<?php
$item = "id";
$valor = $_GET["idCot"];
$cot = ControladorCotizaciones::ctrMostrarCotizaciones($item, $valor);
$itemCliente = "id";
$idCliente = $cot["id_client"] <= 1 ? 0 : $cot["id_client"];

if($idCliente > 1){
  $cliente = ControladorClientes::ctrMostrarClientes($itemCliente, $idCliente);
}else{
  $cliente = ControladorClientes::ctrMostrarClientes($itemCliente, 1);;
}

if($cliente["rut_facturar"] != ''){
  $rutFacturarClienteVentaCot = $cliente["rut_facturar"];
}else{
  $rutFacturarClienteVentaCot = '';
}

if($idCliente > 1){
  $tipoCliente = $cliente['tipo_cliente'] == 'minorista' || $cliente['tipo_cliente'] == '' ? 'minorista' : 'mayorista'; // detecta tipo de cliente
}else{
  $tipoCliente = 'minorista';
}

if($cot['venta']!=''){
  echo '<script>

    Swal.fire({
      icon: "error",
      title: "La cotización ya fue ingresada en la venta nro. '.$cot['venta'].'",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
      }).then(function(result){
      if (result.value) {
        window.location = "crear-venta";
        }
      })
  </script>';

  return;

}

$_SESSION["mostrarUtilidadCot"] = 0; //RESET MOSTRAR UTILIDAD COT
?>

<body onload="atajosGrales(); listarProdVentaCot(); sumarTotalesVentaCot();">
  <div class="content-wrapper">
    <section class="content-header d-none d-lg-block">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-4">
            <h1>
              Venta Cotización
            </h1>
          </div>
          <div class="col-sm-4">
            <h1><?php echo strtoupper($_SESSION['sucursal']);?></h1>
          </div>          
          <div class="col-sm-4">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Inicio</a></li>
              <li class="breadcrumb-item active">Venta Cotización</li>
            </ol>
          </div>
        </div>
      </div>
    </section>
    <div class="row mb-2 d-lg-none"></div>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12 col-lg-5">
            <div class="card card-primary card-outline">
              <form role="form" method="post" class="formularioVentaCot">

                <input type="hidden" class="idVendVentaCot" id="idVendVentaCot" name="idVendVentaCot" value="<?php echo $_SESSION["id"]; ?>">
                <input type="hidden" class="nomVendVentaCot" id="nomVendVentaCot" name="nomVendVentaCot" value="<?php echo $_SESSION["nombre"]; ?>">
                <input type="hidden" id="perfilVend" value="<?php echo $_SESSION["perfil"]; ?>">
                <input type="hidden" class="listaProdsVentaCot col-12" id="listaProdsVentaCot" name="listaProdsVentaCot" value="<?php echo $cot["productos"]; ?>">
                <input type="hidden" id="nomClientVentaCot" name="nomClientVentaCot">
                <input type="hidden" id="detPagoVentaCot" name="detPagoVentaCot">                    
                <input type="hidden" id="fiadoVentaCot" name="fiadoVentaCot">
                <input type="hidden" name="idCot" id="idCot" value="<?php echo $_GET["idCot"]; ?>">
                <input type="hidden" name="totalVentaCot" id="totalVentaCot" value="">
                <input type="hidden" name="tipoClienteVentaCot" id="tipoClienteVentaCot" value="<?php echo $tipoCliente; ?>" required>
                <input type="hidden" name="detalleFleteVentaCot" class="detalleFlete" value="<?php echo $cot["detalle_flete"]; ?>">
                <input type="hidden" class="incluyeFlete">
                <input type="hidden" class="rutFacturarCliente" value="<?php echo $rutFacturarClienteVentaCot;?>">
                <input type="hidden" id="rutFacturaVentaCot" name="rutFacturaVentaCot">

                <div class="card-body">              
                  <div class="row mantener-posicion" style="background-color: white">
                    <h4 class="col-12 text-center d-lg-none">
                      VENTA COTIZACIÓN <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modalVentaCotMovil"><i class="fas fa-plus"></i></button> <!-- PROD DESDE CELULAR -->
                    </h4>

                    <div class="col-6 d-none d-lg-block" style="background-color: white">
                      <h5 class="mb-2">Vendedor</h5>
                      <div class="navbar-brand">
                        <?php
                          if($_SESSION["foto"] != ""){
                            echo '<img class="direct-chat-img" width="30" height="30" src="'.$_SESSION["foto"].'">';
                          }else{
                            echo '<img class="direct-chat-img" width="30" height="30" src="componentes/img/usuarios/default/anonymous.png">';
                          }
                        ?>
                        <div class="mb-2"></div>
                        <span class="info-box-text"><h5>   <?php echo $_SESSION["nombre"] ?></h5></span>
                      </div>
                    </div>                    

                    <div class="col-12 col-lg-6" style="background-color: white">
                      <h5 class="mb-2">Total</h5>
                      <div class="navbar-brand">
                        <img class="direct-chat-img" width="30" height="30" src="componentes/img/sama/dollar75x75.png">
                        <div class="mb-1"></div>
                        <span class="info-box-text"><h4 class="totVentaCotMostrar" id="totVentaCotMostrar" name="totVentaCotMostrar">   0</h4></span>
                      </div>
                    </div>
                  </div>

                  <hr>

                  <h3>PRODUCTOS</h3>
                  <div class="row">
                    <div class="col-12">
                      <div class="form-group row nuevoProductoVentaCot" style="padding:10px">
                        <?php
                        $listaProducto = json_decode($cot["productos"], true);
                        $sucursal = $_SESSION['sucursal'];
                  

                        $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
                        $nombre_y_alias = array();
                        $locales = array();
                              
                        foreach ($sucursales as $key => $value){
                          if($value['nombre_sucursal'] != $sucursal){
                            array_push($nombre_y_alias, $value["nombre_sucursal"]); 
                            array_push($nombre_y_alias, $value["alias_sucursal"]);
                            array_push($locales, $nombre_y_alias);
                          $nombre_y_alias = array(); // vaciamos array
                          }
                        }     
                  

                        foreach ($listaProducto as $key => $value){
                          $item = "id";
                          $valor = $value["id"];
                          $orden = "id";
                          // error_reporting(0);
                          $producto = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);
                          $disabled = 'disabled';






                          $stockOtrosLocales = '';
                          $existenciasOtrosLocales = 0;
                          for ($i_1=0; $i_1 < count($locales); $i_1++){
                            if($producto['stock_'.$locales[$i_1][0]] > 0){
                              $stockOtrosLocales .= strtoupper($locales[$i_1][0])." (".$producto['zona_'.$locales[$i_1][0]].") &rarr; ".number_format($producto['stock_'.$locales[$i_1][0]],0,',','.')."u&#10;"; // EJ. BODEGA1 (C17N5) -> 1000u
                              $existenciasOtrosLocales += $producto['stock_'.$locales[$i_1][0]];
                            } 
                          }

                          if($stockOtrosLocales == ''){
                            $stockOtrasSucursales = '';
                          }else{
                            $stockOtrasSucursales = "<button style='color:white; background-color:purple' class='btn btn-xs info' data-original-title='".$stockOtrosLocales."'>HAY STOCK EN:</button>";
                          }




                          if($producto['stock_'.$sucursal] == 0 && $existenciasOtrosLocales == 0){ // SI NO HAY STOCK
                            $state_stock = '<div><img style="position:absolute; z-index:3; height:60px; padding:5px 60%;" src="componentes/img/extras/sin_stock2.png"></div>';
                            $cant = 0;
                            $borde_color = 'rgb(114,114,114)';
                            $color = 'red';
                            $existencias = '<b class="float-right" style="color:black">Solo hay ('.$producto['stock_'.$sucursal].'/'.$value['cant'].')</b>';
                            $fondoYLetras = 'background-color:rgb(114,114,114); color:white';
                            $disabledCant = 'disabled';
                            $fondoInput = '';
                            $nuevoStock = 0;
                            $stock = $producto['stock_'.$sucursal];

                          }else if($value['cant'] > $producto['stock_'.$sucursal] && $producto["stock_".$sucursal] > 0 && $existenciasOtrosLocales == 0){ // INCOMPLETO
                            $state_stock = '<div><img style="position:absolute; z-index:3; height:60px; padding:5px 60%;" src="componentes/img/extras/incompleto2.png"></div>';
                            $cant = $producto['stock_'.$sucursal];
                            $borde_color = 'rgb(234,117,0)';
                            $color = 'black';
                            $existencias = '<b class="float-right" style="color:black">Solo hay ('.$producto['stock_'.$sucursal].'/'.$value['cant'].')</b>';
                            $fondoYLetras = 'background-color:rgb(234,117,0); color:white';
                            $disabledCant = '';
                            $fondoInput = '';
                            $nuevoStock = $producto["stock_".$sucursal]-$cant;
                            $stock = $producto['stock_'.$sucursal];

                          }else if($producto["stock_".$sucursal] < 0){ // PRODUCTO QUE NO MANEJA STOCK (STOCK NEGATIVO, ARRIENDO, FLETE, ETC)
                            $state_stock = '';
                            $cant = $value['cant'];
                            $borde_color = 'black';
                            $color = 'black';
                            $existencias = '';
                            $fondoYLetras = '';
                            $disabledCant = '';
                            $fondoInput = 'background-color:rgb(238,238,238)';
                            $nuevoStock = $producto["stock_".$sucursal]-$cant;
                            $stock = INF;

                          }else if(($value['cant'] > $producto['stock_'.$sucursal] && $producto["stock_".$sucursal] >= 0) && $existenciasOtrosLocales > 0){ // si hay stock en otras sucursales
                            $state_stock = '';
                            $cant = $producto['stock_'.$sucursal];
                            $borde_color = 'navy';
                            $color = 'navy';
                            $existencias = '<b class="float-right" style="color:black">Solo hay ('.$producto['stock_'.$sucursal].'/'.$value['cant'].')</b>'.$stockOtrasSucursales;
                            // $existencias = '<b class="float-right" style="color:black">Solo hay ('.$producto['stock_'.$sucursal].'/'.$value['cant'].')</b>';
                            $fondoYLetras = '';
                            $disabledCant = '';
                            $fondoInput = 'background-color:black';
                            $nuevoStock = $producto["stock_".$sucursal]-$cant;
                            $stock = $producto['stock_'.$sucursal];
                            // echo $existenciasOtrosLocales;

                          }else{ // SI HAY STOCK
                            $state_stock = '';
                            $cant = $value['cant'];
                            $borde_color = 'black';
                            $color = 'black';
                            $existencias = '';
                            $fondoYLetras = '';
                            $disabledCant = '';
                            $fondoInput = 'background-color:rgb(238,238,238)';
                            $nuevoStock = $producto["stock_".$sucursal]-$cant;
                            $stock = $producto['stock_'.$sucursal];
                            
                          }


                        $descuento = number_format((1-($value['pV']/$producto['precio_venta']))*100,2,',','.'); 




                          echo
                          '<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px; border-color:'.$borde_color.'; color:'.$color.';'.$fondoYLetras.'">
                            <div class="col-12 descripcion" style="padding-left:0px">
                              <div>
                                <div>
                                  <button type="button" class="btn btn-danger btn-xs quitarProdVentCot" idProducto="'.$producto["id"].'">
                                    <i class="fa fa-times"></i>
                                  </button> 
                                  <font size="-1">
                                    <b>'.$producto["zona_".$sucursal].'-'.$producto["sku"].'</b> '.$producto["descripcion"].' <b>('.number_format($producto["precio_venta"],0,',','.').'c/u desde '.$producto["mayor_sobre"].'u '.number_format($producto["precio_mayor"],0,',','.').'c/u)</b> [<i>'.$descuento.'%</i>] <font id="existenciasCot">'.$existencias.'</font>
                                  </font>
                                </div>
                                <input type="hidden" class="form-control prodVentaCot" style="height: 40px" idProducto="'.$value["id"].'" codigoInterno="'.$producto["sku"].'" name="agregarProducto" value="'.$producto["descripcion"].'">
                              </div>
                            </div>
                            <div style="height:25px"></div>

                            <div class="col-3 ingresoCantVentaCot" style="padding-left:0px">
                              <font size="-2">Cantidad</font>
                              <input type="number" class="form-control cantProdVentaCot" style="height: 40px;'.$fondoYLetras.'" name="cantProdVentaCot" id="cantProdVentaCot" min="1" max="'.($stock).'" value="'.$cant.'" stock="'.$stock.'" mayoreo="'.$producto["mayor_sobre"].'" cantCotizado="'.$value['cant'].'" nuevoStock="'.$nuevoStock.'" required '.$disabledCant.'>
                            </div>

                            <div class="col-6 ingresoPrecioVentaCot" style="padding-left:0px">
                                '.$state_stock.'
                                <font size="-2">Total ($)</font>
                              <div class="input-group">
                                <input type="number" style="height: 40px;'.$fondoYLetras.'" class="form-control precioProdVentaCot info" data-original-title="$ '.number_format($value["pV"],0,',','.').'" precioCompra="'.$producto["precio_compra"].'" pCotizado="'.$value["pV"].'" precioReal="'.$producto["precio_venta"].'" precioFinal="'.$producto["precio_compra"].'" precioMayor="'.$producto["precio_mayor"].'" id="precioProdVentaCot" value="'.($value["pV"]*$cant).'" required readonly>
                              </div>
                            </div>

                            <div class="col-3 ingresoDctoVentaCot" style="padding-left:0px">
                              <div>
                                <font size="-2">Descuento</font>
                                <input type="number" style="height: 40px;'.$fondoYLetras.'" min="0" max="'.$producto["descuento"].'" class="form-control dctoProdVentaCot" step="1" value="'.$value['dcto'].'" required '.$disabled.'>
                              </div>
                            </div>
                          </div>
                          <div id="esp'.$producto["id"].'" style="height:3px"></div>';

                        }
                        ?>
                      </div>
                    </div>
                  </div>                      

                  <button type="button" class="btn btn-default d-md-none btnAgregarProductoCot">Agregar producto</button> <!-- BOTÓN PARA AGREGAR PRODUCTO DESDE CELULAR -->
                  
                  <div class="row">  
                   
                    <div class="col-12">
                      <span class="direct-chat-name float-left"><label>Detalles Adicionales</label></span>
                      <div class="input-group">
                        <span class="input-group-append">
                            <img class="direct-chat-img" style="height:60px; width:60px" src="componentes/img/sama/info.png">
                        </span>   
                        <textarea class="form-control detalleVentaCot" id="detalleVentaCot" name="detalleVentaCot" rows="2" value=""></textarea>
                      </div>
                    </div>


                    <div class="col-sm-8">
                      <div class="mb-2"></div>
                      <div class="form-group">
                        <label>Seleccionar Cliente</label>
                        <span class="input-group-addon"><i class="fas fa-users"></i></span> 
                        <select class="form-control select2 selecClientVentaCot" id="selecClientVentaCot" name="selecClientVentaCot" ventana="crearVenta" style="width: 100%;">
                          <?php

                          // SELECCIONA EL CLIENTE ELEGIDO EN LA VENTA ANTES DE EDITAR
                          if($cliente["id"] > 1){
                            $apellidos = explode(" ", $cliente["apellido"]);
                            $nombres = explode(" ", $cliente["nombre"]);
                            $nombre = $nombres[0].' '.$apellidos[0].' ('.$cliente["referencia"].')';
                            echo '<option value="'.$cliente["id"].'">'.strtoupper($nombre).'</option>';
                          }else{
                            echo '<option value="1">-</option>';
                          }

                          // CARGA EL RESTO DE CLIENTES
                          $item = null;
                          $valor = null;
                          $clientes = ControladorClientes::ctrMostrarClientes($item, $valor);
                          for ($i=1; $i < count($clientes); $i++) { 
                            if($clientes[$i]['id']!=$cliente['id'] && $clientes[$i]['tipo_cliente']!='propietario' && $clientes[$i]['estado'] != 0){ // EVITA QUE SE CARGUE 2 VECES EL CLIENTE y QUE SE CARGUEN A PROPIETARIOS EN VENTA COT
                              $apellidos = explode(" ", $clientes[$i]["apellido"]);
                              $nombres = explode(" ", $clientes[$i]["nombre"]);
                              $nombre = $nombres[0].' '.$apellidos[0].' ('.$clientes[$i]["referencia"].')';     
                              if($clientes[$i]['credito_interno']==0 && $clientes[$i]['deuda_cliente']>0){ // CLIENTE BLOQUEADO
                                echo '<option class="btn-danger" value="'.$clientes[$i]["id"].'" style="color:white">'.strtoupper($nombre).'</option>';
                              }else if($clientes[$i]['credito_interno']==1){ // CLIENTE ACTIVO
                                echo '<option class="btn-success" value="'.$clientes[$i]["id"].'" style="color:white">'.strtoupper($nombre).'</option>';
                              }else if($clientes[$i]['credito_interno']==2 && $clientes[$i]['deuda_cliente']>0){ // CLIENTE SUSPENDIDO
                                echo '<option class="btn-warning" value="'.$clientes[$i]["id"].'" style="color:white">'.strtoupper($nombre).'</option>';
                              }else{ // CLIENTE SIN CREDITO ASIGNADO Y SIN DEUDA (CLIENTE NORMAL)
                                echo '<option class="" value="'.$clientes[$i]["id"].'">'.strtoupper($nombre).'</option>';
                              }
                            }
                          }
                          ?>

                        </select>
                      </div>
                    </div>

                    <div class="col-sm-4" style="padding-right:0px">
                      <div class="mb-2"></div>
                      <div class="form-group">
                        <label>Método de Pago</label>
                        <span class="input-group-addon"><i class="fas fa-hand-holding-usd"></i></span> 
                        <select class="form-control metodoPagoVentaCot" id="metodoPagoVentaCot" name="metodoPagoVentaCot" required>
                          <option value="">Método</option>
                          <option value="Efectivo">Efectivo</option>
                          <option value="Transferencia">Transferencia</option>
                          <option value="TC">Tarjeta Crédito</option>
                          <option value="TD">Tarjeta Débito</option>
                          <option value="E_TD">Efectivo + TD</option>
                          <option value="E_TC">Efectivo + TC</option>
                          <?php
                            if($cliente['credito_interno']==1 || $_SESSION['perfil'] == 'Administrador' || ($cliente['credito_interno'] != 1 && $cliente['deuda_cliente'] < 0)){ // PERMITE CREDITO INTERNO SI TIENE CI ACTIVO ó SI ES ADMINISTRADOR ó SIN CI ASIGNADO PERO CON SALDO A FAVOR
                              echo '<option value="Fiado">Crédito Interno</option>';
                            }
                          ?>
                          <option value="Pend">Cobro en Reparto</option>
                        </select>
                      </div>
                    </div>
                  </div>

                  <div class="row cajasMetodoPagoVentaCot" id="cajasMetodoPagoVentaCot"></div>
                  <input type="button" id="ingresarVentaCot" class="btn btn-primary float-right" onclick="boletaOFacturaVentaCot()" value="Registrar Venta">
                </div> 


              </form>

              <?php

                $crearVentaCot = new ControladorVentas();
                $crearVentaCot -> ctrIngresarVentaCot();
                
              ?>
            </div>    
          </div>

          <div class="col-7 d-none d-lg-block">
            <div class="card card-success card-outline">
              <div class="d-none d-lg-block">
                <div class="card-body">
                  <table class="table dt-responsive tablaVentaCotProductos" idCot="<?php echo $_GET["idCot"]; ?>">
                    <thead>
                      <tr>
                        <th style="width: 10px">#</th>
                        <th>Imagen</th>
                        <th>Descripción</th>
                        <?php
                          if($_SESSION['perfil'] == 'Administrador'){
                            echo '<th>$/Venta</th>';
                          }else{
                            echo '<th>$/Único</th>';
                          }
                        ?>
                        <th>Stock</th>
                        <th>Acciones</th>
                      </tr>
                    </thead>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</body>


<!-- AGREGAR PRODUCTO MOVILES  -->

<div class="modal fade" id="modalVentaCotMovil">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="spinerCarga"></div>
      <div class="modal-header bg-success">
        <h4 class="modal-title">Venta Cotización MOVIL</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class='modal-body'>
        <div class='box-body'>
                     
          <div class='col-12'>
            <div class='form-group'>
   
              <span class="input-group-addon"><i class="fas fa-box"></i></span> 
              <label>Seleccionar Producto</label>
              <select class="form-control select2" id="selectProdVentaCotMovil" style="width: 100%;">
                <option value="0" selected="selected">Seleccione Producto</option>
                <?php

                  $detectaFlete = 0;
                  $skuFlete = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'sku_flete')['ajuste'];
                  
                  foreach ($listaProducto as $key => $value){                    
                    $prod = ControladorProductos::ctrMostrarProductos('id', $value['id'], 'id');
                  
                    if($prod['sku'] == $skuFlete){
                      $detectaFlete += 1;
                    }
                    else{
                      $detectaFlete += 0;
                    }

                    $stockDisponible = $prod['stock_'.$sucursal] == 0 ? '(SIN STOCK)' : '(Stock: '.$prod['stock_'.$sucursal].'u)';
                    echo '<option class="red-option" value="'.$prod["id"].'">['.$prod['sku'].'] '.$prod["descripcion"].' '.$stockDisponible.'</option>';
                  }


                  if($detectaFlete == 0){ // incluir flete si es necesario
                    $flete = ControladorProductos::ctrMostrarProducto('sku', $skuFlete);
                    echo '<option class="red-option" value="'.$flete["id"].'">['.$flete['sku'].'] '.$flete["descripcion"].'</option>';                    
                  }

                ?>
              </select>
            </div>        
            <div class="form-group" id="infoProdVentaCotMovil">
              
            </div>

          </div>

        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Salir</button>
          <button type="button" id='agregarProdVentaCotMovil' class="btn btn-success" disabled="disabled">Agregar Producto</button>
        </div>
      </div>
    </div>
  </div>
</div>