<div class="content-wrapper">

  <section class="content-header">
    
    <h1>
      <div class="row">
        <div class="col-xs-5">
          Retiro Productos
        </div>
        <div class="col-xs-7">        
          <span style="width: 10px">
            <div class='btn-group'>
              <button class='btn btn-success' id="programarRetiros" data-toggle="modal" data-target="#modalProgramarRetiros" style="height: 40px">
                Programar Retiro
                <i class="fa fa-star"></i>
              </button>
            </div>

            <div class='btn-group'>
              <button class='btn btn-info' id="retiroProductos" data-toggle="modal" data-target="#modalRetiroProductos" style="height: 40px">
              Retiro Productos
              <i class="fas fa-cart-plus"></i>
            </div>

          </span> 
        </div>
      </div>
    </h1>

    <ol class="breadcrumb">
      
      <li><a href="inicio"><i class="fa fa-dashboard"></i> Inicio</a></li>
      
      <li class="active">Retiro Productos</li>
    
    </ol>

  </section>

  <section class="content">

    <div class="box">

      <div class="box-body">
        
       <table class="table table-bordered table-striped dt-responsive tablaRetiroProductos" width="100%">
         
        <thead>
         
         <tr>

           <th>Fecha</th>
           <th>Cliente</th>
           <th>Responsable</th>
           <th>Producto</th>
           <th>Cantidad a Retirar</th>
           <th>Cantidad Retirada</th>
           <th>Saldo</th>
           <th>Acciones</th>
           
         </tr> 

        </thead>      

       </table>


      </div>

    </div>

  </section>

</div>

<!--=====================================
MODAL PROGRAMAR RETIROS
======================================-->
<div id="modalProgramarRetiros" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="formProgramarRetiros" method="POST">

        <!--=====================================
        CABEZA DEL MODAL
        ======================================-->
        <div class="modal-header" style="background:#3c8dbc; color:white">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Programar Retiro Productos</h4>
        </div>

        <!--=====================================
        CUERPO DEL MODAL
        ======================================-->
        <div class="modal-body">
          <div class="box-body">

            <!--=====================================
            CLIENTE
            ======================================-->
            <div class='col-lg-12 col-xs-12'>
              <div class='form-group'>
                <div class='input-group'>
                  <span class='input-group-addon'><i class='fa fa-list'></i></span> 
                  <select style='font-size:15px' class='form-control input-lg' id='clienteProgramarRetiro' name='clienteProgramarRetiro' required>
                    <option value="0">Seleccione Cliente</option>
                    <?php
                      $item = null;
                      $valor = null;
                      $categorias = ControladorClientes::ctrMostrarClientes($item, $valor);
                      foreach ($categorias as $key => $value) {
                        if($value["referencia"]==""){
                          $finalNombre = "";
                        }else{
                          $finalNombre = " (".$value["referencia"].")";
                        }
                        if($value["id"]!=1){                          
                          echo '<option value="'.$value["id"].'">'.$value["apellido"]." ".$value["nombre"].$finalNombre.'</option>';                        
                        }
                      }
                    ?>
                  </select>
                </div>
              </div>
            </div>

            <!--=====================================
            CANTIDAD
            ======================================-->
            <div class='col-lg-12 col-xs-12'>
              <div class='form-group'>
                <div class="input-group">
                  <span class="input-group-addon" style="height: 40px"><i class="fa fa-stack-overflow"></i></span>
                  <input type="number" class="form-control input-lg" style="height: 40px" min="1" name="cantidadProgramarRetiro" id="cantidadProgramarRetiro" placeholder="Cantidad a Retirar">
                </div>
              </div>
            </div>

            <!--=====================================
            CODIGO PRODUCTO
            ======================================-->
            <div class='col-lg-12 col-xs-12'>
              <div class='form-group'>
                <div class="input-group">
                  <span class="input-group-addon" style="height: 40px"><i class="glyphicon glyphicon-barcode"></i></span>
                  <input type="text" class="form-control input-lg" style="height: 40px" min="1" name="codigoProductoRetiro" id="codigoProductoRetiro" placeholder="Código Interno Producto" maxlength="6" onkeypress="return soloNumeros(event)">
                </div>
              </div>
            </div>

          </div>
        </div>

        <!--=====================================
        PIE DEL MODAL
        ======================================-->
        <div class="modal-footer">
          <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Salir</button>
            <div class='btn-group'><button class='btn btn-warning' id="btnProgramarRetiro" style="height: 40px">Programar Retiro</button></div>
        </div>
      </form>
    </div>
  </div>
</div>

<!--=====================================
MODAL RETIRO PRODUCTOS
======================================-->
<div id='modalRetiroProductos' class='modal fade' role='dialog'>
  <div class='modal-dialog'>
    <div class='modal-content'>
      <form id="formRegistrarRetiro" method="POST">

        <!--=====================================
        CABEZA DEL MODAL
        ======================================-->
        <div class='modal-header' style='background:#3c8dbc; color:white'>
          <button type='button' class='close' data-dismiss='modal'>&times;</button>
          <h4 class='modal-title'>Retiro Productos</h4>
        </div>

        <!--=====================================
        CUERPO DEL MODAL
        ======================================-->
        <div class='modal-body'>
          <div class='box-body'>
            
            <div class='col-lg-12 col-xs-12'>
              <div class='form-group'>
                <div class='input-group'>
                  <span class='input-group-addon'><i class='fa fa-list'></i></span> 
                  <select style='font-size:15px' class='form-control input-lg' id='clienteRetiroProductos' name='clienteRetiroProductos' required>
                    <option value="0">Seleccione Cliente</option>
                    <?php
                      $item = null;
                      $valor = null;
                      $orden = "id";
                      $retiros = ControladorProductos::ctrMostrarRetiroProductos($item, $valor, $orden);
                      
                      foreach ($retiros as $key => $value) {

                        $item = "id";
                        $valor = $value['id_cliente'];
                        $cliente = ControladorClientes::ctrMostrarClientes($item, $valor);

                        $item = "sku";
                        $valor =  $value["cod_producto"];
                        $productosRetirar = ControladorProductos::ctrMostrarProducto($item, $valor);
                        
                        // FILTRA SI EXISTE UN RETIRO PROGRAMADO Y ADEMAS SI QUEDAN PRODUCTOS POR RETIRAR
                        if($value["cantidad"] > 0 && $value["saldo"] > 0){
                        echo '<option value="'.$value["id"].'" codProd="'.$value["cod_producto"].'" cantProd="'.$value["cantidad"].'" idClient="'.$value['id_cliente'].'">'.mb_strtoupper($cliente["nombre"]." ".$cliente["apellido"])." - ".$value["cantidad"]." ".$productosRetirar["descripcion"].'</option>';        

                        }

                      }
                    ?>
                  </select>
                </div>
              </div>
            </div>
            <input type="hidden" name="idClienteRetiroProd" id="idClienteRetiroProd">
            <input type="hidden" name="codigoOrigProductoRetiro" id="codigoOrigProductoRetiro">
            <input type="hidden" name="cantOrigProductoRetiro" id="cantOrigProductoRetiro">
            <!--=====================================
            RESPONSABLE
            ======================================-->
            <div class='col-lg-12 col-xs-12'>
              <div class='form-group'>
                <div class="input-group">
                  <span class="input-group-addon" style="height: 40px"><i class="fa fa-user"></i></span>
                  <input type="text" class="form-control input-lg" style="height: 40px" name="responsableRetiro" id="responsableRetiro" placeholder="Responsable ¿Quién Retira?">
                </div>
              </div>
            </div>
       
            <!--=====================================
            CANTIDAD RETIRADA
            ======================================-->
            <div class='col-lg-12 col-xs-12'>
              <div class='form-group'>
                <div class="input-group">
                  <span class="input-group-addon" style="height: 40px"><i class="fa fa-stack-overflow"></i></span>
                  <input type="number" class="form-control input-lg" style="height: 40px" min="1" name="cantidadRetiro" id="cantidadRetiro" placeholder="Cantidad Retirada">
                </div>
              </div>
            </div>

          </div>
        </div>

        <!--=====================================
        PIE DEL MODAL
        ======================================-->
        <div class='modal-footer'>
          <button type='button' class='btn btn-default pull-left' data-dismiss='modal'>Salir</button>
          <div class='btn-group'><button class='btn btn-warning' id="btnRegistroRetiro" style="height: 40px">Registrar Retiro</button></div>
        </div>
      </form>
    </div>
  </div>
</div>