<?php

// $inicio = microtime(true);

$meses = [
    'Jan' => 'Ene',
    'Apr' => 'Abr',
    'Aug' => 'Ago',
    'Dec' => 'Dic'
];
$mesIngles = date('M');
$mes = $meses[$mesIngles] ?? $mesIngles;



$rol = $_SESSION['perfil'];
$idUsuario = $_SESSION['id'];
$traerVentasMes = ModeloVentas::mdlMostrarVentasMes('ventas', $idUsuario);
$totalVentasMes = ModeloVentas::mdlSumaTotalVentasMes('ventas',$rol, $idUsuario);
$utilidadMes = ModeloVentas::mdlSumaTotalUtilidadesMes('ventas');

$locales = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "local");
$bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");

$totalCapitalLocales = 0;
$totalRetornoInversion = 0;
foreach ($locales as $key => $value) {
  $inversion = ControladorProductos::ctrMostrarInversion('stock_'.$value['nombre_sucursal'], 'precio_compra');
  $totalCapitalLocales += $inversion['inversion'];
  $retornoInversion = ControladorProductos::ctrMostrarInversion('stock_'.$value['nombre_sucursal'], 'precio_venta');
  $totalRetornoInversion += $retornoInversion['inversion'];
}

$totalCapitalBodegas = 0;
// $mostrarCapitalBodegas = '';
foreach ($bodegas as $key => $value) {
  $inversion = ControladorProductos::ctrMostrarInversion('stock_'.$value['nombre_sucursal'], 'precio_compra');
  $totalCapitalBodegas += $inversion['inversion'];
  $retornoInversion = ControladorProductos::ctrMostrarInversion('stock_'.$value['nombre_sucursal'], 'precio_venta');
  $totalRetornoInversion += $retornoInversion['inversion'];
}


// OBTIENE CODIGOS DE VENTAS ASOCIADOS EN COTIZACION (COTIZACION VENDIDA)
$cotsMes = ModeloCotizaciones::mdlMostrarCotizacionesMes('cotizaciones');
$arrayCotsVendidas = [];
foreach ($cotsMes as $key => $value) {
  if($value['venta']!=''){
    array_push($arrayCotsVendidas, $value['venta']);
  }
}

$cotsVendidas = 0;
$totalCotsVendidas = 0;
for ($i=0; $i < count($arrayCotsVendidas); $i++){
  $ventaCot = ControladorVentas::ctrMostrarVentas('cod_venta', $arrayCotsVendidas[$i], '=', '!=', 0, 'fecha_cont', 'DESC');
  if(is_array($ventaCot)){
    $montoVenta = $ventaCot['id'];
    $estadoVenta = $ventaCot['estado'];
    if($estadoVenta != 0){ // se vendio realmente
      $totalCotsVendidas += $montoVenta;
      $cotsVendidas += 1;
    }
  }
}

$porcentajeConversionCotAVenta = count($cotsMes) == 0 ? 0 : number_format((count($arrayCotsVendidas)/count($cotsMes))*100,1,',','.');

$porCobrarTotal = ModeloClientes::mdlCuentasPorCobrar()['total'];

$compromisosMes = ModeloMovimientosBancarios::mdlMostrarCompromisosPagoAtrasadosDashboard('compromisos_pago','id');
$compromisosPagadosMes = ModeloMovimientosBancarios::mdlMostrarCompromisosPagadosMes('compromisos_pago');

$hoy = date('Y-m-d');
$compromisosAtrasados = 0;
$cantCompromisosAtrasados = 0;
$compromisosPorPagarMes = 0;
$cantCompromisosPorPagarMes = 0;
$ultimoDiaMesEnCurso = cal_days_in_month(CAL_GREGORIAN, date('n'), date('Y'));



$hoyUF = ModeloMovimientosBancarios::mdlValorUF($hoy);
if ($hoyUF && is_array($hoyUF)){ // busca si está en DB
  $valorUF = ModeloMovimientosBancarios::mdlValorUF($hoy)['valor'];
}else{ // si no la busca en API REST
  $fechaBuscar = date("d-m-Y", strtotime($hoy));
  $apiUrl = 'https://mindicador.cl/api/uf/'.$fechaBuscar;
  if(ini_get('allow_url_fopen')){
      $json = file_get_contents($apiUrl);
  }else{
      //De otra forma utilizamos cURL
      $curl = curl_init($apiUrl);
      curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
      $json = curl_exec($curl);
      curl_close($curl);
  }
  $dailyIndicators = json_decode($json);
  $valorUFDia = $dailyIndicators->serie[0]->valor;
  $registrarUFHoy = ModeloMovimientosBancarios::mdlRegistrarUFAnterior($hoy, $valorUFDia);
}



foreach ($compromisosMes as $key => $value) {
  
  if($value['fecha_vencimiento'] < $hoy){
    if($value['tipo_compromiso'] != 'hipotecario'){
      $compromisosAtrasados += $value['monto'];
      $cantCompromisosAtrasados += 1;
    }else{
      $valorUF = ModeloMovimientosBancarios::mdlValorUF($value['fecha_vencimiento'])['valor'];
      $compromisosAtrasados += $value['monto']*$valorUF;
      $cantCompromisosAtrasados += 1;
    }
  }else{
    if($value['tipo_compromiso'] != 'hipotecario'){
      $compromisosPorPagarMes += $value['monto'];
      $cantCompromisosPorPagarMes += 1;
    }else{
      // $valorUF = ModeloMovimientosBancarios::mdlValorUF($value['fecha_vencimiento'])['valor'];
      $valorUF = ModeloMovimientosBancarios::mdlValorUF($hoy)['valor'];
      $compromisosPorPagarMes += $value['monto']*$valorUF;
      $cantCompromisosPorPagarMes += 1;
    }
  }
}

$compromisosPagados = 0;
$cantCompromisosPagados = 0;
foreach ($compromisosPagadosMes as $key => $value) {
  $compromisosPagados += $value['monto_pagado'];
  $cantCompromisosPagados += 1;
}



$porcUtil = ($totalVentasMes["total"]-$utilidadMes["total"]) == 0 ? 0 : $utilidadMes["total"]*100/($totalVentasMes["total"]-$utilidadMes["total"]);
$ventProm = count($traerVentasMes)==0 ? 0 : $totalVentasMes["total"]/count($traerVentasMes);



// $fin = microtime(true);
// $tiempo = $fin - $inicio;
// print_r('<br><br><br><br><br>------------------------------------------------------'.$tiempo);
?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-4">
          <h1>
            Resumen
            <small><?php if($_SESSION['perfil']=='Administrador'){echo $mes.'-'.date('Y');}else{echo $_SESSION['nombre'].' <b>'.$mes.'-'.date('Y').'</b>';} ?></small>
          </h1>
        </div>
        <div class="col-sm-4">
          <h1><?php echo strtoupper($_SESSION['sucursal']); ?></h1>
        </div>          
        <div class="col-sm-4">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">Inicio</a></li>
            <li class="breadcrumb-item active">Resumen ventas</li>
          </ol>
        </div>
      </div>
    </div>
  </div>
  <section class="content">
    <div class="container-fluid">
      <?php 
        if($rol == 'Administrador'){
          echo'
          <div class="row">
            <div class="col-12 col-sm-6 col-md-4 col-xl-4">
                <div class="info-box mb-3">
                  <span style="height:100px; width:100px; font-size:50px" class="info-box-icon bg-success elevation-1"><i class="fas fa-shopping-cart"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text" style="font-size:20px">Ventas</span>
                    <span class="info-box-number" style="font-size:30px">$ '.number_format($totalVentasMes["total"],0,',','.').'</span>
                  </div>
                </div>
            </div>

            <div class="col-12 col-sm-6 col-md-4 col-xl-4">
                <div class="info-box">
                  <span style="height:100px; width:100px; font-size:50px" class="info-box-icon bg-info elevation-1"><i class="fas fa-calculator"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text" style="font-size:20px">Cotizaciones</span>
                    <span class="info-box-number" style="font-size:30px">
                      $ '.number_format($totalCotsVendidas,0,',','.').'
                    </span>
                  </div>
                </div>
            </div>

            <div class="col-12 col-sm-6 col-md-4 col-xl-4">
                <div class="info-box mb-3">
                  <span style="height:100px; width:100px; font-size:50px" class="info-box-icon bg-teal elevation-1"><i class="fas fa-boxes"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text" style="font-size:20px">Inventario</span>
                    <span class="info-box-number" style="font-size:30px">
                      $ '.number_format($totalCapitalBodegas+$totalCapitalLocales,0,',','.').'
                    </span>
                  </div>
                </div>
            </div>


            <div class="clearfix hidden-md-up"></div>

            <div class="col-12 col-sm-6 col-md-4 col-xl-4">
                <div class="info-box mb-3">
                  <span style="height:100px; width:100px; font-size:50px" class="info-box-icon bg-warning elevation-1"><i class="fas fa-user-times" style="color:white"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text" style="font-size:20px">Por Cobrar</span>
                    <span class="info-box-number" style="font-size:30px">$ '.number_format($porCobrarTotal,0,',','.').'</span>
                  </div>
                </div>
            </div>

            <div class="col-12 col-sm-6 col-md-4 col-xl-4">
                <div class="info-box mb-3">
                  <span style="height:100px; width:100px; font-size:50px" class="info-box-icon bg-indigo elevation-1"><i class="fas fa-hands-helping"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text" style="font-size:20px">Compromisos</span>
                    <span class="info-box-number" style="font-size:30px">
                        $ '.number_format($compromisosAtrasados+$compromisosPorPagarMes+$compromisosPagados,0,',','.').'
                    </span>
                  </div>
                </div>
            </div>

            <div class="col-12 col-sm-6 col-md-4 col-xl-4">
                <div class="info-box mb-3">
                  <span style="height:100px; width:100px; font-size:50px" class="info-box-icon bg-danger elevation-1"><i class="fas fa-handshake-slash"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text" style="font-size:20px">Atrasado</span>
                    <span class="info-box-number" style="font-size:30px">
                      $ '.number_format($compromisosAtrasados,0,',','.').'
                    </span>
                  </div>
                </div>
            </div>        
          </div>';
              // <a href="analisis-ventas">
              // </a>
              // <a href="analisis-cotizaciones">
              // </a>
              // <a href="analisis-inventario">
              // </a>
              // <a href="analisis-cuentas-por-cobrar">              
              // </a>
              // <a href="analisis-compromisos">  
              // </a>
              // <a href="analisis-compromisos">
              // </a>
        }else if($rol == 'Vendedor'){


          $ventasMesVendedor = ControladorVentas::ctrSumaTotalVentasMes($rol, $idUsuario);
          $traerVentasMesVendedor = ModeloVentas::mdlMostrarVentasMes('ventas', $idUsuario);
          $traerCotsVendedor = ModeloCotizaciones::mdlMostrarCotizacionesMesVendedor();
          // $cantidadVentasMesVendedor = ControladorVentas::ctrMostrarVentasMes();

          echo'
          <div class="row">
            <div class="col-12 col-sm-6 col-md-4">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-success elevation-1"><i class="fas fa-shopping-cart"></i></span>
                <div class="info-box-content">
                  <span class="info-box-text">Ventas</span>
                  <span class="info-box-number">$ '.number_format($ventasMesVendedor["total"],0,',','.').'</span>
                </div>
              </div>
            </div>

            <div class="col-12 col-sm-6 col-md-4">
              <div class="info-box">
                <span class="info-box-icon bg-success elevation-1"><i class="fas fa-shopping-cart"></i></span>
                <div class="info-box-content">
                  <span class="info-box-text">Cantidad Ventas</span>
                  <span class="info-box-number">'
                    .number_format(count($traerVentasMesVendedor),0,',','.').'
                  </span>
                </div>
              </div>
            </div>

            <div class="col-12 col-sm-6 col-md-4">
              <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-calculator"></i></span>
                <div class="info-box-content">
                  <span class="info-box-text">Cotizaciones</span>
                  <span class="info-box-number">'.
                    number_format(count($traerCotsVendedor),0,',','.').'
                  </span>
                </div>
              </div>
            </div>
          </div>';
        }

        function colorAvance($porcentaje){
          if($porcentaje < 33.33){
            $color = 'danger';
          }else if($porcentaje >= 33.33 && $porcentaje < 66.66){
            $color = 'warning';
          }else if($porcentaje >= 66.66 && $porcentaje <= 100){
            $color = 'success';
          }else{
            $color = 'primary';            
          }
          return $color;
        }

        $ventasMesAnterior = ModeloVentas::mdlSeleccionarVentasAnteriores('atras_1_mes');
        $ventasSemestreAnterior = ModeloVentas::mdlSeleccionarVentasAnteriores('atras_6_meses');
        $ventasAnioAnterior = ModeloVentas::mdlSeleccionarVentasAnteriores('atras_12_meses');
        $ventasHace1Anio = ModeloVentas::mdlSeleccionarVentasAnteriores('hace_1_anio');



        $avanceCantVentasMes = count($ventasMesAnterior) == 0 ? 0 : count($traerVentasMes)/count($ventasMesAnterior)*100;
        $avanceCantVentasSemestreAnterior = count($ventasSemestreAnterior) == 0 ? 0 : (count($traerVentasMes)/(count($ventasSemestreAnterior)/6))*100;
        $avanceCantVentasAnioAnterior = count($ventasAnioAnterior) == 0 ? 0 : (count($traerVentasMes)/(count($ventasAnioAnterior)/12))*100;
        $avanceVentasHace1Anio = count($ventasHace1Anio) == 0 ? 0 : count($traerVentasMes)/count($ventasHace1Anio)*100;

        $totalMesAnterior = ModeloVentas::mdlTotalVentasAnteriores('atras_1_mes')[0];
        $totalSemestreAnterior = ModeloVentas::mdlTotalVentasAnteriores('atras_6_meses')[0];
        $totalAnioAnterior = ModeloVentas::mdlTotalVentasAnteriores('atras_12_meses')[0];
        $totalHace1Anio = ModeloVentas::mdlTotalVentasAnteriores('hace_1_anio')[0];


        $avanceTotalVentasMes = $totalMesAnterior == 0 ? 0 : $totalVentasMes["total"]/$totalMesAnterior*100;
        $avanceTotalVentasSemestreAnterior = $totalSemestreAnterior == 0 ? 0 : ($totalVentasMes["total"]/($totalSemestreAnterior/6))*100;
        $avanceTotalVentasAnioAnterior = $totalAnioAnterior == 0 ? 0 : ($totalVentasMes["total"]/($totalAnioAnterior/12))*100;
        $avanceTotalVentasHace1Anio = $totalHace1Anio == 0 ? 0 : $totalVentasMes["total"]/$totalHace1Anio*100;

        // CALCULO VENTAS PROMEDIOS ANTERIORES
        $mesAnterior = date('Y-m', strtotime('-1 month'));
        $diasTrabajados_MesAnterior = count(ModeloVentas::mdlDiasTrabajados($mesAnterior));
        $diasTrabajados_MesEnCurso = count(ModeloVentas::mdlDiasTrabajados(date('Y-m')));

        $cantPromVentas_Diarias_MesAnterior = $diasTrabajados_MesAnterior == 0 ? 0 : count($ventasMesAnterior)/$diasTrabajados_MesAnterior;
        $totalPromVentas_Diarias_MesAnterior = $diasTrabajados_MesAnterior == 0 ? 0 : $totalMesAnterior/$diasTrabajados_MesAnterior;

        $cantPromVentas_Diarias_MesEnCurso = $diasTrabajados_MesEnCurso == 0 ? 0 : count($traerVentasMes)/$diasTrabajados_MesEnCurso;
        $totalPromVentas_Diarias_MesEnCurso = $diasTrabajados_MesEnCurso == 0 ? 0 : $totalVentasMes["total"]/$diasTrabajados_MesEnCurso;

        if($cantPromVentas_Diarias_MesAnterior == 0){
          $porcentajeComparacionCantVentas = '';
          $colorPorcentajeComparacionCantVentas = '';
          $flechaPorcentajeComparacionCantVentas = '';
          $porcentajeComparacionTotalVentas = '';
          $colorPorcentajeComparacionTotalVentas = '';
          $flechaPorcentajeComparacionTotalVentas = '';
        }else if($cantPromVentas_Diarias_MesEnCurso/$cantPromVentas_Diarias_MesAnterior >= 1){        
          $porcentajeComparacionCantVentas = abs(round((1-($cantPromVentas_Diarias_MesEnCurso/$cantPromVentas_Diarias_MesAnterior))*100, 1));
          $colorPorcentajeComparacionCantVentas = 'rgb(255,193,7)';
          $flechaPorcentajeComparacionCantVentas = 'down';
          $porcentajeComparacionTotalVentas = abs(round((1-($totalPromVentas_Diarias_MesEnCurso/$totalPromVentas_Diarias_MesAnterior))*100, 1));
          $colorPorcentajeComparacionTotalVentas = 'cyan';
          $flechaPorcentajeComparacionTotalVentas = 'up';
        }else{
          $porcentajeComparacionCantVentas = round((1-($cantPromVentas_Diarias_MesEnCurso/$cantPromVentas_Diarias_MesAnterior))*100, 1);
          $colorPorcentajeComparacionCantVentas = 'rgb(255,193,7)';
          $flechaPorcentajeComparacionCantVentas = 'down';
          $porcentajeComparacionTotalVentas = round((1-($totalPromVentas_Diarias_MesEnCurso/$totalPromVentas_Diarias_MesAnterior))*100, 1);
          $colorPorcentajeComparacionTotalVentas = 'rgb(255,193,7)';
          $flechaPorcentajeComparacionTotalVentas = 'down';
        }

      ?>

      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-body">
              <div class="row">


                <?php

                  // GRAFICO VENTAS
                  if($_SESSION['perfil'] == 'Administrador'){
                    echo'  
                    <div class="col-12 col-md-8">
                      <p class="text-center">
                        Ventas: 1 '.$mes.' - '.date('d').' '.$mes.'  &rarr; <b>$ '.number_format($totalVentasMes["total"],0,',','.').'</b> en <b>'.number_format(count($traerVentasMes),0,',','.').'</b> Ventas
                      </p>
                      <div>
                        <div class="box-body border-radius-none">
                          <div id="line-chart-inicio"></div>
                        </div>';

                          error_reporting(0);
                          $rol = $_SESSION['perfil'];
                          $idUsuario = $_SESSION['id'];
                          $nombreUsuario = $_SESSION['nombre'];


                          if(isset($_GET["fechaInicial"])){

                              $fechaInicial = $_GET["fechaInicial"];
                              $fechaFinal = $_GET["fechaFinal"];

                          }else{

                          $fechaInicial = date('Y-m').'-01';
                          $fechaFinal = date('Y-m-d');

                          }

                          $ventasMesEnCurso = ControladorVentas::ctrRangoFechasVentas($fechaInicial, $fechaFinal, $rol, $idUsuario);

                          $arrayFechas = array();
                          $arrayVentas = array();
                          $arrayUtilidades = array();
                          $sumaVentasMes = array();
                          $sumaUtilidadesMes = array();


                          foreach ($ventasMesEnCurso as $key => $value) {

                            #Capturamos sólo el año y el mes
                            $fecha = $value["fecha_cont"];
                            #Introducir las fechas en arrayFechas
                            array_push($arrayFechas, $fecha);
                            #Capturamos las ventas
                            $arrayVentas = array($fecha => $value["total"]);
                            $arrayUtilidades = array($fecha => $value["utilidad_total"]);

                            #Sumamos los pagos que ocurrieron el mismo mes
                            foreach ($arrayVentas as $key => $value) {
                                $sumaVentasMes[$key] += $value;
                            }

                            foreach ($arrayUtilidades as $key => $value) {
                                $sumaUtilidadesMes[$key] += $value;
                            }

                          }


                          $noRepetirFechas = array_unique($arrayFechas);

                          echo'
                          <script>


                          var line = new Morris.Line({
                              element          : "line-chart-inicio",
                              resize           : true,
                              grid             : false,
                              xLabels          : "day",
                              axes             : true,
                              data             : [';

                              

                              if($noRepetirFechas != null){

                                  foreach($noRepetirFechas as $key){

                                   echo "{ y: '".$key."', Ventas: ".$sumaVentasMes[$key].", Util: ".$sumaUtilidadesMes[$key].", Prom: ".round($totalPromVentas_Diarias_MesAnterior,0)." },";


                                  }

                                  echo "{y: '".$key."', Ventas: ".$sumaVentasMes[$key].", Util: ".$sumaUtilidadesMes[$key].", Prom: ".round($totalPromVentas_Diarias_MesAnterior,0)." }";

                              }else{

                                 echo "{ y: '0', Ventas: '0' }";

                              }

                              echo'
                              ],
                              xkey             : "y",
                              ykeys: ["Ventas","Util","Prom"],
                              labels: ["Venta","Utilidad","Prom Ant"],
                              lineColors: ["white","cyan","goldenrod"],
                              // goals: [50000, 200000],
                              lineWidth        : [0.5,0,1],
                              hideHover        : "auto",
                              gridTextColor    : "white",
                              gridStrokeWidth  : 0.4,
                              pointSize        : [1,0,0],
                              pointStrokeColors: ["white","cyan","goldenrod"],
                              gridLineColor    : "#ffffff",
                              gridTextFamily   : "Open Sans",
                              preUnits         : "$",
                              gridTextSize     : 10
                            });    
                          </script>
                      </div>
                    </div>';
                  }else if($_SESSION['perfil'] == 'Vendedor'){
                    echo'  
                    <div class="col-12 col-md-8">
                      <p class="text-center">
                        Ventas: 1 '.$mes.' - '.date('d').' '.$mes.'  &rarr; <b>$ '.number_format($totalVentasMes["total"],0,',','.').'</b> en <b>'.number_format(count($traerVentasMes),0,',','.').'</b> Ventas
                      </p>
                      <div>
                        <div class="box-body border-radius-none">
                          <div id="line-chart-inicio-vendedor"></div>
                        </div>';

                          error_reporting(0);
                          $rol = $_SESSION['perfil'];
                          $idUsuario = $_SESSION['id'];
                          $nombreUsuario = $_SESSION['nombre'];


                          if(isset($_GET["fechaInicial"])){

                              $fechaInicial = $_GET["fechaInicial"];
                              $fechaFinal = $_GET["fechaFinal"];

                          }else{

                          $fechaInicial = date('Y-m').'-01';
                          $fechaFinal = date('Y-m-d');

                          }

                          $ventasMesEnCurso = ControladorVentas::ctrRangoFechasVentas($fechaInicial, $fechaFinal, $rol, $idUsuario);

                          $arrayFechas = array();
                          $arrayVentas = array();
                          $arrayUtilidades = array();
                          $sumaVentasMes = array();
                          $sumaUtilidadesMes = array();


                          foreach ($ventasMesEnCurso as $key => $value) {

                            #Capturamos sólo el año y el mes
                            $fecha = $value["fecha_cont"];
                            #Introducir las fechas en arrayFechas
                            array_push($arrayFechas, $fecha);
                            #Capturamos las ventas
                            $arrayVentas = array($fecha => $value["total"]);
                            $arrayUtilidades = array($fecha => $value["utilidad_total"]);

                            #Sumamos los pagos que ocurrieron el mismo mes
                            foreach ($arrayVentas as $key => $value) {
                                $sumaVentasMes[$key] += $value;
                            }

                            foreach ($arrayUtilidades as $key => $value) {
                                $sumaUtilidadesMes[$key] += $value;
                            }

                          }


                          $noRepetirFechas = array_unique($arrayFechas);
                          echo'
                          <script>


                          var line = new Morris.Line({
                              element          : "line-chart-inicio-vendedor",
                              resize           : true,
                              grid             : false,
                              xLabels          : "day",
                              axes             : true,
                              data             : [';

                              

                              if($noRepetirFechas != null){

                                  foreach($noRepetirFechas as $key){

                                   echo "{ y: '".$key."', Ventas: ".$sumaVentasMes[$key]."},";


                                  }

                                  echo "{y: '".$key."', Ventas: ".$sumaVentasMes[$key]."}";

                              }else{

                                 echo "{ y: '0', Ventas: '0' }";

                              }

                              echo'
                              ],
                              xkey             : "y",
                              ykeys: ["Ventas"],
                              labels: ["Venta"],
                              lineColors: "chartreuse",
                              lineWidth        : 1,
                              hideHover        : "auto",
                              gridTextColor    : "green",
                              gridStrokeWidth  : 0.4,
                              pointSize        : 2,
                              gridLineColor    : "#ffffff",
                              gridTextFamily   : "Open Sans",
                              preUnits         : "$",
                              gridTextSize     : 10
                            });    
                          </script>
                      </div>
                    </div>';
                  }

                  // COMPARATIVA

                  if($_SESSION['perfil'] == 'Administrador'){

                    echo'
                    <div class="row col-12 col-md-4">

                      <div class="col-12">
                        <p class="text-center">
                          <b>Comparativa</b>
                        </p>
                      </div>
                      <div class="col-12 col-xl-6">
                        <div class="progress-group">
                          <b>Nro. Ventas</b><br>
                          Mes Anterior
                          <span class="float-right"><b>'.number_format(count($traerVentasMes),0,',','.').'</b>/'.number_format(count($ventasMesAnterior),0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.colorAvance($avanceCantVentasMes).'" style="width: '.$avanceCantVentasMes.'%"></div>
                          </div>
                        </div>

                        <div class="progress-group">
                          <span class="progress-text">Promedio Semestre</span>
                          <span class="float-right"><b>'.number_format(count($traerVentasMes),0,',','.').'</b>/'.number_format(count($ventasSemestreAnterior)/6,0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.colorAvance($avanceCantVentasSemestreAnterior).'" style="width: '.$avanceCantVentasSemestreAnterior.'%"></div>
                          </div>
                        </div>

                        <div class="progress-group d-none d-lg-block">
                          <span class="progress-text">Promedio 12 Meses</span>
                          <span class="float-right"><b>'.number_format(count($traerVentasMes),0,',','.').'</b>/'.number_format(count($ventasAnioAnterior)/12,0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.colorAvance($avanceCantVentasAnioAnterior).'" style="width: '.$avanceCantVentasAnioAnterior.'%"></div>
                          </div>
                        </div>

                        <div class="progress-group d-none d-lg-block">
                          '.$mes.' '.date('Y',strtotime('-1 year')).'
                          <span class="float-right"><b>'.number_format(count($traerVentasMes),0,',','.').'</b>/'.number_format(count($ventasHace1Anio),0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.colorAvance($avanceVentasHace1Anio).'" style="width: '.$avanceVentasHace1Anio.'%"></div>
                          </div>
                        </div>
                      </div>

                      <div class="col-12 col-xl-6">
                        <div class="progress-group d-none d-lg-block">
                          <b>Ventas ($)</b><br> 
                          <span class="float-right"><b>'.number_format($totalVentasMes["total"],0,',','.').'</b>/'.number_format($totalMesAnterior,0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.colorAvance($avanceTotalVentasMes).'" style="width: '.$avanceTotalVentasMes.'%"></div>
                          </div>
                        </div>

                        <div class="progress-group d-lg-none">
                          <b>Ventas ($)</b><br>
                          Mes Anterior
                          <span class="float-right"><b>'.number_format($totalVentasMes["total"]/1000000,2,',','.').'M</b>/'.number_format($totalMesAnterior/1000000,2,',','.').'M</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.colorAvance($avanceTotalVentasMes).'" style="width: '.$avanceTotalVentasMes.'%"></div>
                          </div>
                        </div>

                        <div class="progress-group d-none d-lg-block"> 
                          <span class="float-right"><b>'.number_format($totalVentasMes["total"],0,',','.').'</b>/'.number_format($totalSemestreAnterior/6,0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.colorAvance($avanceTotalVentasSemestreAnterior).'" style="width: '.$avanceTotalVentasSemestreAnterior.'%"></div>
                          </div>
                        </div>

                        <div class="progress-group d-lg-none">
                          Prom. 6 meses
                          <span class="float-right"><b>'.number_format($totalVentasMes["total"]/1000000,2,',','.').'M</b>/'.number_format($totalSemestreAnterior/6/1000000,2,',','.').'M</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.colorAvance($avanceTotalVentasSemestreAnterior).'" style="width: '.$avanceTotalVentasSemestreAnterior.'%"></div>
                          </div>
                        </div>

                        <div class="progress-group d-none d-lg-block">
                           <span class="float-right"><b>'.number_format($totalVentasMes["total"],0,',','.').'</b>/'.number_format($totalAnioAnterior/12,0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.colorAvance($avanceTotalVentasAnioAnterior).'" style="width: '.$avanceTotalVentasAnioAnterior.'%"></div>
                          </div>
                        </div>

                        <div class="progress-group d-none d-lg-block">
                           <span class="float-right"><b>'.number_format($totalVentasMes["total"],0,',','.').'</b>/'.number_format($totalHace1Anio,0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.colorAvance($avanceTotalVentasHace1Anio).'" style="width: '.$avanceTotalVentasHace1Anio.'%"></div>
                          </div>
                        </div>
                      </div>';





                      $porcentajeCot_VS_Ventas_Cantidad = count($traerVentasMes) == 0 ? 0 : round($cotsVendidas/count($traerVentasMes)*100,1);
                      $porcentajeCot_VS_Ventas_Monto = $totalVentasMes["total"] == 0 ? 0 : round($totalCotsVendidas/$totalVentasMes["total"]*100,1);
                      $porcentajeConversion = count($cotsMes) == 0 ? 0 : round($cotsVendidas/count($cotsMes)*100,1);
                      if($porcentajeConversion < 33.33){
                        $colorPorcentajeConversion = 'danger';
                      }else if($porcentajeConversion >= 33.33 && $porcentajeConversion < 66.66){
                        $colorPorcentajeConversion = 'warning';
                      }else{
                        $colorPorcentajeConversion = 'success';
                      }



                      echo'
                      <div class="col-12">
                        <p class="text-center">
                          <br><b class="d-none d-lg-block">Cotizaciones Concretadas Mes En Curso</b><b class="d-lg-none">Cotizaciones</b>
                        </p>
                      </div>

                      <div class="col-12 col-xl-4 d-none d-lg-block">

                        <div class="progress-group">
                          Nro Ventas<br> 
                          <span class="float-right"><b>'.$cotsVendidas.'</b>/'.number_format(count($traerVentasMes),0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-success" style="width: '.$porcentajeCot_VS_Ventas_Cantidad.'%"></div>
                          </div>
                          '.$porcentajeCot_VS_Ventas_Cantidad.'%
                        </div>
                      </div>

                      <div class="col-12 col-xl-4 d-lg-none">
                        <div class="progress-group">
                          Ventas ($)
                          <span class="float-right"><b>'.number_format($totalCotsVendidas,0,',','.').'</b>/'.number_format($totalVentasMes["total"],0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-success" style="width: '.$porcentajeCot_VS_Ventas_Monto.'%"></div>
                          </div>
                          '.$porcentajeCot_VS_Ventas_Monto.'%
                        </div>
                      </div>

                      <div class="col-12 col-xl-4 d-none d-lg-block">
                        <div class="progress-group">
                          Ventas ($)<br> 
                          <span class="float-right"><b>'.number_format($totalCotsVendidas,0,',','.').'</b>/'.number_format($totalVentasMes["total"],0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-success" style="width: '.$porcentajeCot_VS_Ventas_Monto.'%"></div>
                          </div>
                          '.$porcentajeCot_VS_Ventas_Monto.'%
                        </div>
                      </div>

                      <div class="col-12 col-xl-4 d-lg-none">
                        <div class="progress-group">
                          Conversión
                          <span class="float-right"><b>'.number_format($cotsVendidas,0,',','.').'</b>/'.number_format(count($cotsMes),0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.$colorPorcentajeConversion.'" style="width: '.$porcentajeConversion.'%"></div>
                          </div>
                          '.$porcentajeConversion.'%
                        </div>
                      </div>
                      <div class="col-12 col-xl-4 d-none d-lg-block">
                        <div class="progress-group">
                          Conversión a Venta<br> 
                          <span class="float-right"><b>'.number_format($cotsVendidas,0,',','.').'</b>/'.number_format(count($cotsMes),0,',','.').'</span>
                          <div class="progress progress-sm">
                            <div class="progress-bar bg-'.$colorPorcentajeConversion.'" style="width: '.$porcentajeConversion.'%"></div>
                          </div>
                          '.$porcentajeConversion.'%
                        </div>
                      </div>
                    </div>';
                  
                  }else if($_SESSION['perfil'] == 'Vendedor'){

                    $totalVentasMesGeneral = ModeloVentas::mdlSumaTotalVentasMes('ventas','Administrador', $idUsuario);
                    $restoVentas = $totalVentasMesGeneral["total"]-$ventasMesVendedor["total"];
                    // var_dump($restoVentas);
                    $porcentajeVentasVendedor = round($ventasMesVendedor["total"]/($ventasMesVendedor["total"]+$restoVentas)*100,1);
                    $porcentajeRestante = round(100-$porcentajeVentasVendedor,1);

                    echo'
                    <div class="row col-12 col-md-4">
                      <div class="box-body border-radius-none">
                        <div id="donuts-ventas-proporcionales-vendedor"></div>
                      </div>

                      <script>
                        Morris.Donut({
                          element: "donuts-ventas-proporcionales-vendedor",
                          resize: true,
                          labelColor:"black", // text color
                          backgroundColor: "#ccc", // border color
                          data: [
                            {label:"'.number_format($ventasMesVendedor["total"],0,',','.').'", value:'.$porcentajeVentasVendedor.', color:"green"},
                            {label:"'.number_format($restoVentas,0,',','.').'", value:'.$porcentajeRestante.', color:"gray"}
                          ],
                          formatter: function (x) { return x + "%"}
                        });
                      </script>
                    </div>';

                  }

                ?>
              </div>
            </div>

            <?php
              if($_SESSION['perfil'] == 'Administrador'){

                echo'
                <section class="content d-none d-xl-block">
                  <div class="container-fluid">
                    <div class="row">
                      <div class="col-12">
                        <div class="card collapsed-card">
                          <div class="card-header">
                            <h3 class="card-title">Detalles</h3>

                            <div class="card-tools">
                              <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-plus"></i>
                              </button>
                            </div>
                          </div>
                          <div class="card-body">
                            <div class="row">

                              <div class="col-sm-3">
                                <div class="description-block border-right">
                                  <span class="description-percentage text-success"> </span>
                                  <h5 class="description-header">$ '.number_format($totalVentasMes["total"],0,',','.').'</h5>
                                  <span class="description-text">TOTAL VENTAS</span>
                                </div>
                              </div>

                              <div class="col-sm-3">
                                <div class="description-block border-right">
                                  <span class="description-percentage text-warning"> </span>
                                  <h5 class="description-header">$ '.number_format($totalVentasMes["total"]-$utilidadMes["total"],0,',','.').'</h5>
                                  <span class="description-text">TOTAL CAPITAL</span>
                                </div>
                              </div>

                              <div class="col-sm-2">
                                <div class="description-block border-right">
                                  <span class="description-percentage" style="color: cyan"><i class="fas fa-caret-up"></i> '.number_format($porcUtil,1,',','.').'%</span>
                                  <h5 class="description-header">$ '.number_format($utilidadMes["total"],0,',','.').'</h5>
                                  <span class="description-text">UTILIDAD</span>
                                </div>
                              </div>

                              <div class="col-sm-2">
                                <div class="description-block border-right">
                                  <span class="description-percentage" style="color: '.$colorPorcentajeComparacionCantVentas.'"><i class="fas fa-caret-'.$flechaPorcentajeComparacionCantVentas.'"></i> '.$porcentajeComparacionCantVentas.'%</span>
                                  <h5 class="description-header">'.number_format($cantPromVentas_Diarias_MesEnCurso,1,',','.').'</h5>
                                  <span class="description-text">CANT. VENTAS DIARIAS (PROM)</span>
                                </div>
                              </div>

                              <div class="col-sm-2">
                                <div class="description-block">
                                  <span class="description-percentage" style="color: '.$colorPorcentajeComparacionTotalVentas.'"><i class="fas fa-caret-'.$flechaPorcentajeComparacionTotalVentas.'"></i> '.$porcentajeComparacionTotalVentas.'%</span>
                                  <h5 class="description-header">$ '.number_format($totalPromVentas_Diarias_MesEnCurso,0,',','.').'</h5>
                                  <span class="description-text">VENTAS DIARIAS (PROM)</span>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </section>';

                echo'
                <section class="content d-xl-none">
                  <div class="container-fluid">
                    <div class="row">
                      <div class="col-12">
                        <div class="card collapsed-card">
                          <div class="card-header">
                            <h3 class="card-title">Detalles</h3>

                            <div class="card-tools">
                              <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-plus"></i>
                              </button>
                            </div>
                          </div>
                          <div class="card-body">
                            <div class="row">

                              <div class="col-6">
                                <div class="description-block">
                                  <h5 class="description-header">TOTAL VENTAS</h5>
                                  <h5 class="description-header">TOTAL CAPITAL</h5>
                                  <h5 class="description-header">UTILIDAD</h5>
                                  <h5 class="description-header">CANT. VENTAS DIARIAS (PROM)</h5>
                                  <h5 class="description-header">VENTAS DIARIAS (PROM)</h5>
                                </div>
                              </div>

                              <div class="col-4">
                                <div class="description-block">
                                  <h5 class="description-header">$ '.number_format($totalVentasMes["total"],0,',','.').'</h5>
                                  <h5 class="description-header">$ '.number_format($totalVentasMes["total"]-$utilidadMes["total"],0,',','.').'</h5>
                                  <h5 class="description-header">$ '.number_format($utilidadMes["total"],0,',','.').'</h5>
                                  <h5 class="description-header">'.number_format($cantPromVentas_Diarias_MesEnCurso,1,',','.').'</h5>
                                  <h5 class="description-header">$ '.number_format($totalPromVentas_Diarias_MesEnCurso,0,',','.').'</h5>
                                </div>
                              </div>

                              <div class="col-2">
                                <div class="description-block">
                                  <h5 class="description-header"> </h5>
                                  <h5 class="description-header"> </h5>
                                  <h5 class="description-header" style="color: cyan"><i class="fas fa-caret-up"></i> '.number_format($porcUtil,1,',','.').'%</h5>
                                  <h5 class="description-header" style="color: '.$colorPorcentajeComparacionCantVentas.'"><i class="fas fa-caret-'.$flechaPorcentajeComparacionCantVentas.'"></i> '.$porcentajeComparacionCantVentas.'%</h5>
                                  <h5 class="description-header" style="color: '.$colorPorcentajeComparacionTotalVentas.'"><i class="fas fa-caret-'.$flechaPorcentajeComparacionTotalVentas.'"></i> '.$porcentajeComparacionTotalVentas.'%</h5>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </section>';

              }
            ?>

          </div>
        </div>
      </div>


      <?php

      if($_SESSION['perfil'] == 'Administrador'){
        $deudores = ModeloClientes::mdlDeudores();
        $totalAdeudado_Deudores_CI_Bloqueado = 0;
        $totalAdeudado_Deudores_CI_Suspendido = 0;
        $totalAdeudado_Deudores_CI_Activo = 0;
        $totalAdeudado_Deudores_Propietarios = 0;
        foreach ($deudores as $key => $value) {
          if($value['tipo_cliente'] != 'Propietario'){
            if($value['credito_interno'] == 0){ // ci bloqueado
              $totalAdeudado_Deudores_CI_Bloqueado += $value['deuda_cliente'];
            }else if($value['credito_interno'] == 2){ // ci suspendido
              $totalAdeudado_Deudores_CI_Suspendido += $value['deuda_cliente'];
            }else if($value['credito_interno'] == 1){ // ci activo
              $totalAdeudado_Deudores_CI_Activo += $value['deuda_cliente'];
            }
          }else{
            $totalAdeudado_Deudores_Propietarios += $value['deuda_cliente'];
          }
        }
        
        $deudaTotalDeudodres = ModeloClientes::mdlCuentasPorCobrar()['total'];
        $porcentajePropietarios = round($totalAdeudado_Deudores_Propietarios/$deudaTotalDeudodres*100,1);
        $porcentajeSuspendidos = round($totalAdeudado_Deudores_CI_Suspendido/$deudaTotalDeudodres*100,1);
        $porcentajeActivos = round($totalAdeudado_Deudores_CI_Activo/$deudaTotalDeudodres*100,1);
        // $porcentajeBloqueados = round($totalAdeudado_Deudores_CI_Bloqueado/$deudaTotalDeudodres*100,1);
        $porcentajeBloqueados = 100-($porcentajePropietarios+$porcentajeSuspendidos+$porcentajeActivos);

        echo'
        <div class="row">
          <div class="col-12 col-lg-6 col-xl-4">
            <div class="card">
              <div class="card-body">
                <div class="row">

                  <div class="col-12">
                    <p class="text-center">
                      <b>DEUDORES</b>
                    </p>
                  </div>
                  <div class="col-8">
                    <div class="box-body border-radius-none">
                      <div id="donuts-deudores" style="height:250px"></div>
                    </div>';
                    
                      $labelBloqueados = $totalAdeudado_Deudores_CI_Bloqueado == 0 ? '' : '{label:"'.number_format($totalAdeudado_Deudores_CI_Bloqueado,0,',','.').'", value:'.$porcentajeBloqueados.', color:"orangered"},';
                      $labelSupendidos = $totalAdeudado_Deudores_CI_Suspendido == 0 ? '' : '{label:"'.number_format($totalAdeudado_Deudores_CI_Suspendido,0,',','.').'", value:'.$porcentajeSuspendidos.', color:"gold"},';
                      $labelActivos = $totalAdeudado_Deudores_CI_Activo == 0 ? '' : '{label:"'.number_format($totalAdeudado_Deudores_CI_Activo,0,',','.').'", value:'.$porcentajeActivos.', color:"chartreuse"},';
                      $labelPropietarios = $totalAdeudado_Deudores_Propietarios == 0 ? '' : '{label:"'.number_format($totalAdeudado_Deudores_Propietarios,0,',','.').'", value:'.$porcentajePropietarios.', color:"cyan"},';

                      echo'
                      <script>
                        Morris.Donut({
                          element: "donuts-deudores",
                          resize: true,
                          labelColor:"white", // text color
                          backgroundColor: "#ccc", // border color
                          data: ['.
                            $labelBloqueados.
                            $labelSupendidos.
                            $labelActivos.
                            $labelPropietarios.
                          '],
                          formatter: function (x) { return x + "%"}
                        });
                      </script>';
                  
                  echo'  
                  </div>';
                  
                    $indicacionBloquados = $totalAdeudado_Deudores_CI_Bloqueado == 0 ? '' : '<li><i class="far fa-circle" style="color:orangered"></i>  CI Bloqueado</li>';
                    $indicacionSupendidos = $totalAdeudado_Deudores_CI_Suspendido == 0 ? '' : '<li><i class="far fa-circle" style="color:gold"></i>  CI Suspendido</li>';
                    $indicacionActivos = $totalAdeudado_Deudores_CI_Activo == 0 ? '' : '<li><i class="far fa-circle" style="color:chartreuse"></i>  CI Activo</li>';
                    $indicacionPropietarios = $totalAdeudado_Deudores_Propietarios == 0 ? '' : '<li><i class="far fa-circle" style="color:cyan"></i>  Propietarios</li>';
                    echo '
                      <div class="col-4">
                        <br><br><br>
                        <ul class="chart-legend clearfix">'.
                          $indicacionBloquados.
                          $indicacionSupendidos.
                          $indicacionActivos.
                          $indicacionPropietarios.'
                        </ul>
                      </div>';
                  
                echo'
                </div>
              </div>
              <div class="card-footer p-0">
                <ul class="nav nav-pills flex-column">

                  <li class="nav-item">
                    <font style="display: block; padding: 0.5rem 1rem;">
                      <b>CLIENTE
                      <span class="float-right">
                      DEUDA</span></b>
                    </font>
                  </li>
                  <li class="nav-item">
                    <a href="extensiones/tcpdf/pdf/historial-cliente-resumen-moroso.php?id='.$deudores[0]['id'].'" target="_blank" class="nav-link">
                      '.$deudores[0]['nombre'].' '.$deudores[0]['apellido'].'
                      <span class="float-right" style="color:orangered">
                      '.number_format($deudores[0]['deuda_cliente'],0,',','.').'</span>
                    </a>
                  </li>
                  <li class="nav-item">
                    <a href="extensiones/tcpdf/pdf/historial-cliente-resumen-moroso.php?id='.$deudores[1]['id'].'" target="_blank" class="nav-link">
                      '.$deudores[1]['nombre'].' '.$deudores[1]['apellido'].'
                      <span class="float-right" style="color:orangered">
                      '.number_format($deudores[1]['deuda_cliente'],0,',','.').'</span>
                    </a>
                  </li>
                  <li class="nav-item">
                    <a href="extensiones/tcpdf/pdf/historial-cliente-resumen-moroso.php?id='.$deudores[2]['id'].'" target="_blank" class="nav-link">
                      '.$deudores[2]['nombre'].' '.$deudores[2]['apellido'].'
                      <span class="float-right" style="color:orangered">
                      '.number_format($deudores[2]['deuda_cliente'],0,',','.').'</span>
                    </a>
                  </li>
                  <li class="nav-item">
                    <a href="cobranza-morosos" target="_blank" class="nav-link float-right">
                        Más info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>';

          echo'
          <div class="col-12 col-lg-6 col-xl-4">
            <div class="card">
              <div class="card-body">
                <div class="row">
                  <div class="col-12">
                    <p class="text-center">
                      <b>COMPROMISOS</b>
                    </p>
                  </div>
                  <div class="col-8">
                    <div class="box-body border-radius-none">
                      <div id="donuts-compromisos" style="height:250px"></div>
                    </div>';
                      
                      $porcentajePorPagarMes = $compromisosPorPagarMes == 0 ? '' : round($compromisosPorPagarMes / ($compromisosAtrasados+$compromisosPorPagarMes+$compromisosPagados)*100,1);
                      $porcentajePagado = $compromisosPagados == 0 ? '' : round($compromisosPagados / ($compromisosAtrasados+$compromisosPorPagarMes+$compromisosPagados)*100,1);
                      // $porcentajeAtrasados = $compromisosAtrasados == 0 ? '' : round($compromisosAtrasados / ($compromisosAtrasados+$compromisosPorPagarMes+$compromisosPagados)*100,1);
                      $porcentajeAtrasados = $compromisosAtrasados == 0 ? '' : 100-($porcentajePorPagarMes+$porcentajePagado);

                      $labelAtrasados = $compromisosAtrasados == 0 ? '' : '{label:"'.number_format($compromisosAtrasados,0,',','.').'", value:'.$porcentajeAtrasados.', color:"orangered"},';
                      $labelPorPagar = $compromisosPorPagarMes == 0 ? '' : '{label:"'.number_format($compromisosPorPagarMes,0,',','.').'", value:'.$porcentajePorPagarMes.', color:"chartreuse"},';
                      $labelPagados = $compromisosPagados == 0 ? '' : '{label:"'.number_format($compromisosPagados,0,',','.').'", value:'.$porcentajePagado.', color:"cornflowerblue"},';

                      echo'
                      <script>
                        Morris.Donut({
                          element: "donuts-compromisos",
                          resize: true,
                          labelColor:"white", // text color
                          backgroundColor: "#ccc", // border color
                          data: ['.
                            $labelAtrasados.
                            $labelPorPagar.
                            $labelPagados.
                          '],
                          formatter: function (x) { return x + "%"}
                        });
                      </script>';
                    
                  echo'  
                  </div>';
                  



                    $indicacionAtrasados = $compromisosAtrasados == 0 ? '' : '<li><i class="far fa-circle" style="color:orangered"></i>  Atrasados <small>('.number_format($cantCompromisosAtrasados,0,',','.').')</small></li>';
                    $indicacionPorPagar = $compromisosPorPagarMes == 0 ? '' : '<li><i class="far fa-circle" style="color:chartreuse"></i>  Por Pagar <small>('.number_format($cantCompromisosPorPagarMes,0,',','.').')</small></li>';
                    $indicacionPagados = $compromisosPagados == 0 ? '' : '<li><i class="far fa-circle" style="color:cornflowerblue"></i>  Pagados <small>('.number_format($cantCompromisosPagados,0,',','.').')</small></li>';
                    echo '
                      <div class="col-4">
                        <br><br><br>
                        <ul class="chart-legend clearfix">'.
                          $indicacionAtrasados.
                          $indicacionPorPagar.
                          $indicacionPagados.'
                        </ul>
                      </div>';
                  

                echo'
                </div>
              </div>
              <div class="card-footer p-0">
                <div class="row">

                  <div class="col-6">
                    <ul class="nav nav-pills flex-column">

                      <li class="nav-item">
                        <font style="display: block; padding: 0.5rem 1rem;">
                          <b>ATRASADOS</b>
                        </font>
                      </li>';

                        $compromisosMes = ModeloMovimientosBancarios::mdlMostrarCompromisosPagoAtrasadosDashboard('compromisos_pago','fecha_vencimiento');
                        // $compromisosPago = ControladorMovimientosBancarios::ctrMostrarCompromisosPago('fecha_vencimiento', null)                    
                        for ($i=0; $i < 3; $i++) { 
                          if($compromisosMes[$i]['fecha_vencimiento'] < $hoy){                        
                            if($compromisosMes[$i]['tipo_compromiso'] == 'cheque'){
                              $tipoDeudaMostrar = 'Cheque <b><i>'.strtoupper($compromisosMes[$i]['se_paga_desde']).'</i></b> ('.ucfirst($compromisosMes[$i]['acreedor']).')';
                            }else if($compromisosMes[$i]['tipo_compromiso'] == 'arriendo'){
                              $tipoDeudaMostrar = 'ARRIENDO';
                            }else if($compromisosMes[$i]['tipo_compromiso'] == 'tc'){
                              $tcPropietario = explode('_',$compromisosMes[$i]['acreedor']);
                              $tipoDeudaMostrar = 'TARJETA CREDITO '.strtoupper($tcPropietario[1]);
                            }else if($compromisosMes[$i]['tipo_compromiso'] == 'consumo'){
                              $bancoAcreedor = explode('_',$compromisosMes[$i]['acreedor'])[$i];
                              $tipoDeudaMostrar = 'CONSUMO '.strtoupper($bancoAcreedor).' <b>['.$compromisosMes[$i]['nro_cuota'].']</b>';
                            }else if($compromisosMes[$i]['tipo_compromiso'] == 'compra_activo'){
                              $tipoDeudaMostrar = 'COMPRA ACTIVO';
                            }else if($compromisosMes[$i]['tipo_compromiso'] == 'hipotecario'){
                              $tipoDeudaMostrar = 'HIPOTECARIO ';
                            }
                          }
                          echo
                            '<li class="nav-item">
                              <font style="display: block; padding: 0.5rem 1rem;">
                                <small>'.date("d/m/y", strtotime($compromisosMes[$i]['fecha_vencimiento'])).' <b>'.$tipoDeudaMostrar.'</b>
                                <span class="float-right" style="color:orangered">
                                $ '.number_format($compromisosMes[$i]["monto"],0,',','.').'</span></small>
                              </font>
                            </li>';
                        }
                    
                    echo'
                    </ul>
                  </div>';

                  echo'
                  <div class="col-6">
                    <ul class="nav nav-pills flex-column">

                      <li class="nav-item">
                        <font style="display: block; padding: 0.5rem 1rem;">
                          <b>POR PAGAR</b>
                        </font>
                      </li>';

                        $clave = 0;
                        foreach ($compromisosMes as $key => $value){
                          if($value['fecha_vencimiento'] >= $hoy && $clave < 3){
                            if($value['tipo_compromiso'] == 'cheque'){
                              $tipoDeudaMostrar = 'Cheque <b><i>'.strtoupper($value['se_paga_desde']).'</i></b> ('.ucfirst($value['acreedor']).')';
                            }else if($value['tipo_compromiso'] == 'arriendo'){
                              $tipoDeudaMostrar = 'ARRIENDO';
                            }else if($value['tipo_compromiso'] == 'tc'){
                              $tcPropietario = explode('_',$value['acreedor']);
                              $tipoDeudaMostrar = 'TARJETA CREDITO '.strtoupper($tcPropietario[1]);
                            }else if($value['tipo_compromiso'] == 'consumo'){
                              $bancoAcreedor = explode('_',$value['acreedor'])[$i];
                              $tipoDeudaMostrar = 'CONSUMO '.strtoupper($bancoAcreedor).' <b>['.$value['nro_cuota'].']</b>';
                            }else if($value['tipo_compromiso'] == 'compra_activo'){
                              $tipoDeudaMostrar = 'COMPRA ACTIVO';
                            }else if($value['tipo_compromiso'] == 'hipotecario'){
                              $tipoDeudaMostrar = 'HIPOTECARIO ';
                            }
                            echo
                            '<li class="nav-item">
                              <font style="display: block; padding: 0.5rem 1rem;">
                                <small>'.date("d/m/y", strtotime($value['fecha_vencimiento'])).' <b>'.$tipoDeudaMostrar.'</b>
                                <span class="float-right" style="color:chartreuse">
                                $ '.number_format($value["monto"],0,',','.').'</span></small>
                              </font>
                            </li>';
                            $clave += 1;
                          }
                        }

                    echo' 
                    </ul>
                  </div>';

                  echo'
                  <div class="col-12">
                    <ul class="nav nav-pills flex-column">
                      <li class="nav-item"></li>
                      <li class="nav-item">
                        <a href="compromisos-pago-movil" target="_blank" class="nav-link float-right d-lg-none">
                            Más info <i class="fa fa-arrow-circle-right"></i>
                        </a>
                        <a href="compromisos-pago" target="_blank" class="nav-link float-right d-none d-lg-block">
                            Más info <i class="fa fa-arrow-circle-right"></i>
                        </a>
                      </li>
                    </ul>
                  </div>

                </div>
              </div>
            </div>
          </div>';

          echo'
          <div class="col-12 col-lg-6 col-xl-4">
            <div class="card">
              <div class="card-body">
                <div class="row">

                  <div class="col-12">
                    <p class="text-center">
                      <b>INVENTARIO</b>
                    </p>
                  </div>

                  <div class="col-12">
                    <div>
                      <div class="box-body border-radius-none">
                        <div id="line-chart-inventario" style="height: 250px"></div>
                      </div>';

                        date_default_timezone_set("America/Santiago");
                        $fechaInicial = date('Y-m-d', strtotime('-3 month'));
                        $saldosCierreDia = ModeloMovimientos::mdlMostrarSaldos('movimientos',$fechaInicial);
                        $invetarioAlCierre = [];
                        $fechasCierre = [];
                        foreach ($saldosCierreDia as $key => $value) {
                          $datosCierre = json_decode($value['detalle']);
                          array_push($invetarioAlCierre, $datosCierre[0]->bodega);
                          array_push($fechasCierre, $value['fecha_cont']);
                        }
                        $limInfStock = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'lim_inf_inventario')['ajuste'];
                        $limSupStock = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'lim_sup_inventario')['ajuste'];
                        
                        echo'
                        <script>


                        var line = new Morris.Line({
                            element          : "line-chart-inventario",
                            resize           : true,
                            grid             : false,
                            xLabels          : "day",
                            axes             : true,
                            data             : [';

                            for ($i=0; $i < count($fechasCierre); $i++) { 
                              echo "{ y: '".$fechasCierre[$i]."', Ventas: ".$invetarioAlCierre[$i]."},";
                            }
                            
                            echo' 
                            ],
                            xkey             : "y",
                            ykeys: ["Ventas"],
                            labels: ["Venta"],
                            lineColors: ["white"],
                            goals: ['.$limInfStock.', '.$limSupStock.'],
                            lineWidth        : 0.5,
                            hideHover        : "auto",
                            gridTextColor    : "white",
                            gridStrokeWidth  : 0.4,
                            pointSize        : 1,
                            pointStrokeColors: ["white"],
                            gridLineColor    : "#ffffff",
                            gridTextFamily   : "Open Sans",
                            preUnits         : "$",
                            gridTextSize     : 10
                          });    
                        </script>';
                      
                    echo'
                    </div>
                  </div>
                </div>
              </div>';

              echo'
              <div class="card-footer p-0">
                <div class="row">';

                  $locales = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "local");
                  $bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");

                  $encabezadoLocales = count($locales) == 1 ? 'LOCAL' : 'LOCALES';
                  $encabezadoBodegas = count($bodegas) == 1 ? 'BODEGA' : 'BODEGAS';


                  $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null , null);

                  $totalMonetarioPerdidaLocales = 0;
                  $totalMonetarioPerdidaBodegas = 0;

                  $totalAgotadosLocales = 0;
                  $totalAgotadosBodegas = 0;

                  $totalProdsBajoStockLocales = 0;
                  $totalProdsBajoStockBodegas = 0;

                  foreach ($sucursales as $key => $value){
                    if($value['tipo_sucursal'] == 'local'){
                      $totalMonetarioPerdidaLocales += ModeloActividadInventario::mdlSumarPerdidasMes(date('Y-m'),$value['nombre_sucursal'])['total'];
                      $totalAgotadosLocales += ModeloProductos::mdlProductosAgotados($value['nombre_sucursal'])['total'];
                      $totalProdsBajoStockLocales += ModeloProductos::mdlProductosBajoStock($value['nombre_sucursal'])['total'];
                    }else if($value['tipo_sucursal'] == 'bodega'){
                      $totalMonetarioPerdidaBodegas += ModeloActividadInventario::mdlSumarPerdidasMes(date('Y-m'),$value['nombre_sucursal'])['total'];
                      $totalAgotadosBodegas += ModeloProductos::mdlProductosAgotados($value['nombre_sucursal'])['total'];
                      $totalProdsBajoStockBodegas += ModeloProductos::mdlProductosBajoStock($value['nombre_sucursal'])['total'];
                    }
                  }

                  $perdidaLocales = $totalMonetarioPerdidaLocales < 0 ? '<small> Perdida Stock <span class="float-right" style="color:orangered">- $ <b>'.number_format($totalMonetarioPerdidaLocales,0,',','.').'</b></span></small>' : '<small> Ganancia Stock <span class="float-right" style="color:chartreuse">+ $ <b>'.number_format($totalMonetarioPerdidaLocales,0,',','.').'</b></span></small>';
                  $perdidaBodegas = $totalMonetarioPerdidaBodegas < 0 ? '<small> Perdida Stock  <span class="float-right" style="color:orangered">- $ <b>'.number_format($totalMonetarioPerdidaBodegas,0,',','.').'</b></span></small>' : '<small> Ganancia Stock <span class="float-right" style="color:chartreuse">+ $ <b>'.number_format($totalMonetarioPerdidaBodegas,0,',','.').'</b></span></small>';

                  echo'
                  <div class="col-6">
                    <ul class="nav nav-pills flex-column">
                      <li class="nav-item">
                        <font style="display: block; padding: 0.5rem 1rem;">
                          <b>'.$encabezadoLocales.'</b>
                        </font>
                      </li>
                      <li class="nav-item">
                        <font style="display: block; padding: 0.5rem 1rem;">
                          '.$perdidaLocales.'
                        </font>
                      </li>
                      <li class="nav-item">
                        <font style="display: block; padding: 0.5rem 1rem;">
                          <small>Productos Agotados
                            <span class="float-right" style="color:orangered">
                              '.number_format($totalAgotadosLocales,0,',','.').'
                            </span>
                          </small>
                        </font>
                      </li>
                      <li class="nav-item">
                        <font style="display: block; padding: 0.5rem 1rem;">
                          <small>Productos Stock Bajo
                            <span class="float-right" style="color:orangered">
                              '.number_format($totalProdsBajoStockLocales,0,',','.').'
                            </span>
                          </small>
                        </font>
                      </li>
                    </ul>
                  </div>

                  <div class="col-6">
                    <ul class="nav nav-pills flex-column">
                      <li class="nav-item">
                        <font style="display: block; padding: 0.5rem 1rem;">
                          <b>'.$encabezadoBodegas.'</b>
                        </font>
                      </li>
                      <li class="nav-item">
                        <font style="display: block; padding: 0.5rem 1rem;">
                          '.$perdidaBodegas.'
                        </font>
                      </li>
                      <li class="nav-item">
                        <font style="display: block; padding: 0.5rem 1rem;">
                          <small>Productos Agotados
                            <span class="float-right" style="color:orangered">
                              '.number_format($totalAgotadosBodegas,0,',','.').'
                            </span>
                          </small>
                        </font>
                      </li>
                      <li class="nav-item">
                        <font style="display: block; padding: 0.5rem 1rem;">
                          <small>Productos Stock Bajo
                            <span class="float-right" style="color:orangered">
                              '.number_format($totalProdsBajoStockBodegas,0,',','.').'
                            </span>
                          </small>
                        </font>
                      </li>
                    </ul>
                  </div>


                  <div class="col-12">
                    <ul class="nav nav-pills flex-column">
                      <li class="nav-item"></li>
                      <li class="nav-item">
                        <a href="analisis-inventario" target="_blank" class="nav-link float-right">
                            Más info <i class="fa fa-arrow-circle-right"></i>
                        </a>
                      </li>
                    </ul>
                  </div>

                </div>
              </div>
            </div>
          </div>

        </div>';
      }
      ?>
    </div>
  </section>
</div>

