<?php
  $diaEvaluado = isset($_GET['fecha']) ? $_GET['fecha'] : date('Y-m-d');
  if($diaEvaluado > date('Y-m-d')){
    echo '<script>
      Swal.fire({
        type: "info",
        title: "Es un día futuro, no se puede cerrar",
        showConfirmButton: true,
        confirmButtonText: "Cerrar"
        }).then(function(result){
        if(result.value){
          window.location = "cerrar-dia";
        }
      })
    </script>';
    return;
  }

  $diaCerrado = ControladorMovimientos::ctrMovSi2LI('fecha_cont', $diaEvaluado, 'tipo_mov', 'saldo');
  $mostrarItem = count($diaCerrado) != 0 ? 'd-none' : '';
  $usuarioCierre = count($diaCerrado) != 0 ? 'Día cerrado por <b>'. strtoupper($diaCerrado[0]['nom_user']) .'</b>' : '';
  $disabled = count($diaCerrado) != 0 ? 'disabled' : '';
  // $idCierre = isset($diaCerrado[0]['id']);


  if( count($diaCerrado) != 0){

      echo '<script>
              Swal.fire({
                type: "info",
                title: "El día ya ha sido cerrado",
                showConfirmButton: true,
                confirmButtonText: "Cerrar"
                }).then(function(result){
              })
            </script>';
    
      $detallesCierre = json_decode($diaCerrado[0]['detalle'],true);
      if(isset($detallesCierre[0]['efectivo_cierre'])){
      
        $monto20000 = $detallesCierre[0]['efectivo_cierre']['20k'] == '' ? 0 : $detallesCierre[0]['efectivo_cierre']['20k'];
        $monto10000 = $detallesCierre[0]['efectivo_cierre']['10k'] == '' ? 0 : $detallesCierre[0]['efectivo_cierre']['10k'];
        $monto5000 = $detallesCierre[0]['efectivo_cierre']['5k'] == '' ? 0 : $detallesCierre[0]['efectivo_cierre']['5k'];
        $monto2000 = $detallesCierre[0]['efectivo_cierre']['2k'] == '' ? 0 : $detallesCierre[0]['efectivo_cierre']['2k'];
        $monto1000 = $detallesCierre[0]['efectivo_cierre']['1k'] == '' ? 0 : $detallesCierre[0]['efectivo_cierre']['1k'];
        $monto500 = $detallesCierre[0]['efectivo_cierre']['500'] == '' ? 0 : $detallesCierre[0]['efectivo_cierre']['500'];
        $monto100 = $detallesCierre[0]['efectivo_cierre']['100'] == '' ? 0 : $detallesCierre[0]['efectivo_cierre']['100'];
        $monto50 = $detallesCierre[0]['efectivo_cierre']['50'] == '' ? 0 : $detallesCierre[0]['efectivo_cierre']['50'];
        $monto10 = $detallesCierre[0]['efectivo_cierre']['10'] == '' ? 0 : $detallesCierre[0]['efectivo_cierre']['10'];

        $totalCierre =  count($diaCerrado) != 0 ? number_format(($monto20000+$monto10000+$monto5000+$monto2000+$monto1000+$monto500+$monto100+$monto50+$monto10),0,',','.') : 0;

        $cuadrar20000 = number_format($monto20000,0,',','.');
        $cuadrar10000 = number_format($monto10000,0,',','.');
        $cuadrar5000 = number_format($monto5000,0,',','.');
        $cuadrar2000 = number_format($monto2000,0,',','.');
        $cuadrar1000 = number_format($monto1000,0,',','.');
        $cuadrar500 = number_format($monto500,0,',','.');
        $cuadrar100 = number_format($monto100,0,',','.');
        $cuadrar50 = number_format($monto50,0,',','.');
        $cuadrar10 = number_format($monto10,0,',','.');

      }else{

        $cuadrar20000 = 'Sin Datos';
        $cuadrar10000 = 'Sin Datos';
        $cuadrar5000 = 'Sin Datos';
        $cuadrar2000 = 'Sin Datos';
        $cuadrar1000 = 'Sin Datos';
        $cuadrar500 = 'Sin Datos';
        $cuadrar100 = 'Sin Datos';
        $cuadrar50 = 'Sin Datos';
        $cuadrar10 = 'Sin Datos';      
        $totalCierre = number_format($diaCerrado[0]['saldo'],0,',','.');

      }
  }else{

    $cuadrar20000 = 0;
    $cuadrar10000 = 0;
    $cuadrar5000 = 0;
    $cuadrar2000 = 0;
    $cuadrar1000 = 0;
    $cuadrar500 = 0;
    $cuadrar100 = 0;
    $cuadrar50 = 0;
    $cuadrar10 = 0;
    $totalCierre = 0;

  }

?>
<body onload="atajosGrales()">
  <div class="content-wrapper">
    <section class="content-header d-none d-lg-block">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-3">
            <h1>
              Cerrar Día
                <?php 
                $fecha = isset($_GET['fecha']) ? $_GET['fecha'] : date('Y-m-d');
                if(date('M', strtotime($fecha)) =='Jan'){
                  $mesTitulo = 'Ene';
                }else if(date('M', strtotime($fecha))=='Apr'){
                  $mesTitulo = 'Abr';            
                }else if(date('M', strtotime($fecha))=='Aug'){
                  $mesTitulo = 'Ago';            
                }else if(date('M', strtotime($fecha))=='Dec'){
                  $mesTitulo = 'Dic';            
                }else{
                  $mesTitulo = date('M', strtotime($fecha));
                }
                echo date('d', strtotime($fecha)).'-'.$mesTitulo.'-'.date('Y', strtotime($fecha)); 
              ?>
            </h1>
          </div>
          <div class="col-sm-3">
            <h1><?php echo strtoupper($_SESSION['sucursal']);?></h1>
          </div>
          <div class="col-sm-3">
            <div class="input-group">
              <span>
                <input type="date" class="form-control" maxlength="10" onkeypress="return soloFecha(event)" id="fechaCierre" value="<?php echo $fecha?>" required="">
              </span>
            </div>
          </div>

          <div class="col-sm-3">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Inicio</a></li>
              <li class="breadcrumb-item active">Cierre Día</li>
            </ol>
          </div>
        </div>
      </div>
    </section>
    <div class="row mb-2 d-lg-none"></div>

    <?php

      // error_reporting(0);
      date_default_timezone_set("America/Santiago");
      $rol = 'Administrador';

      if(isset($_GET["fechaInicial"])){
        $fechaInicial = $_GET["fechaInicial"];
        $fechaFinal = $_GET["fechaFinal"];
      }else{
        $fechaInicial = date('Y-m').'-01';
        $fechaFinal = date('Y-m-d');
      }
      $ventasPeriodo = ControladorVentas::ctrRangoFechasVentas($fechaInicial, $fechaFinal, $rol, $_SESSION['id']);


      // Array temporal para almacenar los totales agrupados por fecha
      $totales_por_fecha = [];
      $utilidades_por_fecha = [];
      $cantidad_ventas_por_fecha = [];

      foreach ($ventasPeriodo as $venta) {
        if (isset($venta['fecha_cont']) && isset($venta['total'])) {
          $fecha = $venta['fecha_cont'];
          $total = $venta['total'];
          $utilidad =  $venta['utilidad_total'];
          
          if (isset($totales_por_fecha[$fecha])) {
              $totales_por_fecha[$fecha] += $total;
          } else {
              $totales_por_fecha[$fecha] = $total;
          }

          if (isset($utilidades_por_fecha[$fecha])) {
              $utilidades_por_fecha[$fecha] += $utilidad;
          } else {
              $utilidades_por_fecha[$fecha] = $utilidad;
          }

          if (isset($cantidad_ventas_por_fecha[$fecha])) {
              $cantidad_ventas_por_fecha[$fecha] += 1;
          } else {
              $cantidad_ventas_por_fecha[$fecha] = 1;
          }

        }
      }

      $totales_diarios = [];

      foreach ($totales_por_fecha as $fecha => $total) {
          $totales_diarios[] = [
              'fecha_cont' => $fecha,
              'total' => $total,
              'utilidad' => $utilidades_por_fecha[$fecha],
              'cant_ventas' => $cantidad_ventas_por_fecha[$fecha]
          ];
      }

      /*#######################################
                  GRAFICO VENTAS
      #######################################*/
      $diasMes = cal_days_in_month(CAL_GREGORIAN, date("m"), date("Y"));
      $diasMesAnt = cal_days_in_month(CAL_GREGORIAN, date("m", strtotime('-1 month')), date("Y"));
      $meses = array("Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic");
      $mesAnt = date('Y-m', strtotime('-1 month'));
      $nroMes = date('m', strtotime('-1 month')) == 12 ? 11 : date('m', strtotime('-1 month'));
      $nombreMes = $meses[(int)$nroMes];

      $ventasMesAnt = ModeloVentas::mdlSumaYCantColVentasMes($mesAnt, 'total');
      $promVentasMesAnt = round($ventasMesAnt['suma']/$diasMesAnt);
      $promVentasMesAntFormat = "$ ". number_format(round($ventasMesAnt['suma']/$diasMesAnt),0);
      $promCantVentasMesAnt = ceil($ventasMesAnt['cant']/$diasMesAnt);


      if(!empty($totales_diarios)){

        echo '

        <script>

        window.onload = function () {
          function atajosGrales(){
            document.onkeydown = function() {
              switch (event.keyCode) {
                case 114:
                  $("div.dataTables_filter input").select();
                break;
                case 121:
                  $("#cerrarDia").click();
                break;

                default:
                  return true;
                  break;
              }
              event.keyCode = 0;
              event.returnValue = false;
              event.cancelBubble = true;
              return false;
            }
            document.onhelp = function() {
              alert("F1");
              return false;
            }
          }
          atajosGrales();

          var chart = new CanvasJS.Chart("grafVentasMesMostrar",{
            animationEnabled: false,
            theme: "light2",
            title:{
              text: "Ventas Mes"
            },
            axisX:{        
              title: "Días",
              suffix: " '.$nombreMes.'",
              // includeZero: false,
            },
            axisY: {
              title: "Monto Venta",
              gridColor: "white",
              valueFormatString:  "#,##0",
              prefix: "$",
              stripLines: [{
                value: '.$promVentasMesAnt.',
                color: "green",
                label: "Prom. '.$meses[intval($nroMes)].' ('.str_replace(',', '.', $promVentasMesAntFormat).')",
                labelFontColor: "green"
              }],
              crosshair: {
                enabled: true
              }
            },
            toolTip:{
              shared:true
            },  
            legend:{
              cursor:"pointer",
              verticalAlign: "bottom",
              horizontalAlign: "left",
              dockInsidePlotArea: true,
              itemclick: toogleDataSeries
            },
            data: [{
              type: "line",
              lineColor: "grey",
              lineThickness: 1,
              markerType: "circle",
              // markerSize: 6,
              dataPoints: [';


              $max = max(array_column($totales_diarios, 'total'));
              $min = min(array_column($totales_diarios, 'total'));

              foreach ($totales_diarios as $key => $value) {              
                if($value['total'] >= $promVentasMesAnt){ // VENTA DEL DIA MAYOR A PROM ANTERIOR
                  if($value['total'] == $max){ // DETECTA MAXIMO
                    echo "{ label: ".($key+1).", y: ".$value['total'].", indexLabel: '$".number_format($value['total'],0,',','.')."', indexLabelFontColor: 'green', markerColor: 'green', markerType: 'triangle', markerSize: 6},";
                  }else{ // LOS DEMAS
                    echo "{ label: ".($key+1).", y: ".$value['total'].",markerColor: 'grey', markerType: 'triangle', markerSize: 10, markerColor: 'green'},";
                  }
                }else{ // VENTA DEL DIA MENOR A PROM ANTERIOR
                  if($value['total'] == $min){ // DETECTA MAXIMO
                    echo "{ label: ".($key+1).", y: ".$value['total'].", indexLabel: '$".number_format($value['total'],0,',','.')."', indexLabelFontColor: 'red', markerColor: 'red', markerType: 'cross', markerSize: 6},";
                  }else{ // LOS DEMAS
                    echo "{ label: ".($key+1).", y: ".$value['total'].",markerColor: 'grey', markerType: 'cross', markerSize: 10, markerColor: 'purple'},";
                  }            
                }
              }

              for ($i=0; $i <= $diasMes ; $i++) { 
                echo "{ x: ".$i."},";
              }  

              echo']
            }]
          });

          chart.render();
          function toogleDataSeries(e){
            if (typeof(e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
              e.dataSeries.visible = false;
            } else{
              e.dataSeries.visible = true;
            }
            chart.render();
          }
          var canvas = $(".canvasjs-chart-canvas").get(0);
          $("#grafVentas").text(canvas.toDataURL("image/jpeg", 1.0));
        }
        </script>';
      }


      // BUSCAMOS CANTIDAD DE VENTAS EN FECHA INDICADA EN ARRAY TOTALES_DIARIOS
      $fechaBuscada = isset($_GET['fecha']) ? $_GET['fecha'] : date('Y-m-d');
      $cantVentasDia = 0;
      $montoVendido = 0;

      foreach ($totales_diarios as $registro) {
        if ($registro['fecha_cont'] == $fechaBuscada) {
          $cantVentasDia = $registro['cant_ventas'];
          $montoVendido = $registro['total'];
          break;
        }
      }

      $cantVentasDiaMostrar = $cantVentasDia == 1 ? '1 venta' : $cantVentasDia.' ventas';

      $ventas_dia = ModeloVentas::mdlMostrarVentasFecha($fechaBuscada); 

      $cantVentasPend = 0;
      foreach ($ventas_dia as $key => $value) {
        if($value['tipo_pago'] == 'Pend'){
          $cantVentasPend += 1;
        }
      }

      $ventasEf = 0;
      $ventasTransf = 0;
      $ventasTD = 0;
      $ventasTC = 0;
      $ventasCI = 0;
      $ventasPend = 0;
      foreach ($ventas_dia as $key => $value) {
        if($value['tipo_pago'] == 'Efectivo'){
          $ventasEf += $value['total'];
        }else if($value['tipo_pago'] == 'Transferencia'){
          $ventasTransf += $value['total'];
        }else if($value['tipo_pago'] == 'TD'){
          $ventasTD += $value['total'];
        }else if($value['tipo_pago'] == 'TC'){
          $ventasTC += $value['total'];
        }else if($value['tipo_pago'] == 'E_TD'){

          $met_pago = json_decode($value["metodo_pago"], true);
          if (is_array($met_pago) && count($met_pago) > 0) {
            $ventasEf += $met_pago[0]['cash'];
            $ventasTD += $met_pago[0]['tarjeta'];
          }

        }else if($value['tipo_pago'] == 'E_TC'){

          $met_pago = json_decode($value["metodo_pago"], true);
          if (is_array($met_pago) && count($met_pago) > 0) {
            $ventasEf += $met_pago[0]['cash'];
            $ventasTC += $met_pago[0]['tarjeta'];
          }

        }else if($value['tipo_pago'] == 'Fiado'){
          $ventasCI += $value['total'];        
        }else if($value['tipo_pago'] == 'Pend'){
          $ventasPend += $value['total'];        
        }
      }

      $orden = 'id';
      $ventana = 'cierre-dia';
      $movs = ControladorMovimientos::ctrMostrarMovimientos('fecha_cont', $fechaBuscada, $orden, $ventana);  
      
      $movsTransbank = ModeloCierre::mdlMovsDiaTransbank($fechaBuscada);
      $movsTransf = ModeloCierre::mdlMovsDiaTransf($fechaBuscada);

      $movimientosDia = ModeloMovimientos::mdlMovimientosDia('movimientos', 'fecha_cont', $fechaBuscada);  

      $abonosEf = 0;
      $cargosEf = 0;
      $retirosCf = 0;
      $aportesCaja = 0;

      foreach ($movimientosDia as $key => $value) {
        if(($diaEvaluado < date('Y-m-d') && isset($diaCerrado[0]['id']) && $value['id'] < $diaCerrado[0]['id']) || $diaEvaluado == date('Y-m-d')){ // SUMA MOVS SOLO SI SON ANTERIORES AL CIERRE ó SI SE ESTA CERRANDO EL DIA DE HOY
          if($value['moneda'] == 'ef' && $value['abono']!=0 && $value['tipo_mov'] != 'apCaja' && $value['tipo_mov'] != 'efVent'){
              $abonosEf += $value['abono'];
          }
          if($value['moneda'] == 'ef' && $value['cargo']!=0){
              $cargosEf += $value['cargo'];
          }
          if($value['tipo_mov'] == 'retCfGde'){
              $retirosCf += $value['cargo'];
          }
          if($value['tipo_mov'] == 'apCaja'){
              $aportesCaja += $value['abono'];
          }
        }
      }

      if(isset($_GET['fecha'])){
        $saldoAnterior =  ModeloMovimientos::mdlSaldoAnterior('movimientos','tipo_mov', 'saldo','fecha_cont', $fechaBuscada, 'fecha_cont')['saldo'];
      }else{
        if(isset($diaCerrado[0]['id'])){ // si ya se cerró el día
          $diaAnterior = (new DateTime($diaCerrado[0]['fecha_cont']))->format('Y-m-d');
          $saldoAnterior =  ModeloMovimientos::mdlSaldoAnterior('movimientos','tipo_mov', 'saldo','fecha_cont', $diaAnterior, 'fecha_cont')['saldo'];
        }else{ // si se va a cerrar dia
          $saldoAnterior = ControladorMovimientos::ctrUltimoItem('tipo_mov', 'saldo', 'id')['saldo'];
        }
      }

    ?>

    <section class="content">
      <div class="d-none" id="grafVentasMesMostrar" style="height: 370px; max-width: 920px; margin: 0px auto; "></div>
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-6">
                    <h4 class="col-12 text-center d-lg-none"><?php echo 'Cierre '.date('d').'-'.$mesTitulo.'-'.date('Y'); ?></h4>

            <?php
            echo' 
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Movimientos en Efectivo</h3>
              </div>
              <div class="card-body row">
                <div class="card-body p-0">
                  <table class="table table-sin-bordes table-sm table-hover">
                    <thead>
                      <tr>
                        <th style="width:10%">Hora</th>
                        <th>Movimiento</th>
                        <th style="width:12%" class="text-primary">Abono</th>
                        <th style="width:12%" class="text-danger">Cargo</th>
                      </tr>
                    </thead>
                    <tbody>';

                        $conteo = 0;
                        foreach ($movs as $key => $value) {


                          $bg = (isset($diaCerrado[0]['id']) && $value['id'] > $diaCerrado[0]['id']) ? 'bg-secondary' : ''; // destaca si se ingresó después del cierre
                          
                          $traducir = ControladorMovimientos::ctrTraducirMovimiento($value['id'],$value['cargo'],$value['abono'],$value['tipo_mov'],$value['moneda'],$value['detalle'],$value['nom_client'],$value['saldo'],$value['saldo_ant'],$value['nom_prov'],$value['nro_fact'],$value['nom_empleado'],$value['nom_socio'],$value['nom_distrib']);
                          $movTraducido = explode(',', $traducir);
                          $hora = substr(explode(' ',$value['fecha'])[1],0,-3);
                          $detalle = ' <i>'.strtoupper(substr(explode(' ',$value["nom_user"])[0],0,1)).'. '.ucfirst(explode(' ',$value["nom_user"])[1]).'</i> - '.$movTraducido[0].' <b>(ID:'.$value['id'].')</b>';
                          $monto = $movTraducido[6] == 0 ? number_format($movTraducido[7], 0, ',', '.') : number_format($movTraducido[6], 0, ',', '.');

                          if($value['abono']!=0 && $value['moneda']=='ef' && ($value['tipo_mov']!='saldo' && $value['tipo_mov']!='efVent')){ // abonos
                            echo'
                              <tr class="text-primary '.$bg.'">
                                <td>'.$hora.'</td>
                                <td>'.$detalle.'</td>
                                <td>+'.$monto.'</td>
                                <td></td>
                              </tr>';
                            $conteo += 1;
                          }else if($value['cargo']!=0 && $value['moneda']=='ef' && $value['tipo_mov']!='saldo'){ // cargos
                            echo'
                              <tr class="text-danger '.$bg.'">
                                <td>'.$hora.'</td>
                                <td>'.$detalle.'</td>
                                <td></td>
                                <td>-'.$monto.'</td>
                              </tr>';
                            $conteo += 1;
                          }
                        }

                    echo'
                    </tbody>
                  </table>
                </div>
              </div>
            </div>';

            if(count($movsTransbank)!=0){
              echo'
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title">Movimientos Transbank</h3>
                </div>
                <div class="card-body">
                  <div class="card-body p-0">
                    <table class="table table-sm table-hover table-sin-bordes">
                      <thead>
                        <tr>
                          <th style="width:10%">Hora</th>
                          <th>Movimiento</th>
                          <th style="width:12%">Monto</th>
                        </tr>
                      </thead>
                      <tbody class="text-primary">';

                          $conteo = 0;
                          $saldo = 0;
                          foreach ($movsTransbank as $key => $value) {
  
                            $bg = (isset($diaCerrado[0]['id']) && $value['id'] > $diaCerrado[0]['id']) ? 'bg-secondary' : ''; // destaca si se ingresó después del cierre

                            if($value['tipo_mov']=='abClient' || $value['tipo_mov']=='anticipoClient'){
                              $conteo += 1;
                              $movMostrar = $value['tipo_mov'] == 'abClient' ? 'ABONO' : 'ANTICIPO';
                              $clienteMostrar = strtoupper(explode('ref. ', $value['nom_client'])[0]);
                              if($value['saldo'] == 0){
                                $saldoMostrar = ' <i><b>(CUENTA SALDADA)</b></i>';
                              }else if($value['saldo'] > 0){
                                $saldoMostrar = ' <i class="text-danger"><b>(SALDO ADEUDADO '.number_format($value['saldo'],0,',','.').')</b></i>';
                              }else if($value['saldo'] < 0){
                                $saldoMostrar = ' <i class="text-primary"><b>(SALDO A FAVOR '.number_format($value['saldo'],0,',','.').')</b></i>';
                              }
                              $monto = number_format($value['abono'],0,',','.');
                              echo'
                              <tr class="text-success '.$bg.'">
                                <td>'.substr($value['fecha'],11,-3).'</td>
                                <td>'.$movMostrar.' <b>'.$clienteMostrar.'</b> '.strtoupper($value['detalle']).$saldoMostrar.'</td>
                                <td>'.$monto.'</td>
                              </tr>';
                              $saldo += $value['abono'];

                            }else{

                              $cliente = strtoupper(explode(' (', $value['nom_client'])[0]);
                              $clienteMostrar = $cliente == '-' ? '' : $cliente;
                              if($value['moneda']=='E_TD' || $value['moneda']=='E_TC'){ // pago combinado efectivo y TD
                                  $metodoPago = json_decode($value['detalle']);
                                  $tipoMoneda = substr($value['moneda'], 2);
                                  $conteo += 1;
                                  echo'
                                  <tr>
                                    <td>'.substr($value['fecha'],11,-3).'</td>
                                    <td>VENTA  ('.$value['tipo_mov'].') <b>'.$clienteMostrar.'</b> '.$tipoMoneda.'-'.$metodoPago[0]->cod.'</td>
                                    <td>'.number_format($metodoPago[0]->tarjeta,0,',','.').'</td>
                                  </tr>';
                                  $saldo += $metodoPago[0]->tarjeta;
                              }else{  
                                  $conteo += 1;
                                  echo'
                                  <tr>
                                    <td>'.substr($value['fecha'],11,-3).'</td>
                                    <td>VENTA  ('.$value['tipo_mov'].') <b>'.$clienteMostrar.'</b> '.strtoupper($value['detalle']).'</td>
                                    <td>'.number_format($value['abono'],0,',','.').'</td>
                                  </tr>';
                                  $saldo += $value['abono'];

                              }

                            }
                          }
                          // if($conteo == 0){
                          //     echo '<div><i>NO HUBIERON MOVIMIENTOS</i></div>';                      
                          // }else{

                          //   echo '
                          //     <tr>
                          //       <td></td>
                          //       <td></td>
                          //       <td style="margin-bottom: 10px;"></td>
                          //     </tr>';
                          //   // <div class="" style="margin-bottom: 10px;"></div>';
                          //         // echo '<div class="col-xs-8" style="text-align:left; color:rgb(0,0,0); font-size:15px"><i>TOTAL TRANSBANK</i></div><div class="col-xs-4" style="text-align:right; color:rgb(0,0,0); font-size:15px"><b>$'.number_format($saldo,0,',','.').'</b></div>';
                          // }

                        

                          // if($conteo == 0){
                          //     echo '<div><i>NO HUBIERON MOVIMIENTOS</i></div>';                      
                          // }
                      echo'       
                      </tbody>
                    </table>

                    <table class="table table-sm table-sin-bordes">
                      <thead>
                        <tr>
                          <th style="width:10%"></th>
                          <th class="float-right"><h5>TOTAL                    </h5></th>
                          <th style="width:12%"><h5>'.number_format($saldo,0,',','.').'</h5></th>
                        </tr>
                      </thead>
                    </table>
                  </div>
                </div>
              </div>';
            }

            if(count($movsTransf) != 0){
            echo'
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Transferencias</h3>
              </div>
              <div class="card-body">
                <div class="card-body p-0">
                  <table class="table table-sm table-hover table-sin-bordes">
                    <thead>
                      <tr>
                        <th style="width:10%">Hora</th>
                        <th>Movimiento</th>
                        <th style="width:12%">Monto</th>
                      </tr>
                    </thead>
                    <tbody>';

                      $conteo = 0;
                      $totalTransf = 0;
                      
                      foreach ($movsTransf as $key => $value){

                        $bg = (isset($diaCerrado[0]['id']) && $value['id'] > $diaCerrado[0]['id']) ? 'bg-secondary' : ''; // destaca si se ingresó después del cierre

                        if($value['saldo'] == 0 && is_numeric($value['saldo'])){
                          $saldoMostrar = ' <i class="text-success"><b>(CUENTA SALDADA)</b></i>';
                        }else if($value['saldo'] > 0 && is_numeric($value['saldo'])){
                          $saldoMostrar = ' <i class="text-danger"><b>(SALDO ADEUDADO '.number_format($value['saldo'],0,',','.').')</b></i>';
                        }else if($value['saldo'] < 0 && is_numeric($value['saldo'])){
                          $saldoMostrar = ' <i class="text-primary"><b>(SALDO A FAVOR '.number_format($value['saldo'],0,',','.').')</b></i>';
                        }

                        if($value['tipo_mov']=='abClient' || $value['tipo_mov']=='anticipoClient'){
                          $cliente = strtoupper(explode('ref. ', $value['nom_client'])[0]);
                          $clienteMostrar = $cliente == '-' ? '' : $cliente;
                          $movMostrar = $value['tipo_mov'] == 'abClient' ? 'ABONO' : 'ANTICIPO';
                          $conteo += 1;
                          echo'
                          <tr class="'.$bg.'">
                            <td>'.substr($value['fecha'],11,-3).'</td>
                            <td>'.$movMostrar.' <b>'.$clienteMostrar.'</b>'.$saldoMostrar.'</td>
                            <td>'.number_format($value['abono'],0,',','.').'</td>
                          </tr>';
                        }else{
                          $conteo += 1;
                          $cliente = strtoupper(explode(' (', $value['nom_client'])[0]);
                          $clienteMostrar = $cliente == '-' ? '' : $cliente;
                          echo'
                          <tr>
                            <td>'.substr($value['fecha'],11,-3).'</td>
                            <td>VENTA ('.$value['tipo_mov'].') <b>'.$clienteMostrar.'</b></td>
                            <td>'.number_format($value['abono'],0,',','.').'</td>
                          </tr>';
                        }
                        $totalTransf += $value['abono'];
                      }
                      
                    echo'
                    </tbody>
                  </table>

                  <table class="table table-sm table-sin-bordes">
                    <thead>
                      <tr>
                        <th style="width:10%"></th>
                        <th class="float-right"><h5>TOTAL                    </h5></th>
                        <th style="width:12%"><h5>'.number_format($totalTransf,0,',','.').'</h5></th>
                      </tr>
                    </thead>
                  </table>
                </div>
              </div>
            </div>';
            }
            ?>
          </div>

          <div class="col-md-6">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Resumen Movimientos en Efectivo</h3>
              </div>
              <div class="card-body row">
                <div class="col-md-6">
                  <div class="card-body p-0">
                    <table class="table table-sm table-sin-bordes">
                      <tbody>
                        <tr class="text-primary">
                          <td style="width:50%">Apertura Caja</td>
                          <td style="width:50%">$ <?php echo number_format($saldoAnterior,0,',','.') ?></td>
                        </tr>
                        <tr class="text-primary">
                          <td style="width:50%">Aporte Caja</td>
                          <td style="width:50%">$ <?php echo number_format($aportesCaja,0,',','.') ?></td>
                        </tr>
                        <tr class="text-primary">
                          <td style="width:50%">Abonos</td>
                          <td style="width:50%">$ <?php echo number_format($abonosEf,0,',','.') ?></td>
                        </tr>
                        <tr class="text-primary">
                          <td style="width:50%">Ventas Efectivo</td>
                          <td style="width:50%">$ <?php echo number_format($ventasEf,0,',','.') ?></td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="card-body p-0">
                    <table class="table table-sm table-sin-bordes">
                      <tbody>
                        <tr class="text-success">
                          <td style="width:50%">Retiros CF</td>
                          <td style="width:50%">$ <?php echo number_format($retirosCf,0,',','.') ?></td>
                        </tr>
                        <tr class="text-danger">
                          <td style="width:50%">Cargos</td>
                          <td style="width:50%">$ <?php echo number_format($cargosEf,0,',','.') ?></td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>

            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Ventas del día (<b><?php echo $cantVentasDiaMostrar ?> → </b>$<?php echo number_format($montoVendido,0,',','.') ?>)</h3>
              </div>
              <div class="card-body row">
                <div class="col-md-6">
                  <div class="card-body p-0">
                    <table class="table table-sm table-sin-bordes">
                      <tbody>
                        <tr class="text-primary">
                          <td style="width:50%">Efectivo</td>
                          <td style="width:50%">$ <?php echo number_format(($ventasEf),0,',','.') ?></td>
                        </tr>
                        <tr class="text-primary">
                          <td style="width:50%">Transferencias</td>
                          <td style="width:50%">$ <?php echo number_format($ventasTransf,0,',','.') ?></td>
                        </tr>
                        <tr class="text-danger">
                          <td style="width:50%">Crédito Interno</td>
                          <td style="width:50%">$ <?php echo number_format($ventasCI,0,',','.') ?></td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="card-body p-0">
                    <table class="table table-sm table-sin-bordes">
                      <tbody>
                        <tr class="text-primary">
                          <td style="width:50%">TD</td>
                          <td style="width:50%">$ <?php echo number_format($ventasTD,0,',','.') ?></td>
                        </tr>
                        <tr class="text-primary">
                          <td style="width:50%">TC</td>
                          <td style="width:50%">$ <?php echo number_format($ventasTC,0,',','.') ?></td>
                        </tr>
                        <tr class="text-danger border border-danger">
                          <td style="width:50%"><b>Pendientes (<?php echo  number_format($cantVentasPend,0,',','.') ?>)</b></td>
                          <td style="width:50%"><b>$ <?php echo number_format($ventasPend,0,',','.') ?></b></td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
            
            <form role='form' method='post'>          
              <textarea class="d-none" id='grafVentas' name="grafVentas"></textarea> <!-- GRAFICO EN BASE64 -->
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title">Efectivo Esperado <b>$<?php echo number_format(($saldoAnterior+$aportesCaja+$abonosEf+$ventasEf-$cargosEf),0,',','.') ?></b></h3>
                </div>
                <div class="card-body row">
                  <div class="col-md-6">
                    <div class="card-body p-0">
                      <table class="table table-sm table-sin-bordes">
                        
                        <thead>
                          <tr>
                            <th style="width:35%"></th>
                            <th style="width:70%; text-align: center">Billetes</th>
                          </tr>
                        </thead>
                        <tbody class="montoCuadrar">
                          <tr>
                            <td style="padding-top:15px">$ 20.000</td>
                            <td>
                              <input type="text" class="form-control form-control-danger miles cierre" monto="20000" onkeyup="format(this);" onkeydown="" onchange="format(this);" onkeypress="return soloNumeros(event)" maxlength="9" id="cuadrar20000" name="cuadrar20000" value="<?php echo $cuadrar20000; ?>" placeholder='' <?php echo $disabled; ?>>
                            </td>
                          </tr>
                         <tr>
                            <td style="padding-top:15px">$ 10.000</td>
                            <td>
                              <input type="text" class="form-control form-control-danger miles cierre" monto="10000" onkeyup="format(this);" onkeydown="" onchange="format(this);" onkeypress="return soloNumeros(event)" maxlength="9" id="cuadrar10000" name="cuadrar10000" value="<?php echo $cuadrar10000; ?>" placeholder='' <?php echo $disabled; ?>>
                            </td>
                          </tr>
                          <tr>
                            <td style="padding-top:15px">$ 5.000</td>
                            <td>
                              <input type="text" class="form-control form-control-danger miles cierre" monto="5000" onkeyup="format(this);" onkeydown="" onchange="format(this);" onkeypress="return soloNumeros(event)" maxlength="9" id="cuadrar5000" name="cuadrar5000" value="<?php echo $cuadrar5000; ?>" placeholder='' <?php echo $disabled; ?>>
                            </td>
                          </tr>
                          <tr>
                            <td style="padding-top:15px">$ 2.000</td>
                            <td>
                              <input type="text" class="form-control form-control-danger miles cierre" monto="2000" onkeyup="format(this);" onkeydown="" onchange="format(this);" onkeypress="return soloNumeros(event)" maxlength="9" id="cuadrar2000" name="cuadrar2000" value="<?php echo $cuadrar2000; ?>" placeholder='' <?php echo $disabled; ?>>
                            </td>
                          </tr>
                          <tr>
                            <td style="padding-top:15px">$ 1.000</td>
                            <td>
                              <input type="text" class="form-control form-control-danger miles cierre" monto="1000" onkeyup="format(this);" onkeydown="" onchange="format(this);" onkeypress="return soloNumeros(event)" maxlength="9" id="cuadrar1000" name="cuadrar1000" value="<?php echo $cuadrar1000; ?>" placeholder='' <?php echo $disabled; ?>>
                            </td>
                          </tr>


                        </tbody>
                      </table>

                      
                    </div>
                  </div>

                  <?php
                    $tipoSucursal = ModeloSucursales::mdlMostrarSucursales('sucursales', 'nombre_sucursal', $_SESSION['sucursal'])[0]['tipo_sucursal'];
                    $bg = $tipoSucursal == 'bodega' ? '' : 'white';
                  ?>

                  <div class="col-md-6">
                    <div class="card-body p-0">
                      <table class="table table-sm table-sin-bordes">  
                        <thead>
                          <tr>
                            <th style="width:35%"></th>
                            <th style="width:70%; text-align: center">Monedas</th>
                          </tr>
                        </thead>
                        <tbody class="montoCuadrar">
                          <tr>
                            <td style="padding-top:15px">$ 500</td>
                            <td>
                              <input type="text" class="form-control form-control-danger miles cierre" monto="500" onkeyup="format(this);" onkeydown="" onchange="format(this);" onkeypress="return soloNumeros(event)" maxlength="7" id="cuadrar500" name="cuadrar500" value="<?php echo $cuadrar500; ?>" placeholder='' <?php echo $disabled; ?>>
                            </td>
                          </tr>
                         <tr>
                            <td style="padding-top:15px">$ 100</td>
                            <td>
                              <input type="text" class="form-control form-control-danger miles cierre" monto="100" onkeyup="format(this);" onkeydown="" onchange="format(this);" onkeypress="return soloNumeros(event)" maxlength="7" id="cuadrar100" name="cuadrar100" value="<?php echo $cuadrar100; ?>" placeholder='' <?php echo $disabled; ?>>
                            </td>
                          </tr>
                          <tr>
                            <td style="padding-top:15px">$ 50</td>
                            <td>
                              <input type="text" class="form-control form-control-danger miles cierre" monto="50" onkeyup="format(this);" onkeydown="" onchange="format(this);" onkeypress="return soloNumeros(event)" maxlength="7" id="cuadrar50" name="cuadrar50" value="<?php echo $cuadrar50; ?>" placeholder='' <?php echo $disabled; ?>>
                            </td>
                          </tr>
                          <tr>
                            <td style="padding-top:15px">$ 10</td>
                            <td>
                              <input type="text" class="form-control form-control-danger miles cierre" monto="10" onkeyup="format(this);" onkeydown="" onchange="format(this);" onkeypress="return soloNumeros(event)" maxlength="7" id="cuadrar10" name="cuadrar10" value="<?php echo $cuadrar10; ?>" placeholder='' <?php echo $disabled; ?>>
                            </td>
                          </tr>
                          <tr>
                            <td style="padding-top:15px">Total Caja</td>
                            <td>
                              <input type="text" class="form-control input-xs miles cierre" id="totalCajaCierre" name="totalCajaCierre" style="background-color: <?php echo $bg;?>" value="<?php echo $totalCierre; ?>" disabled>
                              <input type="hidden" id="totalCaja" name="totalCaja" value="0">
                            </td>
                          </tr>

                        </tbody>
                      </table>
                    </div>
                  </div>

                  <div class="col-md-12 text-primary">
                    <div class="card-body p-0">
                      <table class="table table-sm table-sin-bordes">
                        <tbody>
                          <tr>
                            <td style="padding-top:15px; width:35%">
                              <?php echo $usuarioCierre; ?>
                            </td>
                          </tr>
                        </tbody>
                      </table>   
                    </div>

                  </div>
                  
                  <div class="col-md-12 <?php echo $mostrarItem;?> text-primary">
                    <div class="card-body p-0">
                      <table class="table table-sm table-sin-bordes">
                        <tbody>
                          <tr>
                            <td>
                              <button style="width:100%; background-color:rgb(37,211,102); color:white; padding-bottom: 10px" type="submit" class="btn">Cerrar Día</button>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>


                </div>
              </div>
              <?php
                $cerraDia = new ControladorMovimientos();
                $utilidadDia = $cantVentasDia == 0 ? 0 : $utilidades_por_fecha[date('Y-m-d')];
                $cerraDia -> ctrCerrarDia($ventasEf, $ventasTD, $ventasTC, $ventasTransf, $ventasCI, $ventasPend, $cantVentasPend, $pag, $montoVendido, $cantVentasDia, $utilidadDia, $diaEvaluado);
              ?>            
            </form>
          </div>
        </div>
      </div>
    </section>
  </div>
</body>