/*==================================================
SURTIR PRODUCTO TRANSFORMABLE
==================================================*/
$(".tablaVentaCotProductos").on("click", "button#surtirAlChicoxD", function(){
	$(this).attr('disabled','disabled');
	var idProd = $(this).attr('idProd');
    var datos = new FormData();
    datos.append("idProdTransf", idProd);
	$.ajax({
		url: "ajax/productos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		 beforeSend: function() {
		 	$('#surtirAlChicoxD').removeAttr('style');
		 	$('#surtirAlChicoxD').addClass('btn-default');
		 	$('#surtirAlChicoxD').attr('disabled','disabled');
		 	$('#surtirAlChicoxD').attr('data-original-title','Transformando');
	        $('#surtirAlChicoxD').html("<div style='text-align:center'>TRANSFORMADO...</div>");
    	},
		success: function(r){
		    var audio = new Audio('componentes/sonidos/success.mp3');
		    audio.play();
		    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'SE HA SURTIDO EL PRODUCTO'});
			$('.tablaVentaCotProductos').DataTable().ajax.reload();
		}
	})
})

/*=============================================
EDITAR PRECIO MAYOR EN VIVO
=============================================*/
$(".tablaVentaCotProductos").on("click", ".btnEditPVentVivoVentaCot", function(){
	var perfil = $('#perfilVend').val();
	var pCompra = $(this).attr('p_comp');
	var pVenta = $(this).attr('p_vent');
	var idProd  = $(this).attr("idProd");
	var pVentMayor = $(this).attr("pVentMayAnt");
	var desc = $(this).attr("desc");
	var mayoreo = $(this).attr("cant_mayor");
	var datos = new FormData();
	var	ut_min_venta = ajuste('ut_min_admin_venta');

	var pMinProdAdmin = Math.round(Number(pCompra)*(1+Number(ut_min_venta)/100)); // permite ventas con 10% de utilidad a administradores
	
	precioAlerta = perfil == 'Administrador' ? pMinProdAdmin : Math.ceil($(this).attr("pVentMayAnt"));
	
	Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'info',title: 'El precio debe ser igual o superior a '+formatNumber.new(precioAlerta, "$")});
  	$(this).parent().parent().html('<div><input type="text" style="width:110px" class="form-control input-xs" name="pVMayVivo" id="pVMayVivo" placeholder="Precio Mayor" value="'+pVentMayor+'" onkeypress="return soloNumeros(event)" required>'+
                          '<br>'+
                          '<button style="width:110px" class="btn btn-info btn-xs editPVentaVivoVentaCot" idProd="'+idProd+'" pMayor="'+pVentMayor+'" desc="'+desc+'" cant_mayor="'+mayoreo+'" p_comp="'+pCompra+'" p_vent="'+pVenta+'">Actualizar Precio</button></div>');
	$('#pVMayVivo').select();
})

$(".tablaVentaCotProductos").on("click", ".editPVentaVivoVentaCot", function(){
	perfil = $('#perfilVend').val();
	id = $(this).attr('idProd');
	pMay = $('#pVMayVivo').val();
	pComp = $(this).attr('p_comp');
	pVent = $(this).attr('p_vent');
	pVentMay = $(this).attr('pMayor');
	mayAnt = $(this).attr('mayAnt');
	dcto = $(this).attr('desc');
	cantMay = 0;
	var id = $(this).attr('idProd');
	var pMay = $(this).parent().children('#pVMayVivo').val();
	var	ut_min_venta_admin = ajuste('ut_min_admin_venta');

	var pMinProdAdmin = Math.round(Number(pComp)*(1+Number(ut_min_venta_admin)/100)); // permite ventas con 10% de utilidad a administradores

	if(pMay != '' && pMay != 0 && Number(pMay) >= Number(pMinProdAdmin)){ // permite que administradores den precio el 10% utilidad
		$("button[idProducto='" + id + "']").removeClass("agregarProductoVentaCot btn-primary");
		$("button[idProducto='" + id + "']").addClass("agregarProductoVentaCot btn-success");
		$("button[idProducto='" + id + "']").attr("pCotizado",pMay);
		// VISUAL
		$(this).parent().html("<div><b>"+formatNumber.new(pVent, "$")+" c/u</b> ("+dcto+"%)"+
							  "<br>"+
							  "<b style='color:rgb(92,184,92)' class='varMayor' idProd='"+id+"'>&uarr; "+cantMay+"u $ "+formatNumber.new(pMay, "$")+" c/u</b>"+
							  "<br>"+
							  "<button class='btn btn-warning btn-xs btnEditPVentVivoVentaCot' idProd='"+id+"' desc='"+dcto+"' cant_mayor='"+cantMay+"' p_comp='"+pComp+"' p_vent='"+pVent+"' mayAnt='"+mayAnt+"' pVentMayAnt='"+pVentMay+"'><i class='fa fa-pen'></i></button>"+
							  "</div>");
	    var audio = new Audio('componentes/sonidos/success.mp3');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Nuevo precio $'+formatNumber.new(Math.ceil(pMay))});

	}else{

		pMinAlerta = perfil == 'Administrador' ? pMinProdAdmin : pVentMay;
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'El precio debe ser igual o superior a '+formatNumber.new(Math.ceil(pMinAlerta, "$"))});
		$('#pVMayVivo').select();
	} 
})



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// /*=============================================
// AGREGANDO PRODUCTOS DESDE EL BOTÓN PARA DISPOSITIVOS ---> SOLO ADMINISTRADOR
// =============================================*/
$('#selectProdVentaCotMovil').change(function(){
	var idProducto = $(this).val();
	if(idProducto == 0){
		$("#infoProdVentaCotMovil").html('');
		$('#agregarProdVentaCotMovil').attr('disabled','disabled');
	}else{
		$('#agregarProdVentaCotMovil').removeAttr('disabled');		
	    var sucursal = $('#sucursalActiva').val();
		var tipo_cliente = $('#tipo_cliente').val();
		var datos = new FormData();
		datos.append("idProducto", idProducto);
		$.ajax({
			url: "ajax/productos.ajax.php",
			method: "POST",
			data: datos,
			cache: false,
			contentType: false,
			processData: false,
			dataType: "json",
			success: function(respuesta) {
				var descuento = respuesta["descuento"];
				var mayoreo = respuesta["mayor_sobre"];
				var precioMayor = respuesta["precio_mayor"];
				var precioCompra = respuesta["precio_compra"];
				var ubic = respuesta["zona_"+sucursal];

				var stockSucursal =  "stock_"+sucursal;
				var descripcion = respuesta["descripcion"];
				var codigoInterno = respuesta["sku"];
				var maneja_stock = respuesta["maneja_stock"];
				var stock = respuesta["stock_"+sucursal];
				var precio = respuesta['precio_venta'];
				

				var tipo_ajuste = 'ut_min_admin_venta';
				var datos = new FormData();
				datos.append("tipo_ajuste", tipo_ajuste);
				$.ajax({
					url:"ajax/ajustes.ajax.php",
					method: "POST",
					data: datos,
					cache: false,
					contentType: false,
					processData: false,
					dataType: "json",
					success: function(r1){
						var ut_min_venta = r1['ajuste'];
						
						var pMinProd = Number(precioCompra)*(1+Number(ut_min_venta)/100) > Number(precio) ? Number(precio) : Math.round(Number(precioCompra)*(1+Number(ut_min_venta)/100)); // asegura precioMin sea el mejor para el cliente
						var	descripcionMostrar = 	'<b>Precio Venta: </b>('+formatNumber.new(precio, "$")+'c/u <b style="color:indigo"><i class="fa fa-arrow-up"></i> '+mayoreo+'u '+formatNumber.new(precioMayor, "$")+'c/u)</b><br>'+
													'<b>Sugerencia: </b>['+formatNumber.new(pMinProd, "$")+' - '+formatNumber.new(precio, "$")+']';

						$('#agregarProdVentaCotMovil').attr('idProd', idProducto);
						$('#agregarProdVentaCotMovil').attr('precioUnicoMovil', precio);

						var imagen = '<br><img style="float:left" id="imagenZoom" src="'+respuesta['imagen']+'" alt="'+descripcion+'" class="imagenZoom" width="150px" idProducto="'+idProducto+'" data-toggle="modal" data-target="#modalZoomProducto">';
						$("#imagenZoomModal").attr("src", respuesta["imagen"]);
						$("#tituloModalZoom").text(descripcion);

						$("#infoProdVentaCotMovil").html(
				          	'<div class="row">'+
				            	'<div class="col-8 descripcion">'+
		                  			'<font size="-1">'+descripcionMostrar+imagen+'</font>'+
				            	'</div>'+
					            '<div class="col-4 precioPreSetMovil">'+
				              		'<font size="-2">Precio Unitario ($)</font>'+
				              		'<div class="input-group">'+
						                '<input type="number" class="form-control" min="'+pMinProd+'" id="precioVentaCotProdMovil" value="'+precio+'">'+
				              		'</div>'+
				            	'</div>'+
					        '</div>'+
					        '<div id="esp'+idProducto+'" style="height:3px"></div>')
					}
				})

			}
		})	
	}
})

$("#modalVentaCotMovil").on("change", "input#precioVentaCotProdMovil", function() {
	min = $(this).attr('min');
	precioVentaMovil = $(this).val();
	if(Number(precioVentaMovil) < Number(min)){
		var audio = new Audio('componentes/sonidos/error.wav');
		audio.play();
    	$(this).val(min);
		setTimeout(function(){
	    	Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'El precio no puede ser menor a '+formatNumber.new(min, '$ ')});
		}, 200);
		$('#agregarProdVentaCotMovil').attr('precioUnicoMovil', min);
	}else{
		$('#agregarProdVentaCotMovil').attr('precioUnicoMovil', precioVentaMovil);		
	}
})


$('#agregarProdVentaCotMovil').click(function(){

	$('#modalVentaCotMovil').modal('hide');
	var idProducto = $(this).attr("idProd");
	var precMay = $(this).attr("precioUnicoMovil");
	$("#selectProdVentaCotMovil").val(0).trigger('change'); // reset select
    var sucursal = $('#sucursalActiva').val();

	var datos = new FormData();
	datos.append("idProducto", idProducto);

	$.ajax({

		url: "ajax/productos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta) {
			descripcion = respuesta["descripcion"];
			codigoInterno = respuesta["sku"];
			maneja_stock = respuesta["maneja_stock"];
			stock = respuesta["stock_"+sucursal];
			precio = respuesta["precio_venta"];
			descuento = respuesta["descuento"];
			precioMayor = precMay != 0 ? precMay : respuesta["precio_mayor"];
			precioCompra = respuesta["precio_compra"];
			ubic = respuesta["zona_"+sucursal];

			readonlyCantidad = "";
			readonlyPrecio = "readonly";
			readonlyDcto = "";
			readonlyDescripcion = "readonly";

			mayoreoPrecioUnico = '(Precio Único: '+formatNumber.new(precioMayor, "$")+'c/u)';

			descripcionMostrar = '<b>'+ubic+'-'+codigoInterno+'</b> '+descripcion+' <i>'+mayoreoPrecioUnico+'</i>';


			estilo = 'height: 40px;background-color:rgb(169,249,98)';
			disabled = 'disabled';
			precioUnico = precioMayor;
			calculoDcto = Math.round((1 - (precioUnico/precio))*10000)/100; //dcto con 2 decimales
			descuentoInput = calculoDcto < 0 ? 0 : calculoDcto; // SI DCTO ES MENOR A CERO SE PONE CERO SI NO EL DCTO QUE PERTENECE

			$(".nuevoProductoVentaCot").prepend(
	          	'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
	            	'<div class="col-12 descripcion" style="padding-left:0px">'+
	              		'<div>'+
	                		'<div>'+
	                  			'<button type="button" class="btn btn-danger btn-xs quitarProdVentCot" idProducto="'+idProducto+'">'+
	                    			'<i class="fa fa-times"></i>'+
	                  			'</button>'+
	                  			'<font size="-1">   '+descripcionMostrar+' <b>(Stock Disponible: '+stock+'u)</b></font>'+
	                		'</div>'+
	                		'<input type="hidden" class="form-control prodVentaCot" style="height: 40px" idProducto="'+idProducto+'" codigointerno="'+codigoInterno+'" name="agregarProducto" value="'+descripcion+'" required="" readonly="'+readonlyDescripcion+'">'+
	              		'</div>'+
	            	'</div>'+
	            	'<div style="height:25px"></div>'+
	            	'<div class="col-3 cantidadProducto" style="padding-left:0px">'+
	              		'<font size="-2">Cantidad</font>'+
	              		'<input type="number" class="form-control cantProdVentaCot" mayoreo="0" style="height: 40px" name="cantProdVentaCot" id="cantProdVentaCot" min="1" max="'+stock+'" value="1" stock="'+stock+'" nuevostock="'+Number(stock - 1)+'" required autofocus '+readonlyCantidad+'>'+
	            	'</div>'+
		            '<div class="col-6 ingresoPrecio" style="padding-left:0px">'+
	              		'<font size="-2">Total ($)</font>'+
	              		'<div class="input-group">'+
			                '<input type="number" style="'+estilo+'" class="form-control precioProdVentaCot" pEditado="'+precioMayor+'" pNormal="'+respuesta["precio_venta"]+'" precioCompra="'+precioCompra+'" precioReal="'+precio+'" precioFinal="'+precio+'" precioMayor="'+precioMayor+'" id="precioProdVentaCot"  value="'+precioMayor+'" required '+readonlyPrecio+'>'+
	              		'</div>'+
	            	'</div>'+
		            '<div class="col-3 ingresoDescuento" style="padding-left:0px">'+
		              	'<div>'+
		              		'<font size="-2">Descuento</font>'+
		                	'<input type="number" style="'+estilo+'" min="0" max="' + descuento + '" class="form-control dctoProdVentaCot" step="1" value="'+descuentoInput+'" '+disabled+' required '+readonlyDcto+'>'+
		              	'</div>'+
		            '</div>'+
		        '</div>'+
		        '<div id="esp'+idProducto+'" style="height:3px"></div>')
		}
	})
	setTimeout(function(){
		listarProdVentaCot();
    	$('#cantProdVentaCot').select();
	}, 300);

})

$('#modalVentaCotMovil').on('shown.bs.modal', function (e) {
	var prodsIngresados = [];
	$('.prodVentaCot').each(function (i){
		idIngresados = $(this).attr('idProducto');
		prodsIngresados.push(idIngresados);
    });
	// ELIMINA LA OPCIÓN QUE YA SE INGRESÓ A LA VENTA
    for (var i = 0; i <	prodsIngresados.length; i++) {
	    $('#selectProdVentaCotMovil option[value="'+prodsIngresados[i]+'"]').remove();
	}

})



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/*===================================================
PERMITE VENDER CON CREDITO INTERNO A ALGUNOS CLIENTES
===================================================*/
$("#selecClientVentaCot").change(function(){


	$('.metodoPagoVentaCot').val(''); // RESET METODO PAGO
	$('.cajasMetodoPagoVentaCot').html(''); // RESET METODO PAGO

	var idCliente = $(this).val();
	var datos = new FormData();
	datos.append("idCliente", idCliente);
	$.ajax({
		url: "ajax/clientes.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(r){
			$('.rutFacturarCliente').val(r['rut_facturar']);
			if(r['credito_interno']==1){ // CLIENTE CON CREDITO INTERNO ACTIVO
				$("#metodoPagoVentaCot").html(
					'<option value="">Método</option>'+
                    '<option value="Efectivo">Efectivo</option>'+
                    '<option value="Transferencia">Transferencia</option>'+
                    '<option value="TC">Tarjeta Crédito</option>'+
                    '<option value="TD">Tarjeta Débito</option>'+
                    '<option value="E_TD">Efectivo + TD</option>'+
                    '<option value="E_TC">Efectivo + TC</option>'+
                    '<option value="Fiado">Crédito Interno</option>'+
                    '<option value="Pend">Cobro en Reparto</option>'
				);
			}else if(r['credito_interno']==2 && r['deuda_cliente']>0){ // CLIENTE CON CREDITO INTERNO SUSPENDIDO Y CON DEUDA
				$("#metodoPagoVentaCot").html(  // EVITA DAR CREDITO INTERNO
					'<option value="">Método</option>'+
                    '<option value="Efectivo">Efectivo</option>'+
                    '<option value="Transferencia">Transferencia</option>'+
                    '<option value="TC">Tarjeta Crédito</option>'+
                    '<option value="TD">Tarjeta Débito</option>'+
                    '<option value="E_TD">Efectivo + TD</option>'+
                    '<option value="E_TC">Efectivo + TC</option>'+
                    '<option value="Pend">Cobro en Reparto</option>'
				);

				Swal.fire({ // ABRE DEUDA DEL CLIENTE
					icon: "warning",
					title: '<strong>CUENTA SUSPENDIDA</strong>',
					html: "Solo pagos por Efectivo, Tranferencia o Tarjeta.<br>Imprimir deuda y entregar al Cliente",
					showConfirmButton: true,
					confirmButtonText: "Ok"
					}).then(function(result){
						if(result.value){
						    window.open("extensiones/tcpdf/pdf/historial-cliente-resumen.php?id=" + idCliente, "_blank");
						}
					})
			}else if(r['credito_interno']==0 && r['deuda_cliente']>0){ // CLIENTE CON CREDITO INTERNO BLOQUEADO Y CON DEUDA
				$("#metodoPagoVentaCot").html(  // EVITA DAR CREDITO INTERNO
					'<option value="">Método</option>'+
                    '<option value="Efectivo">Efectivo</option>'+
                    '<option value="Transferencia">Transferencia</option>'+
                    '<option value="TC">Tarjeta Crédito</option>'+
                    '<option value="TD">Tarjeta Débito</option>'+
                    '<option value="E_TD">Efectivo + TD</option>'+
                    '<option value="E_TC">Efectivo + TC</option>'+
                    '<option value="Pend">Cobro en Reparto</option>'
				);

				Swal.fire({ // ABRE DEUDA DEL CLIENTE
					icon: "error",
					title: '<strong>CUENTA BLOQUEADA</strong>',
					html: "Solo pagos por Efectivo, Tranferencia o Tarjeta.<br>Imprimir deuda, entregar al Cliente y COBRAR",
					showConfirmButton: true,
					confirmButtonText: "Ok"
					}).then(function(result){
						if (result.value) {
						    window.open("extensiones/tcpdf/pdf/historial-cliente-resumen.php?id=" + idCliente, "_blank");
						}
					})
			}else if(r['credito_interno'] != 1 && r['deuda_cliente']<0){ // PERMITE CREDITO INTERNO AUTOMATICO SI LA CUENTA ESTA CON SALDO A FAVOR, LIMITE HASTA LLEGAR A CERO
				$("#metodoPagoVentaCot").html( // OPCIONES DE PAGO
					'<option value="">Método</option>'+
                    '<option value="Efectivo">Efectivo</option>'+
                    '<option value="Transferencia">Transferencia</option>'+
                    '<option value="TC">Tarjeta Crédito</option>'+
                    '<option value="TD">Tarjeta Débito</option>'+
                    '<option value="E_TD">Efectivo + TD</option>'+
                    '<option value="E_TC">Efectivo + TC</option>'+
                    '<option value="Fiado">Crédito Interno</option>'+
                    '<option value="Pend">Cobro en Reparto</option>'
				);
				// $('.'+cajMetPago).html('');
					saldoAFavor =	"<table><tbody><tr><td>       </td><td><h2><strong>CLIENTE CON SALDO A FAVOR</strong></h2></td></tr></tbody></table>"+
									"<table>"+					
										"<tbody>"+
											"<tr>"+
												"<td>                    </td>"+
												"<td style='text-align:center;color:blue'>Crédito Interno Disponible:</td>"+
												"<td>  </td>"+
												"<td style='color:blue'>"+formatNumber.new(-r['deuda_cliente'], "$ ")+"</td>"+
											"</tr>"+
										"</tbody"+
									"</table>";
					Swal.fire({icon: "info", html: saldoAFavor, showConfirmButton: true, confirmButtonText: "Ok"})
			}

		}
	})
})

var idCot = $('.tablaVentaCotProductos').attr('idCot');
var skuFlete = ajuste('sku_flete');
var skuProdComun = ajuste('sku_prod_comun');
var skuInteres = ajuste('sku_interes');
var tablaDataProductos = $('.tablaVentaCotProductos').DataTable({
	"ajax": "ajax/datatable-ventaCotProductos.ajax.php?idCot="+idCot+"&skuFlete="+skuFlete+"&skuProdComun="+skuProdComun+"&skuInteres="+skuInteres,
    "order": [ 5, "asc" ], //orden descendente por defecto
	"deferRender": true,
	"retrieve": true,
	"processing": true,
	"language": {

		"sProcessing": "Procesando...",
		"sLengthMenu": "Mostrar _MENU_ registros",
		"sZeroRecords": "No se encontraron resultados",
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		"sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
		"sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		"sInfoPostFix": "",
		"sSearch": "Buscar:",
		"sUrl": "",
		"sInfoThousands": ",",
		"sLoadingRecords": "Cargando...",
		"oPaginate": {
			"sFirst": "Primero",
			"sLast": "Último",
			"sNext": "Siguiente",
			"sPrevious": "Anterior"
		},
		"oAria": {
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		}

	},
  	
  	dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
  	buttons:

  		[
			{ // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
                text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
                action: function ( e, dt, node, config ) {
					dt.clear().draw();
					dt.ajax.reload();
                }
            }	      
	    ]

});

/*=============================================
HACER CLICK AL BUSCAR EN DATATABLE
=============================================*/
$('div.dataTables_filter').keyup(function(e) {
	// if($('div.dataTables_filter input')!=""){
	if (e.keyCode == 13) {
		// HACE CLICK EN LA PRIMERA COINCIDENCIA DE LA BUSQUEDA DATATABLE
		$('#agregarProducto0').click();
		// MUESTRA TODA LA TABLA DEJANDO INVALIDO EL SEARCH, PERO NO BORRA EL INPUT
		$('#tablaVentaCotProductos').dataTable().fnFilter('');
	}
	// }
});

/*=============================================
AGREGANDO PRODUCTOS A LA VENTA DESDE LA TABLA
=============================================*/
$(".tablaVentaCotProductos tbody").on("click", "button.agregarProductoVentaCot", function() {

	var idProducto = $(this).attr("idProducto");
    var sucursal = $('#sucursalActiva').val();
    var cantCotizado = $(this).attr("cantCotizado");
    var pCotizado = $(this).attr("pCotizado");
	$(this).removeClass("btn-primary agregarProducto");
	$(this).addClass("btn-default");
	$("button[idProducto='" + idProducto + "']").attr("disabled",'disabled');
	var datos = new FormData();
	var detectaFlete = $(this).hasClass('fleteAgregado');
	datos.append("idProducto", idProducto);
	$.ajax({

		url: "ajax/productos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta) {
			var descripcion = respuesta["descripcion"];
			var codigoInterno = respuesta["sku"];
			var maneja_stock = respuesta["maneja_stock"];
			var stock = respuesta["stock_"+sucursal];
			var precio = respuesta["precio_venta"];
			var descuento = respuesta["descuento"];
			var mayoreo = respuesta["mayor_sobre"];
			var precioMayor = respuesta["precio_mayor"];
			var precioCompra = respuesta["precio_compra"];
			var ubic = respuesta["zona_"+sucursal];

			if (stock == 0 && maneja_stock == "SI") { // EVITAR AGREGAR PRODUTO CUANDO EL STOCK ESTÁ EN CERO

				Swal.fire({
					title: "No hay stock disponible",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});

				$("button[idProducto='" + idProducto + "']").addClass("btn-primary agregarProducto");

				return;

			} else {				

				existencias = '<b class="float-right" style="color:black">Lleva (1/'+cantCotizado+')</b>';
				nuevoStock = stock-1;
				descuento = (Math.round((1-(Number(pCotizado)/Number(precio)))*10000))/100; 

				if(detectaFlete){ // detecta flete
					disabCant = 'disabled';
					disabPrecio = '';
				}else{
					disabCant = '';
					disabPrecio = 'disabled';
				}

// <button class="btn btn-primary btn-sm recuperarBoton agregarProductoVentaCot" sucursal="local1" id="agregarProducto0" idproducto="1577" pcotizado="700" cantcotizado="1">Agregar</button>
// <button class="btn btn-success recuperarBoton agregarProductoVentaCot fleteAgregado" id="agregarProductoCot0" pcotizado="3000" idproducto="535" disabled="disabled">Agregar</button>
// <button class="btn btn-sm recuperarBoton agregarProductoVentaCot noManejaStock btn-default" sucursal="local1" id="agregarProducto0" idproducto="535" pmay="0" maydesde="0" mayant="1000" pventmayant="3000" disabled="disabled">Agregar</button>

				$(".nuevoProductoVentaCot").prepend(
						'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px; border-color:black; color:black;">'+
                            '<div class="col-12 descripcion" style="padding-left:0px">'+
                              	'<div>'+
                                	'<div>'+
                                  		'<button type="button" class="btn btn-danger btn-xs quitarProdVentCot" idProducto="'+idProducto+'">'+
                                    		'<i class="fa fa-times"></i>'+
                                  		'</button>'+
                                  		'<font size="-1">'+
                                    		' <b>'+ubic+'-'+codigoInterno+'</b> '+descripcion+' <b>('+formatNumber.new(precio, "")+'c/u desde '+mayoreo+'u '+formatNumber.new(precioMayor, "")+'c/u)</b> [<i>'+descuento+'%</i>]  <font id="existenciasCot">'+existencias+'</font>'+
                                  		'</font>'+
                                	'</div>'+
                                	'<input type="hidden" class="form-control prodVentaCot" style="height: 40px" idProducto="'+idProducto+'" codigoInterno="'+codigoInterno+'" name="agregarProducto" value="'+descripcion+'">'+
                              	'</div>'+
                            '</div>'+

                            '<div style="height:25px"></div>'+

                            '<div class="col-3 ingresoCantVentaCot" style="padding-left:0px">'+
                              	'<font size="-2">Cantidad</font>'+
                              	'<input type="number" class="form-control cantProdVentaCot" style="height: 40px;" name="cantProdVentaCot" id="cantProdVentaCot" min="1" max="'+stock+'" value="1" stock="'+stock+'" mayoreo="'+mayoreo+'" cantCotizado="'+cantCotizado+'" nuevoStock="'+nuevoStock+'" required '+disabCant+'>'+
                            '</div>'+

                            '<div class="col-6 ingresoPrecioVentaCot" style="padding-left:0px">'+
                                '<font size="-2">Total ($)</font>'+
                              	'<div class="input-group">'+
                                	'<input type="number" style="height: 40px;" class="form-control precioProdVentaCot info" data-original-title="'+formatNumber.new(pCotizado, "$ ")+'" precioCompra="'+precioCompra+'" pCotizado="'+pCotizado+'" precioReal="'+precio+'" precioFinal="'+precioCompra+'" precioMayor="'+precioMayor+'" id="precioProdVentaCot" value="'+(pCotizado)+'" required '+disabPrecio+'>'+
                              	'</div>'+
                            '</div>'+

                            '<div class="col-3 ingresoDctoVentaCot" style="padding-left:0px">'+
                              	'<div>'+
                                	'<font size="-2">Descuento</font>'+
                                	'<input type="number" style="height: 40px;" min="0" max="'+descuento+'" class="form-control dctoProdVentaCot" step="1" value="'+descuento+'" required disabled>'+
                              	'</div>'+
                            '</div>'+
                        '</div>'+
                        '<div id="esp'+idProducto+'" style="height:3px"></div>')

				listarProdVentaCot()
				sumarTotalesVentaCot()
				calcularVueltoVentaCot()
				localStorage.removeItem("quitarProdVentCot");
			}

		}

	})		




});

/*=============================================
CUANDO CARGUE LA TABLA CADA VEZ QUE NAVEGUE EN ELLA
=============================================*/
$(".tablaVentaCotProductos").on("draw.dt", function() {
	if (localStorage.getItem("quitarProdVentCot") != null) {
		var listaIdProductos = JSON.parse(localStorage.getItem("quitarProdVentCot"));
		for (var i = 0; i < listaIdProductos.length; i++) {
			$("button.recuperarBoton[idProducto='" + listaIdProductos[i]["idProducto"] + "']").removeClass('btn-default');
			$("button.recuperarBoton[idProducto='" + listaIdProductos[i]["idProducto"] + "']").addClass('btn-primary agregarProducto');
		}
	}
})

/*=============================================
QUITAR PRODUCTOS DE LA VENTA Y RECUPERAR BOTÓN
=============================================*/
var idquitarProdVentCot = [];
localStorage.removeItem("quitarProdVentCot");
$(".formularioVentaCot").on("click", "button.quitarProdVentCot", function() {
	$(this).parent().parent().parent().parent().parent().children('#esp'+$(this).attr('idProducto')).remove();
	$(this).parent().parent().parent().parent().remove();
	var idProducto = $(this).attr("idProducto");
	/*=============================================
	ALMACENAR EN EL LOCALSTORAGE EL ID DEL PRODUCTO A QUITAR
	=============================================*/
	if (localStorage.getItem("quitarProdVentCot") == null) {
		idquitarProdVentCot = [];
	} else {
		idquitarProdVentCot.concat(localStorage.getItem("quitarProdVentCot"))
	}

	idquitarProdVentCot.push({
		"idProducto": idProducto
	});

	localStorage.setItem("quitarProdVentCot", JSON.stringify(idquitarProdVentCot));

	$("button.recuperarBoton[idProducto='" + idProducto + "']").removeClass('btn-default');
	$("button.recuperarBoton[idProducto='" + idProducto + "']").addClass('btn-primary agregarProductoVentaCot');
	$("button.recuperarBoton[idProducto='" + idProducto + "']").removeAttr('disabled'); //RECUPERAR BOTONES DE EDICIÓN DE VENTA EN pVMayVivo	

	if ($(".nuevoProductoVentaCot").children().length == 0) {

		$("#nuevoImpuestoVenta").val(0);
		$("#nuevoTotalVenta").val(0);
		$("#totalVentaCot").val(0);
		$("#totalUtilidad").val(0);
		$("#nuevoTotalVenta").attr("total", 0);

		// DESACTIVA BOTON INGRESAR VENTA SI NO HAY PRODUCTOS
		$('#metodoPagoVentaCot').attr('disabled', 'disabled');
		
	} else {

		listarProdVentaCot()
		calcularVueltoVentaCot();


	}
	sumarTotalesVentaCot()
	listarProdVentaCot()

	$('.metodoPagoVentaCot').val(''); // RESET METODO PAGO
	$('.cajasMetodoPagoVentaCot').html(''); // RESET METODO PAGO
})

/*=============================================
MODIFICAR CANTIDAD
=============================================*/
$(".formularioVentaCot").on("change", "input.cantProdVentaCot", function() {

	var precio = $(this).parent().parent().children(".ingresoPrecioVentaCot").children().children(".precioProdVentaCot");
	var descuento = $(this).parent().parent().children(".ingresoDctoVentaCot").children().children(".dctoProdVentaCot");
	var nuevoStock = Number($(this).attr("stock")) - $(this).val();
	
	if(nuevoStock<0){ // EVITA QUE EL STOCK SEA MENOR QUE CERO
		$(this).attr("nuevoStock", 0);
	}else{
		$(this).attr("nuevoStock", nuevoStock);
	}


	if(nuevoStock<0){ // EVITA VENDER MAS DE LO QUE HAY EN STOCK EXISTENTE
		Swal.fire({
		  	icon: "error",
		  	title: "Solo quedan "+$(this).attr('max')+"u",
		  	showConfirmButton: true,
		  	confirmButtonText: "Cerrar"
		  	}).then(function(result){
				if(result.value) {
					$('#cantProdVentaCot').select();
				}
			})
		$(this).val($(this).attr('max'));

	}else if($(this).val()<=0){ // EVITA VENDER STOCK NEGATIVO
		$('#cantProdVentaCot').val(1);
	}

	var dcto = (Math.round((1-(Number(precio.attr('pCotizado'))/Number(precio.attr('precioReal'))))*10000))/100; //dcto con 2 decimales
	descuento.val(dcto);
	precioFinal = precio.attr('pCotizado')*$(this).val();  // SE MANTIENE PRECIO COTIZADO EN CUALQUIER STOCK
	precio.val(precioFinal);

	// CAMBIO DE EXISTENCIAS EN DESCRIPCION
	$(this).parent().parent().children(".descripcion").children().children().children().children('#existenciasCot').html('<b class="float-right" style="color:black">Lleva ('+$(this).val()+'/'+$(this).attr('cantCotizado')+')</b>')

	listarProdVentaCot()
	sumarTotalesVentaCot()
	calcularVueltoVentaCot()
	$('.metodoPagoVentaCot').val(''); // RESET METODO PAGO
	$('.cajasMetodoPagoVentaCot').html(''); // RESET METODO PAGO
})


/*=============================================
MODIFICAR PRECIO FLETE
=============================================*/
$(".formularioVentaCot").on("change", "input.precioProdVentaCot", function() {
	listarProdVentaCot()
	sumarTotalesVentaCot()
})

/*=============================================
SUMAR TODOS LOS PRECIOS
=============================================*/
function sumarTotalesVentaCot() {
  	var total = 0;
  	$(".precioProdVentaCot").each(function(){
		if (isNaN(parseInt($(this).val()))){
      		total += 0;
    	}else{
      		total += parseInt($(this).val());
    	}
  	});
	$("#totalVentaCot").val(total);
	$("#totVentaCotMostrar").text('   '+formatNumber.new(total));
}

/*=============================================
SELECCIONAR MÉTODO DE PAGO
=============================================*/
$("#metodoPagoVentaCot").change(function() {

	var metodo = $(this).val();
	var total = $("#totalVentaCot").val();
	if (metodo == "Efectivo") {
		$(".cajasMetodoPagoVentaCot").html(
            '<div class="col-6">'+
              	'<div class="mb-2"></div>'+
          		'<div class="form-group">'+
            		'<label>Efectivo ($)</label>'+
					'<input type="text" class="form-control efectivoVentaCotMostrar" id="efectivoVentaCotMostrar" name="efectivoVentaCotMostrar" placeholder="0" required onkeyup="formatoMiles($(this));" onkeypress="return soloNumeros(event)" onchange="sinFormatoMiles('+"'efectivoVentaCot'"+',$(this).val());calcularVueltoVentaCot();">'+
                    '<input type="hidden" id="efectivoVentaCot" name="efectivoVentaCot">'+
          		'</div>'+
        	'</div>'+
            '<div class="col-6" style="padding-right:0px">'+
              '<div class="mb-2"></div>'+
              '<div class="form-group">'+
                '<label>Vuelto ($)</label>'+
				'<input type="text" class="form-control vueltoEfectivoVentaCotMostrar" id="vueltoEfectivoVentaCotMostrar" name="vueltoEfectivoVentaCotMostrar" placeholder="0" readonly required>'+
				'<input type="hidden" id="vueltoEfectivoVentaCot" name="vueltoEfectivoVentaCot">'+
              '</div>'+
            '</div>')

	} else if (metodo == "E_TD") {
		$(".cajasMetodoPagoVentaCot").html(
			'<div class="col-4">' +
	          	'<div class="mb-2"></div>'+
	    		'<label>Efectivo ($)</label>'+
				'<div>' +
					'<input type="text" class="form-control efectivoCombTDVentaCotMostrar" id="efectivoCombTDVentaCotMostrar" name="efectivoCombTDVentaCotMostrar" placeholder="0" required onkeyup="formatoMiles($(this));" onkeypress="return soloNumeros(event)" onchange="listarMetodosVentaCot();sinFormatoMiles('+"'efectivoCombTDVentaCot'"+',$(this).val());calcVueltoTransbank('+"'TD'"+');">'+
                    '<input type="hidden" id="efectivoCombTDVentaCot" name="efectivoCombTDVentaCot">'+
				'</div>' +
			'</div>' +

			'<div class="col-4" id="cobrarTD" style="padding-left:0px">' +
	          	'<div class="mb-2"></div>'+
	    		'<label>Diferencia Tarjeta ($)</label>'+
				'<div>' +
					'<input type="text" class="form-control vueltoCombTDVentaCotMostrar" id="vueltoCombTDVentaCotMostrar" name="vueltoCombTDVentaCotMostrar" placeholder="0" required onkeyup="formatoMiles($(this));" onkeypress="return soloNumeros(event)" onchange="sinFormatoMiles('+"'vueltoCombTDVentaCot'"+',$(this).val());" readonly required>'+
                    '<input type="hidden" id="vueltoCombTDVentaCot" name="vueltoCombTDVentaCot">'+
				'</div>' +
			'</div>' +
			
			'<div class="col-4" id="cobrarTD" style="padding-left:0px">' +
	          	'<div class="mb-2"></div>'+
	    		'<label>Código Transacción</label>'+
				'<div>' +
					'<input type="text" class="form-control" id="codTransCombTDVentaCot" name="codTransCombTDVentaCot" maxlength="4" placeholder="4 últimos dígitos" onkeypress="return soloNumeros(event)" required>' +
				'</div>' +
			'</div>')

	} else if (metodo == "E_TC") {
		$(".cajasMetodoPagoVentaCot").html(
			'<div class="col-4">' +
	          	'<div class="mb-2"></div>'+
	    		'<label>Efectivo ($)</label>'+
				'<div>' +
					'<input type="text" class="form-control efectivoCombTCVentaCotMostrar" id="efectivoCombTCVentaCotMostrar" name="efectivoCombTCVentaCotMostrar" placeholder="0" required onkeyup="formatoMiles($(this));" onkeypress="return soloNumeros(event)" onchange="sinFormatoMiles('+"'efectivoCombTCVentaCot'"+',$(this).val());calcVueltoTransbank('+"'TC'"+');">'+
                    '<input type="hidden" id="efectivoCombTCVentaCot" name="efectivoCombTCVentaCot">'+
				'</div>' +
			'</div>' +

			'<div class="col-4" id="cobrarTD" style="padding-left:0px">' +
	          	'<div class="mb-2"></div>'+
	    		'<label>Diferencia Tarjeta ($)</label>'+
				'<div>' +
					'<input type="text" class="form-control vueltoCombTCVentaCotMostrar" id="vueltoCombTCVentaCotMostrar" name="vueltoCombTCVentaCotMostrar" placeholder="0" required onkeyup="formatoMiles($(this));" onkeypress="return soloNumeros(event)" onchange="sinFormatoMiles('+"'vueltoCombTCVentaCot'"+',$(this).val());" readonly required>'+
                    '<input type="hidden" id="vueltoCombTCVentaCot" name="vueltoCombTCVentaCot">'+
				'</div>' +
			'</div>' +
			
			'<div class="col-4" id="cobrarTD" style="padding-left:0px">' +
	          	'<div class="mb-2"></div>'+
	    		'<label>Código Transacción</label>'+
				'<div>' +
					'<input type="text" class="form-control" id="codTransCombTCVentaCot" name="codTransCombTCVentaCot" maxlength="4" placeholder="4 últimos dígitos" onkeypress="return soloNumeros(event)" required>' +
				'</div>' +
			'</div>')

	} else if (metodo == "TD" || metodo == "TC") {
		$('.cajasMetodoPagoVentaCot').html(
            '<div class="col-6">'+
              	'<div class="mb-2"></div>'+
          		'<div class="form-group">'+
            		'<label>Código Transacción</label>'+
					'<input type="text" class="form-control" id="codTransbankVentaCot" name="codTransbankVentaCot" maxlength="4" placeholder="4 últimos dígitos" onkeypress="return soloNumeros(event)" required>'+
          		'</div>'+
            '</div>')

	} else if (metodo == "Transferencia") {
		$('.cajasMetodoPagoVentaCot').html(
            '<div class="col-6">'+
              	'<div class="mb-2"></div>'+
          		'<div class="form-group">'+
            		'<label>Monto Transferencia ($)</label>'+
					'<input type="text" class="form-control transferenciaVentaCotMostrar" id="transferenciaVentaCotMostrar" placeholder="0" value="'+formatNumber.new(total)+'" required disabled>'+
                    '<input type="hidden" id="transferenciaVentaCot" name="transferenciaVentaCot" value="'+total+'">'+

          		'</div>'+
            '</div>')

	} else if (metodo == "Fiado") {
		$('.cajasMetodoPagoVentaCot').html(
            '<div class="col-6">'+
              	'<div class="mb-2"></div>'+
          		'<div class="form-group">'+
            		'<label>Crédito Interno</label>'+
					'<input type="text" class="form-control creditoInternoVentaCotMostrar" id="creditoInternoVentaCotMostrar"  placeholder="0" value="'+formatNumber.new(total)+'" required disabled>'+
                    '<input type="hidden" id="creditoInternoVentaCot" name="creditoInternoVentaCot" value="'+total+'">'+
          		'</div>'+
            '</div>')

	} else if (metodo == "Pend") {
		$('.cajasMetodoPagoVentaCot').html(
            '<div class="col-6">'+
              	'<div class="mb-2"></div>'+
          		'<div class="form-group">'+
            		'<label>Pago Pendiente ($)</label>'+
					'<input type="text" class="form-control pendienteVentaCotMostrar" id="pendienteVentaCotMostrar"  placeholder="0" value="'+formatNumber.new(total)+'" required disabled>'+
                    '<input type="hidden" id="pendienteVentaCot" name="pendienteVentaCot" value="'+total+'">'+
          		'</div>'+
            '</div>')

	} else {
		$('.cajasMetodoPagoVentaCot').html('');
	}
})

/*=============================================
CALCULO DEL VUELTO EN EFECTIVO
=============================================*/
function calcularVueltoVentaCot(){

	var total = $('#totalVentaCot').val();
	var efectivo = $('#efectivoVentaCot').val();
	var cambio = Number(efectivo) - Number(total);
	if (total == 0) {
        var audio = new Audio('componentes/sonidos/error.wav');
        audio.play();
        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe contener productos la Venta'});

	} else if (total > 0 && cambio < 0) {
        var audio = new Audio('componentes/sonidos/error.wav');
        audio.play();
        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Falta Dinero'});

		$('#efectivoVentaCot').val(0);
		$('#efectivoVentaCotMostrar').val(0);
		$('#vueltoEfectivoVentaCot').val(0);
		$('#vueltoEfectivoVentaCotMostrar').val(0);
		$('#efectivoVentaCotMostrar').select();
	} else {
		$('#vueltoEfectivoVentaCot').val(cambio);
		$('#vueltoEfectivoVentaCotMostrar').val(formatNumber.new(cambio,''));
	}

	$('#transferenciaVentaCot').val(total);
	$('#creditoInternoVentaCot').val(total);
	listarMetodosVentaCot()
}

/*=============================================
DIFERENCIA PAGO COMBINADO TD
=============================================*/
function calcVueltoTransbank(tarjeta){
	var cash = $("#efectivoComb"+tarjeta+"VentaCot");
	var cashMostrar = $("#efectivoComb"+tarjeta+"VentaCotMostrar");
	var cambio = $("#totalVentaCot").val() - cash.val();
	var diferenciaTransbank = $("#efectivoComb"+tarjeta+"VentaCot").parent().parent().parent().children('#cobrarTD').children().children("#vueltoComb"+tarjeta+"VentaCot");
	var diferenciaTransbankMostrar = $("#efectivoComb"+tarjeta+"VentaCot").parent().parent().parent().children('#cobrarTD').children().children("#vueltoComb"+tarjeta+"VentaCotMostrar");
	if (cambio < 0) {
		Swal.fire({
			title: "El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta",
			icon: "error",
			confirmButtonText: "¡Cerrar!"
		});
		cash.val(0);
		cashMostrar.val(0);
		diferenciaTransbank.val(0);
		diferenciaTransbankMostrar.val(0);
	} else {
		diferenciaTransbankMostrar.val(formatNumber.new(cambio));
		diferenciaTransbank.val(cambio);
	}
}

/*=============================================
LISTAR TODOS LOS PRODUCTOS
=============================================*/
function listarProdVentaCot() {
	var listaProductos = [];
	var descripcion = $(".prodVentaCot");
	var cantidad = $(".cantProdVentaCot");
	var precio = $(".precioProdVentaCot");
	var descuento = $(".dctoProdVentaCot");
	var subtotal = 0;
  	var skuFlete = ajuste('sku_flete');
	var detectaFlete = 0;


	for (var i = 0; i < descripcion.length; i++) {

		if($(cantidad[i]).val()>0){ //SOLO LISTA LOS PRODUCTOS VENDIDOS QUE HAY EN STOCK
			listaProductos.push({
				"id": $(descripcion[i]).attr("idProducto"),
				"sku": $(descripcion[i]).attr("codigoInterno"),
				"cant": $(cantidad[i]).val(),
				"prod": $(descripcion[i]).val(),
				"pC": $(precio[i]).attr("precioCompra"),
				"pV": $(precio[i]).val()/$(cantidad[i]).val(),
				"tot": $(precio[i]).val(),
				"dcto": $(descuento[i]).val()
			})
		}
		subtotal = Number(subtotal) + Number($(precio[i]).val());

		if($(descripcion[i]).attr("codigoInterno") == skuFlete){
			detectaFlete += 1;
		}else{
			detectaFlete += 0
		}
	}
	$("#listaProdsVentaCot").val(JSON.stringify(listaProductos));

	$('.incluyeFlete').val(detectaFlete);
	sumarTotalesVentaCot();

}


/*=============================================
BOTON EDITAR VENTA
=============================================*/
$(".tablaVentas").on("click", ".botonGuardaVenta", function() {

	listarMetodosVentaCot();

})

/*=============================================
BOTON EDITAR VENTA
=============================================*/
$(".tablaVentas").on("click", ".btnDevProds", function() {
    var id = $(this).attr('codigoVenta');
    var ruta="id="+id;
    window.open("index.php?ruta=dev-prods&"+ruta,"_blank");
})


function boletaOFacturaVentaCot(metPago){


	Swal.fire({
		icon:'question',
	  	title: "<h1>¿Boleta o Factura?</h1>",
	  	showDenyButton: true,
	  	confirmButtonText: 'Boleta',
	  	denyButtonText: 'Factura',
	  	customClass: {
	    	actions: 'my-actions',
	    	cancelButton: 'order-1 right-gap boton-cancelar',
	    	confirmButton: 'order-2 btn boton-confirmar',
	    	denyButton: 'order-3 btn boton-denegar',
	    	title: 'titulo-modif',
	  	}

	}).then((result) => {
	  	if (result.isConfirmed) { // BOLETA
	    	enviarVentaCot()

	  	} else if (result.isDenied) { // FACTURA
	  		rutFacturarCliente = $('.rutFacturarCliente').val();
			Swal.fire({
		        title: "Rut a Facturar",
		        input: "text",
		        inputValue: rutFacturarCliente,
				inputAttributes: {
				    maxlength: 10,
				    placeholder: 'Formato: 18817715-8',
				    onkeypress: "return soloRut(event)"
				},
		        confirmButtonText: "Ok",
				showCancelButton: true,
				cancelButtonText: 'Cancelar',
		        inputValidator: inputRut => {

					rutDigitado = inputRut.split('-');
					rut = rutDigitado[0].split("").reverse().join("");
					dv = rutDigitado[1];
					multiplicadores = [2,3,4,5,6,7];
					sumaTotal = 0;
					j = 0;
					for (var i = 0; i < rut.length; i++){
					    sumaTotal += Number(rut[i]) * Number(multiplicadores[j]);
					    j = Number(i) == 5 ? 0 : j=j+1;
					}
					dvCalculado = 11-Math.trunc(sumaTotal)%11

					if(Number(dvCalculado) == 11){
						dvComparar = 0;
					}else if(Number(dvCalculado) == 10){
						dvComparar = 'k';
					}else{
						dvComparar = dvCalculado;
					}

					if(dvComparar == dv){
						$('#rutFacturaVentaCot').val(inputRut);
		        		enviarVentaCot();
					}else{
		        		return "Escriba el rut en el formato: 18817715-8";
					}

		        }
		    })
	  	}
	})

}


/*=============================================
ANTES DE ENVIAR FORMULARIO
=============================================*/
function enviarVentaCot(){
	listarProdVentaCot();
	var listaProductos = $("#listaProdsVentaCot").val();
	var metodo = $("#metodoPagoVentaCot").val();
	var efectivo = $("#efectivoVentaCot").val();
	var efectivoTD = $("#efectivoCombTDVentaCot").val();
	var efectivoTC = $("#efectivoCombTCVentaCot").val();
	var codigoTD = $("#codTransCombTDVentaCot").val();
	var codigoTC = $("#codTransCombTCVentaCot").val();
	var codigoTarjeta = $("#codTransbankVentaCot").val();
	var vueltoE_TD = $("#vueltoCombTDVentaCot").val();
	var vueltoE_TC = $("#vueltoCombTCVentaCot").val();
	var totalVenta = $("#totalVentaCot").val();
	var transferencia = $("#transferenciaVentaCot").val();
	// comprobar required en detalleVenta
	var requerido = $("#detalleVenta").attr('required');

 	if (requerido == "required" && $("#detalleVenta").val() == "") {

		Swal.fire({
			title: "Ingrese el Destino del Flete",
			icon: "error",
			confirmButtonText: "¡Cerrar!"
		});

	} else if (metodo == "") {

		Swal.fire({
			title: "Debe elegir algún metodo de pago",
			icon: "error",
			confirmButtonText: "¡Cerrar!"
		});

	} else {


		if (metodo == "Efectivo" && (efectivo == "" || efectivo == 0)) {
	        var audio = new Audio('componentes/sonidos/error.wav');
	        audio.play();
	        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese el dinero en efectivo'});

			$("#efectivoVentaCot").select();

		} else if ((metodo == "TD" || metodo == "TC") && (codigoTarjeta == "" || codigoTarjeta.length < 4)) {
			Swal.fire({
				title: "Falta ingresar los 4 últimos dígitos de la transacción",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "Fiado" && ($('#selecClientVentaCot').val() == 1)) {
			Swal.fire({
				title: "Crédito Interno, necesario asignar venta a un Cliente",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "E_TD" && (efectivoTD == "" && codigoTD.length < 4)) {

				Swal.fire({
					title: "Debe ingresar el dinero en efectivo junto con los 4 últimos dígitos de la transacción",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});

		} else if (metodo == "E_TD" && (efectivoTD == "" && codigoTD.length == 4)) {

			
				Swal.fire({
					title: "Debe ingresar el dinero en efectivo",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});

		} else if (metodo == "E_TD" && (efectivoTD == 0 && codigoTD.length < 4)) {
				Swal.fire({
					title: "El dinero en efectivo tiene que ser mayor que 0 e inferior al valor total, además debe ingresar los 4 últimos dígitos de la transacción",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});
				$("#efectivoCombTDVentaCot").val(0);
				$("#vueltoCombTDVentaCot").val(0);

		} else if (metodo == "E_TD" && (efectivoTD == 0 && codigoTD.length == 4)) {

				Swal.fire({
					title: "El dinero en efectivo tiene que ser mayor que 0 e inferior al valor total",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});

		} else if (metodo == "E_TD" && (vueltoE_TD < 0 && codigoTD.length == 4)) {
				Swal.fire({
					title: "El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});
				$("#efectivoCombTDVentaCot").val(0);
				$("#vueltoCombTDVentaCot").val(0);

		} else if (metodo == "E_TD" && (vueltoE_TD < 0 && codigoTD.length < 4)) {

				Swal.fire({
					title: "El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta, además debe ingresar los 4 últimos dígitos de la transacción",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});
				$("#efectivoCombTDVentaCot").val(0);
				$("#vueltoCombTDVentaCot").val(0);
		} else if (metodo == "E_TD" && (vueltoE_TD > 0 && codigoTD.length < 4)) {

				Swal.fire({
					title: "Debe ingresar los 4 últimos dígitos de la transacción",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});

		} else if (metodo == "E_TC" && (efectivoTC == "" && codigoTC.length < 4)) {


				Swal.fire({
					title: "Debe ingresar el dinero en efectivo junto con los 4 últimos dígitos de la transacción",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});

		} else if (metodo == "E_TC" && (efectivoTC == "" && codigoTC.length == 4)) {
				Swal.fire({
					title: "Debe ingresar el dinero en efectivo",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});
		} else if (metodo == "E_TC" && (efectivoTC == 0 && codigoTC.length < 4)) {
				Swal.fire({
					title: "El dinero en efectivo tiene que ser mayor que 0 e inferior al valor total, además debe ingresar los 4 últimos dígitos de la transacción",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});
				$("#efectivoCombTCVentaCot").val(0);
				$("#vueltoCombTCVentaCot").val(0);

		} else if (metodo == "E_TC" && (efectivoTC == 0 && codigoTC.length == 4)) {
				Swal.fire({
					title: "El dinero en efectivo tiene que ser mayor que 0 e inferior al valor total",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});

		} else if (metodo == "E_TC" && (efectivoTC < 0 && codigoTC.length == 4)) {
				Swal.fire({
					title: "El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});
				$("#efectivoCombTCVentaCot").val(0);
				$("#vueltoCombTCVentaCot").val(0);
		} else if (metodo == "E_TC" && (efectivoTC < 0 && codigoTC.length < 4)) {

				Swal.fire({
					title: "El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta, además debe ingresar los 4 últimos dígitos de la transacción",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});
				$("#efectivoCombTCVentaCot").val(0);
				$("#vueltoCombTCVentaCot").val(0);
		} else if (metodo == "E_TC" && (efectivoTC > 0 && codigoTC.length < 4)) {
				Swal.fire({
					title: "Debe ingresar los 4 últimos dígitos de la transacción",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});


		} else if (metodo == "Transferencia" && transferencia == "") {

				Swal.fire({
					title: "ERROR",
					text: "Debe ingresar el Valor Transferido",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});

		} else if (metodo == "Transferencia" && transferencia < totalVenta) {

				Swal.fire({
					title: "ERROR",
					text: "El Valor Transferido no puede ser inferior al Total de la Venta",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});
		} else if (metodo == "Transferencia" && transferencia > totalVenta) {

				Swal.fire({
					title: "ERROR",
					text: "El Valor Transferido no puede ser superior al Total de la Venta. ESTE METODO NO ACEPTA DAR VUELTO",
					icon: "error",
					confirmButtonText: "¡Cerrar!"
				});

		} else if (metodo == "Pend" && ($('#selecClientVentaCot').val() == 1 && $('#detalleVentaCot').val() == '')) {
	        var audio = new Audio('componentes/sonidos/error.wav');
	        audio.play();
	        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Asigne algún dato para identificar quién adeuda'});
			$('#detalleVentaCot').select();

		} else {
			// detalleFlete = $('.detalleFlete').val().split(' // ');
			// nombreDespacho = detalleFlete[0];
			// nroDespacho = detalleFlete[1] == undefined ? '' : detalleFlete[1];
			// direccionDespacho = detalleFlete[2] == undefined ? '' : detalleFlete[2];

			if($('.incluyeFlete').val() == 1){ // DETECTA FLETE PARA FLETE
				nombreDespacho = infoCliente($('#selecClientVentaCot').val())['id'] == 1 ? '' : infoCliente($('#selecClientVentaCot').val())['nombre'].toUpperCase()+' '+infoCliente($('#selecClientVentaCot').val())['apellido'].toUpperCase();
				nroDespacho = infoCliente($('#selecClientVentaCot').val())['id'] == 1 ? '' : infoCliente($('#selecClientVentaCot').val())['telefono'];
				direccionDespacho = infoCliente($('#selecClientVentaCot').val())['id'] == 1 ? '' : infoCliente($('#selecClientVentaCot').val())['direccion'];

				(async () => {

					const { value: formValues } = await Swal.fire({
				  		title: 'Datos Despacho',
				  		html:
				    		'<input id="swal-input1" class="swal2-input" placeholder="Nombre" maxlength="30" value="'+nombreDespacho+'">' +
				    		'<input id="swal-input2" class="swal2-input" placeholder="Fono (Ej: 938714443)" maxlength="9" value="'+nroDespacho+'">' +
				    		'<input id="swal-input3" class="swal2-input" placeholder="Dirección" maxlength="50" value="'+direccionDespacho+'">',
				  		focusConfirm: false,
				  		preConfirm: () => {
				    		return [
				      			$('#swal-input1').val(),
				      			$('#swal-input2').val(),
				      			$('#swal-input3').val()
				    		]
				  		}
					})

					if (formValues) {
						$('.detalleFlete').val(formValues[0]+' // '+formValues[1]+' // '+formValues[2]);
						listarMetodosVentaCot();
						clienteVentaCot();
						document.forms[0].submit();
					}

				})()

			}else{
				$('.detalleFlete').val('');
				listarMetodosVentaCot();
				clienteVentaCot();
				document.forms[0].submit();

			}

		}
	


	}

}

// /*====================================================================================
// NUMEROS CON SEPARACION DE MILES CON PUNTO (UTILIZAR: formatNumber.new(NUMERO, "$ "))
// ====================================================================================*/
// var formatNumber = {
// 	separador: ".", // separador para los miles
// 	sepDecimal: ',', // separador para los decimales
// 	formatear: function(num) {
// 		num += '';
// 		var splitStr = num.split('.');
// 		var splitLeft = splitStr[0];
// 		var splitRight = splitStr.length > 1 ? this.sepDecimal + splitStr[1] : '';
// 		var regx = /(\d+)(\d{3})/;
// 		while (regx.test(splitLeft)) {
// 			splitLeft = splitLeft.replace(regx, '$1' + this.separador + '$2');
// 		}
// 		return this.simbol + splitLeft + splitRight;
// 	},
// 	new: function(num, simbol) {
// 		this.simbol = simbol || '';
// 		return this.formatear(num);
// 	}
// }

/*=============================================
LISTAR MÉTODO DE PAGO
=============================================*/
function listarMetodosVentaCot() {
	var listaMetodos = "";
	var metodo = $("#metodoPagoVentaCot").val();
	if (metodo == "Efectivo") {
		var totalSinRedondeo = $("#totalVentaCot").val();
		var resto = totalSinRedondeo % 10;
		if (resto < 6) {
			var totalRedondeado = totalSinRedondeo - resto;
			var vueltoRedondeado = $("#efectivoVentaCot").val() - totalRedondeado;
		} else {
			var totalRedondeado = Number(totalSinRedondeo) + 10 - Number(resto);
			var vueltoRedondeado = $("#efectivoVentaCot").val() - totalRedondeado;
		}
		$('#detPagoVentaCot').val('[{"cash":"' + $('#efectivoVentaCot').val() + '","total":"' + totalRedondeado + '","vuelto":"' + vueltoRedondeado + '"}]');
	} else if (metodo == 'E_TD') {
		$('#detPagoVentaCot').val('[{"cash":"' + $('#efectivoCombTDVentaCot').val() + '","tarjeta":"' + $('#vueltoCombTDVentaCot').val() + '","cod":"' + $('#codTransCombTDVentaCot').val() + '"}]');
	} else if (metodo == 'E_TC') {
		$('#detPagoVentaCot').val('[{"cash":"' + $('#efectivoCombTCVentaCot').val() + '","tarjeta":"' + $('#vueltoCombTCVentaCot').val() + '","cod":"' + $('#codTransCombTCVentaCot').val() + '"}]');
	} else if (metodo == "TC") {
		$("#detPagoVentaCot").val(metodo + "-" + $("#codTransbankVentaCot").val());
	} else if (metodo == "TD") {
		$("#detPagoVentaCot").val(metodo + "-" + $("#codTransbankVentaCot").val());
	} else if (metodo == "Transferencia"){
		$("#detPagoVentaCot").val($("#transferenciaVentaCot").val());
	} else if (metodo == "Fiado") {
		$("#detPagoVentaCot").val($('#creditoInternoVentaCot').val());
		$('#fiadoVentaCot').val($('#creditoInternoVentaCot').val());
	} else if (metodo == "Pend") {
		$("#detPagoVentaCot").val($("#pendienteVentaCot").val());		
	} else {
		$('#fiadoVentaCot').val('');
	}

}

/*=============================================
NOMBRE CLIENTE
=============================================*/
function clienteVentaCot() {
	$("#nomClientVentaCot").val($("#selecClientVentaCot option:selected").text());	
}

/*=============================================
FUNCIÓN PARA DESACTIVAR LOS BOTONES AGREGAR CUANDO EL PRODUCTO YA HABÍA SIDO SELECCIONADO EN LA CARPETA
=============================================*/

function quitarAgregarProductoVentaCot() {

	//Capturamos todos los id de productos que fueron elegidos en la venta
	var idProductos = $(".quitarProdVentCot");

	//Capturamos todos los botones de agregar que aparecen en la tabla
	var botonesTabla = $(".tablaVentaCotProductos tbody button.agregarProducto");

	//Recorremos en un ciclo para obtener los diferentes idProductos que fueron agregados a la venta
	for (var i = 0; i < idProductos.length; i++) {

		//Capturamos los Id de los productos agregados a la venta
		var boton = $(idProductos[i]).attr("idProducto");

		//Hacemos un recorrido por la tabla que aparece para desactivar los botones de agregar
		for (var j = 0; j < botonesTabla.length; j++) {

			if ($(botonesTabla[j]).attr("idProducto") == boton) {

				$(botonesTabla[j]).removeClass("btn-primary agregarProducto");
				$(botonesTabla[j]).addClass("btn-default");

			}
		}

	}

}

/*========================================================================
CADA VEZ QUE CARGUE LA TABLA CUANDO NAVEGAMOS EN ELLA EJECUTAR LA FUNCIÓN:
========================================================================*/
$('.tablaVentaCotProductos').on('draw.dt', function() {

	quitarAgregarProductoVentaCot();

})


/*=============================================
RANGO DE FECHAS
=============================================*/

$('#daterange-btn').daterangepicker({
		ranges: {
			'Hoy': [moment(), moment()],
			'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
			'Últimos 7 días': [moment().subtract(6, 'days'), moment()],
			'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
			'Este mes': [moment().startOf('month'), moment().endOf('month')],
			'Último mes': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
		},
		startDate: moment(),
		endDate: moment()
	},
	function(start, end) {
		$('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));

		var fechaInicial = start.format('YYYY-MM-DD');

		var fechaFinal = end.format('YYYY-MM-DD');

		var capturarRango = $("#daterange-btn span").html();

		localStorage.setItem("capturarRango", capturarRango);

		window.location = "index.php?ruta=ventas&fechaInicial=" + fechaInicial + "&fechaFinal=" + fechaFinal;

	}

)

/*=============================================
CANCELAR RANGO DE FECHAS
=============================================*/
$(".daterangepicker.opensleft .range_inputs .cancelBtn").on("click", function() {
	localStorage.removeItem("capturarRango");
	localStorage.clear();
	window.location = "ventas";
})

/*=============================================
CAPTURAR HOY
=============================================*/

$(".daterangepicker.opensleft .ranges li").on("click", function() {

	var textoHoy = $(this).attr("data-range-key");

	if (textoHoy == "Hoy") {

		var d = new Date();

		var dia = d.getDate();
		var mes = d.getMonth() + 1;
		var año = d.getFullYear();

		// if(mes < 10){

		// 	var fechaInicial = año+"-0"+mes+"-"+dia;
		// 	var fechaFinal = año+"-0"+mes+"-"+dia;

		// }else if(dia < 10){

		// 	var fechaInicial = año+"-"+mes+"-0"+dia;
		// 	var fechaFinal = año+"-"+mes+"-0"+dia;

		// }else if(mes < 10 && dia < 10){

		// 	var fechaInicial = año+"-0"+mes+"-0"+dia;
		// 	var fechaFinal = año+"-0"+mes+"-0"+dia;

		// }else{

		// 	var fechaInicial = año+"-"+mes+"-"+dia;
		//    	var fechaFinal = año+"-"+mes+"-"+dia;

		// }

		dia = ("0" + dia).slice(-2);
		mes = ("0" + mes).slice(-2);

		var fechaInicial = año + "-" + mes + "-" + dia;
		var fechaFinal = año + "-" + mes + "-" + dia;

		localStorage.setItem("capturarRango", "Hoy");

		window.location = "index.php?ruta=ventas&fechaInicial=" + fechaInicial + "&fechaFinal=" + fechaFinal;

	}

})

/*=============================================
ABRIR ARCHIVO XML EN NUEVA PESTAÑA
=============================================*/
$(".abrirXML").click(function() {
	var archivo = $(this).attr("archivo");
	window.open(archivo, "_blank");
})

// ACTUALIZAR TABLA PRODUCTOS
$('#actualizarTablaProductosVentaCot').click(function(){
	$('.tablaVentaCotProductos').DataTable().ajax.reload();	
})
