$('.tblProveedoresMovil').DataTable( {
    "deferRender": true,
    "retrieve": true,
    "processing": true,
    "pageLength": 25,
    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "&rarr;",
        "sPrevious": "&larr;"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }

    },
    dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',
});

/*=============================================
EDITAR PROVEEDOR
=============================================*/
$(".tablas").on("click", ".btnEditarProveedor", function(){

	var idProveedor = $(this).attr("idProveedor");

	var datos = new FormData();
    datos.append("idProveedor", idProveedor);


    $.ajax({

      url:"ajax/proveedores.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
      success:function(respuesta){
        $("#idProveedor").val(respuesta["id"]);
        $("#editarAliasProveedor").val(respuesta["alias_empresa"]);
        $("#editarNombreProveedor").val(respuesta["nombre_empresa"]);
        $("#editarNombreResponsable").val(respuesta["nombre"]);
        $("#editarDiasCredito").val(respuesta["dias_credito"]);
        $("#editarRutProveedor").val(respuesta["rut"]);
        $("#editarEmailProveedor").val(respuesta["correo"]);
        $("#editarTelefonoProveedor").val(respuesta["telefono"]);
        $("#editarDireccionProveedor").val(respuesta["direccion"]);
      }
  	})
})


/*=============================================
ELIMINAR PROVEEDOR
=============================================*/
$(".tablas").on("click", ".btnEliminarProveedor", function(){

	var idProveedor = $(this).attr("idProveedor");
	
	Swal.fire({
        title: '¿Está seguro de borrar el proveedor?',
        text: "¡Si no lo está puede cancelar la acción!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, borrar proveedor!'
      }).then(function(result){
        if (result.value) {
          
            window.location = "index.php?ruta=proveedores&idProveedor="+idProveedor;
        }

  })

})