$("#agregarProd").click(function() {

  var datos = new FormData();

  // 1. Recolectar todos los campos por ID:
  var datos2 = {
    provProdDB: $("#provProdDB").val(),
    proveedorProducto: $("#proveedorProducto").val(),
    catDB: $("#catDB").val(),
    subcatDB: $("#subcatDB").val(),
    nuevaCategoria: $("#nuevaCategoria").val(),
    nuevaSubcategoria: $("#nuevaSubcategoria").val(),  
    nuevoCodigo: $("#nuevoCodigo").val(),
    codigoProveedor: $("#codigoProveedor").val(),
    nuevaDescripcion: $("#nuevaDescripcion").val(),
    descripcionAlternativa: $("#descripcionAlternativa").val(),
    descripcionSii: $("#descripcionSii").val(),
    manejaStock: $("#manejaStock").val(),
    nuevoStockIdeal: $("#stockIdeal").val(),
    embalajeCompraProd: $("#embalajeCompraProd").val(),
    zonaEntregaProd: $("#zonaEntregaProd").val(),
    nuevoPrecioCompraNeto: $("#nuevoPrecioCompraNeto").val(),
    nuevoPrecioCompra: $("#nuevoPrecioCompra").val(),
    nuevoPrecioVenta: $("#nuevoPrecioVenta").val(),
    descuentoMaximo: $("#descuentoMaximo").val(),
    precioMayor: $("#precioMayor").val(),
    mayoreo: $("#mayoreo").val(),
    codigoInterno2: $("#codigoInterno2").val()
  };

  $.each(datos2, function(key, value) {
    datos.append(key, value);
  });

  var $inputImagen = document.querySelector("#nuevaImagen");
  const imagenSubir = $inputImagen.files;
  for (const archivo of imagenSubir) { // Agregamos cada archivo a "archivos[]". Los corchetes son importantes
      datos.append("nuevaImagen", archivo);
  }

  Swal.fire({
    title: 'Creando producto...',
    text: 'Espere un momento',
    allowOutsideClick: false,
    allowEscapeKey: false,
    allowEnterKey: false,
    didOpen: () => {
      Swal.showLoading();
    }
  });

  $.ajax({
    url:'ajax/productos.ajax.php',
    method: 'POST',
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success: function(respuesta) {

      let r = respuesta.split('///');
      if(r[0] == 'ok'){

        let jsonProd = JSON.parse(r[2]);
        let datosProducto = jsonProd.data[0];
        let tabla = $('.tablaProductosAdmin').DataTable();
        $('#formAddProd')[0].reset();
        $('.previsualizar').attr('src','componentes/img/productos/default/anonymous.png');
        tabla.row.add( datosProducto ).draw(false);
        $('#modalAgregarProducto').modal('hide');
        Swal.close();
        audioSuccess("Producto creado correctamente");
      
      }
    }
  })
});



$("#editarProd").click(function() {

  var idProd = $("#idProductoEditar").val();

  var datos = new FormData();
  datos.append('editarProd', $("#idProductoEditar").val());

  // 1. Recolectar todos los campos por ID:
  var datos2 = {
    imagenActual: $("#imagenActual").val(),
    editarManejaStock: $("#editarManejaStock").val(),
    editarStockIdeal: $("#editarStockIdeal").val(),
    editarEmbalajeCompraProd: $("#editarEmbalajeCompraProd").val(),
    editarZonaEntregaProd: $("#editarZonaEntregaProd").val(),
  
    editarDescripcion: $("#editarDescripcion").val(),
    nombreAlternativo: $("#nombreAlternativo").val(),
    editarDescSii: $("#editarDescSii").val(),
    codigo: $("#idProductoEditar").val(),
    codigoProveedorEditar: $("#codigoProveedorEditar").val(),
    editarProveedorProducto: $("#editarProveedorProducto").val(),
    nomProvEdit: $("#nomProvEdit").val(),
    editarDescuentoMaximo: $("#editarDescuentoMaximo").val(),
    editarPrecioCompra: $("#editarPrecioCompra").val(),
    editarPrecioCompraNeto: $("#editarPrecioCompraNeto").val(),
    editarPrecioVenta: $("#editarPrecioVenta").val(),
    editarMayoreo: $("#editarMayoreo").val(),
    editarPrecioMayor: $("#editarPrecioMayor").val(),
    editarCodigoInterno: $("#editarCodigoInterno").val(),
    editarUbicacion: $("#editarUbicacion").val()
  };

  $.each(datos2, function(key, value) {
    datos.append(key, value);
  });

  var $inputImagen = document.querySelector("#editarImagen");
  const imagenSubir = $inputImagen.files;
  for (const archivo of imagenSubir) { // Agregamos cada archivo a "archivos[]". Los corchetes son importantes
      datos.append("editarImagen", archivo);
  }

  Swal.fire({
    title: 'Modificando producto...',
    text: 'Espere un momento',
    allowOutsideClick: false,
    allowEscapeKey: false,
    allowEnterKey: false,
    didOpen: () => {
      Swal.showLoading();
    }
  });

  $.ajax({
    url:'ajax/productos.ajax.php',
    method: 'POST',
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success: function(respuesta) {

      let r = respuesta.split('///');
      if(r[0] == 'ok'){

        let jsonProd = JSON.parse(r[1]);
        let datosProducto = jsonProd.data[0];
        let tabla = $('.tablaProductosAdmin').DataTable();
        tabla.row( $('#row-' + idProd) )
             .data( datosProducto )
             .draw(false);
        $('#formEditProd')[0].reset();
        $('.previsualizar').attr('src','componentes/img/productos/default/anonymous.png');
        $('#modalEditarProducto').modal('hide');
        Swal.close();
        audioSuccess("Producto Editado correctamente");
      
      }
    }
  })
});

$('.modalProds').on('hidden.bs.modal', function (e) { // detecta click a fuera
  $('.previsualizar').attr('src','componentes/img/productos/default/anonymous.png');
});

function traerTodosLosProds(){
  var datos = new FormData();
  datos.append('traerProds', 'todos');
  $.ajax({
    url:'ajax/productos.ajax.php',
    method: 'POST',
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType:'json',
    success:function(r){
      return r;
    }
  })
}

var ventana = window.location.pathname.split('/')[2];
var perfilVend = $("#perfilVend").val();
var contador = 0;

/*========================= ACTUALIZACIONES AJAX ===========================================================================================================================================*/
/*---------------------------------------------
ACTUALIZAR PRECIO VENTA
---------------------------------------------*/
$('.tablaProductosAdmin').on("dblclick", ".btnEditPVenta", function(){
  var idProd = $(this).attr('idProd');
  var nombreIdentificador = 'PrecioVentaProd';
  contador++;
  if(contador==1){
    localStorage.setItem("primerId"+nombreIdentificador, idProd);
    let datosProd = infoProd(idProd);
    $('#pVenta'+idProd).html(

      '$ Normal<input type="text" style="width:110px" class="form-control input-xs" id="pVentaUnit" idProd="'+idProd+'" placeholder="Precio Venta" '+
      'onkeypress="return soloNumeros(event)" value="'+datosProd['precio_venta']+'" required>'+
      '$ Mayor<input type="text" style="width:110px" class="form-control input-xs" id="pVMayor" idProd="'+idProd+'" placeholder="Precio Mayor" '+
      'onkeypress="return soloNumeros(event)" value="'+datosProd['precio_mayor']+'" required><br>'+
      '<button style="width:60%" class="btn btn-info btn-xs editPVenta input-seguido" id="editPVenta'+idProd+'" idProd="'+idProd+'"><font size="-1">Actualizar</font></button>'+
      '<button style="width:30%" class="btn btn-danger btn-xs cancelarEditPVenta" idProd="'+idProd+'"><i class="fa fa-times"></i></button>');

  }else if(contador==2){
    localStorage.setItem("ultimoId"+nombreIdentificador, idProd);
  }else{
    localStorage.setItem("primerId"+nombreIdentificador, localStorage.getItem("ultimoId"+nombreIdentificador));
    localStorage.setItem("ultimoId"+nombreIdentificador, idProd);
  }
  if(contador != 1){
    // A LA NORMALIDAD EL BOTON ANTERIOR
    datosProd = infoProd(localStorage.getItem('primerId'+nombreIdentificador));
    $('#pVenta'+localStorage.getItem("primerId"+nombreIdentificador)).html(
      '<div class="btnEditPVenta" idProd="'+localStorage.getItem('primerId'+nombreIdentificador)+'"><b>VENTA</b><br>'+
        formatNumber.new(datosProd['precio_venta'], "$ ")+'<br>'+
        '<font style="color:blue"><b>&uarr; '+datosProd['mayor_sobre']+'u '+formatNumber.new(datosProd['precio_mayor'], "$ ")+'</b><br></font>'+
        '<font size="-1">MAX DCTO: '+datosProd['descuento']+'%</font><br>'+
      '</div>'+
      '<div class="btn-group float-right">'+
        '<button class="btn btn-default btn-xs btnMayDesdMenos" idProd="'+localStorage.getItem('primerId'+nombreIdentificador)+'">&darr;</button>'+
        '<button class="btn btn-default btn-xs btnMayDesdMas" idProd="'+localStorage.getItem('primerId'+nombreIdentificador)+'">&uarr;</button>'+
      '</div>')
    localStorage.setItem("ultimoId"+nombreIdentificador, idProd);
    datosProd = infoProd(idProd);
    $('#pVenta'+idProd).html(
      '<input type="text" style="width:110px" class="form-control input-xs" id="pVentaUnit" idProd="'+idProd+'" placeholder="Precio Venta" '+
      'onkeypress="return soloNumeros(event)" value="'+datosProd['precio_venta']+'" required><br>'+
      '<input type="text" style="width:110px" class="form-control input-xs" id="pVMayor" idProd="'+idProd+'" placeholder="Precio Mayor" '+
      'onkeypress="return soloNumeros(event)" value="'+datosProd['precio_mayor']+'" required><br>'+
      '<button style="width:60%" class="btn btn-info btn-xs editPVenta input-seguido" id="editPVenta'+idProd+'" idProd="'+idProd+'"><font size="-1">Actualizar</font></button>'+
      '<button style="width:30%" class="btn btn-danger btn-xs cancelarEditPVenta" idProd="'+idProd+'"><i class="fa fa-times"></i></button>');
  }
  $('#pVentaUnit').select();
})

// CANCELAR EDIT PRECIO VENTA
$(".tablaProductosAdmin").on("click", ".cancelarEditPVenta", function(){
  let idProd = $(this).attr('idProd');
  let datosProd = infoProd(idProd);
  $('#pVenta'+idProd).html(  
    '<div class="btnEditPVenta" idProd="'+idProd+'"><b>VENTA</b><br>'+
      formatNumber.new(datosProd['precio_venta'], "$ ")+'<br>'+
      '<font style="color:blue"><b>&uarr; '+datosProd['mayor_sobre']+'u '+formatNumber.new(datosProd['precio_mayor'], "$ ")+'</b><br></font>'+
      '<font size="-1">MAX DCTO: '+datosProd['descuento']+'%</font><br>'+
    '</div>'+
    '<div class="btn-group float-right">'+
      '<button class="btn btn-default btn-xs btnMayDesdMenos" idProd="'+idProd+'">&darr;</button>'+
      '<button class="btn btn-default btn-xs btnMayDesdMas" idProd="'+idProd+'">&uarr;</button>'+
    '</div>');  
})

// CLICK EN NUEVO PRECIO
$(".tablaProductosAdmin").on("click", ".editPVenta", function(){
  var idProd = $(this).attr("idProd");
  var datosProd = infoProd(idProd);
  var pVentaAj = $(this).parent().children('#pVentaUnit').val();
  var pVMayorAj = $(this).parent().children('#pVMayor').val();
  var datos = new FormData();
  datos.append("modifPVenta", idProd);
  datos.append("pVentaAj", pVentaAj);
  datos.append("pVMayorAj", pVMayorAj);
  if(pVentaAj != '' && pVMayorAj != ''){
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,

      beforeSend: function() {
        $('#editPVenta'+idProd).removeAttr('style').removeClass('btn-info').addClass('btn-default').attr('disabled','disabled').html("<div style='text-align:center'>ACTUALIZANDO PRECIO VENTA...</div>");
      },      

      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          $('#pVenta'+idProd).html(
            '<div class="btnEditPVenta" idProd="'+idProd+'"><b>VENTA</b><br>'+
              formatNumber.new(pVentaAj, "$ ")+'<br>'+
              '<font style="color:blue"><b>&uarr; '+datosProd['mayor_sobre']+'u '+formatNumber.new(pVMayorAj, "$ ")+'</b><br></font>'+
              '<font size="-1">MAX DCTO: '+datosProd['descuento']+'%</font><br>'+
            '</div>'+
            '<div class="btn-group float-right">'+
              '<button class="btn btn-default btn-xs btnMayDesdMenos" idProd="'+idProd+'">&darr;</button>'+
              '<button class="btn btn-default btn-xs btnMayDesdMas" idProd="'+idProd+'">&uarr;</button>'+
            '</div>');

          $('#fecha'+idProd).html(resp[4]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS

          audioSuccess('Precio venta actualizado');
          localStorage.clear();
          contador=0;
        }
      }
    })
  }else{
    audioError('Ingrese Precio Unitario y Precio Mayor');
  }
})

// SUGERIR PRECIO MAYOR
$(".tablaProductosAdmin").on("change", "#pVentaUnit", function(){
  var idProd = $(this).attr('idProd');
  var datosProd = infoProd(idProd);
  var pMayorMax = Math.floor($(this).val()*(1-datosProd['descuento']/100));
  var porcentajeMinUtUnit = Number(ajuste('ut_min_edit_precio_normal_prod'));
  var precioUnitMin = Number(Math.ceil(datosProd['precio_compra']*((100+porcentajeMinUtUnit)/100)));
  var precioMayorForzado = Number(Math.ceil(precioUnitMin*(1-datosProd['descuento']/100)));
  var precioMayor = Number(Math.ceil($(this).val()*(1-datosProd['descuento']/100)));
  
  if(Number($(this).val()) >= precioUnitMin){ // SI CUMPLE CON VALOR INGRESADO ES MAYOR O IGUAL A LA MINIMA UTILIDAD EXIGIDA
    $(this).parent().children('#pVMayor').val(precioMayor);        
  }else{ // SI NO CUMPLE CON EL PRECIO MINIMO
    audioError('El Precio de Venta Unitario debe sera mayor o igual a '+formatNumber.new(precioUnitMin, '$ '));
    $(this).val(precioUnitMin);
    $(this).parent().children('#pVMayor').val(precioMayorForzado);
  }
})

// EVITAR PRECIO_VENTA SEA MENOR AL MINIMO UTILIDAD MAYOR Y QUE PRECIOVENTA_MAYOR SEA SUPERIOR A PRECIO VENTA CON MAX DCTO
$(".tablaProductosAdmin").on("change", "#pVMayor", function(){
  var idProd = $(this).attr('idProd');
  var datosProd = infoProd(idProd);
  var pMayorMax = Math.floor($(this).parent().children('#pVentaUnit').val()*(1-Number(datosProd['descuento'])/100));
  var pMayor = $(this).val();
  var porcentajeMinUtMayor = Number(ajuste('ut_min_edit_precio_mayor_prod'));
  var precioMayorMinForzado = Number(Math.ceil(datosProd['precio_compra']*((100+porcentajeMinUtMayor)/100)));
  
  if(Number(pMayor) > Number(pMayorMax)){ // SI PRECIO MAYOR ES MAS CARO QUE EL PRECIO CON MAXIMO DESCUENTO
    audioError('El precio Mayorista erroneo, debe estar entre '+formatNumber.new(precioMayorMinForzado, '$ ')+' y '+formatNumber.new(pMayorMax, '$ '));
    $(this).val(pMayorMax);
    $(this).select();
  }else if(Number(pMayor) < Number(precioMayorMinForzado)){
    audioError('El precio Mayorista erroneo, debe estar entre '+formatNumber.new(precioMayorMinForzado, '$ ')+' y '+formatNumber.new(pMayorMax, '$ '));
    $(this).val(precioMayorMinForzado);
    $(this).select();
  }
})

/*---------------------------------------------
EDITAR MAYOR DESDE MENOS
---------------------------------------------*/
$(".tablaProductosAdmin").on("click", ".btnMayDesdMenos", function(){
  
  var btn = $(this);
  var idProd = $(this).attr("idProd");
  var datosProd = infoProd(idProd);
  var resta = Number(datosProd['mayor_sobre'])-1;
  var datos = new FormData();
  datos.append("mayDesdMenos", idProd);
  datos.append("cant", resta);
  $.ajax({
    url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,

    beforeSend: function() {
      btn.attr('disabled','disabled');
    },      


    success:function(r){
      resp = r.split(',');
      var stockActual = resp[2];
      if (resp[0] == 'ok') {

        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Mayor desde '+(stockActual)+'u'});
        btn.removeAttr('disabled');
        
        if(Number(stockActual) == 1){ // OFERTA
          $('#pVenta'+idProd).html(
            "<div class='btnEditPVenta' idProd='"+idProd+"'><b>VENTA</b><br>"+
              "<strike>Antes: $ "+formatNumber.new(datosProd['precio_venta'])+"</strike><br>"+
              "<b class='text-danger'>Ahora: $ "+formatNumber.new(datosProd["precio_mayor"])+"</b>"+
            "</div>"+
            "<div class='btn-group float-right'>"+
              "<button class='btn btn-info btn-xs finalizarOferta info' data-original-title='Finalizar Oferta' idProd='"+idProd+"'>Finalizar Oferta</button>"+
            "</div>")
          audioMarioCoin();
          Swal.fire({
            icon: 'success',
            title: 'Oferta aplicada',
            width: 600,
            color: '#716add',
            backdrop: 
                      `rgba(0,0,123,0.4)
                      url("componentes/img/sama/oferta.gif")
                      center top
                      no-repeat`
          })

        }else{
          $('#pVenta'+idProd).html(
            '<div class="btnEditPVenta" idProd="'+idProd+'"><b>VENTA</b><br>'+
              formatNumber.new(datosProd['precio_venta'], "$ ")+'<br>'+
              '<font style="color:blue"><b>&uarr; '+(stockActual)+'u '+formatNumber.new(datosProd['precio_mayor'], "$ ")+'</b><br></font>'+
              '<font size="-1">MAX DCTO: '+datosProd['descuento']+'%</font><br>'+
            '</div>'+
            '<div class="btn-group float-right">'+
              '<button class="btn btn-default btn-xs btnMayDesdMenos" idProd="'+idProd+'">&darr;</button>'+
              '<button class="btn btn-default btn-xs btnMayDesdMas" idProd="'+idProd+'">&uarr;</button>'+
            '</div>');
        }
        $('#fecha'+idProd).html(resp[1]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
      }
    }
  })
})

/*---------------------------------------------
EDITAR MAYOR DESDE MAS Y FINALIZAR OFERTA
---------------------------------------------*/
$(".tablaProductosAdmin").on("click", ".btnMayDesdMas,.finalizarOferta", function(){
  var idProd = $(this).attr("idProd");
  var datosProd = infoProd(idProd);
  var suma = Number(datosProd['mayor_sobre'])+1;
  var datos = new FormData();
  datos.append("mayDesdMas", idProd);
  datos.append("cant", suma);
  if(datosProd['mayor_sobre'] >= 1){
    $(this).attr('mayDesde',(suma));
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      success:function(r){
        resp = r.split(',');
        var stockActual = resp[2];
        if (resp[0] == 'ok'){
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Mayor desde '+(stockActual)+'u'});
          $('#pVenta'+idProd).html(
            '<div class="btnEditPVenta" idProd="'+idProd+'"><b>VENTA</b><br>'+
              formatNumber.new(datosProd['precio_venta'], "$ ")+'<br>'+
              '<font style="color:blue"><b>&uarr; '+(stockActual)+'u '+formatNumber.new(datosProd['precio_mayor'], "$ ")+'</b><br></font>'+
              '<font size="-1">MAX DCTO: '+datosProd['descuento']+'%</font><br>'+
            '</div>'+
            '<div class="btn-group float-right">'+
              '<button class="btn btn-default btn-xs btnMayDesdMenos" idProd="'+idProd+'">&darr;</button>'+
              '<button class="btn btn-default btn-xs btnMayDesdMas" idProd="'+idProd+'">&uarr;</button>'+
            '</div>');
          $('#fecha'+idProd).html(resp[1]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
        }
      }
    })
  }
})

/*-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
/*---------------------------------------------
ACTUALIZAR PRECIO COMPRA
---------------------------------------------*/
$('.tablaProductosAdmin').on("dblclick", ".editPCompraProd", function(){
  var idProd = $(this).attr('idProd');
  var nombreIdentificador = 'PrecioCompraProd';
  contador++;
  if(contador==1){
    localStorage.setItem("primerId"+nombreIdentificador, idProd);
    let datosProd = infoProd(idProd);
    $('#pCompra'+idProd).html(
      '<input type="text" style="width:110px" class="form-control input-xs" id="pCompraNETO" idProd="'+idProd+'" placeholder="Precio Compra NETO" '+
      'onkeypress="return soloNumeros(event)" value="'+datosProd['pc_neto']+'" required><br>'+
      '<input type="text" style="width:110px" class="form-control input-xs" id="pCompraIVA" idProd="'+idProd+'" placeholder="Precio Compra c/IVA" '+
      'onkeypress="return soloNumeros(event)" value="'+datosProd['precio_compra']+'" required><br>'+
      '<button style="width:60%" class="btn btn-info btn-xs editPCompra input-seguido" idProd="'+idProd+'"><font size="-1">Actualizar</font></button>'+
      '<button style="width:30%" class="btn btn-danger btn-xs cancelarEditPCompra" idProd="'+idProd+'"><i class="fa fa-times"></i></button>');

  }else if(contador==2){
    localStorage.setItem("ultimoId"+nombreIdentificador, idProd);
  }else{
    localStorage.setItem("primerId"+nombreIdentificador, localStorage.getItem("ultimoId"+nombreIdentificador));
    localStorage.setItem("ultimoId"+nombreIdentificador, idProd);
  }
  if(contador != 1){
    // A LA NORMALIDAD EL BOTON ANTERIOR
    datosProd = infoProd(localStorage.getItem('primerId'+nombreIdentificador));
    $('#pCompra'+localStorage.getItem("primerId"+nombreIdentificador)).html(
      '<div class="editPCompraProd" idprod="'+localStorage.getItem('primerId'+nombreIdentificador)+'">'+
        '<font size="-1">'+
          '<p style="color:rgb(128,139,150)">COMPRA<br>'+
          '<b>'+formatNumber.new(datosProd['pc_neto'], "$")+' / '+formatNumber.new(datosProd['precio_compra'], "$")+'</b></p>'+
        '</font>'+
      '</div>');
    localStorage.setItem("ultimoId"+nombreIdentificador, idProd);
    datosProd = infoProd(idProd);
    $('#pCompra'+idProd).html(
      '<input type="text" style="width:110px" class="form-control input-xs" id="pCompraNETO" idProd="'+idProd+'" placeholder="Precio Compra NETO" '+
      'onkeypress="return soloNumeros(event)" value="'+datosProd['pc_neto']+'" required><br>'+
      '<input type="text" style="width:110px" class="form-control input-xs" id="pCompraIVA" idProd="'+idProd+'" placeholder="Precio Compra c/IVA" '+
      'onkeypress="return soloNumeros(event)" value="'+datosProd['precio_compra']+'" required><br>'+
      '<button style="width:60%" class="btn btn-info btn-xs editPCompra input-seguido" idProd="'+idProd+'"><font size="-1">Actualizar</font></button>'+
      '<button style="width:30%" class="btn btn-danger btn-xs cancelarEditPCompra" idProd="'+idProd+'"><i class="fa fa-times"></i></button>');
  }
  $('#pCompraNETO').select();
})

// CANCELAR EDIT PRECIO COMPRA
$(".tablaProductosAdmin").on("click", ".cancelarEditPCompra", function(){
  let idProd = $(this).attr('idProd');
  let datosProd = infoProd(idProd);
  $('#pCompra'+idProd).html(
    '<div class="editPCompraProd" idprod="'+idProd+'">'+
      '<font size="-1">'+
        '<p style="color:rgb(128,139,150)">COMPRA<br>'+
        '<b>'+formatNumber.new(datosProd['pc_neto'], "$")+' / '+formatNumber.new(datosProd['precio_compra'], "$")+'</b></p>'+
      '</font>'+
    '</div>');
})

// CLICK EN NUEVO PRECIO COMPRA
$(".tablaProductosAdmin").on("click", ".editPCompra", function(){
  var idProd = $(this).attr("idProd");
  var datosProd = infoProd(idProd);
  var pCNetoAjax = $(this).parent().children('#pCompraNETO').val();
  var pCompraAjax = $(this).parent().children('#pCompraIVA').val();
  var datos = new FormData();
  datos.append("modifPCompra", idProd);
  datos.append("pCNetoAjax", pCNetoAjax);
  datos.append("pCompraAjax", pCompraAjax);
  if(pCNetoAjax != '' && pCompraAjax != ''){
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,

      beforeSend: function() {
        $('#pCompra'+idProd).removeAttr('style').removeClass('btn-info').addClass('btn-default').attr('disabled','disabled').html("<div style='text-align:center'>ACTUALIZANDO PRECIO COMPRA...</div>");
      },      

      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){

          $('#pCompra'+idProd).html(
            '<div class="editPCompraProd" idprod="'+idProd+'">'+
              '<font size="-1">'+
                '<p style="color:rgb(128,139,150)">COMPRA<br>'+
                '<b>'+formatNumber.new(pCNetoAjax, "$")+' / '+formatNumber.new(pCompraAjax, "$")+'</b></p>'+
              '</font>'+
            '</div>');
          $('#fecha'+idProd).html(resp[4]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS

          audioSuccess('Precio Compra actualizado');
          localStorage.clear();
          contador=0;
        }
      }
    })
  }else{
    audioError('Ingrese Precio Neto y Precio c/IVA');
  }
})

// CAMBIOS PRECIO NETO
$(".tablaProductosAdmin").on("change", "#pCompraNETO", function(){
  let precio = $(this).val();
  if(Number(precio) > 0){ // SI CUMPLE CON VALOR INGRESADO ES MAYOR O IGUAL A LA MINIMA UTILIDAD EXIGIDA
    $(this).parent().children('#pCompraIVA').val(Math.round(precio*1.19));        
  }else{ // SI NO CUMPLE CON EL PRECIO MINIMO
    audioError('Debe ser mayor que cero');
    $(this).select();
  }
})

// CAMBIOS PRECIO NETO
$(".tablaProductosAdmin").on("change", "#pCompraIVA", function(){
  let precio = $(this).val();
  if(Number(precio) > 0){ // SI CUMPLE CON VALOR INGRESADO ES MAYOR O IGUAL A LA MINIMA UTILIDAD EXIGIDA
    $(this).parent().children('#pCompraNETO').val(Math.round(precio/1.19));        
  }else{ // SI NO CUMPLE CON EL PRECIO MINIMO
    audioError('Debe ser mayor que cero');
    $(this).select();
  }
})

/*-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
$('.tablaProductosAdmin').on("click", ".editNameProd", function(){
  var idProd = $(this).attr('idProd');
  var nombreIdentificador = 'NombreProd';
  contador++;
  if(contador==1){
    localStorage.setItem("primerId"+nombreIdentificador, idProd);
    let nombreProd = infoProd(idProd)['descripcion'];
    $('#descripcionProd'+idProd).html(
        '<input class="form-control editNombreProdAjax" name="editNombreProdAjax" idProd="'+idProd+'" id="editNombreProdAjax" value="'+nombreProd+'"><div style="height:3px"></div>'+
        '<button class="btn btn-success btn-xs btnEditNombreProdAjax input-seguido" idProd="'+idProd+'" nombreActual="'+nombreProd+'" id="btnEditNombreProdAjax'+idProd+'">Actualizar Descripción</button>'+
        '<button class="btn btn-danger btn-xs btnCancelarNombreProd" idProd="'+idProd+'" id="btnCancelarNombreProd'+idProd+'">Cancelar</button>');
  }else if(contador==2){
    localStorage.setItem("ultimoId"+nombreIdentificador, idProd);
  }else{
    localStorage.setItem("primerId"+nombreIdentificador, localStorage.getItem("ultimoId"+nombreIdentificador));
    localStorage.setItem("ultimoId"+nombreIdentificador, idProd);
  }
  if(contador != 1){
    // A LA NORMALIDAD EL BOTON ANTERIOR
    let datosProd = infoProd(localStorage.getItem('primerId'+nombreIdentificador));
    $('#descripcionProd'+datosProd['id']).html(
      "<font size='+1'><b class='editNameProd' idProd='"+datosProd['id']+"'>"+datosProd["descripcion"]+"</b></font><br>"+
      "<font size='-1' class='editNameAltProd' idProd='"+datosProd['id']+"'>"+datosProd["descripcion2"]+"</font>");

    datosProd = infoProd(localStorage.getItem('ultimoId'+nombreIdentificador));
    $('#descripcionProd'+idProd).html(
        '<input class="form-control editNombreProdAjax" name="editNombreProdAjax" idProd="'+idProd+'" id="editNombreProdAjax" value="'+datosProd['descripcion']+'"><div style="height:3px"></div>'+
        '<button class="btn btn-success btn-xs btnEditNombreProdAjax input-seguido" idProd="'+idProd+'" nombreActual="'+datosProd['descripcion']+'" id="btnEditNombreProdAjax'+idProd+'">Actualizar Descripción</button>'+
        '<button class="btn btn-danger btn-xs btnCancelarNombreProd" idProd="'+idProd+'" id="btnCancelarNombreProd'+idProd+'">Cancelar</button>');
    $('#editNombreProdAjax').select();
  }
  $('#editNombreProdAjax').select();
})

$('.tablaProductosAdmin, .tablaProductos').on("dblclick", ".editNameAltProd", function(){
  
  var idProd = $(this).attr('idProd');
  contador++;
  if(contador==1){
    localStorage.setItem("primerIdNombreAltProd", idProd);
    let nombreAltProd = infoProd(idProd)['descripcion2'];
    $('#descripcionProd'+idProd).html(
        '<input class="form-control editNombreAltProdAjax" name="editNombreAltProdAjax" idProd="'+idProd+'" id="editNombreAltProdAjax" value="'+nombreAltProd+'"><div style="height:3px"></div>'+
        '<button class="btn btn-success btn-xs btnEditNombreAltProdAjax input-seguido" idProd="'+idProd+'" nombreActual="'+nombreAltProd+'" id="btnEditNombreAltProdAjax'+idProd+'">Actualizar Descripción</button>'+
        '<button class="btn btn-danger btn-xs btnCancelarNombreAltProd" idProd="'+idProd+'" id="btnCancelarNombreAltProd'+idProd+'">Cancelar</button>');
  }else if(contador==2){
    localStorage.setItem("ultimoIdNombreAltProd", idProd);
  }else{
    localStorage.setItem("primerIdNombreAltProd", localStorage.getItem("ultimoIdNombreAltProd"));
    localStorage.setItem("ultimoIdNombreAltProd", idProd);
  }

  if(contador != 1){
    // A LA NORMALIDAD EL BOTON ANTERIOR
    let datosProd = infoProd(localStorage.getItem('primerIdNombreAltProd'));
    $('#descripcionProd'+datosProd['id']).html(
      "<font size='+1'><b class='editNameProd' idProd='"+datosProd['id']+"'>"+datosProd["descripcion"]+"</b></font><br>"+
      "<font size='-1' class='editNameAltProd' idProd='"+datosProd['id']+"'>"+datosProd["descripcion2"]+"</font>");

    datosProd = infoProd(localStorage.getItem('ultimoIdNombreAltProd'));
    $('#descripcionProd'+idProd).html(
        '<input class="form-control editNombreAltProdAjax" name="editNombreAltProdAjax" idProd="'+idProd+'" id="editNombreAltProdAjax" value="'+datosProd['descripcion2']+'"><div style="height:3px"></div>'+
        '<button class="btn btn-success btn-xs btnEditNombreAltProdAjax input-seguido" idProd="'+idProd+'" nombreActual="'+datosProd['descripcion']+'" id="btnEditNombreAltProdAjax'+idProd+'">Actualizar Descripción</button>'+
        '<button class="btn btn-danger btn-xs btnCancelarNombreAltProd" idProd="'+idProd+'" id="btnCancelarNombreAltProd'+idProd+'">Cancelar</button>');
    $('#editNombreAltProdAjax').select();
  }
  $('#editNombreAltProdAjax').select();
})


$(".tablaProductosAdmin, .tablaProductos").on("click", ".btnCancelarNombreAltProd,.btnCancelarNombreProd", function(){
  var idProd = $(this).attr('idProd');
  $('#descripcionProd'+idProd).html(
    "<font size='+1'><b class='editNameProd' idProd='"+idProd+"'>"+infoProd(idProd)["descripcion"]+"</b></font><br>"+
    "<font size='-1' class='editNameAltProd' idProd='"+idProd+"'>"+infoProd(idProd)["descripcion2"]+"</font>");
  localStorage.clear();
})

$(".tablaProductosAdmin").on("click", ".btnEditNombreProdAjax", function(){
  var idProd = $(this).attr('idProd');
  var nombreNuevo = $('#editNombreProdAjax').val();
  var datos = new FormData();
  datos.append("modifDescripcion", idProd);
  datos.append("descripcion", nombreNuevo);
  $.ajax({
  url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    beforeSend: function(){
      $('#btnEditNombreProdAjax'+idProd).attr('disabled','disabled');
      $('#btnCancelarNombreProd'+idProd).attr('disabled','disabled');
      $('#btnEditNombreProdAjax'+idProd).html("<div style='text-align:center'>ACTUALIZANDO DESCRIPCIÓN...</div>");
    },
    success:function(r){
      if(r='ok'){
        
        $('#descripcionProd'+idProd).html(
          "<font size='+1'><b class='editNameProd' idProd='"+idProd+"'>"+infoProd(idProd)["descripcion"]+"</b></font><br>"+
          "<font size='-1' class='editNameAltProd' idProd='"+idProd+"'>"+infoProd(idProd)["descripcion2"]+"</font>");
        audioSuccess('Descripción modificada');
        contador=0;
      }
    }
  })
  localStorage.clear();
})

$(".tablaProductosAdmin, .tablaProductos").on("click", ".btnEditNombreAltProdAjax", function(){
  var idProd = $(this).attr('idProd');
  var nombreNuevo = $('#editNombreAltProdAjax').val();

  var datos = new FormData();
  datos.append("modifDescripcion2", idProd);
  datos.append("descripcion", nombreNuevo);

  $.ajax({
  url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    beforeSend: function(){
      $('#btnEditNombreAltProdAjax'+idProd).attr('disabled','disabled');
      $('#btnCancelarNombreAltProd'+idProd).attr('disabled','disabled');
      $('#btnEditNombreAltProdAjax'+idProd).html("<div style='text-align:center'>ACTUALIZANDO DESCRIPCIÓN...</div>");
    },
    success:function(r){
      if(r='ok'){
        
        $('#descripcionProd'+idProd).html(
          "<font size='+1'><b class='editNameProd' idProd='"+idProd+"'>"+infoProd(idProd)["descripcion"]+"</b></font><br>"+
          "<font size='-1' class='editNameAltProd' idProd='"+idProd+"'>"+infoProd(idProd)["descripcion2"]+"</font>");
        audioSuccess('Descripción modificada');
        contador=0;
      }
    }
  })
  localStorage.clear();  

})

$(".tablaProductosAdmin").on("click", ".listaProvs", function(){
  var idProd = $(this).attr('idProd');
  var cantProvs = infoProd(idProd)['lista_proveedores'].split(',').length;
  var mostrarBotonEliminarProv = Number(cantProvs) > 1 ? '' : 'd-none';
  var datos = new FormData();
  $('#codigos'+idProd).html('<b>PROVEEDORES</b><br>');
  datos.append('listaProvsProd', idProd);
  $.ajax({
    url:'ajax/proveedores.ajax.php',
    method: 'POST',
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(resp){
      var listaProvs = JSON.parse(resp);
      $(listaProvs).each(function (i){
        $('#codigos'+idProd).append('<br><font size="-1" class="input-seguido">' + listaProvs[i]['nom_prov'].toUpperCase()+'</font>'+
                                    "<button type='button' class='btn btn-danger input-seguido btn-circle btn-sm quitarProvProd float-right info "+mostrarBotonEliminarProv+"' nomProv='"+listaProvs[i]['nom_prov']+"' idProv='"+listaProvs[i]['id_prov']+"' idProd='"+idProd+"'>"+
                                      "<i class='fa fa-times'></i>"+
                                    "</button>"+
                                    "<button type='button' class='btn btn-warning btn-circle btn-sm editProvProd info float-right' nomProv='"+listaProvs[i]['nom_prov']+"' idProv='"+listaProvs[i]['id_prov']+"' idProd='"+idProd+"'>"+
                                      "<i class='fa fa-pencil'></i>"+
                                    "</button>");
      })
      $('#codigos'+idProd).append("<br><br>"+
                                  "<button type='button' class='input-seguido btn btn-info btn-sm info btnAddProvProd' style='width:20%;' idProd='"+idProd+"'>+</button>"+
                                  "<button type='button' class='btn btn-success btn-sm info btnOkProvsProd' style='width:70%' idProd='"+idProd+"'>OK</button>");
    }
  })
})

$(".tablaProductosAdmin").on("click", ".editProvProd", function(){
  var idProd = $(this).attr('idProd');
  var idProv = $(this).attr('idProv');
  var nomProv = $(this).attr('nomProv');
  var datos = new FormData();
  datos.append('datosProvProd', idProd);
  datos.append('idProvProd', idProv);
  $.ajax({
    url:'ajax/productos.ajax.php',
    method: 'POST',
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(resp){
      let skuProv = resp.split(',')[0]; 
      let pc_neto_Prov = resp.split(',')[1];
      $('#codigos'+idProd).html(
        '<b><font size="+1">'+nomProv.toUpperCase()+'</font></b><br><br>'+
        '<font size="-1">SKU PROVEEDOR</font>'+
        '<input type="text" style="width:100%" class="form-control input-xs" id="skuEditProv'+idProd+'" placeholder="Sku Proveedor" value="'+skuProv+'" required>'+
        '<font size="-1">PRECIO NETO PROVEEDOR</font>'+
        '<input type="text" style="width:100%" class="form-control input-xs" id="pCNetoEditProv'+idProd+'" placeholder="$ Neto Unit" onkeypress="return soloNumeros(event)" value="'+pc_neto_Prov+'" required><br>'+
        '<button style="width:60%" class="btn btn-info btn-xs okEditProvProd input-seguido" idProv="'+idProv+'" id="editProvProd'+idProd+'" idProd="'+idProd+'"><font size="-1">OK</font></button>'+
        '<button style="width:30%" class="btn btn-danger btn-xs cancelaEditProvProd" idProd="'+idProd+'"><i class="fa fa-times"></i></button>');
    }
  })
})

$(".tablaProductosAdmin").on("click", ".okEditProvProd", function(){
  var idProd = $(this).attr('idProd');
  var skuProv = $(this).parent().children('#skuEditProv'+idProd).val()
  var pcNetoProv = $(this).parent().children('#pCNetoEditProv'+idProd).val()
  var idProv = $(this).attr('idProv');
  var sucursal = $('#sucursalActiva').val();
  var datos = new FormData();
  datos.append('editProvProd', idProd);
  datos.append('idEditProvProd', idProv);
  datos.append('skuEditProvProd', skuProv);
  datos.append('pcNetoEditProvProd', pcNetoProv);
  $.ajax({
    url:'ajax/productos.ajax.php',
    method: 'POST',
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(resp){

      if(resp == 'ok'){
        let datosProd = infoProd(idProd);
        var sku = Number(datosProd["categoria"]) <= 9 ? '0'+datosProd["sku"] : datosProd["sku"];
        $('#codigos'+idProd).html(
            '<b>'+datosProd['zona_'+sucursal]+'-'+sku+'</b> '+
            '<i style="color:rgb(224,142,11)" class="fa fa-pen btnEditUbic" idproducto="'+idProd+'" codint="'+sku+'" prov="'+datosProd['cod_proveedor']+'" ubic="'+datosProd['zona_'+sucursal]+'" codbar="'+datosProd['codigo']+'"></i><br>'+
            datosProd['codigo']+'<br>'+
            '<i>PROV (<b>'+datosProd['cod_proveedor']+'</b>)</i><br>'+
            '<b class="listaProvs" idProd="'+idProd+'">'+datosProd['nom_prov'].toUpperCase()+'</b><br><br>'+
            '<div class="embalajeCompra" idprod="'+idProd+'" embalajecompra="'+datosProd['embalaje_compra']+'"><font>Embalaje: <b>'+datosProd['embalaje_compra']+'</b>u</font></div>')
        audioSuccess('Proveedor Editado');

      }else{
        mixinError('No se puedo concretar la acción');
      }
    }
  })
})
$(".tablaProductosAdmin").on("click", ".btnAddProvProd", function(){
  var idProd = $(this).attr('idProd');
  var provsActuales = infoProd(idProd)['lista_proveedores'].split(',');
  var datos = new FormData();
  datos.append('idProveedor', 'todos');
  $.ajax({
    url:'ajax/proveedores.ajax.php',
    method: 'POST',
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(resp){
      var listaProvs = JSON.parse(resp);
      $('#codigos'+idProd).html('<b>Agregar Proveedor</b><br><br>'+
        '<select class="form-control-xs select2 selectProvsProd" id="selectProvsProd'+idProd+'" style="width: 100%;"></select>')
      
      $(listaProvs).each(function (i){
        $('#selectProvsProd'+idProd).append('<option value="'+listaProvs[i].id+'">'+infoProv(listaProvs[i].id)['alias_empresa']+'</option>')
      })


      var select = document.getElementById('selectProvsProd'+idProd);
      var options = select.children;
      for (var ia = 0; ia < provsActuales.length; ia++) {
        for (var i = 0; i < options.length; i++) {
          if (options[i].value === provsActuales[ia]) {
            select.removeChild(options[i]);
          }
        }
      }

      $('#selectProvsProd'+idProd).prepend('<option value="0" selected="selected">Seleccione Proveedor</option>');
      $('#codigos'+idProd).append(
        '<input type="text" style="width:100%" class="form-control input-xs" id="skuNewProv'+idProd+'" placeholder="Sku Proveedor" value="" required>'+
        '<input type="text" style="width:100%" class="form-control input-xs" id="pCNetoNewProv'+idProd+'" placeholder="$ Neto Unit" onkeypress="return soloNumeros(event)" value="" required><br>'+
        '<button style="width:60%" class="btn btn-info btn-xs okAddProvProd input-seguido" id="addProvProd'+idProd+'" idProd="'+idProd+'"><font size="-1">OK</font></button>'+
        '<button style="width:30%" class="btn btn-danger btn-xs cancelaAddProvProd" idProd="'+idProd+'"><i class="fa fa-times"></i></button>');
      $('#selectProvsProd'+idProd).select2();
    }
  })
})

$(".tablaProductosAdmin").on("click", ".okAddProvProd", function(){
  var idProd = $(this).attr('idProd');
  var datosProd = infoProd(idProd);
  var sucursal = $('#sucursalActiva').val();
  var sku = Number(datosProd["categoria"]) <= 9 ? '0'+datosProd["sku"] : datosProd["sku"];
  var nomProd = datosProd['desc_sii'];
  var newProvProd = $('#selectProvsProd'+idProd);
  var skuNewProv = $('#skuNewProv'+idProd).val();
  var pCNetoNewProv = $('#pCNetoNewProv'+idProd).val();
  var datos = new FormData();

  if(Number(newProvProd.val()) != 0 && Number(pCNetoNewProv) > 0 && pCNetoNewProv != ''){
    Swal.fire({
      icon:'question',
        title: "<h5>Agregar a <b>"+newProvProd.find('option:selected').text().toUpperCase()+"</b> como proveedor de <b>"+nomProd+"</b>?</h5>",
        showDenyButton: true,
        confirmButtonText: 'Si',
        denyButtonText: 'Cancelar',
        customClass: {
          actions: 'my-actions',
          cancelButton: 'order-1 right-gap boton-cancelar',
          confirmButton: 'order-2 btn boton-confirmar',
          denyButton: 'order-3 btn boton-denegar',
        }
    }).then((result) => {
      if (result.isConfirmed) {
        datos.append('agregarProvProd', idProd);
        datos.append('idProvNew', newProvProd.val());
        datos.append('skuProvNew', skuNewProv);
        datos.append('pNetoProvNew', pCNetoNewProv);
        $.ajax({
          url:'ajax/productos.ajax.php',
          method: 'POST',
          data: datos,
          cache: false,
          contentType: false,
          processData: false,
          success:function(resp){
            $('#codigos'+idProd).html(
                '<b>'+datosProd['zona_'+sucursal]+'-'+sku+'</b> '+
                '<i style="color:rgb(224,142,11)" class="fa fa-pen btnEditUbic" idproducto="'+idProd+'" codint="'+sku+'" prov="'+datosProd['cod_proveedor']+'" ubic="'+datosProd['zona_'+sucursal]+'" codbar="'+datosProd['codigo']+'"></i><br>'+
                datosProd['codigo']+'<br>'+
                '<i>PROV (<b>'+datosProd['cod_proveedor']+'</b>)</i><br>'+
                '<b class="listaProvs" idProd="'+idProd+'">'+datosProd['nom_prov'].toUpperCase()+'</b><br><br>'+
                '<div class="embalajeCompra" idprod="'+idProd+'" embalajecompra="'+datosProd['embalaje_compra']+'"><font>Embalaje: <b>'+datosProd['embalaje_compra']+'</b>u</font></div>')
          }
        })
      } else if (result.isDenied) {
        resolve();
      }
    })
  }else{
    audioError('A lo menos debe seleccionar Proveedor y el Precio Neto de Compra');
  }
})

$(".tablaProductosAdmin").on("click", ".btnOkProvsProd,.cancelaAddProvProd,.cancelaEditProvProd", function(){
  var idProd = $(this).attr('idProd');
  var datosProd = infoProd(idProd);
  var sucursal = $('#sucursalActiva').val();
  var sku = Number(datosProd["categoria"]) <= 9 ? '0'+datosProd["sku"] : datosProd["sku"];
  $('#codigos'+idProd).html(
      '<b>'+datosProd['zona_'+sucursal]+'-'+sku+'</b> '+
      '<i style="color:rgb(224,142,11)" class="fa fa-pen btnEditUbic" idproducto="'+idProd+'" codint="'+sku+'" prov="'+datosProd['cod_proveedor']+'" ubic="'+datosProd['zona_'+sucursal]+'" codbar="'+datosProd['codigo']+'"></i><br>'+
      datosProd['codigo']+'<br>'+
      '<i>PROV (<b>'+datosProd['cod_proveedor']+'</b>)</i><br>'+
      '<b class="listaProvs" idProd="'+idProd+'">'+datosProd['nom_prov'].toUpperCase()+'</b><br><br>'+
      '<div class="embalajeCompra" idprod="'+idProd+'" embalajecompra="'+datosProd['embalaje_compra']+'"><font>Embalaje: <b>'+datosProd['embalaje_compra']+'</b>u</font></div>')
})

$(".tablaProductosAdmin").on("click", ".quitarProvProd", function(){
  var idProd = $(this).attr('idProd');
  var datosProd = infoProd(idProd);
  var nomProd = datosProd['desc_sii'];
  var idProv = $(this).attr('idProv');
  var nomProv = $(this).attr('nomProv');
  var datos = new FormData();
  var sucursal = $('#sucursalActiva').val();
  var sku = Number(datosProd["categoria"]) <= 9 ? '0'+datosProd["sku"] : datosProd["sku"];
  Swal.fire({
    icon:'question',
      title: "<h5>¿Eliminar a <b>"+nomProv.toUpperCase()+"</b> como proveedor de <b>"+nomProd+"</b>?</h5>",
      showDenyButton: true,
      confirmButtonText: 'Si',
      denyButtonText: 'Cancelar',
      customClass: {
        actions: 'my-actions',
        cancelButton: 'order-1 right-gap boton-cancelar',
        confirmButton: 'order-2 btn boton-confirmar',
        denyButton: 'order-3 btn boton-denegar',
      }
  }).then((result) => {
    if (result.isConfirmed) {
      datos.append('eliminarProvProd', idProd);
      datos.append('idProv', idProv);
      $.ajax({
      url:'ajax/proveedores.ajax.php',
      method: 'POST',
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
        success:function(resp){
          $('#codigos'+idProd).html(
              '<b>'+datosProd['zona_'+sucursal]+'-'+sku+'</b> '+
              '<i style="color:rgb(224,142,11)" class="fa fa-pen btnEditUbic" idproducto="'+idProd+'" codint="'+sku+'" prov="'+datosProd['cod_proveedor']+'" ubic="'+datosProd['zona_'+sucursal]+'" codbar="'+datosProd['codigo']+'"></i><br>'+
              datosProd['codigo']+'<br>'+
              '<i>PROV (<b>'+datosProd['cod_proveedor']+'</b>)</i><br>'+
              '<b class="listaProvs" idProd="'+idProd+'">'+datosProd['nom_prov'].toUpperCase()+'</b><br><br>'+
              '<div class="embalajeCompra" idprod="'+idProd+'" embalajecompra="'+datosProd['embalaje_compra']+'"><font>Embalaje: <b>'+datosProd['embalaje_compra']+'</b>u</font></div>')
        }
      })
    } else if (result.isDenied) {
      resolve();
    }
  })
})

$(".tablaProductosAdmin").on("click", ".quitarRelacion", function(){
  let idProd = $(this).attr('idProd');
  let idProdRelacionado = $(this).attr('idProdRelacionado');
  var datos = new FormData();
  datos.append('quitarRelacionProd', idProd);
  datos.append('prodRelacionado', idProdRelacionado);
  $.ajax({
  url:'ajax/productos.ajax.php',
  method: 'POST',
  data: datos,
  cache: false,
  contentType: false,
  processData: false,
    success:function(resp){
      r = resp.split('///');
      if(r[0] == 'ok'){      
        let arrayRelacionados = infoProd(idProd)['prods_relacionados'].split(',');
        let listaProdsRelacionados = '';

        if(r[1] == ''){
          listaProdsRelacionados += "<button type='button' class='btn btn-primary btn-circle btn-sm relacionarProd info' data-original-title='Relacionar' idProd='"+idProd+"'><i class='fas fa-plus'></i></button>";
        }else{
          for (i=0; i < arrayRelacionados.length; i++){
            let prodRelacionado = infoProd(arrayRelacionados[i])['desc_sii'];
            listaProdsRelacionados += prodRelacionado+
                                      "<button type='button' class='btn btn-danger btn-circle btn-sm quitarRelacion info float-right' data-original-title='Quitar Relación' idProdRelacionado='"+arrayRelacionados[i]+"' idProd='"+idProd+"'>"+
                                        "<i class='fas fa-minus'></i>"+
                                      "</button><br>";
          }
          listaProdsRelacionados += "<button type='button' class='btn btn-primary btn-circle btn-sm relacionarProd info' data-original-title='Relacionar' idProd='"+idProd+"'><i class='fas fa-plus'></i></button>";
        }
        $('#relacion'+idProd).html(listaProdsRelacionados);
      }
    }
  })
})

$(".tablaProductosAdmin").on("click", ".confirmarRelacion", function(){
  let idProd = $(this).attr('idProd');
  let relacion = $(this).parent().children('.relacionSelect').val();
  var datos = new FormData();
  datos.append('relacionarProd', idProd);
  datos.append('prodRelacionado', relacion);
  $.ajax({
  url:'ajax/productos.ajax.php',
  method: 'POST',
  data: datos,
  cache: false,
  contentType: false,
  processData: false,
    success:function(resp){
      r = resp.split(',');
      if(r[0] == 'ok' && r[1] != 0){
        audioSuccess('Producto agregado a sugerencias');
        let arrayRelacionados = infoProd(idProd)['prods_relacionados'].split(',');
        let listaProdsRelacionados = '';
        for (i=0; i < arrayRelacionados.length; i++){
          let prodRelacionado = infoProd(arrayRelacionados[i])['desc_sii'];
          listaProdsRelacionados += prodRelacionado+
                                    "<button type='button' class='btn btn-danger btn-circle btn-sm quitarRelacion info float-right' data-original-title='Quitar Relación' idProdRelacionado='"+arrayRelacionados[i]+"'  idProd='"+idProd+"'>"+
                                      "<i class='fas fa-minus'></i>"+
                                    "</button><br>";
        }
        listaProdsRelacionados += "<button type='button' class='btn btn-primary btn-circle btn-sm relacionarProd info' data-original-title='Relacionar' idProd='"+idProd+"'><i class='fas fa-plus'></i></button>";
        $('#relacion'+idProd).html(listaProdsRelacionados);
      }else{
        audioError('Seleccione producto de la lista');
      }
    }
  })
})

$(".tablaProductosAdmin").on("click", ".relacionarProd", function(){
  idProd = $(this).attr('idProd');
  var datos = new FormData();
  datos.append('traerProds', 'todos');
  $.ajax({
  url:'ajax/productos.ajax.php',
  method: 'POST',
  data: datos,
  cache: false,
  contentType: false,
  processData: false,
  dataType:'json',
    success:function(r){
      producto = infoProd(idProd);
      relacionados = producto['prods_relacionados'];

      $('#relacion'+idProd).html(
        '<select class="form-control-sm select2 relacionSelect" style="width: 80%;" onchange="prodRelacionadoSelect2($(this))">'+
          '<option value="0" selected="selected">Seleccione Producto</option>'+
        '</select>'+
        ' <button type="button" class="btn btn-success btn-circle btn-sm confirmarRelacion info" data-original-title="Relacionar" idProd="'+idProd+'"><i class="fa-solid fa-check"></i></button>')
      $(r).each(function (i){
        if (!relacionados.includes(r[i]['id']) && r[i]['id'] != idProd){ // no aparecen los ya relacionados ni el mismo prod
          $('.relacionSelect').append('<option value="'+r[i]['id']+'" nombre="'+r[i]['descripcion']+'">'+r[i]['desc_sii'].toUpperCase()+'</option>');
        }
      });
      $('.relacionSelect').select2(); // activar select2
      $('.relacionSelect').focus();
    }
  })
})

function prodRelacionadoSelect2(item){
    mixinInfo($('.relacionSelect option[value="' + item.val() + '"]').attr('nombre').toUpperCase())
}

$('.tablaTicketsProductos').DataTable({
  "ajax": "ajax/datatable-tickets-prods.ajax.php",
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 25,
  "language": {

    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }

  },
    
  dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
  buttons:

  [
    { // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
      text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
      action: function ( e, dt, node, config ) {
        dt.clear().draw();
        dt.ajax.reload();
      }
    }       
  ]
});


$(".tablaTicketsProductos tbody").on("click", "button.agregarTicketProd", function(){
  var idProducto = $(this).attr("idProducto");
  $(this).removeClass("agregarTicketProd");
  $(this).attr('disabled','disabled');
  $(this).addClass('recuperarBoton');  
  var datos = new FormData();
  datos.append("idProducto", idProducto);

  $.ajax({
    url: "ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(r){
      sku = Number(r["categoria"]) <= 9 ? '0'+r["sku"] : r["sku"];
      $(".prodsTickets").prepend(
        '<div class="row mb-1 col-12" id="borde" style="padding:5px 20px; border-style: dashed; border-width: 1px;">'+
          '<div class="col-2 ingCantAbast" style="padding-left:0px; height:100px">'+
            '<img id="imagenZoom" src="'+r['imagen']+'" alt="'+r['descripcion']+'" class="imagenZoom" width="100px" idProducto="'+r['id']+'" data-toggle="modal" data-target="#modalZoomProducto">'+
          '</div>'+
          '<div class="col-9 descripcionEtiquetasProds" idProd="'+r['id']+'" style="padding-left:0px;padding-right:0px">'+
            '<font size="+2"><b>'+sku+'</b><br>'+r['descripcion']+'</font>'+
          '</div>'+
          '<div class="col-1" style="padding-left:0px;padding-right:0px">'+
            '<button type="button" class="btn btn-danger float-right btn-xs quitarProdCodBarra" idProducto="'+r['id']+'"><i class="fa fa-times"></i></button> '+
        '</div>'+
        '<div id="esp'+r['id']+'" style="height:3px"></div>')
    }
  })
})

/*=============================================
PDF ETIQUETAS CODIGOS BARRA
=============================================*/
function generarEtiquetasInfoProd(){
  var listaEtiquetas = [];
  var cantEtiquetas = $(".descripcionEtiquetasProds");
  for (var i = 0; i < cantEtiquetas.length; i++){
      listaEtiquetas.push({
        "id": $(cantEtiquetas[i]).attr("idProd")
      })
  }

  (async () => {

    const { value: formValues } = await Swal.fire({
      title: 'Formato Etiqueta',
      html:
        'Formato Etiqueta:<br>'+
        '<select class="form-control" id="swal-input1"><option value="100x50">100x50mm</option><option value="50x30">50x30mm</option></select>',
      focusConfirm: false,
      preConfirm: () => {
        return [
          $('#swal-input1').val(),
        ]
      }
    })
    if (formValues) {
      let ancho = formValues[0].split('x')[0];
      let alto = formValues[0].split('x')[1];
      window.open("extensiones/tcpdf/pdf/info-prod-venta.php?ancho="+ancho+"&alto="+alto+"&etiqs=" + JSON.stringify(listaEtiquetas), "_blank");
      // window.open("extensiones/tcpdf/pdf/codigos-barra.php?ancho="+formValues[0]+"&alto="+formValues[1]+"&etiqs=" + JSON.stringify(listaCodigos), "_blank");
    }

  })()

}




/*=============================================
PDF ETIQUETAS CODIGOS BARRA
=============================================*/
function generarEtiquetas(){
  var listaCodigos = [];
  var cantCodsBarra = $(".cantCodsBarra");
  for (var i = 0; i < cantCodsBarra.length; i++){
    if($(cantCodsBarra[i]).val() != 0 && $(cantCodsBarra[i]).val() != ''){
      listaCodigos.push({
        "id": $(cantCodsBarra[i]).attr("idProd"),
        "cant": $(cantCodsBarra[i]).val(),
      })
    }
  }
  window.open("extensiones/tcpdf/pdf/codigos-barra.php?ancho=50&alto=30&etiqs=" + JSON.stringify(listaCodigos), "_blank");

  // (async () => {

  //   const { value: formValues } = await Swal.fire({
  //     title: 'Formato Etiqueta',
  //     html:
  //       'ANCHO<input id="swal-input1" class="swal2-input" placeholder="Ancho" maxlength="3" value="50">' +
  //       '<br>ALTO   <input id="swal-input2" class="swal2-input" placeholder="Alto" maxlength="3" value="30">',
  //     focusConfirm: false,
  //     preConfirm: () => {
  //       return [
  //         $('#swal-input1').val(),
  //         $('#swal-input2').val()
  //       ]
  //     }
  //   })

  //   if (formValues) {
  //     window.open("extensiones/tcpdf/pdf/codigos-barra.php?ancho="+formValues[0]+"&alto="+formValues[1]+"&etiqs=" + JSON.stringify(listaCodigos), "_blank");
  //   }

  // })()


}




if(ventana == 'productos'){
  if(perfilVend == 'Administrador' || perfilVend == 'Socio'){
    var tblProd = 'tablaProductosAdmin';
  }else{
    var tblProd = 'tablaProductos';
  }
}else if(ventana == 'productos-movil'){
  if(perfilVend == 'Administrador' || perfilVend == 'Socio'){
    var tblProd = 'tablaProductosAdminMovil';
  }else{
    var tblProd = 'tablaProductosMovil';
  }
}else if(ventana == 'productos-config'){
    var tblProd = 'tablaProductosConfig';
}else{
    var tblProd = 'tblProdsDet';
}

$('#nuevaDescripcion').keyup(function(){
  $('#descripcionSii').val($(this).val().slice(0, 25).replace(/["']/g, ""))
})

/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
$('.'+tblProd).on("change", ".entregaProd", function(){
  let idProd = $(this).attr('idProd');
  let sectorEntrega = $(this).val();
  var datos = new FormData();
  datos.append("modifEntregaProd", idProd);
  datos.append("sectorEntregaProd", sectorEntrega);

  $.ajax({
  url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(r){
      if(r='ok'){
        audioSuccess('Se entrega en '+sectorEntrega.toUpperCase());
      }
    }
  })


})


/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
$('.'+tblProd).on("click", ".embalajeCompra", function(){
  let idProd = $(this).attr('idProd');
  let sucursal = $('#sucursalActiva').val();

  contador++;
  if(contador==1){

    localStorage.setItem("primerIdEmbalajeCompra", idProd);
    let embalajeCompra = infoProd(idProd)['embalaje_compra'];
    $('#codigos'+idProd).html(
        '<input class="form-control editEmbalajeCompraAjax" name="editEmbalajeCompraAjax" onkeypress="return soloEnteros(event)" idProd="'+idProd+'" id="editEmbalajeCompraAjax" onkeyup="formatoMiles($(this));" value="'+formatNumber.new(embalajeCompra)+'"><div style="height:3px"></div>'+
        '<button class="btn btn-success btn-xs btnEditEmbalajeCompraAjax input-seguido" idProd="'+idProd+'" embalajeActual="'+infoProd(idProd)['embalaje_compra']+'" id="btnEditEmbalajeCompraAjax'+idProd+'">Actualizar Embalaje</button>'+
        '<button class="btn btn-danger btn-xs btnCancelarEmbalajeCompra" idProd="'+idProd+'" id="btnCancelarEmbalajeCompra'+idProd+'">Cancelar</button>');
  }else if(contador==2){
    localStorage.setItem("ultimoIdEmbalajeCompra", idProd);
  }else{
    localStorage.setItem("primerIdEmbalajeCompra", localStorage.getItem("ultimoIdEmbalajeCompra"));
    localStorage.setItem("ultimoIdEmbalajeCompra", idProd);
  }

  if(contador != 1){

    // A LA NORMALIDAD EL BOTON ANTERIOR
    let datosProd = infoProd(localStorage.getItem('primerIdEmbalajeCompra'));
    let codProvVista = datosProd['cod_proveedor'] == '' ? '' : "<br><i>PROV (<b>"+datosProd['cod_proveedor']+"</b>)</i>";
    let codInt = Number(datosProd['categoria']) >= 10 ? datosProd['sku'] : '0'+datosProd['sku'];
    $('#codigos'+datosProd['id']).html(
      "<b>"+datosProd['zona_'+sucursal].toUpperCase()+"-"+codInt+"</b>"+
      "<i style='color:rgb(224,142,11)' class='fa fa-pen btnEditUbic' idProducto='"+datosProd['id']+"'></i><br>"+datosProd['codigo']+
      codProvVista+
      "<br><b class='listaProvs' idProd='"+idProd+"'>"+datosProd['nom_prov'].toUpperCase()+"</b>"+
      "<br><br>"+
      "<div class='embalajeCompra' idProd='"+datosProd['id']+"'><font>Embalaje: <b>"+formatNumber.new(datosProd['embalaje_compra'])+"</b>u</font></div>");

    // INTERFAZ PARA INGRESAR CAMBIO DE STOCK
    datosProd = infoProd(localStorage.getItem('ultimoIdEmbalajeCompra'));
    $('#codigos'+idProd).html(
        '<input class="form-control editEmbalajeCompraAjax" name="editEmbalajeCompraAjax" onkeypress="return soloEnteros(event)" idProd="'+idProd+'" id="editEmbalajeCompraAjax" onkeyup="formatoMiles($(this));" value="'+formatNumber.new(datosProd['embalaje_compra'])+'"><div style="height:3px"></div>'+
        '<button class="btn btn-success btn-xs btnEditEmbalajeCompraAjax input-seguido" idProd="'+idProd+'" embalajeActual="'+datosProd['embalaje_compra']+'"  id="btnEditEmbalajeCompraAjax'+idProd+'">Actualizar Embalaje</button>'+
        '<button class="btn btn-danger btn-xs btnCancelarEmbalajeCompra" idProd="'+idProd+'" id="btnCancelarEmbalajeCompra'+idProd+'">Cancelar</button>');
  }
  $('#editEmbalajeCompraAjax').select();
})


$('.'+tblProd).on("click", ".btnEditEmbalajeCompraAjax", function(){
  let idProd = $(this).attr('idProd');
  let cant = $(this).parent().children('#editEmbalajeCompraAjax').val().replace(/\./g, ''); // nros sin formato de miles
  let embalajeActual = $(this).attr('embalajeActual');
  let sucursal = $('#sucursalActiva').val();
  let datosProd = infoProd(idProd);
  let codProvVista = datosProd['cod_proveedor'] == '' ? '' : "<br><i>PROV (<b>"+datosProd['cod_proveedor']+"</b>)</i>";
  let codInt = Number(datosProd['categoria']) >= 10 ? datosProd['sku'] : '0'+datosProd['sku'];
  var datos = new FormData();
  datos.append("modifEmbalajeCompra", idProd);
  datos.append("cantEmbalajeCompra", cant);
  if(Number(cant) == Number(embalajeActual) || cant == ''){
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'info',title: 'No se han realizado cambios'});
    $('#codigos'+idProd).html(
      "<b>"+datosProd['zona_'+sucursal].toUpperCase()+"-"+codInt+"</b>"+
      "<i style='color:rgb(224,142,11)' class='fa fa-pen btnEditUbic' idProducto='"+idProd+"'></i><br>"+datosProd['codigo']+
      codProvVista+
      "<br><b class='listaProvs' idProd='"+idProd+"'>"+datosProd['nom_prov'].toUpperCase()+"</b>"+
      "<br><br>"+
      "<div class='embalajeCompra' idProd='"+idProd+"'><font>Embalaje: <b>"+formatNumber.new(datosProd['embalaje_compra'])+"</b>u</font></div>");
  }else{
    $.ajax({
    url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      beforeSend: function(){
        $('#btnCancelarEmbalajeCompra'+idProd).attr('disabled','disabled');
        $('#btnEditEmbalajeCompraAjax'+idProd).attr('disabled','disabled');
        $('#btnEditEmbalajeCompraAjax'+idProd).html("<div style='text-align:center'>ACTUALIZANDO...</div>");
      },
      success:function(r){
        if(r='ok'){
          audioSuccess('Embalaje Compra Actualizado')
          $('#codigos'+idProd).html(
            "<b>"+datosProd['zona_'+sucursal].toUpperCase()+"-"+codInt+"</b>"+
            "<i style='color:rgb(224,142,11)' class='fa fa-pen btnEditUbic' idProducto='"+idProd+"'></i><br>"+datosProd['codigo']+
            codProvVista+
            "<br><b class='listaProvs' idProd='"+idProd+"'>"+datosProd['nom_prov'].toUpperCase()+"</b>"+
            "<br><br>"+
            "<div class='embalajeCompra' idProd='"+idProd+"'><font>Embalaje: <b>"+formatNumber.new(cant)+"</b>u</font></div>");
            localStorage.clear();
        }
      }
    })
  }
  localStorage.clear();  
})

$('.'+tblProd).on("click", ".btnCancelarEmbalajeCompra", function(){
  let idProd = $(this).attr('idProd');
  let sucursal = $('#sucursalActiva').val();
  let datosProd = infoProd(idProd);
  let codProvVista = datosProd['cod_proveedor'] == '' ? '' : "<br><i>PROV (<b>"+datosProd['cod_proveedor']+"</b>)</i>";
  let codInt = Number(datosProd['categoria']) >= 10 ? datosProd['sku'] : '0'+datosProd['sku'];

  Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'info',title: 'No se han realizado cambios'});
  $('#codigos'+idProd).html(
    "<b>"+datosProd['zona_'+sucursal].toUpperCase()+"-"+codInt+"</b>"+
    "<i style='color:rgb(224,142,11)' class='fa fa-pen btnEditUbic' idProducto='"+idProd+"'></i><br>"+datosProd['codigo']+
    codProvVista+
    "<br><b class='listaProvs' idProd='"+idProd+"'>"+datosProd['nom_prov'].toUpperCase()+"</b>"+
    "<br><br>"+
    "<div class='embalajeCompra' idProd='"+idProd+"'><font>Embalaje: <b>"+formatNumber.new(datosProd['embalaje_compra'])+"</b>u</font></div>");
  localStorage.clear();  
})


/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// CAMBIAR DESCRIPCION SII
$('.'+tblProd).on("click", ".editDescSII", function(){
  idProd = $(this).attr('idProd');
  descripcion = $(this).text();
  $(this).parent().parent().removeClass('bg-danger'); // remover fondo que indica que sobrepasa los 25 caracteres

  if(descripcion.length <= 25){
    estiloInput = 'background-color:rgb(169,249,98); color:black';
  }else{
    estiloInput = 'background-color:rgb(247,122,85); color:white';
  }
  // SCRIPT PARA IDENTIFICAR LOS 2 ULTIMOS ID'S ABIERTOS
    contador++;
    if(contador==1){
      localStorage.setItem("primerIdDescSII", idProd);
      localStorage.setItem("primerDescSII", descripcion);

      // INTERFAZ PARA EDITAR NOMBRE SII
      $('#descripcionSII'+idProd).html(
          '<input class="form-control editDescSIIAjax" style="'+estiloInput+'" name="editDescSIIAjax" idProd="'+idProd+'" id="editDescSIIAjax" value="'+descripcion+'"><div style="height:3px"></div>'+
          '<button class="btn btn-success btn-xs btnEditDescSIIAjax" idProd="'+idProd+'" descripcionSII="'+descripcion+'" id="btnEditDescSIIAjax'+idProd+'">Actualizar descripción</button>'+
          '<button class="btn btn-danger btn-xs btnCancelarDescSII" idProd="'+idProd+'" descripcionSII="'+descripcion+'" id="btnCancelarDescSII'+idProd+'">Cancelar</button>');
      $('#editDescSIIAjax').select();
    }
    else if(contador==2){
      localStorage.setItem("ultimoIdDescripcionSII", idProd);
      localStorage.setItem("ultimoDescripcionSII", descripcion);

      // A LA NORMALIDAD EL BOTON ANTERIOR
      bg = localStorage.getItem('primerDescSII').length <= 25 ? '' : 'bg-danger';
      $('#descripcionSII'+localStorage.getItem('primerIdDescSII')).html(
            '<div class="'+bg+'">'+
              '<div class="hidden-md hidden-lg"></div>'+
              '<div class="hidden-xs hidden-sm"><b class="editDescSII" idProd="'+localStorage.getItem('primerIdDescSII')+'">'+localStorage.getItem('primerDescSII')+'</b></div>'+
            '</div>')
      // INTERFAZ PARA EDITAR descripcion VENTA
      $('#descripcionSII'+idProd).html(
          '<input class="form-control editDescSIIAjax" style="'+estiloInput+'" name="editDescSIIAjax" idProd="'+idProd+'" id="editDescSIIAjax" value="'+descripcion+'"><div style="height:3px"></div>'+
          '<button class="btn btn-success btn-xs btnEditDescSIIAjax" idProd="'+idProd+'" descripcionSII="'+descripcion+'" id="btnEditDescSIIAjax'+idProd+'">Actualizar descripción</button>'+
          '<button class="btn btn-danger btn-xs btnCancelarDescSII" idProd="'+idProd+'" descripcionSII="'+descripcion+'" id="btnCancelarDescSII'+idProd+'">Cancelar</button>');
      $('#editDescSIIAjax').select();
    }else{
      localStorage.setItem("primerIdDescSII", localStorage.getItem("ultimoIdDescripcionSII"));
      localStorage.setItem("primerDescSII", localStorage.getItem("ultimoDescripcionSII"));
      localStorage.setItem("ultimoIdDescripcionSII", idProd);
      localStorage.setItem("ultimoDescripcionSII", descripcion);

      // A LA NORMALIDAD EL BOTON ANTERIOR
      bg = localStorage.getItem('primerDescSII').length <= 25 ? '' : 'bg-danger';
      $('#descripcionSII'+localStorage.getItem('primerIdDescSII')).html(
            '<div class="'+bg+'">'+
              '<div class="hidden-md hidden-lg"></div>'+
              '<div class="hidden-xs hidden-sm"><b class="editDescSII" idProd="'+localStorage.getItem('primerIdDescSII')+'">'+localStorage.getItem('primerDescSII')+'</b></div>'+
            '</div>')
      // INTERFAZ PARA EDITAR descripcion VENTA
      $('#descripcionSII'+idProd).html(
          '<input class="form-control editDescSIIAjax" style="'+estiloInput+'" name="editDescSIIAjax" idProd="'+idProd+'" id="editDescSIIAjax" value="'+descripcion+'"><div style="height:3px"></div>'+
          '<button class="btn btn-success btn-xs btnEditDescSIIAjax" idProd="'+idProd+'" descripcionSII="'+descripcion+'" id="btnEditDescSIIAjax'+idProd+'">Actualizar descripción</button>'+
          '<button class="btn btn-danger btn-xs btnCancelarDescSII" idProd="'+idProd+'" descripcionSII="'+descripcion+'" id="btnCancelarDescSII'+idProd+'">Cancelar</button>');
      $('#editDescSIIAjax').select();
    }
})

$('.'+tblProd).on("keyup", ".editDescSIIAjax", function(){
  descripcion = $(this).val();
  if(descripcion.length <= 25){
    $(this).attr('style','height: 30px; font-size: 10pt; background-color:rgb(169,249,98); color:black');
  }else{
    $(this).attr('style','height: 30px; font-size: 10pt; background-color:rgb(247,122,85); color:white');
  }
})

$('.'+tblProd).on("click", ".btnCancelarDescSII", function(){
  idProd = $(this).attr('idProd');
  descripcion = $(this).attr('descripcionSII');
  $('#descripcionSII'+idProd).html("<b>SII:</b><br><font color='blue' class='editDescSII' idProd='"+idProd+"'>"+descripcion+"</font>");
  localStorage.clear();
})


$('.'+tblProd).on("click", ".btnEditDescSIIAjax", function(){
  idProd = $(this).attr('idProd');
  descripcionAnterior = $(this).attr('descripcionSII');
  descripcionNueva = $(this).parent().children('#editDescSIIAjax').val();
  var datos = new FormData();
  datos.append("modifDescSIIProd", idProd);
  datos.append("descripcion", elimCaracteresMalos(descripcionNueva));

  if(descripcionNueva == descripcionAnterior){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'No se han realizado cambios'});
    $('#descripcionSII'+idProd).html(
      "<b>SII:</b><br>"+
      "<font color='blue' class='editDescSII' idProd='"+idProd+"'>"+descripcionAnterior+"</font>"
    )
  }else if(descripcionNueva == ''){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe escribir algo'});
  }else if(descripcionNueva.length>25){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'La descripción supera los 25 caracteres'});
  }else{
    $.ajax({
    url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      beforeSend: function(){
        $('#btnEditDescSIIAjax'+idProd).attr('disabled','disabled');
        $('#btnCancelarDescSII'+idProd).attr('disabled','disabled');
        $('#btnEditDescSIIAjax'+idProd).html("<div style='text-align:center'>ACTUALIZANDO DESCRIPCIÓN...</div>");
      },
      success:function(r){
        if(r='ok'){
          $('#descripcionSII'+idProd).html(
            '<b>SII:</b><br>'+
            '<div class="bg-success">'+
              '<div class="hidden-md hidden-lg"></div>'+
              '<div class="hidden-xs hidden-sm"><b class="editDescSII" idProd="'+idProd+'">'+elimCaracteresMalos(descripcionNueva)+'</b></div>'+
            '</div>'
          )
          var audio = new Audio('componentes/sonidos/success.mp3');
          audio.play();
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Descripción modificada'});
          localStorage.clear();
          contador=0;
        }
      }
    })
  }
  localStorage.clear();  
})

/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// ELIMINAR CONFIGURACION DE PRODUCTO TRASNFORMABLE
$('.'+tblProd).on('click', 'button.btnElimProdrTransf', function(){
  var idBase = $(this).attr('idBase');
  var idSurtido = $(this).attr('idSurtido');
  var idSurtido2 = $(this).attr('idSurtido2');
  var datos = new FormData();
  datos.append('elimProdTransfBase', idBase);
  datos.append('elimProdTransfSurtido', idSurtido);
  datos.append('elimProdTransfSurtido2', idSurtido2);
  $.ajax({
  url:'ajax/productos.ajax.php',
  method: 'POST',
  data: datos,
  cache: false,
  contentType: false,
  processData: false,
    success:function(resp){
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'info',title: 'PRODUCTO TRANSFORMABLE ELIMINADO'});
      $('.tablaProductosConfig').DataTable().ajax.reload();
    }
  })
})


/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// CARGAR PRODUCTOS PREEXISTENTES PARA EDITAR
$('.'+tblProd).on('click', 'button.btnEditProdrTransf', function(){
  var idProdBase = $(this).attr('idProd');
  var idProdSurtido = $(this).attr('idSurtido');
  // var idProdSurtido2 = $(this).attr('idSurtido2');
  var datosProdBase = infoProd(idProdBase);
  var datosProdSurtido = infoProd(idProdSurtido);

  // VALORES QUE VIENEN DE BASE DE DATOS
  $("#prodBaseEdit").html('');
  $("#prodBaseEdit").append("<option value='"+datosProdBase['id']+"'>"+datosProdBase['descripcion'].toUpperCase()+"</option>");
  $("#prodBaseEdit").append("<option value='0'>Seleccione Producto</option>");

  $("#prodSurtidoEdit").html('');
  $("#prodSurtidoEdit").append("<option value='"+datosProdSurtido['id']+"'>"+datosProdSurtido['descripcion'].toUpperCase()+"</option>");
  $("#prodSurtidoEdit").append("<option value='0'>Seleccione Producto</option>");
  
  $("#unidIntercambioEdit").val(datosProdBase['cant_transf']);

  $("#prodBase2Edit").val(datosProdSurtido['id']);
  $("#prodBase2EditVista").val(datosProdSurtido['descripcion']);

  if(idProdSurtido != 0){
    $('#nivel2TransformacionProd').removeClass('d-none');
    datosProdSurtido2 = infoProd(idProdSurtido);
    $('#unidIntercambio2Edit').val(datosProdSurtido2['cant_transf_2']);
    $("#prodSurtido2Edit").html('');
    $("#prodSurtido2Edit").append("<option value='"+datosProdSurtido2['id']+"'>"+datosProdSurtido2['descripcion'].toUpperCase()+"</option>");
    $("#prodSurtido2Edit").append("<option value='0'>Seleccione Producto</option>");
  }else{
    $('#nivel2TransformacionProd').addClass('d-none');
  }

  
  // FOCUS EN ELEMENTO CODIGO PROVEEDOR MODAL
  $('#modalEditProdTransf').on('shown.bs.modal', function (e) {
    $('#prodBaseEdit').focus();
  })
  // GUARDAR PRODUCTOS INICIALES POR SI SE CAMBIAN TENEMOS QUE DEJAR EN 0 TODO LO TRANSFORMABLE
  $('#idProdBaseAnt').val(datosProdBase['id']);
  $('#idProdSurtirAnt').val(datosProdSurtido['id']);
  llenar_prods_transf(datosProdBase['id'],datosProdSurtido['id'],datosProdSurtido2['id']);

})

function llenar_prods_transf(prodBase,prodSurtir,prodSurtir2){
  var datos = new FormData();
  datos.append('traerProds', 'todos');
  $.ajax({
  url:'ajax/productos.ajax.php',
  method: 'POST',
  data: datos,
  cache: false,
  contentType: false,
  processData: false,
  dataType:'json',
    success:function(r){
      $(r).each(function (i){
        // QUE NO APAREZCA PRODUCTO_BASE SELECCIONADO EN CONFIG ANTIGUA
        if(Number(r[i]['id'])!=Number(prodBase)){
          $("#prodBaseEdit").append("<option value='"+r[i]['id']+"'>"+r[i]['descripcion'].toUpperCase()+"</option>");
        }
        // QUE NO APAREZCA PRODUCTO_SURTIR SELECCIONADO EN CONFIG ANTIGUA
        if(Number(r[i]['id'])!=Number(prodSurtir)){
          $("#prodSurtidoEdit").append("<option value='"+r[i]['id']+"'>"+r[i]['descripcion'].toUpperCase()+"</option>");
        }

        if(Number(r[i]['id'])!=Number(prodSurtir2)){
          $("#prodSurtido2Edit").append("<option value='"+r[i]['id']+"'>"+r[i]['descripcion'].toUpperCase()+"</option>");
        }
      });
    }
  })
}
/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
$('#prodSurtido').change(function(){
  $('#prodBase2').val($(this).val()); // traspasa id
  $('#prodBase2Vista').attr("value",$(this).find('option:selected').text()); // traspasa nombre visible
})



// CONFIGURAR PRODUCTO TRANSFORMABLE POR AJAX
$('#btnProductoConfig').on('click',function(){
  var prodBase = $('#prodBase').val();
  var intercambio = $('#unidIntercambio').val();
  var prodSurtido = $('#prodSurtido').val();
  if(prodBase!=0 && intercambio != 0 && prodSurtido != 0){
    var datos = new FormData();
    datos.append("idProdBase", prodBase);
    datos.append("intercambio", intercambio);
    datos.append("prodSurtido", prodSurtido);
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          var audio = new Audio('componentes/sonidos/success.mp3');
          audio.play();
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'PRODUCTO CONFIGURADO EXITOSAMENTE'});
          $('#prodBase').val(0).trigger('change');
          $('#unidIntercambio').val('');
          $('#prodSurtido').val(0).trigger('change');
          $('#modalConfigProducto').modal('hide');
          actualizarTabla()
        }
      }
    })
  }else{
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'SE DEBE COMPLETAR EL FORMULARIO PARA PODER CONFIGURAR EL PRODUCTO'});
  }
})

/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// EDITAR CONFIGURACION PRODUCTO TRANSFORMABLE POR AJAX
$('#btnProductoConfigEdit').on('click',function(){
  var prodBase = $('#prodBaseEdit').val();
  var prodSurtido = $('#prodSurtidoEdit').val();
  var intercambio = $('#unidIntercambioEdit').val();
  if(prodBase!=0 && intercambio != 0 && prodSurtido != 0 && prodBase!=prodSurtido){
    var datos = new FormData();
    datos.append("idProdBaseEdit", prodBase);
    datos.append("prodSurtidoEdit", prodSurtido);
    datos.append("intercambioEdit", intercambio);

    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,

      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          audioSuccess('PRODUCTO TRANSFORMABLE EDITADO EXITOSAMENTE');
          $('#prodBaseEdit').val(0).trigger('change');
          $('#unidIntercambioEdit').val('');
          $('#prodSurtidoEdit').val(0).trigger('change');
          $('#modalEditProdTransf').modal('hide');
          $('.tablaProductosConfig').DataTable().ajax.reload();

        }
      }
    })
  }else{
    audioError('SE DEBE COMPLETAR EL FORMULARIO CON PRODUCTO BASE Y PRODUCTO SURTIDO DISTINTO');
  }
})

/*=============================================
HISTORIAL PRODUCTO
=============================================*/
$(".tablaProductosAdmin").on("click", ".historialProducto", function(){
  idProd = $(this).attr('idProd');
  window.open("index.php?ruta=historial-producto&idProd="+idProd,"_blank");
})
$(".tablaProductosAdminMovil").on("click", ".historialProducto", function(){
  idProd = $(this).attr('idProd');
  window.open("index.php?ruta=historial-producto&idProd="+idProd,"_blank");
})

/*=============================================
CHECKEO STOCK PRODUCTO
=============================================*/
function checkeoStock(idProd){
  var datos = new FormData();
  datos.append("checkStock", idProd);
  $.ajax({
    url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    // dataType:'json',
    success:function(r){
      var resp = r.split(',');
      if(resp[0]=='ok'){
        var audio = new Audio('componentes/sonidos/success.mp3');
        audio.play();
        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'PRODUCTO CHECKEADO'});
        $('#btnCheckStock'+idProd).html('');
      }
    }
  })
}

/*=============================================
CARGAR TABLA PRODUCTOS
=============================================*/
$('.tablaProductos').DataTable( {
    "ajax": "ajax/datatable-productos.ajax.php?perfilVend="+perfilVend,
    // "order": [[ 11, "desc" ],[ 3, "asc" ]], //orden descendente por defecto
    "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 25,
   "language": {

      "sProcessing":     "Procesando...",
      "sLengthMenu":     "Mostrar _MENU_ registros",
      "sZeroRecords":    "No se encontraron resultados",
      "sEmptyTable":     "Ningún dato disponible en esta tabla",
      "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
      "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
      "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix":    "",
      "sSearch":         "Buscar (F3):",
      "sUrl":            "",
      "sInfoThousands":  ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
      "sFirst":    "Primero",
      "sLast":     "Último",
      "sNext":     "Siguiente",
      "sPrevious": "Anterior"
      },
      "oAria": {
        "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }

  },
    
  dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
  buttons:

  [
    { // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
      text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
      action: function ( e, dt, node, config ) {
        dt.clear().draw();
        dt.ajax.reload();
      }
    }       
  ],
  columnDefs: [
    {
      // Oculta la columna id si no quieres verla
      targets: 0,
      visible: false
    }
  ]  
});

$('.tablaProductosMovil').DataTable( {
    "ajax": "ajax/datatable-productos-movil.ajax.php?perfilVend="+perfilVend,
    // "order": [[ 11, "desc" ],[ 3, "asc" ]], //orden descendente por defecto
    "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 25,
   "language": {
    "sProcessing": "Procesando...",
    "sLengthMenu": "Mostrar _MENU_ registros",
    "sZeroRecords": "No se encontraron resultados",
    "sEmptyTable": "Ningún dato disponible en esta tabla",
    "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix": "",
    "sSearch": "Buscar",
    "sUrl": "",
    "sInfoThousands": ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
      "sFirst": "Primero",
      "sLast": "Último",
      "sNext": "&rarr;",
      "sPrevious": "&larr;"
    },
    "oAria": {
      "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }

  },
  dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',

} );
/*=============================================
CARGAR TABLA CONFIGURACION DE PRODUCTOS
=============================================*/
$('.tablaProductosConfig').DataTable({
  "ajax": "ajax/datatable-productos-config.ajax.php",
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 25,
  "language": {
    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  }
});


/*=============================================
CARGAR TABLA PRODUCTOS ADMIN
=============================================*/
$('.tablaProductosAdminMovil').DataTable( {
  "ajax": "ajax/datatable-productos-adm-movil.ajax.php?perfilVend="+perfilVend,
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 25,
  "language": {

    "sProcessing": "Procesando...",
    "sLengthMenu": "Mostrar _MENU_ registros",
    "sZeroRecords": "No se encontraron resultados",
    "sEmptyTable": "Ningún dato disponible en esta tabla",
    "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix": "",
    "sSearch": "<button class='btn btn-info btn-sm' onclick='actualizarTabla();'><i class='fas fa-undo'></i></button>    Buscar",
    "sUrl": "",
    "sInfoThousands": ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
      "sFirst": "Primero",
      "sLast": "Último",
      "sNext": "&rarr;",
      "sPrevious": "&larr;"
    },
    "oAria": {
      "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }

  },
  dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',


});

var tblAdmin = $('.tablaProductosAdmin').DataTable({
  "ajax": "ajax/datatable-productos-adm.ajax.php?perfilVend="+perfilVend,
  "order": [[ 11, "desc" ],[ 4, "asc" ]], //orden descendente por defecto
  "columnDefs": [ // columnas que se omiten en busqueda
    { "searchable": false, "targets": 4}
  ],
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 25,
  "language": {

    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  },

  dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
  buttons:

  [
    { // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
      text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
      action: function ( e, dt, node, config ) {
        dt.clear().draw();
        dt.ajax.reload();
      }
    }       
  ]
  ,

 createdRow: function(row, data, dataIndex) {
    // Supón que el ID está en la primera columna (posición 0)
    $(row).attr('id', 'row-' + data[0]);
  },
  columnDefs: [
    { targets: 0, visible: false },     // Oculta ID
    { targets: 5, searchable: false }   // No busca en Relacionados
  ]  
});



$('.tablaCodsBarraProductos').DataTable({
  "ajax": "ajax/datatable-cods-barra.ajax.php",
  // "order": [[ 11, "desc" ],[ 3, "asc" ]], //orden descendente por defecto
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 25,
  "language": {

    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }

  },
    
  dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
  buttons:
  [
    { // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
      text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
      action: function ( e, dt, node, config ) {
        dt.clear().draw();
        dt.ajax.reload();
      }
    }       
  ]
});

$(".tablaCodsBarraProductos tbody").on("click", "button.agregarCodBarra", function(){
  var idProducto = $(this).attr("idProducto");
  $(this).removeClass("agregarCodBarra");
  $(this).attr('disabled','disabled');
  $(this).addClass('recuperarBoton');  
  var datos = new FormData();
  datos.append("idProducto", idProducto);
  $.ajax({
    url: "ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(r){
      sku = Number(r["categoria"]) <= 9 ? '0'+r["sku"] : r["sku"];
      $(".prodsCodBarra").prepend(
        '<div class="row mb-1 col-12" id="borde" style="padding:5px 20px; border-style: dashed; border-width: 1px;">'+
          '<div class="col-3 ingCantAbast" style="padding-left:0px">'+
            '<font size="-2">Cantidad</font>'+
            '<div class="input-group">'+
              '<input type="number" class="form-control form-control-sm cantCodsBarra" id="cantCodsBarra" idProd="'+r['id']+'" min="0" value="0" required>'+
            '</div>'+
          '</div>'+
          '<div class="col-8" style="padding-left:0px;padding-right:0px">'+
            '<font size="-1"><b>'+sku+'</b><br>'+r['descripcion']+'</font>'+
          '</div>'+
          '<div class="col-1" style="padding-left:0px;padding-right:0px">'+
            '<button type="button" class="btn btn-danger float-right btn-xs quitarProdCodBarra" idProducto="'+r['id']+'"><i class="fa fa-times"></i></button> '+
        '</div>'+
        '<div id="esp'+r['id']+'" style="height:3px"></div>')
    }
  })
})

$(".formularioCodigosBarra").on("click", "button.quitarProdCodBarra", function(){
  $(this).parent().parent().parent().children('#esp'+$(this).attr('idProducto')).remove();
  $(this).parent().parent().remove();
  var idProducto = $(this).attr("idProducto");
  $("button[idProducto='"+idProducto+"']").removeAttr('disabled');
  $("button.recuperarBoton[idProducto='"+idProducto+"']").addClass('agregarCodBarras');
  $("button[idProducto='"+idProducto+"']").removeClass('recuperarBoton');

})



/*=================================================
CREACION CODIGO INTERNO A PARTIR DE CAT Y SUBCAT -->OK
=================================================*/
$("#nuevaCategoria,#nuevaSubcategoria,#catAbast,#subcatAbast").change(function(){

  var categoria = $("#nuevaCategoria option:selected").attr("codigo");
  var catAbast = $("#catAbast option:selected").attr("codigo");
  var subcategoria = $("#nuevaSubcategoria option:selected").attr("codigoSub");
  var subcatAbast = $("#subcatAbast option:selected").attr("codigoSub");

    if(categoria>=10 || catAbast>=10){
      categoria;
      catAbast;
    }else{
      categoria = "0"+categoria;
      catAbast = "0"+catAbast;
    }

    if(subcategoria>=10 || subcatAbast >=10){
      subcategoria;
      subcatAbast;
    }else{
      subcategoria = "0"+subcategoria;
      subcatAbast = "0"+subcatAbast;
    }

    $("#codigoInterno2").val(categoria+subcategoria);
    $("#subcodAbast").val(catAbast+subcatAbast);
    if($("#nuevaCategoria").val()!=0 && $("#nuevaSubcategoria").val()!=0){
      $("#catDB").val($("#nuevaCategoria option:selected").text());
      $("#subcatDB").val($("#nuevaSubcategoria option:selected").text());
    }
});

// PROVEEDOR EN DB PRODUCTOS
$("#proveedorProducto,#editarProveedorProducto").change(function(){
  if($(this).val()==0){
    var provCrear = '';
    var provEdit = '';
  }else{    
    var provCrear = $("#proveedorProducto option:selected").text();
    var provEdit = $("#editarProveedorProducto option:selected").text();
  }
  $('#provProdDB').val(provCrear);
  $('#nomProvEdit').val(provEdit);
});



/*=============================================
SELECT DINÁMICO DE SUBCATEGORIAS --> OK
=============================================*/
// CAMBIOS EN SELECT1
$("#nuevaCategoria").change(function(){

  var idSubcategoria = $("#nuevaCategoria option:selected").attr("codigo");
  var datos = new FormData();
  datos.append("idSubcategoria", idSubcategoria);
  $.ajax({
      url:"ajax/informes.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
      success:function(respuesta){
          llenar_subcats(respuesta);
      }
  })

})

function llenar_subcats(arregloAjax){
    $("#nuevaSubcategoria").html(""); //reset child options
    $("#nuevaSubcategoria").append("<option value='0'>Subcategoría</option>");
    $(arregloAjax).each(function (i) { //populate child options
        $("#nuevaSubcategoria").append("<option  codigo ="+arregloAjax[i].categoria_padre+" codigoSub="+arregloAjax[i].id_subcategoria+" value=\""+arregloAjax[i].id_subcategoria+"\">"+arregloAjax[i].subcategoria+"</option>");
    });
}

/*==========================================================================================
SELECT DINÁMICO DE SUBCATEGORIAS EN GENERAR INFORME ABASTECIMIENTO POR SUBCATEGORIA --->OK
==========================================================================================*/
// CAMBIOS EN SELECT1
$("#catAbast").change(function(){

  var idSubcategoria = $("#catAbast option:selected").attr("codigo");
  var datos = new FormData();
  datos.append("idSubcategoria", idSubcategoria);
  $.ajax({
      url:"ajax/informes.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
      success:function(respuesta){
          llenar_subcats_abast(respuesta);
      }
  })

})

function llenar_subcats_abast(arregloAjax){
    $("#subcatAbast").html(""); //reset child options
    $("#subcatAbast").append("<option value='0'>Subcategoría</option>");
    $(arregloAjax).each(function (i) { //populate child options
        $("#subcatAbast").append("<option  codigo ="+arregloAjax[i].categoria_padre+" codigoSub="+arregloAjax[i].id_subcategoria+" value=\""+arregloAjax[i].id_subcategoria+"\">"+arregloAjax[i].subcategoria+"</option>");
    });
}
/*-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// /*==========================================================================================
// ACTUALIZAR PRECIO COMPRA  --> OK, NO SE OCUPA EN VERSION 2.0
// ==========================================================================================*/
// $("."+tblProd+" tbody").on("click", ".btnEditPComp", function(){
//   // INPUTS EDICION
//   $(this).parent().html('<input type="text" style="width:110px" class="form-control input-xs" name="pCompraNeto" id="pCompraNeto" placeholder="NETO" onkeypress="return soloNumeros(event)" value="'+$(this).attr("pCNeto")+'" required>'+
//                         '<br>'+
//                         '<input type="text" style="width:110px" class="form-control input-xs" name="pCompra" id="pCompra" placeholder="C/IVA" onkeypress="return soloNumeros(event)" value="'+$(this).attr('pC')+'" required>'+
//                         '<br>'+
//                         '<button style="width:110px" class="btn btn-info btn-xs editPCompra" idProd="'+$(this).attr("idProducto")+'">Actualizar Precio</button>');
//   $('#pCompraNeto').select();

//   $("."+tblProd+" tbody").on("click", ".editPCompra", function(){
//     var idProd = $(this).attr("idProd");
//     var pCompra = $(this).parent().children('#pCompra').val();
//     var pCompraNeto = $(this).parent().children('#pCompraNeto').val();
//     var datos = new FormData();
//     datos.append("modifPCompra", idProd);
//     datos.append("pCompra", pCompra);
//     datos.append("pCompraNeto", pCompraNeto);
//     if((pCompra != '' || pCompra != 0) && (pCompraNeto != '' || pCompraNeto != 0)){
//       $.ajax({
//         url:"ajax/productos.ajax.php",
//         method: "POST",
//         data: datos,
//         cache: false,
//         contentType: false,
//         processData: false,
//         success:function(r){
//           var resp = r.split(',');
//           if(resp[0]=='ok'){
//             toastr.success('Precio compra actualizado');
//             setTimeout("window.location='productos'", 200);
//           }
//         }
//       })
//       $(this).parent().html("<font size='-1'><p style='color:rgb(128,139,150)'>S/IVA <b>$ "+
//         formatNumber.new(pCompraNeto, "$ ")+"</b><br>C/IVA <b>$ "+formatNumber.new(pCompra, "$ ")+"</b></p>"+
//         "</font><i style='color:rgb(224,142,11)' class='fa fa-pen btnEditPComp' pC='"+pCompra+"' pCNeto='"+pCompraNeto+"' idProducto='"+idProd+"'></i>");
//     }else{
//       toastr.error('Ingrese Precio Neto y Total');     
//     }
//   })
// })

// /*==========================================================================================
// PRECIO CON IVA Y SIN IVA AUTOMATICO --> OK, NO SE OCUPA EN VERSION 2.0
// ==========================================================================================*/
// $("."+tblProd+" tbody").on("change", "#pCompraNeto", function(){
//   $(this).parent().children('#pCompra').val(Number(Math.round($(this).val()*1.19)));
// })
// $("."+tblProd+" tbody").on("change", "#pCompra", function(){
//   $(this).parent().children('#pCompraNeto').val(Number(Math.round($(this).val()/1.19*100)/100));
// })


// // SUGERIR PRECIO MAYOR
// $("."+tblProd+" tbody").on("change", "#pVentaUnit", function(){
//   var desc = $(this).parent().children('.editPVenta').attr('desc');
//   var pMayorMax = $(this).val()*(1-desc/100);
//   $(this).parent().children('#pVMayor').val(pMayorMax)
// })
// // EVITAR PRECIO MAYOR SUPERIOR A MAX DCTO
// $("."+tblProd+" tbody").on("change", "#pVMayor", function(){
//   var desc = $(this).parent().children('.editPVenta').attr('desc');
//   var pMayorMax = Math.floor($(this).parent().children('#pVentaUnit').val()*(1-desc/100));
//   var pMayor = $(this).val();
//   if(pMayor >= pMayorMax){
//     toastr.error('El precio Mayorista erroneo, debe ser menor a $ '+pMayorMax);
//     $(this).val(0);
//     $(this).select();
//   }
// })
/*-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// function controlInvetario(id){
//   var datos = new FormData();
//   datos.append("controlarInventario", id);
//   $.ajax({
//     url:"ajax/productos.ajax.php",
//     method: "POST",
//     data: datos,
//     cache: false,
//     contentType: false,
//     processData: false,
//     success:function(r){

//     }
//   })

// }
$("."+tblProd+" tbody").on("change", ".controlInvetario", function(){
  var idProd = $(this).attr("idProd");
  var tipoControl = $(this).val();

  var mostrarControl = ['No Controlar','Primera Prioridad','Controlar Inventario'];
  var colorControl = ['','bg-success','bg-primary'];
  var tamanoInput = tblProd == "tablaProductosAdminMovil" ? "form-control-sm" : "";
  
  var datos = new FormData();
  datos.append("controlarInventario", idProd);
  datos.append("tipoControl", tipoControl);
  $.ajax({
    url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(resp){
      r = resp.split(',')
      if(r[0] == 'ok'){
        var audio = new Audio('componentes/sonidos/success.mp3');
        audio.play();
        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon:'success',title: 'Control Inventario Seteado'});
        $('#controlInvetario'+idProd).attr('class','form-control '+tamanoInput+' info controlInvetario '+colorControl[r[1]]);
      }
    }
  })
})




/*=============================================
SUBIR STOCK IDEAL CON CLICK   -->OK
=============================================*/
$("."+tblProd+" tbody").on("click", ".btnSubirStkIdeal", function(){
  $(this).attr('disabled','disabled');
  var idProd = $(this).attr("idProd");
  var stockActual = $(this).attr("stockActual");
  var stockIdeal = $(this).attr("stkIdeal");
  var suma = Number(stockIdeal)+1;
  var datos = new FormData();
  datos.append("stockIdeal", idProd);
  datos.append("idealActualizado", suma);
  if(stockIdeal >= 3){ // EL STOCK IDEAL MINIMO ES 3 PARA CUALQUIER PRODUCTO
    $(this).attr('stkIdeal',(suma)); // CAMBIA EL ATRIBUTO PARA PERMITIR SEGUIR VARIANDO EL STOCK IDEAL
    $('#btnBajarStkIdeal'+idProd).attr('stkIdeal',(suma));
    // $('#btnBajarStkIdeal'+idProd).removeAttr('disabled');

    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Stock Ideal '+(suma)+'u'});

          // COLOR DE BOTON STOCK DINAMICO
          if(resp[2]<=suma/3){
            var color = 'danger';
          }else if(resp[2]>suma/3  && resp[2]<suma/1.5){
            var color = 'warning';
          }else{
            var color = 'success';
          }

          $('#stkVis'+idProd).children('.stockVista').html(resp[2]+'/'+suma); // SUMA VISUAL EN ELEMENTO
          $('#fecha'+idProd).html(resp[1]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
          $('#btnSubirStkIdeal'+idProd).removeAttr('disabled');

          $('#stockDispMovil'+idProd).text(resp[2]+'/'+suma);
        }
      }
    })
  }
})

/*=============================================
BAJAR STOCK IDEAL CON CLICK   -->OK
=============================================*/
$("."+tblProd+" tbody").on("click", ".btnBajarStkIdeal", function(){
  $(this).attr('disabled','disabled');
  var idProd = $(this).attr("idProd");
  var stockActual = $(this).attr("stockActual");
  var stockIdeal = $(this).attr("stkIdeal");
  var resta = Number(stockIdeal)-1;
  var datos = new FormData();
  datos.append("stockIdealResta", idProd);
  datos.append("idealActualizadoResta", resta);
  if(stockIdeal > 3){ // EL STOCK IDEAL MINIMO ES 3 PARA CUALQUIER PRODUCTO
    $(this).attr('stkIdeal',(resta)); // CAMBIA EL ATRIBUTO PARA PERMITIR SEGUIR VARIANDO EL STOCK IDEAL
    $('#btnSubirStkIdeal'+idProd).attr('stkIdeal',(resta));
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Stock Ideal '+(resta)+'u'});
          // COLOR DE BOTON STOCK DINAMICO
          if(resp[2]<=resta/3){
            var color = 'danger';
          }else if(resp[2]>resta/3  && resp[2]<resta/1.5){
            var color = 'warning';
          }else{
            var color = 'success';
          }

          $('#stkVis'+idProd).children('.stockVista').html(resp[2]+'/'+resta); // SUMA VISUAL EN ELEMENTO
          $('#fecha'+idProd).html(resp[1]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
          $('#btnBajarStkIdeal'+idProd).removeAttr('disabled');
    
          $('#stockDispMovil'+idProd).text(resp[2]+'/'+resta);

        }
      }
    })

  }else{
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Stock Ideal Mínimo = 3u'});
  }


})

$("."+tblProd+" tbody").on("click", ".btnEditZonaMovil", function(){
  var idProd = $(this).attr('idProd');
  var sku = $(this).attr('skuProd');
  var zona = $('#editZonaMovil'+idProd).val();
  var datos = new FormData();
  datos.append("modifUbic", idProd);
  datos.append("zonaSucursal", zona);
  $.ajax({
    url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(resp){
      var r = resp.split(',');
      audioSuccess('Ubicación Actualizada');
      $('#zonaMovil'+idProd).text(r[2].toUpperCase()+'-'+sku)
    }
  })
})

/*=============================================
EDITAR UBICACION  --->OK
=============================================*/
$("."+tblProd+" tbody").on("click", ".btnEditUbic", function(){
  var idProd = $(this).attr("idProducto");
  var sucursal = $('#sucursalActiva').val();
  // SCRIPT PARA IDENTIFICAR LOS 2 ULTIMOS ID'S ABIERTOS
  contador++;
  if(contador==1){
    localStorage.setItem("primerIdZonaVista", idProd);
    let zona = infoProd(idProd)['zona_'+sucursal] != null ? infoProd(idProd)['zona_'+sucursal] : '';
    $('#codigos'+localStorage.getItem('primerIdZonaVista')).html('<input type="text" style="width:110px" class="form-control input-xs" name="editUbic" id="editUbic" placeholder="Ubicación" value="'+zona.toUpperCase()+'" required>'+
                          '<br>'+
                          '<button style="width:110px" class="btn btn-info btn-xs btnModiUbic" id="btnModifUbic'+idProd+'" idProd="'+idProd+'">Actualizar Ubicación</button>');
  }else if(contador==2){
    localStorage.setItem("ultimoIdZonaVista", idProd);
  }else{
    localStorage.setItem("primerIdZonaVista", localStorage.getItem("ultimoIdZonaVista"));
    localStorage.setItem("ultimoIdZonaVista", idProd);
  }

  if(contador != 1){
    // A LA NORMALIDAD EL BOTON ANTERIOR
    let datosProd = infoProd(localStorage.getItem('primerIdZonaVista'));
    let codInt = Number(datosProd['categoria']) >= 10 ? datosProd['sku'] : '0'+datosProd['sku'];
    let codProvVista = datosProd['cod_proveedor'] == '' ? '' : "<br><i>PROV (<b>"+datosProd['cod_proveedor']+"</b>)</i>";
    let zona = datosProd['zona_'+sucursal] != null ? datosProd['zona_'+sucursal] : '';
    $('#codigos'+datosProd['id']).html(
      "<b>"+zona.toUpperCase()+"-"+codInt+"</b>"+
      "<i style='color:rgb(224,142,11)' class='fa fa-pen btnEditUbic' idProducto='"+datosProd['id']+"'></i><br>"+datosProd['codigo']+
      codProvVista+
      "<br><b class='listaProvs' idProd='"+idProd+"'>"+datosProd['nom_prov'].toUpperCase()+"</b>"+
      "<br><br>"+
      "<div class='embalajeCompra' idProd='"+datosProd['id']+"'><font>Embalaje: <b>"+formatNumber.new(datosProd['embalaje_compra'])+"</b>u</font></div>");
    // INTERFAZ PARA INGRESAR CAMBIO UBICACION
    datosProd = infoProd(localStorage.getItem('ultimoIdZonaVista'));
    $('#codigos'+datosProd['id']).html('<input type="text" style="width:110px" class="form-control input-xs" name="editUbic" id="editUbic" placeholder="Ubicación" value="'+zona.toUpperCase()+'" required>'+
                          '<br>'+
                          '<button style="width:110px" class="btn btn-info btn-xs btnModiUbic" id="btnModifUbic'+datosProd['id']+'" idProd="'+datosProd['id']+'">Actualizar Ubicación</button>');
  }
  $('#editUbic').select();
})

$("."+tblProd+" tbody").on("click", ".btnModiUbic", function(){
  let idProd = $(this).attr("idProd");
  let datosProd = infoProd(idProd);
  let sucursal = $('#sucursalActiva').val();
  let sku = Number(datosProd['sku']) >= 10 ? datosProd['sku'] : '0'+datosProd['sku'];
  let ubic = $(this).parent().children('#editUbic').val()
  let codBar = datosProd['codigo'];
  let prov = datosProd['cod_proveedor'] == '' ? '' : "<i>PROV (<b>"+datosProd['cod_proveedor']+"</b>)</i><br>";
  let embalaje = datosProd['embalaje_compra'];
  let datos = new FormData();
  datos.append("modifUbic", idProd);
  datos.append("zonaSucursal", ubic);

  if(ubic != ''){
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,

      beforeSend: function() {
        $('#btnModifUbic'+idProd).removeAttr('style');
        $('#btnModifUbic'+idProd).removeClass('btn-info');
        $('#btnModifUbic'+idProd).addClass('btn-default');
        $('#btnModifUbic'+idProd).attr('disabled','disabled');
        $('#btnModifUbic'+idProd).html("<div style='text-align:center'>ACTUALIZANDO UBICACIÓN...</div>");
      },      

      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){

          if(prov!=''){ // SI TIENE CODIGO DE PROVEEDOR
              $('#codigos'+idProd).html(
                "<b>"+ubic.toUpperCase()+"-"+sku+"</b>"+
                "<i style='color:rgb(224,142,11)' class='fa fa-pen btnEditUbic' idProducto='"+idProd+"'></i><br>"+codBar+"<br>"+
                prov+
                "<b class='listaProvs' idProd='"+idProd+"'>"+datosProd['nom_prov']+"</b>"+
                "<br><br><div class='embalajeCompra' idProd='"+idProd+"' id='embalajeCompra"+idProd+"'><font>Embalaje: <b>"+formatNumber.new(embalaje)+"</b>u</font></div>");

          }else{ // SI NO TIENE CODIGO DE PROVEEDOR
              $('#codigos'+idProd).html(
                "<b>"+ubic.toUpperCase()+"-"+sku+"</b>"+
                "<i style='color:rgb(224,142,11)' class='fa fa-pen btnEditUbic' idProducto='"+idProd+"'></i><br>"+codBar+"<br>"+
                prov+
                "<b class='listaProvs' idProd='"+idProd+"'>"+datosProd['nom_prov']+"</b>"+
                "<br><br><div class='embalajeCompra' idProd='"+idProd+"' id='embalajeCompra"+idProd+"'><font>Embalaje: <b>"+formatNumber.new(embalaje)+"</b>u</font></div>");
          }
          $('#fecha'+idProd).html(resp[1]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
          var audio = new Audio('componentes/sonidos/success.mp3');
          audio.play();
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Ubicación actualizada'});
          localStorage.clear();
          contador=0;
        }          
      }
    })      

  }else{
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese Nueva Ubicación'});

  }
})
/*-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

/*=============================================
ACTIVAR/DESACTIVAR PRODUCTO --> OK
=============================================*/
$("."+tblProd+",.tablaProductosAdminMovil tbody").on("click", ".btnActProd", function(){
  // toastr.clear(); // desvanecer las otras alertas toastr
  var idProd = $(this).attr("idProd");
  var estadoProd = $(this).attr("estadoProd");
  var datos = new FormData();
  datos.append("activarId", idProd);
  datos.append("activarProd", estadoProd);
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
        success:function(r){
          var resp = r.split(',');
          if(resp[1]==1){
            Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Activado'});
          }else{
            Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Desactivado'});
          }
        }
    })

    if(estadoProd == 0){

      $(this).removeClass('btn-success');
      $(this).addClass('btn-danger');
      $(this).html('Desactivado');
      $(this).attr('estadoProd',1);
      $(this).tooltip('hide');
      $(this).attr("data-original-title","Activar");

    }else{

      $(this).addClass('btn-success');
      $(this).removeClass('btn-danger');
      $(this).html('Activado');
      $(this).attr('estadoProd',0);
      $(this).tooltip('hide');
      $(this).attr("data-original-title","Desactivar");

    }

})

/*=============================================
RESTAR STOCK -->OK
=============================================*/
$("."+tblProd+" tbody").on("click", ".btnRestStock", function(){
  var idProd = $(this).attr("idProd");
  var ideal = $(this).attr("ideal");
  var cant = $(this).parent().children('.stockVista');
  var stk = cant.text().split('/');
  var resta = (Number(stk[0]) - 1)+'/'+stk[1];
  // color stock dinámico
  if((Number(stk[0]) - 1)<=ideal/3){
    cant.removeClass('btn-success');
    cant.removeClass('btn-warning');
    cant.addClass('btn-danger');
  }else if((Number(stk[0]) - 1)>ideal/3  && (Number(stk[0]) - 1)<ideal/1.5){
    cant.removeClass('btn-success');
    cant.removeClass('btn-danger');
    cant.addClass('btn-warning');
  }else{
    cant.removeClass('btn-warning');
    cant.removeClass('btn-danger');
    cant.addClass('btn-success');
  }

  if(Number(stk[0]) == 0){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'No puede seguir descontando productos'});

  }else{
    $(this).attr('disabled','disabled');
    var datos = new FormData();
    datos.append("restStock", idProd);
    datos.append("resta", resta);
    datos.append("ideal", ideal);
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'warning',title: '-1'});
          // SE DEBE IDENTIFICAR POR ID PARTICULAR, DEBIDO A QUE AJAX NO PERMITE ENTRAR AL ELEMENTO POR $(this)
          $('#stkVis'+idProd).children('.stockVista').html(resp[1]+'/'+stk[1]); // RESTA VISUAL EN ELEMENTO
          $('#stkVis'+idProd).children('.botonesStkIdeal').children('.btnBajarStkIdeal').attr("stockActual", resp[1]-1); // CAMBIA EL VALOR DE STOCK ACTUAL EN BOTONES QUE VARIAN STOCK IDEAL
          $('#stkVis'+idProd).children('.botonesStkIdeal').children('.btnSubirStkIdeal').attr("stockActual", resp[1]-1); // CAMBIA EL VALOR DE STOCK ACTUAL EN BOTONES QUE VARIAN STOCK IDEAL   
          $('#fecha'+idProd).html(resp[4]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
          $('#btnRestStock'+idProd).removeAttr('disabled');
          checkeoStock(idProd);
          $('#stockDispMovil'+idProd).text(resp[1]+'/'+stk[1]);
        }
      }
    })
  }
})

/*=============================================
SUMAR STOCK --> OK
=============================================*/
$("."+tblProd+" tbody").on("click", ".btnSumStock", function(){
  $(this).attr('disabled','disabled');
  var idProd = $(this).attr("idProd");
  var ideal = $(this).attr("ideal");
  var cant = $(this).parent().children('.stockVista');
  var stk = cant.text().split('/');
  var suma = (Number(stk[0]) + 1)+'/'+stk[1];
  // color stock dinámico
  if((Number(stk[0]) + 1)<=ideal/3){
    cant.removeClass('btn-success');
    cant.removeClass('btn-warning');
    cant.addClass('btn-danger');
  }else if((Number(stk[0]) + 1)>ideal/3  && (Number(stk[0]) + 1)<ideal/1.5){
    cant.removeClass('btn-success');
    cant.removeClass('btn-danger');
    cant.addClass('btn-warning');
  }else{
    cant.removeClass('btn-warning');
    cant.removeClass('btn-danger');
    cant.addClass('btn-success');
  }
  var datos = new FormData();
  datos.append("sumStock", idProd);
  datos.append("suma", suma);
  datos.append("idealSuma", ideal);
    $.ajax({
    url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(r){
      var resp = r.split(',');
      if(resp[0]=='ok'){
        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: '+1'});
        // SE DEBE IDENTIFICAR POR ID PARTICULAR, DEBIDO A QUE AJAX NO PERMITE ENTRAR AL ELEMENTO POR $(this)
        $('#stkVis'+idProd).children('.stockVista').html(resp[1]+'/'+stk[1]); // SUMA VISUAL EN ELEMENTO
        $('#stkVis'+idProd).children('.botonesStkIdeal').children('.btnBajarStkIdeal').attr("stockActual", Number(resp[1])+1); // CAMBIA EL VALOR DE STOCK ACTUAL EN BOTONES QUE VARIAN STOCK IDEAL
        $('#stkVis'+idProd).children('.botonesStkIdeal').children('.btnSubirStkIdeal').attr("stockActual", Number(resp[1])+1); // CAMBIA EL VALOR DE STOCK ACTUAL EN BOTONES QUE VARIAN STOCK IDEAL   
        $('#fecha'+idProd).html(resp[4]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
        $('#btnSumStock'+idProd).removeAttr('disabled');
        checkeoStock(idProd);
        $('#stockDispMovil'+idProd).text(resp[1]+'/'+stk[1]);
      }
    }
  })

})

/*-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
/*=============================================
EDITAR STOCK    --->OK
=============================================*/
// INTERFAZ DE EDICION DE STOCK
$("."+tblProd+" tbody").on("click", ".stockVista", function(){    
  var idProd = $(this).attr("idProd");
  // INPUTS EDICION
  var inventario = $(this).text();
  var stk = inventario.split('/');
  var stock = stk[0];
  var ideal = stk[1]; 

  // COLOR DE BOTON STOCK DINAMICO
  if(stock<=ideal/3){
    var color = 'danger';
  }else if(stock>ideal/3  && stock<ideal/1.5){
    var color = 'warning';
  }else{
    var color = 'success';
  }


  // SCRIPT PARA IDENTIFICAR LOS 2 ULTIMOS ID'S ABIERTOS
  contador++;
  if(contador==1){
    localStorage.setItem("primerStockVista", stock);
    localStorage.setItem("primerStockIdealVista", ideal);
    localStorage.setItem("primerColorVista", color);
    localStorage.setItem("primerIdStockVista", idProd);
    // INTERFAZ PARA INGRESAR CAMBIO DE STOCK
    $('#stkVis'+localStorage.getItem('primerIdStockVista')).html(
        '<input type="text" style="width:110px" class="form-control input-xs" onkeypress="return soloNumeros(event)" name="editStock" id="editStock" placeholder="stock" value="'+stock+'" required>'+
        '<button style="width:110px" class="btn btn-info btn-xs btnEditStock" id="btnEditStock'+idProd+'" stock="'+stock+'" idProd="'+idProd+'" ideal="'+ideal+'">Actualizar Stock</button>');
    $('#editStock').select();

  }else if(contador==2){
    localStorage.setItem("ultimoStockVista", stock);
    localStorage.setItem("ultimoStockIdealVista", ideal);
    localStorage.setItem("ultimoColorVista", color);
    localStorage.setItem("ultimoIdStockVista", idProd);
    // A LA NORMALIDAD EL BOTON ANTERIOR
    $('#stkVis'+localStorage.getItem('primerIdStockVista')).html('<button class="btn btn-default btnRestStock" id="btnRestStock'+localStorage.getItem('primerIdStockVista')+'" ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+'>&darr;</button>'+
      '<button style="text-align:right" class="btn btn-'+localStorage.getItem('primerColorVista')+' stockVista" stk='+localStorage.getItem('primerStockVista')+' ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+' style="width:50px">'+localStorage.getItem('primerStockVista')+'/'+localStorage.getItem('primerStockIdealVista')+'</button>'+
      '<button class="btn btn-default btnSumStock" id="btnSumStock'+localStorage.getItem('primerIdStockVista')+'"  ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+'>&uarr;</button>');
    // INTERFAZ PARA INGRESAR CAMBIO DE STOCK
    $('#stkVis'+localStorage.getItem('ultimoIdStockVista')).html('<input type="text" style="width:110px" class="form-control input-xs" onkeypress="return soloNumeros(event)" name="editStock" id="editStock" placeholder="stock" value="'+stock+'" required>'+
                          '<button style="width:110px" class="btn btn-info btn-xs btnEditStock" id="btnEditStock'+idProd+'" stock="'+stock+'" idProd="'+idProd+'" ideal="'+ideal+'">Actualizar Stock</button>');
    $('#editStock').select();


  }else{
    localStorage.setItem("primerIdStockVista", localStorage.getItem("ultimoIdStockVista"));
    localStorage.setItem("primerStockVista", localStorage.getItem("ultimoStockVista"));
    localStorage.setItem("primerStockIdealVista", localStorage.getItem("ultimoStockIdealVista"));
    localStorage.setItem("primerColorVista", localStorage.getItem("ultimoColorVista"));
    localStorage.setItem("ultimoStockVista", stock);
    localStorage.setItem("ultimoStockIdealVista", ideal);
    localStorage.setItem("ultimoColorVista", color);
    localStorage.setItem("ultimoIdStockVista", idProd);
    // A LA NORMALIDAD EL BOTON ANTERIOR
    $('#stkVis'+localStorage.getItem('primerIdStockVista')).html('<button class="btn btn-default btnRestStock" id="btnRestStock'+localStorage.getItem('primerIdStockVista')+'" ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+'>&darr;</button>'+
      '<button style="text-align:right" class="btn btn-'+localStorage.getItem('primerColorVista')+' stockVista" stk='+localStorage.getItem('primerStockVista')+' ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+' style="width:50px">'+localStorage.getItem('primerStockVista')+'/'+localStorage.getItem('primerStockIdealVista')+'</button>'+
      '<button class="btn btn-default btnSumStock" id="btnSumStock'+localStorage.getItem('primerIdStockVista')+'"  ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+'>&uarr;</button>');
    // INTERFAZ PARA INGRESAR CAMBIO DE STOCK
    $('#stkVis'+localStorage.getItem('ultimoIdStockVista')).html('<input type="text" style="width:110px" class="form-control input-xs" onkeypress="return soloNumeros(event)" name="editStock" id="editStock" placeholder="stock" value="'+stock+'" required>'+
                          '<button style="width:110px" class="btn btn-info btn-xs btnEditStock" id="btnEditStock'+idProd+'" stock="'+stock+'" idProd="'+idProd+'" ideal="'+ideal+'">Actualizar Stock</button>');
    $('#editStock').select();
  }
})

// CAMBIO EN LA BASE DE DATOS
$("."+tblProd+" tbody").on("click", ".btnEditStock", function(){
  var idProd = $(this).attr("idProd");
  var cant = $(this).parent().children('#editStock').val();
  var ideal = $(this).attr('ideal');
  var stock = $(this).attr('stock');

  if(cant<=ideal/3){ // COLOR DE BOTON STOCK DINAMICO
    var color = 'danger';
  }else if(cant>ideal/3  && cant<ideal/1.5){
    var color = 'warning';
  }else{
    var color = 'success';
  }

  var datos = new FormData();
  datos.append("editStock", idProd);
  datos.append("cant", cant);
  datos.append("ideal", ideal);

  if(cant == stock){

      $('#stkVis'+idProd).html(
          '<button class="btn btn-default btnRestStock info" data-original-title="-1" id="btnRestStock'+idProd+'" ideal='+ideal+' idProd='+idProd+'>&darr;</button>'+
          '<button style="text-align:right" class="btn btn-'+color+' stockVista" stk='+cant+' ideal='+ideal+' idProd='+idProd+' style="width:50px">'+cant+'/'+ideal+'</button>'+
          '<button class="btn btn-default btnSumStock info" data-original-title="+1" id="btnSumStock'+idProd+'" ideal='+ideal+' idProd='+idProd+'>&uarr;</button>');
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'info',title: 'No se registraron cambios'})        

  }else if(cant != stock && cant != ''){
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      beforeSend: function() {
        $('#btnEditStock'+idProd).removeAttr('style');
        $('#btnEditStock'+idProd).removeClass('btn-info');
        $('#btnEditStock'+idProd).addClass('btn-default');
        $('#btnEditStock'+idProd).attr('disabled','disabled');
        $('#btnEditStock'+idProd).html("<div style='text-align:center'>ACTUALIZANDO STOCK...</div>");
      },      
      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          $('#stkVis'+idProd).html('<button class="btn btn-default btnRestStock info" data-original-title="-1" id="btnRestStock'+idProd+'" ideal='+ideal+' idProd='+idProd+'>&darr;</button>'+
            '<button style="text-align:right" class="btn btn-'+color+' stockVista" stk='+cant+' ideal='+ideal+' idProd='+idProd+' style="width:50px">'+cant+'/'+ideal+'</button>'+
            '<button class="btn btn-default btnSumStock info" data-original-title="+1" id="btnSumStock'+idProd+'" ideal='+ideal+' idProd='+idProd+'>&uarr;</button>');
          checkeoStock(idProd);
          localStorage.clear();
          contador=0;
          $('#stockDispMovil'+idProd).text(cant+'/'+ideal);

        }
      }
    })
  }
})
/*-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
/*======================================================
PRECIO DE VENTA AUTOMATICO DEPENDIENDO DEL PRECIO COMPRA
======================================================*/
$('#nuevoPrecioCompra, #editarPrecioCompra').change(function(){
  // si el checkbox porcentaje está chequeado aplica el porcentaje
  if($('.porcentaje').prop('checked')){
    // asigna el valor de la caja de text de porcentaje, por defecto está configurada a 40%
    var valorPorcentaje = Math.ceil($('.nuevoPorcentaje').val());
    var precio_compra_nuevo_inicial = Math.ceil(Math.ceil(Number($('#nuevoPrecioCompra').val())+Number(($('#nuevoPrecioCompra').val()*valorPorcentaje/100)))/10)*10;
    var precio_compra_editar_inicial = Math.ceil(Math.ceil(Number($('#editarPrecioCompra').val())+Number(($('#editarPrecioCompra').val()*valorPorcentaje/100)))/10)*10;
    var precio_venta = $('#nuevoPrecioVenta').val();
    var precio_venta_editar = $('#editarPrecioVenta').val();
    var precio_compra = $('#nuevoPrecioCompra').val();
    var precio_compra_editar = $('#editarPrecioCompra').val();

    // cambios en crear producto
    $('#nuevoPrecioVenta').val(precio_compra_nuevo_inicial);
    $('#precioMayor').val(Math.ceil(Number(precio_compra_nuevo_inicial*0.95)));
    $('#nuevoPrecioCompraNeto').val(Math.round(Number($(this).val()/1.19*100))/100);


    // cambios en editar producto
    if($('#precioCompraNuevo').val() > $('#precioCompraAntiguo').val()){
      $('#editarPrecioVenta').val(precio_compra_editar_inicial);
    }

    $('#editarPrecioMayor').val(Math.ceil(Number(precio_compra_editar_inicial*0.95)));
    $('#precioCompraNuevo').val($('#editarPrecioCompra').val());
    $('#editarPrecioCompraNeto').val(Math.round(Number($(this).val()/1.19*100))/100);
    $('#editarPrecioVenta').val($('#editarPrecioCompra').val()*2);

  }
})

// PRECIO C/IVA AUTOMATICO
$('#nuevoPrecioCompraNeto').change(function(){
  $('#nuevoPrecioCompra').val(Math.round(Number($(this).val())*1.19));

})
$('#editarPrecioCompraNeto').change(function(){
  $('#editarPrecioCompra').val(Math.round(Number($(this).val())*1.19));
  $('#editarPrecioVenta').val(Math.round(Number($(this).val())*1.19)*2);
})


/*=============================================
CAMBIO DE PORCENTAJE
=============================================*/
$(".nuevoPorcentaje").change(function(){
  // está checkeado?
  if($(".porcentaje").prop("checked")){
    // valorPorcentaje = lo que esté en la caja de texto
    var valorPorcentaje = Math.ceil($(this));
    // porcentaje es el valor de la venta q se traspasa en fila 129
    var porcentaje = Math.ceil(Math.ceil(Number(($("#nuevoPrecioCompra").val()*valorPorcentaje/100))+Number($("#nuevoPrecioCompra").val()))/10)*10;
    // porcentaje es el valor de la venta q se traspasa en fila 132
    var editarPorcentaje = Math.ceil(Math.ceil(Number(($("#editarPrecioCompra").val()*valorPorcentaje/100))+Number($("#editarPrecioCompra").val()))/10)*10;

    $("#nuevoPrecioVenta").val(porcentaje);
    // $("#nuevoPrecioVenta").prop("readonly",true);

    $("#editarPrecioVenta").val(editarPorcentaje);
    // $("#editarPrecioVenta").prop("readonly",true);

  }
})

/*=============================================
SUBIENDO LA FOTO DEL PRODUCTO
=============================================*/
$(".nuevaImagen,.imgAbast").change(function(){

  var imagen = this.files[0];
  
  /*=============================================
    VALIDAMOS EL FORMATO DE LA IMAGEN SEA JPG O PNG
    =============================================*/

    if(imagen["type"] != "image/jpeg" && imagen["type"] != "image/png"){

      $(".nuevaImagen").val("");

       Swal.fire({
          title: "Error al subir la imagen",
          text: "¡La imagen debe estar en formato JPG o PNG!",
          type: "error",
          confirmButtonText: "¡Cerrar!"
        });
  // $(this).parent().html('<input type="text" style="width:110px" class="form-control input-xs" name="pCompra" id="pCompra" placeholder="Precio compra" onkeypress="return soloNumeros(event)" value="'+$(this).attr("pC")+'" required>'+
  //                       '<br>'+
  //                       '<button style="width:110px" class="btn btn-info btn-xs editPCompra" idProd="'+$(this).attr("idProducto")+'">Actualizar Precio</button>');
  // $('#pCompra').select();

    }else if(imagen["size"] > 2000000){

      $(".nuevaImagen").val("");

       Swal.fire({
          title: "Error al subir la imagen",
          text: "¡La imagen no debe pesar más de 2MB!",
          type: "error",
          confirmButtonText: "¡Cerrar!"
        });

    }else{

      var datosImagen = new FileReader;
      datosImagen.readAsDataURL(imagen);

      $(datosImagen).on("load", function(event){

        var rutaImagen = event.target.result;

        $(".previsualizar").attr("src", rutaImagen);
        $(".previsualizarAbast").attr("src", rutaImagen);

      })

    }
})

/*=============================================
EDITAR PRODUCTO --> OK
=============================================*/
$('.'+tblProd+',.tablaProductosAdminMovil,.tablaProductosMovil tbody').on('click', 'button.btnEditarProducto', function(){
  // EXTRAER DATOS PARA LA EDICION
  var perfil = $('#perfilVend').val();
  var sucursal = $('#sucursalActiva').val();
  var idProducto = $(this).attr('idProducto');
  var datos = new FormData();
  datos.append('idProducto', idProducto);

  $.ajax({
  url:'ajax/productos.ajax.php',
  method: 'POST',
  data: datos,
  cache: false,
  contentType: false,
  processData: false,
  dataType:'json',
    
    success:function(respuesta){ 

      var sku = Number(respuesta['categoria']) < Number(10) && respuesta["sku"][0] !== "0" ? '0'+respuesta['sku'] : respuesta['sku'];
      $('#idProductoEditar').val(respuesta['id']);
      $('#editarCodigo').val(respuesta['codigo']);
      $('#editarCodigoInterno').val(sku);
      $('#editarDescripcion').val(respuesta['descripcion']);
      $('#nombreAlternativo').val(respuesta['descripcion2']);
      $('#editarDescSii').val(respuesta['desc_sii']);
      $('#editarPrecioCompra').val(respuesta['precio_compra']);        
      $('#editarPrecioCompraNeto').val(respuesta['pc_neto']);        
      $('#editarPrecioVenta').val(respuesta['precio_venta']);
      $('#editarDescuentoMaximo').val(respuesta['descuento']);
      $('#editarMayoreo').val(respuesta['mayor_sobre']);
      $('#editarPrecioMayor').val(respuesta['precio_mayor']);
      $('#codigoBarraEditar').val(respuesta['codigo']);
      $('#codigoProveedorEditar').val(respuesta['cod_proveedor']);
      $('#nomProvEdit').val(respuesta['nom_prov']);
      $('#editarUbicacion').val(respuesta['zona_'+sucursal]);
      $('#editarStock').val(respuesta['stock_'+sucursal]);
      if(respuesta['imagen'] != ''){
        $('#imagenActual').val(respuesta['imagen']);
        $('.previsualizar').attr('src',  respuesta['imagen']);
      }
      
      /*--------------------------------------------------------------------------------------------------------------------------------------------*/      
      // SELECT MANEJA STOCK
      if(respuesta['maneja_stock'] == 'SI'){
        $("#editarManejaStock").html("");
        $("#editarManejaStock").append("<option value='SI'>SI</option>");
        $("#editarManejaStock").append("<option value='NO'>NO</option>");
        $('#editarStockIdeal').removeAttr('disabled');        
        $('#editarEmbalajeCompraProd').removeAttr('disabled');        
        $('#editarZonaEntregaProd').removeAttr('disabled');        

        $('#editarStockIdeal').val(respuesta['stock_ideal_'+sucursal]);
        $('#editarEmbalajeCompraProd').val(respuesta['embalaje_compra']);        
        $('#editarZonaEntregaProd').val(respuesta['zona_prod']);        
      }else{
        $("#editarManejaStock").html(""); 
        $("#editarManejaStock").append("<option value='NO'>NO</option>");        
        $("#editarManejaStock").append("<option value='SI'>SI</option>");
        $('#editarStock').attr('disabled', 'disabled');
        $('#editarStockIdeal').attr('disabled', 'disabled');        
        $('#editarEmbalajeCompraProd').attr('disabled', 'disabled');        
        $('#editarZonaEntregaProd').attr('disabled', 'disabled');        

        $('#editarStockIdeal').val('');        
        $('#editarEmbalajeCompraProd').val('');        
        $('#editarZonaEntregaProd').val(0);        
      }

      /*--------------------------------------------------------------------------------------------------------------------------------------------*/
      // LLENAR SELECT PROVEEDORES
      var idProveedor = respuesta['proveedor'];
      var datos = new FormData();
      datos.append('idProveedor', idProveedor);
      $.ajax({
      url:'ajax/proveedores.ajax.php',
      method: 'POST',
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',        
        success:function(respuesta2){  
          $('#editarProveedorProducto').html(""); 
          $("#editarProveedorProducto").append("<option value='"+respuesta2['id']+"'>"+respuesta2['alias_empresa'].toUpperCase() +"</option>");
          var idProveedor = 'todos';
          var datos = new FormData();
          datos.append('idProveedor', idProveedor);
          $.ajax({
          url:'ajax/proveedores.ajax.php',
          method: 'POST',
          data: datos,
          cache: false,
          contentType: false,
          processData: false,
          dataType:'json',        
            success:function(respuesta3){
              $(respuesta3).each(function(i){
                if(respuesta3[i]['id'] != respuesta2['id']) {
                  $("#editarProveedorProducto").append("<option value='"+respuesta3[i]['id']+"'>"+respuesta3[i]['alias_empresa'].toUpperCase() +"</option>");                      
                }
              });
            }
          })
        }
      })
      // FOCUS EN ELEMENTO CODIGO PROVEEDOR MODAL
      $('#modalEditarProducto').on('shown.bs.modal', function (e) {
        $('#codigoProveedorEditar').select();
      })
    }

  })
})

/*=============================================
ELIMINAR PRODUCTO
=============================================*/
$('.tablaProductosAdmin,.tablaProductosAdminMovil tbody').on("click", "button.btnEliminarProducto", function(){
  var idProd = $(this).attr("idProducto");
  var imagen = $(this).attr("imagen");
  Swal.fire({
    title: '¿Está seguro de borrar el producto?',
    text: "¡Si no lo está puede cancelar la acción!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    cancelButtonText: 'Cancelar',
    confirmButtonText: 'Sí, borrar producto!'
  }).then(function(result) {

    if (result.value) {

      Swal.fire({
        title: 'Eliminando...',
        text: 'Espere un momento',
        allowOutsideClick: false,
        allowEscapeKey: false,
        allowEnterKey: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });

      var datos = new FormData();
      datos.append('deleteProd', idProd);
      datos.append('imagen', imagen);

      $.ajax({
        url: 'ajax/productos.ajax.php',
        method: 'POST',
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        success: function(respuesta) {
          if (respuesta == 'ok') {

            let tabla = $('.tablaProductosAdmin').DataTable();
            let fila = $('#row-'+idProd);
            tabla.row(fila).remove().draw(false);
            Swal.close();
            audioSuccess("Producto eliminado correctamente");

          }
        },
        error: function() {
          Swal.close();
          Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Ocurrió un error de red.'
          });
        }
      });

    }

  });




})
  
/*=============================================
DESCUENTO MAXIMO         
=============================================*/
$('#descuentoMaximo').change(function(){

  var descuentoMax = $("#descuentoMaximo");


  if(descuentoMax.val() < 0 || descuentoMax.val() >25){
    mixinError('Descuento Incorrecto, se permite descuento >= 0 y descuento <= 25');
    descuentoMax.val(0);
  }
  var precio_venta = $('#nuevoPrecioVenta');
  $('#precioMayor').val(Math.round(precio_venta.val()*(1-descuentoMax.val()/100)));

  // $('#porcentajeUtilidad').text(descuentoMax.val()+' %');
  // $('#editarPorcentajeUtilidad').text(descuentoMax.val()+' %');
});

// EN EDITAR VENTA
$('#editarDescuentoMaximo').change(function(){

  var descuentoMax = $("#editarDescuentoMaximo");

  if(descuentoMax.val() <= 0 || descuentoMax.val() >25){
    Swal.fire({
          title: "ERROR",
          text: "Descuento Incorrecto, se permite descuento>=0 y descuento<=25",
          type: "error",
          confirmButtonText: "¡Cerrar!"
        });    
    descuentoMax.val(25);
  }

  var precio_venta = $('#editarPrecioVenta');
  // $('#precioMayor').val(precio_venta.val()*(1-descuentoMax.val()/100));
  $('#editarPrecioMayor').val(Math.round(precio_venta.val()*(1-descuentoMax.val()/100)));

});

/*=============================================
PRECIO VENTA
=============================================*/
$("#nuevoPrecioVenta, #editarPrecioVenta").change(function(){

  var precio_venta = $('#nuevoPrecioVenta');
  var precio_venta_editar = $('#editarPrecioVenta');
  var precio_compra = $('#nuevoPrecioCompra');
  var precio_compra_editar = $('#editarPrecioCompra');
  var descuento_max = $('#descuentoMaximo');
  var descuento_max_editar = $('#editarDescuentoMaximo');
  // alerta si se el precio venta es menor al 30% de utilidad total
  if(precio_venta.val() < (precio_compra.val()*1.3) ){

  var utilidad = Math.round(((precio_venta.val()/precio_compra.val())-1)*100);

    Swal.fire({
          title: "INFO",
          text: "El precio de venta del producto está generando solo un "+utilidad+"% de utilidad",
          type: "warning",
          confirmButtonText: "¡Cerrar!"
        });    
  }
  // $('#porcentajeUtilidad').text(Math.ceil(Number((((precio_venta.val()/precio_compra.val())-1)*100)))+' %');
  // $('#editarPorcentajeUtilidad').text(Math.ceil(Number((((precio_venta_editar.val()/precio_compra_editar.val())-1)*100)))+' %');
  $('#precioMayor').val(Math.round(precio_venta.val()*(1-descuento_max.val()/100)));
  $('#editarPrecioMayor').val(Math.round(precio_venta_editar.val()*(1-descuento_max_editar.val()/100)));

});

/*=============================================
PRECIO MAYOR
=============================================*/
$('#precioMayor').change(function(){

  var precio_venta = $('#nuevoPrecioVenta');
  var precio_mayor = $(this);
  var descuento_max = $('#descuentoMaximo');
  var verif_precio = (precio_venta.val()*(1-descuento_max.val()/100));
  if(precio_mayor.val() >= verif_precio){

    Swal.fire({
          title: "ERROR",
          text: "El precio Mayorista erroneo, debe ser menor a $ "+verif_precio+" para que sea un precio Mayorista. Recordar que el precio Mayorista debe ser mejor que el precio venta aplicándole el máximo descuento",
          type: "error",
          confirmButtonText: "¡Cerrar!"
        });    
  }

});

$('#editarPrecioMayor').change(function(){

  var precio_venta = $('#editarPrecioVenta');
  var precio_mayor = $(this);
  var descuento_max = $('#editarDescuentoMaximo');
  var verif_precio = (precio_venta.val()*(1-descuento_max.val()/100));
  if(precio_mayor.val() >= verif_precio){

    Swal.fire({
          title: "ERROR",
          text: "El precio Mayorista erroneo, debe ser menor a $ "+verif_precio+" para que sea un precio Mayorista. Recordar que el precio Mayorista debe ser mejor que el precio venta aplicándole el máximo descuento",
          type: "error",
          confirmButtonText: "¡Cerrar!"
        });    
  }

});

/*================================================
MANEJA STOCK? HABILITAR INPUTS STOCK ACTUAL E IDEAL 
================================================*/
$('#manejaStock, #editarManejaStock').change(function(){

  var maneja_stock = $(this);
  var nuevo_stock = $('#nuevoStock');
  var stock_ideal = $('#stockIdeal');
  var editar_nuevo_stock = $('#editarStock');
  var editar_stock_ideal = $('#editarStockIdeal');
 
  if(maneja_stock.val() == 0 || maneja_stock.val() == 'NO'){
    nuevo_stock.attr('disabled', 'disabled');
    stock_ideal.attr('disabled', 'disabled');
    editar_nuevo_stock.attr('disabled', 'disabled');
    editar_stock_ideal.attr('disabled', 'disabled');
    $('#embalajeCompraProd').attr('disabled','disabled');
    $('#zonaEntregaProd').attr('disabled','disabled');
    $('#editarEmbalajeCompraProd').attr('disabled','disabled');
    $('#editarZonaEntregaProd').attr('disabled','disabled');
  }else if(maneja_stock.val() == 'SI'){
    nuevo_stock.removeAttr('disabled');
    stock_ideal.removeAttr('disabled');
    editar_nuevo_stock.removeAttr('disabled');
    editar_stock_ideal.removeAttr('disabled');
    $('#embalajeCompraProd').removeAttr('disabled');
    $('#zonaEntregaProd').removeAttr('disabled');
    $('#editarEmbalajeCompraProd').removeAttr('disabled');
    $('#editarZonaEntregaProd').removeAttr('disabled');
  }

})

/*=============================================
PRODUCTO FALTANTE
=============================================*/
$('#btnGuardarFaltante').click(function() {
  var datos = $('#formProdFaltante').serialize();
  $.ajax({
    type: 'POST',
    url: 'ajax/productos.ajax.php',
    data: datos,
    success: function(r) {
      if (r == 1) {
        var audio = new Audio('componentes/sonidos/success.mp3');
        audio.play();
        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Producto en busqueda de proveedor'});
        $('#productoFaltante').val('');
      } else {
        var audio = new Audio('componentes/sonidos/error.wav');
        audio.play();
        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'No se pudo concretar'});

        $('#productoFaltante').val('');
      }
    }
  })
  return false;
})

/*==================================================================
FOCUS EN PROVEEDOR PRODUCTO AL HACER CLICK EN BOTON AGREGAR PRODUCTO 
==================================================================*/
$('#btnModalAgregarProducto').click(function() {

  $(function () {
    $('#modalAgregarProducto').on('shown.bs.modal', function (e) {
      $('#proveedorProducto').focus();
    })
  });

})

// FOCUS EN INPUT MODAL
$('#modalActualizarStock').on('shown.bs.modal', function (e) {
  $('#stockComprado').select();
})

// FOCUS EN INPUT MODAL
$('#modalActualizarPrecioCompra').on('shown.bs.modal', function (e) {
  $('#nuevoPrecioCompraModal').select();
})


