$(".tablaInventarioMovil").on("click", ".historialProducto", function(){
  idProd = $(this).attr('idProd');
  window.open("index.php?ruta=historial-producto&idProd="+idProd,"_blank");
})

var ventana = window.location.pathname.split('/')[2];
var perfilVend = $("#perfilVend").val();
var contador = 0;

$('.tablaInventarioMovil').DataTable( {
  "ajax": "ajax/datatable-inventario-movil.ajax.php?perfilVend="+perfilVend,
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 25,
  "language": {

    "sProcessing":     "Procesando...",
    "sLengthMenu":     "",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch": "<button class='btn btn-info btn-sm' onclick='actualizarTabla();'><i class='fas fa-undo'></i></button>    Buscar",
    "sUrl": "",
    "sInfoThousands": ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
      "sFirst": "Primero",
      "sLast": "Último",
      "sNext": "&rarr;",
      "sPrevious": "&larr;"
    },
    "oAria": {
      "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }

  },
  dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',
});


$(".tablaInventarioMovil tbody").on("change", ".controlInvetario", function(){
  var idProd = $(this).attr("idProd");
  var tipoControl = $(this).val();

  var mostrarControl = ['No Controlar','Primera Prioridad','Controlar Inventario'];
  var colorControl = ['','bg-success','bg-primary'];
  var tamanoInput = tblProd == "tablaProductosAdminMovil" ? "form-control-sm" : "";
  
  var datos = new FormData();
  datos.append("controlarInventario", idProd);
  datos.append("tipoControl", tipoControl);
  $.ajax({
    url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(resp){
      r = resp.split(',')
      if(r[0] == 'ok'){
        var audio = new Audio('componentes/sonidos/success.mp3');
        audio.play();
        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon:'success',title: 'Control Inventario Seteado'});
        $('#controlInvetario'+idProd).attr('class','form-control '+tamanoInput+' info controlInvetario '+colorControl[r[1]]);
      }
    }
  })
})

/*=============================================
SUBIR STOCK IDEAL CON CLICK   -->OK
=============================================*/
$(".tablaInventarioMovil tbody").on("click", ".btnSubirStkIdeal", function(){
  $(this).attr('disabled','disabled');
  var idProd = $(this).attr("idProd");
  var stockActual = $(this).attr("stockActual");
  var stockIdeal = $(this).attr("stkIdeal");
  var suma = Number(stockIdeal)+1;
  var datos = new FormData();
  datos.append("stockIdeal", idProd);
  datos.append("idealActualizado", suma);
  if(stockIdeal >= 3){ // EL STOCK IDEAL MINIMO ES 3 PARA CUALQUIER PRODUCTO
    $(this).attr('stkIdeal',(suma)); // CAMBIA EL ATRIBUTO PARA PERMITIR SEGUIR VARIANDO EL STOCK IDEAL
    $('#btnBajarStkIdeal'+idProd).attr('stkIdeal',(suma));
    // $('#btnBajarStkIdeal'+idProd).removeAttr('disabled');

    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Stock Ideal '+(suma)+'u'});

          // COLOR DE BOTON STOCK DINAMICO
          if(resp[2]<=suma/3){
            $('#stkVis'+idProd).children('.stockVista').removeClass('btn-warning');
            var color = 'danger';
          }else if(resp[2]>suma/3  && resp[2]<suma/1.5){
            $('#stkVis'+idProd).children('.stockVista').removeClass('btn-success');
            var color = 'warning';
          }else{
            var color = 'success';
          }

          $('#stkVis'+idProd).children('.stockVista').html(resp[2]+'/'+suma); // SUMA VISUAL EN ELEMENTO
          $('#stkVis'+idProd).children('.stockVista').addClass('btn-'+color); // COLOR STOCK
          $('#fecha'+idProd).html(resp[1]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
          $('#btnSubirStkIdeal'+idProd).removeAttr('disabled');

          $('#stockDispMovil'+idProd).text(resp[2]+'/'+suma);
        }
      }
    })
  }
})

/*=============================================
BAJAR STOCK IDEAL CON CLICK   -->OK
=============================================*/
$(".tablaInventarioMovil tbody").on("click", ".btnBajarStkIdeal", function(){
  $(this).attr('disabled','disabled');
  var idProd = $(this).attr("idProd");
  var stockActual = $(this).attr("stockActual");
  var stockIdeal = $(this).attr("stkIdeal");
  var resta = Number(stockIdeal)-1;
  var datos = new FormData();
  datos.append("stockIdealResta", idProd);
  datos.append("idealActualizadoResta", resta);
  if(stockIdeal > 3){ // EL STOCK IDEAL MINIMO ES 3 PARA CUALQUIER PRODUCTO
    $(this).attr('stkIdeal',(resta)); // CAMBIA EL ATRIBUTO PARA PERMITIR SEGUIR VARIANDO EL STOCK IDEAL
    $('#btnSubirStkIdeal'+idProd).attr('stkIdeal',(resta));
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Stock Ideal '+(resta)+'u'});
          // COLOR DE BOTON STOCK DINAMICO
          if(resp[2]<=resta/3){
            var color = 'danger';
          }else if(resp[2]>resta/3  && resp[2]<resta/1.5){
            $('#stkVis'+idProd).children('.stockVista').removeClass('btn-danger');
            var color = 'warning';
          }else{
            $('#stkVis'+idProd).children('.stockVista').removeClass('btn-warning');
            var color = 'success';
          }

          $('#stkVis'+idProd).children('.stockVista').html(resp[2]+'/'+resta); // SUMA VISUAL EN ELEMENTO
          $('#stkVis'+idProd).children('.stockVista').addClass('btn-'+color); // COLOR STOCK
          $('#fecha'+idProd).html(resp[1]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
          $('#btnBajarStkIdeal'+idProd).removeAttr('disabled');
    
          $('#stockDispMovil'+idProd).text(resp[2]+'/'+resta);

        }
      }
    })

  }else{
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Stock Ideal Mínimo = 3u'});
  }


})

$(".tablaInventarioMovil tbody").on("change", ".editZonaMovil", function(){ // EVITAR ESPACIOS Y TODO A MAYUSCULA
  let resultado = $(this).val($(this).val().toUpperCase().replace(/\s/g, ''));
})


$(".tablaInventarioMovil tbody").on("click", ".btnEditZonaMovil", function(){
  var idProd = $(this).attr('idProd');
  var sku = $(this).attr('skuProd');
  var zona = $('#editZonaMovil'+idProd).val();
  var datos = new FormData();
  datos.append("modifUbic", idProd);
  datos.append("zonaSucursal", zona);
  $.ajax({
    url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(resp){
      var r = resp.split(',');
      audioSuccess('Ubicación Actualizada');
      $('#zonaMovil'+idProd).text(r[2].toUpperCase()+'-'+sku)
    }
  })
})


/*=============================================
ACTIVAR/DESACTIVAR PRODUCTO --> OK
=============================================*/
$(".tablaInventarioMovil tbody").on("click", ".btnActProd", function(){
  // toastr.clear(); // desvanecer las otras alertas toastr
  var idProd = $(this).attr("idProd");
  var estadoProd = $(this).attr("estadoProd");
  var datos = new FormData();
  datos.append("activarId", idProd);
  datos.append("activarProd", estadoProd);
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
        success:function(r){
          var resp = r.split(',');
          if(resp[1]==1){
            Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Activado'});
          }else{
            Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Desactivado'});
          }
        }
    })

    if(estadoProd == 0){

      $(this).removeClass('btn-success');
      $(this).addClass('btn-danger');
      $(this).html('Desactivado');
      $(this).attr('estadoProd',1);
      $(this).tooltip('hide');
      $(this).attr("data-original-title","Activar");

    }else{

      $(this).addClass('btn-success');
      $(this).removeClass('btn-danger');
      $(this).html('Activado');
      $(this).attr('estadoProd',0);
      $(this).tooltip('hide');
      $(this).attr("data-original-title","Desactivar");

    }

})

/*=============================================
RESTAR STOCK -->OK
=============================================*/
$(".tablaInventarioMovil tbody").on("click", ".btnRestStock", function(){
  var idProd = $(this).attr("idProd");
  var ideal = $(this).attr("ideal");
  var cant = $(this).parent().children('.stockVista');
  var stk = cant.text().split('/');
  var resta = (Number(stk[0]) - 1)+'/'+stk[1];
  // color stock dinámico
  if((Number(stk[0]) - 1)<=ideal/3){
    cant.removeClass('btn-success');
    cant.removeClass('btn-warning');
    cant.addClass('btn-danger');
  }else if((Number(stk[0]) - 1)>ideal/3  && (Number(stk[0]) - 1)<ideal/1.5){
    cant.removeClass('btn-success');
    cant.removeClass('btn-danger');
    cant.addClass('btn-warning');
  }else{
    cant.removeClass('btn-warning');
    cant.removeClass('btn-danger');
    cant.addClass('btn-success');
  }

  if(Number(stk[0]) == 0){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'No puede seguir descontando productos'});

  }else{
    $(this).attr('disabled','disabled');
    var datos = new FormData();
    datos.append("restStock", idProd);
    datos.append("resta", resta);
    datos.append("ideal", ideal);
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'warning',title: '-1'});
          // SE DEBE IDENTIFICAR POR ID PARTICULAR, DEBIDO A QUE AJAX NO PERMITE ENTRAR AL ELEMENTO POR $(this)
          $('#stkVis'+idProd).children('.stockVista').html(resp[1]+'/'+stk[1]); // RESTA VISUAL EN ELEMENTO
          $('#stkVis'+idProd).children('.botonesStkIdeal').children('.btnBajarStkIdeal').attr("stockActual", resp[1]-1); // CAMBIA EL VALOR DE STOCK ACTUAL EN BOTONES QUE VARIAN STOCK IDEAL
          $('#stkVis'+idProd).children('.botonesStkIdeal').children('.btnSubirStkIdeal').attr("stockActual", resp[1]-1); // CAMBIA EL VALOR DE STOCK ACTUAL EN BOTONES QUE VARIAN STOCK IDEAL   
          $('#fecha'+idProd).html(resp[4]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
          $('#btnRestStock'+idProd).removeAttr('disabled');
          checkeoStock(idProd);
          $('#stockDispMovil'+idProd).text(resp[1]+'/'+stk[1]);
        }
      }
    })
  }
})

/*=============================================
SUMAR STOCK --> OK
=============================================*/
$(".tablaInventarioMovil tbody").on("click", ".btnSumStock", function(){
  $(this).attr('disabled','disabled');
  var idProd = $(this).attr("idProd");
  var ideal = $(this).attr("ideal");
  var cant = $(this).parent().children('.stockVista');
  var stk = cant.text().split('/');
  var suma = (Number(stk[0]) + 1)+'/'+stk[1];
  // color stock dinámico
  if((Number(stk[0]) + 1)<=ideal/3){
    cant.removeClass('btn-success');
    cant.removeClass('btn-warning');
    cant.addClass('btn-danger');
  }else if((Number(stk[0]) + 1)>ideal/3  && (Number(stk[0]) + 1)<ideal/1.5){
    cant.removeClass('btn-success');
    cant.removeClass('btn-danger');
    cant.addClass('btn-warning');
  }else{
    cant.removeClass('btn-warning');
    cant.removeClass('btn-danger');
    cant.addClass('btn-success');
  }
  var datos = new FormData();
  datos.append("sumStock", idProd);
  datos.append("suma", suma);
  datos.append("idealSuma", ideal);
    $.ajax({
    url:"ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(r){
      var resp = r.split(',');
      if(resp[0]=='ok'){
        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: '+1'});
        // SE DEBE IDENTIFICAR POR ID PARTICULAR, DEBIDO A QUE AJAX NO PERMITE ENTRAR AL ELEMENTO POR $(this)
        $('#stkVis'+idProd).children('.stockVista').html(resp[1]+'/'+stk[1]); // SUMA VISUAL EN ELEMENTO
        $('#stkVis'+idProd).children('.botonesStkIdeal').children('.btnBajarStkIdeal').attr("stockActual", Number(resp[1])+1); // CAMBIA EL VALOR DE STOCK ACTUAL EN BOTONES QUE VARIAN STOCK IDEAL
        $('#stkVis'+idProd).children('.botonesStkIdeal').children('.btnSubirStkIdeal').attr("stockActual", Number(resp[1])+1); // CAMBIA EL VALOR DE STOCK ACTUAL EN BOTONES QUE VARIAN STOCK IDEAL   
        $('#fecha'+idProd).html(resp[4]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS
        $('#btnSumStock'+idProd).removeAttr('disabled');
        checkeoStock(idProd);

        $('#stockDispMovil'+idProd).text(resp[1]+'/'+stk[1]);
      }
    }
  })

})

/*-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
/*=============================================
EDITAR STOCK    --->OK
=============================================*/
// INTERFAZ DE EDICION DE STOCK
$(".tablaInventarioMovil tbody").on("click", ".stockVista", function(){    
  var idProd = $(this).attr("idProd");
  // INPUTS EDICION
  var inventario = $(this).text();
  var stk = inventario.split('/');
  var stock = stk[0];
  var ideal = stk[1]; 

  // COLOR DE BOTON STOCK DINAMICO
  if(stock<=ideal/3){
    var color = 'danger';
  }else if(stock>ideal/3  && stock<ideal/1.5){
    var color = 'warning';
  }else{
    var color = 'success';
  }


  // SCRIPT PARA IDENTIFICAR LOS 2 ULTIMOS ID'S ABIERTOS
  contador++;
  if(contador==1){
    localStorage.setItem("primerStockVista", stock);
    localStorage.setItem("primerStockIdealVista", ideal);
    localStorage.setItem("primerColorVista", color);
    localStorage.setItem("primerIdStockVista", idProd);
    // INTERFAZ PARA INGRESAR CAMBIO DE STOCK
    $('#stkVis'+localStorage.getItem('primerIdStockVista')).html(
        '<input type="text" style="width:110px" class="form-control input-xs" onkeypress="return soloNumeros(event)" name="editStock" id="editStock" placeholder="stock" value="'+stock+'" required>'+
        '<button style="width:110px" class="btn btn-info btn-xs btnEditStock" id="btnEditStock'+idProd+'" stock="'+stock+'" idProd="'+idProd+'" ideal="'+ideal+'">Actualizar Stock</button>');
    $('#editStock').select();

  }else if(contador==2){
    localStorage.setItem("ultimoStockVista", stock);
    localStorage.setItem("ultimoStockIdealVista", ideal);
    localStorage.setItem("ultimoColorVista", color);
    localStorage.setItem("ultimoIdStockVista", idProd);
    // A LA NORMALIDAD EL BOTON ANTERIOR
    $('#stkVis'+localStorage.getItem('primerIdStockVista')).html('<button class="btn btn-default btnRestStock" id="btnRestStock'+localStorage.getItem('primerIdStockVista')+'" ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+'>&darr;</button>'+
      '<button style="text-align:right" class="btn btn-'+localStorage.getItem('primerColorVista')+' stockVista" stk='+localStorage.getItem('primerStockVista')+' ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+' style="width:50px">'+localStorage.getItem('primerStockVista')+'/'+localStorage.getItem('primerStockIdealVista')+'</button>'+
      '<button class="btn btn-default btnSumStock" id="btnSumStock'+localStorage.getItem('primerIdStockVista')+'"  ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+'>&uarr;</button>');
    // INTERFAZ PARA INGRESAR CAMBIO DE STOCK
    $('#stkVis'+localStorage.getItem('ultimoIdStockVista')).html('<input type="text" style="width:110px" class="form-control input-xs" onkeypress="return soloNumeros(event)" name="editStock" id="editStock" placeholder="stock" value="'+stock+'" required>'+
                          '<button style="width:110px" class="btn btn-info btn-xs btnEditStock" id="btnEditStock'+idProd+'" stock="'+stock+'" idProd="'+idProd+'" ideal="'+ideal+'">Actualizar Stock</button>');
    $('#editStock').select();


  }else{
    localStorage.setItem("primerIdStockVista", localStorage.getItem("ultimoIdStockVista"));
    localStorage.setItem("primerStockVista", localStorage.getItem("ultimoStockVista"));
    localStorage.setItem("primerStockIdealVista", localStorage.getItem("ultimoStockIdealVista"));
    localStorage.setItem("primerColorVista", localStorage.getItem("ultimoColorVista"));
    localStorage.setItem("ultimoStockVista", stock);
    localStorage.setItem("ultimoStockIdealVista", ideal);
    localStorage.setItem("ultimoColorVista", color);
    localStorage.setItem("ultimoIdStockVista", idProd);
    // A LA NORMALIDAD EL BOTON ANTERIOR
    $('#stkVis'+localStorage.getItem('primerIdStockVista')).html('<button class="btn btn-default btnRestStock" id="btnRestStock'+localStorage.getItem('primerIdStockVista')+'" ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+'>&darr;</button>'+
      '<button style="text-align:right" class="btn btn-'+localStorage.getItem('primerColorVista')+' stockVista" stk='+localStorage.getItem('primerStockVista')+' ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+' style="width:50px">'+localStorage.getItem('primerStockVista')+'/'+localStorage.getItem('primerStockIdealVista')+'</button>'+
      '<button class="btn btn-default btnSumStock" id="btnSumStock'+localStorage.getItem('primerIdStockVista')+'"  ideal='+localStorage.getItem('primerStockIdealVista')+' idProd='+localStorage.getItem('primerIdStockVista')+'>&uarr;</button>');
    // INTERFAZ PARA INGRESAR CAMBIO DE STOCK
    $('#stkVis'+localStorage.getItem('ultimoIdStockVista')).html('<input type="text" style="width:110px" class="form-control input-xs" onkeypress="return soloNumeros(event)" name="editStock" id="editStock" placeholder="stock" value="'+stock+'" required>'+
                          '<button style="width:110px" class="btn btn-info btn-xs btnEditStock" id="btnEditStock'+idProd+'" stock="'+stock+'" idProd="'+idProd+'" ideal="'+ideal+'">Actualizar Stock</button>');
    $('#editStock').select();
  }
})

// CAMBIO EN LA BASE DE DATOS
$(".tablaInventarioMovil tbody").on("click", ".btnEditStock", function(){
  var idProd = $(this).attr("idProd");
  var cant = $(this).parent().children('#editStock').val();
  var ideal = $(this).attr('ideal');
  var stock = $(this).attr('stock');

  if(cant<=ideal/3){ // COLOR DE BOTON STOCK DINAMICO
    var color = 'danger';
  }else if(cant>ideal/3  && cant<ideal/1.5){
    var color = 'warning';
  }else{
    var color = 'success';
  }

  var datos = new FormData();
  datos.append("editStock", idProd);
  datos.append("cant", cant);
  datos.append("ideal", ideal);

  if(cant == stock){

      $('#stkVis'+idProd).html(
          '<button class="btn btn-default btnRestStock info" data-original-title="-1" id="btnRestStock'+idProd+'" ideal='+ideal+' idProd='+idProd+'>&darr;</button>'+
          '<button style="text-align:right" class="btn btn-'+color+' stockVista" stk='+cant+' ideal='+ideal+' idProd='+idProd+' style="width:50px">'+cant+'/'+ideal+'</button>'+
          '<button class="btn btn-default btnSumStock info" data-original-title="+1" id="btnSumStock'+idProd+'" ideal='+ideal+' idProd='+idProd+'>&uarr;</button>');
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'info',title: 'No se registraron cambios'})        

  }else if(cant != stock && cant != ''){
    $.ajax({
      url:"ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      beforeSend: function() {
        $('#btnEditStock'+idProd).removeAttr('style');
        $('#btnEditStock'+idProd).removeClass('btn-info');
        $('#btnEditStock'+idProd).addClass('btn-default');
        $('#btnEditStock'+idProd).attr('disabled','disabled');
        $('#btnEditStock'+idProd).html("<div style='text-align:center'>ACTUALIZANDO STOCK...</div>");
      },      
      success:function(r){
        var resp = r.split(',');
        if(resp[0]=='ok'){
          $('#stkVis'+idProd).html('<button class="btn btn-default btnRestStock info" data-original-title="-1" id="btnRestStock'+idProd+'" ideal='+ideal+' idProd='+idProd+'>&darr;</button>'+
            '<button style="text-align:right" class="btn btn-'+color+' stockVista" stk='+cant+' ideal='+ideal+' idProd='+idProd+' style="width:50px">'+cant+'/'+ideal+'</button>'+
            '<button class="btn btn-default btnSumStock info" data-original-title="+1" id="btnSumStock'+idProd+'" ideal='+ideal+' idProd='+idProd+'>&uarr;</button>');
          $('#fecha'+idProd).html(resp[4]); // SE RECIBE EN POSICION 4 LA FECHA INGRESADA A BASE DE DATOS

          checkeoStock(idProd);
          localStorage.clear();
          contador=0;
          $('#stockDispMovil'+idProd).text(cant+'/'+ideal);

        }
      }
    })
  }
})
/*-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/