/*=============================================
RANGO DE FECHAS
=============================================*/
if(localStorage.getItem("capturarRango6") != null){
    $("#daterange-btn6 span").html(localStorage.getItem("capturarRango6"));
}else{
    $("#daterange-btn6 span").html('<i class="fa fa-calendar"></i> Rango de fecha')
}

$('#daterange-btn6').daterangepicker(
    {
        ranges: {
            'Home'       : [moment().subtract(1, 'month'), moment()],
            'Este mes'  : [moment().startOf('month'), moment().endOf('month')],
            'Mes Anterior'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Este año'  : [moment().startOf('year'), moment().endOf('year')],
            'Año Anterior'  : [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        },
        startDate: moment(),
        endDate  : moment()
    },
    function (start, end){
        var fechaInicial = start.format('YYYY-MM-DD');
        var fechaFinal = end.format('YYYY-MM-DD');
        var hoy = moment(new Date()).format('YYYY-MM-DD');
        var fecha1 = fechaInicial;
        var fecha2 = fechaFinal;
        $('#daterange-btn6 span').html(moment(fecha1).format('DD-MM-YY') + ' - ' + moment(fecha2).format('DD-MM-YY'));
        var capturarRango = $("#daterange-btn6 span").html();
        localStorage.setItem("capturarRango6", capturarRango);
        window.location = "index.php?ruta=intercambio-stock&fechaInicial="+fecha1+"&fechaFinal="+fecha2;
    }
)


/*=============================================
CARGAR TABLA INTERCAMBIO STOCK (ÚLTIMOS 2 MESES)
=============================================*/
$('.tablaIntercambioStock').DataTable({
  "ajax": "ajax/datatable-intercambio-stock.ajax.php?fechaInicial="+obtenerGET(window.location)['fechaInicial']+"&fechaFinal="+obtenerGET(window.location)['fechaFinal'],
  "order": [[ 0, "desc" ]], //orden descendente por defecto
  "deferRender": true,
  "retrieve": true,
  "mark": true,
  "processing": true,
  "pageLength": 10,
  "language": {

    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  }
});

/*=============================================
CARGAR TABLA INTERCAMBIO STOCK (TODOS)
=============================================*/
$('.tablaIntercambioStockAll').DataTable({
  "ajax": "ajax/datatable-intercambio-stock-all.ajax.php",
  "order": [[ 0, "desc" ]], //orden descendente por defecto
  "deferRender": true,
  "retrieve": true,
  "mark": true,
  "processing": true,
  "pageLength": 10,
  "language": {

    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  }
});

/*=============================================
CARGAR TABLA INTERCAMBIO STOCK MOVIL
=============================================*/
$('.tablaIntercambioStockMovil').DataTable({
  "ajax": "ajax/datatable-intercambio-stock-movil.ajax.php",
  "order": [[ 0, "desc" ]], //orden descendente por defecto
  "deferRender": true,
  "retrieve": true,
  "mark": true,
  "processing": true,
  "pageLength": 10,
  "language": {
    "sProcessing": "Procesando...",
    "sLengthMenu": "Mostrar _MENU_ registros",
    "sZeroRecords": "No se encontraron resultados",
    "sEmptyTable": "Ningún dato disponible en esta tabla",
    "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix": "",
    "sSearch": "Buscar",
    "sUrl": "",
    "sInfoThousands": ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
      "sFirst": "Primero",
      "sLast": "Último",
      "sNext": "&rarr;",
      "sPrevious": "&larr;"
    },
    "oAria": {
      "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  },
  dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',
});

/*=============================================
CARGAR TABLA PRODUCTOS A INTERCAMBIAR
=============================================*/
$('.tablaAbastecimientoInterno').DataTable({
  "ajax": "ajax/datatable-abastecimiento-interno.ajax.php?bodega="+obtenerGET(window.location)['bodega']+"&suc="+obtenerGET(window.location)['suc'],
  "order": [[ 2, "asc" ],[ 3, "desc" ]], //orden descendente por defecto  
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 25,
  "language":{
    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  },
  dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
  buttons:
  [
    { // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
      text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
      action: function ( e, dt, node, config ) {
        dt.clear().draw();
        dt.ajax.reload();
      }
    }       
  ]
});

/*=============================================
IMPRIMIR CODIGOS DE BARRA
=============================================*/
$('.tablaIntercambioStock,.tablaIntercambioStockAll').on('click', '.imprimirCodigosBarra', function(){
  var idCompra = $(this).attr('idCompra');
  var datos = new FormData();
  datos.append('datosIntercambio', idCompra);
  $.ajax({
    url:'ajax/intercambios-stock.ajax.php',
    method: 'POST',
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(respuesta){
      r = JSON.parse(respuesta);
      productosComprados = JSON.parse(r.abastecimiento);
      $('#contenidoImprimirCodigos').html('');
      $(productosComprados).each(function (i){
        textoCant = i == 0 ? 'Cant Etiquetas' : '';
        textoProd = i == 0 ? 'Producto' : '';

        $('#contenidoImprimirCodigos').append(
              '<div class="col-3 ingCantAbast" style="padding-left:0px">'+
                '<font size="-1"><b>'+textoCant+'</b></font>'+
                '<div class="input-group">'+
                  '<input type="number" class="form-control form-control-sm cantCodsBarra" id="cantCodsBarra" idProd="'+productosComprados[i].id+'" value="'+productosComprados[i].cant+'">'+
                '</div>'+
              '</div>'+
              '<div class="col-9 ingPCompAbastNeto" style="padding-left:0px">'+
                '<font size="-1"><b>'+textoProd+'</b></font>'+
                '<div class="input-group">'+productosComprados[i].cant+' '+infoProd(productosComprados[i].id)['descripcion']+
                '</div>'+
              '</div>'
          )
      });
    }
  })  
})

// /*=============================================
// ABASTERCIMIENTO INTERNO PARA DISPOSITIVOS ---> SOLO ADMINISTRADOR
// =============================================*/
$('#selectProdAbastInternoMovil').change(function(){ //OK
  var get = obtenerGET(window.location);
  var bodega = get['bodega']; // actua como bodega
  var local = get['suc']; // actua como local

  var idProducto = $(this).val();
  if(idProducto == 0){
    $("#infoProdAbastInternoMovil").html('');
    $('#agregarProdAbastInternoMovil').attr('disabled','disabled');
  }else{

    $('#agregarProdAbastInternoMovil').removeAttr('disabled');   
    var datos = new FormData();
    datos.append("idProducto", idProducto);
    $.ajax({
      url: "ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        $('#agregarProdAbastInternoMovil').attr('idProd', idProducto);
        var imagen = '<br><img style="float:left" id="imagenZoom" src="'+respuesta['imagen']+'" alt="'+respuesta["descripcion"]+'" class="imagenZoom" width="150px" idProducto="'+idProducto+'" data-toggle="modal" data-target="#modalZoomProducto">';
        $("#imagenZoomModal").attr("src", respuesta["imagen"]);
        $("#tituloModalZoom").text(respuesta["descripcion"]);

        $("#infoProdAbastInternoMovil").html(
            '<div class="row">'+
              '<div class="col-12">'+
                '<font>'+respuesta["descripcion"]+'</font>'+
              '</div>'+
              '<div class="col-6">'+
                  imagen+
              '</div>'+
              '<div class="col-6">'+
                '<font size="-1"><br><br><br>'+
                  'Stock <i>'+local.toUpperCase()+'</i>: <b>'+formatNumber.new(respuesta['stock_'+local])+'</b><br>'+
                  '<font style="color:blue">Stock <i>'+bodega.toUpperCase()+'</i>: <b>'+formatNumber.new(respuesta['stock_'+bodega])+'</b></font>'+
                '</font>'+
              '</div>'+
            '</div>'+
            '<div id="esp'+idProducto+'" style="height:3px"></div>')
      }
    })  
  }
})

$('#agregarProdAbastInternoMovil').click(function(){
  var get = obtenerGET(window.location);
  var bodega = get['bodega']; // actua como bodega
  var local = get['suc']; // actua como local
  var idProducto = $(this).attr("idProd");
  $('#modalAbastecimientoInternoMovil').modal('hide');
  $("#selectProdAbastInternoMovil").val(0).trigger('change'); // reset select

  var datos = new FormData();
  datos.append("idProducto", idProducto);

  $.ajax({

    url: "ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      stockLocal = respuesta['stock_'+local];
      stockBodega = respuesta['stock_'+bodega];
      descripcionInicial = respuesta["descripcion"];
      largoDescripcionInicial = descripcionInicial.length;
      espacios = ' ';
      if(Number(largoDescripcionInicial)<45){
        descripcion = respuesta["descripcion"]+' '+espacios.repeat(45-largoDescripcionInicial);
      }else{
        descripcion = respuesta["descripcion"];
      }
      sku = Number(respuesta["categoria"]) <= 9 ? '0'+respuesta["sku"] : respuesta["sku"];
      codigos = sku+'-'+respuesta["zona_"+bodega];
      $(".prodAbastInterno").prepend(
        '<div class="row mb-1" id="borde" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-color:red;">'+
          '<div class="col-3 ingCantAbast" style="padding-left:0px">'+
            '<font size="-2">Cantidad</font>'+
            '<div class="input-group">'+
              '<input type="number" class="form-control form-control-sm cantAbastInterno" idProd="'+idProducto+'" stk="'+stockLocal+'" min="0" max="'+stockBodega+'" value="0" id="cantAbastInterno" required>'+
            '</div>'+
          '</div>'+
          '<div class="col-8 ingPCompAbastNeto" style="padding-left:0px;padding-right:0px">'+
            '<font size="-1"><b>'+codigos+'</b><br>'+descripcion+'</font>'+
          '</div>'+
          '<div class="col-1 ingPCompAbastNeto" style="padding-left:0px;padding-right:0px">'+
            '<button type="button" class="btn btn-danger float-right btn-xs quitarProdAbastInterno" idProducto="'+idProducto+'"><i class="fa fa-times"></i></button> '+
        '</div>'+
        '<div id="esp'+idProducto+'" style="height:3px"></div>')
    }
  })
  setTimeout(function(){
    listarProductos();
      $('#nuevaCantidadProducto').select();
  }, 300);

})

$('#modalAbastecimientoInternoMovil').on('shown.bs.modal', function (e) {
  var prodsIngresados = [];
  $('.cantAbastInterno').each(function (i){
    idIngresados = $(this).attr('idProd');
    prodsIngresados.push(idIngresados);
  });
  // ELIMINA LA OPCIÓN QUE YA SE INGRESÓ A LA VENTA
  for (var i = 0; i < prodsIngresados.length; i++) {
    $('#selectProdAbastInternoMovil option[value="'+prodsIngresados[i]+'"]').remove();
  }
  $("#infoProdAbastInternoMovil").html('');
})

/*=============================================
VER INTERCAMBIO STOCK PDF
=============================================*/
$(".tablaIntercambioStock,.tablaIntercambioStockAll,.tablaIntercambioStockMovil").on("click", ".btnVerPDFIntercambioInterno", function(){
  var id = $(this).attr("idCompra");
  window.open("extensiones/tcpdf/pdf/intercambio-stock.php?codigo=" + id+"&motivo=ver", "_blank");
})

/*=============================================
EVITAR PROBLEMAS DE ABASTECER MISMA BODEGA
=============================================*/
$('#bodegaAbast').change(function(){
  var seleccion = $(this).val();
  if(seleccion == 0){
    $("#sucurAbastBodega").attr('disabled','disabled');
  }else{
    var llamarSucursales = 'todas';
    var datos = new FormData();
    datos.append("llamarSucursales", llamarSucursales);
    $.ajax({
      url:"ajax/sucursales.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
      success:function(sucursales){
        $("#sucurAbastBodega").html('<option value="0">Seleccione Sucursal</option>');
        $("#sucurAbastBodega").removeAttr('disabled');
        $(sucursales).each(function (i){
          if(sucursales[i].nombre_sucursal != seleccion){ // descarta la bodega de abastecimiento
            $("#sucurAbastBodega").append("<option value='"+sucursales[i].nombre_sucursal+"'>"+sucursales[i].alias_sucursal.toUpperCase()+"</option>");
          }
        });
      }
    })
  }
})

/*=============================================
QUITAR PRODUCTOS DE ABASTECIMIENTO INTERNO
=============================================*/
var idQuitarProdAbast = [];
localStorage.removeItem("quitarProdAbastInterno");
$(".formularioAbastecimientoInterno").on("click", "button.quitarProdAbastInterno", function(){
  $(this).parent().parent().parent().children('#esp'+$(this).attr('idProducto')).remove();
  $(this).parent().parent().remove();
  var idProducto = $(this).attr("idProducto");
  /*=============================================
  ALMACENAR EN EL LOCALSTORAGE EL ID DEL PRODUCTO A QUITAR
  =============================================*/
  if (localStorage.getItem("quitarProdAbastInterno") == null) {
    idQuitarProdAbast = [];
  } else {
    idQuitarProdAbast.concat(localStorage.getItem("quitarProdAbastInterno"))
  }

  idQuitarProdAbast.push({
    "idProducto": idProducto
  });

  localStorage.setItem("quitarProdAbastInterno", JSON.stringify(idQuitarProdAbast));

  $("button[idProd='" + idProducto + "']").removeAttr('disabled');
  $("button.recuperarBoton[idProd='" + idProducto + "']").addClass('abastecerInternoProd');
  $("button[idProd='" + idProducto + "']").removeClass('recuperarBoton');
  listarAbastecimientoInterno()

})

/*=============================================
CANTIDAD ABASTECIMEINTO INTERNO
=============================================*/
$(".formularioAbastecimientoInterno").on("change", "input.cantAbastInterno", function(){
  if($(this).val()<=0){ // NO PERMITE COMPRAR CERO O MENOS UNIDADES 
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'No puedes comprar 0 unidades'});

    $(this).val(1);
    $(this).parent().parent().parent().removeAttr('style');
    $(this).parent().parent().parent().attr('style','padding:5px 20px; border-style: dashed; border-width: 1px;');    
  }else if(Number($(this).val())>Number($(this).attr('max'))){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Bodega solo tiene '+$(this).attr('max')+' unidades'});

    $(this).val($(this).attr('max'));
    $(this).parent().parent().parent().removeAttr('style');
    $(this).parent().parent().parent().attr('style','padding:5px 20px; border-style: dashed; border-width: 1px;');    
  }else{ // ELIMINA BORDE ROJO SI TODO ESTA BIEN CON STOCK_COMPRA
    $(this).parent().parent().parent().removeAttr('style');
    $(this).parent().parent().parent().attr('style','padding:5px 20px; border-style: dashed; border-width: 1px;');    
  }
  listarAbastecimientoInterno()
  actualizarTotalCompra()
});

/*=============================================
ENVIAR FORMULARIO ABASTECIMIENTO
=============================================*/
function enviarAbastecimientoInterno(motivo) {
  var abastecimiento = $("#abastecimientoInterno").val();
  var buscar_ceros = 0;
  $(".cantAbastInterno").each(function(){
    if($(this).val()==0){
      buscar_ceros += 1; // PARA ENVIAR ALERTA DE CUANTOS PRODUCTOS NO SE ESTA INGRESANDO STOCK
    }
  });

  if(abastecimiento == "[]" || abastecimiento == "") {
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe agregar productos'});

  }else if(buscar_ceros==1){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Falta ingresar stock comprado de 1 producto, fijarse en borde rojo'});

  }else if(buscar_ceros>1){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Falta ingresar stock comprado de '+buscar_ceros+' productos, fijarse en borde rojo'});
  }else{
    $('#motivo').val(motivo); //PASAR MOTIVO DEL FORMULARIO
    document.forms[0].submit();
  }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*=============================================
FUNCIONES PERSONALIZADAS
=============================================*/
// CONFIGURACION PARA ABASTECIMIENTO INTERNO
function abastDesdeBodega(){
  var bodega = $('#bodegaAbast').val();
  var sucursal = $('#sucurAbastBodega').val();
  window.open("index.php?ruta=abastecimiento-interno&bodega="+bodega+"&suc="+sucursal, "_blank");
  $('#bodegaAbast').val(0);
  $('#sucurAbastBodega').val(0);
  $('#modalAbastInterno').modal('hide');
}

// LISTAR ABASTECIMIENTO INTERNO
function listarAbastecimientoInterno() {
  var listaProds = [];
  var cant = $(".cantAbastInterno");
  for (var i = 0; i < cant.length; i++) {
    var cantAbast = Number($(cant[i]).val());

    listaProds.push({
      "id": $(cant[i]).attr("idProd"),
      "cant": cantAbast
    })
  }
  $(".abastecimientoInterno").val(JSON.stringify(listaProds));
}


/*===============================================
AGREGANDO PRODUCTOS ABASTECIMIENTO INTERNO MANUAL
===============================================*/
$(".tablaAbastecimientoInterno tbody").on("click", ".abastecerInternoProd", function(){
  var getVentana = window.location.search.split('&');
  var bodega = getVentana[1].substring(7);
  var sucursal = getVentana[2].substring(4);
  var idProducto = $(this).attr("idProd");
  $(this).removeClass("abastecerInternoProd");
  $("button[idProd='" + idProducto + "']").attr("disabled",'disabled');
  $("button[idProd='" + idProducto + "']").addClass('recuperarBoton');
  var datos = new FormData();
  datos.append("idProducto", idProducto);
  $.ajax({
    url: "ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var descripcionInicial = respuesta["descripcion"];
      var largoDescripcionInicial = descripcionInicial.length;
      var espacios = ' ';
      if(Number(largoDescripcionInicial)<100){
        var descripcion = respuesta["descripcion"]+' '+espacios.repeat(100-largoDescripcionInicial);
      }
      var sku = Number(respuesta["categoria"]) <= 9 ? '0'+respuesta["sku"] : respuesta["sku"];
      var codigos = sku+'-'+respuesta["zona_"+bodega];
      // var codigoInterno = respuesta["sku"];
      var stock = respuesta["stock_"+sucursal];
      var stock_bodega = respuesta["stock_"+bodega];
      $(".prodAbastInterno").prepend(
        '<div class="row mb-1" id="borde" style="padding:5px 20px; border-style: dashed; border-width: 2px; border-color:red;">'+
          '<div class="col-2 ingCantAbast" style="padding-left:0px">'+
            '<span class="input-group-addon" style="height: 40px"><i class="fa fa-cubes"></i></span> <font size="-2">Cantidad</font>'+
            '<div class="input-group">'+
              '<input type="number" style="height: 40px" class="form-control cantAbastInterno" idProd="'+idProducto+'" stk="'+stock+'" min="0" max="'+stock_bodega+'" value="0" id="cantAbastInterno" required>'+
            '</div>'+
          '</div>'+
          '<div class="col-9 ingPCompAbastNeto" style="padding-left:0px;padding-right:0px">'+
            '<font size="5.5"><b>'+codigos+'</b> '+descripcion+'</font>'+
          '</div>'+
          '<div class="col-1 ingPCompAbastNeto" style="padding-left:0px;padding-right:0px">'+
            '<button type="button" class="btn btn-danger float-right btn-sm quitarProdAbastInterno" idProducto="'+idProducto+'"><i class="fa fa-times"></i></button> '+
        '</div>'+
        '<div id="esp'+idProducto+'" style="height:3px"></div>')
      listarAbastecimientoInterno();
    }
  })
});