async function extraerDatosVentaTicket(idVenta,obj){
	var datos = new FormData();
  	datos.append("datosVenta", idVenta);
   	$.ajax({
		url:"ajax/ventas.ajax.php",
  		method: "POST",
  		data: datos,
  		cache: false,
  		contentType: false,
  		processData: false,
      	success:function(r){
      		infoVenta = JSON.parse(r);
      		if(infoVenta['vista_vendedor'] == 1){
				// imprimirTicketVentaJS(infoVenta['cod_venta'],infoVenta['fecha_venta'],infoVenta['nom_vend'],infoVenta['nom_client'],infoVenta['productos'],infoVenta['total'],infoVenta['tipo_pago'],infoVenta['metodo_pago'],infoVenta['detalle_flete'],infoVenta['vista_vendedor'])
				imprimirTicketVentaJS(infoVenta['cod_venta'],infoVenta['fecha_venta'],infoVenta['nom_vend'],infoVenta['nom_client'],infoVenta['productos'],infoVenta['total'],infoVenta['tipo_pago'],infoVenta['metodo_pago'],infoVenta['detalle_flete'])
				.then((resultado) => {
					audioSuccess('Imprimiendo');
					obj.removeAttr('disabled');
					$('.imprimirUltimoTicketCabecera').html(
						'<a class="nav-link" data-original-title="IMPRIMIR ULTIMO TICKET" data-placement="bottom" href="#" onclick="extraerDatosVentaTicket(\'ultima\',$(this));$(\'.imprimirUltimoTicketCabecera\').html(\'\')" role="button">'+
							'<i class="fas fa-print"></i>'+
						'</a>');
				})
      		}else{
      			// audioError('No se puede imprimir venta de SOCIOS');

				imprimirTicketVentaSocioJS(infoVenta['cod_venta'],infoVenta['fecha_venta'],infoVenta['nom_vend'],infoVenta['nom_client'],infoVenta['productos'],infoVenta['total'],infoVenta['tipo_pago'],infoVenta['metodo_pago'],infoVenta['detalle_flete'])
				.then((resultado) => {
					audioSuccess('Imprimiendo');
					obj.removeAttr('disabled');
					$('.imprimirUltimoTicketCabecera').html(
						'<a class="nav-link" data-original-title="IMPRIMIR ULTIMO TICKET" data-placement="bottom" href="#" onclick="extraerDatosVentaTicket(\'ultima\',$(this));$(\'.imprimirUltimoTicketCabecera\').html(\'\')" role="button">'+
							'<i class="fas fa-print"></i>'+
						'</a>');
				})

      		}
    	}
   	})
}


async function imprimirTicketVentaSocioJS(codVenta,fechaHora,nomVend,nomCliente,listaProductos,totalVenta,tipoPago,metodoPago,infoFlete){
	var nombreImpresora = ajuste('nombre_impresora_termica');
	var api_key = ajuste('api_key_impresora_termica');
	var nombreComercial = reemplazarTildes(ajuste('nombre_comercial').toUpperCase());
	var nombreReal = reemplazarTildes(ajuste('nombre_real').toUpperCase());
	var direccion = reemplazarTildes(ajuste('direccion_comercial').toUpperCase());
	var wspLocal1 = ajuste('wsp_local1');

	var fechaTicketJS = fechaHora.split(' ')[0].split('-')[2]+'-'+fechaHora.split(' ')[0].split('-')[1]+'-'+fechaHora.split(' ')[0].split('-')[0]+' '+fechaHora.split(' ')[1];
	var cantInfoNomVend = nomVend.split(' ').length;
	var vendedor = Number(cantInfoNomVend) >= 2 ? 'Vend: '+  nomVend.split(' ')[0].toUpperCase() + ' ' + nomVend.split(' ')[1].substring(0,1).toUpperCase() + '.' : 'Vend: '+nomVend.toUpperCase();
    var nroEspaciosVendedor = 28 - vendedor.length;
    var vendedorTicket = vendedor.toUpperCase() + " ".repeat(nroEspaciosVendedor)+' '+fechaTicketJS;
    var totalVentaTicket = formatNumber.new(totalVenta);

	var productosMesonID = [];
	var productosMesonCANT = [];
	var productosMesonPV = [];
	var productosMesonTOT = [];
	var productosMesonPROD = [];

	var productosPatioID = [];
	var productosPatioCANT = [];
	var productosPatioPV = [];
	var productosPatioTOT = [];

	var productos_Finales_ID = [];
	var productos_Finales_CANT = [];
	var productos_Finales_PV = [];
	var productos_Finales_TOT = [];
	
	var skuProdComun = ajuste('sku_prod_comun');
	var skuFlete = ajuste('sku_flete');
	var skuInteres = ajuste('sku_interes');

	var productosVenta = JSON.parse(listaProductos);

	$(productosVenta).each(function (i){

        let idProd = productosVenta[i].id;
        
        if(infoProd(idProd)["sku"] == skuFlete || infoProd(idProd)["sku"] == skuInteres){ // PRIMERO REVISA SI HAY FLETES O INTERES
            productos_Finales_ID.push(productosVenta[i]['id']);
            productos_Finales_CANT.push(productosVenta[i]['cant']);
            productos_Finales_PV.push(productosVenta[i]['pV']);
            productos_Finales_TOT.push(productosVenta[i]['tot']);
        }else{

          if(infoProd(idProd)["zona_prod"] == 'patio'){ // TODOS LOS PRODUCTOS DE PATIO, EXCLUYENDO FLETE E INTERES (SE DEJARAN AL FINAL)
              productosPatioID.push(productosVenta[i]['id']);
              productosPatioCANT.push(productosVenta[i]['cant']);
              productosPatioPV.push(productosVenta[i]['pV']);
              productosPatioTOT.push(productosVenta[i]['tot']);
          }else{ // PRODUCTOS MESON
              productosMesonID.push(productosVenta[i]['id']);
              productosMesonCANT.push(productosVenta[i]['cant']);
              productosMesonPV.push(productosVenta[i]['pV']);
              productosMesonTOT.push(productosVenta[i]['tot']);
              productosMesonPROD.push(productosVenta[i]['prod']);
          }
        }
    })
    
	const conector = new connetor_plugin()
                    conector.feed("1")
                    conector.fontsize("3")
                    conector.textaling("center")
                    conector.text(nombreComercial)
                    conector.fontsize("1")
                    conector.text(nombreReal)
                    conector.text(direccion)
                    conector.fontsize("2")
                    conector.textaling("center")
                    conector.text("VENTA: "+codVenta)
                    conector.feed("1")
                    conector.fontsize("1")
                    conector.textaling("left")
                    conector.text(vendedorTicket)
                    conector.feed("1")
                    conector.text("Cliente: "+nomCliente)


					let cantProdsMeson = productosMesonCANT.length;

				    if(Number(cantProdsMeson) > 0){ // SI HAY PRODUCTOS EN MESON
            			conector.text("------------------------------------------------")
						conector.fontsize("2")
						conector.text("PRODUCTOS MESON")
						conector.fontsize("1")
						conector.textaling("left")
						conector.text("SKU     CANT   DESCRIPCION                      ")
						conector.text("------------------------------------------------")

					    for (let i = 0;  i < productosMesonCANT.length ; i++) {
							var idProd = productosMesonID[i];

			                // SKU                  
			                if(infoProd(idProd)["sku"] == skuProdComun){ // detecta prod comun (SKU=000000 y DESCRIPCION=ESCRITO EN DOC)
			                    var sku = '000000 ';
			                    var descSII = productosMesonPROD[i].toUpperCase().substring(0, 25);
			                }else{
			                   	var sku = infoProd(idProd)["categoria"] <= 9 ? '0'+infoProd(idProd)["sku"] : infoProd(idProd)["sku"]; // agrega "0" si catergoria es <= 9
			                    var descSII = infoProd(idProd)["desc_sii"];
			                }

							sku = String(sku);

					        var nroEspaciosSku = 7 - sku.substring(0, 7).length;
					        var nroEspaciosDescripcion = 25 - Number(descSII.length) + 1;
					        var skuTicket = sku+' '.repeat(nroEspaciosSku);
					        var descSIITicket = descSII + " ".repeat(nroEspaciosDescripcion);

					        var cant = productosMesonCANT[i];
					        var cantidad_digitos = cant.length;
					        var nroEspaciosCantItem = Number(cantidad_digitos) > 4 ? 0 : 4 - Number(cantidad_digitos);
					        var cantMostrar =  Number(cantidad_digitos) > 4 ? (Math.round(cant*100))/100 : cant;
					        var cantidadTicket = cantMostrar + " ".repeat(nroEspaciosCantItem);
					        
					        var linea1 = skuTicket +' '+cantidadTicket+'   '+descSIITicket;

			                // TOTAL PRECIO VENTA ITEM
			                var zonaProd = infoProd(idProd)["zona_"+$('#sucursalActiva').val()] === null ? '' : infoProd(idProd)["zona_"+$('#sucursalActiva').val()].substring(0, 7);
							var linea2 = zonaProd;

					        conector.textaling("left");
					        conector.text(linea1);
							conector.text(linea2);
 
						}
					}

					let cantProdsPatio = productosPatioCANT.length;
			        
			        if(cantProdsPatio > 0){
			            
			            if(productosVenta.length > 0){
			                conector.text("------------------------------------------------");
			            }

						conector.fontsize("2");
						conector.textaling("left");
						conector.text("PRODUCTOS PATIO");
						conector.fontsize("1");
						conector.text("SKU     CANT   DESCRIPCION                      ")
						conector.text("------------------------------------------------");

			            
					    for (let i = 0;  i < productosPatioCANT.length ; i++) {

							var idProd = productosPatioID[i];

		                   	var sku = infoProd(idProd)["categoria"] <= 9 ? '0'+infoProd(idProd)["sku"] : infoProd(idProd)["sku"]; // agrega "0" si catergoria es <= 9
		                    var descSII = infoProd(idProd)["desc_sii"];
			                
							sku = String(sku);

					        var nroEspaciosSku = 7 - sku.substring(0, 7).length;
					        var nroEspaciosDescripcion = 25 - Number(descSII.length) + 1;
					        var skuTicket = sku+' '.repeat(nroEspaciosSku);
					        var descSIITicket = descSII + " ".repeat(nroEspaciosDescripcion);

					        var cant = productosPatioCANT[i];
					        var cantidad_digitos = cant.length;
					        var nroEspaciosCantItem = Number(cantidad_digitos) > 4 ? 0 : 4 - Number(cantidad_digitos);
					        var cantMostrar =  Number(cantidad_digitos) > 4 ? (Math.round(cant*100))/100 : cant;
					        var cantidadTicket = cantMostrar + " ".repeat(nroEspaciosCantItem);

					        var linea1 = skuTicket +' '+cantidadTicket+'   '+descSIITicket;

			                // TOTAL PRECIO VENTA ITEM
			                var zonaProd = infoProd(idProd)["zona_"+$('#sucursalActiva').val()] === null ? '' : infoProd(idProd)["zona_"+$('#sucursalActiva').val()].substring(0, 7);
							var linea2 = zonaProd;
							
					        conector.textaling("left");
					        conector.text(linea1);
							conector.text(linea2);
						}
					}

			        // INCORPORACION DE PRODUCTOS FINALES
			        if(productos_Finales_ID.length > 0){

			            conector.text("------------------------------------------------");
			                
			            // for ($i=0; $i < count($productos_Finales_ID); $i++){
						for (let i = 0;  i < productos_Finales_CANT.length ; i++){

							var idProd = productos_Finales_ID[i];

		                   	var sku = infoProd(idProd)["categoria"] <= 9 ? '0'+infoProd(idProd)["sku"] : infoProd(idProd)["sku"]; // agrega "0" si catergoria es <= 9
		                   	var dctoAdicional = 0;
			                if(infoProd(idProd)['sku'] == skuInteres && productos_Finales_TOT[i] < 0){
			                    var descSII = 'DESCUENTO ADICIONAL';
			                    dctoAdicional = Math.abs(productos_Finales_TOT[i]);
			                }else{
			                    var descSII = infoProd(idProd)["desc_sii"];
			                }
			                
							sku = String(sku);

					        var nroEspaciosSku = 7 - sku.substring(0, 7).length;
					        var nroEspaciosDescripcion = 25 - Number(descSII.length) + 1;
					        var skuTicket = sku+' '.repeat(nroEspaciosSku);
					        var descSIITicket = descSII + " ".repeat(nroEspaciosDescripcion);

					        var cant = productos_Finales_CANT[i];
					        var cantidad_digitos = cant.length;
					        var nroEspaciosCantItem = Number(cantidad_digitos) > 4 ? 0 : 4 - Number(cantidad_digitos);
					        var cantidadTicket = " ".repeat(nroEspaciosCantItem) + cant + '*';

					        var linea1 = skuTicket +' '+cantidadTicket+'   '+descSIITicket;

					        conector.textaling("left");
						    conector.text(linea1);

			            }
			        }			            

					conector.textaling("right");
		            conector.text("------------------------------------------------");
					conector.text("SE PAGA CON CREDITO INTERNO");
                    conector.feed("8")
                    conector.cut("0")

	const resp = await conector.imprimir(nombreImpresora, api_key);
	if(resp == true){
		return 'ok';
	}

}

async function imprimirTicketVentaJS(codVenta,fechaHora,nomVend,nomCliente,listaProductos,totalVenta,tipoPago,metodoPago,infoFlete){
	var nombreImpresora = ajuste('nombre_impresora_termica');
	var api_key = ajuste('api_key_impresora_termica');
	var nombreComercial = reemplazarTildes(ajuste('nombre_comercial').toUpperCase());
	var nombreReal = reemplazarTildes(ajuste('nombre_real').toUpperCase());
	var direccion = reemplazarTildes(ajuste('direccion_comercial').toUpperCase());
	var wspLocal1 = ajuste('wsp_local1');

	var fechaTicketJS = fechaHora.split(' ')[0].split('-')[2]+'-'+fechaHora.split(' ')[0].split('-')[1]+'-'+fechaHora.split(' ')[0].split('-')[0]+' '+fechaHora.split(' ')[1];
	var cantInfoNomVend = nomVend.split(' ').length;
	var vendedor = Number(cantInfoNomVend) >= 2 ? 'Vend: '+  nomVend.split(' ')[0].toUpperCase() + ' ' + nomVend.split(' ')[1].substring(0,1).toUpperCase() + '.' : 'Vend: '+nomVend.toUpperCase();
	// var vendedor = Number(cantInfoNomVend) >= 2 ? 'Vend: '+nomVend.split(' ')[0].substring(0,1)+'. '+nomVend.split(' ')[1].substring(0,18)+' ' : 'Vend: '+nomVend.toUpperCase();
    var nroEspaciosVendedor = 28 - vendedor.length;
    var vendedorTicket = vendedor.toUpperCase() + " ".repeat(nroEspaciosVendedor)+' '+fechaTicketJS;
    var totalVentaTicket = formatNumber.new(totalVenta);

	var productosMesonID = [];
	var productosMesonCANT = [];
	var productosMesonPV = [];
	var productosMesonTOT = [];
	var productosMesonPROD = [];

	var productosPatioID = [];
	var productosPatioCANT = [];
	var productosPatioPV = [];
	var productosPatioTOT = [];

	var productos_Finales_ID = [];
	var productos_Finales_CANT = [];
	var productos_Finales_PV = [];
	var productos_Finales_TOT = [];
	
	var skuProdComun = ajuste('sku_prod_comun');
	var skuFlete = ajuste('sku_flete');
	var skuInteres = ajuste('sku_interes');

	var productosVenta = JSON.parse(listaProductos);

	$(productosVenta).each(function (i){

        let idProd = productosVenta[i].id;
        let datosProd = infoProd(idProd);

        if(datosProd["sku"] == skuFlete || datosProd["sku"] == skuInteres){ // PRIMERO REVISA SI HAY FLETES O INTERES
            productos_Finales_ID.push(productosVenta[i]['id']);
            productos_Finales_CANT.push(productosVenta[i]['cant']);
            productos_Finales_PV.push(productosVenta[i]['pV']);
            productos_Finales_TOT.push(productosVenta[i]['tot']);
        }else{

          if(datosProd["zona_prod"] == 'patio'){  // TODOS LOS PRODUCTOS DE PATIO, EXCLUYENDO FLETE E INTERES (SE DEJARAN AL FINAL)
              productosPatioID.push(productosVenta[i]['id']);
              productosPatioCANT.push(productosVenta[i]['cant']);
              productosPatioPV.push(productosVenta[i]['pV']);
              productosPatioTOT.push(productosVenta[i]['tot']);
          }else{ // PRODUCTOS MESON
              productosMesonID.push(productosVenta[i]['id']);
              productosMesonCANT.push(productosVenta[i]['cant']);
              productosMesonPV.push(productosVenta[i]['pV']);
              productosMesonTOT.push(productosVenta[i]['tot']);
              productosMesonPROD.push(productosVenta[i]['prod']);
          }
        }
    })
    
	const conector = new connetor_plugin()
                    conector.feed("1")
                    conector.fontsize("3")
                    conector.textaling("center")
                    conector.text(nombreComercial)
                    conector.fontsize("1")
                    conector.text(nombreReal)
                    conector.text(direccion)
                    conector.fontsize("2")
                    conector.textaling("center")
                    conector.text("VENTA: "+codVenta)
                    conector.feed("1")
                    conector.fontsize("1")
                    conector.textaling("left")
                    conector.text(vendedorTicket)
                    conector.feed("1")
                    conector.text("Cliente: "+nomCliente)


					let cantProdsMeson = productosMesonCANT.length;

					var dctoTotal = 0;
					var totalNormalGral = 0;
                   	var dctoAdicional = 0;

				    if(Number(cantProdsMeson) > 0){ // SI HAY PRODUCTOS EN MESON
            			conector.text("------------------------------------------------")
						conector.fontsize("2")
						conector.text("PRODUCTOS MESON")
						conector.fontsize("1")
						conector.textaling("left")
						conector.text("SKU     DESCRIPCION               CANT*($)PRECIO")
						conector.text("------------------------------------------------")

					    for (let i = 0;  i < productosMesonCANT.length ; i++) {
							var idProd = productosMesonID[i];
							var datosProd = infoProd(idProd);

			                // SKU                  
			                if(datosProd["sku"] == skuProdComun){ // detecta prod comun (SKU=000000 y DESCRIPCION=ESCRITO EN DOC)
			                    var sku = '000000 ';
			                    var descSII = productosMesonPROD[i].toUpperCase().substring(0, 25);
			                }else{
			                   	var sku = datosProd["categoria"] <= 9 ? '0'+datosProd["sku"] : datosProd["sku"]; // agrega "0" si catergoria es <= 9
			                    var descSII = datosProd["desc_sii"];
			                }

							sku = String(sku);

					        var nroEspaciosSku = 7 - sku.substring(0, 7).length;
					        var nroEspaciosDescripcion = 25 - Number(descSII.length) + 1;
					        var skuTicket = sku+' '.repeat(nroEspaciosSku);
					        var descSIITicket = descSII + " ".repeat(nroEspaciosDescripcion);

					        var cant = productosMesonCANT[i];
					        var cantidad_digitos = cant.length;
					        var nroEspaciosCantItem = Number(cantidad_digitos) > 4 ? 0 : 4 - Number(cantidad_digitos);
					        var cantMostrar =  Number(cantidad_digitos) > 4 ? (Math.round(cant*100))/100 : cant;
					        var cantidadTicket = " ".repeat(nroEspaciosCantItem) + cantMostrar + '*';

					        var precioVenta = datosProd["sku"] == skuProdComun ? formatNumber.new(productosMesonTOT[i]) : formatNumber.new(productosMesonPV[i]);
					        var cantidad_digitos_PV = precioVenta.length;
					        var nroEspaciosPV = 9 - Number(cantidad_digitos_PV);
					        var repetEspaciosPV = nroEspaciosPV < 0 ? 0 : nroEspaciosPV;
					        var precioVentaTicket = " ".repeat(repetEspaciosPV) + precioVenta;
					        
					        var linea1 = skuTicket +' '+descSIITicket+cantidadTicket+precioVentaTicket;

			                // TOTAL PRECIO VENTA ITEM
			                var zonaProd = datosProd["zona_"+$('#sucursalActiva').val()] === null ? '' : datosProd["zona_"+$('#sucursalActiva').val()].substring(0, 7);
			                var largoZona = zonaProd.length;
			                var totalNormal = productosMesonCANT[i]*datosProd['precio_venta'];
			                var descuento = totalNormal - productosMesonTOT[i];

							dctoTotal = Number(dctoTotal) + Number(descuento);
							totalNormalGral = Number(totalNormalGral) + Number(totalNormal);

			                if(Number(descuento) > 0){

			                	var precioNormal = datosProd['precio_venta'];
			                	var precioNormalMostrar = "(NORMAL: $"+formatNumber.new(precioNormal)+")";
			                    var largoPrecioNormalMostrar = precioNormalMostrar.length;
			                    var totalConDctoMostrar = "$ "+formatNumber.new(productosMesonTOT[i]);
			                    var largoTotalConDctoMostrar = totalConDctoMostrar.length;
			                    var nroEspaciosLargoPrecioNormalMostrar = 47 - Number(largoPrecioNormalMostrar) - Number(largoZona) - (7-Number(largoZona)) - Number(largoTotalConDctoMostrar);
			                    var repetEspaciosLargoPrecioNormalMostrar = Number(nroEspaciosLargoPrecioNormalMostrar) < 0 ? 0 : nroEspaciosLargoPrecioNormalMostrar;
								var linea2 = zonaProd+" ".repeat(7-Number(largoZona)+1)+precioNormalMostrar+" ".repeat(repetEspaciosLargoPrecioNormalMostrar)+totalConDctoMostrar;
			                }else{
			                    var totalItem = "$ "+ formatNumber.new(productosMesonTOT[i]);
			                    var largoTotal = totalItem.length;
			                    var nroEspaciosTotalItem = 48 - Number(largoTotal) - Number(largoZona);
			                    var repetEspaciosTotalItem = Number(nroEspaciosTotalItem) < 0 ? 0 : nroEspaciosTotalItem;
								var linea2 = zonaProd+" ".repeat(repetEspaciosTotalItem)+totalItem;
			                }
					        conector.textaling("left");
					        conector.text(linea1);
							conector.text(linea2);
							conector.feed("1");
						}
					}

					let cantProdsPatio = productosPatioCANT.length;
			        
			        if(cantProdsPatio > 0){
			            
			            if(cantProdsMeson > 0){
			                conector.feed("4");
			            }

			            if(productosVenta.length > 0){
			                conector.text("------------------------------------------------");
			            }

						conector.fontsize("2");
						conector.textaling("left");
						conector.text("PRODUCTOS PATIO");
						conector.fontsize("1");
						conector.text("SKU     DESCRIPCION               CANT*($)PRECIO");
						conector.text("------------------------------------------------");

			            
					    for (let i = 0;  i < productosPatioCANT.length ; i++) {

							var idProd = productosPatioID[i];
							var datosProd = infoProd(idProd);

		                   	var sku = datosProd["categoria"] <= 9 ? '0'+datosProd["sku"] : datosProd["sku"]; // agrega "0" si catergoria es <= 9
		                    var descSII = datosProd["desc_sii"];
			                
							sku = String(sku);

					        var nroEspaciosSku = 7 - sku.substring(0, 7).length;
					        var nroEspaciosDescripcion = 25 - Number(descSII.length) + 1;
					        var skuTicket = sku+' '.repeat(nroEspaciosSku);
					        var descSIITicket = descSII + " ".repeat(nroEspaciosDescripcion);

					        var cant = productosPatioCANT[i];
					        var cantidad_digitos = cant.length;
					        var nroEspaciosCantItem = Number(cantidad_digitos) > 4 ? 0 : 4 - Number(cantidad_digitos);
					        var cantMostrar =  Number(cantidad_digitos) > 4 ? (Math.round(cant*100))/100 : cant;
					        var cantidadTicket = " ".repeat(nroEspaciosCantItem) + cantMostrar + '*';

					        // PRECIO VENTA PRODUCTO
					        var precioVenta = formatNumber.new(productosPatioPV[i]);
					        var cantidad_digitos_PV = precioVenta.length;
					        var nroEspaciosPV = 9 - Number(cantidad_digitos_PV);
					        var repetEspaciosPV = nroEspaciosPV < 0 ? 0 : nroEspaciosPV;
					        var precioVentaTicket = " ".repeat(repetEspaciosPV) + precioVenta;

					        var linea1 = skuTicket + ' ' +descSIITicket+cantidadTicket+precioVentaTicket;

			                // TOTAL PRECIO VENTA ITEM
			                var zonaProd = datosProd["zona_"+$('#sucursalActiva').val()] === null ? '' : datosProd["zona_"+$('#sucursalActiva').val()].substring(0, 7);
			                var largoZona = zonaProd.length;
			                var totalNormal = productosPatioCANT[i]*datosProd['precio_venta'];
			                var descuento = totalNormal - productosPatioTOT[i];

							dctoTotal = Number(dctoTotal) + Number(descuento);
							totalNormalGral = Number(totalNormalGral) + Number(totalNormal);

			                if(Number(descuento) > 0){

			                	var precioNormal = datosProd['precio_venta'];
			                	var precioNormalMostrar = "(NORMAL: $"+formatNumber.new(precioNormal)+")";
			                    var largoPrecioNormalMostrar = precioNormalMostrar.length;
			                    var totalConDctoMostrar = "$ "+formatNumber.new(productosPatioTOT[i]);
			                    var largoTotalConDctoMostrar = totalConDctoMostrar.length;
			                    var nroEspaciosLargoPrecioNormalMostrar = 47 - Number(largoPrecioNormalMostrar) - Number(largoZona) - (7-Number(largoZona)) - Number(largoTotalConDctoMostrar);
			                    var repetEspaciosLargoPrecioNormalMostrar = Number(nroEspaciosLargoPrecioNormalMostrar) < 0 ? 0 : nroEspaciosLargoPrecioNormalMostrar;
								var linea2 = zonaProd+" ".repeat(7-Number(largoZona)+1)+precioNormalMostrar+" ".repeat(repetEspaciosLargoPrecioNormalMostrar)+totalConDctoMostrar;
								
						        conector.textaling("left");
						        conector.text(linea1);
								conector.text(linea2);
								conector.feed("1");

			                }else{

			                    var totalItem = "$ "+ formatNumber.new(productosPatioTOT[i]);
			                    var largoTotal = totalItem.length;
			                    var nroEspaciosTotalItem = 48 - Number(largoTotal) - Number(largoZona);
			                    var repetEspaciosTotalItem = Number(nroEspaciosTotalItem) < 0 ? 0 : nroEspaciosTotalItem;
								var linea2 = zonaProd+" ".repeat(repetEspaciosTotalItem)+totalItem;

						        conector.textaling("left");
						        conector.text(linea1);
								conector.text(linea2);
								conector.feed("1");

			                } 
						}
					}

			        // INCORPORACION DE PRODUCTOS FINALES
			        if(productos_Finales_ID.length > 0){

			            conector.text("------------------------------------------------");
			                
			            // for ($i=0; $i < count($productos_Finales_ID); $i++){
						for (let i = 0;  i < productos_Finales_CANT.length ; i++){

							var idProd = productos_Finales_ID[i];
							var datosProd = infoProd(idProd);

		                   	var sku = datosProd["categoria"] <= 9 ? '0'+datosProd["sku"] : datosProd["sku"]; // agrega "0" si catergoria es <= 9
			                if(datosProd['sku'] == skuInteres && productos_Finales_TOT[i] < 0){
			                    var descSII = 'DESCUENTO ADICIONAL';
			                    dctoAdicional = Math.abs(productos_Finales_TOT[i]);
			                }else{
			                    var descSII = datosProd["desc_sii"];
			                }
			                
							sku = String(sku);

					        var nroEspaciosSku = 7 - sku.substring(0, 7).length;
					        var nroEspaciosDescripcion = 25 - Number(descSII.length) + 1;
					        var skuTicket = sku+' '.repeat(nroEspaciosSku);
					        var descSIITicket = descSII + " ".repeat(nroEspaciosDescripcion);

					        var cant = productos_Finales_CANT[i];
					        var cantidad_digitos = cant.length;
					        var nroEspaciosCantItem = Number(cantidad_digitos) > 4 ? 0 : 4 - Number(cantidad_digitos);
					        var cantidadTicket = " ".repeat(nroEspaciosCantItem) + cant + '*';

					        var precioVenta = formatNumber.new(productos_Finales_PV[i]);
					        var cantidad_digitos_PV = precioVenta.length;
					        var nroEspaciosPV = 9 - Number(cantidad_digitos_PV);
					        var repetEspaciosPV = nroEspaciosPV < 0 ? 0 : nroEspaciosPV;
					        var precioVentaTicket = " ".repeat(repetEspaciosPV) + precioVenta;
					        
					        var linea1 = skuTicket + ' ' +descSIITicket+cantidadTicket+precioVentaTicket;


							var totalItem = "$ "+ formatNumber.new(productos_Finales_TOT[i]);
					        var linea2 = totalItem;

							totalNormalGral = Number(totalNormalGral) + Number(productos_Finales_TOT[i]);

					        conector.textaling("left");
						    conector.text(linea1);
					        conector.textaling("right");
							conector.text(linea2);

			            }
			        }

			        let subtotal = Number(dctoTotal)+Number(dctoAdicional)+Number(totalVenta);
			        dctoTotal = Number(dctoTotal)+Number(dctoAdicional);
                    conector.feed("4")
                    conector.text("------------------------------------------------")
                    // conector.text("         SUBTOTAL:  $ "+formatNumber.new(subtotal))

                    if(Number(dctoTotal) > 0){
	                    conector.text("         SUBTOTAL:  $ "+formatNumber.new(subtotal))
                    	conector.text("       DESCUENTOS: -$ "+formatNumber.new(dctoTotal))
                    }


                    conector.fontsize("2")

                    conector.text("   TOTAL: $ "+totalVentaTicket)
                    conector.feed("1")
                    conector.textaling("left")
                    conector.fontsize("1")


			        if(tipoPago=="Efectivo"){

			            cash = formatearMilesJSON(metodoPago.split('","')[0].slice(10));
			            cantidad_digitos_cash = cash.length;
			            nroEspaciosCash = 9 - Number(cantidad_digitos_cash);
			            cashTicket = " ".repeat(nroEspaciosCash) + cash;

			            total = formatearMilesJSON(metodoPago.split('","')[1].slice(8));
			            cantidad_digitos_total = total.length;
			            nroEspaciostotal = 9 - Number(cantidad_digitos_total);
			            totalTicket = " ".repeat(nroEspaciostotal) + total;

			            vuelto = formatearMilesJSON(metodoPago.split('","')[2].slice(9).split('"}]')[0]);
			            cantidad_digitos_vuelto = vuelto.length;
			            nroEspaciosvuelto = 9 - Number(cantidad_digitos_vuelto);
			            vueltoTicket = " ".repeat(nroEspaciosvuelto) + vuelto;

			            conector.text("                               CASH: $ "+cashTicket);
						conector.text("                              TOTAL: $ "+totalTicket);
						conector.text("                             -------------------");
						conector.text("                             VUELTO: $ "+vueltoTicket);

			        }else if(tipoPago=="Transferencia"){

			        	conector.textaling("right");
						conector.text("PAGADO VIA TRANSFERENCIA ELECTRONICA");

			        }else if(tipoPago=="TD"){
			            
			            conector.textaling("right");
						conector.text("PAGADO CON TARJETA DEBITO: "+metodoPago);

			        }else if(tipoPago=="TC"){

			            conector.textaling("right");
						conector.text("PAGADO CON TARJETA CREDITO: "+metodoPago);

			        }else if(tipoPago=="E_TC" || tipoPago=="E_TD"){

						conector.textaling("right");
						conector.text("SE PAGA CON PAGO COMBINADO");

			        }else if(tipoPago=="Fiado"){

						conector.textaling("right");
						conector.text("SE PAGA CON CREDITO INTERNO");

			        }else if(tipoPago=="Pend"){

						conector.textaling("right");
						conector.feed("1")
						conector.fontsize("2");
						conector.text("COBRAR EN REPARTO");

			        }


			        if(infoFlete != ''){

			            let nombreFlete = infoFlete.split('// ')[0];
			            let nroFlete = infoFlete.split('// ')[1];
			            let direccionFlete = infoFlete.split('// ')[2];

						conector.fontsize("1");
			            conector.feed("1");
						conector.text("------------------------------------------------");
						conector.fontsize("2");
						conector.textaling("center");
						conector.text("DATOS DESPACHO");
						conector.textaling("left");
						conector.fontsize("1");
						conector.text("NOMBRE    : "+nombreFlete.toUpperCase());
						conector.text("FONO      : "+nroFlete.toUpperCase());
						conector.text("DIRECCION : "+direccionFlete.toUpperCase());
						conector.text("------------------------------------------------");
			        }



                    conector.feed("2")
                    conector.textaling("center")
                    conector.fontsize("2")
                    conector.text("WHATSAPP: +56"+wspLocal1)
                    conector.feed("2")
                    conector.fontsize("1")
                    conector.text("GRACIAS POR SU COMPRA...")

                    conector.feed("8")
                    conector.cut("0")

	const resp = await conector.imprimir(nombreImpresora, api_key);
	if(resp == true){
		return 'ok';
	}

}



async function extraerDatosCotTicket(idCot){
	var datos = new FormData();
  	datos.append("datosCot", idCot);
   	$.ajax({
		url:"ajax/cotizaciones.ajax.php",
  		method: "POST",
  		data: datos,
  		cache: false,
  		contentType: false,
  		processData: false,
      	success:function(r){
      		infoCot = JSON.parse(r);
			imprimirTicketCotJS(infoCot['fecha_ingreso'],infoCot['nom_vend'],infoCot['productos'],infoCot['nom_client'],infoCot['total'],infoCot['id'],infoCot['fecha_expiracion']);
  			audioSuccess('Imprimiendo');
    	}
   	})
}

async function imprimirTicketCotJS(fechaIngreso,nomVend,listaProdsCot,nomCliente,totalCot,nroCot,fechaExpiracion){
	
	let nombreImpresora = ajuste('nombre_impresora_termica');
	var api_key = ajuste('api_key_impresora_termica');
	var nombreComercial = reemplazarTildes(ajuste('nombre_comercial').toUpperCase());
	var nombreReal = reemplazarTildes(ajuste('nombre_real').toUpperCase());
	var direccion = reemplazarTildes(ajuste('direccion_comercial').toUpperCase());
	var wspLocal1 = ajuste('wsp_local1');

	var fechaTicketJS = fechaIngreso.split('-')[2]+'-'+fechaIngreso.split('-')[1]+'-'+fechaIngreso.split('-')[0];
	var fechaExpiracionTicketJS = fechaExpiracion.split('-')[2]+'-'+fechaExpiracion.split('-')[1]+'-'+fechaExpiracion.split('-')[0];

	var cantInfoNomVend = nomVend.split(' ').length;
	// var vendedor = Number(cantInfoNomVend) >= 2 ? 'Vend: '+nomVend.split(' ')[0].substring(0,1)+'. '+nomVend.split(' ')[1].substring(0,18)+' ' : 'Vend: '+nomVend.toUpperCase();
	var vendedor = Number(cantInfoNomVend) >= 2 ? 'Vend: '+  nomVend.split(' ')[0].toUpperCase() + ' ' + nomVend.split(' ')[1].substring(0,1).toUpperCase() + '.' : 'Vend: '+nomVend.toUpperCase();
    var nroEspaciosVendedor = 48 - 11 - vendedor.length;
    var vendedorTicket = vendedor.toUpperCase() + " ".repeat(nroEspaciosVendedor)+' '+fechaTicketJS;
    var totalCotTicket = formatNumber.new(totalCot);

	var productosCot = JSON.parse(listaProdsCot);

	var productosMesonID = [];
	var productosMesonCANT = [];
	var productosMesonPV = [];
	var productosMesonTOT = [];
	var productosMesonPROD = [];
	var productosPatioID = [];
	var productosPatioCANT = [];
	var productosPatioPV = [];
	var productosPatioTOT = [];

	$(productosCot).each(function (i){

        let idProd = productosCot[i].id;
      	if(infoProd(idProd)["zona_prod"] == 'patio'){  // TODOS LOS PRODUCTOS DE PATIO, EXCLUYENDO FLETE E INTERES (SE DEJARAN AL FINAL)
          	productosPatioID.push(productosCot[i]['id']);
          	productosPatioCANT.push(productosCot[i]['cant']);
          	productosPatioPV.push(productosCot[i]['pV']);
          	productosPatioTOT.push(productosCot[i]['tot']);
      	}else{ // PRODUCTOS MESON
			productosMesonID.push(productosCot[i]['id']);
			productosMesonCANT.push(productosCot[i]['cant']);
			productosMesonPV.push(productosCot[i]['pV']);
			productosMesonTOT.push(productosCot[i]['tot']);
			productosMesonPROD.push(productosCot[i]['prod']);
      	}
    })

	const conector = new connetor_plugin()

	                conector.feed("1")
                    conector.fontsize("1")
                    conector.textaling("center")
                    conector.text(nombreComercial)
                    conector.fontsize("2")
                    conector.textaling("center")
                    conector.text("COTIZACION "+formatNumber.new(nroCot))
                    conector.feed("1")
                    conector.fontsize("1")
                    conector.textaling("left")
                    conector.text(vendedorTicket)
                    conector.textaling("right")
                    conector.feed("1")
                    conector.text("VALIDA HASTA: "+fechaExpiracionTicketJS)
                    conector.textaling("left")
                    conector.feed("1")
                    conector.text("Cliente: "+nomCliente.toUpperCase())
                    conector.feed("1")
                    conector.text("SKU     DESCRIPCION               CANT*($)PRECIO")
                    conector.text("------------------------------------------------")

					var dctoTotal = 0;
					var totalNormalGral = 0;
                   	var dctoAdicional = 0;
				    if(Number(productosMesonCANT.length) > 0){ // SI HAY PRODUCTOS EN MESON

					    for (let i = 0;  i < productosMesonCANT.length ; i++) {


					        var idProd = productosMesonID[i];
							var datosProd = infoProd(idProd);

					        var sku = Number(datosProd['categoria']) <= 9 ? '0'.toString() + datosProd['sku'] : datosProd['sku'];
					        

							sku = String(sku);

					        var nroEspaciosSku = 7 - sku.substring(0, 7).length;
					        var skuTicket = sku+' '.repeat(nroEspaciosSku)

					        var descSII = datosProd["desc_sii"];
					        var nroEspaciosDescripcion = 25 - Number(descSII.length) + 1;
					        var descSIITicket = descSII + " ".repeat(nroEspaciosDescripcion);

					        var cant = productosMesonCANT[i];
					        var cantidad_digitos = cant.length;
							var nroEspaciosCantItem = Number(cantidad_digitos) > 4 ? 0 : 4 - Number(cantidad_digitos);
					        var cantidadTicket = " ".repeat(nroEspaciosCantItem) + cant + '*';

					        var precioVenta = formatNumber.new(productosMesonPV[i]);
					        var cantidad_digitos_PV = precioVenta.length;
					        var nroEspaciosPV = 9 - Number(cantidad_digitos_PV);
					        var repetEspaciosPV = nroEspaciosPV < 0 ? 0 : nroEspaciosPV;
					        var precioCotTicket = " ".repeat(repetEspaciosPV) + precioVenta;

					        var totalItemTicket = formatNumber.new(productosMesonTOT[i]);

					        var linea1 = skuTicket + ' ' +descSIITicket+cantidadTicket+precioCotTicket;
					        conector.textaling("left");
					        conector.text(linea1);


					        // LINEA 2
			                var zonaProd = datosProd["zona_"+$('#sucursalActiva').val()] === null ? '' : datosProd["zona_"+$('#sucursalActiva').val()].substring(0, 7);
			                var largoZona = zonaProd.length;
							if(Number(precioVenta) <= Number(precioNormal)){ // SIN OFERTA
			                	var precioNormal = datosProd['precio_venta'];
			                	var precioNormalMostrar = "(NORMAL: $"+formatNumber.new(precioNormal)+")";
			                    var largoPrecioNormalMostrar = precioNormalMostrar.length;
			                    var totalConDctoMostrar = "$ "+formatNumber.new(totalItemTicket);
			                    var largoTotalConDctoMostrar = totalConDctoMostrar.length;
			                    var nroEspaciosLargoPrecioNormalMostrar = 47 - Number(largoPrecioNormalMostrar) - Number(largoZona) - (7-Number(largoZona)) - Number(largoTotalConDctoMostrar);
			                    var repetEspaciosLargoPrecioNormalMostrar = Number(nroEspaciosLargoPrecioNormalMostrar) < 0 ? 0 : nroEspaciosLargoPrecioNormalMostrar;
								var linea2 = zonaProd+" ".repeat(7-Number(largoZona)+1)+precioNormalMostrar+" ".repeat(repetEspaciosLargoPrecioNormalMostrar)+totalConDctoMostrar;
						        conector.textaling("left");
								conector.text(linea2);
			                }else{
			                    var totalItem = "$ "+totalItemTicket;
			                    var largoTotal = totalItem.length;
			                    var nroEspaciosTotalItem = 48 - Number(largoTotal) - Number(largoZona);
			                    var repetEspaciosTotalItem = Number(nroEspaciosTotalItem) < 0 ? 0 : nroEspaciosTotalItem;
								var linea2 = zonaProd+" ".repeat(repetEspaciosTotalItem)+totalItem;
						        conector.textaling("left");
								conector.text(linea2);
			                } 

			                // CALCULO DCTO TOTAL
			                let totalNormal = productosMesonCANT[i]*datosProd['precio_venta'];
			                let descuento = totalNormal - productosMesonTOT[i];
							dctoTotal = Number(dctoTotal) + Number(descuento);
							totalNormalGral = Number(totalNormalGral) + Number(totalNormal);


					    }
					}				    

			        if(productosPatioCANT.length > 0){
			            
			            if(productosMesonCANT.length > 0){
			                conector.text("------------------------------------------------");
			            }


					    for (let i = 0;  i < productosPatioCANT.length ; i++) {


					        var idProd = productosPatioID[i];
							var datosProd = infoProd(idProd);

					        var sku = Number(datosProd['categoria']) <= 9 ? '0'.toString() + datosProd['sku'] : datosProd['sku'];

							sku = String(sku);

					        var nroEspaciosSku = 7 - sku.substring(0, 7).length;
					        var skuTicket = sku+' '.repeat(nroEspaciosSku)

					        var descSII = datosProd["desc_sii"];
					        var nroEspaciosDescripcion = 25 - Number(descSII.length) + 1;
					        var descSIITicket = descSII + " ".repeat(nroEspaciosDescripcion);

					        var cant = productosPatioCANT[i];
					        var cantidad_digitos = cant.length;
							var nroEspaciosCantItem = Number(cantidad_digitos) > 4 ? 0 : 4 - Number(cantidad_digitos);
					        var cantidadTicket = " ".repeat(nroEspaciosCantItem) + cant + '*';

					        var precioVenta = formatNumber.new(productosPatioPV[i]);
					        var cantidad_digitos_PV = precioVenta.length;
					        var nroEspaciosPV = 9 - Number(cantidad_digitos_PV);
					        var repetEspaciosPV = nroEspaciosPV < 0 ? 0 : nroEspaciosPV;
					        var precioCotTicket = " ".repeat(repetEspaciosPV) + precioVenta;

					        var totalItemTicket = formatNumber.new(productosPatioTOT[i]);
					        var linea1 = skuTicket + ' ' +descSIITicket+cantidadTicket+precioCotTicket;
					        conector.textaling("left");
					        conector.text(linea1);


					        // LINEA 2
			                var zonaProd = datosProd["zona_"+$('#sucursalActiva').val()] === null ? '' : datosProd["zona_"+$('#sucursalActiva').val()].substring(0, 7);
			                var largoZona = zonaProd.length;
							if(Number(precioVenta) <= Number(precioNormal)){ // CON DESCUENTO
			                	var precioNormal = datosProd['precio_venta'];
			                	var precioNormalMostrar = "(NORMAL: $"+formatNumber.new(precioNormal)+")";
			                    var largoPrecioNormalMostrar = precioNormalMostrar.length;
			                    var totalConDctoMostrar = "$ "+totalItemTicket;
			                    var largoTotalConDctoMostrar = totalConDctoMostrar.length;
			                    var nroEspaciosLargoPrecioNormalMostrar = 47 - Number(largoPrecioNormalMostrar) - Number(largoZona) - (7-Number(largoZona)) - Number(largoTotalConDctoMostrar);
			                    var repetEspaciosLargoPrecioNormalMostrar = Number(nroEspaciosLargoPrecioNormalMostrar) < 0 ? 0 : nroEspaciosLargoPrecioNormalMostrar;
								var linea2 = zonaProd+" ".repeat(7-Number(largoZona)+1)+precioNormalMostrar+" ".repeat(repetEspaciosLargoPrecioNormalMostrar)+totalConDctoMostrar;
						        conector.textaling("left");
								conector.text(linea2);
			                }else{
			                    var totalItem = "$ "+totalItemTicket;
			                    var largoTotal = totalItem.length;
			                    var nroEspaciosTotalItem = 48 - Number(largoTotal) - Number(largoZona);
			                    var repetEspaciosTotalItem = Number(nroEspaciosTotalItem) < 0 ? 0 : nroEspaciosTotalItem;
								var linea2 = zonaProd+" ".repeat(repetEspaciosTotalItem)+totalItem;
						        conector.textaling("left");
								conector.text(linea2);
			                } 
							conector.feed("1");
			                // CALCULO DCTO TOTAL
			                let totalNormal = productosPatioCANT[i]*datosProd['precio_venta'];
			                let descuento = totalNormal - productosPatioTOT[i];
							dctoTotal = Number(dctoTotal) + Number(descuento);
							totalNormalGral = Number(totalNormalGral) + Number(totalNormal);
					    }
					}

			        let subtotal = Number(dctoTotal)+Number(totalCot);
                    conector.text("------------------------------------------------")
                    conector.feed("1")
                    if(Number(dctoTotal) > 0){
	                    conector.text("         SUBTOTAL:  $ "+formatNumber.new(subtotal))
                    	conector.text("       DESCUENTOS: -$ "+formatNumber.new(dctoTotal))
                    }

                    conector.fontsize("2")
                    conector.text("   TOTAL: $ "+totalCotTicket)
                    conector.feed("1")
                    conector.textaling("left")
                    conector.fontsize("1")
                    conector.feed("2")
                    conector.textaling("center")
                    conector.fontsize("2")
                    conector.text("WHATSAPP: +56"+wspLocal1)
                    conector.feed("2")
                    conector.fontsize("1")
                    conector.text("GRACIAS POR COTIZAR...")
                    conector.feed("8")
                    conector.cut("0")

	const resp = await conector.imprimir(nombreImpresora, api_key);                    

}

async function imprimirTicketAbono(codigoTransaccion,fechaHora,sucursal,nomVend,idCliente,nomCliente,montoAbono,metodoPago,deudaAnterior,tipoMov){
	
	let nombreImpresora = ajuste('nombre_impresora_termica');
	var api_key = ajuste('api_key_impresora_termica');
	var nombreComercial = reemplazarTildes(ajuste('nombre_comercial').toUpperCase());
	var nombreReal = reemplazarTildes(ajuste('nombre_real').toUpperCase());
	var direccion = reemplazarTildes(ajuste('direccion_comercial').toUpperCase());
	var wspLocal1 = ajuste('wsp_local1');

	let fechaTicketJS = fechaHora.split(' ')[0].split('-')[2]+'-'+fechaHora.split(' ')[0].split('-')[1]+'-'+fechaHora.split(' ')[0].split('-')[0]+' '+fechaHora.split(' ')[1];
	let vendedor = 'Vend: '+nomVend.split(' ')[0]+' '+nomVend.split(' ')[1].substring(0,1)+'.';
    let nroEspaciosVendedor = 48 - 20 - vendedor.length;
    let vendedorAbono = vendedor.toUpperCase() + " ".repeat(nroEspaciosVendedor)+' '+fechaTicketJS;

    let cant_digitos_IdCliente = idCliente.length;
    let nro_ceros_IdCliente = 5 - Number(cant_digitos_IdCliente);
    let nroCliente = "0".repeat(nro_ceros_IdCliente) + idCliente;
	
	let nombreClienteTicket = nomCliente.split(' ref.')[0];

    let metodoPagoTicket = metodoPago == 'ef' ? 'Efectivo' : metodoPago;
    
    let adeudado_o_favor_anterior = Number(deudaAnterior) >= 0 ? 'Deuda Cliente   : $ ' : "A Favor Cliente : $ ";
    let deudaAnteriorTicket = deudaAnterior >= 0 ? deudaAnterior : -deudaAnterior;

    let adeudo_o_favor = Number(deudaAnterior)-Number(montoAbono) >= 0 ? "DEUDA ACTUAL: " : "SALDO A FAVOR: $ ";
    let deudaActualizada = Number(deudaAnterior)-Number(montoAbono) >= 0 ? Number(deudaAnterior)-Number(montoAbono) : -(Number(deudaAnterior)-Number(montoAbono));

	const 	conector = new connetor_plugin()
			conector.feed("1")
			conector.fontsize("2")
			conector.textaling("center")
			conector.text(nombreComercial)
			conector.fontsize("1")
			conector.text("Comprobante de Pago")
			conector.fontsize("1")
			conector.textaling("left")
			conector.feed("1")
			conector.text("Sucursal: "+sucursal.toUpperCase())
			conector.feed("1")
			conector.text(vendedorAbono)
			conector.text("------------------------------------------------")
			conector.text("Numero Cliente  : "+nroCliente)
			conector.text("Nombre Cliente  : "+nombreClienteTicket.toUpperCase())
			conector.text(adeudado_o_favor_anterior+formatNumber.new(deudaAnteriorTicket))

			conector.text("------------------------------------------------")
			conector.fontsize("2")
			conector.text("MONTO PAGADO: "+formatNumber.new(montoAbono))
			conector.fontsize("1")
			conector.text("------------------------------------------------")
			conector.text("Numero Transaccion : "+formatNumber.new(codigoTransaccion))
			conector.text("Metodo de Pago     : "+metodoPagoTicket.toUpperCase())
			conector.text("------------------------------------------------")
			conector.fontsize("2")
			// conector.text("MONTO PAGADO: "+formatNumber.new(montoAbono))
			conector.text(adeudo_o_favor+formatNumber.new(deudaActualizada))
			conector.fontsize("1")
			conector.text("------------------------------------------------")
			conector.feed("6")
			conector.cut("0")
	let resp = await conector.imprimir(nombreImpresora, api_key);

	if (resp) {
	  	audioSuccess('Imprimiendo');
	} else {
		audioError('No se pudo imprimir');
	}

}


function reimprimirTicketAbono(idMov){
	let nombreImpresora = ajuste('nombre_impresora_termica');
	var api_key = ajuste('api_key_impresora_termica');
	var nombreComercial = reemplazarTildes(ajuste('nombre_comercial').toUpperCase());
	var nombreReal = reemplazarTildes(ajuste('nombre_real').toUpperCase());
	var direccion = reemplazarTildes(ajuste('direccion_comercial').toUpperCase());
	var wspLocal1 = ajuste('wsp_local1');

	var datos = new FormData();
  	datos.append("datosMov", idMov);
  	$.ajax({
    	type: "POST",
    	cache: false,
    	contentType: false,
    	processData: false,
    	data: datos,
    	url:"ajax/movimientos.ajax.php",
    	dataType: "json",
    	success:function(resp){
    		let fechaHora = resp['fecha'];
    		let nomVend = resp['nom_user'];
			let sucursal = $('#sucursalActiva').val();
			let codigoTransaccion = resp['id'];
			let idCliente = resp['id_client'];
			let nomCliente = resp['nom_client'];
			let montoAbono = resp['abono'];
			let metodoPago = resp['moneda'];
			let deudaAnterior = resp['saldo_ant'];
			imprimirTicketAbono(codigoTransaccion,fechaHora,sucursal,nomVend,idCliente,nomCliente,montoAbono,metodoPago,deudaAnterior,'abClient');
		}
    })
}