focusModal('nroNC');
focusModal('montoPagadoVista');
var tblCompromisos =
$('.tablaCompromisos').DataTable({
    "ajax": "ajax/datatable-compromisos-pago.ajax.php?fechaInicial="+obtenerGET(window.location)['fechaInicial']+"&fechaFinal="+obtenerGET(window.location)['fechaFinal'],
    "order": [[ 2, "asc" ]], //orden descendente por defecto
    "deferRender": true,
    "retrieve": true,
    // "mark": true,
    "processing": true,

    "createdRow": function(row, data, dataIndex) {
        const startIndex = data[2].indexOf('>') + 1;
        const endIndex = data[2].indexOf('</font>');
        const jsonDatosPago = data[2].substring(startIndex, endIndex);
        const arrayDatosPago = JSON.parse(jsonDatosPago);
        var fechaVencimiento = arrayDatosPago.fecha_venc;
        var fechaPago = arrayDatosPago.fecha_pago;
        var estado = arrayDatosPago.estado;
        var hoy = moment(new Date()).format('YYYY-MM-DD');

        if(Number(estado) == 0 && hoy >= fechaVencimiento){ // atrasado sin pago
            $(row).css('background-color', 'background:rgb(255,200,200)'); // rosa
            $(row).addClass('filaSeleccionablePago');
        }else if(Number(estado) == 1 && fechaPago > fechaVencimiento){ // pagado con retraso
            $(row).css('background-color', 'background:rgb(195,195,195)'); // gris
            $(row).addClass('filaPagada');
        }else if(Number(estado) == 1 && fechaPago <= fechaVencimiento){// PAGADO
            $(row).css('background-color', 'background:rgb(164,255,255)'); // cyan
            $(row).addClass('filaPagada');
        }else{
            $(row).css('background-color', '');
            $(row).addClass('filaSeleccionablePago');
        }        
    },

    "pageLength": 10,
    "language": {
        "sProcessing":     "Procesando...",
        "sLengthMenu":     "Mostrar _MENU_ registros",
        "sZeroRecords":    "No se encontraron resultados",
        "sEmptyTable":     "Ningún dato disponible en esta tabla",
        "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
        "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
        "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
        "sInfoPostFix":    "",
        "sSearch":         "Buscar (F3):",
        "sUrl":            "",
        "sInfoThousands":  ",",
        "sLoadingRecords": "Cargando...",
        "oPaginate": {
        "sFirst":    "Primero",
        "sLast":     "Último",
        "sNext":     "Siguiente",
        "sPrevious": "Anterior"
    },
        "oAria": {
            "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
            "sSortDescending": ": Activar para ordenar la columna de manera descendente"
        }

    },
});

$('.tablaCompromisos tbody').on('click', 'tr.filaPagada', function(){
    mixinInfo('Ya está pagado');
})

$('.tablaCompromisos tbody').on('click', 'tr.filaSeleccionablePago', function() {
    if (event.ctrlKey) {
        $(this).toggleClass('filaSeleccionadaPago'); // Alternar la clase 'seleccionada'
        var fila = $(this);
        var infoFila = fila.find('td:eq(2)').text();
        var jsonFila = infoFila.split('}')[0]+'}';
        var arrayDatosPago = JSON.parse(jsonFila);

        if($(this).hasClass('filaSeleccionadaPago')){
            $('#totalCompromisos').val(Number($('#totalCompromisos').val()) + Number(arrayDatosPago.saldo)); // suma seleccion
            $(this).css('background-color', 'background:rgb(0,255,0)');
        }else{
            
            $('#totalCompromisos').val(Number($('#totalCompromisos').val()) - Number(arrayDatosPago.saldo)); // resta seleccion
            var fechaVencimiento = arrayDatosPago.fecha_venc;
            var fechaPago = arrayDatosPago.fecha_pago;
            var estado = arrayDatosPago.estado;
            var hoy = moment(new Date()).format('YYYY-MM-DD');
            if(Number(estado) == 0 && hoy >= fechaVencimiento){
                $(this).css('background-color', 'background:rgb(255,200,200)');
            }else{
                $(this).css('background-color', '');
                $(this).addClass('filaSeleccionablePago');
            }        

        }

        if(Number($('#totalCompromisos').val()) == 0){
            $('#totalSeleccionadoMostrar').text('');
        }else{
            $('#totalSeleccionadoMostrar').text('SELECCIONADO: $ '+formatNumber.new($('#totalCompromisos').val()));
        }
    }
});

/*=============================================
VARIABLE LOCAL STORAGE
=============================================*/
if(localStorage.getItem("capturarRango3") != null){
    $("#daterange-btn3 span").html(localStorage.getItem("capturarRango3"));
}else{
    $("#daterange-btn3 span").html('<i class="fa fa-calendar"></i> Rango de fecha')
}

/*=============================================
RANGO DE FECHAS
=============================================*/
$('#daterange-btn3').daterangepicker(
    {
        ranges: {
            'Compromisos'       : [moment().subtract(1, 'month'), moment()],
            'Este mes'  : [moment().startOf('month'), moment().endOf('month')],
            'Mes Anterior'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Este año'  : [moment().startOf('year'), moment().endOf('year')],
            'Año Anterior'  : [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        },
        startDate: moment(),
        endDate  : moment()
    },
    function (start, end){
        var fechaInicial = start.format('YYYY-MM-DD');
        var fechaFinal = end.format('YYYY-MM-DD');
        var hoy = moment(new Date()).format('YYYY-MM-DD');
        var fecha1 = fechaInicial;
        var fecha2 = fechaFinal;
        $('#daterange-btn3 span').html(moment(fecha1).format('DD-MM-YY') + ' - ' + moment(fecha2).format('DD-MM-YY'));
        var capturarRango = $("#daterange-btn3 span").html();
        localStorage.setItem("capturarRango3", capturarRango);
        window.location = "index.php?ruta=compromisos-pago&fechaInicial="+fecha1+"&fechaFinal="+fecha2;
    }
)

// $("#tipoAbonoParcial").change(function(){
//     option = $(this).val();
//     if(option == 'nc'){
//         $('.notaCredito').removeClass('d-none');
//         $('.abonoParcial').addClass('d-none');
//         $('.ingresarAbonoParcial').removeAttr('disabled');
//         $('#tipoMonedaAbonoParcial').val('');
//         $('#montoAbonoParcial').val('');
//     }else if(option == 'ab'){
//         $('.abonoParcial').removeClass('d-none');
//         $('.notaCredito').addClass('d-none');
//         $('.ingresarAbonoParcial').removeAttr('disabled');
//         $('#montoNC').val('');
//         $('#nroNC').val('');
//     }else{
//         $('.abonoParcial').addClass('d-none');
//         $('.notaCredito').addClass('d-none');
//         $('.ingresarAbonoParcial').attr('disabled','disabled');
//         $('#nroNC').val('');
//         $('#montoNC').val('');
//         $('#tipoMonedaAbonoParcial').val('');
//         $('#montoAbonoParcial').val('');
//     }
// })



$('#registrarPagoCompromiso').click(function(){
    $(this).attr('disabled','disabled');
    if($('#montoPagadoVista').val() != '' && $('#monedaPagoCompromiso').val() != ''){
        var idCompromiso = $("#registrarPagoID").val();
        var monto = $("#montoPagadoVista").val().replace(/\./g, '');
        var datos = new FormData();
        datos.append("pagarCompromiso", idCompromiso);
        datos.append("tipo", 'ab');
        datos.append("montoAbono", monto);
        datos.append("monedaAbono", $('#monedaPagoCompromiso').val());
        datos.append("fechaAbono", $("#fechaPagoCompromiso").val());
        var $inputComprobantess = document.querySelector("#comprobantePagoFinal");
        const comprobantesSubir = $inputComprobantess.files;
        for (const archivo of comprobantesSubir) { // Agregamos cada archivo a "archivos[]". Los corchetes son importantes
            datos.append("comprobanteCompromisoPago[]", archivo);
        }
        $.ajax({
            url: "ajax/compromisos-pago.ajax.php",
            method: "POST",
            data: datos,
            cache: false,
            contentType: false,
            processData: false,
            enctype: 'multipart/form-data', // Asegura la codificación correcta

            success: function(r){
                $('.tablaCompromisos').DataTable().ajax.reload();      
                $('#modalRegistrarPago').modal('hide');
                $('#monedaPagoCompromiso').val('');
                $('#comprobantePagoFinal').val('');
                audioSuccess('Abono Ingresado Exitosamente');
                $('#registrarPagoCompromiso').removeAttr('disabled');
            }
        })
    }
})

$('#ingresarNC').click(function(){
    if(($('#montoNC').val() != '' && $('#nroNC').val() != '')){
        var idCompromiso = $("#idCompromisoPagoAbonoParcial").val();
        var montoNC = $("#montoNC").val().replace(/\./g, '');
        var nroNC = $("#nroNC").val().replace(/\./g, '');
        var datos = new FormData();
        datos.append("aplicarNC", idCompromiso);
        datos.append("tipo", 'nc');
        datos.append("nroNC", nroNC);
        datos.append("montoNC", montoNC);
        datos.append("fecha", $("#fechaPagoAbonoParcial").val());
        $.ajax({
            url: "ajax/compromisos-pago.ajax.php",
            method: "POST",
            data: datos,
            cache: false,
            contentType: false,
            processData: false,
            success: function(r){
                $('.nc').val('');
                $('.tablaCompromisos').DataTable().ajax.reload();
                $('#modalNC').modal('hide');
                audioSuccess('NC Ingresada Exitosamente');
            }
        })
    }else{
        mixinError('Ingresar Nro NC y Monto');
    }

})

$(".tablaCompromisos,.tablaCompromisosMovil").on("click", ".comprobantePagoCompromiso", function(){
    var doc = $(this).attr('doc');
    var ncs = $(this).attr('nc');
    var id = $(this).attr('idCompromiso');
    if(ncs == 0){
        window.open(doc, "_blank");
    }else{
        window.open("extensiones/tcpdf/pdf/historial-pago-factura.php?id="+id+"&doc=" + doc, "_blank");
    }
})

$(".tablaCompromisosMovil").DataTable({
    // "order": [[ 2, "asc" ]], //orden
    "deferRender": true,
    "retrieve": true,
    "processing": true,
    "pageLength": 25,
    "language": {
        "sProcessing": "Procesando...",
        "sLengthMenu": "Mostrar _MENU_ registros",
        "sZeroRecords": "No se encontraron resultados",
        "sEmptyTable": "Ningún dato disponible en esta tabla",
        "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
        "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
        "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
        "sInfoPostFix": "",
        "sSearch": "Buscar",
        "sUrl": "",
        "sInfoThousands": ",",
        "sLoadingRecords": "Cargando...",
        "oPaginate": {
            "sFirst": "Primero",
            "sLast": "Último",
            "sNext": "&rarr;",
            "sPrevious": "&larr;"
        },
        "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
        }
    },
    dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',
});

// $('.tablaCompromisos').DataTable({
//     // "order": [[ 2, "asc" ]], //orden
//     "deferRender": true,
//     "retrieve": true,
//     "processing": true,
//     "pageLength": 25,
//     "language": {
//         "sProcessing":     "Procesando...",
//         "sLengthMenu":     "Mostrar _MENU_ registros",
//         "sZeroRecords":    "No se encontraron resultados",
//         "sEmptyTable":     "Ningún dato disponible en esta tabla",
//         "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
//         "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
//         "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
//         "sInfoPostFix":    "",
//         "sSearch":         "Buscar (F3):",
//         "sUrl":            "",
//         "sInfoThousands":  ",",
//         "sLoadingRecords": "Cargando...",
//         "oPaginate": {
//         "sFirst":    "Primero",
//         "sLast":     "Último",
//         "sNext":     "Siguiente",
//         "sPrevious": "Anterior"
//         },
//         "oAria": {
//             "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
//             "sSortDescending": ": Activar para ordenar la columna de manera descendente"
//         }
//     }
// });

// FOCUS EN INPUT MODAL
$('#modalRegistrarCompromisoPago').on('shown.bs.modal', function (e) {
    $('#nombreDeudorCompromiso').focus();
})

$('#checkCobroAnual').click(function(){
    if($('#checkCobroAnual').prop('checked')) {
        $('#cobroAnual').val('SI');
    }else{
        $('#cobroAnual').val('NO');
    }
})

function otroAcreedor(option){
    if(option == 'otro'){
        $('.acreedorEdit').removeClass('d-none');
        $('#acreedor').val('');
    }else{
        $('.acreedorEdit').addClass('d-none');
        $('#acreedor').val(option);
    }
}

/*=============================================
CAMBIOS EN TIPO COMPROMISO PAGO
=============================================*/
$("#tipoCompromiso").change(function(){
    // RESET CHECK COBRO ANUAL
    $('#cobroAnual').val('NO');
    $('#checkCobroAnual').prop("checked", false);
    tipo = $(this).val();
    if(tipo == 'cheque'){
        $('.inputMontoCompromiso').removeClass('d-none');
        $('#esConsumo').addClass('d-none');
        // oculta check compromiso anual y utiliza todo el ancho para ingresar monto        
        $('#anchoMontoCompromiso').removeClass().addClass('col-12'); // ancha el monto
        $('#anchoCheckCobroAnual').addClass('d-none'); // oculta check compromiso Anual
        $('#esCheque').removeClass('d-none');
        $('.inputFechaVencimiento').removeClass('d-none');
        $('.inputAcreedor').removeClass('d-none');
        $('.inputDescripcionCompromiso').removeClass('d-none');
        $('.inputAcreedor').html('<div class="input-group">'+
                                    '<div class="input-group-prepend">'+
                                      '<span class="input-group-text" style="background:white"><i class="fa fa-user-ninja"></i></span>'+
                                    '</div>'+
                                    '<select class="form-control input-lg" onchange="otroAcreedor($(this).val());">'+
                                        '<option value="">Selecionar Acreedor</option>'+
                                        '<option value="Europlast">EUROPLAST</option>'+
                                        '<option value="MasCeramica">MASCERAMICA</option>'+
                                        '<option value="Prodalam">PRODALAM</option>'+
                                        '<option value="otro">OTRO</option>'+
                                    '</select>'+
                                '</div>'+
                                '<div class="acreedorEdit d-none">'+
                                    '<div style="height:3px"></div>'+
                                    '<div class="input-group">'+
                                        '<div class="input-group-prepend">'+
                                          '<span class="input-group-text" style="background:white"><i class="fa fa-user-ninja"></i></span>'+
                                        '</div>'+
                                        '<input type="text" class="input-lg form-control" id="acreedor" name="acreedor" placeholder="Nombre Acreedor" required>'+
                                    '</div>'+
                                '</div>')
    }else if(tipo == 'arriendo'){
        $('.inputMontoCompromiso').removeClass('d-none');
        $('#esConsumo').addClass('d-none');
        $('#esCheque').addClass('d-none');

        // muestra input compromiso y permite hacerlo anual
        $('#anchoMontoCompromiso').removeClass().addClass('col-9');
        $('#anchoCheckCobroAnual').removeClass().addClass('col-3'); 

        $('.inputFechaVencimiento').removeClass('d-none');
        $('.inputAcreedor').removeClass('d-none');
        $('.inputDescripcionCompromiso').removeClass('d-none');
        $('.inputAcreedor').html('<div class="input-group">'+
                                    '<div class="input-group-prepend">'+
                                        '<span class="input-group-text" style="background-color:white"><i class="fa fa-user-ninja"></i></span>'+
                                    '</div>'+
                                    '<select class="form-control input-lg" name="acreedor" id="acreedor">'+
                                        '<option value="">Selecionar Acreedor</option>'+
                                        '<option value="Raul Vera">RAÚL VERA</option>'+
                                    '</select>'+
                                '</div>')
    }else if(tipo == 'compra_activo'){
        $('.inputMontoCompromiso').removeClass('d-none');
        $('#esConsumo').addClass('d-none');
        $('#esCheque').addClass('d-none');

        // oculta check compromiso anual y utiliza todo el ancho para ingresar monto
        $('#anchoMontoCompromiso').removeClass().addClass('col-12');
        $('#anchoCheckCobroAnual').addClass('d-none');

        $('.inputFechaVencimiento').removeClass('d-none');
        $('.inputAcreedor').removeClass('d-none');
        $('.inputDescripcionCompromiso').removeClass('d-none');
        $('.inputAcreedor').html('<div class="input-group">'+
                                    '<div class="input-group-prepend">'+
                                        '<span class="input-group-text" style="background-color:white"><i class="fa fa-user-ninja"></i></span>'+
                                    '</div>'+
                                    '<input type="text" class="input-lg form-control" id="acreedor" name="acreedor" placeholder="Nombre Acreedor">'+
                                 '</div>');

    }else if(tipo == 'gastos_sama' || tipo == 'gastos_carlos' || tipo == 'gastos_edu'){
        $('.inputMontoCompromiso').removeClass('d-none');
        $('#esConsumo').addClass('d-none');
        $('#esCheque').addClass('d-none');

        // oculta check compromiso anual y utiliza todo el ancho para ingresar monto
        $('#anchoMontoCompromiso').removeClass().addClass('col-12');
        $('#anchoCheckCobroAnual').addClass('d-none');

        $('.inputFechaVencimiento').removeClass('d-none');
        $('.inputAcreedor').removeClass('d-none');
        $('.inputDescripcionCompromiso').removeClass('d-none');
        $('.inputAcreedor').html('<div class="input-group">'+
                                    '<div class="input-group-prepend">'+
                                        '<span class="input-group-text" style="background-color:white"><i class="fa fa-user-ninja"></i></span>'+
                                    '</div>'+
                                    '<input type="text" class="input-lg form-control" id="acreedor" name="acreedor" placeholder="Nombre Acreedor">'+
                                 '</div>');

    }else if(tipo == 'tc'){
        $('.inputMontoCompromiso').removeClass('d-none');
        $('#esConsumo').addClass('d-none');
        $('#esCheque').addClass('d-none');

        // oculta check compromiso anual y utiliza todo el ancho para ingresar monto
        $('#anchoMontoCompromiso').removeClass().addClass('col-12');
        $('#anchoCheckCobroAnual').addClass('d-none');

        $('.inputFechaVencimiento').removeClass('d-none');
        $('.inputAcreedor').removeClass('d-none');
        $('.inputDescripcionCompromiso').removeClass('d-none');
        $('.inputAcreedor').html('<div class="input-group">'+
                                    '<div class="input-group-prepend">'+
                                        '<span class="input-group-text" style="background-color:white"><i class="fa fa-user-ninja"></i></span>'+
                                    '</div>'+
                                    '<select class="form-control input-lg" name="acreedor" id="acreedor">'+
                                        '<option value="">Selecionar Acreedor</option>'+
                                        '<option value="tc_falabella_eduar">TC FALABELLA EDUAR</option>'+
                                        '<option value="tc_falabella_carlos">TC FALABELLA CARLOS</option>'+
                                        '<option value="tc_itau_eduar">TC ITAÚ EDUAR</option>'+
                                        '<option value="tc_cencosud_eduar">TC CENCOSUD EDUAR</option>'+
                                    '</select>'+
                                '</div>')
    }else if(tipo == 'convenio'){
        $('#esCheque').addClass('d-none');
        $('.inputFechaVencimiento').removeClass('d-none').addClass('d-none');
        $('#esConsumo').removeClass('d-none');
        $('.inputMontoCompromiso').addClass('d-none');
        $('.inputAcreedor').removeClass('d-none');
        $('.inputDescripcionCompromiso').removeClass('d-none');
        $('.inputAcreedor').addClass('d-none');

    }else if(tipo == 'consumo'){
        $('#esCheque').addClass('d-none');
        $('.inputFechaVencimiento').removeClass('d-none').addClass('d-none');
        $('#esConsumo').removeClass('d-none');
        $('.inputMontoCompromiso').addClass('d-none');
        $('.inputAcreedor').removeClass('d-none');
        $('.inputDescripcionCompromiso').removeClass('d-none');
        $('.inputAcreedor').html('<div class="input-group">'+
                                    '<div class="input-group-prepend">'+
                                        '<span class="input-group-text" style="background-color:white"><i class="fa fa-user-ninja"></i></span>'+
                                    '</div>'+
                                    '<select class="form-control input-lg" name="acreedor" id="acreedor">'+
                                        '<option value="">Selecionar Acreedor</option>'+
                                        '<option value="estado_carlos">BCO ESTADO CARLOS</option>'+
                                        '<option value="estado_edu">BCO ESTADO EDUAR</option>'+
                                        '<option value="falabella_carlos">BCO FALABELLA CARLOS</option>'+
                                        '<option value="falabella_edu">BCO FALABELLA EDUAR</option>'+
                                        '<option value="itau_carlos">BCO ITAÚ CARLOS</option>'+
                                        '<option value="itau_edu">BCO ITAÚ EDUAR</option>'+
                                        '<option value="santander_edu">BCO SANTANDER EDUAR</option>'+
                                        '<option value="somnaval_carlos">SOMNAVAL CARLOS</option>'+
                                        '<option value="somnaval_edu">SOMNAVAL EDUAR</option>'+
                                        '<option value="caja_los_andes_carlos">CAJA LOS ANDES CARLOS</option>'+
                                        '<option value="caja_los_andes_edu">CAJA LOS ANDES EDUAR</option>'+
                                    '</select>'+
                                '</div>'+
                                '<div class="form-group"> '+
                                    '<div class="input-group">'+
                                        '<div class="input-group-prepend">'+
                                            '<span class="input-group-text" style="background-color:white"><i class="nav-icon fa-solid fa-building-columns"></i></span>'+
                                        '</div>'+
                                        '<select class="form-control input-lg" name="bancoAcreedor" id="bancoAcreedor">'+
                                            '<option value="">Selecionar Banco</option>'+
                                            '<option value="bci">BCI</option>'+
                                            '<option value="estado">ESTADO</option>'+
                                            '<option value="falabella">FALABELLA</option>'+
                                            '<option value="itau">ITAU</option>'+
                                            '<option value="santander">SANTANDER</option>'+
                                            '<option value="scotiabank">SCOTIABANK</option>'+
                                            '<option value="somnaval">SOMNAVAL</option>'+
                                            '<option value="caja_los_andes">CAJA LOS ANDES</option>'+
                                        '</select>'+
                                    '</div>'+
                                '</div>'+

                                '<div class="form-group">'+
                                    '<div class="input-group">'+
                                        '<div class="input-group-prepend">'+
                                            '<span class="input-group-text" style="background-color:white"><i class="fas fa-hashtag"></i></span>'+
                                        '</div>'+
                                        '<input type="text" class="form-control input-lg" name="nroCredito" placeholder="Ingrese nro Crédito">'+
                                    '</div>'+
                                '</div>')
    }else if(tipo == 'hipotecario'){
        // $('.inputMontoCompromiso').removeClass('d-none');
        // $('#esConsumo').removeClass('d-none');
        // $('#esCheque').addClass('d-none');
        // muestra input compromiso y permite hacerlo anual
        $('#anchoMontoCompromiso').removeClass().addClass('col-9');
        // $('#anchoCheckCobroAnual').removeClass().addClass('col-3'); 
        $('#anchoCheckCobroAnual').addClass('d-none');
        // $('.inputFechaVencimiento').removeClass('d-none');
        // $('#primerVencimientoHipotecario').removeClass('d-none');
        $('.inputAcreedor').removeClass('d-none');
        $('.inputDescripcionCompromiso').addClass('d-none');
        $('.inputAcreedor').html('<div class="input-group">'+
                                    '<div class="input-group-prepend">'+
                                        '<span class="input-group-text" style="background-color:white"><i class="fa fa-user-ninja"></i></span>'+
                                    '</div>'+
                                    '<select class="form-control input-lg" name="acreedor" id="acreedor">'+
                                        '<option value="">Selecionar Deudor</option>'+
                                        '<option value="c14">CASA 14 - EDUAR</option>'+
                                        '<option value="c47">CASA 47 - CARMEN</option>'+
                                        '<option value="c48">CASA 48 - CARLOS</option>'+
                                        '<option value="c68">CASA 68 - JANORON</option>'+
                                        '<option value="c69">CASA 69 - SAMA</option>'+
                                        '<option value="agua salada">TERRENO AGUA SALADA - CARLOS</option>'+
                                    '</select>'+
                                '</div>'+

                                '<div class="form-group"> '+
                                    '<div class="input-group">'+
                                        '<div class="input-group-prepend">'+
                                            '<span class="input-group-text" style="background-color:white"><i class="nav-icon fa-solid fa-building-columns"></i></span>'+
                                        '</div>'+
                                        '<select class="form-control input-lg" name="bancoAcreedor" id="bancoAcreedor">'+
                                            '<option value="">Selecionar Banco</option>'+
                                            '<option value="bci">BCI</option>'+
                                            '<option value="estado">ESTADO</option>'+
                                            '<option value="falabella">FALABELLA</option>'+
                                            '<option value="itau">ITAU</option>'+
                                            '<option value="santander">SANTANDER</option>'+
                                            '<option value="scotiabank">SCOTIABANK</option>'+
                                        '</select>'+
                                    '</div>'+
                                '</div>'+

                                '<div class="form-group">'+
                                    '<div class="input-group">'+
                                        '<div class="input-group-prepend">'+
                                            '<span class="input-group-text" style="background-color:white"><i class="fas fa-hashtag"></i></span>'+
                                        '</div>'+
                                        '<input type="text" class="form-control input-lg" name="nroCredito" placeholder="Ingrese nro Crédito">'+
                                    '</div>'+
                                '</div>'+

                                '<div class="form-group">Primer Vencimiento'+
                                    '<div class="input-group">'+
                                        '<div class="input-group-prepend">'+
                                            '<span class="input-group-text" style="background-color:white"><i class="fa fa-calendar-alt"></i></span>'+
                                        '</div>'+
                                        '<input type="date" class="form-control input-lg" maxlength="10" onkeypress="return soloFecha(event)" id="primerVencimientoHipotecario" name="primerVencimientoHipotecario" value="">'+
                                    '</div>'+
                                '</div>'+
                                '<div class="inputMontoCompromiso form-group">'+
                                    '<div class="row">'+
                                        '<div class="col-6" id="anchoMontoCompromiso">'+
                                            '<div class="input-group">'+
                                                '<div class="input-group-prepend">'+
                                                    '<span class="input-group-text" style="background-color:white"><i class="fa fa-dollar-sign"></i></span>'+
                                                '</div>'+
                                                '<input type="number" step="0.01" class="form-control input-lg" id="montoHipotecario" name="montoHipotecario" placeholder="Ingrese monto en UF">'+
                                            '</div>'+
                                        '</div>'+
                                        '<div class="col-6" id="anchoMontoCompromiso">'+
                                            '<div class="input-group">'+
                                                '<div class="input-group-prepend">'+
                                                    '<span class="input-group-text" style="background:white"><i class="fa fa-list-ol"></i></span>'+
                                                '</div>'+
                                                '<input type="number" class="form-control input-lg" id="cuotasHipotecario" name="cuotasHipotecario" placeholder="Ingrese nro Cuotas">'+
                                            '</div>'+
                                        '</div>'+
                                    '</div>'+
                                '</div>')
    }else{
        $('.inputMontoCompromiso').addClass('d-none');
        $('#esConsumo').addClass('d-none');
        $('#esCheque').addClass('d-none');
        $('.inputFechaVencimiento').addClass('d-none');
        $('.inputAcreedor').addClass('d-none');
        $('.inputDescripcionCompromiso').addClass('d-none');
    }
})

/*=============================================
ELIMINAR COMPROMISO PAGO
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("click", ".btnEliminarCompromisoPago", function(){
    var id = $(this).attr("idCompromisoPago");
    Swal.fire({
        title: '¿Está seguro de borrar el Compromiso de Pago?',
        text: "¡Si no lo está puede cancelar la accíón!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, eliminar Compromiso!'
    }).then(function(result){
        if(result.value){
            var datos = new FormData();
            datos.append("eliminarCompromiso", id);
            $.ajax({
                url: "ajax/compromisos-pago.ajax.php",
                method: "POST",
                data: datos,
                cache: false,
                contentType: false,
                processData: false,
                success: function(r){ 
                    if(r == 'ok'){                    
                        mixinInfo('Compromiso Eliminado');
                        $('.tablaCompromisos').DataTable().ajax.reload();
                    }
                }
            })
        }
    })
})

/*=============================================
CAMBIO NRO GUIA O FACTURA
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("dblclick", ".editGuiaFact", function(){
    var idCompromiso = $(this).attr('idCompromisoPago');
    var datos = new FormData();
    datos.append("infoCompromiso", idCompromiso);
    $.ajax({
        url: "ajax/compromisos-pago.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        success: function(r){ 
            const datosCompromiso = JSON.parse(r);

            let descripcion = datosCompromiso.descripcion;
            
            // Expresiones regulares para extraer los números
            const guiaRegex = /Guía nro\.\s*(\d+)/;
            const facturaRegex = /Factura nro\.\s*(\d+)/;

            // Buscar coincidencias en el texto
            const guiaMatch = descripcion.match(guiaRegex);
            const facturaMatch = descripcion.match(facturaRegex);

            // Extraer los números encontrados
            const guiaNro = guiaMatch ? guiaMatch[1] : null;
            const facturaNro = facturaMatch ? facturaMatch[1] : null;

            if(guiaNro == null){ // si solo hay factura
                $('#editGuiaFact'+idCompromiso).html(
                    'Nro Factura'+
                    '<input type="text" style="width:60%" class="form-control input-xs nroFact" id="editNroDoc'+idCompromiso+'" placeholder="Nro Factura" '+
                    'onkeypress="return soloNumeros(event)" value="'+facturaNro+'"><div style="height:3px"></div>'+
                    '<button style="width:35%" class="btn btn-info btn-sm editarNroDoc input-seguido" idCompromiso="'+idCompromiso+'"><font size="-1">Actualizar</font></button>'+
                    '<button style="width:20%" class="btn btn-danger btn-sm cancelarEditarNroDoc"><i class="fa fa-times"></i></button>');
                $('#editNroDoc'+idCompromiso).select();
            }else{ // si hay guia asociada
                let nroFact = facturaNro == null ? '' : facturaNro;
                $('#editGuiaFact'+idCompromiso).html(
                    'Nro Guía'+
                    '<input type="text" style="width:60%" class="form-control input-xs nroGuia" id="editNroDoc'+idCompromiso+'" placeholder="Nro Guía" '+
                    'onkeypress="return soloNumeros(event)" value="'+guiaNro+'"><div style="height:3px"></div>'+
                    'Nro Factura'+
                    '<input type="text" style="width:60%" class="form-control input-xs nroFact" placeholder="Nro Factura" '+
                    'onkeypress="return soloNumeros(event)" value="'+nroFact+'"><div style="height:3px"></div>'+
                    '<button style="width:35%" class="btn btn-info btn-sm editarNroDoc input-seguido" idCompromiso="'+idCompromiso+'"><font size="-1">Actualizar</font></button>'+
                    '<button style="width:20%" class="btn btn-danger btn-sm cancelarEditarNroDoc"><i class="fa fa-times"></i></button>');
                $('#editNroDoc'+idCompromiso).select();
            }
        }
    })
})
/*=============================================
CANCELAR CAMBIO MONTO COMRPOMISO
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("click", ".cancelarEditarNroDoc", function(){
    $('.table').DataTable().ajax.reload();
})
/*=============================================
ACTUALIAR CAMBIO MONTO COMRPOMISO
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("click", ".editarNroDoc", function(){
    var idCompromiso = $(this).attr('idCompromiso');
    var nroFact = $(this).parent().children('.nroFact').val();
    var nroGuia = $(this).parent().children('.nroGuia').val();
    var descripcionNueva = nroGuia == undefined ? 'Factura nro. '+nroFact : 'Guía nro. '+nroGuia+' - Factura nro. '+nroFact;

    var datos = new FormData();
    datos.append("editNroDocumento", idCompromiso);
    datos.append("descripcionNroDoc", descripcionNueva);
    $.ajax({
        url: "ajax/compromisos-pago.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        success: function(r){
            if(r == 'ok'){
                audioSuccess('Nros Actualizados con éxito')
                $('.table').DataTable().ajax.reload();
            }
        }
    })
})



/*=============================================
CAMBIO MONTO COMPROMISO
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("dblclick", "#montoCompromiso", function(){
    var idCompromiso = $(this).attr('idCompromisoPago');
    // var fecha = $(this).attr('fecha');
    var datos = new FormData();
    datos.append("infoCompromiso", idCompromiso);
    $.ajax({
        url: "ajax/compromisos-pago.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        success: function(r){ 
            
            const datosCompromiso = JSON.parse(r);
            if(datosCompromiso.tipo_compromiso == 'hipotecario'){
                Swal.mixin({toast: true,position: 'top-start',showConfirmButton: false,timer: 2000}).fire({icon: 'info',title: 'Solo se puede modificar fecha en compromisos en UF'});
                $('#descripcionCompromiso'+idCompromiso).html(
                    'Fecha Vencimiento'+
                    '<input type="date" style="width:60%" class="form-control input-xs edit editFechaCompromiso" maxlength="10" onkeypress="return soloFecha(event)" id="editFechaCompromiso" placeholder="Fecha contable" value="'+datosCompromiso.fecha_vencimiento+'"><div style="height:3px"></div>'+
                    'Monto ($)'+
                    '<input type="text" style="width:60%" class="form-control input-xs montoCompromisoActualizar" id="editInputMontoCompromiso'+idCompromiso+'" onkeyup="formatoMiles($(this));" placeholder="Monto Compromiso" '+
                    'onkeypress="return soloNumeros(event)" value="'+formatNumber.new(datosCompromiso.monto)+'" disabled><div style="height:3px"></div>'+
                    '<button style="width:35%" class="btn btn-info btn-sm editarFechaCompromisoHipo input-seguido" idCompromiso="'+idCompromiso+'"><font size="-1">Actualizar</font></button>'+
                    '<button style="width:20%" class="btn btn-danger btn-sm cancelarEditarMontoCompromiso"><i class="fa fa-times"></i></button>');
                $('#editFechaCompromiso').select();
            }else{
                $('#descripcionCompromiso'+idCompromiso).html(
                    'Fecha Vencimiento'+
                    '<input type="date" style="width:60%" class="form-control input-xs edit editFechaCompromiso" maxlength="10" onkeypress="return soloFecha(event)" id="editFechaCompromiso" placeholder="Fecha contable" value="'+datosCompromiso.fecha_vencimiento+'"><div style="height:3px"></div>'+
                    'Monto ($)'+
                    '<input type="text" style="width:60%" class="form-control input-xs montoCompromisoActualizar" id="editInputMontoCompromiso'+idCompromiso+'" onkeyup="formatoMiles($(this));" placeholder="Monto Compromiso" '+
                    'onkeypress="return soloNumeros(event)" value="'+formatNumber.new(datosCompromiso.monto)+'"><div style="height:3px"></div>'+
                    '<button style="width:35%" class="btn btn-info btn-sm editarMontoCompromiso input-seguido" idCompromiso="'+idCompromiso+'"><font size="-1">Actualizar</font></button>'+
                    '<button style="width:20%" class="btn btn-danger btn-sm cancelarEditarMontoCompromiso"><i class="fa fa-times"></i></button>');
                $('#editInputMontoCompromiso'+idCompromiso).select();

            }

        }
    })
})
/*=============================================
CANCELAR CAMBIO MONTO COMRPOMISO
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("click", ".cancelarEditarMontoCompromiso", function(){
    $('.table').DataTable().ajax.reload();
})
/*=============================================
ACTUALIAR CAMBIO MONTO COMRPOMISO
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("click", ".editarMontoCompromiso", function(){
    var idCompromiso = $(this).attr('idCompromiso');
    var fecha = $(this).parent().children('.editFechaCompromiso').val();
    var monto = $(this).parent().children('.montoCompromisoActualizar').val();
    var datos = new FormData();
    datos.append("editarMontoCompromiso", idCompromiso);
    datos.append("montoActualizado", monto);
    datos.append("fecha", fecha);
    $.ajax({
        url: "ajax/compromisos-pago.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        success: function(r){
            if(r == 'ok'){
                audioSuccess('Monto Actualizado')
                $('.tablaCompromisos').DataTable().ajax.reload();
            }
        }
    })
})

/*=============================================
ACTUALIAR FECHA COMPROMISO HIPO
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("click", ".editarFechaCompromisoHipo", function(){
    var idCompromiso = $(this).attr('idCompromiso');
    var fecha = $(this).parent().children('.editFechaCompromiso').val();
    var datos = new FormData();
    datos.append("editarFechaCompromisoHipo", idCompromiso);
    datos.append("fecha", fecha);
    $.ajax({
        url: "ajax/compromisos-pago.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        beforeSend: function(){
          $('.editarFechaCompromisoHipo').attr('disabled','disabled');
          $('.cancelarEditarMontoCompromiso').attr('disabled','disabled');
        },
        success: function(r){
            if(r == 'ok'){
                audioSuccess('Monto Actualizado')
                $('.tablaCompromisos').DataTable().ajax.reload();
            }
        }
    })
})


/*=============================================
REGISTRAR PAGO  COMPROMISO
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("click", "#btnPagarCompromisoPago", function(){
    var id = $(this).attr("idCompromisoPago");
    var aPago = $(this).attr("aPagar");
    var titulo = $(this).attr("titulo");
    var vencimiento = $(this).attr("vencimiento");
    $('#tituloRegistraPago').html("<font size='+1'>"+titulo+"   <b>"+vencimiento+"</b></font>");
    $('#registrarPagoID').val(id);
    $('#aPagar').val(aPago);
    $('.aPagarCompromiso').text('$ '+formatNumber.new(aPago));
    $('#montoPagadoVista').val(formatNumber.new(aPago));
    $('.montoPagado').val(aPago);
})
/*=============================================
APLICAR NC
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("click", "#btnAplicarNC", function(){
    var id = $(this).attr("idCompromisoPago");
    var aPago = $(this).attr("aPagar");
    var titulo = $(this).attr("titulo");
    $('#tituloRegistroNC').html("<font size='+1'>"+titulo+"</font>");
    $('#idCompromisoPagoAbonoParcial').val(id);
    $('#aPagarAbonoParcial').val(aPago);
    $('.aPagarCompromiso').text('$ '+formatNumber.new(aPago));
})

/*=============================================
REVOCAR PAGO
=============================================*/
$(".tablaCompromisos,.tablaCompromisosMovil").on("click", "#btnRevocarPago", function(){
    var idCompromisoPago = $(this).attr('idCompromisoPago');
    var datos = new FormData();
    datos.append("revocarPago", idCompromisoPago);
    $.ajax({
        url: "ajax/compromisos-pago.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        success: function(r){
            audioSuccess('Pago Revocado');
            $('#comprobantePagoCompromiso'+idCompromisoPago).removeClass('badge-success').removeClass('comprobantePagoCompromiso').addClass('badge-danger').text('VENCIDO');
            $('#estadoPago'+idCompromisoPago).html('<h4><span class="label label-warning">Revocado</span></h4>');
            $('#montoPagado'+idCompromisoPago).html('-');
            $('#interesPagado'+idCompromisoPago).html('-');
            $('#pagadoCon'+idCompromisoPago).html('-');
            $('#botonesCompromisoPago'+idCompromisoPago).html(  '<div class="btn-group">'+
                                                                    '<button class="btn btn-success btnPagarCompromisoPago info" data-original-title="Registrar Pago" id="btnPagarCompromisoPago" aPagar="'+$(this).attr('monto')+'" idCompromisoPago="'+idCompromisoPago+'" data-toggle="modal" data-target="#modalRegistrarPago">'+
                                                                        '<i class="fa fa-money-bill-alt"></i>'+
                                                                    '</button>'+
                                                                    '<button class="btn btn-danger btnEliminarCompromisoPago info" data-original-title="Eliminar Compromiso" id="btnEliminarCompromisoPago" idCompromisoPago="'+idCompromisoPago+'">'+
                                                                        '<i class="fa fa-times"></i>'+
                                                                    '</button>'+
                                                                '</div>');
            $('.tablaCompromisos').DataTable().ajax.reload();
        }
    })
})

/*=============================================
CAMBIOS EN MONEDA DE PAGO
=============================================*/
$("#monedaPagoCompromiso").change(function(){
    var moneda = $(this).val();
    if(moneda == 'efectivo'){
        $('#cobroACta').html(   '<option value="">Procedencia</option>'+
                                '<option value="caja_fuerte_central">CAJA FUERTE CENTRAL</option>');
    }else{
        $('#cobroACta').html(   '<option value="">Procedencia</option>'+
                                '<option value="estado_carlos">ESTADO CARLOS</option>'+
                                '<option value="estado_eduar">ESTADO EDUAR</option>'+
                                '<option value="falabella_carlos">FALABELLA CARLOS</option>'+
                                '<option value="falabella_eduar">FALABELLA EDUAR</option>'+
                                '<option value="itau_carlos">ITAÚ CARLOS</option>'+
                                '<option value="itau_eduar">ITAÚ EDUAR</option>'+
                                '<option value="santander_eduar">SANTANDER EDUAR</option>'+
                                '<option value="dcto_automatico_carlos">DESCUENTO AUTOMATICO CARLOS</option>'+
                                '<option value="dcto_automatico_eduar">DESCUENTO AUTOMATICO EDUAR</option>');
    }
})