<?php

require_once "conexion.php";

class ModeloSucursales{

    /*=============================================
    MOSTRAR LOCALES
    =============================================*/
    static public function mdlMostrarSucursales($tabla, $item, $valor){
        if($item == null){
            // Consulta sin parámetro de búsqueda
            $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY nombre_sucursal ASC");
        } else {
            // Consulta con parámetro de búsqueda
            $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");
            // Solo enlaza el parámetro si hay un valor para $item
            $stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
        }

        $stmt -> execute();
        $resultado = $stmt -> fetchAll();

        // Liberar el recurso asignando null
        $stmt = null;

        return $resultado;
    }

    /*==============================================
    CAMBIO SUCURSAL (SE REQUIEREN DATOS DE 2 TABLAS)
    ==============================================*/
    static public function mdlCambioSucursalCompra($idCompra){
        $stmt = Conexion::conectar()->prepare("SELECT `id`,`sucursal_abastecida`,`abastecimiento` FROM `compras` WHERE `id` = :idCompra UNION SELECT `id`,`nombre_sucursal`,`alias_sucursal` FROM `sucursales`");
        $stmt -> bindParam(":idCompra", $idCompra, PDO::PARAM_INT);
        $stmt -> execute();

        $resultado = $stmt -> fetchAll();

        // Liberar el recurso asignando null
        $stmt = null;

        return $resultado;
    }
}
?>
