<?php

require_once "conexion.php";

class ModeloProductos{

	/*==================================================================
	COMPRAS NO URGENTES
	==================================================================*/
	static public function mdlComprasNoUrgentes(){
		$bodega = 'bodega1';
		$stockIdealBodega = 'stock_ideal_'.$bodega;
	    $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
	    $locales = [];
	    foreach ($sucursales as $key => $value){
	      array_push($locales, $value['nombre_sucursal']);
	    }
	    $stockLocales = '';
	    foreach ($locales as $key) {
	      $stockLocales .= 'stock_'.$key.'+';
	    }
	    $stockLocalesSQL =  substr($stockLocales, 0, -1);
		$stmt = Conexion::conectar()->prepare("SELECT * FROM `productos` WHERE ($stockLocalesSQL) <= ($stockIdealBodega/3) AND control_inventario = 2 AND transformable != 2 ORDER BY proveedor ASC, descripcion ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*==================================================================
	COMPRAS NECESARIAS
	==================================================================*/
	static public function mdlComprasNecesarias(){
	    $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
	    $locales = [];
	    foreach ($sucursales as $key => $value){
	      array_push($locales, $value['nombre_sucursal']);
	    }
	    $stockLocales = '';
	    foreach ($locales as $key) {
	      $stockLocales .= 'stock_'.$key.'+';
	    }
	    $stockLocalesSQL =  substr($stockLocales, 0, -1);
		$stmt = Conexion::conectar()->prepare("SELECT * FROM `productos` WHERE ($stockLocalesSQL) = 0 AND control_inventario = 2 AND transformable != 2 ORDER BY proveedor ASC, descripcion ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*==================================================================
	PRODUCTOS AGOTADOS
	==================================================================*/
	static public function mdlProductosAgotados($sucursal){
		$stock = 'stock_'.$sucursal;
		$stmt = Conexion::conectar()->prepare("SELECT count(id) as total FROM `productos` WHERE $stock = 0 AND control_inventario = 1 AND transformable != 2");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	/*==================================================================
	PRODUCTOS BAJO STOCK
	==================================================================*/
	static public function mdlProductosBajoStock($sucursal){
		$stock = 'stock_'.$sucursal;
		$stockIdeal = 'stock_ideal_'.$sucursal;
		$stmt = Conexion::conectar()->prepare("SELECT count(id) as total FROM `productos` WHERE $stock > 0 AND $stock < $stockIdeal/2 AND control_inventario = 1 AND transformable != 2");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	/*==================================================================
	COMPRAS URGENTES
	==================================================================*/
	static public function mdlComprasMuyUrgentes(){
		$sucursal = $_SESSION['sucursal'];
	    $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
	    $locales = [];
	    foreach ($sucursales as $key => $value){
	      array_push($locales, $value['nombre_sucursal']);
	    }
	    $stockLocales = '';
	    foreach ($locales as $key) {
	      $stockLocales .= 'stock_'.$key.'+';
	    }
	    $stockLocalesSQL =  substr($stockLocales, 0, -1);
		$stmt = Conexion::conectar()->prepare("SELECT * FROM `productos` WHERE ($stockLocalesSQL) = 0 AND control_inventario = 1 AND transformable != 2 ORDER BY proveedor ASC, descripcion ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}


	static public function mdlComprasUrgentes(){
		$sucursal = $_SESSION['sucursal'];
		$bodega = 'bodega1';
		$stockIdealBodega = 'stock_ideal_'.$bodega;
	    $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
	    $locales = [];
	    foreach ($sucursales as $key => $value){
	      array_push($locales, $value['nombre_sucursal']);
	    }
	    $stockLocales = '';
	    foreach ($locales as $key) {
	      $stockLocales .= 'stock_'.$key.'+';
	    }
	    $stockLocalesSQL =  substr($stockLocales, 0, -1);
		$stmt = Conexion::conectar()->prepare("SELECT * FROM `productos` WHERE ($stockLocalesSQL) <= ($stockIdealBodega/2) AND control_inventario = 1 AND transformable != 2 ORDER BY proveedor ASC, descripcion ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}


	/*==================================================================
	ABASTECIMIENTO A LOCAL_VENTA DESDE BODEGA 
	==================================================================*/
	static public function mdlAbastecimientoDesdeBodega(){
		$sucursal = $_SESSION['sucursal'];
		$bodega = 'bodega1';
		$stockLocal = 'stock_'.$sucursal;
		$stockIdealLocal = 'stock_ideal_'.$sucursal;
		$stockBodega = 'stock_'.$bodega;
		$zona = 'zona_'.$bodega;
		// EXTRAE TODOS LOS PRODUCTOS QUE CUMPLAN CON: STOCK_LOCAL <= 1/3 DEL STOCK_IDEAL_LOCAL y NO HAY STOCK EN BODEGA y  EL PRODUCTO NO ES SURTIBLE
		$stmt = Conexion::conectar()->prepare("SELECT * FROM `productos` WHERE $stockLocal <= ($stockIdealLocal/3) AND $stockBodega > 0 AND transformable != 2 ORDER BY $zona ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*==================================================================
	ABASTECIMIENTO A LOCAL_VENTA DESDE BODEGA 
	==================================================================*/
	static public function mdlAbastecimientoInterno_AlCierre(){

		$sucursal = $_SESSION['sucursal'];
		$stockLocal = 'stock_'.$sucursal;
		$stockIdealLocal = 'stock_ideal_'.$sucursal;

		$bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");

	    $stockBodegas = '';
  		foreach ($bodegas as $key_0 => $value_0) {
    		$stockBodegas = 'stock_'.$value_0['nombre_sucursal'].'+';
  		}
	    $stockBodegas =  substr($stockBodegas, 0, -1);

		$zona = 'zona_'.$sucursal;

		$stmt = Conexion::conectar()->prepare("SELECT * FROM `productos` WHERE $stockLocal <= ($stockIdealLocal/2) AND $stockBodegas > 0 AND transformable != 2 AND control_inventario = 1 UNION SELECT * FROM `productos` WHERE $stockLocal <= ($stockIdealLocal/3) AND $stockBodegas > 0 AND transformable != 2 AND control_inventario = 2 UNION SELECT * FROM `productos` WHERE $stockLocal = 0 AND $stockBodegas > 0 AND transformable != 2 AND control_inventario = 0 ORDER BY $zona ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}


	/*==================================================================
	SELECCIONAR PRODUCTOS TRANSFORMABLES CON STOCK MENOR A 1/3 DEL IDEAL
	==================================================================*/
	static public function mdlSeleccionarTransformablesBajoStock(){
		$sucursal = $_SESSION['sucursal'];
		$stockLocal = 'stock_'.$sucursal;
		$stockIdeal = 'stock_ideal_'.$sucursal;
		$stmt = Conexion::conectar()->prepare("SELECT * FROM `productos` WHERE `transformable` = 2 AND $stockLocal < ($stockIdeal/3)");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	SELECCIONAR ULTIMO_ID_REGISTRO
	=============================================*/
	static public function mdlSeleccionarUltimoIdRegistro(){
		$stmt = Conexion::conectar()->prepare("SELECT `id_registro` FROM `actividad_inventario` ORDER by `id` DESC LIMIT 1");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	REGISTRO ABASTECIMIENTO EXTERNO
	=============================================*/
	static public function mdlIngresarAbastecimiento($tabla, $total, $fecha_ingreso, $estado, $fecha_compra, $abastecimiento, $factura, $guia, $otro_doc, $id_prov, $nom_prov, $id_trab, $nom_trab, $ultimoRegistro, $sucursal, $tipoPago){
		// $sucursal = $_SESSION['sucursal'];
		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(sucursal_abastecida, estado, abastecimiento, id_prov, nom_prov, id_trab, nom_trab, factura, guia, otro_doc, fecha_compra, total, fecha_ingreso, tipo_pago) VALUES ('$sucursal', :estado, :abastecimiento, :id_prov, :nom_prov, :id_trab, :nom_trab, :factura, :guia, :otro_doc, :fecha_compra, :total, :fecha_ingreso, '$tipoPago')");
		$stmt->bindParam(":estado", $estado, PDO::PARAM_STR);
		$stmt->bindParam(":abastecimiento", $abastecimiento, PDO::PARAM_STR);
		$stmt->bindParam(":id_prov", $id_prov, PDO::PARAM_INT);
		$stmt->bindParam(":nom_prov", $nom_prov, PDO::PARAM_STR);
		$stmt->bindParam(":id_trab", $id_trab, PDO::PARAM_INT);
		$stmt->bindParam(":nom_trab", $nom_trab, PDO::PARAM_STR);
		$stmt->bindParam(":factura", $factura, PDO::PARAM_INT);
		$stmt->bindParam(":guia", $guia, PDO::PARAM_INT);
		$stmt->bindParam(":otro_doc", $otro_doc, PDO::PARAM_INT);
		$stmt->bindParam(":fecha_compra", $fecha_compra, PDO::PARAM_STR);
		$stmt->bindParam(":total", $total, PDO::PARAM_INT);
		$stmt->bindParam(":fecha_ingreso", $fecha_ingreso, PDO::PARAM_STR);
		// $stmt->bindParam(":tipo_pago", $tipoPago, PDO::PARAM_STR);
		if($stmt->execute()){

			// INSERTAR COD VENTA EN REGISTRO INVENTARIO
			// $stmt = Conexion::conectar()->prepare("SELECT @@identity AS id");
			$ultimoId = ModeloCompras::mdlSeleccionarUltimoIdCompra()['id'];
			$codCompraActividad = ModeloProductos::mdlActualizarProducto('actividad_inventario', 'detalle', $ultimoId, $ultimoRegistro);



			return "ok";
		}else{
			return "error";
		}
		$stmt->close();
		$stmt = null;
	}

	/*=============================================
	INVERSION
	=============================================*/
	static public function mdlMostrarInversion($tabla, $item1, $item2){

		$stmt = Conexion::conectar()->prepare("SELECT SUM($item1*$item2) as inversion FROM $tabla");

		$stmt -> execute();

		return $stmt -> fetch();

		$stmt -> close();

		$stmt = null;
	}

	/*=============================================
	INVERSION
	=============================================*/
	static public function mdlAvanceConteo($estadoProd, $checkProd, $orden){

		$stmt = Conexion::conectar()->prepare("SELECT * FROM productos WHERE $estadoProd = 1 AND $checkProd = 1 ORDER BY $orden ASC");

		$stmt -> execute();

		return $stmt -> fetchAll();

		$stmt -> close();

		$stmt = null;
	}




	/*=============================================
	MULTIPLICAR 2 COINCIDENCIA 1
	=============================================*/
	static public function mdlMultiplicar2Coincidir1($tabla, $item1, $item2, $item3, $valor3){

		$stmt = Conexion::conectar()->prepare("SELECT SUM($item1*$item2) as total FROM $tabla WHERE $item3 = :$item3");
		$stmt -> bindParam(":".$item3, $valor3, PDO::PARAM_STR);
		$stmt -> execute();

		return $stmt -> fetch();

		$stmt -> close();

		$stmt = null;
	}



	/*=================================================================================
	REEMPLAZA ULTIMO ID EN TODA LA TABLA CUANDO COINCIDE LA CATEGORIA Y LA SUBCATEGORIA 
	=================================================================================*/

	static public function mdlUltimoId($tabla, $ultimoSubCod, $subCodInterno){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET ult_sub_cod_int = :ult_sub_cod_int WHERE sub_cod_int = $subCodInterno");
		$stmt -> bindParam(":ult_sub_cod_int", $ultimoSubCod, PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt->close();
		$stmt = null;

	}


	/*=============================================
	SELECCIONAR Maximo de la tabla
	=============================================*/
	static public function mdlSeleccionarItem($tabla, $item, $item_coincidencia, $valor){

		$stmt = Conexion::conectar()->prepare("SELECT MAX($item) as item FROM $tabla WHERE $item_coincidencia = $valor" );

		$stmt -> execute();

		return $stmt -> fetch();

		$stmt -> close();

		$stmt = null;
	}


	/*=============================================
	MOSTRAR PRODUCTOS FALTANTES
	=============================================*/

	static public function mdlMostrarProductosFaltantes($tabla, $item, $valor, $orden){

	$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY $orden DESC");

	$stmt -> execute();

	return $stmt -> fetchAll();

	$stmt -> close();

	$stmt = null;

	}

	/*=============================================
	MOSTRAR RETIRO PRODUCTOS
	=============================================*/
	static public function mdlMostrarRetiroProductos($tabla, $item, $valor, $orden){

		if($item == null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY $orden DESC");

			$stmt -> execute();

			return $stmt -> fetchAll();

			$stmt -> close();

			$stmt = null;

		}else if($item == "id_asociado"){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY $orden ASC");
			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
			$stmt -> execute();
			return $stmt -> fetchAll();
			$stmt -> close();
			$stmt = null;

		}else if($item == "id"){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");
			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
			$stmt -> execute();
			return $stmt -> fetch();
			$stmt -> close();
			$stmt = null;
		}	
	}


	static public function mdlMostrarProducto($tabla, $item, $valor){


		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

		$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

		$stmt -> execute();

		return $stmt -> fetch();
		
		$stmt -> close();

		$stmt = null;		

	}

	static public function mdlMostrarProductosAllActivos(){

		$sucursal = $_SESSION['sucursal'];
		$estado = 'estado_'.$sucursal;
		$stmt = Conexion::conectar()->prepare("SELECT * FROM productos WHERE $estado = 1 ORDER BY descripcion ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;

	}

	static public function mdlMostrarProductos($tabla, $item, $valor, $orden){

		if($item != null && $valor > 1){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY $orden DESC");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else if($item != null && $valor <= 1){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY $orden DESC");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchAll();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado_local1 = 1 ORDER BY $orden ASC");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}

		$stmt -> close();

		$stmt = null;

	}

	static public function mdlMostrarProductosInforme($tabla, $item, $valor, $orden){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY $orden ASC");
		$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;		
	}

	static public function mdlMostrarProductos1($tabla, $item, $valor, $orden){
	
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item > 0 ORDER BY $orden ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;

	}


	static public function mdlMostrarProductosPedidoAll($item,$valor,$orden){
		$stmt = Conexion::conectar()->prepare("SELECT id,stock_compra, descripcion, pc_neto, precio_compra FROM productos WHERE $item = :$item and stock_compra > 0 ORDER BY $orden ASC");
		$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlMostrarProductos1_orden2($tabla, $item, $valor, $orden1, $orden2){
	
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item > 0 ORDER BY $orden1 ASC, $orden2 ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;

	}


	static public function mdlMostrarProductos2($tabla, $item1, $valor1, $item2, $valor2, $orden){
	
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item1 = :$item1 AND $item2 <= :$item2 ORDER BY $orden ASC");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);

		$stmt -> execute();

		return $stmt -> fetchAll();
		
		$stmt -> close();

		$stmt = null;

	}	

	static public function mdlMostrarProductos3($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $orden){
	
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item1 = :$item1 AND $item2 <= :$item2 AND $item3 = :$item3 ORDER BY $orden ASC");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item3, $valor3, PDO::PARAM_STR);

		$stmt -> execute();

		return $stmt -> fetchAll();
		
		$stmt -> close();

		$stmt = null;

	}		

	static public function mdlMostrarProductos4($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $item4, $valor4, $orden){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item1 = :$item1 AND $item2 < $valor2/3 AND $item3 = :$item3 AND $item4 > :$item4 ORDER BY $orden ASC");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		// $stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item3, $valor3, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item4, $valor4, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}		 

	static public function mdlMostrarProductosPedidoProveedor($item1, $valor1, $item2, $valor2, $item3, $valor3, $orden){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM productos WHERE FIND_IN_SET(:$item1, $item1) AND $item2 = :$item2 AND $item3 <= $valor3/3 AND stock_compra > 0 ORDER BY $orden ASC");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;		
	}

	static public function mdlMostrarProductosPedidoProveedor2($tabla, $item1, $valor1, $item2, $valor2, $orden){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE FIND_IN_SET(:$item1, $item1) AND $item2 = :$item2 ORDER BY $orden ASC");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;		
	}


	static public function mdlMostrarProductosPedido2($tabla, $item1, $valor1, $item2, $valor2, $orden){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item1 = :$item1  AND $item2 = :$item2 ORDER BY $orden ASC");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlMostrarTotalPedido2($tabla, $item1, $valor1, $item2, $valor2, $item4, $item5){
		$stmt = Conexion::conectar()->prepare("SELECT SUM($item4*$item5) as totalPedido FROM $tabla WHERE  FIND_IN_SET(:$item1, $item1) AND $item2 = :$item2");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlMostrarProductosPedido3($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $orden){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE FIND_IN_SET(:$item1, $item1) AND $item2 = :$item2 AND $item3 <= $valor3/3 ORDER BY $orden ASC");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlMostrarTotalPedido($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $item4, $item5){
		$stmt = Conexion::conectar()->prepare("SELECT SUM($item4*$item5) as totalPedido FROM $tabla WHERE $item1 = :$item1 AND $item2 = :$item2");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}


	// static public function mdlMostrarTotalPedido($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $item4, $item5){
	// 	$stmt = Conexion::conectar()->prepare("SELECT SUM($item4*$item5) as totalPedido FROM $tabla WHERE $item1 = :$item1 AND $item3 <= $valor3/3 AND $item2 = :$item2");
	// 	$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
	// 	$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
	// 	$stmt -> execute();
	// 	return $stmt -> fetch();
	// 	$stmt -> close();
	// 	$stmt = null;
	// }

	static public function mdlMostrarProductosCotizacion($tabla, $item, $valor, $orden){

		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY $orden DESC");

		$stmt -> execute();

		return $stmt -> fetchAll();
			
		$stmt -> close();

		$stmt = null;

	}


	static public function mdlMostrarProductosCotizacion1($tabla, $item, $valor, $orden){

		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");
		$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

		$stmt -> execute();

		return $stmt -> fetchAll();
			
		$stmt -> close();

		$stmt = null;

	}


	/*=============================================
	SELECCIONAR UN PRODUCTO
	=============================================*/
	static public function mdlSeleccionarProducto($tabla, $item, $valor){
	
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");
		$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
		$stmt -> execute();

		return $stmt -> fetch();
		
		$stmt -> close();

		$stmt = null;

	}


	/*=============================================
	MOSTRAR PRODUCTOS MAS VENDIDOS
	=============================================*/
	static public function mdlMostrarProductosMasVendidos($tabla, $item, $valor, $motivo, $orden){

		// if($item != null && $valor > 1){

		// 	$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY $orden DESC");

		// 	$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

		// 	$stmt -> execute();

		// 	return $stmt -> fetch();

		// }else if($item != null && $valor <= 1){

		// 	$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY $orden DESC");

		// 	$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

		// 	$stmt -> execute();

		// 	return $stmt -> fetchAll();

		// }else{

			if($motivo == 'volumenVentas'){

				$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY $orden DESC");
				
			}
			else if($motivo == 'volumenIngresos'){

				$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY ($orden*precio_venta) DESC");

			}
			else if($motivo == 'volumenUtilidad'){

				$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY ($orden*precio_venta-$orden*precio_compra) DESC");

			}


			$stmt -> execute();

			return $stmt -> fetchAll();

		// }

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	MOSTRAR ABASTECIMIENTO
	=============================================*/

	static public function mdlMostrarAbastecimiento($tabla, $item, $valor, $orden, $crit1, $valorCrit1){

		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item AND $crit1 = :$crit1 ORDER BY stock ASC");

		$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

		$stmt -> bindParam(":".$crit1, $valorCrit1, PDO::PARAM_STR);

		$stmt -> execute();

		return $stmt -> fetchAll();

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	REGISTRO DE PRODUCTO
	=============================================*/
	static public function mdlIngresarProducto($tabla, $datos){
		$sucursal = $_SESSION['sucursal'];
		date_default_timezone_set("America/Santiago");
		$fechaModif = "fecha_modif_".$sucursal;
		$fecha_modif = date("Y-m-d H:i:s");

		// PARAMETRO 1 Y PARAMETRO 2, CONTEMPLA TODOS LOS LOCALES DE VENTA QUE EXISTAN Y LES AGREGA ESTADO = 1 (ACTIVO), ESTADO_STOCK = 1 (CRITICO) Y STOCK_IDEAL = PARAMETRO DEFINIDO POR EL USUARIO
		$parametro1 = '';
		$parametro2 = '';
	    $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, "local");
	    // if(count($sucursales)>1){ // SI HAY MAS DE UNA SUCURSAL SE AGREGA ESTADO_LOCALx =1, STOCK_ IDEAL A CADA SUCURSAL DE VENTA
	    foreach ($sucursales as $key => $value) {
			$parametro1 .= ", estado_".$value['nombre_sucursal'].", stock_ideal_".$value['nombre_sucursal'];
			$parametro2 .= ", :estado_".$value['nombre_sucursal'].", :stock_ideal_".$value['nombre_sucursal'];
	    }
	    // }
		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(prods_relacionados, ult_sub_cod_int, categoria, cat_nom, subcategoria, subcat_nom, proveedor, nom_prov, lista_proveedores, lista_provs_json, sub_cod_int, sku, codigo, cod_proveedor, descripcion, descripcion2, desc_sii, imagen, maneja_stock, embalaje_compra, zona_prod, precio_compra, pc_neto, precio_venta, descuento, mayor_sobre, precio_mayor, id_trab, nom_trab $parametro1, $fechaModif) VALUES (:prods_relacionados, :ult_sub_cod_int, :categoria, :cat_nom, :subcategoria, :subcat_nom, :proveedor, :nom_prov, :lista_proveedores, :lista_provs_json, :sub_cod_int, :sku, :codigo, :cod_proveedor, :descripcion, :descripcion2, :desc_sii, :imagen, :maneja_stock, :embalaje_compra, :zona_prod, :precio_compra, :pc_neto, :precio_venta, :descuento, :mayor_sobre, :precio_mayor, :id_trab, :nom_trab $parametro2, '$fecha_modif')");

		$stmt->bindParam(":ult_sub_cod_int", $datos["ult_sub_cod_int"], PDO::PARAM_INT);
		$stmt->bindParam(":prods_relacionados", $datos["prods_relacionados"], PDO::PARAM_STR);
		$stmt->bindParam(":categoria", $datos["categoria"], PDO::PARAM_INT);
		$stmt->bindParam(":cat_nom", $datos["cat_nom"], PDO::PARAM_STR);
		$stmt->bindParam(":subcategoria", $datos["subcategoria"], PDO::PARAM_INT);
		$stmt->bindParam(":subcat_nom", $datos["subcat_nom"], PDO::PARAM_STR);
		$stmt->bindParam(":proveedor", $datos["proveedor"], PDO::PARAM_INT);
		$stmt->bindParam(":lista_proveedores", $datos["lista_proveedores"], PDO::PARAM_STR);
		$stmt->bindParam(":lista_provs_json", $datos["lista_provs_json"], PDO::PARAM_STR);
		$stmt->bindParam(":nom_prov", $datos["nom_prov"], PDO::PARAM_STR);
		$stmt->bindParam(":sub_cod_int", $datos["sub_cod_int"], PDO::PARAM_STR);
		$stmt->bindParam(":sku", $datos["sku"], PDO::PARAM_STR);
		$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_STR);
		$stmt->bindParam(":cod_proveedor", $datos["cod_proveedor"], PDO::PARAM_STR);
		$stmt->bindParam(":descripcion", $datos["descripcion"], PDO::PARAM_STR);
		$stmt->bindParam(":descripcion2", $datos["descripcion2"], PDO::PARAM_STR);
		$stmt->bindParam(":desc_sii", $datos["desc_sii"], PDO::PARAM_STR);
		$stmt->bindParam(":imagen", $datos["imagen"], PDO::PARAM_STR);
		$stmt->bindParam(":maneja_stock", $datos["maneja_stock"], PDO::PARAM_STR);
		$stmt->bindParam(":embalaje_compra", $datos["embalaje_compra"], PDO::PARAM_STR);
		$stmt->bindParam(":zona_prod", $datos["zona_prod"], PDO::PARAM_STR);
		$stmt->bindParam(":precio_compra", $datos["precio_compra"], PDO::PARAM_STR);
		$stmt->bindParam(":pc_neto", $datos["pc_neto"], PDO::PARAM_STR);
		$stmt->bindParam(":precio_venta", $datos["precio_venta"], PDO::PARAM_STR);
		$stmt->bindParam(":descuento", $datos["descuento"], PDO::PARAM_STR);
		$stmt->bindParam(":mayor_sobre", $datos["mayor_sobre"], PDO::PARAM_STR);
		$stmt->bindParam(":precio_mayor", $datos["precio_mayor"], PDO::PARAM_STR);
		$stmt->bindParam(":id_trab", $datos["id_trab"], PDO::PARAM_STR);
		$stmt->bindParam(":nom_trab", $datos["nom_trab"], PDO::PARAM_STR);
		// $stmt->bindParam(":propietario", $datos["propietario"], PDO::PARAM_STR);
		// $stmt->bindParam(":estado_local1", $datos["estado_local1"], PDO::PARAM_STR);
		// $stmt->bindParam(":stock_ideal_local1", $datos["stock_ideal_local1"], PDO::PARAM_STR);

	    foreach ($sucursales as $key => $value) {
			$stmt->bindParam(":estado_".$value['nombre_sucursal'], $datos["estado_local1"], PDO::PARAM_INT); // SE COPIA EL ESTADO EN LOCAL1, PQ ES UN PRODUCTO NUEVO Y SE SETEA DE LA MISMA MANERA EN TODOS LOS LOCALES
			$stmt->bindParam(":stock_ideal_".$value['nombre_sucursal'], $datos["stock_ideal_local1"], PDO::PARAM_INT); // SE COPIA EL STOCK_IDEAL EN LOCAL1, PQ ES UN PRODUCTO NUEVO Y SE SETEA DE LA MISMA MANERA EN TODOS LOS LOCALES
	    }

		if($stmt->execute()){
			// INGRESO ACTIVIDAD
			$ultimoId = ModeloProductos::mdlSeleccionarUltimoIdProducto()['id'];
			$ultimoRegistro = ModeloProductos::mdlSeleccionarUltimoIdRegistro();
			$actividadInventario = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'stkInicio', 0, '', $ultimoId, $_SESSION['id'], $_SESSION['nombre']);
			return "ok///".$ultimoId;
		}else{

			return "error";
		
		}

		$stmt->close();
		$stmt = null;

	}
	/*=============================================
	SELECCIONAR ULTIMO_ID_REGISTRO
	=============================================*/
	static public function mdlSeleccionarUltimoIdProducto(){
		$stmt = Conexion::conectar()->prepare("SELECT MAX(id) AS id FROM productos");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}


	/*=============================================
	EDITAR PRODUCTO
	=============================================*/
	static public function mdlEditarProducto($tabla, $datos){
		$sucursal = $_SESSION['sucursal'];
		if($_SESSION['perfil'] == 'Administrador'){
			$stockIdeal = "stock_ideal_".$sucursal;

			$zona = "zona_".$sucursal;
			$fechaModif = "fecha_modif_".$sucursal;
			$stockIdeal2 = ":stock_ideal_".$sucursal;
			$zona2 = ":zona_".$sucursal;
			date_default_timezone_set("America/Santiago");
			$fecha_modif = date("Y-m-d H:i:s");

			$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET descripcion = :descripcion, descripcion2 = :descripcion2, desc_sii = :desc_sii, cod_proveedor = :cod_proveedor, proveedor = :proveedor, nom_prov = :nom_prov, id_trab = :id_trab, nom_trab = :nom_trab, maneja_stock = :maneja_stock, embalaje_compra = :embalaje_compra, zona_prod = :zona_prod, $stockIdeal = $stockIdeal2, descuento = :descuento, precio_compra = :precio_compra, pc_neto = :pc_neto, precio_venta = :precio_venta, mayor_sobre = :mayor_sobre, precio_mayor = :precio_mayor, imagen = :imagen, $zona = $zona2, $fechaModif = '$fecha_modif' WHERE id = :codigo");
			

			$stmt->bindParam(":descripcion", $datos["descripcion"], PDO::PARAM_STR);
			$stmt->bindParam(":descripcion2", $datos["descripcion2"], PDO::PARAM_STR);
			$stmt->bindParam(":desc_sii", $datos["desc_sii"], PDO::PARAM_STR);
			$stmt->bindParam(":cod_proveedor", $datos["cod_proveedor"], PDO::PARAM_STR);
			$stmt->bindParam(":proveedor", $datos["proveedor"], PDO::PARAM_INT);
			$stmt->bindParam(":nom_prov", $datos["nom_prov"], PDO::PARAM_STR);
			$stmt->bindParam(":id_trab", $datos["id_trab"], PDO::PARAM_INT);
			$stmt->bindParam(":nom_trab", $datos["nom_trab"], PDO::PARAM_STR);
			$stmt->bindParam(":maneja_stock", $datos["maneja_stock"], PDO::PARAM_STR);
			$stmt->bindParam(":embalaje_compra", $datos["embalaje_compra"], PDO::PARAM_INT);
			$stmt->bindParam(":zona_prod", $datos["zona_prod"], PDO::PARAM_STR);
			$stmt->bindParam(":stock_ideal_".$sucursal, $datos["stock_ideal_".$sucursal], PDO::PARAM_INT);
			$stmt->bindParam(":descuento", $datos["descuento"], PDO::PARAM_INT);
			$stmt->bindParam(":precio_compra", $datos["precio_compra"], PDO::PARAM_INT);
			$stmt->bindParam(":pc_neto", $datos["pc_neto"], PDO::PARAM_INT);
			$stmt->bindParam(":precio_venta", $datos["precio_venta"], PDO::PARAM_INT);
			$stmt->bindParam(":mayor_sobre", $datos["mayor_sobre"], PDO::PARAM_INT);
			$stmt->bindParam(":precio_mayor", $datos["precio_mayor"], PDO::PARAM_INT);
			$stmt->bindParam(":imagen", $datos["imagen"], PDO::PARAM_STR);
			$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_STR);
			$stmt->bindParam(":zona_".$sucursal, $datos["zona_".$sucursal], PDO::PARAM_STR);

		}else if($_SESSION['perfil'] == 'Vendedor'){
			$zona = "zona_".$sucursal;
			$fechaModif = "fecha_modif_".$sucursal;
			$zona2 = ":zona_".$sucursal;
			$fechaModif2 = "fecha_modif_".$sucursal;

			$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET descripcion2 = :descripcion2, imagen = :imagen, $zona = $zona2, $fechaModif = $fechaModif2 WHERE codigo = :codigo");
			
			$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_STR);
			$stmt->bindParam(":descripcion2", $datos["descripcion2"], PDO::PARAM_STR);
			$stmt->bindParam(":imagen", $datos["imagen"], PDO::PARAM_STR);
			$stmt->bindParam(":zona_".$sucursal, $datos["zona_".$sucursal], PDO::PARAM_STR);
			$stmt->bindParam(":fecha_modif_".$sucursal, $datos["fecha_modif_".$sucursal], PDO::PARAM_STR);

		}


		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt->close();
		$stmt = null;

	}

	/*=============================================
	BORRAR PRODUCTO
	=============================================*/

	static public function mdlEliminarProducto($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE id = :id");

		$stmt -> bindParam(":id", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}


	/*=============================================
	BORRAR PRODUCTO AJAX
	=============================================*/

	static public function mdlEliminarProductoFaltante($item, $valor, $tabla){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE id = :id");

		$stmt -> bindParam(":id", $valor, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}



	/*=============================================
	ACTUALIZAR PRODUCTO
	=============================================*/

	static public function mdlActualizarProducto($tabla, $item1, $valor1, $valor){
		// if($tabla=='productos' || $tabla=='ventas'){
		// 	$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE id = :id");
		// }else if($tabla=='actividad_inventario'){
		// 	$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE id_registro = :id");			
		// }
		if($tabla == 'actividad_inventario'){
			$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE id_registro = :id");			
		}else{
			$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE id = :id");
		}

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":id", $valor, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	ACTUALIZAR SALDO PRODUCTOS RETIRO
	=============================================*/
	static public function mdlActualizarSaldoProductoRetiro($tabla, $saldo, $idRetiro){
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET saldo = $saldo WHERE id = $idRetiro");
		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}


	/*=============================================
	ACTUALIZAR PRECIO DE COMPRA
	=============================================*/
	static public function mdlActualizarPrecioCompra($tabla, $datos){
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET stock_precio_nuevo = :stock_precio_nuevo, nuevo_precio_compra = :nuevo_precio_compra WHERE id = :id");

		$stmt->bindParam(":stock_precio_nuevo", $datos["stock_precio_nuevo"], PDO::PARAM_STR);
		$stmt->bindParam(":nuevo_precio_compra", $datos["nuevo_precio_compra"], PDO::PARAM_STR);
		$stmt->bindParam(":id", $datos["id"], PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	MOSTRAR SUMA VENTAS
	=============================================*/	
	static public function mdlMostrarSumaVentas($tabla, $columnaSuma){
		$stmt = Conexion::conectar()->prepare("SELECT SUM($columnaSuma) as total FROM $tabla");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	SUMAR PRODUCTOS RETIRADOS
	=============================================*/	

	static public function mdlSumarProductosRetirados($tabla, $idRetiro){
		$stmt = Conexion::conectar()->prepare("SELECT SUM(retirado) as total_retirado FROM $tabla WHERE id_asociado = $idRetiro");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	ACTUALIZAR 1
	=============================================*/
	static public function mdlActualizar1($tabla, $item1, $valor1, $item2, $valor2){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE $item2 = :$item2");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok,".$valor1;
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	RESET STOCK COMPRA PROVEEDOR
	=============================================*/
	static public function mdlResetStockCompraProveedor($tabla, $item1, $valor1, $item2, $valor2){
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE FIND_IN_SET(:$item2, $item2)");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		if($stmt -> execute()){
			return "ok";
		}else{
			return "error";	
		}
		$stmt -> close();
		$stmt = null;
	}



	/*=============================================
	ACTUALIZAR 1_2 (1 item con 2 coincidencias)
	=============================================*/
	static public function mdlActualizar1_2($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE $item2 = :$item2 AND $item3 = :$item3");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item3, $valor3, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	ACTUALIZAR 1_0 (1 item sin coincidencias0)
	=============================================*/
	static public function mdlActualizar1_0($tabla, $item1, $valor1){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}


	/*=============================================
	ACTUALIZAR 2
	=============================================*/
	static public function mdlActualizar2($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1, $item2 = :$item2 WHERE $item3 = :$item3");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item3, $valor3, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok,".$valor1.",".$valor2.",".$valor3;
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	ACTUALIZAR 3
	=============================================*/
	static public function mdlConfigProdTransformable($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $item4, $valor4){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1, $item2 = :$item2, $item3 = :$item3 WHERE $item4 = :$item4");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item3, $valor3, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item4, $valor4, PDO::PARAM_STR);

		if($stmt -> execute()){
			$productoBase = ModeloProductos::mdlMostrarProducto('productos', 'id', $valor4);
			$productoSurtido = ModeloProductos::mdlMostrarProducto('productos', 'id', $valor3);
			$img = $productoSurtido['imagen'];
			$nomBase = $productoBase['descripcion'];
			$nomProdSurtido = $productoSurtido['descripcion'];
			return "ok,".$img.",".$nomBase.",".$nomProdSurtido.",".$valor2;
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	AGREGAR PRODUCTOS AJAX
	=============================================*/
	static public function mdlAgregarProdAjax($tabla, $datos){
		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(descripcion, id_trab, nom_trab, proveedor, nom_prov, categoria, cat_nom, subcategoria, subcat_nom, ubicacion, sub_cod_int, ult_sub_cod_int, cod_int_sin_zona, codigo, cod_proveedor, imagen) VALUES (:descripcion, :id_trab, :nom_trab, :proveedor, :nom_prov, :categoria, :cat_nom, :subcategoria, :subcat_nom, :ubicacion, :sub_cod_int, :ult_sub_cod_int, :cod_int_sin_zona, :codigo, :cod_proveedor, :imagen)");

		$stmt->bindParam(":descripcion", $datos["descripcion"], PDO::PARAM_STR);
		$stmt->bindParam(":id_trab", $datos["id_trab"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_trab", $datos["nom_trab"], PDO::PARAM_STR);
		$stmt->bindParam(":proveedor", $datos["proveedor"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_prov", $datos["nom_prov"], PDO::PARAM_STR);
		$stmt->bindParam(":categoria", $datos["categoria"], PDO::PARAM_INT);
		$stmt->bindParam(":cat_nom", $datos["cat_nom"], PDO::PARAM_STR);
		$stmt->bindParam(":subcategoria", $datos["subcategoria"], PDO::PARAM_INT);
		$stmt->bindParam(":subcat_nom", $datos["subcat_nom"], PDO::PARAM_INT);
		$stmt->bindParam(":ubicacion", $datos["zona_local1"], PDO::PARAM_INT);
		$stmt->bindParam(":sub_cod_int", $datos["sub_cod_int"], PDO::PARAM_STR);
		$stmt->bindParam(":ult_sub_cod_int", $datos["ult_sub_cod_int"], PDO::PARAM_STR);
		$stmt->bindParam(":cod_int_sin_zona", $datos["sku"], PDO::PARAM_STR);
		$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_STR);
		$stmt->bindParam(":cod_proveedor", $datos["cod_proveedor"], PDO::PARAM_STR);
		$stmt->bindParam(":imagen", $datos["imagen"], PDO::PARAM_STR);
		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt->close();
		$stmt = null;

	}



	// /*=============================================
	// ACTUALIZAR 4
	// =============================================*/
	// static public function mdlActualizar4($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $item4, $valor4, $item5, $valor5){

	// 	$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1, $item2 = :$item2, $item3 = :$item3, $item4 = :$item4 WHERE $item5 = :$item5");

	// 	$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
	// 	$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
	// 	$stmt -> bindParam(":".$item3, $valor3, PDO::PARAM_STR);
	// 	$stmt -> bindParam(":".$item4, $valor4, PDO::PARAM_STR);
	// 	$stmt -> bindParam(":".$item5, $valor5, PDO::PARAM_STR);

	// 	if($stmt -> execute()){

	// 		return "ok";
		
	// 	}else{

	// 		return "error";	

	// 	}

	// 	$stmt -> close();

	// 	$stmt = null;

	// }


}