<?php

require_once "conexion.php";

class ModeloMovimientos{

	/*=============================================
	MODIF 2 ITEMS MOVIMIENTO
	=============================================*/
	static public function mdlActualizar2($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3){
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1, $item2 = :$item2 WHERE $item3 = :$item3");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item3, $valor3, PDO::PARAM_STR);
		if($stmt -> execute()){
			return "ok,".$valor1.",".$valor2.",".$valor3;
		}else{
			return "error";	
		}
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MODIF 2 ITEMS MOVIMIENTO
	=============================================*/
	static public function mdlActualizar3($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $item4, $valor4){
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1, $item2 = :$item2, $item3 = :$item3 WHERE $item4 = :$item4");
		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item3, $valor3, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item4, $valor4, PDO::PARAM_STR);
		if($stmt -> execute()){
			return "ok,".$valor1.",".$valor2.",".$valor3.",".$valor4;
		}else{
			return "error";	
		}
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	ELIMINAR MOVIMIENTO
	=============================================*/
	static public function mdlEliminarMov($tabla, $datos){
		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE id = :id");
		$stmt -> bindParam(":id", $datos, PDO::PARAM_INT);
		if($stmt -> execute()){
			return "ok";
		}else{
			return "error";	
		}
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR SALDOS HACE 3 MESES
	=============================================*/
	static public function mdlMostrarSaldos($tabla, $fechaInicial){
		$stmt = Conexion::conectar()->prepare("SELECT detalle,fecha_cont FROM `movimientos` WHERE tipo_mov = 'saldo' AND detalle not LIKE '%[{\"bodega\":\"10000\"%' AND detalle != '-' AND fecha_cont >= '$fechaInicial' ORDER BY id ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR 30 ULTIMOS DIAS DE VENTAS
	=============================================*/
	static public function mdlMostrarMovimientos30($tabla, $item, $fechaInicial, $hoy){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item BETWEEN '$fechaInicial' AND '$hoy'");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR MOVIMIENTOS HOY
	=============================================*/
	static public function mdlMostrarMovimientosHoy($tabla, $item, $fecha){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = '$fecha'");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}
	
	/*=============================================
	TODOS LOS MOVIMIENTOS CREDITO INTERNO CLIENTE
	=============================================*/
	static public function mdlHistorialCredIntCliente($id, $orden){
		$stmt = Conexion::conectar()->prepare("SELECT `fecha_venta`,`fecha_cont`,`estado`,`tipo_pago`,`id`,`cod_venta`,`total` FROM `ventas` WHERE `id_cliente` = $id AND `estado` != 0 AND `tipo_pago` = 'Fiado' UNION SELECT `fecha`,`fecha_cont`,`tipo_mov`,`moneda`,`id`,`id`,`abono` FROM `movimientos` WHERE `id_client` = $id AND `abono` != 0 UNION SELECT `fecha`,`fecha_cont`,`tipo_mov`,`moneda`,`id`,`id`,`cargo` FROM `movimientos` WHERE `id_client` = $id AND `cargo` != 0 ORDER BY `fecha_cont` ASC, `fecha_venta` ASC");
			// PRIMERO BUSCA VENTAS CON CREDITO INTERNO (FIADO)
			// SEGUNDO BUSCA ABONOS
			// TERCERO BUSCA CARGOS (EGRESOS)
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR MOVIMIENTOS
	=============================================*/
	static public function mdlMostrarMovimientos($tabla, $item, $valor, $orden, $ventana){
		if($ventana == 'movimientos-all'){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY $orden DESC");
		}else if($ventana == 'movimientos-all-movil'){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY $orden DESC");
		}else if($ventana == 'cierre-dia'){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item like '%$valor%' ORDER BY $orden ASC");
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item like '%$valor%' ORDER BY $orden DESC");
		}
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	//=============================================
	// MOSTRAR ULTIMO SALDO
	//=============================================
	static public function mdlUltimoItem($tabla, $item, $valor, $orden){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = '$valor' ORDER by $orden DESC LIMIT 1");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	//=============================================
	// MOSTRAR SALDO ANTERIOR
	//=============================================
	static public function mdlSaldoAnterior($tabla, $item1, $valor1, $item2, $valor2, $orden){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item1 = '$valor1' AND $item2 < '$valor2' ORDER by $orden DESC LIMIT 1");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	// MOSTRAR SALDO ANTERIOR
	static public function mdlSegundoSaldoAnterior($tabla, $item, $valor, $orden){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = '$valor' ORDER by $orden DESC LIMIT 1,1");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	// MOSTRAR CON 2 COINCIDENCIAS
	static public function mdlMovSi2LI($tabla, $item1, $valor1, $item2, $valor2){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item1 LIKE '%$valor1%' AND $item2 = '$valor2'");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	// MOSTRAR CON 2 COINCIDENCIAS
	static public function mdlMovSi2LI1($tabla, $item1, $valor1, $item2, $valor2){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item1 LIKE '%$valor1%' AND $item2 = '$valor2'");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	SUMAR TOTAL DEL DIA
	=============================================*/
	static public function mdlMovimientosDia($tabla, $item1, $valor1){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item1 = :$item1");
		$stmt->bindParam(":$item1", $valor1, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}	

	/*=============================================
	SUMAR TOTAL DEL DIA
	=============================================*/
	static public function mdlSumaOtrosCargosReporte($fecha_cont){
		$stmt = Conexion::conectar()->prepare("SELECT SUM(`cargo`) as total FROM `movimientos` WHERE `tipo_mov` != 'pagProv' and `tipo_mov` != 'pagTrab' and `tipo_mov` != 'retCfGde' and `tipo_mov` != 'prestTerc' and `fecha_cont` = '$fecha_cont'");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}	

	/*=============================================
	SUMAR 2 CONDICIONES
	=============================================*/
	static public function mdlSumaSi2LI($tabla, $item1, $valor1, $item2, $valor2, $sumar){
		$stmt = Conexion::conectar()->prepare("SELECT SUM($sumar) as total FROM $tabla where $item1 like '%$valor1%' and $item2 = '$valor2'");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}	
	
	/*=============================================
	SUMAR 3 CONDICIONES
	=============================================*/
	static public function mdlSumaSi3DLI($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $sumar){
		$stmt = Conexion::conectar()->prepare("SELECT SUM($sumar) as total FROM $tabla where $item1 != '$valor1' and $item2 like '%$valor2%' and $item3 = '$valor3'");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}	




	/*=============================================
	REGISTRAR INGRESO DINERO
	=============================================*/
	static public function mdlRegistrarMovimiento($tabla, $datos){

		$sucursal = $_SESSION['sucursal'];
		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(fecha, fecha_cont, tipo_mov, id_prov, nom_prov, id_socio, nom_socio, id_empleado, nom_empleado, detalle, nro_fact, user, nom_user, sucursal, cargo, abono, moneda, id_client, nom_client, id_distrib, nom_distrib, saldo, saldo_ant) VALUES (:fecha, :fecha_cont, :tipo_mov, :id_prov, :nom_prov, :id_socio, :nom_socio, :id_empleado, :nom_empleado, :detalle, :nro_fact, :user, :nom_user, '$sucursal', :cargo, :abono, :moneda, :id_client, :nom_client, :id_distrib, :nom_distrib, :saldo, :saldo_ant)");
		$stmt->bindParam(":fecha", $datos["fecha"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_cont", $datos["fecha_cont"], PDO::PARAM_STR);
		$stmt->bindParam(":tipo_mov", $datos["tipo_mov"], PDO::PARAM_STR);
		$stmt->bindParam(":id_prov", $datos["id_prov"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_prov", $datos["nom_prov"], PDO::PARAM_STR);
		$stmt->bindParam(":id_socio", $datos["id_socio"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_socio", $datos["nom_socio"], PDO::PARAM_STR);
		$stmt->bindParam(":id_empleado", $datos["id_empleado"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_empleado", $datos["nom_empleado"], PDO::PARAM_STR);
		$stmt->bindParam(":detalle", $datos["detalle"], PDO::PARAM_STR);
		$stmt->bindParam(":nro_fact", $datos["nro_fact"], PDO::PARAM_STR);
		$stmt->bindParam(":user", $datos["user"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_user", $datos["nom_user"], PDO::PARAM_STR);
		$stmt->bindParam(":cargo", $datos["cargo"], PDO::PARAM_INT);
		$stmt->bindParam(":abono", $datos["abono"], PDO::PARAM_INT);
		$stmt->bindParam(":moneda", $datos["moneda"], PDO::PARAM_STR);
		$stmt->bindParam(":id_client", $datos["id_client"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_client", $datos["nom_client"], PDO::PARAM_STR);
		$stmt->bindParam(":id_distrib", $datos["id_distrib"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_distrib", $datos["nom_distrib"], PDO::PARAM_STR);
		$stmt->bindParam(":saldo", $datos["saldo"], PDO::PARAM_INT);
		$stmt->bindParam(":saldo_ant", $datos["saldo_ant"], PDO::PARAM_INT);
		
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}
		$stmt->close();
		$stmt = null;

	}

	// /*=============================================
	// REGISTRAR EGRESO DINERO
	// =============================================*/
	// static public function mdlEgresosCaja($tabla, $datos){
		
	// 	$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(fecha, det_mov, user, nom_user, cargo, abono, met_pago_mov, id_client, nom_client, saldo, saldo_ant) VALUES (:fecha, :det_mov, :user, :nom_user, :cargo, :abono, :met_pago_mov, :id_client, :nom_client, :saldo, :saldo_ant)");
	// 	$stmt->bindParam(":fecha", $datos["fecha"], PDO::PARAM_STR);
	// 	$stmt->bindParam(":det_mov", $datos["det_mov"], PDO::PARAM_STR);
	// 	$stmt->bindParam(":user", $datos["user"], PDO::PARAM_INT);
	// 	$stmt->bindParam(":nom_user", $datos["nom_user"], PDO::PARAM_STR);
	// 	$stmt->bindParam(":cargo", $datos["cargo"], PDO::PARAM_INT);
	// 	$stmt->bindParam(":abono", $datos["abono"], PDO::PARAM_INT);
	// 	$stmt->bindParam(":met_pago_mov", $datos["met_pago_mov"], PDO::PARAM_STR);
	// 	$stmt->bindParam(":id_client", $datos["id_client"], PDO::PARAM_INT);
	// 	$stmt->bindParam(":nom_client", $datos["nom_client"], PDO::PARAM_STR);
	// 	$stmt->bindParam(":saldo", $datos["saldo"], PDO::PARAM_INT);
	// 	$stmt->bindParam(":saldo_ant", $datos["saldo_ant"], PDO::PARAM_INT);
	// 	if($stmt->execute()){
	// 		return "ok";
	// 	}else{
	// 		return "error";
	// 	}
	// 	$stmt->close();
	// 	$stmt = null;

	// }


// 

}

