<?php
session_start();
if (!isset($_SESSION['id'])) {
    header("Location: ../../../inicio");
    exit();
}


require_once "../../../controladores/ventas.controlador.php";
require_once "../../../modelos/ventas.modelo.php";
require_once "../../../controladores/clientes.controlador.php";
require_once "../../../modelos/clientes.modelo.php";
require_once "../../../controladores/movimientos.controlador.php";
require_once "../../../modelos/movimientos.modelo.php";
require_once "../../../controladores/usuarios.controlador.php";
require_once "../../../modelos/usuarios.modelo.php";
require_once "../../../controladores/ajustes.controlador.php";
require_once "../../../modelos/ajustes.modelo.php";

require_once('../tcpdf.php');
require_once('../../fpdi/autoload.php');

use setasign\Fpdi\Tcpdf\Fpdi;

class historialCliente{

	public function mostrarHistorial(){

		$item = 'id';
		$valor = $_GET['id'];
		$cliente = ControladorClientes::ctrMostrarClientes($item, $valor);
		$apellidos = explode(" ", $cliente["apellido"]);
		$nombres = explode(" ", $cliente["nombre"]);
		$nombre = strtoupper($nombres[0].' '.$apellidos[0].' ('.$cliente["referencia"].')');
		$orden = 'ASC';
		$movimientosCredito = ModeloMovimientos::mdlHistorialCredIntCliente($valor, $orden);

		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->setFooterData(array(0,64,0), array(0,64,128));
		$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
		// $pdf->SetFooterMargin(PDF_MARGIN_FOOTER); // HOJAS


		$pdf = new Fpdi();

		$pdf->setPrintHeader(false);
		$pdf->SetTitle('RESUMEN CON FACTURAS');


		$pdf->startPageGroup();
		$pdf->AddPage();


		/*=============================================
		                 TITULO
		=============================================*/
		$pdf->SetLink($pdf->AddLink());
		$pdf->SetDestination("inicio");


		$fechaHora = ControladorAjustes::ctrFechaHora();


		$bloque0 = '<table>
						<tr>
							<td style="width:20px; border-bottom: 0.5px solid #000000;"></td>
							<td style="width:70px; border-bottom: 0.5px solid #000000;"><img src="'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"></td>
							<td style="width:20px; border-bottom: 0.5px solid #000000;"></td>
							<td style="background-color:white; width:430px; border-bottom: 0.5px solid #000000;">
								<div style="font-size:11px; text-align:left; line-height:15px;">
									ESTADO DE CUENTA RESUMIDO (VENTAS y FACTURAS)<br>
									<b>'.$nombre.'</b>                                                 <font size="-3">'.date('d/m/Y H:i:s', strtotime($fechaHora)).'</font>
								</div>
							</td>
						</tr>
					</table>
					<br><br>';

		$pdf->writeHTML($bloque0, false, false, false, false, '');

		/*=============================================
		                 CABECERA           
		=============================================*/
		$bloque1 =
			'<br>
			<table style="font-size:8px; padding:5px 2px;">
				<tr>
					<td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center"><b>#</b></td>		
					<td style="border: 0.5px solid #000000; background-color:white; width:55px; text-align:center"><b>FECHA</b></td>		
					<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center"><b>MOVIMIENTO</b></td>
					<td style="border: 0.5px solid #000000; background-color:white; width:90px; text-align:center"><b>MONEDA</b></td>
					<td style="border: 0.5px solid #000000; background-color:white; width:70px; text-align:center"><b>TRANSACCION</b></td>
					<td style="border: 0.5px solid #000000; background-color:white; width:60px; text-align:center"><b>FACTURA</b></td>
					<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center"><b>MONTO ($)</b></td>
					<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center"><b>SALDO ($)</b></td>
				</tr>
			</table><br>';

		$pdf->writeHTML($bloque1, false, false, false, false, '');		
			
		$tabla = '';
		$saldoAntiguo = 0;
		$nro = 0;
		$idsVentas = [];

		// MOVIMIENTOA
		if(count($movimientosCredito)<=25){ // si hay menos de 25 movs

			$saldo = 0;
			foreach($movimientosCredito as $key => $value) {

				$fecha = date("d/m/Y", strtotime($value['fecha_cont']));
				if($value['estado']=='abClient'){
					$tipo_mov = 'ABONO';
					$saldo -= $value['total'];
					$color = 'color:blue';
				}else if($value['estado']=='dctoClient'){
					$tipo_mov = 'DESCUENTO';
					$saldo -= $value['total'];
					$color = 'color:blue';
				}else if($value['estado']=='anticipoClient'){
					$tipo_mov = 'ANTICIPO';	
					$saldo -= $value['total'];
					$color = 'color:green';
				}else if($value['estado']=='abPrest'){
					$tipo_mov = 'AB. PRÉSTAMO';	
					$saldo -= $value['total'];
					$color = 'color:green';
				}else if($value['estado']=='prestTerc'){
					$tipo_mov = 'PRÉSTAMO';	
					$saldo += $value['total'];
					$color = 'color:purple';
				}else if($value['estado']=='devClient'){
					$tipo_mov = 'DEVOLUCIÓN';	
					$saldo += $value['total'];
					$color = 'color:black';
				}else{
					$nro = $nro+1;
					$tipo_mov = 'COMPRA';	
					$saldo += $value['total'];
					$color = 'color:red';
					array_push($idsVentas, $value['id']);
				}

				$saldoMostrar = number_format($saldo,0,',','.');
				$total = number_format($value['total'],0,',','.');

				if($value['tipo_pago']=='ef'){
					$moneda = 'EFECTIVO';
				}else if($value['tipo_pago']=='transf'){
					$moneda = 'TRANSFERENCIA';	
				}else if($value['tipo_pago']=='td'){
					$moneda = 'T. DÉBITO';	
				}else if($value['tipo_pago']=='tc'){
					$moneda = 'T. CRÉDITO';	
				}else if($value['tipo_pago']=='dcto'){
					$moneda = 'DESCUENTO';	
				}else{
					$moneda = 'CRÉDITO INTERNO';		
				}

				if($value['estado']!='abClient' && $value['estado']!='dctoClient' && $value['estado']!='anticipoClient' && $value['estado']!='abPrest' && $value['estado']!='prestTerc' && $value['estado']!='devClient'){
					$nroTransaccion = '<a href="#pdfVenta'.$nro.'">'.$value['cod_venta'].'</a>';
				}else{
					$nroTransaccion = $value['cod_venta'];
				}

				$datosVenta = ControladorVentas::ctrMostrarVentas('id', $value['id'], '=', '!=', 0, 'fecha_cont', 'DESC');
				
				$facturasVenta = $datosVenta['nro_factura'] == null ? '' : explode(',', $datosVenta['nro_factura']);
				$cantFacturasVentas = $datosVenta['nro_factura'] == null ? 0 : count($facturasVenta);

				$listaFacts = '';
				for ($i=0; $i < $cantFacturasVentas; $i++) { 
					if($i==0){
						$listaFacts .= $facturasVenta[$i];
					}else{
						$listaFacts .= '<br>'.$facturasVenta[$i];
					}
					$facts = '<a href="#Fact'.$nro.'">'.$listaFacts.'</a>';
				}

				$facturasAsociadas = $datosVenta['nro_factura'] != '' ? $facts : '-';

				$tabla .= 
					'<table style="font-size:8px; padding:4px 2px;">
						<tr>
							<td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center; '.$color.'">'.$nro.'</td>
							<td style="border: 0.5px solid #000000; background-color:white; width:55px; text-align:center; '.$color.'">'.$fecha.'</td>
							<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; '.$color.'">'.$tipo_mov.'</td>
							<td style="border: 0.5px solid #000000; background-color:white; width:90px; text-align:center; '.$color.'">'.$moneda.'</td>
							<td style="border: 0.5px solid #000000; background-color:white; width:70px; text-align:center; '.$color.'">'.$nroTransaccion.'</td>
							<td style="border: 0.5px solid #000000; background-color:white; width:60px; text-align:center; '.$color.'">'.$facturasAsociadas.'</td>
							<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; '.$color.'">'.$total.'</td>
							<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; '.$color.'">'.$saldoMostrar.'</td>
						</tr>
					</table>';

			}

		}else{ // si hay mas de 25 movs


			foreach ($movimientosCredito as $key => $value) {
				if($key<count($movimientosCredito)-25){	// SALDO ANTES DE LOS ULTIMOS 30 MOVIMIENTO 
					if($value['estado']=='abClient'){
						$saldoAntiguo -= $value['total'];
					}else if($value['estado']=='dctoClient'){
						$saldoAntiguo -= $value['total'];
					}else if($value['estado']=='anticipoClient'){
						$saldoAntiguo -= $value['total'];
					}else if($value['estado']=='abPrest'){
						$saldoAntiguo -= $value['total'];
					}else if($value['estado']=='prestTerc'){
						$saldoAntiguo += $value['total'];
					}else if($value['estado']=='devClient'){
						$saldoAntiguo += $value['total'];
					}else{ // VENTA
						$saldoAntiguo += $value['total'];
					}
				}
			}


			$saldoMostrar = number_format($saldoAntiguo,0,',','.');
			$fechaSaldoAntiguo =  date("d/m/Y", strtotime($movimientosCredito[count($movimientosCredito)-25-1]['fecha_cont']));
			$fecha = date("d/m/Y", strtotime($value['fecha_cont']));

			// PRIMERA FILA CON EL SALDO ANTERIOR A LOS SIGUIENTES 25 MOVIMIENTOS
			$tabla .=  '<table style="font-size:8px; padding:5px 2px;">
							<tr>
								<td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center;">-</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:55px; text-align:center;">'.$fechaSaldoAntiguo.'</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center;">SALDO ANTERIOR</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:90px; text-align:center;">SALDO</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:70px; text-align:center;">-</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:60px; text-align:center;">-</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center;">-</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center;">'.$saldoMostrar.'</td>
							</tr>
						</table>';

			// LOS SIGUIENTES MOVIMIENTOS
			$nro = 0;
			$saldo = $saldoAntiguo;
			foreach($movimientosCredito as $key => $value) {
				if($key>=count($movimientosCredito)-25){	// SALDO ANTES DE LOS ULTIMOS 30 MOVIMIENTO 
					$fecha = date("d/m/Y", strtotime($value['fecha_cont']));
					if($value['estado']=='abClient'){
						$tipo_mov = 'ABONO';
						$saldo -= $value['total'];
						$color = 'color:blue';
					}else if($value['estado']=='dctoClient'){
						$tipo_mov = 'DESCUENTO';
						$saldo -= $value['total'];
						$color = 'color:blue';
					}else if($value['estado']=='anticipoClient'){
						$tipo_mov = 'ANTICIPO';	
						$saldo -= $value['total'];
						$color = 'color:green';
					}else if($value['estado']=='abPrest'){
						$tipo_mov = 'AB. PRÉSTAMO';	
						$saldo -= $value['total'];
						$color = 'color:green';
					}else if($value['estado']=='prestTerc'){
						$tipo_mov = 'PRÉSTAMO';	
						$saldo += $value['total'];
						$color = 'color:purple';
					}else if($value['estado']=='devClient'){
						$tipo_mov = 'DEVOLUCIÓN';	
						$saldo += $value['total'];
						$color = 'color:black';
					}else{
						$nro = $nro+1;
						$tipo_mov = 'COMPRA';	
						$saldo += $value['total'];
						$color = 'color:red';
						array_push($idsVentas, $value['id']);
					}
					$saldoMostrar = number_format($saldo,0,',','.');
					$total = number_format($value['total'],0,',','.');

					if($value['tipo_pago']=='ef'){
						$moneda = 'EFECTIVO';
					}else if($value['tipo_pago']=='transf'){
						$moneda = 'TRANSFERENCIA';	
					}else if($value['tipo_pago']=='td'){
						$moneda = 'T. DÉBITO';	
					}else if($value['tipo_pago']=='tc'){
						$moneda = 'T. CRÉDITO';	
					}else if($value['tipo_pago']=='dcto'){
						$moneda = 'DESCUENTO';	
					}else{
						$moneda = 'CRÉDITO INTERNO';		
					}


					// if($saldo == 0){
					// 	$tabla = '';
					// 	$nro = 0;
					// 	$idsVentas = [];
					// }else{
						if($value['estado']!='abClient' && $value['estado']!='dctoClient' && $value['estado']!='anticipoClient' && $value['estado']!='abPrest' && $value['estado']!='prestTerc' && $value['estado']!='devClient'){
							$nroTransaccion = '<a href="#pdfVenta'.$nro.'">'.$value['cod_venta'].'</a>';
						}else{
							$nroTransaccion = $value['cod_venta'];
						}

						$datosVenta = ControladorVentas::ctrMostrarVentas('id', $value['id'], '=', '!=', 0, 'fecha_cont', 'DESC');
						
						$facturasVenta = explode(',', $datosVenta['nro_factura'] ?? '');
						$cantFacturasVentas = count($facturasVenta);

						$listaFacts = '';
						for ($i=0; $i < $cantFacturasVentas; $i++) { 
							if($i==0){
								$listaFacts .= $facturasVenta[$i];
							}else{
								$listaFacts .= '<br>'.$facturasVenta[$i];
							}
							$facts = '<a href="#Fact'.$nro.'">'.$listaFacts.'</a>';
						}

						$facturasAsociadas = $datosVenta['nro_factura'] != '' ? $facts : '-';

						$tabla .= 
							'<table style="font-size:8px; padding:4px 2px;">
								<tr>
									<td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center; '.$color.'">'.$nro.'</td>
									<td style="border: 0.5px solid #000000; background-color:white; width:55px; text-align:center; '.$color.'">'.$fecha.'</td>
									<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; '.$color.'">'.$tipo_mov.'</td>
									<td style="border: 0.5px solid #000000; background-color:white; width:90px; text-align:center; '.$color.'">'.$moneda.'</td>
									<td style="border: 0.5px solid #000000; background-color:white; width:70px; text-align:center; '.$color.'">'.$nroTransaccion.'</td>
									<td style="border: 0.5px solid #000000; background-color:white; width:60px; text-align:center; '.$color.'">'.$facturasAsociadas.'</td>
									<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; '.$color.'">'.$total.'</td>
									<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; '.$color.'">'.$saldoMostrar.'</td>
								</tr>
							</table>';
					// }
				}
			}

		}
		$bloque2 = $tabla;
		$pdf->writeHTML($bloque2, false, false, false, false, '');

		/*=============================================
		               PIE DE PAGINA           
		=============================================*/
		if($saldo>0){// DATOS DE TRANSFERENCIA SI HAY DEUDA

			$nombreBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_banco')['ajuste'];
			$tipoCuentaBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'tipo_cuenta_banco')['ajuste'];
			$nroCuentaBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nro_cuenta_banco')['ajuste'];
			$nombreTitularBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_titular_banco')['ajuste'];
			$rutTitularBanco = explode('-',ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_titular_banco')['ajuste']);
			$rutMostrar = number_format($rutTitularBanco[0],0,',','.').'-'.$rutTitularBanco[1];
			$correoPagosBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_pagos_banco')['ajuste'];

			$datosPiePagina =
				'<table>
					<tr><td></td></tr>
					<tr><td>EL SALDO ADEUDADO ES DE <b>$ '.$saldoMostrar.'.-</b></td></tr>
					<tr><td></td></tr>
					<tr><td><b>DATOS PARA TRANSFERENCIA:</b></td></tr>
					<tr>
						<td style="width:120px; text-align:left; font-size:8px; padding:0px 2px;">
							BANCO <br>
							TIPO DE CUENTA<br>
							NRO. DE CUENTA<br>
							TITULAR<br>
							RUT<br>
							CORREO CONFIRMACIÓN
						</td>
						<td style="width:5px; text-align:left; font-size:8px; padding:0px 2px;">
							:<br>
							:<br>
							:<br>
							:<br>
							:<br>
							:<br>
						</td>
						<td style="width:240px; text-align:left; font-size:8px; padding:0px 2px;">
							BANCO '.strtoupper($nombreBanco).'<br>
							'.strtoupper($tipoCuentaBanco).'<br>
							'.$nroCuentaBanco.'<br>
							'.strtoupper($nombreTitularBanco).'<br>
							'.$rutMostrar.'<br>
							'.strtolower($correoPagosBanco).'<br>
						</td>
					</tr>
				</table>';
			$pdf->writeHTML($datosPiePagina, false, false, false, false, '');


		}else if($saldo<0){

			$saldoMostrar = number_format(-$saldo,0,',','.');
			$datosPiePagina =
				'<table>	
					<tr><td></td></tr>
					<tr><td>TIENES UN SALDO A FAVOR DE <b>$ '.$saldoMostrar.'.-</b></td></tr>
				</table>';
			$pdf->writeHTML($datosPiePagina, false, false, false, false, '');

		}else{

			$datosPiePagina =
				'<table>
					<tr><td></td></tr>
					<tr><td>NO TIENES SALDO ADEUDADO, ESTÁS AL DÍA</td></tr>
				</table>';
			$pdf->writeHTML($datosPiePagina, false, false, false, false, '');

		}





		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//DOCUMENTOS
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		// VENTAS ASOCIADAS AL PDF
		// $correlativoFact = 0;
		for ($i=0; $i < count($idsVentas); $i++) {


			$pdf->SetFont('helvetica', '', 12);
			//TRAEMOS LA INFORMACIÓN DE LA VENTA
			$itemVenta = "id";
			$valorVenta = $idsVentas[$i]; // entrega id de ultima venta que puede ver el vendedor o administrador
			$compItem = '=';
			$compEstado = '!=';
			$estado = 0;
			$filOrden = 'fecha_cont';
			$ord = 'DESC';
			$respuestaVenta = ControladorVentas::ctrMostrarVentas($itemVenta, $valorVenta, $compItem, $compEstado, $estado, $filOrden, $ord);

			$fecha = $respuestaVenta["fecha_venta"];
			$productos = json_decode($respuestaVenta["productos"], true);
			$total = number_format($respuestaVenta["total"],0,',','.');

			//TRAEMOS LA INFORMACIÓN DEL CLIENTE
			$itemCliente = "id";
			$valorCliente = $respuestaVenta["id_cliente"];
			if($respuestaVenta["id_cliente"]==0){
			$nomNew = explode(" (",$respuestaVenta["nom_client"]);
			$nomClient = $nomNew[0];
			}else{
			$respuestaCliente = ControladorClientes::ctrMostrarClientes($itemCliente, $valorCliente);
			$apellidos = explode(" ", $respuestaCliente["apellido"]);
			$nomClient = '<b>'.$respuestaCliente["nombre"].' '.$apellidos[0].'</b>';
			}


			//TRAEMOS LA INFORMACIÓN DEL VENDEDOR
			$itemVendedor = "id";
			$valorVendedor = $respuestaVenta["id_vendedor"];
			$respuestaVendedor = ControladorUsuarios::ctrMostrarUsuarios($itemVendedor, $valorVendedor);

			$pdf-> setPrintHeader(false);
			$pdf->startPageGroup();
			$pdf->AddPage();

			$nombreComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_comercial')['ajuste']);
			$nombreReal = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_real')['ajuste']);
			$rutComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_comercial')['ajuste']);
			$direccionComercio = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'direccion_comercial')['ajuste']);
			$wsp = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_ventas')['ajuste'];
			$fono = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'];
			if($fono == ''){
				$fonoVenta = '';
			}else{
				$fonoVenta = 'Fono-Ventas: '.$fono.'<br>';
			}
			$correo = strtolower(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_ventas')['ajuste']);
			$logo = 'src="'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"';

			// AGREGA HIPERVINCULO
			$pdf->SetLink($pdf->AddLink());
			$pdf->SetDestination('pdfVenta'.($i+1));

			$bloque1 = '
				<table>
					<tr>
						<td style="width:150px"><img '.$logo.'></td>
						<td style="background-color:white; width:140px">
							<div style="font-size:8.5px; text-align:right; line-height:15px;">
								<br>'.$nombreComercio.'
								<br>'.$nombreReal.'
								<br>'.$rutComercio.'
								<br>Dirección: '.$direccionComercio.'
							</div>
						</td>
						<td style="background-color:white; width:140px">
							<div style="font-size:8.5px; text-align:right; line-height:15px;">
								<br>Whatsapp: '.$wsp.'
								<br>'.$fonoVenta.$correo.'
							</div>
						</td>
						<td style="background-color:white; width:110px; text-align:center"><br><br>Venta Nro. <br>'.$respuestaVenta['cod_venta'].'</td>
					</tr>
				</table>';

			$pdf->writeHTML($bloque1, false, false, false, false, '');

			// ---------------------------------------------------------

			$bloque2 = 

				'<table>
					<tr>
						<td style="width:540px"><img src="images/back.jpg"></td>
					</tr>
				</table>

				<table style="font-size:10px; padding:5px 10px;">
					<tr>
						<td style="border: 1px solid #666; background-color:white; width:390px">Cliente: '.$nomClient.'</td>
						<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">Fecha: '.$fecha.'</td>
					</tr>
					<tr>
						<td style="border: 1px solid #666; background-color:white; width:540px">Vendedor: '.$respuestaVendedor['nombre'].'</td>
					</tr>
					<tr>
						<td style="border-bottom: 1px solid #666; background-color:white; width:540px"></td>
					</tr>
				</table>';

			$pdf->writeHTML($bloque2, false, false, false, false, '');

			if($_SESSION['perfil'] == 'Vendedor' && $respuestaVenta['vista_vendedor']==0){ // impide ver venta con precio_venta = precio_compra a perfil vendedor
			
				$bloque3 = // ENCABEZADOS COLUMNAS
					'<table style="font-size:10px; padding:5px 10px;">
						<tr>
							<td style="border: 1px solid #333; background-color:white; width:70px; text-align:center; font-size:9px"><b>CANT</b></td>
							<td style="border: 1px solid #333; background-color:white; width:80px; text-align:center; font-size:9px"><b>COD</b></td>
							<td style="border: 1px solid #333; background-color:white; width:390px; text-align:left; font-size:9px"><b>PRODUCTOS</b></td>
						</tr>
					</table>';
				$pdf->writeHTML($bloque3, false, false, false, false, '');

				foreach(array_reverse($productos) as $key => $item) {


				$precioTotal = number_format($item["tot"], 0,',','.');

				$bloque4 =
					'<table style="font-size:10px; padding:5px 10px;">
						<tr>
							<td style="border: 1px solid #333; color:#333; background-color:white; width:70px; text-align:center; font-size:9px">'.$item['cant'].'</td>
							<td style="border: 1px solid #333; color:#333; background-color:white; width:80px; text-align:center; font-size:9px">'.$item['sku'].'</td>
							<td style="border: 1px solid #333; color:#333; background-color:white; width:390px; text-align:left; font-size:9px">'.$item['prod'].'</td>
						</tr>
					</table>';
				$pdf->writeHTML($bloque4, false, false, false, false, '');

			}

			}else{ // sigue el proceso si no cumple lo anterior

				// ENCABEZADOS COLUMNAS
				$bloque3 =

					'<table style="font-size:10px; padding:5px 10px;">
						<tr>
							<td style="border: 1px solid #333; background-color:white; width:50px; text-align:center; font-size:9px"><b>CANT</b></td>
							<td style="border: 1px solid #333; background-color:white; width:55px; text-align:left; font-size:9px"><b>COD</b></td>
							<td style="border: 1px solid #333; background-color:white; width:270px; text-align:left; font-size:9px"><b>PRODUCTOS</b></td>
							<td style="border: 1px solid #333; background-color:white; width:80px; text-align:center; font-size:9px"><b>$ UNIT. C/IVA</b></td>
							<td style="border: 1px solid #333; background-color:white; width:85px; text-align:center; font-size:9px"><b>VALOR TOTAL</b></td>
						</tr>
					</table>';
				$pdf->writeHTML($bloque3, false, false, false, false, '');

				// ---------------------------------------------------------

				foreach(array_reverse($productos) as $key => $item) {

					$valorUnitarioNeto = number_format(($item["tot"]/$item["cant"])/1.19, 2,',','.');
					$valorUnitario = number_format($item["tot"]/$item["cant"], 0,',','.');
					// $precioUnitario = $valorUnitarioNeto.' - '.$valorUnitario;
					$precioUnitario = '$ '.$valorUnitario;


					if($item["dcto"]>0){
						$dcto = "<b>(Dcto: ".$item["dcto"]."%)</b>";
					}else{
						$dcto = "";
					}


					$precioTotal = number_format($item["tot"], 0,',','.');

					$bloque4 =

						'<table style="font-size:10px; padding:5px 10px;">
							<tr>
								<td style="border: 1px solid #333; color:#333; background-color:white; width:50px; text-align:center; font-size:9px">'.$item['cant'].'</td>
								<td style="border: 1px solid #333; color:#333; background-color:white; width:55px; text-align:left; font-size:9px">'.$item['sku'].'</td>
								<td style="border: 1px solid #333; color:#333; background-color:white; width:270px; text-align:left; font-size:9px">'.$item['prod'].' '.$dcto.'</td>
								<td style="border: 1px solid #333; color:#333; background-color:white; width:80px; text-align:center; font-size:9px">'.$precioUnitario.'</td>
								<td style="border: 1px solid #333; color:#333; background-color:white; width:85px; text-align:center; font-size:9px">$ '.$precioTotal.'</td>
							</tr>
						</table>';
					$pdf->writeHTML($bloque4, false, false, false, false, '');

				}

				// ---------------------------------------------------------

				$bloque5 =
					'<table style="font-size:10px; padding:5px 10px;">
						<tr>
							<td style="color:#333; background-color:white; width:340px; text-align:center"></td>
							<td style="border-bottom: 1px solid #666; background-color:white; width:100px; text-align:center"></td>
							<td style="border-bottom: 1px solid #666; color:#333; background-color:white; width:100px; text-align:center"></td>
						</tr>
						<tr>
							<td style="border-right: 1px solid #666; color:#333; background-color:white; width:340px; text-align:center"></td>
							<td style="border: 1px solid #666; background-color:white; width:100px; text-align:center">TOTAL:</td>
							<td style="border: 1px solid #666; color:#333; background-color:white; width:100px; text-align:center">$ '.$total.'</td>
						</tr>
					</table>';
				$pdf->writeHTML($bloque5, false, false, false, false, '');

			}

			// ---------------------------------------------------------
			// DETALLES Y METODO DE PAGO
			$metPago = json_decode($respuestaVenta["metodo_pago"]);
			$filaDespacho = $respuestaVenta['detalle_flete'] == '' ? '' : '<tr><td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">DESPACHO:</td><td style="font-size:13px; color:#333; background-color:white; width:390px; text-align:left"><b>'.strtoupper($respuestaVenta['detalle_flete']).'</b></td></tr>';
			$filaObservaciones = $respuestaVenta['detalle_venta']=='' ? '' : '<tr><td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">OBSERVACIONES:</td><td style="font-size:13px; color:#333; background-color:white; width:390px; text-align:left">'.strtoupper($respuestaVenta['detalle_venta']).'</td></tr>';

			$bloque6 =
				'<table style="padding:5px 10px;">
					<tr>
						<td></td>
					</tr>'.
					$filaObservaciones.
					$filaDespacho.'
					<tr>
						<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
						<td style="font-size:13px; background-color:white; width:390px; text-align:left">CRÉDITO INTERNO</td>
					</tr>
				</table>';

			$pdf->writeHTML($bloque6, false, false, false, false, '');
			
			$pdf->writeHTMLCell(0, 0, 170, 5, '<a href="#inicio" style="font-size:10px">SUBIR</a>', 0, 0, false, true, 'C');


			if($respuestaVenta['rut_factura'] != '' && $respuestaVenta['nro_factura'] != ''){

				$facturasVenta = explode(',', $respuestaVenta['nro_factura']);
				
				$cantFacturasVenta = count($facturasVenta);

				$directorioFacturas = $respuestaVenta['dir_factura'] == '' ? '' : $respuestaVenta['dir_factura'].'/';

				// $listaFacts = '';
				for ($ia=0; $ia < $cantFacturasVenta; $ia++) { 

					$archivoFactura = '../../../sii/facturas/'.$directorioFacturas.$facturasVenta[$ia].'.pdf';
					// $archivoFactura = '../../../../sii/facturas/'.$facturasVenta[$ia].'.pdf';
					
					$pdf->SetFont('courier', 'B', 12);
					if(file_exists($archivoFactura)){
			

						$pdf->setSourceFile('../../../sii/facturas/'.$directorioFacturas.$facturasVenta[$ia].'.pdf');
						$pdfFactura = $pdf->importPage(1);
						$pdf->AddPage();

						if($ia==0){
							$pdf->SetLink($pdf->AddLink());
							$pdf->SetDestination('Fact'.($i+1));
						}

						$pdf->Cell(0, 10, 'Factura Asociada a venta nro. '.$respuestaVenta['cod_venta'], 0, 1, 'L'); // Agregar un título
						$pdf->useTemplate($pdfFactura);
						$pdf->writeHTMLCell(0, 0, 170, 5, '<a href="#inicio" style="font-size:10px">SUBIR</a>', 0, 0, false, true, 'C');
					}else{
						$pdf->AddPage();

						$pdf->SetLink($pdf->AddLink());
						$pdf->SetDestination('Fact'.($i+1));
						$html = 'La Factura nro. <b>"'.$facturasVenta[$ia].'"</b> aún no se ha subido al servidor.';
						$pdf->writeHTML($html, false, false, false, false, '');
						$pdf->writeHTMLCell(0, 0, 170, 5, '<a href="#inicio" style="font-size:10px">SUBIR</a>', 0, 0, false, true, 'C');
					}

					// $correlativoFact++;
				}
			}
		}
		
		// Guardar el PDF resultante
		$pdf->Output('FACTURAS CREDITO INTERNO '.$nombre.'.pdf', 'I');


	}

}

$historial = new historialCliente();
$historial -> mostrarHistorial();


?>