<?php

require_once "../../../controladores/ventas.controlador.php";
require_once "../../../modelos/ventas.modelo.php";
require_once "../../../controladores/cotizador.controlador.php";
require_once "../../../modelos/cotizador.modelo.php";
require_once "../../../controladores/clientes.controlador.php";
require_once "../../../modelos/clientes.modelo.php";
require_once "../../../controladores/usuarios.controlador.php";
require_once "../../../modelos/usuarios.modelo.php";
require_once "../../../controladores/productos.controlador.php";
require_once "../../../modelos/productos.modelo.php";
require_once "../../../controladores/ajustes.controlador.php";
require_once "../../../modelos/ajustes.modelo.php";

class imprimirCotizacion{

public $codigo;

public function traerImpresionCotizacion(){

//TRAEMOS LA INFORMACIÓN DE LA VENTA

$itemVenta = "id";
$nroCot = $this->codigo;

$respuestaCotizacion = ControladorCotizaciones::ctrMostrarCotizaciones($itemVenta, $nroCot);
$nroCotMostrar = number_format($nroCot,'0',',','.');

// $fecha = substr($respuestaCotizacion["fecha"],0,-8);
$fechaIngreso = $respuestaCotizacion["fecha_ingreso"];
$fechaExpiracion = $respuestaCotizacion["fecha_expiracion"];

$productos = json_decode($respuestaCotizacion["productos"], true);
$neto = number_format($respuestaCotizacion["neto"],0,',','.');
$impuesto = number_format($respuestaCotizacion["iva"],0,',','.');
$total = number_format($respuestaCotizacion["total"],0,',','.');
$totalConRecargo = number_format($respuestaCotizacion["total"]*1.05,0,',','.');

//TRAEMOS LA INFORMACIÓN DEL CLIENTE

$itemCliente = "id";
$valorCliente = $respuestaCotizacion["id_client"];
if($respuestaCotizacion["id_client"]==0){
$nomNew = explode(" (",$respuestaCotizacion["nom_client"]);
$nomClient = $nomNew[0];
}else{
$respuestaCliente = ControladorClientes::ctrMostrarClientes($itemCliente, $valorCliente);
$apellidos = explode(" ", $respuestaCliente["apellido"]);
$nomClient = '<b>'.$respuestaCliente["nombre"].' '.$apellidos[0].'</b>';
}



//TRAEMOS LA INFORMACIÓN DEL VENDEDOR

$itemVendedor = "id";
$valorVendedor = $respuestaCotizacion["id_vendedor"];

$respuestaVendedor = ControladorUsuarios::ctrMostrarUsuarios($itemVendedor, $valorVendedor);

//REQUERIMOS LA CLASE TCPDF
require_once('tcpdf_include.php');
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf-> setPrintHeader(false);
$pdf->startPageGroup();
$pdf->AddPage();

$nombreComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_comercial')['ajuste']);
$nombreReal = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_real')['ajuste']);
$rutComercio = explode('-',ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_comercial')['ajuste']);
$rutMostrar = number_format($rutComercio[0],0,',','.').'-'.$rutComercio[1];
$direccionComercio = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'direccion_comercial')['ajuste']);
$wsp = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_cot')['ajuste'];
$fono = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_cot')['ajuste'];
if($fono == ''){
	$fonoCot = '';
}else{
	$fonoCot = 'Fono-Ventas: '.$fono.'<br>';
}

$correo = strtolower(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_cot')['ajuste']);
$logo = 'src="'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"';

$bloque1 = <<<EOF
	<table>
		<tr>
			<td style="width:540px"><font size="50" style="text-align:center; color:rgb(40,48,94)"><b>COTIZACIÓN $nroCotMostrar</b></font></td>
		</tr>
		<tr>

			<td style="background-color:white; width:180px">
				<div style="font-size:8.5px; text-align:left; line-height:10px;">
					<br>
					$nombreComercio
					<br>
					$nombreReal (<b>$rutMostrar</b>)
					<br>
					Dirección: $direccionComercio
				</div>
			</td>
			<td style="width:45px"></td>
			<td style="width:90px"><img $logo></td>
			<td style="width:45px"></td>
			<td style="background-color:white; width:180px">
				<div style="font-size:8.5px; text-align:right; line-height:10px;">
					<br>
					Whatsapp: $wsp
					<br>
					$correo
				</div>
			</td>
		</tr>
	</table>
EOF;
$pdf->writeHTML($bloque1, false, false, false, false, '');

// ---------------------------------------------------------

$bloque2 = <<<EOF


	<table style="font-size:10px; padding:5px 10px;">
	<br><br>
		<tr>
		
			<td style="border: 1px solid #333; background-color:white; width:240px">
					
					
					<font size="+2">Cliente: $nomClient</font>
				
			</td>

			<td style="border: 1px solid #333; background-color:white; width:145px; text-align:left">
			
				Fecha Ingreso: $fechaIngreso

			</td>

			<td style="border: 1px solid #333; background-color:white; width:155px; text-align:left">
			
				Fecha Expiración: $fechaExpiracion

			</td>

		</tr>

		<tr>
		
			<td style="border: 1px solid #333; background-color:white; width:540px">

				<font size="+2">Vendedor: <b>$respuestaVendedor[nombre]</b></font>
			
			</td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');

// ---------------------------------------------------------

$bloque3 = <<<EOF
	<table style="font-size:10px; padding:5px 3px;">
		<br><br>
		<tr>
			<td style="border: 1px solid #333; background-color:white; width:35px; text-align:center; font-size:8px"><b>Cant</b></td>
			<td style="border: 1px solid #333; background-color:white; width:40px; text-align:center; font-size:8px"><b>Código</b></td>
			<td style="border: 1px solid #333; background-color:white; width:330px; text-align:left; font-size:8px"><b>Productos</b></td>
			<td style="border: 1px solid #333; background-color:white; width:60px; text-align:center; font-size:8px"><b>$ Unit c/Dcto</b></td>
			<td style="border: 1px solid #333; background-color:white; width:75px; text-align:center; font-size:8px"><b>Total</b></td>
		</tr>
	</table>
EOF;

// ---------------------------------------------------------

// $bloque3 = <<<EOF
// 	<table style="font-size:10px; padding:5px 3px;">
// 		<tr>
// 			<td style="border: 1px solid #333; background-color:white; width:35px; text-align:center; font-size:8px"><b>Cant</b></td>
// 			<td style="border: 1px solid #333; background-color:white; width:40px; text-align:center; font-size:8px"><b>Código</b></td>
// 			<td style="border: 1px solid #333; background-color:white; width:270px; text-align:left; font-size:8px"><b>Productos</b></td>
// 			<td style="border: 1px solid #333; background-color:white; width:60px; text-align:center; font-size:8px"><b>$ Unitario</b></td>
// 			<td style="border: 1px solid #333; background-color:white; width:60px; text-align:center; font-size:8px"><b>$ Unit c/Dcto</b></td>
// 			<td style="border: 1px solid #333; background-color:white; width:75px; text-align:center; font-size:8px"><b>Total</b></td>
// 		</tr>
// 	</table>
// EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

// ---------------------------------------------------------
$subtotal = 0;
$detectaFlete = 0;
$skuFlete = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'sku_flete')['ajuste'];
foreach(array_reverse($productos) as $key => $item) {


	// $itemProducto = "id";
	// $valorProducto = $item["id"];
	// $orden = 'id';
	// $cantCotizada = $item["cant"];
	// $respuestaProducto = ControladorProductos::ctrMostrarProductos($itemProducto, $valorProducto, $orden);
	
	if($skuFlete == $item['sku']){
		$detectaFlete += 1;
	}

	if($item["pV"]>$item["tot"]/$item["cant"]){ // si pV es mayor que precio unitario asignado
	$vUnit = "$".number_format($item["pV"], 0,',','.');
	$vUnitDcto = number_format($item["tot"]/$item["cant"], 0,',','.');
	$precioTotal = number_format($item["tot"], 0,',','.');
	$subtotal += $item["pV"]*$item["cant"];
	$pNormal = "<i>[Normal ".$vUnit."]</i>";
	}else{
	$vUnit = "$".number_format($item["pV"], 0,',','.');
	$vUnitDcto = number_format($item["tot"]/$item["cant"], 0,',','.');
	$precioTotal = number_format($item["tot"], 0,',','.');
	$subtotal += $item["tot"];
	$pNormal = "";
	}



	if($item["dcto"]>0){
	$dcto = "(Dcto: ".$item["dcto"]."%)";
	}else{
	$dcto = "";
	}

$bloque4 = <<<EOF
	<table style="font-size:10px; padding:5px 3px;">
		<tr>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:35px; text-align:center; font-size:8px">
				$item[cant]
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:40px; text-align:center; font-size:8px">
				$item[sku]
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:330px; text-align:left; font-size:8px">
				$item[prod] <b>$dcto</b> $pNormal
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:60px; text-align:center; font-size:8px">$ 
				$vUnitDcto
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:75px; text-align:center; font-size:8px">$ 
				$precioTotal
			</td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');

}

// ---------------------------------------------------------
$subT = number_format($subtotal, 0,',','.');
$dctos = number_format($subtotal-$respuestaCotizacion["total"], 0,',','.');

$fecha1= new DateTime($fechaIngreso);
$fecha2= new DateTime($fechaExpiracion);
$diff = $fecha1->diff($fecha2);
$vigencia = $diff->days;

$vigenciaMostrar = $vigencia == 1 ? '1 día' : $vigencia.' días corridos';

if($detectaFlete == 1){
	$condiciones1 = '<td style="color:#333; background-color:white; width:113px; font-size:8.5px; text-align:left; line-height:10px;">Validez<br>Condición de Pago</td>';
	$condiciones2 = '<td style="color:#333; background-color:white; width:262px; font-size:8.5px; text-align:left; line-height:10px;">: '.$vigenciaMostrar.'<br>: Efectivo o Transferencia</td>';
}else{
	$condiciones1 = '<td style="color:#333; background-color:white; width:113px; font-size:8.5px; text-align:left; line-height:10px;">Condición Despacho<br>Validez<br>Condición de Pago</td>';	
	$condiciones2 = '<td style="color:#333; background-color:white; width:262px; font-size:8.5px; text-align:left; line-height:10px;">: Sin Despacho<br>: '.$vigenciaMostrar.'<br>: Efectivo o Transferencia</td>';
}

if($dctos==0){
$bloque5 = <<<EOF


	<table style="font-size:10px; padding:5px 10px;">

<br><br>
		
		<tr>
			<td style="width:100px"></td>		
			<td style="width:212px"></td>
			<td style="border: 1px solid #333; background-color:rgb(158,235,146); width:130px; text-align:center; font-size:13px">
				<b>TOTAL A PAGAR</b>
			</td>
			
			<td style="border: 1px solid #333; color:#333; background-color:rgb(158,235,146); width:98px; text-align:center; font-size:13px">
				<b>$ $total</b>
			</td>

		</tr>
		<tr>
			$condiciones1
			$condiciones2
		</tr>
		<tr>
			<td style="color:#333; background-color:white; width:113px; font-size:8.5px; text-align:left; line-height:10px">Observaciones</td>		
			<td style="color:#333; background-color:white; width:427px; font-size:8.5px; text-align:left; line-height:10px">: Esta cotización <b>NO ASEGURA</b> disponibilidad del producto. Se solicita existencia al momento de la compra.
			</td>
		</tr>


	</table>




EOF;

$pdf->writeHTML($bloque5, false, false, false, false, '');
}else{


$bloque5 = <<<EOF


	<table style="font-size:10px; padding:5px 10px;">

		<tr>

			<td style="color:#333; background-color:white; width:113px; text-align:center"></td>
			<td style="color:#333; background-color:white; width:262px; text-align:center"></td>
			<td style="background-color:white; width:80px; text-align:center"></td>
			<td style="color:#333; background-color:white; width:85px; text-align:center"></td>

		</tr>
		
		<tr>
			<td style="width:100px"></td>		
			<td style="width:212px"></td>
			<td style="border: 1px solid #333; background-color:white; width:130px; text-align:center">
				SUBTOTAL
			</td>
			
			<td style="border: 1px solid #333; color:#333; background-color:white; width:98px; text-align:center">
				$ $subT
			</td>
		</tr>

		<tr>
			<td style="width:100px"></td>		
			<td style="width:212px"></td>
			<td style="border: 1px solid #333; background-color:white; width:130px; text-align:center">
				DESCUENTOS
			</td>
			
			<td style="border: 1px solid #333; color:#333; background-color:white; width:98px; text-align:center">
				$ $dctos
			</td>

		</tr>
		<tr>
			<td style="width:100px"></td>		
			<td style="width:212px"></td>
			<td style="border: 1px solid #333; background-color:rgb(158,235,146); width:130px; text-align:center; font-size:13px">
				<b>TOTAL A PAGAR</b>
			</td>
			
			<td style="border: 1px solid #333; color:#333; background-color:rgb(158,235,146); width:98px; text-align:center; font-size:13px">
				<b>$ $total</b>
			</td>

		</tr>
		<tr>
			<td style="color:#333; background-color:white; width:113px; text-align:left">Condición Despacho<br>Validez<br>Condición de Pago</td>		
			<td style="color:#333; background-color:white; width:262px; text-align:left">: Sin Despacho<br>: $vigenciaMostrar<br>: Efectivo o Transferencia</td>
		</tr>
		<tr>
			<td style="color:#333; background-color:white; width:113px; text-align:left">Observaciones</td>		
			<td style="color:#333; background-color:white; width:427px; text-align:left">: Esta cotización <b>NO ASEGURA</b> disponibilidad del producto. Se solicita confirmar<br>  existencia al momento de la compra
			</td>
		</tr>


	</table>




EOF;

$pdf->writeHTML($bloque5, false, false, false, false, '');	
}

$bloque6 = <<<EOF

	<table style="font-size:10px; padding:5px 10px;">
		<br>
		<tr>

			<td style="color:#333; background-color:white; ; font-size:8.5px; text-align:left; line-height:10px">
			Esperando que el contenido de la presente sea de su utilidad, me pongo a sus órdenes para cualquier duda al respecto. Atentamente,
			</td>

		</tr>


	</table>

	<table style="font-size:10px; padding:5px 10px;">

		<tr>
			<td style="width:300px"></td>

			<td style="color:#000; background-color:white; width:150px; text-align:center">
			$respuestaVendedor[nombre] <br>	$correo
			</td>
			<td style="width:90px"></td>

		</tr>

	</table>



EOF;

$pdf->writeHTML($bloque6, false, false, false, false, '');


// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 
if($_GET['motivo']=='descarga'){
	if($respuestaCotizacion['id_client']==0){ // NOMBRE CON NRO DE TELEFONO SI NO ES CLIENTE
		$pdf->Output(date("Ymd").' Cotizacion '.$respuestaCotizacion["id"].'__'.strtoupper($respuestaCotizacion['nom_client']).'.pdf','D');
	}else{ //SI ES CLIENTE SOLO NOMBRE
		$nombreAbreviado = explode(' (', $respuestaCotizacion['nom_client']);
		$pdf->Output(date("Ymd").' Cotizacion '.$respuestaCotizacion["id"].'__'.strtoupper($nombreAbreviado[0]).'.pdf','D');
	}
}else if($_GET['motivo']=='ver'){
	$pdf->Output(date("Ymd").' Cotizacion '.$respuestaCotizacion["id"].'__'.strtoupper($respuestaCotizacion['nom_client']).'.pdf');
}


}

}

$cotizacion = new imprimirCotizacion();
$cotizacion -> codigo = $_GET["codigo"];
$cotizacion -> traerImpresionCotizacion();

?>