<?php
set_time_limit(3000);
require_once "../../../modelos/compras.modelo.php";
require_once "../../../modelos/productos.modelo.php";

class imprimirCodigosBarra{
    public function crearPDFCodsBarra(){

        $codigosBarra = json_decode($_GET['etiqs']);
        
        //REQUERIMOS LA CLASE TCPDF
        require_once('tcpdf_include.php');
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf-> setPrintHeader(false);
        $pdf->startPageGroup();
        $pdf->AddPage();
        // date_default_timezone_set("America/Santiago");

        $html = '<table>';
        $nombres = [];
        $codigos = [];
        foreach($codigosBarra as $key => $value) {

            $idProducto = $codigosBarra[$key]->id;
            $cantEtiquetasProd = $codigosBarra[$key]->cant;

            $producto = ModeloProductos::mdlMostrarProductos('productos','id', $idProducto, 'fecha');
            $sku = $producto["categoria"] <= 9 ? '0'.$producto["sku"] : $producto["sku"];
            for ($i=0; $i < $cantEtiquetasProd; $i++) { 
                array_push($nombres, $producto['desc_sii']);
                array_push($codigos, strval($sku));
            }
        }
        

        $iteraciones = round(count($nombres)/4,0);
        $restoPorIterar = count($nombres)%4;

        $resta = $restoPorIterar == 0 || $restoPorIterar == 1 ? 0 : 1;  // PARA EVITAR OFFSET

        for ($i=0; $i < ($iteraciones-$resta); $i++){
            $barcode1 = $pdf->serializeTCPDFtagParameters(array($codigos[(4*$i)], 'I25','','',72, 20, 0.5, array('position'=>'5','border'=>false, 'padding'=>2, 'fgcolor'=>array(0,0,0), 'bgcolor' => array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>7, 'stretchtext'=>6), 'N'));
            $barcode2 = $pdf->serializeTCPDFtagParameters(array($codigos[(4*$i+1)], 'I25','','',72, 20, 0.5, array('position'=>'5','border'=>false, 'padding'=>2, 'fgcolor'=>array(0,0,0), 'bgcolor' => array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>7, 'stretchtext'=>6), 'N'));
            $barcode3 = $pdf->serializeTCPDFtagParameters(array($codigos[(4*$i+2)], 'I25','','',72, 20, 0.5, array('position'=>'5','border'=>false, 'padding'=>2, 'fgcolor'=>array(0,0,0), 'bgcolor' => array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>7, 'stretchtext'=>6), 'N'));
            $barcode4 = $pdf->serializeTCPDFtagParameters(array($codigos[(4*$i+3)], 'I25','','',72, 20, 0.5, array('position'=>'5','border'=>false, 'padding'=>2, 'fgcolor'=>array(0,0,0), 'bgcolor' => array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>7, 'stretchtext'=>6), 'N'));
            $html .= 
                    '<tr>
                        <td style="font-size:8px; width:22%">'.strtoupper($nombres[4*$i]).'<br><tcpdf method="write1DBarcode" params="'.$barcode1.'" /></td><td style="font-size:8px; width:3%"></td>
                        <td style="font-size:8px; width:22%">'.strtoupper($nombres[4*$i+1]).'<br><tcpdf method="write1DBarcode" params="'.$barcode2.'" /></td><td style="font-size:8px; width:3%"></td>
                        <td style="font-size:8px; width:22%">'.strtoupper($nombres[4*$i+2]).'<br><tcpdf method="write1DBarcode" params="'.$barcode3.'" /></td><td style="font-size:8px; width:3%"></td>
                        <td style="font-size:8px; width:22%">'.strtoupper($nombres[4*$i+3]).'<br><tcpdf method="write1DBarcode" params="'.$barcode4.'" /></td><td style="font-size:8px; width:3%"></td>
                    </tr>';
        }
        

        if($restoPorIterar != 0){   
            $ultimaIteracion = $i;
            // RESTO DE PRODUCTOS POR ITERAR
            $html .= '<tr>';
            for ($i=0; $i < ($restoPorIterar); $i++){
                $barcode1 = $pdf->serializeTCPDFtagParameters(array($codigos[4*$ultimaIteracion+$i], 'I25','','',72, 20, 0.5, array('position'=>'5','border'=>false, 'padding'=>2, 'fgcolor'=>array(0,0,0), 'bgcolor' => array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>7, 'stretchtext'=>6), 'N'));
                $html .= '<td style="font-size:8px; width:22%">'.strtoupper($nombres[4*$ultimaIteracion+$i]).'<br><tcpdf method="write1DBarcode" params="'.$barcode1.'" /></td><td style="font-size:8px; width:3%"></td>';
            }



            // COMPLETAR FILA
            for ($i=0; $i < (4-$restoPorIterar); $i++){
                $barcode1 = $pdf->serializeTCPDFtagParameters(array($codigos[count($nombres)-1], 'I25','','',72, 20, 0.5, array('position'=>'5','border'=>false, 'padding'=>2, 'fgcolor'=>array(0,0,0), 'bgcolor' => array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>7, 'stretchtext'=>6), 'N'));
                $html .= '<td style="font-size:8px; width:22%">'.strtoupper($nombres[count($nombres)-1]).'<br><tcpdf method="write1DBarcode" params="'.$barcode1.'" /></td><td style="font-size:8px; width:3%"></td>';
            }






            $html .= '</tr>';

        }
        $html .= '</table>';


        $pdf->writeHTML($html, false, false, false, false, '');
        $pdf->Output('Codigos Barra'.'.pdf');
    }
}

$codigosBarra = new imprimirCodigosBarra();
$codigosBarra -> crearPDFCodsBarra();

