<?php
set_time_limit(3000);
require_once "../../../modelos/compras.modelo.php";
require_once "../../../modelos/productos.modelo.php";

class imprimirCodigosBarra{
	public function crearPDFCodsBarra(){

		$codigosBarra = json_decode($_GET['etiqs']);
		$cantEtiquetasProd = 0;
		foreach($codigosBarra as $key => $value) {
			$cantEtiquetasProd += $codigosBarra[$key]->cant;
		}

		//REQUERIMOS LA CLASE TCPDF
		require_once('tcpdf_include.php');
		
		$ancho = 30;
		$largo = 50;
		$medidas = array($ancho, $largo); // Ajustar aqui segun los milimetros necesarios;
		$pdf = new TCPDF('L', 'mm', $medidas, true, 'UTF-8', false);
		$pdf->SetMargins(2, 2, 2, 2);
		$pdf->SetAutoPageBreak(false, PDF_MARGIN_BOTTOM); 
		$pdf-> setPrintHeader(false);
		$pdf-> setPrintFooter(false);
		$pdf->startPageGroup();

		$nombres = [];
		$codigos = [];
		foreach($codigosBarra as $key => $value) {

			$idProducto = $codigosBarra[$key]->id;
			$cantEtiquetasProd = $codigosBarra[$key]->cant;

			$producto = ModeloProductos::mdlMostrarProductos('productos','id', $idProducto, 'fecha');
			$sku = $producto["categoria"] <= 9 ? '0'.$producto["sku"] : $producto["sku"];
			for ($i=0; $i < $cantEtiquetasProd; $i++) { 
				$barcode = $pdf->serializeTCPDFtagParameters(array(strval($sku), 'I25','','',90, 20, 0.6, array('position'=>'5','border'=>false, 'padding'=>2, 'fgcolor'=>array(0,0,0), 'bgcolor' => array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>10, 'stretchtext'=>10), 'N'));
        		
        		$pdf->AddPage();
                $espacio6Digitos = strlen($sku) == 6 ? '   ' : '';
				$html = '<font size="8px">'.strtoupper($producto['desc_sii']).'</font><br>'.$espacio6Digitos.'<tcpdf method="write1DBarcode" params="'.$barcode.'" />';
        		$pdf->writeHTML($html, false, false, false, false, '');
			}
		}
		

		$pdf->Output('Codigos Barra'.'.pdf');
	}
}

$codigosBarra = new imprimirCodigosBarra();
$codigosBarra -> crearPDFCodsBarra();

