<?php
session_start();
require_once "../../../controladores/ventas.controlador.php";
require_once "../../../modelos/ventas.modelo.php";
require_once "../../../controladores/clientes.controlador.php";
require_once "../../../modelos/clientes.modelo.php";
require_once "../../../controladores/usuarios.controlador.php";
require_once "../../../modelos/usuarios.modelo.php";
require_once "../../../controladores/productos.controlador.php";
require_once "../../../modelos/productos.modelo.php";
require_once "../../../controladores/ajustes.controlador.php";
require_once "../../../modelos/ajustes.modelo.php";

class imprimirVenta{
public function traerImpresionVenta(){

//TRAEMOS LA INFORMACIÓN DE LA VENTA
if(isset($_GET['codigo'])){ // accedero por id
	$itemVenta = "id";
	$valorVenta = $_GET['codigo'] != 'ultima' ? $_GET['codigo'] : ModeloVentas::mdlSeleccionarUltimoIdVenta($_SESSION['perfil'])['id']; // entrega id de ultima venta que puede ver el vendedor o administrador
}else if(isset($_GET['cod_venta'])){ // acceder por 
	$itemVenta = "cod_venta";
	$valorVenta = $_GET['cod_venta'];
}
$compItem = '=';
$compEstado = '!=';
$estado = 0;
$filOrden = 'fecha_cont';
$ord = 'DESC';
$respuestaVenta = ControladorVentas::ctrMostrarVentas($itemVenta, $valorVenta, $compItem, $compEstado, $estado, $filOrden, $ord);


$fecha = $respuestaVenta["fecha_venta"];
$productos = json_decode($respuestaVenta["productos"], true);
$total = number_format($respuestaVenta["total"],0,',','.');

//TRAEMOS LA INFORMACIÓN DEL CLIENTE
$itemCliente = "id";
$valorCliente = $respuestaVenta["id_cliente"];
if($respuestaVenta["id_cliente"]==0){
$nomNew = explode(" (",$respuestaVenta["nom_client"]);
$nomClient = $nomNew[0];
}else{
$respuestaCliente = ControladorClientes::ctrMostrarClientes($itemCliente, $valorCliente);
$apellidos = explode(" ", $respuestaCliente["apellido"]);
$nomClient = '<b>'.$respuestaCliente["nombre"].' '.$apellidos[0].'</b>';
}


//TRAEMOS LA INFORMACIÓN DEL VENDEDOR
$itemVendedor = "id";
$valorVendedor = $respuestaVenta["id_vendedor"];
$respuestaVendedor = ControladorUsuarios::ctrMostrarUsuarios($itemVendedor, $valorVendedor);

//REQUERIMOS LA CLASE TCPDF
require_once('tcpdf_include.php');
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf-> setPrintHeader(false);
$pdf->startPageGroup();
$pdf->AddPage();

$nombreComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_comercial')['ajuste']);
$nombreReal = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_real')['ajuste']);
$rutComercio = explode('-',ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_comercial')['ajuste']);
$rutMostrar = number_format($rutComercio[0],0,',','.').'-'.$rutComercio[1];
$direccionComercio = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'direccion_comercial')['ajuste']);
$wsp = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_ventas')['ajuste'];
$fono = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'];
if($fono == ''){
	$fonoVenta = '';
}else{
	$fonoVenta = 'Fono-Ventas: '.$fono.'<br>';
}
$correo = strtolower(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_ventas')['ajuste']);
$logo = 'src="'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"';

$bloque1 = <<<EOF
	<table>
		<tr>
			<td style="width:150px"><img $logo></td>
			<td style="background-color:white; width:140px">
				<div style="font-size:8.5px; text-align:right; line-height:15px;">
					<br>
					$nombreComercio
					<br>
					$nombreReal
					<br>
					$rutMostrar
					<br>
					Dirección: $direccionComercio
				</div>
			</td>
			<td style="background-color:white; width:140px">
				<div style="font-size:8.5px; text-align:right; line-height:15px;">
					<br>
					Whatsapp: $wsp
					<br>
					$fonoVenta
					$correo
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center"><br><br>Venta Nro. <br>$respuestaVenta[cod_venta]</td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ---------------------------------------------------------

$bloque2 = <<<EOF

	<table>
		
		<tr>
			
			<td style="width:540px"><img src="images/back.jpg"></td>
		
		</tr>

	</table>

	<table style="font-size:10px; padding:5px 10px;">
	
		<tr>
		
			<td style="border: 1px solid #666; background-color:white; width:390px">

				Cliente: $nomClient

			</td>

			<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">
			
				Fecha: $fecha

			</td>

		</tr>

		<tr>
		
			<td style="border: 1px solid #666; background-color:white; width:540px">Vendedor: $respuestaVendedor[nombre]</td>

		</tr>

		<tr>
		
		<td style="border-bottom: 1px solid #666; background-color:white; width:540px"></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');



if($_SESSION['perfil'] == 'Vendedor' && $respuestaVenta['vista_vendedor'] == 0){ // impide ver venta con precio_venta = precio_compra a perfil vendedor
// ENCABEZADOS COLUMNAS
$bloque3 = <<<EOF

	<table style="font-size:10px; padding:5px 10px;">

		<tr>
		
			<td style="border: 1px solid #333; background-color:white; width:70px; text-align:center; font-size:9px"><b>CANT</b></td>
			<td style="border: 1px solid #333; background-color:white; width:80px; text-align:center; font-size:9px"><b>COD</b></td>
			<td style="border: 1px solid #333; background-color:white; width:390px; text-align:left; font-size:9px"><b>PRODUCTOS</b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

foreach(array_reverse($productos) as $key => $item) {


$precioTotal = number_format($item["tot"], 0,',','.');

$bloque4 = <<<EOF

	<table style="font-size:10px; padding:5px 10px;">

		<tr>
			
			<td style="border: 1px solid #333; color:#333; background-color:white; width:70px; text-align:center; font-size:9px">
				$item[cant]
			</td>

			<td style="border: 1px solid #333; color:#333; background-color:white; width:80px; text-align:center; font-size:9px">
				$item[sku]
			</td>

			<td style="border: 1px solid #333; color:#333; background-color:white; width:390px; text-align:left; font-size:9px">
				$item[prod]
			</td>

		</tr>

	</table>


EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');

}




}else{ // sigue el proceso si no cumple lo anterior

// ENCABEZADOS COLUMNAS
$bloque3 = <<<EOF

	<table style="font-size:10px; padding:5px 10px;">

		<tr>
		
		<td style="border: 1px solid #333; background-color:white; width:50px; text-align:center; font-size:9px"><b>CANT</b></td>
		<td style="border: 1px solid #333; background-color:white; width:55px; text-align:left; font-size:9px"><b>COD</b></td>
		<td style="border: 1px solid #333; background-color:white; width:270px; text-align:left; font-size:9px"><b>PRODUCTOS</b></td>
		<td style="border: 1px solid #333; background-color:white; width:80px; text-align:center; font-size:9px"><b>$ UNIT. C/IVA</b></td>
		<td style="border: 1px solid #333; background-color:white; width:85px; text-align:center; font-size:9px"><b>VALOR TOTAL</b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

// ---------------------------------------------------------



foreach(array_reverse($productos) as $key => $item) {


$valorUnitarioNeto = number_format(($item["tot"]/$item["cant"])/1.19, 2,',','.');
$valorUnitario = number_format($item["tot"]/$item["cant"], 0,',','.');
// $precioUnitario = $valorUnitarioNeto.' - '.$valorUnitario;
$precioUnitario = '$ '.$valorUnitario;


if($item["dcto"]>0){
$dcto = "<b>(Dcto: ".$item["dcto"]."%)</b>";
}else{
$dcto = "";
}


$precioTotal = number_format($item["tot"], 0,',','.');

$bloque4 = <<<EOF

	<table style="font-size:10px; padding:5px 10px;">

		<tr>
			
			<td style="border: 1px solid #333; color:#333; background-color:white; width:50px; text-align:center; font-size:9px">
				$item[cant]
			</td>

			<td style="border: 1px solid #333; color:#333; background-color:white; width:55px; text-align:left; font-size:9px">
				$item[sku]
			</td>

			<td style="border: 1px solid #333; color:#333; background-color:white; width:270px; text-align:left; font-size:9px">
				$item[prod] $dcto
			</td>


			<td style="border: 1px solid #333; color:#333; background-color:white; width:80px; text-align:center; font-size:9px">
				$precioUnitario
			</td>

			<td style="border: 1px solid #333; color:#333; background-color:white; width:85px; text-align:center; font-size:9px">$ 
				$precioTotal
			</td>


		</tr>

	</table>


EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');

}





// ---------------------------------------------------------

$bloque5 = <<<EOF

	<table style="font-size:10px; padding:5px 10px;">

		<tr>

			<td style="color:#333; background-color:white; width:340px; text-align:center"></td>

			<td style="border-bottom: 1px solid #666; background-color:white; width:100px; text-align:center"></td>

			<td style="border-bottom: 1px solid #666; color:#333; background-color:white; width:100px; text-align:center"></td>

		</tr>
		
		<tr>
		
			<td style="border-right: 1px solid #666; color:#333; background-color:white; width:340px; text-align:center"></td>

			<td style="border: 1px solid #666; background-color:white; width:100px; text-align:center">
				TOTAL:
			</td>
			
			<td style="border: 1px solid #666; color:#333; background-color:white; width:100px; text-align:center">
				$ $total
			</td>

		</tr>


	</table>




EOF;

$pdf->writeHTML($bloque5, false, false, false, false, '');












}

// ---------------------------------------------------------
// DETALLES Y METODO DE PAGO
$metPago = json_decode($respuestaVenta["metodo_pago"]);
$filaDespacho = $respuestaVenta['detalle_flete'] == '' ? '' : '<tr><td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">DESPACHO:</td><td style="font-size:13px; color:#333; background-color:white; width:390px; text-align:left"><b>'.strtoupper($respuestaVenta['detalle_flete']).'</b></td></tr>';
$filaObservaciones = $respuestaVenta['detalle_venta']=='' ? '' : '<tr><td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">OBSERVACIONES:</td><td style="font-size:13px; color:#333; background-color:white; width:390px; text-align:left">'.strtoupper($respuestaVenta['detalle_venta']).'</td></tr>';

if($respuestaVenta['tipo_pago']=="Efectivo"){
	$cash = number_format($metPago[0]->cash,0,',','.');
	$total = number_format($metPago[0]->total,0,',','.');
	$vuelto = number_format($metPago[0]->vuelto,0,',','.');

$bloque6 = <<<EOF
	<table style="padding:5px 10px;">
		<tr>
			<td></td>
		</tr>
		$filaObservaciones
		$filaDespacho
		<tr>
			<td style="font-size:13px; color:#333; background-color:white; width:340px; text-align:left">METODO PAGO:</td>
			<td style="font-size:10px; background-color:white; width:100px; text-align:right">CASH<br>TOTAL<br>VUELTO</td>
			<td style="font-size:10px; color:#333; background-color:white; width:100px; text-align:center">:$ $cash<br>:$ $total<br>:$ $vuelto</td>
		</tr>
	</table>
EOF;
}else if($respuestaVenta['tipo_pago']=="Transferencia"){
$bloque6 = <<<EOF
	<table style="padding:5px 10px;">
		<tr>
			<td></td>
		</tr>
		$filaObservaciones
		$filaDespacho
		<tr>
			<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
			<td style="font-size:13px; background-color:white; width:390px; text-align:left">SE PAGÓ VÍA TRANSFERENCIA ELECTRÓNICA</td>
		</tr>
	</table>
EOF;
}else if($respuestaVenta['tipo_pago']=="TD"){
$bloque6 = <<<EOF
	<table style="padding:5px 10px;">
		<tr>
			<td></td>
		</tr>
		$filaObservaciones
		$filaDespacho
		<tr>
			<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
			<td style="font-size:13px; background-color:white; width:390px; text-align:left">$respuestaVenta[metodo_pago]</td>
		</tr>
	</table>
EOF;
}else if($respuestaVenta['tipo_pago']=="TC"){
$bloque6 = <<<EOF
	<table style="padding:5px 10px;">
		<tr>
			<td></td>
		</tr>
		$filaObservaciones
		$filaDespacho
		<tr>
			<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
			<td style="font-size:13px; background-color:white; width:390px; text-align:left">$respuestaVenta[metodo_pago]</td>
		</tr>
	</table>
EOF;
}else if($respuestaVenta['tipo_pago']=="E_TC" || $respuestaVenta['tipo_pago']=="E_TD"){
$bloque6 = <<<EOF
	<table style="padding:5px 10px;">
		<tr>
			<td></td>
		</tr>
		$filaObservaciones
		$filaDespacho
		<tr>
			<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
			<td style="font-size:13px; background-color:white; width:390px; text-align:left">SE PAGÓ CON PAGO COMBINADO</td>
		</tr>
	</table>
EOF;
}else if($respuestaVenta['tipo_pago']=="Fiado"){
$bloque6 = <<<EOF
	<table style="padding:5px 10px;">
		<tr>
			<td></td>
		</tr>
		$filaObservaciones
		$filaDespacho
		<tr>
			<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
			<td style="font-size:13px; background-color:white; width:390px; text-align:left">CRÉDITO INTERNO</td>
		</tr>
	</table>
EOF;
}else if($respuestaVenta['tipo_pago']=="Pend"){
$bloque6 = <<<EOF
	<table style="padding:5px 10px;">
		<tr>
			<td></td>
		</tr>
		$filaObservaciones
		$filaDespacho
		<tr>
			<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
			<td style="font-size:13px; background-color:white; width:390px; text-align:left">COBRAR EN REPARTO</td>
		</tr>
	</table>
EOF;
}


$pdf->writeHTML($bloque6, false, false, false, false, '');
// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 
// ---------------------------------------------------------
if($_GET['motivo']=='descarga'){
	if($respuestaVenta["id_cliente"]==0){
		$pdf->Output('Detalle Venta Nro.'.$respuestaVenta["cod_venta"].'.pdf', 'D');
	}else{
		if($respuestaCliente['id']!=1){
			$pdf->Output('Detalle Venta Nro. '.$respuestaVenta["cod_venta"].' a '.$respuestaCliente['nombre'].' '.$respuestaCliente['apellido'].'.pdf', 'D');
		}else{
			$pdf->Output('Detalle Venta Nro.'.$respuestaVenta["cod_venta"].'.pdf', 'D');
		}
	}
}else if($_GET['motivo']=='ver'){
	if($respuestaVenta["id_cliente"]==0){
		$pdf->Output('Detalle Venta Nro.'.$respuestaVenta["cod_venta"].'.pdf');
	}else{
		if($respuestaCliente['id']!=1){
			$pdf->Output('Detalle Venta Nro. '.$respuestaVenta["cod_venta"].' a '.$respuestaCliente['nombre'].' '.$respuestaCliente['apellido'].'.pdf');
		}else{
			$pdf->Output('Detalle Venta Nro.'.$respuestaVenta["cod_venta"].'.pdf');
		}
	}
}

}

}

$boletaCarta = new imprimirVenta();
// $boletaCarta -> codigo = $_GET["codigo"];
$boletaCarta -> traerImpresionVenta();

?>