<?php
class ControladorProductos{

	static public function ctrCargarFilaProdAdmin($id){

        $sucursal = $_SESSION['sucursal'];
        $item = "estado_".$sucursal;
        $valor = 1;
        $orden = "fecha_modif_".$sucursal;
        $productos = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);
        


        $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
        $nombre_y_alias = array();
        $locales = array();
            
        foreach ($sucursales as $key => $value){
            if($value['nombre_sucursal'] != $sucursal){
                array_push($nombre_y_alias, $value["nombre_sucursal"]); 
                array_push($nombre_y_alias, $value["alias_sucursal"]);
                array_push($locales, $nombre_y_alias);
                $nombre_y_alias = array(); // vaciamos array
            }
        }   


        $datosJson = '{"data": [';
        $productoFila = ModeloProductos::mdlMostrarProducto('productos', 'id', $id);

        $descripcionESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productoFila["descripcion"]);
        $descripcion2ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productoFila["descripcion2"]);
        $descripcion2 = $descripcion2ESCAPE == '' ? '+ Nombre Alternativo ' : $descripcion2ESCAPE;
        $descSII_ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productoFila["desc_sii"]);

        $imagen = "<img id='imagenZoom' src='".$productoFila["imagen"]."' alt='".$descripcionESCAPE."' class='imagenZoom' width='40px' idProducto='".$productoFila["id"]."' data-toggle='modal' data-target='#modalZoomProducto'>";

        $idCodigos = 'codigos'.$productoFila["id"];
        if($productoFila["cod_proveedor"]!=''){
            $codProveedor = "<i>PROV (<b>".$productoFila["cod_proveedor"]."</b>)</i><br><b class='listaProvs' idProd='".$productoFila['id']."'>".strtoupper($productoFila['nom_prov'])."</b>";
        }else{                  
            $codProveedor = "<b class='listaProvs' idProd='".$productoFila['id']."'>".strtoupper($productoFila['nom_prov'])."</b>";
        }

        // EMBALAJE
        $embalajeCompra = "<br><br><div class='embalajeCompra' idProd='".$productoFila['id']."' embalajeCompra='".$productoFila['embalaje_compra']."'><font>Embalaje: <b>".number_format($productoFila['embalaje_compra'],0,',','.')."</b>u</font></div>";

        $sku = $productoFila["categoria"] <= 9 ? '0'.$productoFila["sku"] : $productoFila["sku"];

        if($productoFila['maneja_stock'] == 'NO'){
        	$ubicacion = '';
        }else{
        	$ubicacion = $productoFila["zona_".$sucursal] == null ? '' : strtoupper($productoFila["zona_".$sucursal])."-";
        }
        // $ubicacion = $productoFila['maneja_stock'] == 'NO' ? '' : strtoupper($productoFila["zona_".$sucursal])."-";


        $btnEditUbic = $productoFila['maneja_stock'] == 'NO' ? '' : " <i style='color:rgb(224,142,11)' class='fa fa-pen btnEditUbic' idProducto='".$productoFila["id"]."' codInt='".$productoFila["sku"]."' prov='".$productoFila["cod_proveedor"]."' ubic='".$productoFila["zona_".$sucursal]."' codBar='".$productoFila["codigo"]."'></i>";
        $codigos = "<div id=".$idCodigos."><b>".$ubicacion.$sku."</b>".$btnEditUbic."<br>".$productoFila["codigo"]."<br>".$codProveedor.$embalajeCompra."</div>";

        // STOCK CON COLORES DINAMICO 
        $stock = $productoFila["stock_".$sucursal];
        $stockIdeal = $productoFila['stock_ideal_'.$sucursal];
        if($stock <= $stockIdeal/3){
            $estado_stock = 1;
        }else if($stock > $stockIdeal/3 && $stock <= $stockIdeal*2/3){
            $estado_stock = 2;
        }else{
            $estado_stock = 3;
        }



        $descuento = "<b>".$productoFila["descuento"]." %</b>";

        $agotado = ($stock == 0 && $productoFila["maneja_stock"] == 'SI') ? "<span style='z-index:1; height:40px' class='float-right-container'><small class='label bg-red'>AGOTADO</small></span><br>" : "";
        $oferta = ($productoFila['mayor_sobre'] == 1 && $productoFila["maneja_stock"] == 'SI') ? "<span style='z-index:1; height:40px' class='float-right-container'><small class='label bg-success'>EN OFERTA</small></span><br>" : "";

        $descripcion = "<font size='+1'><b class='editNameProd' idProd='".$productoFila['id']."'>".$descripcionESCAPE."</b></font><br><font size='-1' class='editNameAltProd' idProd='".$productoFila['id']."'>".$descripcion2."</font>";         
        $descripcionSII = strlen($descSII_ESCAPE) <= 25 ? "<b>SII:</b><br><font color='blue' class='editDescSII' idProd='".$productoFila['id']."'>".$descSII_ESCAPE."</font>" : "<b>SII:</b><br><font color='white' class='editDescSII' idProd='".$productoFila['id']."'>".$descSII_ESCAPE."</font>"; // filtro de color si supera los 25 caracteres
        $bg_desc_sii = strlen($descSII_ESCAPE) <= 25 ? "" : "bg-danger";



        $descripcionCompleta =  "<div class='d-none d-lg-block' id='descripcionProd".$productoFila['id']."'>".$descripcion."</div><hr>".
                                "<div id='descripcionSII".$productoFila['id']."'>".
                                    "<div class='".$bg_desc_sii."'>".
                                        "<div class='d-none d-lg-block'>".$descripcionSII."</div>".
                                    "</div>".
                                "</div>";
        
        // PRECIO VENTA
        $idPVenta = 'pVenta'.$productoFila["id"];

        if($productoFila["maneja_stock"]=="SI" && $productoFila['mayor_sobre'] != 1){ // MANEJA STOCK Y SIN OFERTA
            $precioVenta = 
            "<div id=".$idPVenta.">".
                "<div class='btnEditPVenta' idProd='".$productoFila['id']."'><b>VENTA</b><br>".
                    "$ ".number_format($productoFila["precio_venta"], 0, ',', '.')."<br>".
                    "<font style='color:blue'><b>&uarr;".$productoFila["mayor_sobre"]."u $ ".number_format($productoFila["precio_mayor"],0,',','.')."</b><br></font>".
                    "<font size='-1'>MAX DCTO: ".$productoFila["descuento"]."%</font></font><br>". 
                "</div>".
                "<div class='btn-group float-right'>".
                    "<button class='btn btn-default btn-xs btnMayDesdMenos info' data-original-title='Bajar Mayoreo' idProd='".$productoFila["id"]."'>&darr;</button>".
                    "<button class='btn btn-default btn-xs btnMayDesdMas info' data-original-title='Subir Mayoreo' idProd='".$productoFila["id"]."'>&uarr;</button>".
                "</div>".
            "</div>";
        }else if($productoFila["maneja_stock"]=="SI" && $productoFila['mayor_sobre'] == 1){ // OFERTA
            $precioVenta = 
            "<div id=".$idPVenta.">".
                "<div class='btnEditPVenta' idProd='".$productoFila['id']."'><b>VENTA</b><br>".
                    "<strike>Antes: $ ".number_format($productoFila["precio_venta"], 0, ',', '.')."</strike><br>".
                    "<b class='text-danger'>Ahora: $ ".number_format($productoFila["precio_mayor"],0,',','.')."</b>".
                "</div>".
                "<div class='btn-group float-right'>".
                    "<button class='btn btn-info btn-xs finalizarOferta info' data-original-title='Finalizar Oferta' idProd='".$productoFila["id"]."'>Finalizar Oferta</button>".
                "</div>".
            "</div>";


        }else{ // PROD VIRTUAL
            $precioVenta = "Precio Estimado <b>$ ".number_format($productoFila["precio_venta"], 0, ',', '.')."</b>";
        }

        // PRECIO COMPRA
        $idPCompra = 'pCompra'.$productoFila["id"];
        if($productoFila["maneja_stock"]=="SI"){   // MANEJA STOCK Y SIN OFERTA
            $decimalesNeto = strpos(strval($productoFila['pc_neto']), '.') !== false ? 2 : 0;
            $precioCompra = 
            "<div  id=".$idPCompra.">".
                "<div class='editPCompraProd' idProd='".$productoFila['id']."'>".
                    "<font size='-1'>".
                        "<p style='color:rgb(128,139,150)'>COMPRA<br>".
                        "<b>$".number_format($productoFila["pc_neto"],$decimalesNeto,',','.')." / $".number_format($productoFila["precio_compra"],0,',','.')."</b></p>".
                    "</font>".
                "</div>".
            "</div>".
            "<hr>";
        }else{
            $precioCompra = "";
        }

        $preciosVista = $precioCompra.$precioVenta;


        //GENERA LEYENDA QUE APARECE EN TOOLTIP CUANDO HAY STOCK >0 EN OTRAS SUCURSALES
        $stockOtrosLocales = '';
        for ($i_1=0; $i_1 < count($locales); $i_1++){
            if($productoFila['stock_'.$locales[$i_1][0]] > 0){
                $stockOtrosLocales .= strtoupper($locales[$i_1][0])." (".$productoFila['zona_'.$locales[$i_1][0]].") &rarr; ".number_format($productoFila['stock_'.$locales[$i_1][0]],0,',','.')."u&#10;"; // EJ. BODEGA1 (C17N5) -> 1000u
            } 
        }

        if($stockOtrosLocales == ''){
            $stockOtrasSucursales = '';
        }else{
            $stockOtrasSucursales = "<button style='color:white; background-color:purple' class='btn btn-xs stockBodega info mb-1' data-original-title='".$stockOtrosLocales."'>OTROS LOCALES</button>";
        }

        // STOCK
        $idStock = 'stkVis'.$productoFila["id"];
        $btnBajaStock = 'btnRestStock'.$productoFila["id"];
        $btnSubeStock = 'btnSumStock'.$productoFila["id"];
        $btnBajaIdeal = 'btnBajarStkIdeal'.$productoFila["id"];
        $btnSubeIdeal = 'btnSubirStkIdeal'.$productoFila["id"];

        if($stock < $stockIdeal/3){
            $color = 'danger';
        }else if($stock >= $stockIdeal/3 && ($stock < (2*$stockIdeal/3))){
            $color = 'warning';
        }else{
            $color = 'success';
        }

        // CONTROL INVENTARIO
        $mostrarControl = ['A Pedido','Primera Prioridad','Controlar Inventario'];
        $colorControl = ['','bg-success','bg-primary'];
        $claveArray = $productoFila['control_inventario'];
        $opciones = "<option value='".$claveArray."'>".$mostrarControl[$claveArray]."</option>";
        for($ia=0;$ia<count($mostrarControl);$ia++){
            if($ia != $claveArray){ // CARGA TODOS LOS DEMAS ELEMENTOS
                $opciones .= "<option value='".$ia."'>".$mostrarControl[$ia]."</option>";
            }
        }
        $selectControlInventario = "<select style='font-size:13px' class='form-control info controlInvetario ".$colorControl[$claveArray]."' id='controlInvetario".$productoFila["id"]."' idProd='".$productoFila["id"]."' data-original-title='CONTROL INVENTARIO?' data-placement='bottom'>".$opciones."</select>";
        $controlInventario = $productoFila["transformable"] == 2 ? "" : $selectControlInventario;

        // ZONA ENTREGA PRODUCTO
        $zonaEntregaProd = ['patio','local'];
        $claveEntregaProd = $productoFila['zona_prod'];
        $opcionesEntregaProd = "<option value='".$claveEntregaProd."'>".strtoupper($zonaEntregaProd[array_search($claveEntregaProd, $zonaEntregaProd)])."</option>";
        for($ib=0;$ib<count($zonaEntregaProd);$ib++){
            if($zonaEntregaProd[$ib] != $claveEntregaProd){ // CARGA TODOS LOS DEMAS ELEMENTOS
                $opcionesEntregaProd .= "<option value='".$zonaEntregaProd[$ib]."'>".strtoupper($zonaEntregaProd[$ib])."</option>";
            }
        }
        $selectEntregaProd = "<br><label for='entregaProd'>Entrega:</label><select style='font-size:13px' class='form-control info entregaProd' id='entregaProd".$productoFila["id"]."' idProd='".$productoFila["id"]."' data-original-title='CONTROL INVENTARIO?' data-placement='bottom'>".$opcionesEntregaProd."</select>";

        $btnCheckStock = 'btnCheckStock'.$productoFila["id"];
        if($productoFila['check_stock_'.$sucursal] == 0 && $productoFila['maneja_stock'] == 'SI'){
            $historial_check = "<div><button class='btn btn-info historialProducto info' data-original-title='Ver Historial' idProd='".$productoFila['id']."'><i class='fa fa-history'></i></button></div><div style='height:3px'></div><div id=".$btnCheckStock."><button class='btn btn-warning info' data-original-title='Checkear Stock' onclick='checkeoStock(".$productoFila['id'].")' idProd='".$productoFila['id']."'><i class='fa fa-check-square'></i></button></div>";
        }else{
            $historial_check = "<div><button class='btn btn-info historialProducto info' data-original-title='Ver Historial' idProd='".$productoFila['id']."'><i class='fa fa-history'></i></button></div>";               
        }

        $botonesVariarIdeal = $sucursal == 'bodega1' ? "" : "<font style='font-size:10px'>STOCK IDEAL</font><div class='btn-group float-right botonesStkIdeal'><button class='btn btn-default btn-xs btnBajarStkIdeal info' data-original-title='Bajar Ideal' id=".$btnBajaIdeal." stockActual='".$productoFila['stock_'.$sucursal]."' stkIdeal='".$productoFila['stock_ideal_'.$sucursal]."' idProd='".$productoFila["id"]."'>&darr;</button><button class='btn btn-default btn-xs btnSubirStkIdeal info' data-original-title='Subir Ideal' id=".$btnSubeIdeal." stockActual='".$productoFila['stock_'.$sucursal]."' stkIdeal='".$productoFila['stock_ideal_'.$sucursal]."' idProd='".$productoFila["id"]."'>&uarr;</button></div>";

        if($productoFila["maneja_stock"]=="SI"){
            $stock_vista = "<div id=".$idStock." class='btn-group'><button class='btn btn-default btnRestStock info' data-original-title='-1' id=".$btnBajaStock." ideal='".$productoFila["stock_ideal_".$sucursal]."' idProd='".$productoFila["id"]."'>&darr;</button><button style='text-align:right' class='btn btn-".$color." stockVista' stk='".$stock."' ideal='".$productoFila["stock_ideal_".$sucursal]."' idProd='".$productoFila["id"]."' style='width:50px'>".$stock."/".$stockIdeal."</button><button class='btn btn-default btnSumStock info' data-original-title='+1' id=".$btnSubeStock." ideal='".$productoFila["stock_ideal_".$sucursal]."' idProd='".$productoFila["id"]."'>&uarr;</button></div><div style='height:3px'></div>".$botonesVariarIdeal."<div style='height:3px'></div>".$stockOtrasSucursales.$controlInventario.$selectEntregaProd;
        }else{
            $stock_vista = "<div class='btn-group'><button class='btn btn-info'><font size='+1'>&infin;</font></button></button></div>";        
        }


        // BOTONES
        if($productoFila["estado_".$sucursal] != 0){
            $btnActProd = "<button class='btn btn-success btn-xs btnActProd info' data-original-title='Desactivar' idProd='".$productoFila['id']."' estadoProd='0'>Activado</button>";
        }else{
            $btnActProd = "<button class='btn btn-warning btn-xs btnActProd info' data-original-title='Activar' idProd='".$productoFila['id']."' estadoProd='1'>Desactivado</button>";
        }
        $botones =  "<div class='btn-group'><button class='btn btn-warning btnEditarProducto info' data-original-title='Editar' idProducto='".$productoFila["id"]."' data-toggle='modal' data-target='#modalEditarProducto'><i class='fa fa-pen'></i></button><button class='btn btn-danger btnEliminarProducto info' data-original-title='Eliminar' idProducto='".$productoFila["id"]."' codigo='".$productoFila["codigo"]."' imagen='".$productoFila["imagen"]."'><i class='fa fa-times'></i></button></div>"; 
        $cats = $agotado.$oferta.'<b>'.$productoFila["cat_nom"].'</b><br>'.$productoFila["subcat_nom"];

        $idFecha = 'fecha'.$productoFila["id"];
        $fechaModificacion = "<div id=".$idFecha." class='btn-group'>".$productoFila["fecha_modif_".$sucursal]."</div>";
        

        $columna1 = "<div>".
                        "<div class='d-none d-lg-block'>".($key+1)."</div>".
                    "</div>";
        $columna2 = "<div>".
                        "<div class='d-none d-lg-block'>".$imagen."</div>".
                    "</div><br>[ID: ".$productoFila["id"]."]";
        $columna3 = "<div>".
                        "<div class='d-none d-lg-block'>".$cats."</div>".
                    "</div>";



        $idRelacion = 'relacion'.$productoFila['id'];
        if($productoFila['prods_relacionados'] == ''){
            $columna5 = "<div id='".$idRelacion."'><button type='button' class='btn btn-primary btn-circle btn-sm relacionarProd info' data-original-title='Relacionar' idProd='".$productoFila['id']."'><i class='fas fa-plus'></i></button></div>";
        }else{
            $arrayRelacionados = explode(',',$productoFila['prods_relacionados']);
            $listaProdsRelacionados = '';
            for ($i=0; $i < count($arrayRelacionados); $i++){
                $infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $arrayRelacionados[$i]);
                $listaProdsRelacionados .= $infoProd['desc_sii']."<button type='button' class='btn btn-danger btn-circle btn-sm quitarRelacion info float-right' data-original-title='Quitar Relación' idProdRelacionado='".$arrayRelacionados[$i]."' idProd='".$productoFila['id']."'><i class='fas fa-minus'></i></button><br>";
            }

            $columna5 = "<div id='".$idRelacion."'>".$listaProdsRelacionados.
                            "<button type='button' class='btn btn-primary btn-circle btn-sm relacionarProd info' data-original-title='Relacionar' idProd='".$productoFila['id']."'><i class='fas fa-plus'></i></button>".
                        "</div>";
        }
        $columna6 = "<div>".
                        "<div class='d-none d-lg-block'>".$codigos."</div>".
                    "</div>";
        $columna7 = "<div>".
                        "<div class='d-none d-lg-block'>".$stock_vista."</div>".
                    "</div>";
        $columna8 = "<div>".
                        "<div class='d-none d-lg-block'>".$historial_check."</div>".
                    "</div>";
        $columna9 = "<div>".
                        "<div class='d-none d-lg-block'>".$preciosVista."</div>".
                    "</div>";

        // MARGEN
        if($productoFila["maneja_stock"]=="SI"){// MANEJA STOCK Y SIN OFERTA
            
            $margenPesosPNormal = "$ ".number_format($productoFila["precio_venta"]-$productoFila['precio_compra'],0,',','.');
            $margenPesosPMayor = "$ ".number_format($productoFila["precio_mayor"]-$productoFila['precio_compra'],0,',','.');
            $margenPorcentajePNormal = round((($productoFila["precio_venta"]/$productoFila['precio_compra'])-1)*100,2)."%";
            $margenPorcentajePMayor = round((($productoFila["precio_mayor"]/$productoFila['precio_compra'])-1)*100,2)."%";

            $margen = 
            "<div>".
                "<font size='-1'>".
                    "<p style='color:rgb(128,139,150)'>Dinero<br>".
                    "<b>".$margenPesosPNormal."  /  ".$margenPesosPMayor."</b></p><hr>".
                    "<p style='color:rgb(128,139,150)'>Porcentual<br>".
                    "<b>".$margenPorcentajePNormal."  /  ".$margenPorcentajePMayor."</b>".
                "</font>".
            "</div>";
        }else{
            $margen = "";
        }

        $columna10 = "<div>".
                        "<div class='d-none d-lg-block'>".$margen."</div>".
                    "</div>";
        $columna11 = "<div>".
                        "<div class='d-none d-lg-block'>".$fechaModificacion."</div>".
                    "</div>";
        $columna12 = "<div>".
                        "<div class='d-none d-lg-block'>".$btnActProd."</div>".
                    "</div>";
        $columna13 = "<div>".
                        "<div class='d-none d-lg-block'>".$botones."</div>".
                    "</div>";


        $datosJson .='[
              "'.$productoFila['id'].'",
              "'.$columna1.'",
              "'.$columna2.'",
              "'.$columna3.'",
              "'.$descripcionCompleta.'",
              "'.$columna5.'",
              "'.$columna6.'",
              "'.$columna7.'",
              "'.$columna8.'",
              "'.$columna9.'",
              "'.$columna10.'",
              "'.$columna11.'",
              "'.$columna12.'",
              "'.$columna13.'"
            ],';


        $datosJson = substr($datosJson, 0, -1);

        $datosJson .=   ']}';

        return $datosJson;

	}

	static public function ctrMostrarRetiroProductos($item, $valor, $orden){
		$tabla = "retiro_productos";
		$respuesta = ModeloProductos::mdlMostrarRetiroProductos($tabla, $item, $valor, $orden);
		return $respuesta;
	}

	/*=============================================
	MOSTRAR INVERSION
	=============================================*/
	static public function ctrMostrarInversion($item1, $item2){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarInversion($tabla, $item1, $item2);
		return $respuesta;
	}

	/*=============================================
	MULTIPLICAR 2 COINCIDENCIA 1
	=============================================*/
	static public function ctrMultiplicar2Coincidir1($item1, $item2, $item3, $valor3){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMultiplicar2Coincidir1($tabla, $item1, $item2, $item3, $valor3);
		return $respuesta;
	}

	/*=============================================
	MOSTRAR TOTAL PEDIDO
	=============================================*/
	static public function ctrMostrarTotalPedido($item_1, $valor_1, $item_2, $valor_2, $item_3, $valor_3, $item_4, $item_5){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarTotalPedido($tabla, $item_1, $valor_1, $item_2, $valor_2, $item_3, $valor_3, $item_4, $item_5);
		return $respuesta;
	}

	/*=============================================
	MOSTRAR 1 PRODUCTO
	=============================================*/
	static public function ctrMostrarProducto($item, $valor){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarProducto($tabla, $item, $valor);
		return $respuesta;
	}

	/*=============================================
	MOSTRAR PRODUCTOS COTIZACION
	=============================================*/
	static public function ctrMostrarProductosCotizacion($item, $valor, $orden){
		$tabla = "productos_cotizacion";
		$respuesta = ModeloProductos::mdlMostrarProductosCotizacion($tabla, $item, $valor, $orden);
		return $respuesta;
	}

	static public function ctrMostrarProductosCotizacion1($item, $valor, $orden){
		$tabla = "productos_cotizacion";
		$respuesta = ModeloProductos::mdlMostrarProductosCotizacion1($tabla, $item, $valor, $orden);
		return $respuesta;
	}

	/*=============================================
	MOSTRAR PRODUCTOS MAS VENDIDOS
	=============================================*/
	static public function ctrMostrarProductosMasVendidos($item, $valor, $motivo, $orden){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarProductosMasVendidos($tabla, $item, $valor, $motivo, $orden);
		return $respuesta;
	}

	/*=============================================
	MOSTRAR PRODUCTOS
	=============================================*/
	static public function ctrMostrarProductos($item, $valor, $orden){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarProductos($tabla, $item, $valor, $orden);
		return $respuesta;
	}

	static public function ctrMostrarProductos1($item, $valor, $orden){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarProductos1($tabla, $item, $valor, $orden);
		return $respuesta;
	}	

	static public function ctrMostrarProductos1_orden2($item, $valor, $orden1, $orden2){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarProductos1_orden2($tabla, $item, $valor, $orden1, $orden2);
		return $respuesta;		
	}

	static public function ctrMostrarProductos2($item1, $valor1, $item2, $valor2, $orden){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarProductos2($tabla, $item1, $valor1, $item2, $valor2, $orden);
		return $respuesta;
	}	

	static public function ctrMostrarProductosPedido3($item_1, $valor_1, $item_2, $valor_2, $item_3, $valor_3, $orden){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarProductosPedido3($tabla, $item_1, $valor_1, $item_2, $valor_2, $item_3, $valor_3, $orden);
		return $respuesta;
	}	

	static public function ctrMostrarProductos3($item1, $valor1, $item2, $valor2, $item3, $valor3, $orden){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarProductos3($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $orden);
		return $respuesta;
	}		

	static public function ctrMostrarProductos4($item1, $valor1, $item2, $valor2, $item3, $valor3, $item4, $valor4, $orden){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarProductos4($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $item4, $valor4, $orden);
		return $respuesta;
	}		

	/*=============================================
	MOSTRAR PRODUCTOS
	=============================================*/
	static public function ctrMostrarProductosFaltantes($item, $valor, $orden){
		$tabla = "productos_faltantes";
		$respuesta = ModeloProductos::mdlMostrarProductosFaltantes($tabla, $item, $valor, $orden);
		return $respuesta;
	}

	static public function ctrMostrarAbastecimiento($item, $valor, $orden, $crit1, $valorCrit1){
		$tabla = "productos";
		$respuesta = ModeloProductos::mdlMostrarAbastecimiento($tabla, $item, $valor, $orden, $crit1, $valorCrit1);
		return $respuesta;
	}

	/*=============================================
	SELECCIONAR ITEM TABLA PRODUCTOS
	=============================================*/
	static public function ctrSeleccionarItem($tabla, $item, $item_coincidencia, $valor){
		$respuesta = ModeloProductos::mdlSeleccionarItem($tabla, $item, $item_coincidencia, $valor);
		return $respuesta["item"];
	}	

	/*=============================================
	CREAR PRODUCTO
	=============================================*/
	static public function ctrCrearProducto($pagina){
		
		if(isset($_POST["nuevaDescripcion"])){
			$tabla = "productos";
			$subCodInterno = $_POST["codigoInterno2"];				
			// codigo interno CORRELATIVO sin zona 
			$item="ult_sub_cod_int";
			$item_coincidencia = "sub_cod_int";
			$valor = $subCodInterno;
            $ultimoSubCod1 = ControladorProductos::ctrSeleccionarItem($tabla, $item, $item_coincidencia, $valor);
			//crea nro correlativo cuando conincide la categoria y la subcategoria 
             if($ultimoSubCod1>=10){
                $ultimoSubCod = $ultimoSubCod1+1;
             }else{
                $ultimoSubCod = str_pad($ultimoSubCod1+1, 2, "0", STR_PAD_LEFT); //anteponer cero si es menor que 10
             }

             $codIntSinZona = $subCodInterno.$ultimoSubCod; // crea codigo interno sin zona

             //codigo de barra, si no hay codigo de barra asigna("sinCog(codigointerno)")
			$codigo =  $_POST["nuevoCodigo"];
			if($codigo == "" || $codigo =="-"){
				$codigoFinal = "sinCOD(".$codIntSinZona.")";
			}else{
				$codigoFinal = $codigo;
			}

			/*=============================================
			SI NO MANEJA STOCK
			=============================================*/
			if($_POST["manejaStock"] == 'NO'){
				$stockIdeal	= 0;
				$embalajeCompra = 0;
				$zonaEntrega = '';
			}else{
				$stockIdeal	= $_POST["stockIdeal"];
				$embalajeCompra = $_POST["embalajeCompraProd"];
				$zonaEntrega = $_POST["zonaEntregaProd"];
			}

	   		/*=============================================
			VALIDAR IMAGEN
			=============================================*/
			$ruta = "componentes/img/productos/default/anonymous.png"; // Imagen por defecto

			if (!empty($_FILES["nuevaImagen"]["tmp_name"])) {
			    $archivoTemporal = $_FILES["nuevaImagen"]["tmp_name"];
			    
			    // Verificar si es una imagen válida antes de llamar a getimagesize()
			    if (@getimagesize($archivoTemporal)) {
			        list($ancho, $alto) = getimagesize($archivoTemporal);
			        $nuevoAncho = 500;
			        $nuevoAlto = 500;

			        /*================================================
			        CREAMOS EL DIRECTORIO DONDE ALMACENAREMOS IMÁGENES
			        =================================================*/
			        $carpetaCatSubcat = "componentes/img/productos/".$subCodInterno;
			        if (!file_exists($carpetaCatSubcat)) {
			            mkdir($carpetaCatSubcat, 0755, true);
			        }

			        /*=============================================
			        PROCESAMOS SEGÚN EL TIPO DE IMAGEN
			        =============================================*/
			        $tipoImagen = $_FILES["nuevaImagen"]["type"];
			        $nombreArchivo = $carpetaCatSubcat."/".$codIntSinZona;

			        if ($tipoImagen == "image/jpeg") {
			            $ruta = $nombreArchivo.".jpg";
			            $origen = imagecreatefromjpeg($archivoTemporal);
			            $destino = imagecreatetruecolor($nuevoAncho, $nuevoAlto);
			            imagecopyresized($destino, $origen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $ancho, $alto);
			            imagejpeg($destino, $ruta);
			        } elseif ($tipoImagen == "image/png") {
			            $ruta = $nombreArchivo.".png";
			            $origen = imagecreatefrompng($archivoTemporal);
			            $destino = imagecreatetruecolor($nuevoAncho, $nuevoAlto);
			            imagecopyresized($destino, $origen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $ancho, $alto);
			            imagepng($destino, $ruta);
			        } else {
			            // Si el tipo de imagen no es válido, se mantiene la imagen por defecto
			            $ruta = "componentes/img/productos/default/anonymous.png";
			        }
			    } else {
			        // Si el archivo no es una imagen válida, usar la imagen por defecto
			        $ruta = "componentes/img/productos/default/anonymous.png";
			    }
			}

			$idCat = $_POST["nuevaCategoria"];
			$nomCat = ModeloCategorias::mdlMostrarCategorias('categorias', 'id', $idCat)['categoria'];

			$idSubcat = $_POST["nuevaSubcategoria"];
            $nomSubcat = ControladorCategorias::ctrSeleccionarSubcategoria1('subcategorias', 'id_subcategoria', $idSubcat, 'categoria_padre', $idCat)['subcategoria'];

            // echo $nomCat.'<br>'.$nomSubcat;

		    $arrayListaJson = [];
    		$provJson = ["prov" => $_POST["proveedorProducto"], "cod_prov" => $_POST["codigoProveedor"], "pc_neto" => $_POST["nuevoPrecioCompraNeto"]];
		    $arrayListaJson[] = $provJson;
			$jsonProvProd = json_encode(array_values($arrayListaJson));

			$aliasEmpresa = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'alias_nombre_comercial')['ajuste'];


			// datos para mysql
			$datos = array("nom_prov" => $_POST["provProdDB"],
						   // "propietario" => $aliasEmpresa,
						   "prods_relacionados" => "",
						   "id_trab" => $_SESSION['id'],
						   "nom_trab" => $_SESSION['nombre'],
						   "categoria" => $idCat,
						   "cat_nom" => $nomCat,
						   "subcategoria" => $idSubcat,
						   "subcat_nom" => $nomSubcat,
						   "proveedor" => $_POST["proveedorProducto"],
						   "lista_proveedores" => $_POST["proveedorProducto"],
						   "lista_provs_json" => $jsonProvProd,
						   "sub_cod_int" => $subCodInterno,
						   "sku" => $codIntSinZona,
						   "codigo" => $codigoFinal,
						   "cod_proveedor" => $_POST["codigoProveedor"],
						   "descripcion" => $_POST["nuevaDescripcion"],
						   "descripcion2" => $_POST["descripcionAlternativa"],
						   "desc_sii" => $_POST["descripcionSii"],
						   "ult_sub_cod_int" => $ultimoSubCod,
						   "maneja_stock" => $_POST["manejaStock"],
						   "embalaje_compra" => $embalajeCompra,
						   "zona_prod" => $zonaEntrega,
						   "precio_compra" => $_POST["nuevoPrecioCompra"],
						   "pc_neto" => $_POST["nuevoPrecioCompraNeto"],
						   "precio_venta" => $_POST["nuevoPrecioVenta"],
						   "descuento" => $_POST["descuentoMaximo"],
						   "mayor_sobre" => $_POST["mayoreo"],
						   "precio_mayor" => $_POST["precioMayor"],
						   "imagen" => $ruta,
						   "stock_ideal_local1" => $stockIdeal,
						   "estado_local1" => 1);

			$respuesta = ModeloProductos::mdlIngresarProducto($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

					Swal.fire({
						icon: "success",
						title: "El producto ha sido guardado correctamente",
						showConfirmButton: true,
						confirmButtonText: "Cerrar",
						focusConfirm: true
						}).then(function(result){
									if (result.value) {

									window.location = "'.$pagina.'";

									}
								})

					</script>';

			}
			
		}

	}	

	/*=============================================
	EDITAR PRODUCTO
	=============================================*/
	static public function ctrEditarProducto($pagina){
		$sucursal = $_SESSION['sucursal'];
		if(isset($_POST["editarDescripcion"])){
			$tabla = "productos";		
	   		/*=============================================
			VALIDAR IMAGEN
			=============================================*/
		   	$ruta = $_POST["imagenActual"];
		   	if(isset($_FILES["editarImagen"]["tmp_name"]) && !empty($_FILES["editarImagen"]["tmp_name"])){
				list($ancho, $alto) = getimagesize($_FILES["editarImagen"]["tmp_name"]);
				$nuevoAncho = 500;
				$nuevoAlto = 500;
				/*====================================================
				VERIFICAMOS EL DIRECTORIO DONDE ALMACENAREMOS IMAGENES
				====================================================*/
				$directorio = "componentes/img/productos/".substr($_POST["editarCodigoInterno"],0,4);
				if(file_exists($directorio) && $_POST["imagenActual"] != "componentes/img/productos/default/anonymous.png"){
					unlink($_POST["imagenActual"]);
				}else{						
					mkdir($directorio, 0755);
				}
				/*=============================================
				DE ACUERDO AL TIPO DE IMAGEN APLICAMOS LAS FUNCIONES POR DEFECTO DE PHP
				=============================================*/
				if($_FILES["editarImagen"]["type"] == "image/jpeg"){
					/*=============================================
					GUARDAMOS LA IMAGEN EN EL DIRECTORIO
					=============================================*/
					$ruta = $directorio."/".$_POST["editarCodigoInterno"].".jpg";
					$origen = imagecreatefromjpeg($_FILES["editarImagen"]["tmp_name"]);				
					$destino = imagecreatetruecolor($nuevoAncho, $nuevoAlto);
					imagecopyresized($destino, $origen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $ancho, $alto);
					imagejpeg($destino, $ruta);
				}
				if($_FILES["editarImagen"]["type"] == "image/png"){
					/*=============================================
					GUARDAMOS LA IMAGEN EN EL DIRECTORIO
					=============================================*/
					$ruta = $directorio."/".$_POST["editarCodigoInterno"].".png";
					$origen = imagecreatefrompng($_FILES["editarImagen"]["tmp_name"]);						
					$destino = imagecreatetruecolor($nuevoAncho, $nuevoAlto);
					imagecopyresized($destino, $origen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $ancho, $alto);
					imagepng($destino, $ruta);
				}
			}


			if($_SESSION['perfil'] == 'Administrador'){

				if($_POST["editarManejaStock"] == 'NO'){
					$stockIdeal	= 0;
					$embalajeCompra = 0;
					$zonaEntrega = '';
				}else{
					$stockIdeal	= $_POST["editarStockIdeal"];
					$embalajeCompra = $_POST["editarEmbalajeCompraProd"];
					$zonaEntrega = $_POST["editarZonaEntregaProd"];
				}

				// FECHA MODIFICACION PRODUCTO SEGUN LOCAL

				$datos = array( "descripcion" => $_POST["editarDescripcion"],
							    "descripcion2" => $_POST["nombreAlternativo"],
							    "desc_sii" => $_POST["editarDescSii"],
							    "codigo" => $_POST["idProductoEditar"],
							    "cod_proveedor" => $_POST["codigoProveedorEditar"],
							    "proveedor" => $_POST["editarProveedorProducto"],
							    "nom_prov" => $_POST["nomProvEdit"],
							    "id_trab" => $_SESSION['id'],
							    "nom_trab" => $_SESSION['nombre'],
							    "maneja_stock" => $_POST["editarManejaStock"],
							    "embalaje_compra" => $embalajeCompra,
							    "zona_prod" => $zonaEntrega,
							    "descuento" => $_POST["editarDescuentoMaximo"],
							    "precio_compra" => $_POST["editarPrecioCompra"],
							    "pc_neto" => $_POST["editarPrecioCompraNeto"],
							    "precio_venta" => $_POST["editarPrecioVenta"],
							    "mayor_sobre" => $_POST["editarMayoreo"],
							    "precio_mayor" => $_POST["editarPrecioMayor"],
							    "imagen" => $ruta,
							    "stock_ideal_".$sucursal=> $stockIdeal,
							    "zona_".$sucursal => $_POST["editarUbicacion"]);

				$respuesta = ModeloProductos::mdlEditarProducto($tabla, $datos, $_SESSION['perfil']);

			}
			else if($_SESSION['perfil'] == 'Vendedor'){

				$datos = array( "codigo" => $_POST["editarCodigo"],
							    "descripcion2" => $_POST["nombreAlternativo"],
						        "fecha_modif_".$sucursal => $fecha_modif,
							    "zona_".$sucursal => $_POST["editarUbicacion"],
							    "imagen" => $ruta);

				$respuesta = ModeloProductos::mdlEditarProducto($tabla, $datos, $_SESSION['perfil']);


			}

			if($respuesta == "ok"){
				echo'<script>
				Swal.fire({
					  icon: "success",
					  title: "El producto ha sido editado correctamente",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar"
					  }).then(function(result){
								if (result.value) {
									window.location = "'.$pagina.'";
								}
							})
				</script>';
			}


		}

	}

	/*=============================================
	BORRAR PRODUCTO
	=============================================*/
	static public function ctrEliminarProducto(){

		// if(isset($_GET["idProducto"])){

		// 	$tabla ="productos";
		// 	$datos = $_GET["idProducto"];

		// 	if($_GET["imagen"] != "" && $_GET["imagen"] != "componentes/img/productos/default/anonymous.png"){

		// 		unlink($_GET["imagen"]);

		// 	}

		// 	$respuesta = ModeloProductos::mdlEliminarProducto($tabla, $datos);

		// 	if($respuesta == "ok"){

		// 		echo'<script>

		// 		Swal.fire({
		// 			  icon: "success",
		// 			  title: "El producto ha sido borrado correctamente",
		// 			  showConfirmButton: true,
		// 			  confirmButtonText: "Cerrar"
		// 			  }).then(function(result){
		// 						if (result.value) {

		// 						window.location = "'.$_GET['ruta'].'";

		// 						}
		// 					})

		// 		</script>';

		// 	}		

		// }

	}


	/*=============================================
	BORRAR PRODUCTO AJAX
	=============================================*/
	static public function ctrEliminarProductoFaltante($item, $valor, $tabla){

			$respuesta = ModeloProductos::mdlEliminarProductoFaltante($item, $valor, $tabla);

	}

	/*=============================================
	MOSTRAR SUMA VENTAS
	=============================================*/

	static public function ctrMostrarSumaVentas($columnaSuma){

		$tabla = "productos";

		$respuesta = ModeloProductos::mdlMostrarSumaVentas($tabla, $columnaSuma);

		return $respuesta;

	}

	/*=============================================
	SUMAR PRODUCTOS RETIRADOS
	=============================================*/
	static public function ctrSumarProductosRetirados($idRetiro){
// $imprimirTicket = new ControladorImprimirTicket();
// $imprimirTicket -> ctrImprimirTicketRetiro($idRetiro);
		$tabla = "retiro_productos";
		$respuesta = ModeloProductos::mdlSumarProductosRetirados($tabla, $idRetiro);
		return $respuesta;
		// $imprimirRetiro = ControladorImprimirTicket::ctrImprimirTicketRetiro($idRetiro);
		



	}

	/*=============================================
	ACTUALIZAR STOCK
	=============================================*/
	static public function ctrActualizarSaldoProductoRetiro($saldo, $idRetiro){
		$tabla = "retiro_productos";
		$respuesta = ModeloProductos::mdlActualizarSaldoProductoRetiro($tabla, $saldo, $idRetiro);
	}			

}