<?php

use Mike42\Escpos\Printer;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;


class ControladorImprimirTicket{

	static public function ctrReimprimirTicketVenta($idCliente, $idVendedor, $listaProductos){


		function title(Printer $printer, $text)
		{
		    $printer->selectPrintMode(Printer::MODE_EMPHASIZED);
		    $printer->text("\n" . $text);
		    $printer->selectPrintMode();
		}

		$itemCliente = "id";
		$valorCliente = $idCliente;
		$traerCliente = ControladorClientes::ctrMostrarClientes($itemCliente, $valorCliente);

		$impresora = "POS-58";
		$conector = new WindowsPrintConnector($impresora);
		$printer = new Printer($conector);
		$printer -> setJustification(Printer::JUSTIFY_CENTER);

		// TITULO
	    $printer->setTextSize(2, 2);
	    $printer->text("Ferretería SAMA");
		title($printer, (date("Y-m-d H:i:s")." COD: ".$_POST["nuevaVenta"]."\n"));

		$printer->setTextSize(1, 1);
		$printer -> feed(1); //Alimentamos el papel 1 vez*/
		$printer -> text("Eduardo Dinamarca C"."\n");//Nombre
		$printer -> text("RUT: 18.817.715-8"."\n");//RUT
		$printer -> text("Pasaje Plaza 893, Limache"."\n");//Dirección
		$printer -> text("WHATSAPP: +56938714443"."\n");//Teléfono
		$printer -> text("ventas@ferreteriasama.cl"."\n");//correo

		$printer -> feed(1); //Alimentamos el papel 1 vez*/

		$printer -> text("Cliente: ".$traerCliente["nombre"]."\n");//Nombre del cliente

		$tablaVendedor = "usuarios";
		$item = "id";
		$valor = $idVendedor;
		$traerVendedor = ModeloUsuarios::mdlMostrarUsuarios($tablaVendedor, $item, $valor);
		$printer -> text("Vendedor: ".$traerVendedor["nombre"]."\n");//Nombre del vendedor

		$printer -> feed(1); //Alimentamos el papel 1 vez*/

		title($printer, "CODIGO PRODUCTO          TOTAL  ");//Nombre del vendedor
		// $printer -> text("040204 TUBO LED 40W PHEL $ 2.200");//Nombre del vendedor

		$subtotal = 0;
		$totalDescuentos = 0;

		foreach ($listaProductos as $key => $value){
	   		// TRAER PRODUCTO
			$item = "id";
			$valor = $value["id"];
			$orden = "id";
			$tablaProductos = "productos";
			$traerProducto = ModeloProductos::mdlMostrarProductos($tablaProductos, $item, $valor, $orden);

			// DESCRIPCION SOLO CON 17 CARACTERES Y LAS PALABRAS SOLO CON SUS 5 PRIMERAS LETRAS
			$separar_descripcion = explode(" ",$value["prod"]);
			$desc_cortada = "";
			for($i=0;$i<count($separar_descripcion);$i++){ 
				$palabra_cortada = substr($separar_descripcion[$i], 0, 5);
				$desc_cortada = $desc_cortada.$palabra_cortada." ";
			}
			$cortar_descripcion=mb_strtoupper(mb_strimwidth($value["cantidad"]."x".$desc_cortada, 0, 17, ""));

			// PRECIOS VENTA
			$precioConDcto = $value["total"];
			$precioSinDcto = $value["cantidad"]*$value["precio"];

			// TOTAL CON EN 6 ESPACIOS
			$espacios = "      ";
			$nro_espacios = 6; //5 espacios
			$largo = strlen(number_format($precioSinDcto,0,',','.'));

			if($largo <= $nro_espacios){
				$totalItemTicket = substr($espacios,0,$nro_espacios-$largo).number_format($precioSinDcto,0, ',', '.'); 						
			}else{
				$totalItemTicket = $precioSinDcto;
			}

			$printer->setJustification(Printer::JUSTIFY_LEFT);
			$printer->text($traerProducto["sku"]." ".$cortar_descripcion." $".$totalItemTicket."\n");//DESCRIPCION ITEM VENDIDO

			$printer->setJustification(Printer::JUSTIFY_RIGHT);					
			if($precioSinDcto-$precioConDcto>0){
			$dctoItem = "-$ ".number_format(($precioSinDcto-$precioConDcto), 0,',','.')."\n";
			}else{
			$dctoItem = "";
			}
			$printer->text($dctoItem);//DESCRIPCION ITEM VENDIDO

			$subtotal = $subtotal + $precioSinDcto;
			$totalDescuentos = $totalDescuentos + $precioSinDcto - $precioConDcto;
			$total =  $subtotal - $totalDescuentos;

		}

		$printer -> feed(1); //Alimentamos el papel 1 vez*/			
		$printer->setJustification(Printer::JUSTIFY_LEFT);									
		
		$espacios = "        "; //8 espacios
		$nro_espacios = 8; 
		$largo = strlen(number_format($subtotal,0,',','.'));
		$complemento = $nro_espacios-$largo;

		if($totalDescuentos!=0){

			$printer->text("        SUBTOTAL: $ ".substr($espacios,0,$nro_espacios-$largo-$complemento).number_format($subtotal,0, ',', '.')."\n"); 

			$descuentos_conteo = strlen(number_format($totalDescuentos,0,',','.'));
			$printer->text("    - DESCUENTOS: $ ".substr($espacios,0,$nro_espacios-$descuentos_conteo-$complemento).number_format($totalDescuentos,0, ',', '.')."\n");
		}

		$total_final_conteo = strlen(number_format($total,0,',','.'));
		title($printer, ("           TOTAL: $ ".substr($espacios,0,$nro_espacios-$total_final_conteo-$complemento).number_format($total,0, ',', '.')."\n\n"));					

		$printer->setJustification(Printer::JUSTIFY_CENTER);									
		$printer->text("Gracias por su compra..."); 

		
		$printer -> feed(3); //Alimentamos el papel 3 veces*/	

		$printer -> cut(); //Cortamos el papel, si la impresora tiene la opción

		$printer -> pulse(); //Por medio de la impresora mandamos un pulso, es útil cuando hay cajón moneder

		$printer -> close();

	}

	static public function ctrImprimirTicketRetiro($idRetiro){

		// 	$traerProducto = ModeloProductos::mdlMostrarProductos($tablaProductos, $item, $valor, $orden);

		// 	// DESCRIPCION SOLO CON 17 CARACTERES Y LAS PALABRAS SOLO CON SUS 5 PRIMERAS LETRAS
		// 	$separar_descripcion = explode(" ",$value["prod"]);
		function title(Printer $printer, $text)
		{
		    $printer->selectPrintMode(Printer::MODE_EMPHASIZED);
		    $printer->text("\n" . $text);
		    $printer->selectPrintMode();
		}

		$item = "id";
		$valor = $idRetiro;
		$orden = "id";
		$retiro = ControladorProductos::ctrMostrarRetiroProductos($item, $valor, $orden);


  		$itemCliente = "id";
  		$valorCliente = $retiro['id_cliente'];
		$cliente = ControladorClientes::ctrMostrarClientes($itemCliente, $valorCliente);
		$nombreCliente = substr($cliente['nombre']." ".$cliente['apellido'],0,21);

		$itemProducto = "sku";
		$valorProducto = $retiro["cod_producto"];
		$productosRetirar = ControladorProductos::ctrMostrarProducto($itemProducto, $valorProducto);
		$nombreProducto = substr($productosRetirar['descripcion'],0,21);

		$item = "id_asociado";
		$valor = $idRetiro;
		$orden = "id";
		$listaRetiros = ControladorProductos::ctrMostrarRetiroProductos($item, $valor, $orden);
		
		$impresora = "POS-58";
		$conector = new WindowsPrintConnector($impresora);
		$printer = new Printer($conector);
		$printer -> setJustification(Printer::JUSTIFY_CENTER);


		// TITULO
	    $printer->setTextSize(2, 2);
	    $printer->text("Ferretería SAMA");
		title($printer, (date("Y-m-d H:i:s")."\n"));

		$printer->setTextSize(1, 1);
		$printer -> feed(1);
		$printer -> text("Cliente  : ".$nombreCliente."\n");
		$printer -> text("Producto : ".$nombreProducto."\n");
		$printer -> text("Unidades : ".$retiro['cantidad']." u\n");

		$printer -> setJustification(Printer::JUSTIFY_LEFT);
		title($printer, "RETIROS REALIZADOS"."\n");
		
		foreach ($listaRetiros as $key => $value){

			$largoCant = strlen($value['retirado']);
			$espacios = '         ';
			$espacioIntermedio = substr($espacios,0,(9-$largoCant));

			$printer -> text('- '.$value['retirado'].'u '.$espacioIntermedio.$value['fecha_retiro']."\n");			
		}

		$printer -> feed(1); 
		$printer -> setJustification(Printer::JUSTIFY_CENTER);
		$printer -> text('SALDO POR RETIRAR  '.$retiro['saldo']."u\n");			
		$printer -> feed(2);
		$printer -> text('------------------------'."\n");			
		$printer -> text('FIRMA RESPONSABLE');			

		$printer -> feed(4); 
		$printer -> cut(); 
		$printer -> close();


	}


	static public function ctrReimprimirTicketVentaGET($cliente, $vendedor, $productosGET4, $codigoVenta, $fechaVenta){


		function title(Printer $printer, $text)
		{
		    $printer->selectPrintMode(Printer::MODE_EMPHASIZED);
		    $printer->text("\n" . $text);
		    $printer->selectPrintMode();
		}

		
		$impresora = "POS-58";
		$conector = new WindowsPrintConnector($impresora);
		$printer = new Printer($conector);
		$printer -> setJustification(Printer::JUSTIFY_CENTER);

		// TITULO
	    $printer->setTextSize(2, 2);
	    $printer->text("Ferretería SAMA");
		title($printer, (date("Y-m-d H:i:s")." COD: ".$codigoVenta."\n"));

		$printer->setTextSize(1, 1);
		$printer -> feed(1); //Alimentamos el papel 1 vez*/
		$printer -> text("Eduardo Dinamarca C"."\n");//Nombre
		$printer -> text("RUT: 18.817.715-8"."\n");//RUT
		$printer -> text("Pasaje Plaza 893, Limache"."\n");//Dirección
		$printer -> text("WHATSAPP: +56938714443"."\n");//Teléfono
		$printer -> text("ventas@ferreteriasama.cl"."\n");//correo

		$printer -> feed(1); //Alimentamos el papel 1 vez*/

		$printer -> text("Cliente: ".$cliente."\n");//Nombre del cliente
		$printer -> text("Vendedor: ".$vendedor."\n");//Nombre del vendedor

		$printer -> feed(1); //Alimentamos el papel 1 vez*/

		title($printer, "CODIGO PRODUCTO          TOTAL  ");//Nombre del vendedor
		// $printer -> text("040204 TUBO LED 40W PHEL $ 2.200");//Nombre del vendedor

		$subtotal = 0;
		$totalDescuentos = 0;
		$productosGETTTT = json_decode($productosGET4, true);
		foreach ($productosGETTTT as $key => $value){

			$separar_descripcion = explode(" ",$value["prod"]);
			$desc_cortada = "";
			for($i=0;$i<count($separar_descripcion);$i++){ 
				$palabra_cortada = substr($separar_descripcion[$i], 0, 5);
				$desc_cortada = $desc_cortada.$palabra_cortada." ";
			}
			$cortar_descripcion=mb_strtoupper(mb_strimwidth($value["cantidad"]."x".$desc_cortada, 0, 17, ""));

			// PRECIOS VENTA
			$precioConDcto = $value["total"];
			$precioSinDcto = $value["cantidad"]*$value["precio"];

			// TOTAL CON EN 6 ESPACIOS
			$espacios = "      ";
			$nro_espacios = 6; //5 espacios
			$largo = strlen(number_format($precioSinDcto,0,',','.'));

			if($largo <= $nro_espacios){
				$totalItemTicket = substr($espacios,0,$nro_espacios-$largo).number_format($precioSinDcto,0, ',', '.'); 						
			}else{
				$totalItemTicket = $precioSinDcto;
			}

			$printer->setJustification(Printer::JUSTIFY_LEFT);
			if(isset($value["sku"])){
				$printer->text($value["sku"]." ".$cortar_descripcion." $".$totalItemTicket."\n");//DESCRIPCION ITEM VENDIDO
			}else{
				$printer->text('000000'." ".$cortar_descripcion." $".$totalItemTicket."\n");//DESCRIPCION ITEM VENDIDO
			}

			$printer->setJustification(Printer::JUSTIFY_RIGHT);					
			if($precioSinDcto-$precioConDcto>0){
			$dctoItem = "-$ ".number_format(($precioSinDcto-$precioConDcto), 0,',','.')."\n";
			}else{
			$dctoItem = "";
			}
			$printer->text($dctoItem);//DESCRIPCION ITEM VENDIDO

			$subtotal = $subtotal + $precioSinDcto;
			$totalDescuentos = $totalDescuentos + $precioSinDcto - $precioConDcto;
			$total =  $subtotal - $totalDescuentos;

		}

		$printer -> feed(1); //Alimentamos el papel 1 vez*/			
		$printer->setJustification(Printer::JUSTIFY_LEFT);									
		
		$espacios = "        "; //8 espacios
		$nro_espacios = 8; 
		$largo = strlen(number_format($subtotal,0,',','.'));
		$complemento = $nro_espacios-$largo;

		if($totalDescuentos!=0){

			$printer->text("        SUBTOTAL: $ ".substr($espacios,0,$nro_espacios-$largo-$complemento).number_format($subtotal,0, ',', '.')."\n"); 

			$descuentos_conteo = strlen(number_format($totalDescuentos,0,',','.'));
			$printer->text("    - DESCUENTOS: $ ".substr($espacios,0,$nro_espacios-$descuentos_conteo-$complemento).number_format($totalDescuentos,0, ',', '.')."\n");
		}

		$total_final_conteo = strlen(number_format($total,0,',','.'));
		title($printer, ("           TOTAL: $ ".substr($espacios,0,$nro_espacios-$total_final_conteo-$complemento).number_format($total,0, ',', '.')."\n\n"));					

		$printer->setJustification(Printer::JUSTIFY_CENTER);									
		$printer->text("Gracias por su compra..."); 

		
		$printer -> feed(3); //Alimentamos el papel 3 veces*/	

		$printer -> cut(); //Cortamos el papel, si la impresora tiene la opción

		$printer -> pulse(); //Por medio de la impresora mandamos un pulso, es útil cuando hay cajón moneder

		$printer -> close();

	}


}