<?php
session_start();
require_once "../modelos/conexion.php";
require_once "../controladores/imprimirTicket.controlador.php";
require_once "../extensiones/vendor/autoload.php";
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";
require_once "../modelos/actividad-inventario.modelo.php";
require_once "../modelos/sucursales.modelo.php";
require_once "../controladores/categorias.controlador.php";
require_once "../modelos/categorias.modelo.php";
require_once "../controladores/movimientos.controlador.php";
require_once "../modelos/movimientos.modelo.php";
require_once "../modelos/ajustes.modelo.php";
require_once "../controladores/funciones-bot-telegram.php";
require_once "../controladores/funciones_generales.php";

class AjaxProductos{

  /*=============================================
  CHECK STOCK PRODUCTO
  =============================================*/
  public function ajaxCheckStockProd(){ // PERMITE SABER SI ESTA CHEQUEADO E INCLUYE FECHA DE CHEQUEO
    date_default_timezone_set("America/Santiago");
    $sucursal = $_SESSION['sucursal'];
    $tabla = "productos";
    $item1 = "check_stock_".$sucursal;
    $valor1 = 1;
    $item2 = 'fecha_check_'.$sucursal;
    $item3 = "id";
    $valor3 = $_POST["checkStock"];
    echo $respuesta = ModeloProductos::mdlActualizar2($tabla, $item1, $valor1, $item2, date("Y-m-d H:i:s"), $item3, $valor3);
  }    

  /*=============================================
  ELIMINAR PRODUCTO TRASNFORMABLE
  =============================================*/
  public function ajaxElimProdTrasnf(){
    $prodBase =  $_POST['elimProdTransfBase'];
    $prodSurtir =  $_POST['elimProdTransfSurtido'];
    $resetProdBase = ModeloProductos::mdlConfigProdTransformable('productos', 'transformable', 0, 'cant_transf', 0, 'id_transf', 0, 'id', $prodBase);
    echo $resetProdSurtir_1 = ModeloProductos::mdlConfigProdTransformable('productos', 'transformable', 0, 'cant_transf', 0, 'id_transf', 0, 'id', $prodSurtir);
  }    

  /*=============================================
  EDITAR CONFIGURACION PRODUCTO TRASNFORMABLE
  =============================================*/
  public function ajaxConfigProdTransfEdit(){
    $idProdBase =  $_POST['idProdBaseEdit'];
    $prodSurtido =  $_POST['prodSurtidoEdit'];
    $intercambio =  $_POST['intercambioEdit'];
    
    $configProdSurtido = ModeloProductos::mdlConfigProdTransformable('productos', 'transformable', 2, 'cant_transf', $intercambio, 'id_transf', $idProdBase, 'id', $prodSurtido);
    echo $respuesta = ModeloProductos::mdlConfigProdTransformable('productos', 'transformable', 1, 'cant_transf', $intercambio, 'id_transf', $prodSurtido, 'id', $idProdBase);
  }    
  


  /*=============================================
  TODOS LOS PRODUCTOS
  =============================================*/ 
  public function traerProdsAll(){
    $respuesta = ModeloProductos::mdlMostrarProductosAllActivos();
    echo json_encode($respuesta);
  }    

  /*=============================================
  DATOS PRODUCTO TRASNFORMABLE
  =============================================*/ 
  public function ajaxDatosProdsVinculadosTransf(){
    $idProd =  $_POST['idProdTransfEdit'];
    $prodSurtirEdit = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);
    $prodBaseEdit = ModeloProductos::mdlMostrarProducto('productos', 'id', $prodSurtirEdit['id_transf']);
    $prods = array();
    array_push($prods, $prodSurtirEdit);
    array_push($prods, $prodBaseEdit);
    echo json_encode($prods);
  }    

  /*=============================================
  SURTIR PRODUCTO TRASNFORMABLE
  =============================================*/ 
  public function ajaxSurtirAlChico(){
    $sucursal = $_SESSION['sucursal'];
    $idProd =  $_POST['idProdTransf'];
    $prodSurtir = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);
    
    $prodBase = ModeloProductos::mdlMostrarProducto('productos', 'id', $prodSurtir['id_transf']);


    $stockBodegas = 0;
    $bodegasExtraccion = [];
    $bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");

    foreach ($bodegas as $key_1 => $value_1) {
      $nombreBodega = $value_1['nombre_sucursal'];
      $stockBodegas += $prodBase['stock_'.$nombreBodega];
      if($prodBase['stock_'.$nombreBodega] > 0){
        array_push($bodegasExtraccion, $nombreBodega);
      }
    }

    $stockProdBase = $prodBase['stock_'.$sucursal]-1; // stock despues de surtir
    $divisorIdeal = $prodBase['control_inventario'] == 1 ? 2 : 3; // si es primera prioridad se alerta cuando falta la mitad, si no cuando falta 1/3
    $tipoLocal = ModeloSucursales::mdlMostrarSucursales("sucursales", "nombre_sucursal", $_SESSION['sucursal'])[0]['tipo_sucursal'];
    if($tipoLocal == 'local'){ // solo si esta en local de ventas se notifica telegram
      if($stockProdBase == 0 && $stockBodegas > 0){

        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
        $imagenDB = $prodBase['imagen']; // Ruta de la imagen que deseas enviar

        $descSiiTG = $prodBase['desc_sii'];
        $skuTG = $prodBase['categoria'] < 10 ? '0'.$prodBase['sku'] : $prodBase['sku'];

        if(count($bodegas) == 1){
          $zonaTG = $prodBase['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$prodBase['zona_bodega1'].'</b>';
        }else{
          $zonaTG = '';
          for ($i=0; $i < count($bodegasExtraccion); $i++) { 
            $letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
            $nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números          
            $zonaMostrar = $prodBase['zona_'.$bodegasExtraccion[$i]] == '' ? 's/ZONA' : $prodBase['zona_'.$bodegasExtraccion[$i]];
            $zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.'</b>) ';
          }
        }

        $faltanteEnLocal = $prodBase['stock_ideal_'.$sucursal] - $stockProdBase;
        $cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;

        $texto =  "‼️‼️‼️‼️ <b>REPONER URGENTE</b> ‼️‼️‼️‼️\n\n".
                  "Descripción  : <b>".$descSiiTG."</b>\n".
                  "SKU                  : <b>".$skuTG."</b>\n".
                  "Zona                 : ".$zonaTG."\n".
                  "Quedaron    : <b>".$stockProdBase.'/'.$prodBase['stock_ideal_'.$sucursal]."</b>\n".
                  "Reponer         : <b>".$cantSugerida."u</b>";
        $notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);
        // NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
        if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
          $notificarDB = ModeloProductos::mdlActualizarProducto('productos', 'notificacion_telegram_'.$sucursal, 1, $prodSurtir['id_transf']);
        }
      }else if($stockProdBase <= ($prodBase['stock_ideal_'.$sucursal]/$divisorIdeal) && $stockProdBase > 0 && $stockBodegas > 0 && $prodBase['notificacion_telegram_'.$sucursal] == 0){

        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
        $imagenDB = $prodBase['imagen']; // Ruta de la imagen que deseas enviar
        $descSiiTG = $prodBase['desc_sii'];
        $skuTG = $prodBase['categoria'] < 10 ? '0'.$prodBase['sku'] : $prodBase['sku'];

        if(count($bodegas) == 1){
          $zonaTG = $prodBase['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$prodBase['zona_bodega1'].'</b>';
        }else{
          $zonaTG = '';
          for ($i=0; $i < count($bodegasExtraccion); $i++) { 
            $letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
            $nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números          
            $zonaMostrar = $prodBase['zona_'.$bodegasExtraccion[$i]] == '' ? 's/ZONA' : $prodBase['zona_'.$bodegasExtraccion[$i]];
            $zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.'</b>) ';
          }
        }

        $faltanteEnLocal = $prodBase['stock_ideal_'.$sucursal] - $stockProdBase;
        $cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;

        $texto =  "Descripción  : <b>".$descSiiTG."</b>\n".
                  "SKU                  : <b>".$skuTG."</b>\n".
                  "Zona                 : ".$zonaTG."\n".
                  "Quedaron    : <b>".$stockProdBase.'/'.$prodBase['stock_ideal_'.$sucursal]."</b>\n".
                  "Reponer         : <b>".$cantSugerida."u</b>";
        $notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);                
        // NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
        if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
          $notificarDB = ModeloProductos::mdlActualizarProducto('productos', 'notificacion_telegram_'.$sucursal, 1, $prodSurtir['id_transf']);
        }
      }
    }

    $stockProdSurtir = $prodSurtir['stock_'.$sucursal]+$prodSurtir['cant_transf'];
    // MODIFICACION EN BASE DE DATOS
    $restarProdBase = ModeloProductos::mdlActualizarProducto('productos', 'stock_'.$sucursal, $stockProdBase, $prodSurtir['id_transf']);
    sleep(1);
    // REGISTRO ACTIVIDAD
    $ultimoRegistro = ModeloProductos::mdlSeleccionarUltimoIdRegistro();
    $registroActividadProdBase = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'transfProdMenos', 1, 'transf', $prodBase['id'], $_SESSION['id'], $_SESSION['nombre']);
    $registroActividadProdSurtir = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'transfProdMas', $prodSurtir['cant_transf'], 'transf', $idProd, $_SESSION['id'], $_SESSION['nombre']);
    echo $respuesta = ModeloProductos::mdlActualizarProducto('productos', 'stock_'.$sucursal, $stockProdSurtir, $idProd);
  }    

  /*=============================================
  CONFIGURAR PRODUCTO TRASNFORMABLE
  =============================================*/ 
  public function ajaxConfigProdTransf(){
    $idProdBase =  $_POST['idProdBase'];
    $intercambio =  $_POST['intercambio'];
    $idProdSurtido =  $_POST['prodSurtido'];

    $configProdSurtidoNivel1 = ModeloProductos::mdlConfigProdTransformable('productos', 'transformable', 2, 'cant_transf', $intercambio, 'id_transf', $idProdBase, 'id', $idProdSurtido);

    echo $respuesta = ModeloProductos::mdlConfigProdTransformable('productos', 'transformable', 1, 'cant_transf', $intercambio, 'id_transf', $idProdSurtido, 'id', $idProdBase);
  }    

  /*=============================================
  BAJAR STOCK IDEAL CON CLICK
  =============================================*/ 
  public function ajaxStockIdealMenos(){
    $sucursal = $_SESSION['sucursal'];
    $id =  $_POST['stockIdealResta'];
    $stk =  $_POST['idealActualizadoResta'];
    $stockIdealSucursalActual = "stock_ideal_".$sucursal;
    /*------------------------------------------------------------------------*/
    date_default_timezone_set("America/Santiago");
    $fechaModifStock = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$sucursal, date("Y-m-d H:i:s"), $id);
    /*------------------------------------------------------------------------*/
    $locales = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "local");
    $stockIdealBodega = 0;
    foreach ($locales as $key => $value) {
      $infoProd = ControladorProductos::ctrMostrarProducto('id', $id, 'id');
      $stockIdealSucursal = $infoProd['stock_ideal_'.$value['nombre_sucursal']];
      $stockIdealBodega += $stockIdealSucursal;
    }
    $stockIdealBodega -= 1; // resta el stock del local
    $modifStockIdealBodega = ModeloProductos::mdlActualizarProducto('productos', 'stock_ideal_bodega1', $stockIdealBodega, $id);
    echo $respuesta = ModeloProductos::mdlActualizarProducto('productos', $stockIdealSucursalActual, $stk, $id).','.date("Y-m-d H:i:s").','.$infoProd['stock_'.$sucursal];
  }    

  /*=============================================
  SUBIR STOCK IDEAL CON CLICK
  =============================================*/ 
  public function ajaxStockIdealMas(){
    $sucursal = $_SESSION['sucursal'];
    $id =  $_POST['stockIdeal'];
    $stk =  $_POST['idealActualizado'];
    $stockIdealSucursalActual = "stock_ideal_".$sucursal;
    /*------------------------------------------------------------------------*/
    date_default_timezone_set("America/Santiago");
    $fechaModifStock = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$sucursal, date("Y-m-d H:i:s"), $id);
    /*------------------------------------------------------------------------*/

    $locales = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "local");
    $stockIdealBodega = 0;
    foreach ($locales as $key => $value) {
      $infoProd = ControladorProductos::ctrMostrarProducto('id', $id, 'id');
      $stockIdealSucursal = $infoProd['stock_ideal_'.$value['nombre_sucursal']];
      $stockIdealBodega += $stockIdealSucursal;
    }
    $stockIdealBodega += 1; // resta el stock del local

    // STOCK IDEAL EN TODAS LAS BODEGAS
    $bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");
    foreach ($bodegas as $key_1 => $value_1) {
      $nombreBodega = $value_1['nombre_sucursal'];
      $modifStockIdealBodega = ModeloProductos::mdlActualizarProducto('productos', 'stock_ideal_'.$nombreBodega, $stockIdealBodega, $id);
    }

    echo $respuesta = ModeloProductos::mdlActualizarProducto('productos', $stockIdealSucursalActual, $stk, $id).','.date("Y-m-d H:i:s").','.$infoProd['stock_'.$sucursal];
  }    

  /*=============================================
  EDITAR MAYOR DESDE MAS
  =============================================*/ 
  public function ajaxMayDesdMas(){
    date_default_timezone_set("America/Santiago");
    $id =  $_POST['mayDesdMas'];
    $cant =  $_POST['cant'];
    $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "local");
    foreach ($sucursales as $key => $value) {
      $fechaModifStock = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$value['nombre_sucursal'], date("Y-m-d H:i:s"), $id);
    }
    echo $respuesta = ModeloProductos::mdlActualizarProducto('productos', 'mayor_sobre', $cant, $id).','.date("Y-m-d H:i:s").','.$cant;
  }    

  /*=============================================
  EDITAR MAYOR DESDE MENOS
  =============================================*/ 
  public function ajaxMayDesdMenos(){
    date_default_timezone_set("America/Santiago");
    $id =  $_POST['mayDesdMenos'];
    $cant =  $_POST['cant'];
    $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "local");
    foreach ($sucursales as $key => $value) {
      $fechaModifStock = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$value['nombre_sucursal'], date("Y-m-d H:i:s"), $id);
    }
    echo $respuesta = ModeloProductos::mdlActualizarProducto('productos', 'mayor_sobre', $cant, $id).','.date("Y-m-d H:i:s").','.$cant;
  }    

  /*=============================================
  EDITAR PRECIO VENTA
  =============================================*/ 
  public function ajaxPVenta(){
    date_default_timezone_set("America/Santiago");
    $tabla = "productos";
    $item1 = "precio_venta";
    $valor1 = $_POST['pVentaAj'];
    $item2 = "precio_mayor";
    $valor2 = $_POST['pVMayorAj'];
    $item3 = "id";
    $valor3 = $_POST['modifPVenta'];
    /*------------------------------------------------------------------------*/
    $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "local");
    foreach ($sucursales as $key => $value) {
      $fechaModifPVenta = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$value['nombre_sucursal'], date("Y-m-d H:i:s"), $valor3);
    }
    /*------------------------------------------------------------------------*/    
    echo $respuesta = ModeloProductos::mdlActualizar2($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3).','.date("Y-m-d H:i:s");
  }

  /*=============================================
  EDITAR STOCK
  =============================================*/ 
  public function ajaxeditStock(){
    $sucursal = $_SESSION['sucursal'];
    $tabla = "productos";
    $item1 = "stock_".$sucursal;
    $stockEditado = $_POST['cant'];
    $valor3 = $_POST['editStock'];
    $traerProducto = ModeloProductos::mdlMostrarProductos('productos', 'id', $valor3, 'id');
    /*------------------------------------------------------------------------*/
    date_default_timezone_set("America/Santiago");
    $fechaModifStock = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$sucursal, date("Y-m-d H:i:s"), $valor3);
    /*------------------------------------------------------------------------*/
    // REGISTRO ACTIVIDAD INVENTARIO
    $ultimoRegistro = ModeloProductos::mdlSeleccionarUltimoIdRegistro();//

    if($stockEditado > $traerProducto['stock_'.$sucursal]){
      $registroSumaStock = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'stockMas', $stockEditado-$traerProducto['stock_'.$sucursal], 'editStock', $traerProducto['id'], $_SESSION['id'], $_SESSION['nombre']);//
    }else{
      $registroRestaStock = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'stockMenos', $traerProducto['stock_'.$sucursal]-$stockEditado, 'editStock', $traerProducto['id'], $_SESSION['id'], $_SESSION['nombre']);//
    }

    // REGISTRO PERDIDA DE STOCK
    $diaCerrado = ControladorMovimientos::ctrMovSi2LI('fecha', date('Y-m-d'), 'tipo_mov', 'saldo');
    $fechaCont = count($diaCerrado)==0 ? date('Y-m-d') : date('Y-m-d', strtotime('+1 day'));
    $diferencia = $stockEditado-$traerProducto['stock_'.$sucursal];
    $totalMonetario = $diferencia * $traerProducto['precio_compra'];
    $perdidaInventario = ModeloActividadInventario::mdlPerdidaInventario('perdida_inventario', $fechaCont, $sucursal, $_SESSION['id'], $traerProducto['id'], $diferencia, $traerProducto['precio_compra'], $totalMonetario);

    $stockBodegas = 0;
    $bodegasExtraccion = [];
    $bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");

    foreach ($bodegas as $key_1 => $value_1) {
      $nombreBodega = $value_1['nombre_sucursal'];
      $stockBodegas += $traerProducto['stock_'.$nombreBodega];
      if($traerProducto['stock_'.$nombreBodega] > 0){
        array_push($bodegasExtraccion, $nombreBodega);
      }
    }

    // notificacion Bot Telegram
    $divisorIdeal = $traerProducto['control_inventario'] == 1 ? 2 : 3; // si es primera prioridad se alerta cuando falta la mitad, si no cuando falta 1/3
    $tipoLocal = ModeloSucursales::mdlMostrarSucursales("sucursales", "nombre_sucursal", $_SESSION['sucursal'])[0]['tipo_sucursal'];
    if($tipoLocal == 'local'){ // solo si esta en local de ventas se notifica telegram
      if($stockEditado == 0 && $stockBodegas > 0){
      
        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
        $imagenDB = $traerProducto['imagen']; // Ruta de la imagen que deseas enviar

        $descSiiTG = $traerProducto['desc_sii'];
        $skuTG = $traerProducto['categoria'] < 10 ? '0'.$traerProducto['sku'] : $traerProducto['sku'];
      
        if(count($bodegas) == 1){
          $zonaTG = $traerProducto['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto['zona_bodega1'].'</b>';
        }else{
          $zonaTG = '';
          for ($i=0; $i < count($bodegasExtraccion); $i++) { 
            $letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
            $nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números          
            $zonaMostrar = $traerProducto['zona_'.$bodegasExtraccion[$i]] == '' ? 's/ZONA' : $traerProducto['zona_'.$bodegasExtraccion[$i]];
            $zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.'</b>) ';
          }
        }

        $faltanteEnLocal = $traerProducto['stock_ideal_'.$sucursal] - $stockEditado;
        $cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;

        $texto =  "‼️‼️‼️‼️ <b>REPONER URGENTE</b> ‼️‼️‼️‼️\n\n".
              "Descripción  : <b>".$descSiiTG."</b>\n".
              "SKU                  : <b>".$skuTG."</b>\n".
              "Zona                 : ".$zonaTG."\n".
              "Quedaron    : <b>".$stockEditado.'/'.$traerProducto['stock_ideal_'.$sucursal]."</b>\n".
              "Reponer         : <b>".$cantSugerida."u</b>";
        $notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);
        // NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
        if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
          $notificarDB = ModeloProductos::mdlActualizarProducto('productos', 'notificacion_telegram_'.$sucursal, 1, $valor3);
        }
      }else if($stockEditado <= ($traerProducto['stock_ideal_'.$sucursal]/$divisorIdeal) && $stockEditado > 0 && $stockBodegas > 0 && $traerProducto['notificacion_telegram_'.$sucursal] == 0){

        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
        $imagenDB = $traerProducto['imagen']; // Ruta de la imagen que deseas enviar

        $descSiiTG = $traerProducto['desc_sii'];
        $skuTG = $traerProducto['categoria'] < 10 ? '0'.$traerProducto['sku'] : $traerProducto['sku'];

        if(count($bodegas) == 1){
          $zonaTG = $traerProducto['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto['zona_bodega1'].'</b>';
        }else{
          $zonaTG = '';
          for ($i=0; $i < count($bodegasExtraccion); $i++) { 
            $letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
            $nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números          
            $zonaMostrar = $traerProducto['zona_'.$bodegasExtraccion[$i]] == '' ? 's/ZONA' : $traerProducto['zona_'.$bodegasExtraccion[$i]];
            $zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.'</b>) ';
          }
        }

        
        $faltanteEnLocal = $traerProducto['stock_ideal_'.$sucursal] - $stockEditado;
        $cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;

        $texto =  "Descripción  : <b>".$descSiiTG."</b>\n".
                  "SKU                  : <b>".$skuTG."</b>\n".
                  "Zona                 : ".$zonaTG."\n".
                  "Quedaron    : <b>".$stockEditado.'/'.$traerProducto['stock_ideal_'.$sucursal]."</b>\n".
                  "Reponer         : <b>".$cantSugerida."u</b>";
        $notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);
        // NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
        if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
          $notificarDB = ModeloProductos::mdlActualizarProducto('productos', 'notificacion_telegram_'.$sucursal, 1, $valor3);
        }
      }
    }
    if($stockEditado > ($traerProducto['stock_ideal_'.$sucursal]/$divisorIdeal)){ // desactiva notificacion telegram
      $notificarDB = ModeloProductos::mdlActualizarProducto('productos', 'notificacion_telegram_'.$sucursal, 0, $valor3);
    }

    echo $respuesta = ModeloProductos::mdlActualizarProducto($tabla, $item1, $stockEditado, $valor3).','.date("Y-m-d H:i:s").','.$fechaCont;
  }    


  /*=============================================
  EDITAR UBICACION
  =============================================*/ 
  public function ajaxEditUbic(){
    $sucursal = $_SESSION['sucursal'];
    $tabla = "productos";
    $item1 = "zona_".$sucursal;
    $valor1 = $_POST['zonaSucursal'];
    $item2 = "id";
    $valor2 = $_POST['modifUbic'];
    /*------------------------------------------------------------------------*/
    date_default_timezone_set("America/Santiago");
    $fechaModifStock = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$sucursal, date("Y-m-d H:i:s"), $valor2);
    /*------------------------------------------------------------------------*/
    echo $respuesta = ModeloProductos::mdlActualizarProducto('productos', $item1, $valor1, $valor2).','.date("Y-m-d H:i:s").','.$valor1;
  }

  /*=============================================
  RESTAR STOCK
  =============================================*/ 
  public function ajaxRestStock(){

    $sucursal = $_SESSION['sucursal'];
    $tabla = "productos";
    $item1 = "stock_".$sucursal;
    $item3 = "id";
    $valor3 = $_POST['restStock'];
    $traerProducto = ModeloProductos::mdlMostrarProductos('productos', 'id', $valor3, 'id');  
    $stockAnterior = $traerProducto['stock_'.$sucursal];
    $stockActualizado = $stockAnterior-1;
    /*------------------------------------------------------------------------*/
    date_default_timezone_set("America/Santiago");
    $fechaModifStock = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$sucursal, date("Y-m-d H:i:s"), $valor3);
    /*------------------------------------------------------------------------*/
    // REGISTRO ACTIVIDAD INVENTARIO
    $ultimoRegistro = ModeloProductos::mdlSeleccionarUltimoIdRegistro();//
    $registroRestaStock = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'stockMenos', 1, 'ajuste', $traerProducto['id'], $_SESSION['id'], $_SESSION['nombre']);//
    // REGISTRO PERDIDA DE STOCK
    $diaCerrado = ControladorMovimientos::ctrMovSi2LI('fecha', date('Y-m-d'), 'tipo_mov', 'saldo');
    $fechaCont = count($diaCerrado)==0 ? date('Y-m-d') : date('Y-m-d', strtotime('+1 day'));
    $perdidaInventario = ModeloActividadInventario::mdlPerdidaInventario('perdida_inventario', $fechaCont, $sucursal, $_SESSION['id'], $traerProducto['id'], -1, $traerProducto['precio_compra'], -$traerProducto['precio_compra']);


    $stockBodegas = 0;
    $bodegasExtraccion = [];
    $bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");

    foreach ($bodegas as $key_1 => $value_1) {
      $nombreBodega = $value_1['nombre_sucursal'];
      $stockBodegas += $traerProducto['stock_'.$nombreBodega];
      if($traerProducto['stock_'.$nombreBodega] > 0){
        array_push($bodegasExtraccion, $nombreBodega);
      }
    }


    // notificacion Bot Telegram
    $divisorIdeal = $traerProducto['control_inventario'] == 1 ? 2 : 3; // si es primera prioridad se alerta cuando falta la mitad, si no cuando falta 1/3
    $tipoLocal = ModeloSucursales::mdlMostrarSucursales("sucursales", "nombre_sucursal", $sucursal)[0]['tipo_sucursal'];
    if($tipoLocal == 'local'){ // solo si esta en local de ventas se notifica telegram
      if($stockActualizado == 0 && $stockBodegas > 0){
      
        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
        $imagenDB = $traerProducto['imagen']; // Ruta de la imagen que deseas enviar

        $descSiiTG = $traerProducto['desc_sii'];
        $skuTG = $traerProducto['categoria'] < 10 ? '0'.$traerProducto['sku'] : $traerProducto['sku'];
      
        if(count($bodegas) == 1){
          $zonaTG = $traerProducto['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto['zona_bodega1'].'</b>';
        }else{
          $zonaTG = '';
          for ($i=0; $i < count($bodegasExtraccion); $i++) { 
            $letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
            $nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números          
            $zonaMostrar = $traerProducto['zona_'.$bodegasExtraccion[$i]] == '' ? 's/ZONA' : $traerProducto['zona_'.$bodegasExtraccion[$i]];
            $zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.'</b>) ';
          }
        }

        $faltanteEnLocal = $traerProducto['stock_ideal_'.$sucursal] - $stockActualizado;
        $cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;

        $texto =  "‼️‼️‼️‼️ <b>REPONER URGENTE</b> ‼️‼️‼️‼️\n\n".
              "Descripción  : <b>".$descSiiTG."</b>\n".
              "SKU                  : <b>".$skuTG."</b>\n".
              "Zona                 : ".$zonaTG."\n".
              "Quedaron    : <b>".$stockActualizado.'/'.$traerProducto['stock_ideal_'.$sucursal]."</b>\n".
              "Reponer         : <b>".$cantSugerida."u</b>";
        $notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);
        // NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
        if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
          $notificarDB = ModeloProductos::mdlActualizarProducto('productos', 'notificacion_telegram_'.$sucursal, 1, $valor3);
        }
      }else if($stockActualizado <= ($traerProducto['stock_ideal_'.$sucursal]/$divisorIdeal) && $stockActualizado > 0 && $stockBodegas > 0 && $traerProducto['notificacion_telegram_'.$sucursal] == 0){

        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
        $imagenDB = $traerProducto['imagen']; // Ruta de la imagen que deseas enviar

        $descSiiTG = $traerProducto['desc_sii'];
        $skuTG = $traerProducto['categoria'] < 10 ? '0'.$traerProducto['sku'] : $traerProducto['sku'];

        if(count($bodegas) == 1){
          $zonaTG = $traerProducto['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto['zona_bodega1'].'</b>';
        }else{
          $zonaTG = '';
          for ($i=0; $i < count($bodegasExtraccion); $i++) { 
            $letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
            $nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números          
            $zonaMostrar = $traerProducto['zona_'.$bodegasExtraccion[$i]] == '' ? 's/ZONA' : $traerProducto['zona_'.$bodegasExtraccion[$i]];
            $zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.'</b>) ';
          }
        }

        
        $faltanteEnLocal = $traerProducto['stock_ideal_'.$sucursal] - $stockActualizado;
        $cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;

        $texto =  "Descripción  : <b>".$descSiiTG."</b>\n".
                  "SKU                  : <b>".$skuTG."</b>\n".
                  "Zona                 : ".$zonaTG."\n".
                  "Quedaron    : <b>".$stockActualizado.'/'.$traerProducto['stock_ideal_'.$sucursal]."</b>\n".
                  "Reponer         : <b>".$cantSugerida."u</b>";
        $notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);
        // NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
        if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
          $notificarDB = ModeloProductos::mdlActualizarProducto('productos', 'notificacion_telegram_'.$sucursal, 1, $valor3);
        }
      }
    }
    echo $respuesta = ModeloProductos::mdlActualizarProducto($tabla, $item1, $stockActualizado, $valor3).','.$stockActualizado.','.date("Y-m-d H:i:s");
  }

  /*=============================================
  SUMAR STOCK
  =============================================*/ 
  public function ajaxSumStock(){
    $sucursal = $_SESSION['sucursal'];
    $tabla = "productos";
    $item1 = "stock_".$sucursal;
    $item3 = "id";
    $valor3 = $_POST['sumStock'];
    $traerProducto = ModeloProductos::mdlMostrarProductos('productos', 'id', $valor3, 'id');  
    $valor1 = $traerProducto['stock_'.$sucursal]+1;
    /*------------------------------------------------------------------------*/
    date_default_timezone_set("America/Santiago");
    $fechaModifStock = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$sucursal, date("Y-m-d H:i:s"), $valor3);
    /*------------------------------------------------------------------------*/
    // REGISTRO ACTIVIDAD INVENTARIO
    $ultimoRegistro = ModeloProductos::mdlSeleccionarUltimoIdRegistro();//
    $registroSumaStock = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'stockMas', 1, 'ajuste', $traerProducto['id'], $_SESSION['id'], $_SESSION['nombre']);//
    
    // REGISTRO PERDIDA DE STOCK
    $diaCerrado = ControladorMovimientos::ctrMovSi2LI('fecha', date('Y-m-d'), 'tipo_mov', 'saldo');
    $fechaCont = count($diaCerrado)==0 ? date('Y-m-d') : date('Y-m-d', strtotime('+1 day'));
    $perdidaInventario = ModeloActividadInventario::mdlPerdidaInventario('perdida_inventario', $fechaCont, $sucursal, $_SESSION['id'], $traerProducto['id'], 1, $traerProducto['precio_compra'], $traerProducto['precio_compra']);


    $divisorIdeal = $traerProducto['control_inventario'] == 1 ? 2 : 3; // si es primera prioridad se alerta cuando falta la mitad, si no cuando falta 1/3
    if($valor1 > ($traerProducto['stock_ideal_'.$sucursal]/$divisorIdeal)){ // desactiva notificacion telegram
      $notificarDB = ModeloProductos::mdlActualizarProducto('productos', 'notificacion_telegram_'.$sucursal, 0, $valor3);
    }

    echo $respuesta = ModeloProductos::mdlActualizarProducto($tabla, $item1, $valor1, $valor3).','.$valor1.','.date("Y-m-d H:i:s");
  }

  /*=============================================
  ACTIVAR/DESACTIVAR PRODUCTO
  =============================================*/ 
  public function ajaxActivarProducto(){
    $sucursal = $_SESSION['sucursal'];
    $tabla = "productos";
    $item1 = "estado_".$sucursal;
    $valor1 = $_POST['activarProd'];
    $item2 = "id";
    $valor2 = $_POST['activarId'];
    /*------------------------------------------------------------------------*/
    date_default_timezone_set("America/Santiago");
    $fechaModifStock = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$sucursal, date("Y-m-d H:i:s"), $valor2);
    /*------------------------------------------------------------------------*/
    echo $respuesta = ModeloProductos::mdlActualizar1($tabla, $item1, $valor1, $item2, $valor2);
  }

  /*=============================================
  EDITAR PRODUCTO
  =============================================*/ 
  public function ajaxEditarProducto(){
    if(isset($_POST['traerProductos']) && $_POST['traerProductos'] == "ok"){
      $item = null;
      $valor = null;
      $orden = "id";
      $respuesta = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);
      echo json_encode($respuesta);
    }else if(isset($_POST['nombreProducto']) && $_POST['nombreProducto'] != ""){
      $item = "descripcion";
      $valor = $_POST['nombreProducto'];
      $orden = "id";
      $respuesta = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);
      echo json_encode($respuesta);
    }else{
      $item = "id";
      $valor = $_POST['idProducto'];
      $orden = "id";
      $respuesta = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);
      echo json_encode($respuesta);
    }
  }

  /*=============================================
  CAMBIAR NOMBRE SII PROD 
  =============================================*/ 
  public function ajaxCambiarNombreSii(){
    $tabla = "productos";
    $item = "desc_sii";
    $valor = $_POST['descripcion'];
    $id = $_POST['modifDescSIIProd'];
    echo $cambioNombre = ModeloProductos::mdlActualizarProducto('productos', $item, $valor, $id);
  }

  /*=============================================
  CONTROLAR INVENTARIO 
  =============================================*/ 
  public function ajaxControlarInventario(){
    $tabla = "productos";
    $item = "control_inventario";
    $valor = $_POST['tipoControl'];
    $id = $_POST['controlarInventario'];
    echo $cambioNombre = ModeloProductos::mdlActualizarProducto('productos', $item, $valor, $id).','.$valor;
  }

  /*=============================================
  RELACIONAR PRODUCTO 
  =============================================*/ 
  public function ajaxRelacionarProd(){
    $idProd = $_POST['relacionarProd'];
    $idProdRelacionado = $_POST['prodRelacionado'];
    
    if($idProdRelacionado != 0){
      $prodsRelacionados = ControladorProductos::ctrMostrarProductos('id', $idProd, 'id')['prods_relacionados'];
      if($prodsRelacionados == ''){
        $relacionarProducto = ModeloProductos::mdlActualizarProducto('productos', 'prods_relacionados', $idProdRelacionado, $idProd);
      }else{
        $arrayRelacionados = explode(',', $prodsRelacionados);
        $listaRelacionados = '';
        for ($i=0; $i < count($arrayRelacionados); $i++) { 
          $listaRelacionados .= $arrayRelacionados[$i].',';
        }
        $listaRelacionados .= $idProdRelacionado;
        $relacionarProducto = ModeloProductos::mdlActualizarProducto('productos', 'prods_relacionados', $listaRelacionados, $idProd);
      }
    }else{
      $relacionarProducto = 'error'; 
    }
    echo $relacionarProducto.','.$idProdRelacionado;
  }

  /*=============================================
  QUITAR RELACION PRODUCTO
  =============================================*/ 
  public function ajaxQuitarRelacionProd(){
    $idProd = $_POST['quitarRelacionProd'];
    $idProdRelacionado = $_POST['prodRelacionado'];
    $prodsRelacionados = ControladorProductos::ctrMostrarProductos('id', $idProd, 'id')['prods_relacionados'];
    $arrayRelacionados = explode(',', $prodsRelacionados);
    $arrayConRelacionQuitada = array_diff($arrayRelacionados, array($idProdRelacionado));
    
    $arrayIterar = array_values($arrayConRelacionQuitada);
    $listaRelacionados = '';
    for ($i=0; $i < count($arrayIterar); $i++) { 
      $listaRelacionados .= $arrayIterar[$i].',';
    }
    $listaRelacionados = substr($listaRelacionados, 0, -1);

    $listaDB = $listaRelacionados == 0 ? '' : $listaRelacionados;

    $actualizarRelacion = ModeloProductos::mdlActualizarProducto('productos', 'prods_relacionados', $listaDB, $idProd);
    echo $actualizarRelacion.'///'.$listaRelacionados;
  }

  /*=============================================
  MODIFICAR EMBALAJE
  =============================================*/ 
  public function ajaxModifEmbalajeCompraProd(){
    $idProd = $_POST['modifEmbalajeCompra'];
    $cant = $_POST['cantEmbalajeCompra'];
    echo $modificarEmbalajeCompra = ModeloProductos::mdlActualizarProducto('productos', 'embalaje_compra', $cant, $idProd);
  }

  /*=============================================
  MODIFICAR ZONA ENTREGA PROD
  =============================================*/ 
  public function ajaxZonaEntregaProd(){
    $idProd = $_POST['modifEntregaProd'];
    $zonaEntrega = $_POST['sectorEntregaProd'];
    echo $modificarEntregaProd = ModeloProductos::mdlActualizarProducto('productos', 'zona_prod', $zonaEntrega, $idProd);
  }

  /*=============================================
  CAMBIAR NOMBRE PROD (descripcion) 
  =============================================*/ 
  public function ajaxCambiarDescripcion(){
    $tabla = "productos";
    $item = "descripcion";
    $valor = $_POST['descripcion'];
    $id = $_POST['modifDescripcion'];
    echo $cambioNombre = ModeloProductos::mdlActualizarProducto('productos', $item, $valor, $id);
  }

  /*=============================================
  CAMBIAR NOMBRE2 PROD  (descripcion2) 
  =============================================*/ 
  public function ajaxCambiarDescripcion2(){
    $tabla = "productos";
    $item = "descripcion2";
    $valor = $_POST['descripcion'];
    $id = $_POST['modifDescripcion2'];
    echo $cambioNombre = ModeloProductos::mdlActualizarProducto('productos', $item, $valor, $id);
  }

  /*=============================================
  EDITAR PRECIO COMPRA
  =============================================*/ 
  public function ajaxModifPrecioCompra(){
    date_default_timezone_set("America/Santiago");
    $tabla = "productos";
    $item1 = "pc_neto";
    $valor1 = $_POST['pCNetoAjax'];
    $item2 = "precio_compra";
    $valor2 = $_POST['pCompraAjax'];
    $item3 = "id";
    $valor3 = $_POST['modifPCompra'];
    /*------------------------------------------------------------------------*/
    $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "local");
    foreach ($sucursales as $key => $value) {
      $fechaModifPVenta = ModeloProductos::mdlActualizarProducto('productos', "fecha_modif_".$value['nombre_sucursal'], date("Y-m-d H:i:s"), $valor3);
    }
    /*------------------------------------------------------------------------*/    
    echo $respuesta = ModeloProductos::mdlActualizar2($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3).','.date("Y-m-d H:i:s");
  }

  /*=============================================
  AGREGAR PROVEEDOR VIA AJAX
  =============================================*/ 
  public function ajaxAgregarProvProd(){
    date_default_timezone_set("America/Santiago");
    $idProd = $_POST['agregarProvProd'];
    $idProv = $_POST['idProvNew'];
    $sku = $_POST['skuProvNew'];
    $pNeto =  $_POST['pNetoProvNew'];
    $infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);

    $lista_proveedores_new = $infoProd['lista_proveedores'].','.$idProv;
    $arrayListaJson = json_decode($infoProd['lista_provs_json'], true);
    $newProv = ["prov" => $idProv, "cod_prov" => $sku, "pc_neto" => $pNeto];
    $arrayListaJson[] = $newProv;

    $jsonNuevoProd = json_encode(array_values($arrayListaJson));
    echo $respuesta = ModeloProductos::mdlActualizar2('productos', 'lista_proveedores', $lista_proveedores_new, 'lista_provs_json', $jsonNuevoProd, 'id', $idProd).','.date("Y-m-d H:i:s");
  }

  /*=============================================
  AGREGAR PROVEEDOR VIA AJAX
  =============================================*/ 
  public function ajaxDatosProvProd(){
    $idProd = $_POST['datosProvProd'];
    $idProv = $_POST['idProvProd'];
    $infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);
    $arrayListaJson = json_decode($infoProd['lista_provs_json'], true);
    foreach ($arrayListaJson as $item) {
        if ($item['prov'] == $idProv) {
            $cod_prov = $item['cod_prov'];
            $pc_neto = $item['pc_neto'];
            break;
        }
    }
    echo $cod_prov.','.$pc_neto;
  }

  /*=============================================
  EDITAR PROVEEDOR PRODUCTO
  =============================================*/ 
  public function ajaxEditProvProd(){
    $idProd = $_POST['editProvProd'];
    $idProv = $_POST['idEditProvProd'];
    $skuProv = $_POST['skuEditProvProd'];
    $pcNetoProv = $_POST['pcNetoEditProvProd'];
    $infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);
    $arrayListaJson = json_decode($infoProd['lista_provs_json'], true);
    foreach ($arrayListaJson as $key => $element) {
        if(isset($element['prov']) && $element['prov'] == $idProv) {
            unset($arrayListaJson[$key]); // elimina la clave
        }
    }
    $actualizarProv = ["prov" => $idProv, "cod_prov" => $skuProv, "pc_neto" => $pcNetoProv];
    $arrayListaJson[] = $actualizarProv;
    $jsonFinal = json_encode(array_values($arrayListaJson));
    echo $listaProvsJson = ModeloProductos::mdlActualizarProducto('productos', "lista_provs_json", $jsonFinal, $idProd);
  }

  /*=============================================
  EDITAR PRODUCTO
  =============================================*/ 
  public function ajaxEditarProdAjax(){

    $sucursal = $_SESSION['sucursal'];
    $tabla = "productos";   
    /*=============================================
    VALIDAR IMAGEN
    =============================================*/
    $ruta = $_POST["imagenActual"];

    if(isset($_FILES["editarImagen"]["tmp_name"])){

      $ubicacionTemporal = $_FILES["editarImagen"]["tmp_name"];
      $extension = pathinfo($_FILES["editarImagen"]["name"], PATHINFO_EXTENSION);
      $rutaCarpeta = dirname($ruta);

      if(file_exists("../".$ruta) && $ruta != 'componentes/img/productos/default/anonymous.png'){
        unlink('../'.$ruta);
      }

      if (!file_exists("../".$rutaCarpeta."/")) {
          mkdir("../".$rutaCarpeta."/", 0755, true); // permisos + recursivo
      }

      $datosProd = infoPorId($tabla,$_POST["editarProd"]);
      $cat = $datosProd['categoria'] < 10 ? '0'.$datosProd['categoria'] : $datosProd['categoria'];
      $subcat = $datosProd['subcategoria'] < 10 ? '0'.$datosProd['subcategoria'] : $datosProd['subcategoria'];
      $rutaImgProd = 'componentes/img/productos/'.$cat.$subcat;

      $idUnico = substr(str_replace('.', '', microtime(true)), -8);
      $nombreArchivo = $_POST["editarCodigoInterno"].'_' . $idUnico . '.'.$extension;
      
      $rutaArchivo = $rutaImgProd.'/'.$nombreArchivo;
      // move_uploaded_file($ubicacionTemporal, '../'.$rutaArchivo);


      list($ancho, $alto) = getimagesize($_FILES["editarImagen"]["tmp_name"]);
      $nuevoAncho = 500;
      $nuevoAlto = 500;

      if($_FILES["editarImagen"]["type"] == "image/jpeg"){
        // =============================================
        // GUARDAMOS LA IMAGEN EN EL DIRECTORIO
        // =============================================
        $ruta = "../".$rutaArchivo;
        $origen = imagecreatefromjpeg($_FILES["editarImagen"]["tmp_name"]);       
        $destino = imagecreatetruecolor($nuevoAncho, $nuevoAlto);
        imagecopyresized($destino, $origen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $ancho, $alto);
        imagejpeg($destino, $ruta);
      }
      if($_FILES["editarImagen"]["type"] == "image/png"){
        // =============================================
        // GUARDAMOS LA IMAGEN EN EL DIRECTORIO
        // =============================================
        $ruta = "../".$rutaArchivo;
        $origen = imagecreatefrompng($_FILES["editarImagen"]["tmp_name"]);            
        $destino = imagecreatetruecolor($nuevoAncho, $nuevoAlto);
        imagecopyresized($destino, $origen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $ancho, $alto);
        imagepng($destino, $ruta);
      }

    }else{
      
      $rutaArchivo = $ruta;
    
    }



    if($_POST["editarManejaStock"] == 'NO'){
      $stockIdeal = 0;
      $embalajeCompra = 0;
      $zonaEntrega = '';
    }else{
      $stockIdeal = $_POST["editarStockIdeal"];
      $embalajeCompra = $_POST["editarEmbalajeCompraProd"];
      $zonaEntrega = $_POST["editarZonaEntregaProd"];
    }

    // FECHA MODIFICACION PRODUCTO SEGUN LOCAL

    $datos = array( "descripcion" => $_POST["editarDescripcion"],
              "descripcion2" => $_POST["nombreAlternativo"],
              "desc_sii" => $_POST["editarDescSii"],
              "codigo" => $_POST["editarProd"],
              "cod_proveedor" => $_POST["codigoProveedorEditar"],
              "proveedor" => $_POST["editarProveedorProducto"],
              "nom_prov" => $_POST["nomProvEdit"],
              "id_trab" => $_SESSION['id'],
              "nom_trab" => $_SESSION['nombre'],
              "maneja_stock" => $_POST["editarManejaStock"],
              "embalaje_compra" => $embalajeCompra,
              "zona_prod" => $zonaEntrega,
              "descuento" => $_POST["editarDescuentoMaximo"],
              "precio_compra" => $_POST["editarPrecioCompra"],
              "pc_neto" => $_POST["editarPrecioCompraNeto"],
              "precio_venta" => $_POST["editarPrecioVenta"],
              "mayor_sobre" => $_POST["editarMayoreo"],
              "precio_mayor" => $_POST["editarPrecioMayor"],
              "imagen" => $rutaArchivo,
              "stock_ideal_".$sucursal=> $stockIdeal,
              "zona_".$sucursal => $_POST["editarUbicacion"]);

    echo $respuesta = ModeloProductos::mdlEditarProducto($tabla, $datos);
    echo '///'.ControladorProductos::ctrCargarFilaProdAdmin($_POST["editarProd"]);

  }

  /*=============================================
  ELIMINAR PRODUCTO
  =============================================*/ 
  public function ajaxEliminarProdAjax(){
    $tabla ="productos";

    if(file_exists("../".$_POST["imagen"]) && $_POST["imagen"] != 'componentes/img/productos/default/anonymous.png'){
      unlink('../'.$_POST["imagen"]);
    }
    echo $respuesta = ModeloProductos::mdlEliminarProducto($tabla, $_POST['deleteProd']);
  }



  /*=============================================
  CREAR PRODUCTO
  =============================================*/ 
  public function ajaxCrearProdAjax(){

    $tabla = "productos";
    $subCodInterno = $_POST["codigoInterno2"];        
    // codigo interno CORRELATIVO sin zona 
    $item="ult_sub_cod_int";
    $item_coincidencia = "sub_cod_int";
    $valor = $subCodInterno;
    $ultimoSubCod1 = ControladorProductos::ctrSeleccionarItem($tabla, $item, $item_coincidencia, $valor);
    
    //crea nro correlativo cuando conincide la categoria y la subcategoria 
    if($ultimoSubCod1>=10){
      $ultimoSubCod = $ultimoSubCod1+1;
    }else{
      $ultimoSubCod = str_pad($ultimoSubCod1+1, 2, "0", STR_PAD_LEFT); //anteponer cero si es menor que 10
    }

    $codIntSinZona = $subCodInterno.$ultimoSubCod; // crea codigo interno sin zona

    //codigo de barra, si no hay codigo de barra asigna("sinCog(codigointerno)")
    $codigo =  $_POST["nuevoCodigo"];
    if($codigo == "" || $codigo =="-"){
      $codigoFinal = "sinCOD(".$codIntSinZona.")";
    }else{
      $codigoFinal = $codigo;
    }

    /*=============================================
    SI NO MANEJA STOCK
    =============================================*/
    if($_POST["manejaStock"] == 'NO'){
      $stockIdeal = 0;
      $embalajeCompra = 0;
      $zonaEntrega = '';
    }else{
      $stockIdeal = $_POST["nuevoStockIdeal"];
      $embalajeCompra = $_POST["embalajeCompraProd"];
      $zonaEntrega = $_POST["zonaEntregaProd"];
    }

    /*=============================================
    VALIDAR IMAGEN
    =============================================*/
    $ruta = "componentes/img/productos/default/anonymous.png"; // Imagen por defecto

    if (!empty($_FILES["nuevaImagen"]["tmp_name"])) {
      $archivoTemporal = $_FILES["nuevaImagen"]["tmp_name"];
        
      // Verificar si es una imagen válida antes de llamar a getimagesize()
      if (@getimagesize($archivoTemporal)) {
        list($ancho, $alto) = getimagesize($archivoTemporal);
        $nuevoAncho = 500;
        $nuevoAlto = 500;

        /*================================================
        CREAMOS EL DIRECTORIO DONDE ALMACENAREMOS IMÁGENES
        =================================================*/
        $carpetaCatSubcat = "../componentes/img/productos/".$subCodInterno;
        if (!file_exists($carpetaCatSubcat)) {
            mkdir($carpetaCatSubcat, 0755, true);
        }

        /*=============================================
        PROCESAMOS SEGÚN EL TIPO DE IMAGEN
        =============================================*/
        $tipoImagen = $_FILES["nuevaImagen"]["type"];
        $nombreArchivo = $carpetaCatSubcat."/".$codIntSinZona;
        if ($tipoImagen == "image/jpeg") {
          $ruta = $nombreArchivo.".jpg";
          $origen = imagecreatefromjpeg($archivoTemporal);
          $destino = imagecreatetruecolor($nuevoAncho, $nuevoAlto);
          imagecopyresized($destino, $origen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $ancho, $alto);
          imagejpeg($destino, $ruta);
        } elseif ($tipoImagen == "image/png") {
          $ruta = $nombreArchivo.".png";
          $origen = imagecreatefrompng($archivoTemporal);
          $destino = imagecreatetruecolor($nuevoAncho, $nuevoAlto);
          imagecopyresized($destino, $origen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $ancho, $alto);
          imagepng($destino, $ruta);
        } else {
          // Si el tipo de imagen no es válido, se mantiene la imagen por defecto
          $ruta = "../componentes/img/productos/default/anonymous.png";
        }
      } else {
        // Si el archivo no es una imagen válida, usar la imagen por defecto
        $ruta = "../componentes/img/productos/default/anonymous.png";
      }
    }

    $idCat = $_POST["nuevaCategoria"];
    $nomCat = ModeloCategorias::mdlMostrarCategorias('categorias', 'id', $idCat)['categoria'];

    $idSubcat = $_POST["nuevaSubcategoria"];
    $nomSubcat = ControladorCategorias::ctrSeleccionarSubcategoria1('subcategorias', 'id_subcategoria', $idSubcat, 'categoria_padre', $idCat)['subcategoria'];


    $arrayListaJson = [];
    $provJson = ["prov" => $_POST["proveedorProducto"], "cod_prov" => $_POST["codigoProveedor"], "pc_neto" => $_POST["nuevoPrecioCompraNeto"]];
    $arrayListaJson[] = $provJson;
    $jsonProvProd = json_encode(array_values($arrayListaJson));

    $aliasEmpresa = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'alias_nombre_comercial')['ajuste'];

    // datos para mysql
    $datos = array("nom_prov" => $_POST["provProdDB"],
             // "propietario" => $aliasEmpresa,
             "prods_relacionados" => "",
             "id_trab" => $_SESSION['id'],
             "nom_trab" => $_SESSION['nombre'],
             "categoria" => $idCat,
             "cat_nom" => $nomCat,
             "subcategoria" => $idSubcat,
             "subcat_nom" => $nomSubcat,
             "proveedor" => $_POST["proveedorProducto"],
             "lista_proveedores" => $_POST["proveedorProducto"],
             "lista_provs_json" => $jsonProvProd,
             "sub_cod_int" => $subCodInterno,
             "sku" => $codIntSinZona,
             "codigo" => $codigoFinal,
             "cod_proveedor" => $_POST["codigoProveedor"],
             "descripcion" => $_POST["nuevaDescripcion"],
             "descripcion2" => $_POST["descripcionAlternativa"],
             "desc_sii" => $_POST["descripcionSii"],
             "ult_sub_cod_int" => $ultimoSubCod,
             "maneja_stock" => $_POST["manejaStock"],
             "embalaje_compra" => $embalajeCompra,
             "zona_prod" => $zonaEntrega,
             "precio_compra" => $_POST["nuevoPrecioCompra"],
             "pc_neto" => $_POST["nuevoPrecioCompraNeto"],
             "precio_venta" => $_POST["nuevoPrecioVenta"],
             "descuento" => $_POST["descuentoMaximo"],
             "mayor_sobre" => $_POST["mayoreo"],
             "precio_mayor" => $_POST["precioMayor"],
             "imagen" => substr($ruta, 3),
             "stock_ideal_local1" => $stockIdeal,
             "estado_local1" => 1);
    echo $respuesta = ModeloProductos::mdlIngresarProducto($tabla, $datos);
    $ultimoId = explode('///', $respuesta)[1];
    echo '///'.ControladorProductos::ctrCargarFilaProdAdmin($ultimoId);
  }

}
/*=============================================
CREAR PROD
=============================================*/
if(isset($_POST['nuevaDescripcion'])){
  $crearProd = new AjaxProductos();
  $crearProd -> ajaxCrearProdAjax();
}

/*=============================================
EDITAR PROD
=============================================*/
if(isset($_POST['deleteProd'])){
  $deleteProd = new AjaxProductos();
  $deleteProd -> ajaxEliminarProdAjax();
}

/*=============================================
EDITAR PROD
=============================================*/
if(isset($_POST['editarProd'])){
  $editProd = new AjaxProductos();
  $editProd -> ajaxEditarProdAjax();
}

/*=============================================
EDITAR PROVEEDOR PRODUCTO
=============================================*/ 
if(isset($_POST['editProvProd'])){
  $editProvProd = new AjaxProductos();
  $editProvProd -> ajaxEditProvProd();
}

/*=============================================
DATOS PROVEEDOR PRODUCTO
=============================================*/ 
if(isset($_POST['datosProvProd'])){
  $datosProvProd = new AjaxProductos();
  $datosProvProd -> ajaxDatosProvProd();
}

/*=============================================
AGREGAR PROVEEDOR VIA AJAX
=============================================*/ 
if(isset($_POST['agregarProvProd'])){
  $agregarProvProd = new AjaxProductos();
  $agregarProvProd -> ajaxAgregarProvProd();
}

/*=============================================
EDITAR PRECIO COMPRA
=============================================*/ 
if(isset($_POST['modifPCompra'])){
  $modifPrecioCompra = new AjaxProductos();
  $modifPrecioCompra -> ajaxModifPrecioCompra();
}

/*=============================================
CAMBIAR NOMBRE2 PROD (descripcion2) 
=============================================*/ 
if(isset($_POST['modifDescripcion2'])){
  $modifDescripcion2 = new AjaxProductos();
  $modifDescripcion2 -> ajaxCambiarDescripcion2();
}

/*=============================================
CAMBIAR NOMBRE PROD (descripcion) 
=============================================*/ 
if(isset($_POST['modifDescripcion'])){
  $modifDescripcion1 = new AjaxProductos();
  $modifDescripcion1 -> ajaxCambiarDescripcion();
}


/*=============================================
MODIFICAR ZONA ENTREGA PROD
=============================================*/ 
if(isset($_POST['modifEntregaProd'])){
  $zonaEntrega = new AjaxProductos();
  $zonaEntrega -> ajaxZonaEntregaProd();
}



/*=============================================
MODIFICAR EMBALAJE
=============================================*/ 
if(isset($_POST["modifEmbalajeCompra"])){
  $modifEmbalajeCompra = new AjaxProductos();
  $modifEmbalajeCompra -> ajaxModifEmbalajeCompraProd();
}

/*=============================================
QUITAR RELACION PRODUCTO
=============================================*/ 
if(isset($_POST["quitarRelacionProd"])){
  $quitarRelacion = new AjaxProductos();
  $quitarRelacion -> ajaxQuitarRelacionProd();
}

/*=============================================
RELACIONAR PRODUCTO
=============================================*/ 
if(isset($_POST["relacionarProd"])){
  $relacionarProd = new AjaxProductos();
  $relacionarProd -> ajaxRelacionarProd();
}

/*=============================================
CONTROLAR INVENTARIO 
=============================================*/ 
if(isset($_POST["controlarInventario"])){
  $controlarInventario = new AjaxProductos();
  $controlarInventario -> ajaxControlarInventario();
}

/*=============================================
CAMBIAR NOMBRE SII PROD 
=============================================*/ 
if(isset($_POST["modifDescSIIProd"])){
  $cambiarNombreSii = new AjaxProductos();
  $cambiarNombreSii -> ajaxCambiarNombreSii();
}

/*=============================================
ACTIVAR PRODUCTO
=============================================*/ 
if(isset($_POST["activarProd"])){
  $activarProd = new AjaxProductos();
  $activarProd -> ajaxActivarProducto();
}


/*=============================================
RESTAR STOCK
=============================================*/ 
if(isset($_POST["restStock"])){
  $restStock = new AjaxProductos();
  $restStock -> ajaxRestStock();
}

/*=============================================
RESTAR STOCK
=============================================*/ 
if(isset($_POST["sumStock"])){
  $sumStock = new AjaxProductos();
  $sumStock -> ajaxsumStock();
}

/*=============================================
ACTUALIZAR UBICACION
=============================================*/ 
if(isset($_POST["modifUbic"])){
  $editUbic = new AjaxProductos();
  $editUbic -> ajaxEditUbic();
}

/*=============================================
ESCRIBIR STOCK
=============================================*/ 
if(isset($_POST["editStock"])){
  $editStock = new AjaxProductos();
  $editStock -> ajaxeditStock();
}

/*=============================================
MODIFICAR PRECIO VENTA
=============================================*/ 
if(isset($_POST["modifPVenta"])){
  $pVenta = new AjaxProductos();
  $pVenta -> ajaxPVenta();
}

/*=============================================
MODIFICAR MAYOR DESDE MENOS
=============================================*/ 
if(isset($_POST["mayDesdMenos"])){
  $mayDesdMenos = new AjaxProductos();
  $mayDesdMenos -> ajaxMayDesdMenos();
}

/*=============================================
MODIFICAR MAYOR DESDE MAS
=============================================*/ 
if(isset($_POST["mayDesdMas"])){
  $mayDesdMas = new AjaxProductos();
  $mayDesdMas -> ajaxMayDesdMas();
}

/*=============================================
SUBIR STOCK IDEAL CON CLICK
=============================================*/ 
if(isset($_POST["stockIdeal"])){
  $stockIdealMas = new AjaxProductos();
  $stockIdealMas -> ajaxStockIdealMas();
}

/*=============================================
BAJAR STOCK IDEAL CON CLICK
=============================================*/ 
if(isset($_POST["stockIdealResta"])){
  $stockIdealMas = new AjaxProductos();
  $stockIdealMas -> ajaxStockIdealMenos();
}

/*=============================================
EDITAR PRODUCTO
=============================================*/ 
if(isset($_POST["idProducto"])){
  $editarProducto = new AjaxProductos();
  $editarProducto -> ajaxEditarProducto();
}

/*=============================================
CONFIGURACION PRODUCTO TRANSFORMABLE
=============================================*/ 
if(isset($_POST["idProdBase"])){
  $configProdTrasnf = new AjaxProductos();
  $configProdTrasnf -> ajaxConfigProdTransf();
}

/*=============================================
SURTIR PRODUCTO TRANSFORMABLE
=============================================*/ 
if(isset($_POST["idProdTransf"])){
  $surtirProd = new AjaxProductos();
  $surtirProd -> ajaxSurtirAlChico();
}

/*=============================================
DATOS PRODUCTO TRANSFORMABLE EDIT
=============================================*/ 
if(isset($_POST["idProdTransfEdit"])){
  $idsProdsVinculadosTransf = new AjaxProductos();
  $idsProdsVinculadosTransf -> ajaxDatosProdsVinculadosTransf();
}

/*=============================================
TODOS LOS PRODUCTOS
=============================================*/ 
if(isset($_POST["traerProds"])){
  $todosLosProds = new AjaxProductos();
  $todosLosProds -> traerProdsAll();
}

/*=============================================
EDITAR CONFIGURACION PRODUCTO TRASNFORMABLE
=============================================*/
if(isset($_POST["idProdBaseEdit"])){
  $todosLosProds = new AjaxProductos();
  $todosLosProds -> ajaxConfigProdTransfEdit();
}

/*=============================================
ELIMINAR PRODUCTO TRASNFORMABLE
=============================================*/
if(isset($_POST["elimProdTransfBase"])){
  $elimProdTransf = new AjaxProductos();
  $elimProdTransf -> ajaxElimProdTrasnf();
}

/*=============================================
CHECK STOCK PRODUCTO
=============================================*/
if(isset($_POST["checkStock"])){
  $checkStockProd = new AjaxProductos();
  $checkStockProd -> ajaxCheckStockProd();
}