<?php
session_start();
require_once '../controladores/ventas.controlador.php';
require_once '../modelos/ventas.modelo.php';

class TablaVentas{

 	/*=============================================
 	 MOSTRAR LA TABLA DE VENTAS
  	=============================================*/ 

	public function mostrarTablaVentas(){
		$sucursal = $_SESSION['sucursal'];
		$ultCierre = $_GET['ultCierre'];
		$ventana = $_GET['ventana'];


		if($ventana == 'ventas-all-movil'){
			$item = null;
		 	$valor = null;
	  		$orden = 'id';
	  		$compItem = '=';
			$compEstado = '!=';
			$estado = 0;
			$filOrden = 'cod_venta';
			$ord = 'DESC';
	  		$ventas = ControladorVentas::ctrMostrarVentas($item, $valor, $compItem, $compEstado, $estado, $filOrden, $ord);
		}else if($ventana == 'ventas-anio-movil'){
			$tabla = 'ventas';
			$item = 'fecha_cont';
			$fechaInicial = date('Y-m-d', strtotime('-1 year'));;
			$hoy = date('Y-m-d', strtotime('+1 day'));
			$ventas = ModeloVentas::mdlMostrarVentasIntervalo($tabla, $item, $fechaInicial, $hoy);	  		
		}else if($ventana == 'ventas-movil'){
			$tabla = 'ventas';
			$item = 'fecha_cont';
			$fechaInicial = date('Y-m-d', strtotime('-1 month'));;
			$hoy = date('Y-m-d', strtotime('+1 day'));
			$ventas = ModeloVentas::mdlMostrarVentasIntervalo($tabla, $item, $fechaInicial, $hoy);
		}


  		if(count($ventas) == 0){

  			echo "{'data': []}";

		  	return;
  		}	
		
  		$datosJson = '{
		  "data": [';


	  	foreach ($ventas as $i => $value) {

	  		if($value['estado']!=0 && $value['sucursal_venta'] == $sucursal){  // FILTRA TODAS LAS VENTAS NO ELIMINADAS Y QUE SEAN DE LA MISMA SUCURSAL

	            if($value['fecha_cont'] > $ultCierre || $_SESSION['perfil']=='Administrador'){
	            	$botonesEdit = "<button class='btn btn-sm btn-warning btnEditarVenta info' idVenta='".$ventas[$i]['id']."' data-original-title='Editar Venta'><i class='fa fa-pen'></i></button><button class='btn btn-sm btn-danger btnEliminarVenta info' idVenta='".$ventas[$i]['id']."' data-original-title='Eliminar Venta'><i class='fa fa-times'></i></button>";
	            }else{
	            	$botonesEdit = '';
	            }


              	$productos=json_decode($ventas[$i]["productos"]);
				$listaProds = "";

				/*--------------------------------- FILTRO PARA NO MOSTRAR INFO DE VENTAS A PRECIO COMPRA A FERRETERIA Y SOCIOS -------------------------------------------*/
				if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){
					$listaProds = $productos[0]->cant." <b>(".$productos[0]->sku.")</b> ".$productos[0]->prod;
				}else{
					$listaProds = $productos[0]->cant." <b>(".$productos[0]->sku.")</b> ".$productos[0]->prod." →<i><b>$".number_format($productos[0]->pV, 0, ',', '.')." c/u</b></i>";
				}
			
            	for($ia=1;$ia<count($productos);$ia++){ 
                $cantidad = "<br>".$productos[$ia]->cant;
                $descripcion = $productos[$ia]->prod;
                $pV = $productos[$ia]->pV;
				if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){
                	$productosComprados[$ia] = $cantidad." <b>(".$productos[$ia]->sku.")</b> ".$descripcion;
				}else{
                	$productosComprados[$ia] = $cantidad." <b>(".$productos[$ia]->sku.")</b> ".$descripcion." →<i><b>$".number_format($pV, 0, ',', '.')." c/u</b></i>";
				}
                // JUNTAMOS VARIABLES EN UNA MISMA LISTA
				$listaProds .= $productosComprados[$ia];               	
            	}

				$met_pago=json_decode($ventas[$i]["metodo_pago"]);
				$idMetPago = 'metPago'.$ventas[$i]['id'];


				if($ventas[$i]["tipo_pago"] == "Efectivo"){
					$cash = number_format($met_pago[0]->cash, 0, ',', '.');
					$vuelto = number_format($met_pago[0]->vuelto, 0, ',', '.');
					if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
		                $metodo_pago = '<b>[Efectivo]</b>';
						$total = '';
					}else{
						$total = number_format($met_pago[0]->total, 0, ',', '.');
		                $metodo_pago = '<b>[Efectivo]</b> Monto: $'.' '.$total;
					}
				}else if($ventas[$i]["tipo_pago"] == "Transferencia"){
					if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<b>[Transferencia]</b>';
					}else{
						$metodo_pago = '<b>[Transferencia]</b> Monto: $'.number_format($ventas[$i]["metodo_pago"], 0, ',', '.');						
					}
				}else if($ventas[$i]["tipo_pago"] == "TD"){
					if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<b>[Tarjeta Debito]</b>';
					}else{
						$metodo_pago = '[<b>Tarjeta Debito</b> '.$ventas[$i]["metodo_pago"].'] <b>$'.number_format($ventas[$i]["total"],0,',','.').'</b>';
					}
				}else if($ventas[$i]["tipo_pago"] == "TC"){
					if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<b>[Tarjeta Credito]</b>';
					}else{
						$metodo_pago = '[<b>Tarjeta Credito</b> '.$ventas[$i]["metodo_pago"].'] <b>$'.number_format($ventas[$i]["total"],0,',','.').'</b>';
					}
				}else if($ventas[$i]["tipo_pago"] == "E_TD"){
					$cash = number_format($met_pago[0]->cash, 0, ',', '.');
					$tarjeta = number_format($met_pago[0]->tarjeta, 0, ',', '.');
					$codigo = $met_pago[0]->cod;
					if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<b>[Pago Combinado]</b>';
					}else{
						$metodo_pago = '<b>[Pago Combinado]</b><br>Cash: $'.$cash." <b>TD-".$codigo."</b> ($".$tarjeta.")";
					}
				}else if($ventas[$i]["tipo_pago"] == "E_TC"){
					$cash = number_format($met_pago[0]->cash, 0, ',', '.');
					$tarjeta = number_format($met_pago[0]->tarjeta, 0, ',', '.');
					$codigo = $met_pago[0]->cod;
					if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<b>[Pago Combinado]</b>';
					}else{
						$metodo_pago = '<b>[Pago Combinado]</b> Cash: $ '.$cash."<br>TC-".$codigo." ($".$tarjeta.")";
					}
				}else if($ventas[$i]["tipo_pago"] == "Fiado"){
					if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<b>[Credito Interno]</b>';
					}else{
						$metodo_pago = '<b>[Credito Interno]</b> Monto: $'.number_format($ventas[$i]["total"], 0, ',', '.');
					}
				}else if($ventas[$i]["tipo_pago"] == "Pend"){
					if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<b>[Pendiente]</b>';
					}else{
						$metodo_pago = '<b>[Pendiente]</b> Monto: $'.number_format($ventas[$i]["total"], 0, ',', '.');
					}
				}

				// TOTAL CON O SIN DESCUENTO
				if($ventas[$i]["descuentos"]!=0){
					if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$total = '';
					}else{
						$total = "<font class='float-right'>$ ".number_format(($ventas[$i]["total"]+$ventas[$i]["descuentos"]), 0, ',', '.')."</font><br><font class='float-right' color='red'>-$ " .number_format($ventas[$i]["descuentos"], 0, ',', '.')."</font><br><b class='float-right'>$ ".number_format($ventas[$i]["total"], 0, ',', '.')."</b>";
					}					
				}else{
					if($ventas[$i]['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$total = '';
					}else{
						$total = "<b class='float-right'>$ ".number_format($ventas[$i]["total"], 0, ',', '.')."</b>";
					}
				}


                if($_SESSION["perfil"] == "Administrador"){    
			  		$botones =  "<div class='btn-group'><button class='btn btn-info btn-sm btnImprimirVentaCarta info' codigoVenta='".$ventas[$i]['id']."' data-original-title='Ver PDF'><i class='fa fa-file'></i></button>".$botonesEdit."</div>";
			  	}else if($ventas[$i]['vista_vendedor']==0 && $_SESSION["perfil"]=="Vendedor"){
                    $botones = '';
			  	}else{
			  		$botones =  "<div class='btn-group'><button class='btn btn-info btn-sm btnImprimirVentaCarta info' codigoVenta='".$ventas[$i]['id']."' data-original-title='Ver PDF'><i class='fa fa-file'></i></button></div>";
			  	}

                $fecha = explode(" ",$ventas[$i]["fecha_venta"]);
                $fechaVent = "<b>".$fecha[0]."</b> ".$fecha[1];
				
                $detalleVenta = $ventas[$i]['detalle_venta'] == '' ? "" : "<b><i>'".$ventas[$i]['detalle_venta']."'</i></b><br>";

                // $nombreCliente = $ventas[$i]['nom_client'] == '-' ? 'Cliente Comun' : strtoupper($ventas[$i]['nom_client']);
                $columna2 =	"<font class='info' data-original-title='Fecha Contable'>".$ventas[$i]['fecha_cont']."</font> <b class='info' data-original-title='Nro Venta'>(".$ventas[$i]['cod_venta'].")</b><br>".
                			"<font style='color:blue'>Cliente: <b>".strtoupper($ventas[$i]['nom_client'])."</b></font><br>".
                			$metodo_pago."<br>".
                			$detalleVenta."<br>".
                			$botones;

				  	$datosJson .='[
					      "'.$columna2.'",
					      "'.$listaProds.'",
					      "'.$fechaVent.'"
					    ],';

				}
				
		  	}

		  $datosJson = substr($datosJson, 0, -1);

		  $datosJson .=   '] 

		 }';
		
		echo $datosJson;


	}


}

/*=============================================
ACTIVAR TABLA DE VENTAS
=============================================*/ 
$actTblVentas = new TablaVentas();
$actTblVentas -> mostrarTablaVentas();