<?php
session_start();
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";
require_once "../controladores/categorias.controlador.php";
require_once "../modelos/categorias.modelo.php";
require_once "../controladores/proveedores.controlador.php";
require_once "../modelos/proveedores.modelo.php";


class TablaProductos{

 	/*=============================================
 	 MOSTRAR LA TABLA DE PRODUCTOS
  	=============================================*/ 

	public function mostrarTablaProductos(){

	    $sucursal = $_SESSION['sucursal'];
		$item = "estado_".$sucursal;
    	$valor = 1;
    	$orden = "id";

  		$productos = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);	

  		if(count($productos) == 0){

  			echo '{"data": []}';

		  	return;
  		}
		
  		$datosJson = '{
		  "data": [';
		  // count trae la cantidad de productos
		  for($i = 0; $i < count($productos); $i++){
  			$stockActual = $productos[$i]["stock_".$sucursal];
  			$stockIdeal = $productos[$i]['stock_ideal_'.$sucursal];
  			if($stockActual <= $stockIdeal/3){
				$estado_stock = 1;
  			}else if($stockActual > $stockIdeal/3 && $stockActual <= $stockIdeal*2/3){
				$estado_stock = 2;
  			}else{
				$estado_stock = 3;
  			}

			if($estado_stock == 1){

				$stock = "<div class='btn-group'><button class='btn btn-danger' style='width:50px'>".$stock."</button>";


			}else if($estado_stock == 2){
						
				$stock = "<div class='btn-group'><button class='btn btn-warning' style='width:50px'>".$stock."</button>";

			}else{

				$stock = "<div class='btn-group'><button class='btn btn-success' style='width:50px'>".$stock."</button>";
			}	  					
			$descripcion = "<font size='+1'>".$productos[$i]["descripcion"]."</font><br>".$stock;

		  	/*=============================================
 	 		PROVEEDOR 
  			=============================================*/ 
  			$item = "id";
  			$valor = $productos[$i]["proveedor"];
  			$proveedor =  ControladorProveedores::ctrMostrarProveedores($item, $valor, $orden);

			/*=============================================
 	 		PRECIO COMPRA
  			=============================================*/ 
  			$precioCompra = "<font size='+0'><p style='color:rgb(128,139,150)'>$ ".number_format($productos[$i]["precio_compra"],0,',','.')." c/u</p></font>";


		 	// llenado de la estructura
		  	$datosJson .='[
			      "'.$descripcion.'",
			      "'.$precioCompra.'",
			      "'.mb_strtoupper($proveedor["alias_empresa"]).'"
			    ],';

		  }
		  // elimina el último caracter que es la coma de la fila 96, para evitar el error de sistaxis que no debe terminar con coma
		  $datosJson = substr($datosJson, 0, -1);
		 // concateno el corchete cerrado y la llave cerrada 
		 $datosJson .=   ']

		 }';
		
		echo $datosJson;


	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$activarProductos = new TablaProductos();
$activarProductos -> mostrarTablaProductos();

