<?php
session_start();
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";
require_once "../modelos/sucursales.modelo.php";

class TablaProductos{

 	/*=============================================
 	 MOSTRAR LA TABLA DE PRODUCTOS
  	=============================================*/ 

	public function mostrarTablaProductos(){

	    $sucursal = $_SESSION['sucursal'];
		$item = "estado_".$sucursal;
    	$valor = 1;
    	$orden = "fecha_modif_".$sucursal;
  		$productos = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);	

  		if(count($productos) == 0){

  			echo '{"data": []}';

		  	return;
  		}


   		$sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
	    $nombre_y_alias = array();
	    $locales = array();
            
        foreach ($sucursales as $key => $value){
        	if($value['nombre_sucursal'] != $sucursal){
	        	array_push($nombre_y_alias, $value["nombre_sucursal"]); 
	        	array_push($nombre_y_alias, $value["alias_sucursal"]);
	        	array_push($locales, $nombre_y_alias);
		    	$nombre_y_alias = array(); // vaciamos array
        	}
        }  		

		
  		$datosJson = '{
		  "data": [';
		  for($i = 0; $i < count($productos); $i++){
		  	$idProd = $productos[$i]['id'];
  			$stockIdeal = ceil($productos[$i]["stock_ideal_".$sucursal]);
  			$stock = $productos[$i]["stock_".$sucursal];
			// BOTONES
            if($productos[$i]["estado_".$sucursal] != 0){
				$btnActProd = "<button class='btn btn-success btn-xs btnActProd' idProd='".$idProd."' estadoProd='0'>Activado</button>";
			}else{
				$btnActProd = "<button class='btn btn-danger btn-xs btnActProd' idProd='".$idProd."' estadoProd='1'>Desactivado</button>";
			}

  			$botones =  "<div class='btn-group'><button class='btn btn-warning btnEditarProducto btn-xs' idProducto='".$idProd."' data-toggle='modal' data-target='#modalEditarProducto'><i class='fa fa-pen'></i></button><button class='btn btn-danger btnEliminarProducto btn-xs' idProducto='".$idProd."' codigo='".$productos[$i]["codigo"]."' imagen='".$productos[$i]["imagen"]."'><i class='fa fa-times'></i></button></div>"; 
  			$cats = '<b>'.$productos[$i]["cat_nom"].'</b><br>'.$productos[$i]["subcat_nom"];

			$idFecha = 'fecha'.$idProd;
  			$fechaModificacion = "<div id=".$idFecha." class='btn-group'>".$productos[$i]["fecha_modif_".$sucursal]."</div>";
			

  			$descripcion2Movil = $productos[$i]["descripcion2"] == '' ? '' : "<br><font size=-2'>".$productos[$i]["descripcion2"]."</font>";
  			$descripcionDispMovil = "<font size='-1'><b>".str_replace(' ',' ', $productos[$i]["descripcion"])."</b> [ID: ".$productos[$i]["id"]."]</font>".$descripcion2Movil;
  			$sku = $productos[$i]["sku"] <= 99999 ? '0'.$productos[$i]["sku"] : $productos[$i]["sku"];
  			$codigosDispMovil = "<br><font id='zonaMovil".$idProd."'>".$productos[$i]["zona_".$sucursal]."-".$sku."</font>";
            
            if($stock < $stockIdeal/3){
            	$color = 'danger';
            }else if($stock >= $stockIdeal/3 && ($stock < (2*$stockIdeal/3))){
            	$color = 'warning';
            }else{
            	$color = 'success';           	
            }


            $precioDispMovil = "<br><font size='-1'><b>P. Compra:</b> $".number_format($productos[$i]["pc_neto"],2,',','.')." / $".number_format($productos[$i]["precio_compra"],0,',','.')."<br><b>P. Venta:</b> $".number_format($productos[$i]["precio_venta"],0,',','.')."  <font style='color:blue'>&uarr;".$productos[$i]["mayor_sobre"]."u <b>$".number_format($productos[$i]["precio_mayor"],0,',','.')."</b></font></font>";

		  	$imagenDispMovil = "<img style='float:right' id='imagenZoom' src='".$productos[$i]["imagen"]."' alt='".$productos[$i]["descripcion"]."' class='imagenZoom' width='40px' idProducto='".$idProd."' data-toggle='modal' data-target='#modalZoomProducto'>";

		  	$proveedor = "<br><font size='-1'><b>Proveedor:</b> ".strtoupper($productos[$i]['nom_prov'])."</font>";
		  	$acciones = "<br><font size='-1'><b>Acciones:</b> ".$botones."</font>";


			//GENERA LEYENDA QUE APARECE EN TOOLTIP CUANDO HAY STOCK >0 EN OTRAS SUCURSALES
			$stockOtrosLocales = '';
			for ($i_1=0; $i_1 < count($locales); $i_1++){
				if($productos[$i]['stock_'.$locales[$i_1][0]] > 0){
					$stockOtrosLocales .= strtoupper($locales[$i_1][0])." (".$productos[$i]['zona_'.$locales[$i_1][0]].") &rarr; ".number_format($productos[$i]['stock_'.$locales[$i_1][0]],0,',','.')."u&#10;"; // EJ. BODEGA1 (C17N5) -> 1000u
				} 
			}

			if($stockOtrosLocales == ''){
				$stockOtrasSucursalesMovil = '';
			}else{
				$stockOtrasSucursalesMovil = "<button style='color:white; background-color:purple' class='btn btn-xs stockBodega info float-right' data-original-title='".$stockOtrosLocales."'>OTROS LOCALES</button>";
			}

            $stockDispMovil = "<h4><font class='float-left'><span id='stockDispMovil".$idProd."' class='label label-".$color."'>".$stock.'/'.$stockIdeal."</span> <button class='btn btn-xs btn-info historialProducto' idProd='".$idProd."'><i class='fa fa-history'></i></button></font>".$stockOtrasSucursalesMovil."<h4>";





            $mostrarControl = ['No Controlar','Primera Prioridad','Controlar Inventario'];
            $colorControl = ['','bg-success','bg-primary'];
            
            $claveArray = $productos[$i]['control_inventario'];

            $opciones = "<option value='".$claveArray."'>".$mostrarControl[$claveArray]."</option>";
            	

			for($ia=0;$ia<count($mostrarControl);$ia++){
            	if($ia != $claveArray){ // CARGA TODOS LOS DEMAS ELEMENTOS
            		$opciones .= "<option value='".$ia."'>".$mostrarControl[$ia]."</option>";
            	}
            }


            $controlInventario = $productos[$i]["transformable"] == 2 ? "" : "<select style='font-size:13px' class='form-control form-control-sm info controlInvetario ".$colorControl[$claveArray]."' id='controlInvetario".$idProd."' idProd='".$idProd."' data-original-title='CONTROL INVENTARIO?' data-placement='bottom'>".$opciones."</select>";


			// STOCK
			$idStock = 'stkVis'.$idProd;
			$btnBajaStock = 'btnRestStock'.$idProd;
			$btnSubeStock = 'btnSumStock'.$idProd;
			$btnBajaIdeal = 'btnBajarStkIdeal'.$idProd;
			$btnSubeIdeal = 'btnSubirStkIdeal'.$idProd;

            if($stock < $stockIdeal/3){
            	$color = 'danger';
            }else if($stock >= $stockIdeal/3 && ($stock < (2*$stockIdeal/3))){
            	$color = 'warning';
            }else{
            	$color = 'success';
            }


            $botonesVariarIdeal = $sucursal == 'bodega1' ? "" : "<div class='btn-group float-right botonesStkIdeal'><button class='btn btn-default btnBajarStkIdeal info' data-original-title='Bajar Ideal' id=".$btnBajaIdeal." stockActual='".$productos[$i]['stock_'.$sucursal]."' stkIdeal='".$productos[$i]['stock_ideal_'.$sucursal]."' idProd='".$idProd."'>&darr;</button><button class='btn btn-default btnSubirStkIdeal info' data-original-title='Subir Ideal' id=".$btnSubeIdeal." stockActual='".$productos[$i]['stock_'.$sucursal]."' stkIdeal='".$productos[$i]['stock_ideal_'.$sucursal]."' idProd='".$idProd."'>&uarr;</button></div>";

			$btnCheckStock = 'btnCheckStock'.$productos[$i]["id"];
			
			if($productos[$i]['check_stock_'.$sucursal] == 0 && $productos[$i]['maneja_stock'] == 'SI'){
				$botonCheck = "     <div class='btn-group' id=".$btnCheckStock."><button class='btn btn-warning' onclick='checkeoStock(".$productos[$i]['id'].")' idProd='".$productos[$i]['id']."'><i class='fa fa-check-square'></i></button></div>";
			}else{
				$botonCheck = "";
			}

			if($productos[$i]["maneja_stock"]=="SI"){
				$stock_vista = "<div class='mb-1'></div><div id=".$idStock." class='btn-group'><button class='btn btn-default btnRestStock info' data-original-title='-1' id=".$btnBajaStock." ideal='".$productos[$i]["stock_ideal_".$sucursal]."' idProd='".$idProd."'>&darr;</button><button style='text-align:right' class='btn btn-".$color." stockVista' stk='".$stock."' ideal='".$productos[$i]["stock_ideal_".$sucursal]."' idProd='".$idProd."' style='width:50px'>".$stock."/".$stockIdeal."</button><button class='btn btn-default btnSumStock info' data-original-title='+1' id=".$btnSubeStock." ideal='".$productos[$i]["stock_ideal_".$sucursal]."' idProd='".$idProd."'>&uarr;</button></div>".$botonCheck.$botonesVariarIdeal."<div style='height:3px'></div>";
			}else{
				$stock_vista = "<div class='btn-group'><button class='btn btn-info'><font size='+1'>&infin;</font></button></button></div>";		
			}


			$cambiarZona = "<div class='input-group'>".
								"<input type='text' class='form-control form-control-sm' id='editZonaMovil".$idProd."' placeholder='Zona' value='".$productos[$i]['zona_'.$sucursal]."'>".
								"<button class='btn btn-info btn-sm btnEditZonaMovil float-right' idProd='".$idProd."' skuProd='".$sku."'>Actualizar Zona</button>".
							"</div>";


			// $ventana = $_GET['ventana'];
			// if($ventana == 'productos-movil'){
				$columna1 = 	$descripcionDispMovil.$imagenDispMovil.
								$codigosDispMovil.
								$stockDispMovil.
								$precioDispMovil.
								$proveedor.
								$acciones;
			// }else{
				// $columna1 = 	$descripcionDispMovil.
				// 				$controlInventario.
				// 				$stock_vista.
				// 				$cambiarZona."<hr>".
				// 				$codigosDispMovil.$imagenDispMovil.
				// 				$stockDispMovil.
				// 				$precioDispMovil.
				// 				$proveedor.
				// 				$acciones;
			// }
			// $columna2 = 	$productos[$i]['nom_prov'];
			// $columna3 = 	$fechaModificacion;
			// $columna4 = 	$btnActProd;
			// $columna5 = 	$botones;


		  	$datosJson .='[
			      "'.$columna1.'"],';

		  }
		  // elimina el último caracter que es la coma de la fila 96, para evitar el error de sistaxis que no debe terminar con coma
		  $datosJson = substr($datosJson, 0, -1);
		 // concateno el corchete cerrado y la llave cerrada 
		 $datosJson .=   ']

		 }';
		
		echo $datosJson;


	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$activarProductos = new TablaProductos();
$activarProductos -> mostrarTablaProductos();
