<?php
session_start();
require_once "../modelos/movimientos-bancarios.modelo.php";
require_once "../modelos/sucursales.modelo.php";

class TablaCompromisoPago{

	public function mostrarTablaCompromisoPago(){

		if(isset($_GET['fechaInicial']) && $_GET['fechaInicial'] != 'undefined'){
			$fecha1 = $_GET['fechaInicial'];
			$fecha2 = $_GET['fechaFinal'];
			$compromisosPago = ModeloMovimientosBancarios::mdlMostrarCompromisosPagoRango('compromisos_pago', $fecha1, $fecha2);
		}else{
			$compromisosPago = ModeloMovimientosBancarios::mdlMostrarCompromisosPago('compromisos_pago','fecha_vencimiento', null);

		}



		if(count($compromisosPago) == 0){
			echo '{"data": []}';
			return;
		}

  		$datosJson = '{"data": [';

        foreach ($compromisosPago as $key => $value){
			// if($key == 16) {

			$fechaVencimiento = $value['fecha_vencimiento'];
            // DCTO POR NOTAS DE CREDITO
            
            if($value['estado'] == 1){
	            $pagoRestante = '<font style=\"color:blue\">-$ '.number_format($value['monto_pagado'],0,',','.').' </font><font class=\"float-right text-primary\">(<b>'.strtoupper(str_replace("_", ' ', $value['moneda_pago'])).'</b>)</font><br>';
            }else{
            	$pagoRestante  = '';
            }


            $pagadoParcial = 0;
            $comprobantes = 0;
	        $abonosParciales = json_decode($value["abonos"],true);

	        $historialAbonos = '';

            if($value["abonos"] != ''){        	
	        	for ($i=0; $i < count($abonosParciales); $i++) {
					$fecha = date('d-m-Y', strtotime($abonosParciales[$i]['fecha']));
	            	if($abonosParciales[$i]['tipo'] == 'nc'){
	                	$historialAbonos .= '<font style=\"color:blue\">-$ '.number_format($abonosParciales[$i]['monto'],0,',','.').' </font><font class=\"float-right\" style=\"color:blue\">'.$fecha.' (NC: '.number_format($abonosParciales[$i]['nro'],0,',','.').')</font><br>';
	                }else if($abonosParciales[$i]['tipo'] == 'ab'){
	                	$abonoMostrar = '<a href=\"'.$abonosParciales[$i]['comprobante'].'\" target=\"_blank\">'.$value['id'].'</a>';
	                	$historialAbonos .= '<font style=\"color:blue\"><b>-$ '.number_format($abonosParciales[$i]['monto'],0,',','.').' </b></font><font class=\"float-right\" style=\"color:blue\">'.$fecha.' <b>(ABONO: '.$abonoMostrar.')</b></font><br>';

		                if($abonosParciales[$i]['comprobante'] != ''){ // conteo comprobantes
		                	$comprobantes += 1;
		                }
	                }
	                $pagadoParcial += $abonosParciales[$i]['monto'];
				}

            }


			if($value['tipo_compromiso'] == 'hipotecario' && $fechaVencimiento > date('Y-m-d')){ // vencido
				$valorUF = ModeloMovimientosBancarios::mdlValorUF(date('Y-m-d'))['valor'];
				$montoPagarOriginal = $value["monto"]*$valorUF;
				$montoMostrar = '$'.number_format($montoPagarOriginal,0,',','.');
			}else if($value['tipo_compromiso'] == 'hipotecario' && $fechaVencimiento <= date('Y-m-d')){ // por vencer
				$valorUF = ModeloMovimientosBancarios::mdlValorUF($fechaVencimiento)['valor'];
				$montoPagarOriginal = $value["monto"]*$valorUF;
				$montoMostrar = '$'.number_format($montoPagarOriginal,0,',','.');
			}else if($value['abonos'] != '' && $value['estado'] == 0){ // sin pagar sin abonos
				$montoPagarOriginal = $value["monto"]-$pagadoParcial;
				$montoMostrar = '$'.number_format($montoPagarOriginal,0,',','.').' <font size=\"-1.5\" style=\"color:blue\"><b>PENDIENTE</b></font>';			
			}else{
				$montoPagarOriginal = $value["monto"];
				$montoMostrar = '$'.number_format($montoPagarOriginal,0,',','.');
			}

			$montoPagarMostrar = $value['tipo_compromiso'] == 'hipotecario' ? $montoPagarOriginal : $value['monto'];

			$abonosVarios = '<font> $ '.number_format($montoPagarMostrar,0,',','.').' </font><font class=\"float-right\">(A PAGAR)</font><br>';

            $deudaActualizada = $montoPagarMostrar-$pagadoParcial;

			$abonosVarios .= $historialAbonos;

			if($montoPagarMostrar-$pagadoParcial > 0){
				$abonosVarios .= '<font style=\"border-top:1px solid black\"> $ '.number_format($deudaActualizada,0,',','.').'                 </font><b class=\"float-right\">(SALDO PENDIENTE)</b>';
			}else{
				$abonosVarios .= '<font style=\"border-top:1px solid black\"> $ '.number_format($deudaActualizada,0,',','.').'                 </font>';
			}




			if($value['tipo_compromiso'] == 'cheque'){
				$tipoDeudaMostrar = 'Cheque <b><i>'.strtoupper($value['se_paga_desde']).'</i></b> ('.ucfirst($value['acreedor']).')';
			}else if($value['tipo_compromiso'] == 'arriendo'){
				$tipoDeudaMostrar = 'Arriendo';
			}else if($value['tipo_compromiso'] == 'tc'){
				$tcPropietario = explode('_',$value['acreedor']);
				$tipoDeudaMostrar = 'Tarjeta Crédito <b>'.strtoupper($tcPropietario[1]).'</b>';
			}else if($value['tipo_compromiso'] == 'consumo'){
				$bancoAcreedor = explode('_',$value['acreedor'])[0];
				$tipoDeudaMostrar = 'Consumo '.strtoupper($bancoAcreedor).' <b>['.$value['nro_cuota'].']</b><br>Nro. Crédito: <b>'.$value['nro_credito'].'</b>';
			}else if($value['tipo_compromiso'] == 'convenio'){
				$tipoDeudaMostrar = 'Convenio '.strtoupper($value['descripcion']).' <b>['.$value['nro_cuota'].']</b>';
			}else if($value['tipo_compromiso'] == 'compra_activo'){
				$tipoDeudaMostrar = 'Compra Activo';
			}else if($value['tipo_compromiso'] == 'gastos_carlos'){
				$tipoDeudaMostrar = 'Gastos <b>Carlos</b>';
			}else if($value['tipo_compromiso'] == 'gastos_edu'){
				$tipoDeudaMostrar = 'Gastos <b>Eduar</b>';
			}else if($value['tipo_compromiso'] == 'gastos_sama'){
				$tipoDeudaMostrar = 'Gastos <b>SAMA</b>';
			}else if($value['tipo_compromiso'] == 'hipotecario'){
				$tipoDeudaMostrar = strtoupper($value['descripcion']).' <b>['.$value['nro_cuota'].']</b><br>Nro. Crédito: <b>'.$value['nro_credito'].'</b>';
			}else if($value['tipo_compromiso'] == 'cred_prov'){
				$tipoDeudaMostrar = 'Abastecimiento <b>'.strtoupper($value['acreedor']).'</b>';
			}

			$accesoEditarMonto = 'id=\"montoCompromiso\" fecha=\"'.$value['fecha_vencimiento'].'\" idCompromisoPago=\"'.$value['id'].'\"'; // evitar modificar monto cuando la moneda es UF

			if($value['estado'] == 1 && $value['fecha_pago'] > $fechaVencimiento){ // pagado con retraso
				$deuda = '<div id=\"descripcionCompromiso'.$value['id'].'\"><h4><span class=\"badge badge-pill badge-primary\" id=\"comprobantePagoCompromiso'.$value['id'].'\">Pagado con RETRASO</span> <font size=\"+1\" id=\"montoCompromiso\">'.$montoMostrar.'</font></h4>'.date('d-m-Y', strtotime($fechaVencimiento)).' ['.strtoupper(str_replace(' ',' ', $value["deudor"])).']<br><font size=\"+1\">'.$tipoDeudaMostrar.'</font></div>';
			}else if($value['estado'] == 1 && $value['fecha_pago'] <= $fechaVencimiento){ // pagado sin retraso
				$deuda = '<div id=\"descripcionCompromiso'.$value['id'].'\"><h4><span class=\"badge badge-pill badge-success\" id=\"comprobantePagoCompromiso'.$value['id'].'\">Pagado</span> <font size=\"+1\" id=\"montoCompromiso\">'.$montoMostrar.'</font></h4>'.date('d-m-Y', strtotime($fechaVencimiento)).' ['.strtoupper(str_replace(' ',' ', $value["deudor"])).']<br><font size=\"+1\">'.$tipoDeudaMostrar.'</font></div>';
			}else if($value['estado'] == 0 && $fechaVencimiento < date('Y-m-d')){ // VENCIDO
				$deuda = '<div id=\"descripcionCompromiso'.$value['id'].'\"><h4><span class=\"badge badge-pill badge-danger\">Vencido</span> <font '.$accesoEditarMonto.' size=\"+1\">'.$montoMostrar.'</font></h4>'.date('d-m-Y', strtotime($fechaVencimiento)).' ['.strtoupper(str_replace(' ',' ', $value["deudor"])).']<br><font size=\"+1\">'.$tipoDeudaMostrar.'</font></div>';
			}else if($value['estado'] == 0 && $fechaVencimiento >= date('Y-m-d')){ // POR VENCER
				$deuda = '<div id=\"descripcionCompromiso'.$value['id'].'\"><font '.$accesoEditarMonto.' size=\"+1\">'.$montoMostrar.'</font><br>'.date('d-m-Y', strtotime($fechaVencimiento)).' ['.strtoupper(str_replace(' ',' ', $value["deudor"])).']<br><font size=\"+1\">'.$tipoDeudaMostrar.'</font></div>';
			}


			// DESCRIPCION
			$tipoCompromiso = $value['tipo_compromiso'];
			$subcadena = "gastos_";
			if (strpos($tipoCompromiso, $subcadena) !== false) { // detecta si contiene texto gastos_
				$descripcion = ucfirst($value["descripcion"]).' <b>'.strtoupper($value['acreedor']).'</b>';
			}else{
				if($tipoCompromiso == 'cred_prov'){
					$descripcion = '<div id=\"editGuiaFact'.$value['id'].'\" class=\"editGuiaFact\" idCompromisoPago=\"'.$value['id'].'\" >'.ucfirst($value["descripcion"]).'</div>';
				}else{
					$descripcion = ucfirst($value["descripcion"]);
				}
			}


			// SALDO EN PESOS
			if($value['estado'] != 1){
				$saldoPend = round($montoPagarOriginal);
			}

			$jsonDatosPago = '{\"estado\":\"'.$value['estado'].'\",\"fecha_venc\":\"'.$fechaVencimiento.'\",\"fecha_pago\":\"'.$value['fecha_pago'].'\",\"saldo\":\"'.$saldoPend.'\"}';
			$descripcionMostrar = '<font size=\"0\" style=\"visibility:hidden\">'.$jsonDatosPago.'</font><br>'.$descripcion;

			// MONTO PAGADO
			if($value['estado'] == 1){ // CUANDO ESTÁ PAGADO SIN NC
				$montoPagado = '<div id=\"montoPagado'.$value['id'].'\"><b>$'.number_format($value['monto_pagado'],0,',','.').'</b></div>';
			}else{
				$montoPagado = '<div id=\"montoPagado'.$value['id'].'\">-</div>';			
			}


			// INTERÉS
			if($value['estado'] == 1){
				$interesPagadoFinal = $value["interes_pagado"] < 0 ? 0 : $value["interes_pagado"];
				$interes = '<div id=\"interesPagado'.$value['id'].'\"><b>$'.number_format($interesPagadoFinal,0,',','.').'</b></div>';
			}else{
				$interes = '<div id=\"interesPagado'.$value['id'].'\">-</div>';
			}


			// DETALLE PAGO
			if($value['estado'] == 1 && $value['fecha_pago'] > $fechaVencimiento){
				$diferencia_en_dias = floor(abs(strtotime($fechaVencimiento) - strtotime($value['fecha_pago'])) / 86400);
				$plural = $diferencia_en_dias > 1 ? 's' : ''; 
				$retraso = '<br>Se paga con retraso de '.$diferencia_en_dias.' día'.$plural;
			}else{
				$retraso = '';
			}

			// $comprobantes = 0;
        	// for ($i_a=0; $i_a < count($abonosParciales); $i_a++) {
        	// 	if($abonosParciales[$i_a]['comprobante'] != ''){
        	// 		$comprobantes += 1;	
        	// 	}
        	// }

			// if($comprobantes >= 1){
	        	$comprobantePago = $comprobantes >= 1 ? '<button class=\"btn btn-success info float-right comprobantePagoCompromiso\" idCompromiso=\"'.$value['id'].'\" nc=\"'.count($abonosParciales).'\" doc=\"'.$value['id'].'\" data-original-title=\"Comprobante\"><i class=\"fa fa-file\"></i></button>' : 'a';
			// }else{
	  		//       	$comprobantePago = '<button class=\"btn btn-success info float-right comprobantePagoCompromiso\" idCompromiso=\"'.$value['id'].'\" nc=\"'.count($abonosParciales).'\" doc=\"'.$value['comprobante'].'\" data-original-title=\"Comprobante\"><i class=\"fa fa-file\"></i></button>';				
			// }

			$fechaPago = '<b>'.date("d/m/Y", strtotime($value['fecha_pago'])).'</b>';
			if($value['moneda_pago'] == 'transf'){
				$pagadoCon = 'Transferencia'.$comprobantePago.'<br>Pagado el '.$fechaPago.$retraso;
			}else if($value['moneda_pago'] == 'cobro_bancario'){
				$pagadoCon = 'Cobro Bancario'.$comprobantePago.'<br>Pagado el '.$fechaPago.$retraso;
			}else if($value['moneda_pago'] == 'efectivo'){
				$pagadoCon = 'Efectivo'.$comprobantePago.'<br>Pagado el '.$fechaPago.$retraso;
			}else if($value['moneda_pago'] == 'webpay'){
				$pagadoCon = 'WEBPAY'.$comprobantePago.'<br>Pagado el '.$fechaPago.$retraso;
			}else{
				$pagadoCon = 'Otro'.$comprobantePago.'<br>Pagado el '.$fechaPago.$retraso;
			}


			if($value['estado'] == 1){ // CUANDO ESTÁ PAGADO SIN NC
				$movsPago = $value['abonos'] == '' ? '' : $abonosVarios;
				$detallePago = '<div id=\"pagadoCon'.$value['id'].'\"><font size=\"+1\">'.$pagadoCon.'<br><br>'.$movsPago.'</font></div>';
			}else if($value['estado'] == 0 && $value['abonos'] == ''){ // VENCIDO
				$detallePago = '<div id=\"pagadoCon'.$value['id'].'\"><font size=\"+1\">-</font></div></td>';
			}else{
				$detallePago = '<div id=\"pagadoCon'.$value['id'].'\"><font size=\"+1\">'.$abonosVarios.'</font></div>';
			}
			
			if($value['estado'] == 1){ // pagado
				$botones = 
					'<div id=\"botonesCompromisoPago'.$value['id'].'\">'.
						'<div class=\"btn-group\">'.
							'<button class=\"btn btn-info info\" data-original-title=\"REVOCAR PAGO\" id=\"btnRevocarPago\" monto=\"'.round($montoPagarOriginal).'\" idCompromisoPago=\"'.$value["id"].'\"><i class=\"fa fa-sync\"></i></button>'.
						'</div>'.
					'</div>';

			}else if($abonosParciales == ''){ // sin pago
            	$botones = 
                	'<div id=\"botonesCompromisoPago'.$value['id'].'\">'.
                		'<div class=\"btn-group\">'.
                			'<button class=\"btn btn-info info btnAplicarNC\" data-original-title=\"Nota de Crédito\" id=\"btnAplicarNC\" titulo=\"'.$value['descripcion'].'\" aPagar=\"'.round($deudaActualizada).'\" idCompromisoPago=\"'.$value["id"].'\"  data-toggle=\"modal\" data-target=\"#modalNC\"><i class=\"fa-solid fa-receipt\"></i></button>'.
                			'<button class=\"btn btn-success info btnPagarCompromisoPago\" data-original-title=\"Registrar Abono\" id=\"btnPagarCompromisoPago\" titulo=\"'.$value['descripcion'].'\" aPagar=\"'.round($deudaActualizada).'\" idCompromisoPago=\"'.$value["id"].'\" vencimiento=\"'.date('d-m-Y', strtotime($value['fecha_vencimiento'])).'\"  data-toggle=\"modal\" data-target=\"#modalRegistrarPago\"><i class=\"fa fa-money-bill-alt\"></i></button>'.
                			'<button class=\"btn btn-danger info btnEliminarCompromisoPago\" data-original-title=\"Eliminar Compromiso\" id=\"btnEliminarCompromisoPago\" idCompromisoPago=\"'.$value["id"].'\"><i class=\"fa fa-times\"></i></button>'.
                		'</div>'.
                	'</div>';

			}else if(count($abonosParciales) != 0 && count($abonosParciales) > 0 && $value['estado'] == 0){ // con abono parcial
            	$botones = 
                	'<div id=\"botonesCompromisoPago'.$value['id'].'\">'.
                		'<div class=\"btn-group mb-1\">'.
                			'<button class=\"btn btn-info info btnAplicarNC\" data-original-title=\"Nota de Crédito\" id=\"btnAplicarNC\" titulo=\"'.$value['descripcion'].'\" aPagar=\"'.round($deudaActualizada).'\" idCompromisoPago=\"'.$value["id"].'\"  data-toggle=\"modal\" data-target=\"#modalNC\"><i class=\"fa-solid fa-receipt\"></i></button>'.
                			'<button class=\"btn btn-success info btnPagarCompromisoPago\" data-original-title=\"Registrar Abono\" id=\"btnPagarCompromisoPago\" titulo=\"'.$value['descripcion'].'\" aPagar=\"'.round($deudaActualizada).'\" idCompromisoPago=\"'.$value["id"].'\" vencimiento=\"'.date('d-m-Y', strtotime($value['fecha_vencimiento'])).'\"  data-toggle=\"modal\" data-target=\"#modalRegistrarPago\"><i class=\"fa fa-money-bill-alt\"></i></button>'.
                			'<button class=\"btn btn-danger info btnEliminarCompromisoPago\" data-original-title=\"Eliminar Compromiso\" id=\"btnEliminarCompromisoPago\" idCompromisoPago=\"'.$value["id"].'\"><i class=\"fa fa-times\"></i></button>'.
                		'</div>'.
						'<div class=\"btn-group\">'.
							'<button class=\"btn bg-orange info\" data-original-title=\"REVOCAR PAGO\" id=\"btnRevocarPago\" monto=\"'.round($montoPagarOriginal).'\" idCompromisoPago=\"'.$value["id"].'\"><i class=\"fa fa-sync\"></i></button>'.
						'</div>'.
					'</div>';
			}

			$datosJson .='[
				"'.($key+1).'",
				"'.$deuda.'",
				"'.$descripcionMostrar.'",
				"'.$montoPagado.'",
				"'.$interes.'",
				"'.$detallePago.'",
				"'.$botones.'"
			],';

			}


		// elimina el último caracter que es la coma de la fila 96, para evitar el error de sistaxis que no debe terminar con coma
		$datosJson = substr($datosJson, 0, -1);
	 	// concateno el corchete cerrado y la llave cerrada 
	 	$datosJson .=   ']}';
		echo $datosJson;
	}
}

$activarCompras = new TablaCompromisoPago();
$activarCompras -> mostrarTablaCompromisoPago();
