<?php
session_start();
require_once "../controladores/clientes.controlador.php";
require_once "../modelos/clientes.modelo.php";

class TblClientes{

 	/*=============================================
 	MOSTRAR TABLA CLIENTES
  	=============================================*/ 
	public function verTblClientes(){
        
        $item = null;
        $valor = null;
        $clientes = ControladorClientes::ctrMostrarClientes($item, $valor);

  		if(count($clientes) == 1){

  			echo '{"data": []}';

		  	return;
  		}
		
  		$datosJson = '{
		  "data": [';

        foreach ($clientes as $i => $value) {

        	if($value['id']!=1){

                
                $btnEstadoCliente = $value["estado"] != 0 ? "<button class='btn btn-success btn-xs btnActDesctCliente' id='cliente".$value['id']."' idCliente='".$value['id']."' estadoCliente='0'>Activado</button>" : "<button class='btn btn-danger btn-xs btnActDesctCliente' id='cliente".$value['id']."' idCliente='".$value['id']."' estadoCliente='1'>Desactivado</button>";

                $btnEstadoClienteMostrar = $_SESSION['perfil'] == 'Administrador' ? $btnEstadoCliente : ''; // FILTRO PARA QUE SOLO EL ADMINISTRADOR PUEDA ACTIVAR O DESACTIVAR CLIENTES

            	$columna1 = "<b>".ucfirst($value['nombre'])." ".ucfirst($value['apellido'])."</b> (".strtoupper($value['referencia']).") <i><b>[ID:".$value["id"]."]</b></i><br>".$btnEstadoClienteMostrar;

				$contacto = "<b>".$value["telefono"]."</b> <a class='pull-right btn btn-lg' id='btnEnviarWhatsapp' href='http://wa.me/+56".$value["telefono"]."' target='_blank' style='background-color:transparent; color:green;'><i class='fab fa-whatsapp'></i></a><br><a href='mailto:".$value['email']."?subject=&body=' >".$value['email']."</a>";

				$direccion = $value['direccion'];

				$deuda =	"<div id='deudaCliente".$value['id']."'>".
								"<div  class='input-group input-group-sm'>".
									"<button class='btn btn-xs btn-success btnVerificarDeuda info' data-original-title='Calcular Deuda' idCliente='".$value["id"]."'>Calcular Deuda</button>".
								"</div>".
							"</div>";

				$idLimite = 'limite'.$value["id"];
                if($_SESSION["perfil"] == "Administrador"){
  					$limite = "<div id=".$idLimite."><b>$ ".number_format($value["limite"],0,',','.')."</b> <i style='color:rgb(224,142,11)' class='fa fa-pen btnEditLimite' limite='".$value['limite']."' idCliente='".$value["id"]."'></i></div>";            	
		  			$botones =  "<div class='btn-group'><button class='btn btn-warning btnEditarCliente' data-toggle='modal' data-target='#modalEditarCliente' idCliente='".$value["id"]."'><i class='fa fa-pen'></i></button><button class='btn btn-danger btnEliminarCliente' idCliente='".$value["id"]."'><i class='fa fa-times'></i></button></div>"; 
                }else{
		  			$botones =  "<div class='btn-group'><button class='btn btn-warning btnEditarCliente' data-toggle='modal' data-target='#modalEditarCliente' idCliente='".$value["id"]."'><i class='fa fa-pen'></i></button></div>";
  					$limite = "<div id=".$idLimite."><b>".$value["limite"]."</b></div>";            	
                }

				// TIPO CLIENTE
	            if($value["tipo_cliente"] == 'minorista'){
				$tipoCliente = 
					"<div id='tipoCliente".$value['id']."' class='input-group input-group-sm'>".
					"<select class='form-control bg-gray-dark' style='border-color:white' id='tipoCliente' name='tipoCliente' idCliente='".$value['id']."'>".
			            "<option value='minorista'>MINORISTA</option>".
		                "<option value='mayorista'>MAYORISTA</option>".
		                "<option value='propietario'>PROPIETARIO</option>".
					"</select></div>";
				}else if($value["tipo_cliente"] == 'mayorista'){
				$tipoCliente = 
					"<div id='tipoCliente".$value['id']."' class='input-group input-group-sm'>".
						"<select class='form-control btn-success' style='border-color:white' id='tipoCliente' name='tipoCliente' idCliente='".$value['id']."'>".
			                "<option value='mayorista'>MAYORISTA</option>".
				            "<option value='minorista'>MINORISTA</option>".
			                "<option value='propietario'>PROPIETARIO</option>".
						"</select>".
					"</div>";
				}else if($value["tipo_cliente"] == 'propietario'){
				$tipoCliente = 
					"<div id='tipoCliente".$value['id']."' class='input-group input-group-sm'>".
					"<select class='form-control btn-info' style='border-color:white' id='tipoCliente' name='tipoCliente' idCliente='".$value['id']."'>".
		                "<option value='propietario'>PROPIETARIO</option>".
		                "<option value='mayorista'>MAYORISTA</option>".
			            "<option value='minorista'>MINORISTA</option>".
					"</select></div>";
				}			



				// CREDITO INTERNO
	            if($value["credito_interno"] == 0){
				$credito_interno = 
					"<div id='credInt".$value['id']."' class='input-group input-group-sm'>".
					"<select style='border-color:white' class='form-control btn-danger' id='creditoInternoCliente' name='creditoInternoCliente' idCliente='".$value['id']."'>".
		                "<option value='0'>CI: Bloqueado</option>".
			            "<option value='1'>CI: Activo</option>".
		                "<option value='2'>CI: Suspendido</option>".
					"</select></div>";
				}else if($value["credito_interno"] == 1){
				$credito_interno = 
					"<div id='credInt".$value['id']."' class='input-group input-group-sm'>".
					"<select style='border-color:white' class='form-control btn-success' id='creditoInternoCliente' name='creditoInternoCliente' idCliente='".$value['id']."'>".
			            "<option value='1'>CI: Activo</option>".
		                "<option value='0'>CI: Bloqueado</option>".
		                "<option value='2'>CI: Suspendido</option>".
					"</select></div>";
				}else if($value["credito_interno"] == 2){
				$credito_interno = 
					"<div id='credInt".$value['id']."' class='input-group input-group-sm'>".
					"<select style='border-color:white' class='form-control btn-warning' id='creditoInternoCliente' name='creditoInternoCliente' idCliente='".$value['id']."'>".
		                "<option value='2'>CI: Suspendido</option>".
		                "<option value='0'>CI: Bloqueado</option>".
			            "<option value='1'>CI: Activo</option>".
					"</select></div>";
				}			



				// RESPETO DE PRECIO MAYOR CUANDO PAGA CON CREDITO INTERNO0
	            if($value["respetar_p_mayor"] == 1){
					$respetarPrecioMayor = 
					"<div id='respetaPMayorCI".$value['id']."' class='input-group input-group-sm'>".
						"<select style='border-color:white' class='form-control btn-success' id='respetaPMayorCI' name='respetaPMayorCI' idCliente='".$value['id']."'>".
				            "<option value='1'>SI</option>".
			                "<option value='0'>NO</option>".
						"</select>".
					"</div>";
				}else{
					$respetarPrecioMayor = 
					"<div id='respetaPMayorCI".$value['id']."' class='input-group input-group-sm'>".
						"<select style='border-color:white' class='form-control btn-danger' id='respetaPMayorCI' name='respetaPMayorCI' idCliente='".$value['id']."'>".
			                "<option value='0'>NO</option>".
				            "<option value='1'>SI</option>".
						"</select>".
					"</div>";
				}

				if($value["tipo_cliente"] == 'minorista'){ // minorista
					$configCliente = "<div id='configCliente".$value['id']."' tipo='".$value['tipo_cliente']."' credito='".$value['credito_interno']."' respetoPrecioMayor='".$value['respetar_p_mayor']."'>".$tipoCliente.$credito_interno."<div id='respetaPMayorCI".$value['id']."'></div></div>";
				}else if($value["tipo_cliente"] == 'mayorista' && $value["credito_interno"] == 0){ // mayorista CI bloqueado
					$configCliente = "<div id='configCliente".$value['id']."' tipo='".$value['tipo_cliente']."' credito='".$value['credito_interno']."' respetoPrecioMayor='".$value['respetar_p_mayor']."'>".$tipoCliente.$credito_interno."<div id='respetaPMayorCI".$value['id']."'></div></div>";
				}else if($value["tipo_cliente"] == 'mayorista' && $value["credito_interno"] == 1){ // mayorista CI activo
					$configCliente = "<div id='configCliente".$value['id']."' tipo='".$value['tipo_cliente']."' credito='".$value['credito_interno']."' respetoPrecioMayor='".$value['respetar_p_mayor']."'>".$tipoCliente.$credito_interno.$respetarPrecioMayor."</div>";
				}else if($value["tipo_cliente"] == 'mayorista' && $value["credito_interno"] == 2){ // mayorista CI suspendido
					$configCliente = "<div id='configCliente".$value['id']."' tipo='".$value['tipo_cliente']."' credito='".$value['credito_interno']."' respetoPrecioMayor='".$value['respetar_p_mayor']."'>".$tipoCliente.$credito_interno."<div id='respetaPMayorCI".$value['id']."'></div></div>";
				}else if($value['tipo_cliente'] == 'propietario'){
					$configCliente = "<div id='configCliente".$value['id']."' tipo='".$value['tipo_cliente']."' credito='".$value['credito_interno']."' respetoPrecioMayor='".$value['respetar_p_mayor']."'>".$tipoCliente."<div id='credInt".$value['id']."'></div><div id='respetaPMayorCI".$value['id']."'></div></div>";					
				}


				if($value['rut'] != ''){
					$rut = number_format(intval(explode('-', $value['rut'])[0]),0,',','.');
					$dvRut = strpos($value['rut'], '-') !== false ? explode('-', $value['rut'])[1] : '';
					$rutPersonal = $rut.'-'.$dvRut;
				}else{
					$rutPersonal = '';
				}

				if($value['rut_facturar'] != ''){
					$rut =  str_contains($value['rut_facturar'], '-') ? number_format(intval(explode('-', $value['rut_facturar'])[0]),0,',','.') : '';
					$dvRut = str_contains($value['rut_facturar'], '-') ? explode('-', $value['rut_facturar'])[1] : '';
					$rutFacturar = '<br><b>Facturar: '.$rut.'-'.$dvRut.'</b>';
				}else{
					$rutFacturar = '';
				}


				$ruts = $rutPersonal.$rutFacturar;

				if($_SESSION["perfil"] == "Administrador"){
			  		$datosJson .='[
					    "'.($i).'",
					    "'.$columna1.'",
					    "'.$ruts.'",
					    "'.$contacto.'",
					    "'.$direccion.'",
					    "'.$value['prods_comprados'].'",
					    "'.$value['prods_comprados'].'",
					    "'.$configCliente.'",
					    "'.$limite.'",
					    "'.$deuda.'",
					    "'.$value['ultima_compra'].'",
					    "'.$value['fecha'].'",
					    "'.$botones.'"
				    ],';
			    }else if($_SESSION["perfil"] != "Administrador" && $value['estado'] != 0){ // PERMITE VER SOLO CLIENTES ACTIVOS A VENDEDORES
			  		$datosJson .='[
					    "'.($i).'",
					    "'.$columna1.'",
					    "'.$ruts.'",
					    "'.$contacto.'",
					    "'.$direccion.'",
					    "'.$value['prods_comprados'].'",
					    "'.$value['prods_comprados'].'",
					    "'.$limite.'",
					    "'.$deuda.'",
					    "'.$value['ultima_compra'].'",
					    "'.$value['fecha'].'",
					    "'.$botones.'"
				    ],';			    	
			    }
			}	
		}


		$datosJson = substr($datosJson, 0, -1);
		$datosJson .=   ']}';
		
		echo $datosJson;

	}

}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$cll = new TblClientes();
$cll -> verTblClientes();

