<?php
session_start();
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";

class TablaProductosAbastecimientoInterno{

 	/*=============================================
 	 MOSTRAR LA TABLA DE PRODUCTOS
  	=============================================*/ 

	public function mostrarTablaProductosAbastecimientoInterno(){

		// PERMITE COMPRAR PARA UN LOCAL DETERMINADO, PERO SOLO EL ADMINISTRADOR
		$sucursal = $_GET['suc'];
		$bodega = $_GET['bodega'];
		
		$item = "estado_".$sucursal;
    	$valor = 1;
    	$orden = "fecha";
  		$productos = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);
 		
  		if(count($productos) == 0){

  			echo '{"data": []}';

		  	return;
  		}	
		
  		$datosJson = '{
		  "data": [';

		for($i = 0; $i < count($productos); $i++){
			if($productos[$i]['maneja_stock'] == 'SI'){

				$descripcionESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productos[$i]["descripcion"]);
				$descripcion2ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productos[$i]["descripcion2"]);

			  	$imagen = "<img id='imagenZoom' src='".$productos[$i]["imagen"]."' alt='".$descripcionESCAPE."' class='imagenZoom' width='40px' idProducto='".$productos[$i]["id"]."' data-toggle='modal' data-target='#modalZoomProducto'>";
				$ubicacion = $productos[$i]["zona_".$sucursal];

				$descripcion = "<b>".$descripcionESCAPE."</b><br><font size=-2'>".$descripcion2ESCAPE."</font>";


	  			$sku = $productos[$i]["categoria"] <= 9 ? '0'.$productos[$i]["sku"] : $productos[$i]["sku"];

				// DESCRIPCION AGOTADO
                $cod = "<div class='position-relative p-3 bg-gray'>".
                  "<div class='ribbon-wrapper'>".
                    "<div class='ribbon bg-danger text-md'>".
                      "Agotado".   
                    "</div>".
                  "</div>".
                  "<b>".$ubicacion."-".$sku."</b> (".$productos[$i]["codigo"].")<br>".$descripcionESCAPE."<br>".
                  "<small>".$descripcion2ESCAPE."</small>".
                "</div>";
	                    // $cod = "<div class='position-relative p-3 bg-gray' style='height:auto'></div>";

				if($productos[$i]['stock_'.$bodega] == 0){
					$codigos = $cod;
				}else{
					$codigos = "<b>".$ubicacion."-".$sku."</b> (".$productos[$i]["codigo"].")<br>".$descripcion;
				}

				$p_comp = "$ ".number_format($productos[$i]["precio_compra"], 0, ',', '.');


	 	 		// STOCK CON COLORES DINAMICO 
				$stockSucursal = $productos[$i]["stock_".$sucursal];
	  			$stockIdeal = $productos[$i]['stock_ideal_'.$sucursal];
	  			if($stockSucursal <= $stockIdeal/3){
					$estadoStockSucursal = 1;
	  			}else if($stockSucursal > $stockIdeal/3 && $stockSucursal <= $stockIdeal*2/3){
					$estadoStockSucursal = 2;
	  			}else{
					$estadoStockSucursal = 3;
	  			}

				if($productos[$i]["maneja_stock"] == "SI" && $estadoStockSucursal == 1 && $stockSucursal > 0){
					$colorStkSuc = "<button class='btn btn-danger'>";
				}else if($productos[$i]["maneja_stock"] == "SI" && $estadoStockSucursal == 2 && $stockSucursal > 0){
					$colorStkSuc = "<button class='btn btn-warning'>";
				}else if($productos[$i]["maneja_stock"] == "SI" && $estadoStockSucursal == 3 && $stockSucursal > 0){
					$colorStkSuc = "<button class='btn btn-success'>";
				}else{
					$colorStkSuc = "<button class='btn bg-black'>";
				}
					
				if($productos[$i]["maneja_stock"]=="SI"){
					$stockSucursalMostrar = "<div class='btn-group'>".$colorStkSuc.$stockSucursal."</button></button></div>";
				}
				$stockBodegaMostrar = "<div class='btn-group'><button class='btn' style='color:white; background-color:purple'>".$productos[$i]["stock_".$bodega]."</button></button></div>";

				if($productos[$i]['stock_'.$bodega] == 0){ // TIENE QUE SER BODEGA*********************************
			  		$btnAgregar =  "<div class='btn-group'><button class='btn btn-default recuperarBoton' style='background-color:darkslategrey; color:white' id='agregarProducto0' idProd='".$productos[$i]["id"]."' disabled>Enviar desde<br>".$productos[$i]["zona_".$bodega]."</button></div>"; 
				}else{
			  		$btnAgregar =  "<div class='btn-group'><button class='btn abastecerInternoProd recuperarBoton' style='background-color:darkslategrey; color:white' id='agregarProducto0' idProd='".$productos[$i]["id"]."'>Enviar desde<br>".$productos[$i]["zona_".$bodega]."</button></div>"; 
				}


			  	$datosJson .='[
				      "'.$imagen.'",
				      "'.$codigos.'",
				      "'.$stockSucursalMostrar.'",
				      "'.$stockBodegaMostrar.'",
				      "'.$btnAgregar.'"
				    ],';
			
			}
		}

		$datosJson = substr($datosJson, 0, -1);

		$datosJson .=   '] 

		}';
		
		echo $datosJson;

	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$activarProductosVentas = new TablaProductosAbastecimientoInterno();
$activarProductosVentas -> mostrarTablaProductosAbastecimientoInterno();

