<?php
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

session_start();
require_once "../modelos/conexion.php";
require_once "../modelos/cotizador.modelo.php";
require_once "../modelos/productos.modelo.php";
require_once "../modelos/sucursales.modelo.php";
require_once "../modelos/compras.modelo.php";

class AjaxCotizaciones{
  /*=============================================
  ACTUALIZAR EXPIRACION COTIZACION
  =============================================*/ 
  public function actualizarExpiracionCot(){
  	$idCot = $_POST["actualizarFechaExpiracionCot"];
    date_default_timezone_set("America/Santiago");
    $fechaNueva = date('Y-m-d', strtotime('+1 day', strtotime(date('Y-m-d'))));
    $respuesta = ModeloCotizaciones::mdlActualizarCot('cotizaciones', 'fecha_expiracion', $fechaNueva, $idCot);
    echo $respuesta;
  }

  /*=============================================
  MOSTRAR UTILIDAD COTIZACION
  =============================================*/ 
  public function mostrarUtilidadCot(){
    $_SESSION["mostrarUtilidadCot"] = $_POST["mostrarUtilidadCot"];
    echo $_SESSION["mostrarUtilidadCot"];
  }


  /*=============================================
  DATOS COTIZACION
  =============================================*/ 
  public function datosCot(){
    $datosCot = ModeloCotizaciones::mdlMostrarCotizaciones('cotizaciones','id', $_POST['datosCot']);
    echo json_encode($datosCot);
  }


  /*=============================================
  ACTUALIZAR EXPIRACION COTIZACION
  =============================================*/ 
  public function consolidarVenta(){

    $idsCots = explode(',', $_POST["consolidarVenta"]);
    $idsUnicos = array();

    for ($i=0; $i < count($idsCots); $i++) { // recorre cada cot seleccionada y agrega la cantidad que requiere
      $datosCot = ModeloCotizaciones::mdlMostrarCotizaciones('cotizaciones','id', $idsCots[$i]);
      $prodsCot = json_decode($datosCot['productos'],true);
      foreach ($prodsCot as $item) {
        $id = $item['id'];
        $infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $id);
        if($infoProd['maneja_stock'] == 'SI'){ 
          if (array_key_exists($id, $idsUnicos)) {
              // $idsUnicos[$id] += intval($item['cant']);
            $idsUnicos[$id]['cantidad'] += intval($item['cant']);
            $idsUnicos[$id]['cotizaciones'][] = $idsCots[$i]; 
          } else {
              // $idsUnicos[$id] = intval($item['cant']);
            $idsUnicos[$id] = [
                'cantidad' => intval($item['cant']),
                'cotizaciones' => [$idsCots[$i]]
            ];
          }
        }
      }      
    }


    // EXTRAEMOS LOCALES
    $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
    $locales = array();
    foreach ($sucursales as $key => $value){
      array_push($locales, $value["nombre_sucursal"]);
    }

    // GUARDAMOS CANTIDAD EN TODOS LOS LOCALES
    $cantRealEnLocales = [];
    $cant_a_vender = [];
    $stock_ideal_local = [];
    foreach ($idsUnicos as $idProd => $cantidad){
      $infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);
      $sumaCantLocales = 0;
      for ($i=0; $i < count($sucursales) ; $i++) { 
        $sumaCantLocales += $infoProd['stock_'.$locales[$i]];
      }
      array_push($cantRealEnLocales, $sumaCantLocales);
      array_push($cant_a_vender, $cantidad);
      array_push($stock_ideal_local, $infoProd['stock_ideal_'.$locales[$i-1]]); // stock ideal en un solo local
    } 
    
    // COMPARAMOS CANTIDADES PARA VER SI CUMPLIMOS CON PEDIDO O NO, SI NO SE CUMPLE SE GENERA LA CANTIDAD DE PRODS NECESARIOS A COMPRAR PARA CUBRIR VENTA
    $arrayProdsComprar = [];
    $idsProdsAnalizar = array_keys($idsUnicos); // Obtenemos todas las claves (IDs) del array

    for ($i = 0; $i < count($idsProdsAnalizar); $i++) {

      $id = $idsProdsAnalizar[$i];
      $infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $id);
      $ultimaCompraProd = ModeloCompras::mdlUltimaCompraProd('compras', 'abastecimiento', '%"id":"'.$id.'"%');
      if(is_array($ultimaCompraProd['abastecimiento']) && count($ultimaCompraProd['abastecimiento']) == 1){ // REVISA SI SE HA COMPRADO ANTES
        $datosCompra = json_decode($ultimaCompraProd['abastecimiento'], true);
        foreach ($datosCompra as $elemento) {
          if(isset($elemento['id']) && $elemento['id'] === "$id") {
            $precioCompraNetoUnit = $elemento['pCNetoActual'];
            $precioCompraTotalUnit = $elemento['pCTotalActual'];
            break; // Terminar el bucle una vez que se encuentra el elemento
          }
        }
      }else{
        $precioCompraNetoUnit = $infoProd['pc_neto'];
        $precioCompraTotalUnit = $infoProd['precio_compra'];
      }

      $cantComprar = ($cant_a_vender[$i]['cantidad']-$cantRealEnLocales[$i]) < 0 ? 0 : ($cant_a_vender[$i]['cantidad']-$cantRealEnLocales[$i]);
      $sku = $infoProd['categoria'] <= 9 ? '0'.$infoProd['sku'] : $infoProd['sku'];

      $cantDespuesDeVenderCotizaciones = ($cantRealEnLocales[$i]-$cant_a_vender[$i]['cantidad']);
      $estadoStockDespuesDeVenderCotizaciones = $cantDespuesDeVenderCotizaciones/$stock_ideal_local[$i];
      // $estadoStockDespuesDeVenderCotizaciones = $stock_ideal_local[$i] == 0 ? 0 : $cantDespuesDeVenderCotizaciones/$stock_ideal_local[$i];

      if($estadoStockDespuesDeVenderCotizaciones <= 0.66){

          $arrayProdsComprar[] = [
            'id' => $id,
            'cantComprar' => $cantComprar,
            'cantEnLocales' => $cantRealEnLocales[$i],
            'cantDespuesVenta' => $cantDespuesDeVenderCotizaciones,
            'estadoDespuesVenta' => $estadoStockDespuesDeVenderCotizaciones,
            'cotizaciones' => json_encode($cant_a_vender[$i]['cotizaciones'])
          ];
      }
    }
    echo json_encode($arrayProdsComprar);
  }

  /*=============================================
  EXTRACCION TEXTO WHATSAPP CONSOLIDAR VENTA
  =============================================*/ 
  public function listaProdsConsolidarVenta(){

    $listaProdsConsolidarVenta = json_decode($_POST['textoWspConsolidarVenta'],true);
    $prov = $_POST['idProv'];
    $totalFinalNeto = 0;
    $textoWsp = '';
    for ($i=0; $i < count($listaProdsConsolidarVenta); $i++) { 

      $idProd = $listaProdsConsolidarVenta[$i]['id']; 
      $infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);

      // BUSCA SKU PROVEEDOR
      $arrayProvs = json_decode($infoProd['lista_provs_json'], true);
      $codProv = $prov == 0 ? '' : '(SINCOD)';
      $precioNetoProveedor = 0;
      if(is_array($arrayProvs)){
        for ($i_a=0; $i_a < count($arrayProvs); $i_a++) { 
          if($arrayProvs[$i_a]['prov'] == $prov){
            $codProv = '('.$arrayProvs[$i_a]['cod_prov'].')'; // si es que se ha comprado al proveedor extrae sku_prov
            $precioNetoProveedor = $arrayProvs[$i_a]['pc_neto'];
          }
        }
      }

      // busca ultimo precio de compra
      $ultimaCompraProd = ModeloCompras::mdlUltimaCompraProd('compras', 'abastecimiento', '%"id":"'.$idProd.'"%');
      if(isset($ultimaCompraProd['abastecimiento'])){ // REVISA SI SE HA COMPRADO ANTES
        $datosCompra = json_decode($ultimaCompraProd['abastecimiento'], true);
        foreach ($datosCompra as $elemento) {
          if(isset($elemento['id']) && $elemento['id'] === "$idProd") {
              $precioCompraNetoUnit = $elemento['pCNetoActual']; // ultimo precio comprado indistinto del proveedor
              break; // Terminar el bucle una vez que se encuentra el elemento
          }
        }
      }else{
        $precioCompraNetoUnit = $infoProd['pc_neto']; // precio neto seteado
      }
      $netoFinalUnit = $precioNetoProveedor <= $precioCompraNetoUnit && $precioNetoProveedor > 0 ? $precioNetoProveedor : $precioCompraNetoUnit; // elige el menor precio para enviar a proveedor
      $textoWsp .= '*'.$listaProdsConsolidarVenta[$i]['cantComprar'].'* '.$codProv.'  ```'.$infoProd['descripcion']. '```  *$ '.number_format($netoFinalUnit,0,',','.').'*\n' ;
      $totalFinalNeto += $netoFinalUnit*$listaProdsConsolidarVenta[$i]['cantComprar'];

    }
    echo $textoWsp.'////'.round($totalFinalNeto);
  }
}

/*============================================================
EXTRACCION TEXTO WHATSAPP CONSOLIDAR VENTA
=============================================================*/ 
if(isset($_POST["textoWspConsolidarVenta"])){
  $listaProdsConsolidarVenta = new AjaxCotizaciones();
  $listaProdsConsolidarVenta -> listaProdsConsolidarVenta();
}

/*============================================================
LISTAR EN MODAL PRODS SEGUN COTIZACIONES Y PRODUCTOS FALTANTES
=============================================================*/ 
if(isset($_POST["consolidarVenta"])){
  $consolidarVenta = new AjaxCotizaciones();
  $consolidarVenta -> consolidarVenta();
}

/*=============================================
ACTUALIZAR EXPIRACION COTIZACION
=============================================*/ 
if(isset($_POST["actualizarFechaExpiracionCot"])){
  $actualizarExpiracionCot = new AjaxCotizaciones();
  $actualizarExpiracionCot -> actualizarExpiracionCot();
}
/*=============================================
MOSTRAR UTILIDAD COTIZACION
=============================================*/ 
if(isset($_POST["mostrarUtilidadCot"])){
  $mostrarUtilidadCot = new AjaxCotizaciones();
  $mostrarUtilidadCot -> mostrarUtilidadCot();
}
/*=============================================
DATOS COTIZACION
=============================================*/ 
if(isset($_POST["datosCot"])){
  $mostrarCot = new AjaxCotizaciones();
  $mostrarCot -> datosCot();
}

