<?php
    
  if($_SESSION['perfil'] == 'Administrador'){
    $readonly = '';
  }else{
    $readonly = 'readonly';
  }

  $ventanaRedireccion = isMobileDevice() ? 'productos-movil' : 'productos';
?>

<body onload="atajosGrales()">
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-4">
            <h1>
              Productos
            </h1>
          </div>
          <div class="col-sm-4">
            <h1><?php echo strtoupper($_SESSION['sucursal']);?></h1>
          </div>          
          <div class="col-sm-4">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Inicio</a></li>
              <li class="breadcrumb-item active">Productos</li>
            </ol>
          </div>
        </div>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card">
              <?php 
                if($_SESSION["perfil"] == "Administrador"){
                  echo              
                  '<div class="card-header">
                    <button class="btn btn-primary" id="btnModalAgregarProducto" data-toggle="modal" data-target="#modalAgregarProducto">Agregar producto (F10)</button>
                  </div>';
                }
              ?>
              <div class="card-body">
                <?php 
                  if($_SESSION["perfil"] == "Administrador"){
                    echo'
                    <table class="table table-hover tablaProductosAdmin" style="width:100%">';
                  }else{
                    echo'
                    <table class="table table-hover tablaProductos" style="width:100%">';
                  }
                ?>
                 
                  <thead>
                    <tr>
                      <th>ID</th>
                      <th>#</th>
                      <th>Imagen</th>
                      <th>Categorización</th>
                      <?php 
                        if($_SESSION["perfil"] == "Administrador"){
                          echo'
                          <th>Descripción</th>
                          <th style="width:180px">Relacionados</th>
                          <th style="width:180px">Códigos</th>
                          <th>Stock</th>
                          <th>Historial</th>
                          <th>Precios</th>
                          <th>Margen (%)<br>Normal/Mayor</th>
                          <th>Modificado</th>
                          <th>Estado</th>
                          <th>Acciones</th>';
                        }else{
                          echo'
                          <th>Descripción</th>
                          <th>Códigos</th>
                          <th>Stock</th>
                          <th style="width:100px">Precio venta</th>';
                        }
                      ?>
                    </tr> 
                  </thead>      
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</body>

<?php
  $tipoSucursal = ModeloSucursales::mdlMostrarSucursales('sucursales', 'nombre_sucursal', $_SESSION['sucursal'])[0]['tipo_sucursal'];
  $bg = $tipoSucursal == 'bodega' ? '' : 'background:white';
?>

<!--=====================================
MODAL AGREGAR PRODUCTO
======================================-->
<div id="modalAgregarProducto" class="modal fade modalProds">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form role="form" method="post" id="formAddProd" enctype="multipart/form-data">
        <div class="modal-header" style="background:#3c8dbc; color:white">
          <h4 class="modal-title">Agregar Producto</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="box-body">

            <div class="form-group">
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-industry"></i></span>
                </div>
                <input type="hidden" name="provProdDB" id="provProdDB">
                <select class="form-control input-lg" style="font-size:16px" id="proveedorProducto" name="proveedorProducto" required>
                  <option value="0">Seleccione Proveedor</option>
                  <?php
                    $item = null;
                    $valor = null;
                    $totatolas = ControladorProveedores::ctrMostrarProveedores($item, $valor);                     
                    foreach ($totatolas as $key => $values) {
                      echo '<option value="'.$values["id"].'">'.mb_strtoupper($values["alias_empresa"]).'</option>';                       
                    }
                  ?>
                </select>
              </div>          
            </div>

            <div class="form-group row">
              <div class="col-6">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-th-large"></i></span>
                  </div>
                  <input type="hidden" name="catDB" id="catDB">
                  <input type="hidden" name="subcatDB" id="subcatDB">
                  <select class="form-control input-lg" style="font-size:16px" id="nuevaCategoria" name="nuevaCategoria" autofocus required>
                    <option value="">Categoría</option>
                    <?php
                      $item = null;
                      $valor = null;
                      $categorias = ControladorCategorias::ctrMostrarCategorias($item, $valor);
                      foreach ($categorias as $key => $values) {
                        echo '<option codigo ="'.$values["id_categoria"].'" value="'.$values["id_categoria"].'">'.$values["categoria"].'</option>';
                      }
                    ?>
                  </select>
                </div>          
              </div>
              <div class="col-6">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-th"></i></span>
                  </div>
                  <select class="form-control input-lg" style="font-size:16px" id="nuevaSubcategoria" name="nuevaSubcategoria" required>
                    <option value="">Subcategoría</option>
                  </select>
                </div>          
              </div>
            </div>

            <div class="form-group row">
              <div class="col-6">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-code"></i></span>
                  </div>
                  <input type="text" class="form-control input-lg" id="nuevoCodigo" name="nuevoCodigo"  onkeypress="return soloNumeros(event)" placeholder="Código de Barras">
                </div>          
              </div>
              <div class="col-6">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-code"></i></span>
                  </div>
                  <input type="text" class="form-control input-lg" id="codigoProveedor" name="codigoProveedor" placeholder="Código Proveedor">
                </div>          
              </div>
            </div>

            <div class="form-group">
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-cube"></i></span>
                </div>
                <input type="text" class="form-control input-lg" id="nuevaDescripcion" name="nuevaDescripcion" placeholder="Ingresar Descripción" required>
              </div>          
            </div>

            <div class="form-group">
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-cube"></i></span>
                </div>
                <input type="text" class="form-control input-lg" id="descripcionAlternativa" name="descripcionAlternativa" placeholder="Nombre Alternativo">
              </div>          
            </div>

            <div class="form-group">
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-cube"></i></span>
                </div>
                <input type="text" class="form-control input-lg" style="font-size: 12px" id="descripcionSii" maxlength="25" name="descripcionSii" placeholder="Nombre SII">
              </div>          
            </div>

            <div class="form-group row">
              <div class="col-3">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fas fa-boxes"></i></span>
                  </div>
                  <select class="form-control input-lg" style="font-size: 12px" name="manejaStock" id="manejaStock" autofocus required>
                    <option value="0">MANEJA STOCK?</option>
                    <option value="SI">SI</option>
                    <option value="NO">NO</option>
                  </select>
                </div>          
              </div>
              <div class="col-3">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fas fa-check"></i></span>
                  </div>
                  <input type="number" style="font-size: 12px;" class="form-control input-lg stockIdeal" name="stockIdeal" id="stockIdeal" min="3" onkeypress="return soloNumeros(event)" placeholder="Stock Ideal" required disabled="disabled">
                </div>          
              </div>
              <div class="col-3">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fas fa-box-open"></i></span>
                  </div>
                  <input type="number" style="font-size: 12px;" class="form-control input-lg embalajeCompraProd" name="embalajeCompraProd" id="embalajeCompraProd" min="1" onkeypress="return soloNumeros(event)" placeholder="Embalaje Compra" required disabled="disabled">
                </div>          
              </div>
              <div class="col-3">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fas fa-truck-loading"></i></span>
                  </div>
                  <select class="form-control input-lg" style="font-size: 12px" name="zonaEntregaProd" id="zonaEntregaProd" required disabled>
                    <option value="0">ZONA ENTREGA?</option>
                    <option value="local">LOCAL</option>
                    <option value="patio">PATIO</option>
                  </select>
                </div>          
              </div>
            </div>

            <div class="form-group row">
              <div class="col-4">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-arrow-up"></i></span>
                  </div>
                  <input type="number" class="form-control input-lg" id="nuevoPrecioCompraNeto" name="nuevoPrecioCompraNeto" step="any" min="0" placeholder="S/IVA" onkeypress="return soloNumeros(event)" required>
                </div>          
              </div>
              <div class="col-4">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-arrow-up"></i></span>
                  </div>
                  <input type="number" class="form-control input-lg" id="nuevoPrecioCompra" name="nuevoPrecioCompra" step="any" min="0" placeholder="C/IVA" onkeypress="return soloNumeros(event)" required>
                </div>          
              </div>
              <div class="col-4">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-arrow-down"></i></span>
                  </div>
                  <input type="number" class="form-control input-lg" id="nuevoPrecioVenta" name="nuevoPrecioVenta" step="any" min="0" placeholder="P. Venta" onkeypress="return soloNumeros(event)" required>
                </div>
                <input type="hidden" class="minimal porcentaje" checked>
                <input type="hidden" class="form-control input-lg nuevoPorcentaje" min="0" value="100" required>
              </div>
            </div>

            <div class="form-group row">
              <div class="col-2">
                <div class="input-group">
                <label>
                  Máximo Descuento
                </label>
                </div>
              </div>
              <div class="col-4">
                <div class="input-group">
                  <input type="hidden" class="form-control input-lg nuevoPorcentaje" min="0" value="100" required>
                  <input type="number" class="form-control input-lg" id="descuentoMaximo" name="descuentoMaximo" min="0" max="25" value="0" required>
                  <div class="input-group-append">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-percent"></i></span>
                  </div>
                </div>
              </div>

              <div class="col-2">
                <div class="input-group">
                <label>
                  Cantidad Mayor
                </label>
                </div>
              </div>
              <div class="col-4">
                <div class="input-group">
                  <input type="number" class="form-control input-lg" name="mayoreo" id="mayoreo" min="0" value="50" onkeypress="return soloNumeros(event)" placeholder="Mayoreo" required>
                  <div class="input-group-append">
                    <span class="input-group-text" style="<?php echo $bg;?>">Unids</span>
                  </div>
                </div>
              </div>
            </div>

            <div class="form-group row">
              <div class="col-6">
                <div class="input-group">
                  <label>
                    SUBIR IMAGEN
                  </label>
                  <br>
                  <div class="input-group">
                    <input type="file" class="nuevaImagen" id="nuevaImagen" name="nuevaImagen">
                    <p class="help-block">Peso máximo de la imagen 2MB</p>
                    <img src="componentes/img/productos/default/anonymous.png" class="img-thumbnail previsualizar" width="100px">
                  </div>
                </div>
              </div>

              <div class="col-2">
                <div class="input-group">
                <label>
                  Precio Mayor
                </label>
                </div>
              </div>
              <div class="col-4">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>">$</span>
                  </div>
                  <input type="number" class="form-control input-lg" name="precioMayor" id="precioMayor" min="0" onkeypress="return soloNumeros(event)" placeholder="$ Mayor" required>
                </div>
              </div>
            </div>            
            <input type="hidden" class="form-control input-lg" id="codigoInterno2" name="codigoInterno2" placeholder="Código Interno2" readonly>
          </div>
        </div>
        
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Salir</button>
          <!-- <button type="submit" class="btn btn-primary">Guardar Producto</button> -->
          <button type="button" id="agregarProd" class="btn btn-primary">Guardar Producto</button>
        </div>

        <?php
          // $crearProducto = new ControladorProductos();
          // $crearProducto -> ctrCrearProducto($ventanaRedireccion);
        ?>
      </form>
    </div>
  </div>
</div>

<!--=====================================
MODAL EDITAR PRODUCTO
======================================-->
<div id="modalEditarProducto" class="modal fade modalProds" role="dialog">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form role="form" method="post" enctype="multipart/form-data" id="formEditProd">
        <div class="modal-header" style="background:#3c8dbc; color:white">
          <h4 class="modal-title">Editar Producto</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="box-body">

            <div class="form-group row">
              <div class="col-6">
                Código Producto
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-code"></i></span>
                  </div>
                  <input type="text" class="form-control input-lg" id="editarCodigo" readonly required>
                </div>          
              </div>
              <div class="col-6">
                Código Interno
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-code"></i></span>
                  </div>
                  <input type="text" class="form-control input-lg" id="editarCodigoInterno" readonly required>
                </div>          
              </div>
            </div>

            <div class="form-group row">
              <div class="col-6">
                Proveedor
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-industry"></i></span>
                  </div>
                  <select class="form-control input-lg" style="font-size:16px" id="editarProveedorProducto" required></select>
                  <input type="hidden" id="nomProvEdit" >
                </div>          
              </div>
              <div class="col-6">
                Código Proveedor
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-code"></i></span>
                  </div>
                  <input type="text" class="form-control input-lg" id="codigoProveedorEditar" placeholder="Código Proveedor">  
                </div>          
              </div>
            </div>      

            <div class="form-group row">
              <div class="col-9">
                Descripción
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-cube"></i></span>
                  </div>
                  <input type="text" class="form-control input-lg" id="editarDescripcion" <?php echo $readonly ?> required>
                </div>          
              </div>
              <div class="col-3">
                Zona
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-map-marker"></i></span>
                  </div>
                  <input type="text" class="form-control input-lg" id="editarUbicacion" placeholder="Zona" autofocus>
                </div>          
              </div>
            </div>

            <div class="form-group">
              Descripción Adicional
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-comment"></i></span>
                </div>
                <input type="text" class="form-control input-lg" id="nombreAlternativo" placeholder="Nombre alternativo">
              </div>          
            </div>


            <div class="form-group">
              Descripción SII
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-comment"></i></span>
                </div>
                <input type="text" class="form-control input-lg" maxlength="25" id="editarDescSii" placeholder="Nombre SII">
              </div>          
            </div>

            <div class="form-group row">
              <div class="col-3">
                Maneja Stock
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fas fa-boxes"></i></span>
                  </div>
                  <select class="form-control input-lg" style="font-size: 100%"  id="editarManejaStock" autofocus required>
                    <option value="0">STOCK?</option>
                    <option value="SI">SI</option>
                    <option value="NO">NO</option>
                  </select>
                </div>          
              </div>
              <div class="col-3">
                Stock Ideal
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fas fa-check"></i></span>
                  </div>
                  <input type="hidden" class="form-control input-lg" id="editarStock" min="0" onkeypress="return soloNumeros(event)" placeholder="Stock Actual" required>
                  <input type="number" class="form-control input-lg" style="font-size: 12px" id="editarStockIdeal" min="3" onkeypress="return soloNumeros(event)" placeholder="Stock Ideal" required>
                </div>          
              </div>
              <div class="col-3">
                Embalaje Compra
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fas fa-box-open"></i></span>
                  </div>
                  <input type="number" style="font-size: 12px;" class="form-control input-lg editarEmbalajeCompraProd" id="editarEmbalajeCompraProd" min="1" onkeypress="return soloNumeros(event)" placeholder="Embalaje Compra" required disabled="disabled">
                </div>          
              </div>
              <div class="col-3">
                Zona Entrega Producto
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fas fa-truck-loading"></i></span>
                  </div>
                  <select class="form-control input-lg" style="font-size: 12px" id="editarZonaEntregaProd" autofocus required>
                    <option value="0">ZONA ENTREGA?</option>
                    <option value="local">LOCAL</option>
                    <option value="patio">PATIO</option>
                  </select>
                </div>          
              </div>
              <div class="col-6">
                Precio Compra Neto
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-arrow-up"></i></span>
                  </div>
                  <input type="number" class="form-control input-lg" id="editarPrecioCompraNeto" step="0.01" min="0" placeholder="Precio Neto" required>
                </div>
              </div>
              <div class="col-6">
                Precio Venta
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-arrow-down"></i></span>
                  </div>
                  <input type="number" class="form-control input-lg" id="editarPrecioVenta" step="any" min="0" placeholder="Precio de venta" onkeypress="return soloNumeros(event)" required>
                  <input type="hidden" class="minimal porcentaje" checked>
                  <input type="hidden" class="form-control input-lg nuevoPorcentaje" min="0" value="100" required>
                </div>          
              </div>
            </div>

            <div class="form-group row">
              <div class="col-6">
                Precio Compra c/iva
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-arrow-up"></i></span>
                  </div>
                  <input type="number" class="form-control input-lg" id="editarPrecioCompra" step="any" min="0" placeholder="Precio c/iva" onkeypress="return soloNumeros(event)" required>
                </div>
              </div>
              <div class="col-6">
                Cantidad Mayor
                <div class="input-group">
                  <input type="number" class="form-control input-lg"  id="editarMayoreo" min="0" value="50" onkeypress="return soloNumeros(event)" placeholder="Mayoreo" required>
                  <div class="input-group-append">
                    <span class="input-group-text" style="<?php echo $bg;?>">Unids</span>
                  </div>
                </div>          
              </div>
            </div>              

            <div class="form-group row">
              <div class="col-6">
                Máximo Descuento
                <div class="input-group">
                  <input type="hidden" class="form-control input-lg nuevoPorcentaje" min="0" value="100" required>
                  <input type="number" class="form-control input-lg" id="editarDescuentoMaximo" min="0" max="25" value="" required>
                  <div class="input-group-append">
                    <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-percent"></i></span>
                  </div>
                </div>
              </div>
              <div class="col-6">
                Precio Mayor
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="<?php echo $bg;?>">$</span>
                  </div>
                  <input type="number" class="form-control input-lg" id="editarPrecioMayor" min="0" onkeypress="return soloNumeros(event)" placeholder="$ Mayor" required>
                </div>          
              </div>
            </div>

            <input type="hidden" id="idProductoEditar" >

            <div class="form-group">
              <div class="panel">SUBIR IMAGEN</div>

                  <!-- <input type="file" id="comprobanteRend" accept=".jpg,.png,.jpeg,.pdf"> -->
                <input type="file" id="editarImagen" class="nuevaImagen" accept=".jpg,.png,.jpeg">
                <p class="help-block">Peso máximo de la imagen 2MB</p>
                <img src="componentes/img/productos/default/anonymous.png" class="img-thumbnail previsualizar" width="100px">
                <input type="hidden" id="imagenActual">
            </div>
          </div>
        </div>  

        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Salir</button>
          <button type="button" id="editarProd" class="btn btn-primary">Editar Producto</button>
        </div>

        <?php
          // $editarProducto = new ControladorProductos();
          // $editarProducto -> ctrEditarProducto($ventanaRedireccion);
        ?>      
      </form>
    </div>
  </div>
</div>

