<?php
date_default_timezone_set("America/Santiago");
if($_SESSION["perfil"] == "Especial" || $_SESSION["perfil"] == "Vendedor"){

  echo '<script>

    window.location = "inicio";

  </script>';

  return;

}

?>
<body onload="atajosGrales()">
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-4">
            <h1>
              Compromisos de Pago
            </h1>
          </div>
          <div class="col-sm-4">
            <h1><?php echo strtoupper($_SESSION['sucursal']);?></h1>
          </div>          
          <div class="col-sm-4">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Inicio</a></li>
              <li class="breadcrumb-item active">Compromisos de Pago</li>
            </ol>
          </div>
        </div>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card">
              <div class="card-header row mantener-posicion fondo-bco">
                <div class="col-2">
                  <button class="btn btn-success" id="addCompromisoPago" data-toggle="modal" data-target="#modalRegistrarCompromisoPago">Compromiso Pago (F10)</button>
                  <input type="hidden" id="totalCompromisos" value="0">

                </div>

                <div class="col-8" style="align-items: center;"><h3>
                  <?php
                    if(isset($_GET['fechaInicial'])){
                      $fecha1 = $_GET['fechaInicial'];
                      $fecha2 = $_GET['fechaFinal'];
                    }else{
                      $fecha1 = date('Y-m-d', strtotime('-2 month'));
                      $fecha2 = date('Y-m-d', strtotime('+3 month'));
                    }

                    $compromisos = ModeloMovimientosBancarios::mdlMostrarCompromisosPagoRango('compromisos_pago', $fecha1, $fecha2);

                    $totalPagar = 0;
                    $vencido = 0;
                    $pagado = 0;
                    $pagarFuturo = 0;
                    $interes = 0;
                    $venceHoy = 0;
                    $hoy = date('Y-m-d');




                    $hoyUF = ModeloMovimientosBancarios::mdlValorUF($hoy);
                    if ($hoyUF && is_array($hoyUF)){ // busca si está en DB
                      $valorUF = ModeloMovimientosBancarios::mdlValorUF($hoy)['valor'];
                    }else{ // si no la busca en API REST
                      $fechaBuscar = date("d-m-Y", strtotime($hoy));
                      $apiUrl = 'https://mindicador.cl/api/uf/'.$fechaBuscar;
                      if(ini_get('allow_url_fopen')){
                          $json = file_get_contents($apiUrl);
                      }else{
                          //De otra forma utilizamos cURL
                          $curl = curl_init($apiUrl);
                          curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                          $json = curl_exec($curl);
                          curl_close($curl);
                      }
                      $dailyIndicators = json_decode($json);
                      $valorUFDia = $dailyIndicators->serie[0]->valor;
                      $registrarUFHoy = ModeloMovimientosBancarios::mdlRegistrarUFAnterior($hoy, $valorUFDia);
                    }
                    
                    if(is_array($compromisos)){
                      foreach ($compromisos as $key_0 => $value_0){

                        if($value_0['tipo_compromiso'] == 'hipotecario' && $value_0['fecha_vencimiento'] > date('Y-m-d')){
                          $valorUF = ModeloMovimientosBancarios::mdlValorUF(date('Y-m-d'))['valor'];
                          $monto = $value_0["monto"]*$valorUF;
                        }else if($value_0['tipo_compromiso'] == 'hipotecario' && $value_0['fecha_vencimiento'] <= date('Y-m-d')){

                          // $valorUF = ModeloMovimientosBancarios::mdlValorUF($value_0['fecha_vencimiento'])['valor'];
                          $datoUF = ModeloMovimientosBancarios::mdlValorUF($value_0['fecha_vencimiento']);
                          if ($datoUF && is_array($datoUF)){
                          
                              $valorUF = $datoUF['valor'];
                          
                          } else {// BUSCANDO EN LA WEB

                                $fechaBuscar = date("d-m-Y", strtotime($value_0['fecha_vencimiento']));
                                $apiUrl = 'https://mindicador.cl/api/uf/'.$fechaBuscar;
                                if(ini_get('allow_url_fopen')){
                                    $json = file_get_contents($apiUrl);
                                }else{
                                    //De otra forma utilizamos cURL
                                    $curl = curl_init($apiUrl);
                                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                                    $json = curl_exec($curl);
                                    curl_close($curl);
                                }
                                $dailyIndicators = json_decode($json);
                                $valorUFDia = $dailyIndicators->serie[0]->valor;
                                $registrarUF = ModeloMovimientosBancarios::mdlRegistrarUFAnterior($value_0['fecha_vencimiento'], $valorUFDia);
                                $valorUF = $valorUFDia;
                          
                          }
                          $monto = $value_0["monto"]*$valorUF;
                        
                        }else{
                          $monto = $value_0['monto'];
                        }

                        $totalPagar += $monto;

                        $abonoParcial = 0;

                        $jsonDB = $value_0["abonos"];
                        if ($jsonDB && is_string($jsonDB)) {
                          $abonosParciales = json_decode($jsonDB,true);
                          if($value_0["abonos"] != ''){
                            for ($i=0; $i < count($abonosParciales); $i++) {
                              $abonoParcial += $abonosParciales[$i]['monto'];
                            }
                          }
                        }
                        

                        $pagado += $value_0['monto_pagado']+$abonoParcial;

                        if($value_0['estado'] == 0 && $value_0['fecha_vencimiento'] < date('Y-m-d')){
                          $vencido += $monto - $value_0['monto_pagado'] - $abonoParcial;
                        }

                        if($value_0['estado'] == 0 && $value_0['fecha_vencimiento'] >= date('Y-m-d')){
                          $pagarFuturo += $monto - $value_0['monto_pagado'];
                        }

                        if($value_0['interes_pagado'] > 0){
                          $interes += $value_0['interes_pagado'];
                        }

                        if($value_0['fecha_vencimiento'] == $hoy){
                          $venceHoy += $monto;
                        }
                      }  
                    }
                    

                    echo '
                      <font color="IndianRed">Vencido: '.number_format($vencido,0,',','.').'</font>    
                      <font color="salmon">Vence Hoy: '.number_format($venceHoy,0,',','.').'</font>    
                      <font color="Navy">Pagado: '.number_format($pagado,0,',','.').'   (<i class="info" data-original-title="INTERES PAGADO">'.number_format($interes,0,',','.').'</i>)</font>    
                      <font color="teal">Por Pagar: '.number_format($pagarFuturo,0,',','.').'</font><br>
                      <font color="teal" id="totalSeleccionadoMostrar"></font>';

                  ?>
                </h3>

                </div>
                <div class="col-2">
                  <button type="button" class="btn btn-default float-right" id="daterange-btn3">
                    <span>
                      <i class="fa fa-calendar"></i>
                        <?php
                          if(isset($_GET["fechaInicial"])){
                            echo $_GET["fechaInicial"]." - ".$_GET["fechaFinal"];
                          }else{
                            echo 'Rango de fecha';
                          }
                        ?>
                      <i class="fa fa-caret-down"></i>
                    </span>
                  </button>
                </div>

              </div>
              <div class="card-body">
                <table class="table table-bordered table-hover tablaCompromisos">
                  <thead>
                    <tr>
                      <th style="width:10px">#</th>
                      <th>Deuda</th>
                      <th>Descripción</th>
                      <th>Pagado</th>
                      <th>Interés</th>
                      <th>Detalle Pago</th>
                      <th style="width:100px">Acciones</th>
                    </tr> 
                  </thead>
                </table>    
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</body>

<!--=====================================
MODAL REGISTRAR COMPROMISO PAGO
======================================-->
<?php
  $bg = $tipoSucursal == 'bodega' ? '' : 'background:white';
?>
<div id="modalRegistrarCompromisoPago" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <form role="form" method="post" enctype="multipart/form-data">
        <div class="modal-header badge-success">
          <h4 class="modal-title">Registrar Compromiso Pago</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="box-body">

            <div class="form-group"> <!-- DEUDOR -->
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-user"></i></span>
                </div>
                  <select class="form-control input-lg" id="nombreDeudorCompromiso" name="nombreDeudorCompromiso" required>
                    <option value="">Selecionar Deudor</option>
                    <option value="Sama">SAMA</option>
                    <option value="C. Dinamarca">CARLOS DINAMARCA</option>
                    <option value="E. Dinamarca">EDUARDO DINAMARCA</option>
                    <option value="Janoron">JANORON</option>
                    <option value="Carmen">CARMEN</option>
                  </select>
              </div>          
            </div>

            <div class="form-group"> <!-- TIPO DEUDA -->
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-list"></i></span>
                </div>
                <select class="form-control input-lg" name="tipoCompromiso" id="tipoCompromiso" required>
                  <option value="">Selecionar Tipo Compromiso</option>
                  <option value="gastos_sama">GASTOS SAMA</option>
                  <option value="gastos_carlos">GASTOS CARLOS</option>
                  <option value="gastos_edu">GASTOS EDU</option>
                  <option value="arriendo">ARRIENDO</option>
                  <option value="cheque">CHEQUE</option>
                  <option value="consumo">CRÉDITO CONSUMO</option>
                  <option value="hipotecario">CRÉDITO HIPOTECARIO</option>
                  <option value="convenio">CONVENIO</option>
                  <option value="compra_activo">COMPRA ACTIVO</option>
                  <option value="tc">TARJETA CRÉDITO</option>
                </select>
              </div>          
            </div>

            <div id="esCheque" class="d-none form-group"> <!-- SI ES CHEQUE -->
              <div class="input-group">              
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-industry"></i></span>
                </div>
                <select class="form-control input-lg" name="chequeBanco" id="chequeBanco">
                  <option value="">Procedencia Cheque</option>
                  <option value="santander">SANTANDER EDU</option>
                  <option value="itau">ITAÚ EDU</option>
                  <option value="itau">ESTADO CARLOS</option>
                </select>
              </div>
            </div>

            <div class="inputAcreedor form-group d-none"></div> <!-- ACREEDOR -->

            <div class="inputFechaVencimiento d-none form-group">Fecha Vencimiento <!-- FECHA VENCIMIENTO -->
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-calendar-alt"></i></span>
                </div>
                <input type="date" class="form-control input-lg" maxlength="10" onkeypress="return soloFecha(event)" id="fechaVencimiento" name="fechaVencimiento" placeholder="Fecha contable" value="">
              </div>
            </div>

            <div id="esConsumo" class="d-none"> <!-- SI ES CONSUMO -->
              <div class="form-group row">
                <div class="col-6">              
                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-list-ol"></i></span>
                    </div>
                    <select class="form-control input-lg" name="cuotasConsumo" id="cuotasConsumo">
                      <option value="">Nro Cuotas</option>
                      <?php
                        for($i=1;$i<=84;$i++){
                          echo'<option value="'.$i.'">'.$i.'</option>';
                        }
                      ?>
                    </select>
                  </div>
                </div>
                <div class="col-6">
                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text" style="background-color:white"><i class="fa fa-dollar-sign"></i></span>
                    </div>
                    <input type="text" class="input-lg form-control" id="valorCuotaConsumoMostrar" name="valorCuotaConsumoMostrar" maxlength="11"  placeholder="Valor Cuota" onkeypress="return soloNumeros(event)" onkeyup="formatoMiles($(this));" onchange="sinFormatoMiles('valorCuotaConsumo', $(this).val());">
                    <input type="hidden" id="valorCuotaConsumo" name="valorCuotaConsumo">
                  </div>
                </div>
              </div>

              <div class="form-group">Primer Vencimiento <!-- FECHA VENCIMIENTO -->
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text" style="background-color:white"><i class="fa fa-calendar-alt"></i></span>
                  </div>
                  <input type="date" class="form-control input-lg" maxlength="10" onkeypress="return soloFecha(event)" id="primerVencimientoConsumo" name="primerVencimientoConsumo" value="">
                </div>
              </div>


            </div>

            <div class="inputDescripcionCompromiso d-none form-group"> <!-- DESCRIPCION -->
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="background-color:white"><i class="fa fa-info"></i></span>
                </div>
                <input type="text" class="input-lg form-control" id="descripcionCompromisoPago" name="descripcionCompromisoPago" placeholder="Describa la Deuda">
              </div>
            </div>

            <div class="inputMontoCompromiso d-none form-group"> <!-- MONTO -->
              <div class="row">
                <div class="col-9" id="anchoMontoCompromiso">              
                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text" style="background-color:white"><i class="fa fa-dollar-sign"></i></span>
                    </div>
                    <input type="text" class="form-control input-lg" id="montoCompromisoPagoVista" maxlength="11" placeholder="Ingrese monto" onkeypress="return soloNumeros(event)" onkeyup="formatoMiles($(this));" onchange="sinFormatoMiles('montoCompromisoPago', $(this).val());">
                    <input type="hidden" id="montoCompromisoPago" name="montoCompromisoPago">
                  </div>
                </div>
                <div class="col-3" id="anchoCheckCobroAnual">              
                  <input type="hidden" name="cobroAnual" id="cobroAnual" value="NO">
                  <div class="input-group">
                    <div class="checkbox">
                      <label><input type="checkbox" id="checkCobroAnual">Cobro Anual?</label>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

      <div class="modal-footer justify-content-between">
        <button type="button" class="btn btn-default" data-dismiss="modal">Salir</button>
        <button type="submit" class="btn btn-success" id="registrarCompromisoPago">Registrar Compromiso Pago</button>
      </div>

        <?php
          $registrarCompromisoPago = new ControladorMovimientosBancarios();
          $registrarCompromisoPago -> ctrRegistrarCompromisoPago('compromisos-pago');
        ?>
      </form>
    </div>
  </div>
</div>

<!--=====================================
MODAL PARA REGISTRAR EL PAGO DE COMPROMISO
======================================-->
<div id="modalRegistrarPago" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header badge-success">
        <h4 class="modal-title" id="tituloRegistraPago">Registrar Pago</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="box-body">
        <input type="hidden" id="registrarPagoID">
        <input type="hidden" id="aPagar">
        <input type="hidden" id="descDeuda">

        <h4 class="text-success">Monto Adeudado: <b class="aPagarCompromiso"></b></h4>

        <?php date_default_timezone_set("America/Santiago"); ?>

          <div class="form-group">Fecha Pago <!-- FECHA PAGO -->
            <div class="input-group">
              <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-calendar-alt"></i></span> 
              <input type="date" class="form-control input-lg" maxlength="10" onkeypress="return soloFecha(event)" id="fechaPagoCompromiso" name="fechaPagoCompromiso" value="<?php echo date('Y-m-d'); ?>">
            </div>
          </div>

          <div class="form-group"> <!-- MONTO PAGADO-->
            <div class="input-group">
              <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-dollar-sign"></i></span>
              <input type="text" class="form-control input-lg" id="montoPagadoVista" maxlength="11" placeholder="Ingrese Monto Pagado" onkeypress="return soloNumeros(event)" onkeyup="formatoMiles($(this));">
            </div>
          </div>

          <div class="form-group"> <!-- MONEDA PAGO -->
            <div class="input-group">
              <span class="input-group-text" style="<?php echo $bg;?>"><i class="fas fa-hand-holding-usd"></i></span> 
              <select class="form-control input-lg" id="monedaPagoCompromiso">
                <option value="">Selecionar Moneda Pago</option>
                <option value="cobro_bancario">COBRO BANCARIO</option>
                <option value="efectivo">EFECTIVO</option>
                <option value="tarjeta">TARJETA</option>
                <option value="transf">TRANSFERENCIA</option>
                <option value="webpay">WEBPAY</option>
                <option value="dcto_automatico">DESCUENTO AUTOMATICO</option>
              </select>
            </div>
          </div>
          <div class="form-group"> <!-- COMPROBANTE -->
            <div class="input-group"><label>ADJUNTAR COMPROBANTE</label><br></div>
            <div class="input-group"><input type="file" id="comprobantePagoFinal" accept="application/pdf,image/*"></div>
          </div>
        </div>
      </div>
      <div class="modal-footer justify-content-between">
        <button type="button" class="btn btn-default" data-dismiss="modal">Salir</button>
        <button type="submit" class="btn btn-success" id="registrarPagoCompromiso">Registrar Pago</button>
      </div>
    </div>
  </div>
</div>


<!--=====================================
MODAL NOTA DE CREDITO
======================================-->
<div id="modalNC" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header bg-info">
        <h4 class="modal-title" id="tituloRegistroNC">Abonos Parciales</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="box-body">

          <input type="hidden" id="idCompromisoPagoAbonoParcial">
          <input type="hidden" id="aPagarAbonoParcial">

          <h4 class="text-info">Monto Adeudado: <b class="aPagarCompromiso"></b></h4>



          <div class="form-group">Fecha Abono <!-- FECHA PAGO -->
            <div class="input-group">
              <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-calendar-alt"></i></span> 
              <input type="date" class="form-control input-lg" maxlength="10" onkeypress="return soloFecha(event)" id="fechaPagoAbonoParcial" value="<?php echo date('Y-m-d'); ?>">
            </div>
          </div>

          <!-- <div class="form-group">
            <label>Tipo de Abono</label>
            <select class="form-control" id="tipoAbonoParcial">
              <option value="">Tipo Abono</option>
              <option value="nc">Nota Crédito</option>
              <option value="ab">Abono</option>
            </select>
          </div> -->

          <div class="form-group notaCredito">
            <label>Nro NC</label>
            <input type="text" class="form-control nc input-lg" id="nroNC" maxlength="11" placeholder="Ingrese Nro NC" onkeypress="return soloNumeros(event)" onkeyup="formatoMiles($(this));">
          </div>

          <div class="form-group notaCredito">
            <label>Monto NC</label>
            <input type="text" class="form-control nc input-lg" id="montoNC" maxlength="11" placeholder="Ingrese Monto NC" onkeypress="return soloNumeros(event)" onkeyup="formatoMiles($(this));">
          </div>


          <div class="form-group d-none abonoParcial"> <!-- COMPROBANTE -->
            <div class="input-group">              
              <label>ADJUNTAR COMPROBANTE</label>
              <br>
            </div>
            <div class="input-group">              
              <input type="file" class="abParc" id="comprobanteAbonoParcial" accept="application/pdf,image/*">
            </div>
          </div>
        </div>
      </div>

      <div class="modal-footer justify-content-between">
        <button type="button" class="btn btn-default" data-dismiss="modal">Salir</button>
        <button type="button" id="ingresarNC" class="btn btn-info">Registrar Abono Parcial</button>
      </div>
    </div>
  </div>
</div>