<?php

if($_SESSION["perfil"] == "Vendedor"){

  echo '<script>

    window.location = "inicio";

  </script>';

  return;

}

?>

<body onload="atajosGrales()">
  <div class="content-wrapper">
    <section class="content-header d-none d-lg-block">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-4">
            <h1>
              Administrar categorías
            </h1>
          </div>
          <div class="col-sm-4">
            <h1><?php echo strtoupper($_SESSION['sucursal']);?></h1>
          </div>          
          <div class="col-sm-4">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Inicio</a></li>
              <li class="breadcrumb-item active">Administrar categorías</li>
            </ol>
          </div>
        </div>
      </div>
    </section>
    <div class="row mb-2 d-lg-none"></div>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-primary card-outline">
              <div class="card-header d-none d-lg-block">
                <button class="btn btn-primary" id="addCat" data-toggle="modal" data-target="#modalAgregarCategoria">
                  Agregar Categoria (F10)
                </button>
              </div>
              <div class="card-body">
                <h4 class="col-12 text-center d-lg-none">
                  Categorías
                  <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modalAgregarCategoria"><i class="far fa-plus"></i></button>
                </h4>
                <table class="table table-bordered table-hover tblCats dt-responsive">
                  <thead>
                    <tr>
                      <th style="width:10px">#</th>
                      <th>Categoria</th>
                      <th style="width:30px">Acciones</th>
                    </tr> 
                  </thead>
                  
                  <tbody>

                    <?php

                      $categorias = ControladorCategorias::ctrMostrarCategorias(null, null);
                      foreach ($categorias as $key => $value) {
                       
                        echo '
                        <tr>
                          <td>'.($key+1).'</td>
                          <td class="text-uppercase">'.$value["categoria"].'</td>
                          <td>
                            <div class="btn-group">  
                              <button class="btn btn-warning btnEditarCategoria" idCategoria="'.$value["id"].'" data-toggle="modal" data-target="#modalEditarCategoria"><i class="fa fa-pen"></i></button>';
                              if($_SESSION["perfil"] == "Administrador"){
                                echo '<button class="btn btn-danger btnEliminarCategoria" idCategoria="'.$value["id"].'"><i class="fa fa-times"></i></button>';
                              }
                            echo '
                            </div>  
                          </td>
                        </tr>';
                      }
                    ?>

                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</body>

<?php
  $tipoSucursal = ModeloSucursales::mdlMostrarSucursales('sucursales', 'nombre_sucursal', $_SESSION['sucursal'])[0]['tipo_sucursal'];
  $bg = $tipoSucursal == 'bodega' ? '' : 'background:white';
?>

<!--=====================================
MODAL AGREGAR CATEGORÍA
======================================-->
<div id="modalAgregarCategoria" class="modal fade">
  <div class="modal-dialog">
    <div class="modal-content">
      <form role="form" method="post" enctype="multipart/form-data">
        <div class="modal-header" style="background:#3c8dbc; color:white">
          <h4 class="modal-title">Agregar Categoría</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="box-body">

            <div class="form-group">
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-th-large"></i></span>
                </div>
                <input type="text" class="form-control input-lg" id="nuevaCategoria" name="nuevaCategoria" placeholder="Ingresar categoría" autofocus required>
              </div>          
            </div>

          </div>
        </div>

        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Salir</button>
          <button type="submit" class="btn btn-primary">Guardar Categoría</button>
        </div>

        <?php
          $crearCategoria = new ControladorCategorias();
          $crearCategoria -> ctrCrearCategoria();
        ?>
      </form>
    </div>
  </div>
</div>

<!--=====================================
MODAL EDITAR CATEGORÍA
======================================-->
<div id="modalEditarCategoria" class="modal fade">
  <div class="modal-dialog">
    <div class="modal-content">
      <form role="form" method="post" enctype="multipart/form-data">
        <div class="modal-header" style="background:#3c8dbc; color:white">
          <h4 class="modal-title">Editar Categoría</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="box-body">

            <div class="form-group">
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text" style="<?php echo $bg;?>"><i class="fa fa-th-large"></i></span>
                </div>
                <input type="text" class="form-control input-lg" name="editarCategoria" id="editarCategoria" required>
                <input type="hidden" id="idCategoria" name="idCategoria" required>
              </div>          
            </div>  
          </div>
        </div>

        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Salir</button>
          <button type="submit" class="btn btn-primary">Editar Categoría</button>
        </div>

        <?php
          $crearCategoria = new ControladorCategorias();
          $crearCategoria -> ctrEditarCategoria();
        ?>
      </form>
    </div>
  </div>
</div>

<?php
  $borrarCategoria = new ControladorCategorias();
  $borrarCategoria -> ctrBorrarCategoria();
?>