<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-4">
          <h1>
            Ajustes
          </h1>
        </div>
        <div class="col-sm-4">
          <h1><?php echo strtoupper($_SESSION['sucursal']);?></h1>
        </div>          
        <div class="col-sm-4">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">Inicio</a></li>
            <li class="breadcrumb-item active">Ajustes</li>
          </ol>
        </div>
      </div>
    </div>
  </section>


  <section class="content">
    <div class="container-fluid">

      <div class="row">

        <div class="col-md-3">

          <div class="card card-success">
            <div class="card-header">
              <h3 class="card-title">Información Empresa</h3>
            </div>

            <?php
              $nombreEmpresa = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_real')['ajuste'];
              $nombreFantasia = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_comercial')['ajuste'];
              $rutEmpresa = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_comercial')['ajuste'];
              $giroComercial = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'giro_comercial')['ajuste'];
              $direccionEmpresa = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'direccion_comercial')['ajuste'];
              $fonoVentas = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'];
              $whatsappVentas = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_ventas')['ajuste'];
              $correoCorporativo = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_ventas')['ajuste'];
            ?>

            <div class="card-body">
              <div class="form-group">
                <label>Nombre Empresa:</label>
                <div class="input-group">
                  <input type="text" id="nombreReal" class="form-control ajustesInfoEmpresa" value="<?php echo $nombreEmpresa; ?>" disabled>
                </div>
              </div>
              <div class="form-group">
                <label>Nombre Fantasía:</label>
                <div class="input-group">
                  <input type="text" id="nombreComercial" class="form-control ajustesInfoEmpresa" value="<?php echo $nombreFantasia; ?>" disabled>
                </div>
              </div>
              <div class="form-group">
                <label>Rut Empresa:</label>
                <div class="input-group">
                  <input type="text" id="rutComercial" onkeyup="verificaRut($(this))" onkeypress="return soloRut(event)" class="form-control ajustesInfoEmpresa" value="<?php echo $rutEmpresa; ?>" disabled>
                </div>
              </div>
              <div class="form-group">
                <label>Giro Comercial:</label>
                <div class="input-group">
                  <input type="text" id="giroComercial" class="form-control ajustesInfoEmpresa" value="<?php echo $giroComercial; ?>" disabled>
                </div>
              </div>
              <div class="form-group">
                <label>Dirección:</label>
                <div class="input-group">
                  <input type="text" id="direccionComercial" class="form-control ajustesInfoEmpresa" value="<?php echo $direccionEmpresa; ?>" disabled>
                </div>
              </div>
            </div>

            <div class="card-footer">
              <button type="button" class="btn btn-warning float-left" id="btnEditarAjustesInfoEmpresa">Editar Configuración</button>
              <button type="button" class="btn btn-success float-right ajustesInfoEmpresa" id="btnGuardarAjustesInfoEmpresa" disabled>Guardar Configuración</button>              
            </div>
          </div>

          <div class="card card-navy">
            <div class="card-header">
              <h3 class="card-title">Información Bancaria</h3>
            </div>








            <?php
              $nombreBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_banco')['ajuste'];
              $tipoCuentaBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'tipo_cuenta_banco')['ajuste'];
              $nroCuentaBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nro_cuenta_banco')['ajuste'];
              $nombreTitularBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_titular_banco')['ajuste'];
              $rutTitularBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_titular_banco')['ajuste'];
              $correoPagosBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_pagos_banco')['ajuste'];
              $arrayBancos = ['bci','chile','estado','itau','scotiabank','santander'];
              $arrayTipoCuentas = ['ahorro','corriente','vista'];
            ?>

            <div class="card-body">
              <div class="form-group">
                <label>Banco:</label>
                <div class="input-group">
                  <select id="nombreBanco" class="form-control ajustesInfoBanco" disabled>
                    <?php
                      echo
                      '<option value="'.$nombreBanco.'">Banco '.strtoupper($nombreBanco).'</option>';
                      for ($i=0; $i < count($arrayBancos); $i++) { 
                        if($arrayBancos[$i] != $nombreBanco){
                          echo
                          '<option value="'.$arrayBancos[$i].'">Banco '.strtoupper($arrayBancos[$i]).'</option>';
                        }
                      }
                    ?>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <label>Tipo Cuenta:</label>
                <div class="input-group">
                  <select id="tipoCuentaBanco" class="form-control ajustesInfoBanco" disabled>
                    <?php
                      echo
                      '<option value="'.$tipoCuentaBanco.'">'.strtoupper($tipoCuentaBanco).'</option>';
                      for ($i=0; $i < count($arrayTipoCuentas); $i++) { 
                        if($arrayTipoCuentas[$i] != $tipoCuentaBanco){
                          echo
                          '<option value="'.$arrayTipoCuentas[$i].'">'.strtoupper($arrayTipoCuentas[$i]).'</option>';
                        }
                      }
                    ?>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <label>Número de Cuenta:</label>
                <div class="input-group">
                  <input type="text" id="nroCuentaBanco" onkeypress="return soloEnteros(event)" class="form-control ajustesInfoBanco" value="<?php echo $nroCuentaBanco; ?>" disabled>
                </div>
              </div>
              <div class="form-group">
                <label>Rut:</label>
                <div class="input-group">
                  <input type="text" id="rutTitularBanco" onkeyup="verificaRut($(this))" onkeypress="return soloRut(event)" class="form-control ajustesInfoBanco" value="<?php echo $rutTitularBanco; ?>" disabled>
                </div>
              </div>
              <div class="form-group">
                <label>Nombre:</label>
                <div class="input-group">
                  <input type="text" id="nombreTitularBanco" class="form-control ajustesInfoBanco" value="<?php echo $nombreTitularBanco; ?>" disabled>
                </div>
              </div>
              <div class="form-group">
                <label>Correo:</label>
                <div class="input-group">
                  <input type="email" id="correoPagosBanco" class="form-control ajustesInfoBanco" onkeyup="validarEmail($(this))" value="<?php echo $correoPagosBanco; ?>" disabled>
                </div>
              </div>
            </div>

            <div class="card-footer">
              <button type="button" class="btn btn-warning float-left" id="btnEditarAjustesBanco">Editar Datos Bancarios</button>
              <button type="button" class="btn btn-success float-right ajustesInfoBanco" id="btnGuardarAjustesBanco" disabled>Guardar Datos Bancarios</button>              
            </div>
          </div>
        

        </div>

        <div class="col-md-3">
          <div class="card card-primary">
            <div class="card-header">
              <h3 class="card-title">Configuración Cotizaciones</h3>
            </div>


           <?php
              $fonoCot = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_cot')['ajuste'];
              $whatsappCot = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_cot')['ajuste'];
              $correoCot = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_cot')['ajuste'];
              $vigenciaCot = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'vigencia_cot')['ajuste'];
              $utMinVendCot = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'ut_min_vend_cot')['ajuste'];
              $utMinAdminCot = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'ut_min_admin_cot')['ajuste'];
            ?>

            <div class="card-body">

              <div class="form-group row">
                <label>Fono Cotizaciones:</label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="fonoCot" maxlength="9" onkeypress="return soloEnteros(event)" class="form-control ajusteCot" value="<?php echo $fonoCot; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste cot'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste cot d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>Whatsapp Cotizaciones:</label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="wspCot" maxlength="9" onkeypress="return soloEnteros(event)" class="form-control ajusteCot" value="<?php echo $whatsappCot; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste cot'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste cot d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              
              <div class="form-group row">
                <label>Correo Cotizaciones:</label>
                <div class="input-group divAjuste col-10">
                  <input type="email" id="correoCot" class="form-control ajusteCot" onkeyup="validarEmail($(this))" value="<?php echo $correoCot; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste cot'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste cot d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>Vigencia Cotizaciones (días):</label>
                <div class="col-10">
                  <font size="-1" class="text-secondary">Se cotiza hoy <?php echo date('d-m-Y'); ?> y se puede vender hasta el día <b id="diaExpiracionCot"><?php echo date('d-m-Y', strtotime('+'.$vigenciaCot.'day')); ?></b></font>
                </div>
                <div class="col-1"></div>
                <div class="input-group divAjuste col-10">
                  <input type="number" min="1" max="30" id="vigenciaCot" class="form-control ajusteCot" value="<?php echo $vigenciaCot; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste cot'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste cot d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>Utilidad Mínima Vendedor:</label>
                <div class="col-11">
                  <font size="-1" class="text-secondary" id="ejemploUtMinVendCot"><b>(<?php echo $utMinVendCot ?>%)</b>. Si el producto lo compro en $1.000, <b>MÍNIMO</b> se cotizará en <i>$<?php echo number_format(1000*(1+$utMinVendCot/100),0,',','.'); ?></i> asegurando a lo menos una utilidad de <b>$<?php echo number_format(1000*($utMinVendCot/100),0,',','.') ?></b>.</font>
                </div>
                <div class="col-1"></div>
                <div class="input-group divAjuste">
                  <div class="col-3 divAjuste">
                    <input type="number" min="0" max="100" id="utMinVendCot" class="form-control ajusteCot vend" value="<?php echo $utMinVendCot; ?>" disabled>
                  </div>
                  <div class="col-7 divAjusteSlider">
                    <div class="mb-2"></div>
                    <input type="range" min="0" max="100" value="<?php echo $utMinVendCot; ?>" step="1" class="form-control-range ajusteCot vend" id="formControlRange" disabled>
                  </div>
                  <div class="col-2">
                    <div class='btn-group'>
                      <button class='btn btn-warning btn-sm btnEditAjuste cot'><i class='fa fa-pen'></i></button>
                      <button class='btn btn-info btn-sm btnCancelarEdicionAjuste cot d-none'><i class="fas fa-ban"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>Utilidad Mínima Administrador:</label>
                <div class="col-11">
                  <font size="-1" class="text-secondary" id="ejemploUtMinAdminCot"><b>(<?php echo $utMinAdminCot ?>%)</b>. Si el producto lo compro en $1.000, <b>MÍNIMO</b> se cotizará en <i>$<?php echo number_format(1000*(1+$utMinAdminCot/100),0,',','.'); ?></i> asegurando a lo menos una utilidad de <b>$<?php echo number_format(1000*($utMinAdminCot/100),0,',','.') ?></b>.</font>
                </div>
                <div class="col-1"></div>
                <div class="input-group">
                  <div class="col-3 divAjuste">
                    <input type="number" min="1" max="100" id="utMinAdminCot" class="form-control ajusteCot admin" value="<?php echo $utMinAdminCot; ?>" disabled>
                  </div>
                  <div class="col-7 divAjusteSlider">
                    <div class="mb-2"></div>
                    <input type="range" min="1" max="100" value="<?php echo $utMinAdminCot; ?>" step="1" class="form-control-range ajusteCot admin" id="formControlRange" disabled>
                  </div>
                  <div class="col-2">
                    <div class='btn-group'>
                      <button class='btn btn-warning btn-sm btnEditAjuste cot'><i class='fa fa-pen'></i></button>
                      <button class='btn btn-info btn-sm btnCancelarEdicionAjuste cot d-none'><i class="fas fa-ban"></i></button>
                    </div>
                  </div>
                 </div>
              </div>
            </div>
          </div>
        </div>

        <div class="col-md-3">
          <div class="card card-info">
            <div class="card-header">
              <h3 class="card-title">Configuración Ventas</h3>
            </div>


           <?php
              $fonoVentas = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'];
              $whatsappVentas = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_ventas')['ajuste'];
              $correoVentas = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_ventas')['ajuste'];
              $utMinVendVentas = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'ut_min_vend_venta')['ajuste'];
              $utMinAdminVentas = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'ut_min_admin_venta')['ajuste'];
            ?>

            <div class="card-body">

              <div class="form-group row">
                <label>Fono Ventas:</label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="fonoVentas" maxlength="9" onkeypress="return soloEnteros(event)" class="form-control ajusteVentas" value="<?php echo $fonoVentas; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste venta'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste venta d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>Whatsapp Ventas:</label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="wspVentas" maxlength="9" onkeypress="return soloEnteros(event)" class="form-control ajusteVentas" value="<?php echo $whatsappVentas; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste venta'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste venta d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              
              <div class="form-group row">
                <label>Correo Ventas:</label>
                <div class="input-group divAjuste col-10">
                  <input type="email" id="correoVentas" onkeyup="validarEmail($(this))" class="form-control ajusteVentas" value="<?php echo $correoVentas; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste venta'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste venta d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>

              <div class="form-group row">
                <label>Utilidad Mínima Vendedor:</label>
                <div class="col-11">
                  <font size="-1" class="text-secondary" id="ejemploUtMinVendVentas"><b>(<?php echo $utMinVendVentas ?>%)</b>. Si el producto lo compro en $1.000, <b>MÍNIMO</b> se cotizará en <i>$<?php echo number_format(1000*(1+$utMinVendVentas/100),0,',','.'); ?></i> asegurando a lo menos una utilidad de <b>$<?php echo number_format(1000*($utMinVendVentas/100),0,',','.') ?></b>.</font>
                </div>
                <div class="col-1"></div>
                <div class="input-group divAjuste">
                  <div class="col-3 divAjuste">
                    <input type="number" min="0" max="100" id="utMinVendVenta" class="form-control ajusteVentas vend" value="<?php echo $utMinVendVentas; ?>" disabled>
                  </div>
                  <div class="col-7 divAjusteSlider">
                    <div class="mb-2"></div>
                    <input type="range" min="0" max="100" value="<?php echo $utMinVendVentas; ?>" step="1" class="form-control-range ajusteVentas vend" id="formControlRange" disabled>
                  </div>
                  <div class="col-2">
                    <div class='btn-group'>
                      <button class='btn btn-warning btn-sm btnEditAjuste venta'><i class='fa fa-pen'></i></button>
                      <button class='btn btn-info btn-sm btnCancelarEdicionAjuste venta d-none'><i class="fas fa-ban"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>Utilidad Mínima Administrador:</label>
                <div class="col-11">
                  <font size="-1" class="text-secondary" id="ejemploUtMinAdminVentas"><b>(<?php echo $utMinAdminVentas ?>%)</b>. Si el producto lo compro en $1.000, <b>MÍNIMO</b> se cotizará en <i>$<?php echo number_format(1000*(1+$utMinAdminVentas/100),0,',','.'); ?></i> asegurando a lo menos una utilidad de <b>$<?php echo number_format(1000*($utMinAdminVentas/100),0,',','.') ?></b>.</font>
                </div>
                <div class="col-1"></div>
                <div class="input-group">
                  <div class="col-3 divAjuste">
                    <input type="number" min="1" max="100" id="utMinAdminVenta" class="form-control ajusteVentas admin" value="<?php echo $utMinAdminVentas; ?>" disabled>
                  </div>
                  <div class="col-7 divAjusteSlider">
                    <div class="mb-2"></div>
                    <input type="range" min="1" max="100" value="<?php echo $utMinAdminVentas; ?>" step="1" class="form-control-range ajusteVentas admin" id="formControlRange" disabled>
                  </div>
                  <div class="col-2">
                    <div class='btn-group'>
                      <button class='btn btn-warning btn-sm btnEditAjuste venta'><i class='fa fa-pen'></i></button>
                      <button class='btn btn-info btn-sm btnCancelarEdicionAjuste venta d-none'><i class="fas fa-ban"></i></button>
                    </div>
                  </div>
                 </div>
              </div>
            </div>
          </div>


          <div class="card card-gray-dark">
            <div class="card-header">
              <h3 class="card-title">Configuración Compras</h3>
            </div>


            <?php
              $correoCompras = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_compras')['ajuste'];
            ?>

            <div class="card-body">

              <div class="form-group row">
                <label>Correo Compras:</label>
                <div class="input-group divAjuste col-10">
                  <input type="email" id="correoCompras" class="form-control ajusteCompras" onkeyup="validarEmail($(this))" value="<?php echo $correoCompras; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste compras'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste compras d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>

            </div>
          </div>          
        </div>

        <div class="col-md-3">
          <div class="card card-olive">
            <div class="card-header">
              <h3 class="card-title">Configuración Productos</h3>
            </div>


           <?php
              $skuProdComun = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'sku_prod_comun')['ajuste'];
              $skuFlete = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'sku_flete')['ajuste'];
              $skuInteres = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'sku_interes')['ajuste'];
              $limInferiorInventario = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'lim_inf_inventario')['ajuste'];
              $limSuperiorInventario = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'lim_sup_inventario')['ajuste'];
            ?>

            <div class="card-body">

              <div class="form-group row">
                <label>SKU Producto Común:</label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="skuProdComun" maxlength="9" onkeypress="return soloEnteros(event)" class="form-control ajusteProd" value="<?php echo $skuProdComun; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste prod'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste prod d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>SKU Flete:           </label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="skuFlete" maxlength="9" onkeypress="return soloEnteros(event)" class="form-control ajusteProd" value="<?php echo $skuFlete; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste prod'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste prod d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>SKU Interés:           </label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="skuInteres" maxlength="9" onkeypress="return soloEnteros(event)" class="form-control ajusteProd" value="<?php echo $skuInteres; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste prod'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste prod d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>Límite Inferior Inventario ($):           </label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="limInfInventario" maxlength="13" onkeypress="return soloEnteros(event)" class="form-control ajusteProd miles" value="<?php echo number_format($limInferiorInventario,0,',','.'); ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste prod'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste prod d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>Límite Superior Inventario ($):           </label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="limSupInventario" maxlength="13" onkeypress="return soloEnteros(event)" class="form-control ajusteProd miles" value="<?php echo number_format($limSuperiorInventario,0,',','.'); ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste prod'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste prod d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="card card-purple">
            <div class="card-header">
              <h3 class="card-title">Configuración Impresora Térmica 80mm</h3>
            </div>
           <?php
              // $usoImpresoraTermica = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'uso_impresora_termica')['ajuste'];
              $nombreImpresoraTermica = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_impresora_termica')['ajuste'];
              $apiKeyImpresoraTermica = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'api_key_impresora_termica')['ajuste'];
              // $checked = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'uso_impresora_termica')['ajuste'] == 1 ? 'checked' : '';
              $checked = 'checked';
            ?>

            <div class="card-body">
              <div class="form-group row">
                <label>Uso Impresora Térmica:</label>
                <div class="input-group custom-control custom-switch divAjuste col-12">
                  
                  <input id="checkboxUsoImpresora" type="checkbox" class="checkboxUsoImpresora" onchange="" <?php echo $checked?>>

                  <label for="checkboxUsoImpresora" class="switchUsoImpresora">
                    <span class="switch__circleUsoImpresora">
                        <span class="switch__circleUsoImpresora-inner text-center"><div style="height: 3px"></div><i class="fas fa-print"></i></span>
                    </span>
                    <span class="switch__left_usoImpresora"> NO</span>
                    <span class="switch__right_usoImpresora">SI  </span>
                  </label>                
                </div>

              </div>
              <div class="form-group row">
                <label>Nombre Impresora Térmica:           </label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="nombreImpresoraTermica" class="form-control ajustePrint" value="<?php echo $nombreImpresoraTermica; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste print'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste print d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group row">
                <label>Key Impresora Térmica:           </label>
                <div class="input-group divAjuste col-10">
                  <input type="text" id="apiKeyImpresoraTermica" class="form-control ajustePrint" value="<?php echo $apiKeyImpresoraTermica; ?>" disabled>
                </div>
                <div class="col-2">
                  <div class='btn-group'>
                    <button class='btn btn-warning btn-sm btnEditAjuste print'><i class='fa fa-pen'></i></button>
                    <button class='btn btn-info btn-sm btnCancelarEdicionAjuste print d-none'><i class="fas fa-ban"></i></button>
                  </div>
                </div>
              </div>
            </div>
          </div>


        </div>

      </div>
    </div>
  </section>
</div>
