/*=============================================
RANGO DE FECHAS
=============================================*/
if(localStorage.getItem("capturarRango4") != null){
    $("#daterange-btn4 span").html(localStorage.getItem("capturarRango4"));
}else{
    $("#daterange-btn4 span").html('<i class="fa fa-calendar"></i> Rango de fecha')
}

$('#daterange-btn4').daterangepicker(
    {
        ranges: {
            'Home'       : [moment().subtract(1, 'month'), moment()],
            'Este mes'  : [moment().startOf('month'), moment().endOf('month')],
            'Mes Anterior'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Este año'  : [moment().startOf('year'), moment().endOf('year')],
            'Año Anterior'  : [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        },
        startDate: moment(),
        endDate  : moment()
    },
    function (start, end){
        var fechaInicial = start.format('YYYY-MM-DD');
        var fechaFinal = end.format('YYYY-MM-DD');
        var hoy = moment(new Date()).format('YYYY-MM-DD');
        var fecha1 = fechaInicial;
        var fecha2 = fechaFinal;
        $('#daterange-btn4 span').html(moment(fecha1).format('DD-MM-YY') + ' - ' + moment(fecha2).format('DD-MM-YY'));
        var capturarRango = $("#daterange-btn4 span").html();
        localStorage.setItem("capturarRango4", capturarRango);
       	window.location = "index.php?ruta=ventas&fechaInicial="+fecha1+"&fechaFinal="+fecha2;
    }
)

/*------------------------------------------------------------------------------------------------------------------------------------------------------
VERSION MOVIL
------------------------------------------------------------------------------------------------------------------------------------------------------*/
var tablaDataProductos = $('.tablaVentaProductosMovil').DataTable({
	"ajax": "ajax/datatable-ventaProductosMovil.ajax.php?perfil="+perfil+"&skuProdComun="+ajuste('sku_prod_comun')+"&utMin="+ajuste('ut_min_admin_venta')+"&skuInteres="+ajuste('sku_interes')+"&ventana="+obtenerPAGINA_y_GET(window.location).pagina,
	"deferRender": true,
	"retrieve": true,
	"processing": true,
	"language": {

		"sProcessing": "Procesando...",
		"sLengthMenu": "Mostrar _MENU_ registros",
		"sZeroRecords": "No se encontraron resultados",
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		"sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
		"sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		"sInfoPostFix": "",
		"sSearch": "<button class='btn btn-info btn-sm' onclick='actualizarTabla();'><i class='fas fa-undo'></i></button>    Buscar",
		"sUrl": "",
		"sInfoThousands": ",",
		"sLoadingRecords": "Cargando...",
		"oPaginate": {
			"sFirst": "Primero",
			"sLast": "Último",
			"sNext": "Siguiente",
			"sPrevious": "Anterior"
		},
		"oAria": {
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		}

	},
	dom: '<"row"<"col-sm-12 col-md-4"f>>t<"row">'
});

$(".tablaVentaProductosMovil tbody").on("click", "button.agregarUnico", function() {
	var idProducto = $(this).attr("idProducto");
	var cantMay = $(this).attr("mayDesde");
	var precMay = $(this).attr("pMay");
	var mayAnt = $(this).attr("mayAnt");
	var pVentMayAnt = $(this).attr("pVentMayAnt");
    var sucursal = $('#sucursalActiva').val();
	var sku = infoProd(idProducto)['sku'];
	var skuInteres = ajuste('sku_interes');
	var inputValor = $(this).parent().parent().parent().children('.div-interes').children('.precioVentaProdMovilVista').val();

	$(this).removeClass("btn-success agregarUnico");
	$(this).addClass("btn-default");
	$("button[idProd='" + idProducto + "']").attr("disabled",'disabled');
	
	var datos = new FormData();
	datos.append("idProducto", idProducto);

	$.ajax({
		url: "ajax/productos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta) {
			descripcion = respuesta["descripcion"];
			codigoInterno = respuesta["sku"];
			maneja_stock = respuesta["maneja_stock"];
			stock = respuesta["stock_"+sucursal];
			precio = respuesta["precio_venta"];
			descuento = respuesta["descuento"];
			mayoreo = cantMay;
			precioMayor = precMay != 0 ? precMay : respuesta["precio_mayor"];
			precioCompra = respuesta["precio_compra"];
			ubic = respuesta["zona_"+sucursal];

			readonlyCantidad = "";
			readonlyPrecio = maneja_stock == 'NO' ? '' : "readonly";
			readonlyDcto = "";
			readonlyDescripcion = "readonly";

			mayoreoPrecioUnico = mayoreo <= 1 ? '(Precio Único: '+formatNumber.new(precioMayor, "$")+'c/u)' : '('+formatNumber.new(precio, "$")+'c/u desde '+mayoreo+'u '+formatNumber.new(precioMayor, "$")+'c/u)';

			if(Number(sku) == Number(skuInteres)){
				precioValor = inputValor;
			}else{
				if(Number(mayoreo) <= 1){
					precioValor = precioMayor;
				}else{
					precioValor = precio;
				}
			}

			descripcionMostrar = '<b>'+ubic+'-'+codigoInterno+'</b> '+descripcion+' <b>'+mayoreoPrecioUnico+'</b> [<i>'+descuento+'%</i>]';
			skuProdComun = ajuste('sku_prod_comun');	
			inputDescripcion = maneja_stock == 'NO' && codigoInterno == skuProdComun ? '<input type="" class="form-control nuevaDescripcionProducto descProdComun" codigointerno="000000" style="height: 40px" idproducto="'+idProducto+'" name="agregarProducto" required placeholder="INGRESE DESCRIPCION DEL PRODUCTO">' : '<input type="hidden" class="form-control nuevaDescripcionProducto" style="height: 40px" idproducto="'+idProducto+'" codigointerno="'+codigoInterno+'" name="agregarProducto" value="'+descripcion+'" required="" readonly="'+readonlyDescripcion+'">';


			estilo = maneja_stock == 'NO' ? '' : 'height: 40px;background-color:rgb(169,249,98)';
			disabled = (mayoreo == 1 || mayoreo == 0) ? 'disabled' : '';
			precioUnico = (mayoreo == 1 || mayoreo == 0) ? precioMayor : precio;
			calculoDcto = Math.round((1 - (precioUnico/precio))*10000)/100; //dcto con 2 decimales
			descuentoInput = calculoDcto < 0 ? 0 : calculoDcto; // SI DCTO ES MENOR A CERO SE PONE CERO SI NO EL DCTO QUE PERTENECE

			$(".nuevoProducto").prepend(
	          	'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
	            	'<div class="col-12 descripcion" style="padding-left:0px">'+
	              		'<div>'+
	                		'<div>'+
	                  			'<button type="button" class="btn btn-danger btn-xs quitarProducto" idproducto="'+idProducto+'">'+
	                    			'<i class="fa fa-times"></i>'+
	                  			'</button>'+
	                  			'<font size="-1">   '+descripcionMostrar+'</font>'+
	                		'</div>'+
	                		inputDescripcion+
	              		'</div>'+
	            	'</div>'+
	            	'<div style="height:25px"></div>'+
	            	'<div class="col-3 cantidadProducto" style="padding-left:0px">'+
	              		'<font size="-2">Cantidad</font>'+
	              		'<input type="number" class="form-control nuevaCantidadProducto" style="height: 40px" name="nuevaCantidadProducto" id="nuevaCantidadProducto" min="1" value="1" stock="'+stock+'" mayoreo="'+mayoreo+'" required autofocus '+readonlyCantidad+'>'+
	            	'</div>'+
		            '<div class="col-6 ingresoPrecio" style="padding-left:0px">'+
	              		'<font size="-2">Total ($)</font>'+
	              		'<div class="input-group">'+
			                '<input type="number" style="'+estilo+'" class="form-control nuevoPrecioProducto" tipoPrecio="unico" pEditado="'+precioValor+'" id="nuevoPrecioProducto" value="'+precioValor+'" required '+readonlyPrecio+'>'+
	              		'</div>'+
	            	'</div>'+
		            '<div class="col-3 ingresoDescuento" style="padding-left:0px">'+
		              	'<div>'+
		              		'<font size="-2">Descuento</font>'+
		                	'<input type="number" style="'+estilo+'" min="0" max="' + descuento + '" class="form-control descuentoProducto" step="1" value="'+descuentoInput+'" '+disabled+' required '+readonlyDcto+'>'+
		              	'</div>'+
		            '</div>'+
		        '</div>'+
		        '<div id="esp'+idProducto+'" style="height:3px"></div>')
		}
	})
	listarProductos()
	$('#modalVentaMovil').modal('hide');

});


/************************************************************************************************************************************************************************************************
VERSION ESCRITORIO
************************************************************************************************************************************************************************************************/

/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// EDITAR PRECIO EN VIVO
$(".tablaVentaProductos").on("click", ".btnEditPVentVivo", function(){ // INTERFAZ PARA CAMBIO PRECIO
	var perfil = $('#perfilVend').val();
	var idProd  = $(this).attr("idProd");
	var datosProd = infoProd(idProd);
	var	ut_min_venta = ajuste('ut_min_admin_venta');
	var pMinProdAdmin = Math.round(Number(datosProd['precio_compra'])*(1+Number(ut_min_venta)/100)); // permite ventas con 10% de utilidad a administradores
	precioAlerta = perfil == 'Administrador' ? pMinProdAdmin : Math.ceil(datosProd['precio_mayor']);
	mixinInfo('El precio debe ser igual o superior a '+formatNumber.new(precioAlerta, "$"));
  	$(this).parent().parent().html('<div><input type="text" style="width:110px" class="form-control input-xs" name="pVMayVivo" id="pVMayVivo" placeholder="Precio Mayor" value="'+datosProd['precio_mayor']+'" onkeypress="return soloNumeros(event)" required>'+
		                           '<br>'+
         		                   '<button style="width:110px" class="btn btn-info btn-xs editPVentaVivo" idProd="'+idProd+'">Actualizar Precio</button></div>');
	$('#pVMayVivo').select();
})

$(".tablaVentaProductos").on("click", ".editPVentaVivo", function(){ // CAMBIO PRECIO EN VIVO
	var perfil = $('#perfilVend').val();
	var idProd = $(this).attr('idProd');
	var datosProd = infoProd(idProd);
	var precioVivo = $(this).parent().children('#pVMayVivo').val();
	var	ut_min_venta_admin = ajuste('ut_min_admin_venta');
	var pMinProdAdmin = Math.round(Number(datosProd['precio_compra'])*(1+Number(ut_min_venta_admin)/100)); // permite ventas con 10% de utilidad a administradores

	if(precioVivo != '' && precioVivo != 0 && Number(precioVivo) >= Number(datosProd['precio_mayor']) && perfil != 'Administrador'){ // permite que vendedores den precio sobre precio mayor
		$("button[idProducto='" + idProd + "']").removeClass("agregarProducto btn-primary");
		$("button[idProducto='" + idProd + "']").addClass("agregarUnico btn-success");
		$("button[idProducto='" + idProd + "']").attr("pMay",precioVivo);
		// VISUAL
		$(this).parent().html("<div><b>"+formatNumber.new(datosProd['precio_venta'], "$")+" c/u</b> ("+datosProd['descuento']+"%)"+
							  "<br>"+
							  "<b style='color:rgb(92,184,92)' class='varMayor' idProd='"+idProd+"'>&uarr; 0u $ "+formatNumber.new(precioVivo, "$")+" c/u</b>"+
							  "<br>"+
							  "<button class='btn btn-warning btn-xs btnEditPVentVivo' idProd='"+idProd+"'><i class='fa fa-pen'></i></button>"+
							  "</div>");
	    audioSuccess('Nuevo precio $'+formatNumber.new(Math.ceil(precioVivo)));
	
	}else if(precioVivo != '' && precioVivo != 0 && Number(precioVivo) >= Number(pMinProdAdmin) && perfil == 'Administrador'){ // permite que administradores den precio el 10% utilidad
		$("button[idProducto='" + idProd + "']").removeClass("agregarProducto btn-primary");
		$("button[idProducto='" + idProd + "']").addClass("agregarUnico btn-success");
		$("button[idProducto='" + idProd + "']").attr("pMay",precioVivo);
		// VISUAL
		$(this).parent().html("<div><b>"+formatNumber.new(datosProd['precio_venta'], "$")+" c/u</b> ("+datosProd['descuento']+"%)"+
							  "<br>"+
							  "<b style='color:rgb(92,184,92)' class='varMayor' idProd='"+idProd+"'>&uarr; 0u $ "+formatNumber.new(precioVivo, "$")+" c/u</b>"+
							  "<br>"+
							  "<button class='btn btn-warning btn-xs btnEditPVentVivo' idProd='"+idProd+"'><i class='fa fa-pen'></i></button>"+
							  "</div>");
		audioSuccess('Nuevo precio $'+formatNumber.new(Math.ceil(precioVivo)));

	}else{
		pMinAlerta = perfil == 'Administrador' ? pMinProdAdmin : datosProd['precio_mayor'];
		audioError('El precio debe ser igual o superior a '+formatNumber.new(Math.ceil(pMinAlerta, "$")));
		$('#pVMayVivo').select();
	} 
})

// AGREGANDO PRODUCTOS PRECIO VENTA EDITADO PC
$(".tablaVentaProductos").on("click", "button.agregarUnico", function() {

	var idProducto = $(this).attr("idProducto");

	var datosProd = infoProd(idProducto);
	var idCliente = $("#seleccionarCliente option:selected").val();
	var datosCliente = infoCliente(idCliente);
	var tipo_cliente = datosCliente['tipo_cliente'];

	var precioEditado = tipo_cliente == 'propietario' ? datosProd['precio_compra'] : $(this).attr("pMay");
	var filtroPropietario = tipo_cliente == 'propietario' ? 'precioProp' : '';

    var sucursal = $('#sucursalActiva').val();
	$(this).removeClass("btn-primary agregarUnico");
	$(this).addClass("btn-default");
	$("button[idProd='" + idProducto + "']").attr("disabled",'disabled');
	let sku = Number(datosProd['categoria']) >= 10 ? datosProd['sku'] : 0+datosProd['sku'];
	let stock = datosProd["stock_"+sucursal];
	let ubic = datosProd["zona_"+sucursal];
	let descripcionMostrar = '<b>'+ubic+'-'+sku+'</b> '+datosProd['descripcion']+' <b>(Precio Único: '+formatNumber.new(precioEditado, "$")+'c/u)</b> [<i>'+datosProd["descuento"]+'%</i>]';
	if(Number(datosProd['precio_venta']) == Number(datosProd['precio_mayor'])){
		if(tipo_cliente == 'propietario'){
			var estilo = 'height: 40px;background-color:rgb(98,249,210)';
		}else{
			var estilo = 'height: 40px';
		}
	}else{
		var estilo = 'height: 40px;background-color:rgb(169,249,98)'; // filtro color precio unico y precio editado
	}
	
	let calculoDcto = Math.round((1 - (precioEditado/datosProd['precio_venta']))*10000)/100; //dcto con 2 decimales
	let descuentoInput = calculoDcto < 0 ? 0 : calculoDcto; // SI DCTO ES MENOR A CERO SE PONE CERO SI NO EL DCTO QUE PERTENECE

	$(".nuevoProducto").prepend(
      	'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
        	'<div class="col-12 descripcion" style="padding-left:0px">'+
          		'<div>'+
            		'<div>'+
              			'<button type="button" class="btn btn-danger btn-xs quitarProducto" idproducto="'+idProducto+'">'+
                			'<i class="fa fa-times"></i>'+
              			'</button>'+
              			'<font size="-1">   '+descripcionMostrar+'</font>'+
            		'</div>'+
            		'<input type="hidden" class="form-control nuevaDescripcionProducto" style="height: 40px" idproducto="'+idProducto+'" codigointerno="'+sku+'" name="agregarProducto" value="'+datosProd['descripcion']+'" readonly>'+
          		'</div>'+
        	'</div>'+
        	'<div style="height:25px"></div>'+
        	'<div class="col-3 cantidadProducto" style="padding-left:0px">'+
          		'<font size="-2">Cantidad</font>'+
          		'<input type="number" class="form-control nuevaCantidadProducto" style="height: 40px" id="nuevaCantidadProducto" min="1" value="1" stock="'+stock+'">'+
        	'</div>'+
            '<div class="col-6 ingresoPrecio" style="padding-left:0px">'+
          		'<font size="-2">Total ($)</font>'+
          		'<div class="input-group">'+
	                '<input type="number" style="'+estilo+'" class="form-control nuevoPrecioProducto '+filtroPropietario+'" tipoPrecio="unico" onmouseover="$(this).tooltip(\'show\')" onmouseout="$(this).tooltip(\'hide\')" data-original-title="$ '+formatNumber.new(precioEditado)+' c/u" pEditado="'+precioEditado+'" id="nuevoPrecioProducto"  value="'+precioEditado+'" readonly>'+
          		'</div>'+
        	'</div>'+
            '<div class="col-3 ingresoDescuento" style="padding-left:0px">'+
              	'<div>'+
              		'<font size="-2">Descuento</font>'+
                	'<input type="number" style="'+estilo+'" min="0" max="' + datosProd["descuento"] + '" class="form-control descuentoProducto" step="1" value="'+descuentoInput+'" disabled>'+
              	'</div>'+
            '</div>'+
        '</div>'+
        '<div id="esp'+idProducto+'" style="height:3px"></div>')

	listarProductos()
	$('#modalVentaMovil').modal('hide');
});

// AGREGANDO PRODUCTOS PRECIO VENTA EDITADO PC
$(".tablaVentaProductos").on("click", "button.agregarOferta", function() {

	var idProd = $(this).attr("idProducto");
    var sucursal = $('#sucursalActiva').val();
	var datosProd = infoProd(idProd);
	var idCliente = $("#seleccionarCliente option:selected").val();
	var datosCliente = infoCliente(idCliente);
	var tipo_cliente = datosCliente['tipo_cliente'];

	var precioFinal = tipo_cliente == 'propietario' ? datosProd['precio_compra'] : datosProd['precio_mayor'];
	var filtroPropietario = tipo_cliente == 'propietario' ? 'precioProp' : '';

	$(this).removeClass("btn-primary agregarOferta");
	$(this).addClass("btn-default");
	$("button[idProd='" + idProd + "']").attr("disabled",'disabled');

	let sku = Number(datosProd['categoria']) >= 10 ? datosProd['sku'] : 0+datosProd['sku'];
	let stock = datosProd["stock_"+sucursal];
	let ubic = datosProd["zona_"+sucursal];
	let descripcionMostrar = '<b>'+ubic+'-'+sku+'</b> '+datosProd['descripcion']+' <b>(Precio Único: '+formatNumber.new(precioFinal, "$")+'c/u)</b> [<i>'+datosProd["descuento"]+'%</i>]';
	let estilo = 'height: 40px;background-color:rgb(98,249,210)';
	let calculoDcto = Math.round((1 - (precioFinal/datosProd['precio_venta']))*10000)/100; //dcto con 2 decimales
	let descuentoInput = calculoDcto < 0 ? 0 : calculoDcto; // SI DCTO ES MENOR A CERO SE PONE CERO SI NO EL DCTO QUE PERTENECE



	$(".nuevoProducto").prepend(
      	'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
        	'<div class="col-12 descripcion" style="padding-left:0px">'+
          		'<div>'+
            		'<div>'+
              			'<button type="button" class="btn btn-danger btn-xs quitarProducto" idProducto="'+idProd+'">'+
                			'<i class="fa fa-times"></i>'+
              			'</button>'+
              			'<font size="-1">   '+descripcionMostrar+'</font>'+
            		'</div>'+
            		'<input type="hidden" class="form-control nuevaDescripcionProducto" style="height: 40px" idProducto="'+idProd+'" codigointerno="'+sku+'" name="agregarProducto" value="'+datosProd['descripcion']+'" readonly>'+
          		'</div>'+
        	'</div>'+
        	'<div style="height:25px"></div>'+
        	'<div class="col-3 cantidadProducto" style="padding-left:0px">'+
          		'<font size="-2">Cantidad</font>'+
          		'<input type="number" class="form-control nuevaCantidadProducto" style="height: 40px" id="nuevaCantidadProducto" min="1" value="1" stock="'+stock+'">'+
        	'</div>'+
            '<div class="col-6 ingresoPrecio" style="padding-left:0px">'+
          		'<font size="-2">Total ($)</font>'+
          		'<div class="input-group">'+
	                '<input type="number" style="'+estilo+'" class="form-control nuevoPrecioProducto '+filtroPropietario+'" tipoPrecio="oferta" onmouseover="$(this).tooltip(\'show\')" onmouseout="$(this).tooltip(\'hide\')" data-original-title="$ '+formatNumber.new(precioFinal)+' c/u" pEditado="'+precioFinal+'" id="nuevoPrecioProducto"  value="'+precioFinal+'" readonly>'+
          		'</div>'+
        	'</div>'+
            '<div class="col-3 ingresoDescuento" style="padding-left:0px">'+
              	'<div>'+
              		'<font size="-2">Descuento</font>'+
                	'<input type="number" style="'+estilo+'" min="0" max="' + datosProd["descuento"] + '" class="form-control descuentoProducto" step="1" value="'+descuentoInput+'" disabled>'+
              	'</div>'+
            '</div>'+
        '</div>'+
        '<div id="esp'+idProd+'" style="height:3px"></div>')

	listarProductos()
	$('#modalVentaMovil').modal('hide');
});

//AGREGANDO PRODUCTOS A LA VENTA DESDE LA TABLA
$(".tablaVentaProductos").on("click", "button.agregarProducto", function() {

	var idProd = $(this).attr("idProducto");
	var datosProd = infoProd(idProd);
	var nroProdComun = $('.prodComunCod').val();
	var sucursal = $('#sucursalActiva').val();
	
	if($(this).hasClass('prodComun')){ // INGRESO PRODUCTO COMUN
		nroProdComun = Number(nroProdComun) + 1;
		$('.prodComunCod').val(nroProdComun);
		$(".nuevoProducto").prepend(
          	'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
            	'<div class="col-12 mb-2 descripcion" style="padding-left:0px">'+
              		'<div>'+
                		'<div>'+
                  			'<button type="button" class="btn btn-danger btn-xs quitarProducto quitarProductoComun" idproducto="prodComun'+nroProdComun+'">'+
                    			'<i class="fa fa-times"></i>'+
                  			'</button>'+
                  			'<font size="-1">   Producto Común</font>'+
                		'</div>'+
              		'</div>'+
            	'</div>'+
				'<input type="" class="form-control nuevaDescripcionProducto descProdComun eliminarCaracteresEspeciales" codigointerno="000000" style="height: 40px" idproducto="'+idProd+'" name="agregarProducto" required placeholder="INGRESE DESCRIPCION DEL PRODUCTO">'+
            	'<div style="height:25px"></div>'+
            	'<div class="col-3 cantidadProducto" style="padding-left:0px">'+
              		'<font size="-2">Cantidad</font>'+
              		'<input type="number" class="form-control nuevaCantidadProducto" style="height: 40px" name="nuevaCantidadProducto" id="nuevaCantidadProducto" value="1" readonly>'+
            	'</div>'+
	            '<div class="col-6 ingresoPrecio" style="padding-left:0px">'+
              		'<font size="-2">Total ($)</font>'+
              		'<div class="input-group">'+
		                '<input type="number" class="form-control nuevoPrecioProducto precioProdComun" pEditado="0" pNormal="1" id="nuevoPrecioProducto" precioCompra="1" value="0" required>'+
              		'</div>'+
            	'</div>'+
	            '<div class="col-3 ingresoDescuento" style="padding-left:0px">'+
	              	'<div>'+
	              		'<font size="-2">Descuento</font>'+
	                	'<input type="number" class="form-control descuentoProducto" value="0" readonly>'+
	              	'</div>'+
	            '</div>'+
	        '</div>'+
	        '<div id="espProdComun'+nroProdComun+'" style="height:3px"></div>')
		listarProductos()
		var cantsProds = JSON.parse($('#listaProductos').val()).length;
		if(cantsProds > 0 && cantsProds == 1){ // bordefinal si hay elementos
			$(".nuevoProducto").append(
			'<div class="col-12" style="border-style: dashed; border-width: 1px; border-right: 1px;border-top: 1px;border-left:1px"></div>')				
		}
		calcularVuelto()
		calcTD()
		calcTC()
		localStorage.removeItem("quitarProducto");
	
	}else if($(this).hasClass('noManejaStock')){ // INGRESO PRODUCTO SIN MANEJO DE STOCK
		$('.nuevoMetodoPago').val(''); // RESET METODO PAGO
		$('.cajasMetodoPago').html(''); // RESET METODO PAGO
		$(this).removeClass("btn-primary agregarProducto");
		$(this).addClass("btn-default");
		$("button[idProd='" + idProd + "']").attr("disabled",'disabled');
		let codigoInterno = Number(datosProd['categoria']) >= 10 ? datosProd["sku"] : '0'+datosProd["sku"];
		descripcionMostrar = '<b>'+datosProd["zona_"+sucursal]+'-'+codigoInterno+'</b> '+datosProd["descripcion"]+' <b>('+formatNumber.new(datosProd["precio_venta"], "$")+'c/u desde '+datosProd["mayor_sobre"]+'u '+formatNumber.new(datosProd["precio_mayor"], "$")+'c/u)</b> [<i>'+datosProd["descuento"]+'%</i>]';
		descuentoInput = Math.round((1 - (datosProd["precio_venta"]/datosProd['precio_venta']))*10000)/100; //CALCULO DE DESCUENTO CON 2 DECIMALES PARA TODOS LOS TIPOS DE CLIENTES

		var readonlyCantidad = "readonly";
		var readonlyPrecio = "";
		var readonlyDcto = "readonly";
		var readonlyDescripcion = "";
		$('#detalleVenta').attr('required', 'required');

		$(".nuevoProducto").prepend(
          	'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
            	'<div class="col-12 descripcion" style="padding-left:0px">'+
              		'<div>'+
                		'<div>'+
                  			'<button type="button" class="btn btn-danger btn-xs quitarProducto" idproducto="'+idProd+'">'+
                    			'<i class="fa fa-times"></i>'+
                  			'</button>'+
                  			'<font size="-1">   '+descripcionMostrar+'</font>'+
                		'</div>'+
                		'<input type="hidden" class="form-control nuevaDescripcionProducto" style="height: 40px" idproducto="'+idProd+'" codigointerno="'+codigoInterno+'" name="agregarProducto" value="'+datosProd["descripcion"]+'" required="" readonly="'+readonlyDescripcion+'">'+
              		'</div>'+
            	'</div>'+
            	'<div style="height:25px"></div>'+
            	'<div class="col-3 cantidadProducto" style="padding-left:0px">'+
              		'<font size="-2">Cantidad</font>'+
              		'<input type="number" class="form-control nuevaCantidadProducto" style="height: 40px" name="nuevaCantidadProducto" id="nuevaCantidadProducto" min="1" value="1" stock="'+datosProd["stock_"+sucursal]+'" mayoreo="'+datosProd["mayor_sobre"]+'" required autofocus '+readonlyCantidad+'>'+
            	'</div>'+
	            '<div class="col-6 ingresoPrecio" style="padding-left:0px">'+
              		'<font size="-2">Total ($)</font>'+
              		'<div class="input-group">'+
		                '<input type="number" style="height: 40px" class="form-control nuevoPrecioProducto" pEditado="'+datosProd["precio_venta"]+'" id="nuevoPrecioProducto" value="'+datosProd["precio_venta"]+'" required '+readonlyPrecio+'>'+
              		'</div>'+
            	'</div>'+
	            '<div class="col-3 ingresoDescuento" style="padding-left:0px">'+
	              	'<div>'+
	              		'<font size="-2">Descuento</font>'+
	                	'<input type="number" style="height: 40px" min="0" max="' + datosProd["descuento"] + '" class="form-control descuentoProducto" step="1" value="'+descuentoInput+'" required ' + readonlyDcto +'>'+
	              	'</div>'+
	            '</div>'+
	        '</div>'+
	        '<div id="esp'+idProd+'" style="height:3px"></div>')
		listarProductos()
		var cantsProds = JSON.parse($('#listaProductos').val()).length;
		if(cantsProds > 0 && cantsProds == 1){ // bordefinal si hay elementos
			$(".nuevoProducto").append(
			'<div class="col-12" style="border-style: dashed; border-width: 1px; border-right: 1px;border-top: 1px;border-left:1px"></div>')				
		}
		calcularVuelto()
		calcTD()
		calcTC()
		localStorage.removeItem("quitarProducto");

	}else{

		$('.nuevoMetodoPago').val(''); // RESET METODO PAGO
		$('.cajasMetodoPago').html(''); // RESET METODO PAGO

		$(this).removeClass("btn-primary agregarProducto");
		$(this).addClass("btn-default");
		$("button[idProd='" + idProd + "']").attr("disabled",'disabled');


		var idCliente = $("#seleccionarCliente option:selected").val();
		var datosCliente = infoCliente(idCliente);
		var tipo_cliente = datosCliente['tipo_cliente'];

		var filtroPropietario = tipo_cliente == 'propietario' ? 'precioProp' : '';


		let codigoInterno = Number(datosProd['categoria']) >= 10 ? datosProd["sku"] : '0'+datosProd["sku"];

		if(tipo_cliente=='minorista'){
			precio = datosProd["precio_venta"];
			estilo = 'height: 40px';
			disabled = '';
			hidden = '';
			descripcionMostrar = '<b>'+datosProd["zona_"+sucursal]+'-'+codigoInterno+'</b> '+datosProd["descripcion"]+' <b>('+formatNumber.new(precio, "$")+'c/u desde '+datosProd['mayor_sobre']+'u '+formatNumber.new(datosProd["precio_mayor"], "$")+'c/u)</b> [<i>'+datosProd["descuento"]+'%</i>]';
		}else if(tipo_cliente=='mayorista'){
			precio = datosProd["precio_mayor"];
			estilo = 'height: 40px;background-color:rgb(169,249,98)';
			disabled = 'disabled';
			hidden = '';
			descripcionMostrar = '<b>'+datosProd["zona_"+sucursal]+'-'+codigoInterno+'</b> '+datosProd["descripcion"]+' <b>('+formatNumber.new(precio, "$")+'c/u desde '+datosProd['mayor_sobre']+'u '+formatNumber.new(datosProd["precio_mayor"], "$")+'c/u)</b> [<i>'+datosProd["descuento"]+'%</i>]';
		}else if(tipo_cliente=='propietario'){
			precio = datosProd["precio_compra"];			
			estilo = 'height: 40px;background-color:rgb(98,249,210)';
			disabled = 'disabled';
			hidden = 'hidden';
			descripcionMostrar = '<b>'+datosProd["zona_"+sucursal]+'-'+codigoInterno+'</b> '+datosProd["descripcion"];
		}

		descuentoInput = Math.round((1 - (precio/(datosProd['precio_venta'])))*10000)/100; //CALCULO DE DESCUENTO CON 2 DECIMALES PARA TODOS LOS TIPOS DE CLIENTES

		// // PERMITE MODIFICAR EL PRECIO CUANDO ES FLETE Y ADEMÁS SOLICITA EL DESTINO EN DETALLE VENTA 
		if(datosProd["maneja_stock"]=='SI' && tipo_cliente=='minorista'){ // PERMITE APLICAR DESCUENTO
			var readonlyCantidad = "";
			var readonlyPrecio = "readonly";
			var readonlyDcto = "";
			var readonlyDescripcion = "readonly";
		}else{ //EL DESCUENTO SE HACE AUTOMATICO PARA PROPIETARIO Y MAYORISTA
			var readonlyCantidad = "";
			var readonlyPrecio = "readonly";
			var readonlyDcto = "readonly";
			var readonlyDescripcion = "readonly";

		}


		$(".nuevoProducto").prepend(
          	'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
            	'<div class="col-12 descripcion" style="padding-left:0px">'+
              		'<div>'+
                		'<div>'+
                  			'<button type="button" class="btn btn-danger btn-xs quitarProducto" idproducto="'+idProd+'">'+
                    			'<i class="fa fa-times"></i>'+
                  			'</button>'+
                  			'<font size="-1">   '+descripcionMostrar+'</font>'+
                		'</div>'+
                		'<input type="hidden" class="form-control nuevaDescripcionProducto" style="height: 40px" idproducto="'+idProd+'" codigointerno="'+codigoInterno+'" name="agregarProducto" value="'+datosProd["descripcion"]+'" required="" readonly="'+readonlyDescripcion+'">'+
              		'</div>'+
            	'</div>'+
            	'<div style="height:25px"></div>'+
            	'<div class="col-3 cantidadProducto" style="padding-left:0px">'+
              		'<font size="-2">Cantidad</font>'+
              		'<input type="number" class="form-control nuevaCantidadProducto" style="height: 40px" name="nuevaCantidadProducto" id="nuevaCantidadProducto" min="1" value="1" stock="'+datosProd["stock_"+sucursal]+'" mayoreo="'+datosProd['mayor_sobre']+'" required autofocus '+readonlyCantidad+'>'+
            	'</div>'+
	            '<div class="col-6 ingresoPrecio '+hidden+'" style="padding-left:0px">'+
              		'<font size="-2">Total ($)</font>'+
              		'<div class="input-group">'+
		                '<input type="number" style="'+estilo+'" class="form-control nuevoPrecioProducto '+filtroPropietario+'" tipoPrecio="normal" onmouseover="$(this).tooltip(\'show\')" onmouseout="$(this).tooltip(\'hide\')" data-original-title="$ '+formatNumber.new(precio)+' c/u" pEditado="0" id="nuevoPrecioProducto" value="'+precio+'" required '+readonlyPrecio+'>'+
              		'</div>'+
            	'</div>'+
	            '<div class="col-3 ingresoDescuento '+hidden+'" style="padding-left:0px">'+
	              	'<div>'+
	              		'<font size="-2">Descuento</font>'+
	                	'<input type="number" style="'+estilo+'" min="0" max="' + datosProd['descuento'] + '" class="form-control descuentoProducto" step="1" value="'+descuentoInput+'" required ' + readonlyDcto + ' '+disabled+'>'+
	              	'</div>'+
	            '</div>'+
	        '</div>'+
	        '<div id="esp'+idProd+'" style="height:3px"></div>')

		listarProductos()

		var cantsProds = JSON.parse($('#listaProductos').val()).length;

		if(cantsProds > 0 && cantsProds == 1){ // bordefinal si hay elementos
			$(".nuevoProducto").append(
			'<div class="col-12" style="border-style: dashed; border-width: 1px; border-right: 1px;border-top: 1px;border-left:1px"></div>')				
		}

		calcularVuelto()
		calcTD()
		calcTC()
		localStorage.removeItem("quitarProducto");

		$('div.dataTables_filter input').select();
	}

});

// CAMBIO CANTIDAD DESDE PC
$(".formularioVenta").on("change", "input.nuevaCantidadProducto", function() {
	
	var idCliente = $("#seleccionarCliente option:selected").val();
	var datosCliente = infoCliente(idCliente);
	var tipoCliente = datosCliente['tipo_cliente'];


	var precio = $(this).parent().parent().children(".ingresoPrecio").children().children(".nuevoPrecioProducto");
	var idProd = $(this).parent().parent().children(".descripcion").children().children(".nuevaDescripcionProducto").attr('idProducto');
	var descuento = $(this).parent().parent().children(".ingresoDescuento").children().children(".descuentoProducto");
	var sucursal = $('#sucursalActiva').val();

	var datosProd = infoProd(idProd);
	$('.nuevoMetodoPago').val(''); // RESET METODO PAGO
	$('.cajasMetodoPago').html(''); // RESET METODO PAGO

	// FILTRO CANTIDAD
	if(Number($(this).val()) > Number(datosProd['stock_'+sucursal])){ // si se quiere comprar mas de lo que hay en
		Swal.fire({
		  	icon: "error",
		  	title: "Solo quedan "+datosProd['stock_'+sucursal]+"u",
		  	showConfirmButton: true,
		  	confirmButtonText: "Cerrar"
		  	}).then(function(result){
				if(result.value) {
					$('#nuevaCantidadProducto').select();
				}
			})
		$(this).val(datosProd['stock_'+sucursal]);
	}else if(Number($(this).val()) <= 0){ //si cant <= 0
		$(this).val(1);
	}

	var verde = 'rgb(169,249,98)';
	var celeste = 'rgb(98,249,210)';


	if(tipoCliente == 'minorista'){
		if(precio.attr('tipoPrecio') == 'unico'){
			precioFinal = $(this).val() * precio.attr('pEditado');
		}else if(precio.attr('tipoPrecio') == 'oferta'){
			precioFinal = $(this).val() * datosProd['precio_mayor'];
		}else if(precio.attr('tipoPrecio') == 'normal'){
			if(Number($(this).val()) >= Number(datosProd['mayor_sobre'])){
				precioFinal = $(this).val() * datosProd['precio_mayor'];
				calculoDcto = (Math.round((1-(Number(precioFinal/$(this).val())/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
				dcto = calculoDcto < 0 ? 0 : calculoDcto;
				descuento.val(dcto);
				descuento.attr('disabled', 'disabled').attr('style', 'height: 40px;background-color:'+verde);	
				precio.attr('style', 'height: 40px;background-color:'+verde);
			}else{
				precioFinal = $(this).val() * datosProd['precio_venta'];			
				descuento.val(0);
				descuento.removeAttr('disabled');	
				descuento.attr('style', 'height: 40px;');	
				precio.attr('style', 'height: 40px;');	
			}
		}
	}else if(tipoCliente == 'propietario'){
		precioFinal = $(this).val() * datosProd['precio_compra'];
		descuento.attr('disabled', 'disabled').attr('style', 'height: 40px;background-color:'+celeste);	
		precio.attr('style', 'height: 40px;background-color:'+celeste);
	}else if(tipoCliente == 'mayorista'){
		if(precio.attr('tipoPrecio') == 'unico'){
			precioFinal = $(this).val() * precio.attr('pEditado');
		}else if(precio.attr('tipoPrecio') == 'oferta' || precio.attr('tipoPrecio') == 'normal'){
			precioFinal = $(this).val() * datosProd['precio_mayor'];
		}
		descuento.attr('disabled', 'disabled').attr('style', 'height: 40px;background-color:'+verde);	
		precio.attr('style', 'height: 40px;background-color:'+verde);
	}

	precio.val(Math.round(precioFinal));
	listarProductos()
	calcularVuelto()
	calcTD()
	calcTC()
})


// LIMITACIONES Y PERMISOS PARA CLIENTES
$("#seleccionarCliente").change(function(){

	var perfil = $('#perfilVend').val();
	var idCliente = $(this).val();
	var datosCliente = infoCliente(idCliente);

	$('.rutFacturarCliente').val(datosCliente['rut_facturar']);
	
	// PERMISOS CREDITO INTERNO, LIMITE COMPRAS, INFORME DEUDAS
	var limiteNormal = Math.round((Number(datosCliente['limite'])-Number(datosCliente['deuda_cliente'])));

	if(perfil == 'Administrador' && datosCliente['tipo_cliente'] != 'propietario'){ // DETECTA CLIENTE QUE NO SEA PROPIETARIO CON CREDITO INTERNO ACTIVO Y HABILITA LA OPCION
		if(datosCliente['id'] != 1){
			if(datosCliente['credito_interno'] == 0){// CI BLOQUEADO
				if(datosCliente['deuda_cliente'] > 0){// CON DEUDA
					opcCI = '<option class="bg-danger" value="Fiado">Crédito Interno</option>';				
				}else if(datosCliente['deuda_cliente'] < 0){ // SALDO A FAVOR
					opcCI = '<option class="bg-success" value="Fiado">Crédito Interno</option>';
				}else{// SIN CREDITO INTERNO ASIGNADO Y SIN DEUDA
					opcCI = '<option class="bg-navy" value="Fiado">Crédito Interno</option>';
				}
			}else if(datosCliente['credito_interno'] == 2 && datosCliente['deuda_cliente'] > 0){ // CI SUSPENDIDO Y CON DEUDA
				opcCI = '<option class="bg-warning" value="Fiado">Crédito Interno</option>';
    		}else if(datosCliente['credito_interno'] == 1 ){ // CI ACTIVO
				opcCI = '<option class="bg-success" value="Fiado">Crédito Interno</option>';
    		}

			$("#nuevoMetodoPago").html( // OPCIONES DE PAGO
				'<option value="">Método</option>'+
                '<option value="Efectivo">Efectivo</option>'+
                '<option value="Transferencia">Transferencia</option>'+
                '<option value="TC">Tarjeta Crédito</option>'+
                '<option value="TD">Tarjeta Débito</option>'+
                '<option value="E_TD">Efectivo + TD</option>'+
                '<option value="E_TC">Efectivo + TC</option>'+
                opcCI+
                '<option value="Pend">Pendiente</option>'
			);
		}else{ // cliente base 
			$("#nuevoMetodoPago").html( // OPCIONES DE PAGO
				'<option value="">Método</option>'+
                '<option value="Efectivo">Efectivo</option>'+
                '<option value="Transferencia">Transferencia</option>'+
                '<option value="TC">Tarjeta Crédito</option>'+
                '<option value="TD">Tarjeta Débito</option>'+
                '<option value="E_TD">Efectivo + TD</option>'+
                '<option value="E_TC">Efectivo + TC</option>'+
                '<option value="Pend">Pendiente</option>'
			);
		}

	}else if(datosCliente['credito_interno']==1 && datosCliente['tipo_cliente']!='propietario'){ // DETECTA CLIENTE QUE NO SEA PROPIETARIO CON CREDITO INTERNO ACTIVO Y HABILITA LA OPCION
		if(Number(limiteNormal) <= 0){
			var opcionCreditoInterno = '<option value="Fiado" disabled>Crédito Interno</option>';
		}else{
			var opcionCreditoInterno = '<option value="Fiado" class="bg-success">Crédito Interno</option>';
		}
		$("#nuevoMetodoPago").html( // OPCIONES DE PAGO
			'<option value="">Método</option>'+
            '<option value="Efectivo">Efectivo</option>'+
            '<option value="Transferencia">Transferencia</option>'+
            '<option value="TC">Tarjeta Crédito</option>'+
            '<option value="TD">Tarjeta Débito</option>'+
            '<option value="E_TD">Efectivo + TD</option>'+
            '<option value="E_TC">Efectivo + TC</option>'+
            opcionCreditoInterno+
            '<option value="Pend">Pendiente</option>'
		);

	}else if(datosCliente['tipo_cliente']=='propietario'){ // DETECTA PROPIETARIO
		$("#nuevoMetodoPago").html( // OPCIONES DE PAGO
			'<option value="">Método</option>'+
            '<option value="Fiado">Crédito Interno</option>'
		);
		
	}else if((datosCliente['credito_interno'] == 0 || datosCliente['credito_interno'] == 2) && datosCliente['deuda_cliente']<0){ // PERMITE CREDITO INTERNO AUTOMATICO SI LA CUENTA ESTA CON SALDO A FAVOR, LIMITE HASTA LLEGAR A CERO   /////////////////////////////LISTO
		$("#nuevoMetodoPago").html( // OPCIONES DE PAGO
			'<option value="">Método</option>'+
            '<option value="Efectivo">Efectivo</option>'+
            '<option value="Transferencia">Transferencia</option>'+
            '<option value="TC">Tarjeta Crédito</option>'+
            '<option value="TD">Tarjeta Débito</option>'+
            '<option value="E_TD">Efectivo + TD</option>'+
            '<option value="E_TC">Efectivo + TC</option>'+
            '<option value="Fiado" class="bg-success">Crédito Interno</option>'+
            '<option value="Pend">Pendiente</option>'
		);

	}else{ // CLIENTES SIN CREDITO ASIGNADO
		$("#nuevoMetodoPago").html( // OPCIONES DE PAGO
			'<option value="">Método</option>'+
            '<option value="Efectivo">Efectivo</option>'+
            '<option value="Transferencia">Transferencia</option>'+
            '<option value="TC">Tarjeta Crédito</option>'+
            '<option value="TD">Tarjeta Débito</option>'+
            '<option value="E_TD">Efectivo + TD</option>'+
            '<option value="E_TC">Efectivo + TC</option>'+
            '<option value="Pend">Pendiente</option>'
		);				
	
	}

	$('.cajasMetodoPago').html('');
	filtroPrecios(idCliente);
})

function filtroPrecios(idCliente){ // ORIGEN SIRVE PARA FILTRAR SI SE MUESTRA TIPOS DE PAGOS HABILITADOS
	// CAMBIO DE PRECIOS SEGUN TIPO DE CLIENTE SE EJECUTA CUANDO SE CAMBIA EL CLIENTE
  	var productos = JSON.parse($('#listaProductos').val());
	var precio = $(".nuevoPrecioProducto");
	var descripcion = $(".nuevaDescripcionProducto");
	var cant = $(".nuevaCantidadProducto");
	var descuento = $(".descuentoProducto");
	var cajaPrecio = $(".ingresoPrecio");
	var cajaDcto = $(".ingresoDescuento");
	var total = 0;
	var totalNormal = 0;
	var perfil = $('#perfilVend').val();
	var verde = 'rgb(169,249,98)';
	var gris = 'rgb(238,238,238)';
	var celeste = 'rgb(98,249,210)';
	var datosCliente = infoCliente(idCliente);

	if(datosCliente['tipo_cliente'] == "mayorista" && datosCliente['credito_interno']==1){ // RESPETO DE PRECIOS MAYORISTAS CON CREDITO INTERNO

		descuento.attr('style','height: 40px;background-color:'+verde).attr('disabled','disabled');
	    $(productos).each(function (i){
			var idProd = $(descripcion[i]).attr("idProducto");
			var datosProd = infoProd(idProd);

			$('.divTotalMostrarVenta').removeClass('d-none');// MUESTRA TOTAL en crear venta
			$(cajaPrecio[i]).removeClass('d-none');//MUESTRA CAJAS
			$(cajaDcto[i]).removeClass('d-none');//MUESTRA CAJAS
			$(precio[i]).attr('style','height: 40px;background-color:'+verde); // MODIFICACION ESTILO

			/*------------------------------------------------------------------------------------------------*/
			// FILTRO PRECIO PROPIETARIO PARA QUE NO QUEDE SETEADO CUANDO SE CAMBIA DE CLIENTE
			if($(precio[i]).hasClass('precioProp')){	
				$(precio[i]).removeClass('precioProp');
				if($(precio[i]).attr('tipoPrecio') == 'unico' || $(precio[i]).attr('tipoPrecio') == 'oferta'){
					$(precio[i]).attr('pEditado',datosProd['precio_mayor']);
				}else{
					$(precio[i]).attr('pEditado',0);
				}
			}
			/*------------------------------------------------------------------------------------------------*/

			if(datosProd['maneja_stock']=='NO' || $(precio[i]).attr('tipoPrecio') == 'unico' || $(precio[i]).attr('tipoPrecio') == 'oferta'){
				$(precio[i]).val($(cant[i]).val()*$(precio[i]).attr('pEditado')); // MODIFICACION PRECIO
				calculoDcto = (Math.round((1-(Number($(precio[i]).attr('pEditado'))/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
			}else{
				$(precio[i]).val($(cant[i]).val()*datosProd['precio_mayor']); // MODIFICACION PRECIO
				calculoDcto = (Math.round((1-(Number(datosProd['precio_mayor'])/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
			}
			dcto = calculoDcto < 0 ? 0 : calculoDcto; // SI DCTO ES MENOR A CERO SE PONE CERO SI NO EL DCTO QUE PERTENECE
			$(descuento[i]).val(dcto); // DESCUENTO A CADA CAJA
			total = Number(total) + Number($(precio[i]).val());
			totalNormal = Number(totalNormal) + Number($(cant[i]).val())*Number(datosProd['precio_venta']);
			listarProductos();

			// TIPOS DE PAGOS DISPONIBLES PARA CLIENTE y CUPO
			var limiteNormal = Math.round((Number(datosCliente['limite'])-Number(datosCliente['deuda_cliente'])));

			if(Number(datosCliente['respetar_p_mayor']) == 1){ // PRECIO CREDITO INTERNO SI SE RESPETA PRECIO
				if(Number(limiteNormal) <= 0){
					var limiteMostrar = 'SIN CUPO';
					var tiposDePago = 'SOLO PAGOS INMEDIATOS';
				}else{
					var limiteMostrar = formatNumber.new(limiteNormal, "$ ");	
					var tiposDePago = 'TODO MÉTODO DE PAGO';
				}
				pagosDisponibles =	"<table><tbody><tr><td>                           </td><td><h2><b>Pagos Disponibles</b></h2></td></tr></tbody></table>"+
						"<table>"+					
							"<tbody>"+
								"<tr><td>               </td></tr>"+
								"<tr><td>               </td></tr>"+
								"<tr>"+
									"<td>                       </td>"+
									"<td style='text-align:left'><h5><b>"+tiposDePago+"</b></h5></td>"+
									"<td>  </td>"+
									"<td><h5><b>: "+formatNumber.new(total, "$ ")+"</b></h5></td>"+
								"</tr>"+
								"<tr><td>               </td></tr>"+
								"<tr>"+
									"<td></td>"+
									"<td style='text-align:center;color:blue'><h4>Cupo Disponible</h4></td>"+
									"<td></td>"+
									"<td style='color:blue'><h4><b>: "+limiteMostrar+"</b></h4></td>"+
								"</tr>"+
							"</tbody"+
						"</table>";
			}else if(Number(datosCliente['respetar_p_mayor']) == 0){
				if(Number(limiteNormal) <= 0){
					var limiteMostrar = 'SIN CUPO';
					var pagoCreditoInterno = '';
				}else{
					var limiteMostrar = formatNumber.new(limiteNormal, "$ ");	
					var pagoCreditoInterno = "<tr>"+
												"<td> </td>"+
												"<td style='text-align:left;color:red'><h5><b>Crédito Interno:<br>(Precios NORMALES)</b></h5></td>"+
												"<td>  </td>"+
												"<td style='color:red'><h5><b>: "+formatNumber.new(totalNormal, "$ ")+"</b></h5></td>"+
											"</tr>";
				}
				pagosDisponibles =	"<table><tbody><tr><td>                               </td><td><h2><b>Pagos Disponibles</b></h2></td></tr></tbody></table>"+
						"<table>"+					
							"<tbody>"+
								"<tr><td> </td></tr>"+
								"<tr><td> </td></tr>"+
								"<tr>"+
									"<td>                              </td>"+
									"<td style='text-align:left'><h5><b>Pagos Inmediatos</b></h5></td>"+
									"<td>  </td>"+
									"<td><h5><b>: "+formatNumber.new(total, "$ ")+"</b></h5></td>"+
								"</tr>"+
								pagoCreditoInterno+
								"<tr>"+
									"<td>                    </td>"+
								"</tr>"+
								"<tr>"+
									"<td>                    </td>"+
									"<td style='text-align:center;color:blue'><h4>Cupo Disponible</h4></td>"+
									"<td></td>"+
									"<td style='color:blue'><h4><b>: "+limiteMostrar+"</b></h4></td>"+
								"</tr>"+
							"</tbody"+
						"</table>";
				
			}
			Swal.fire({icon: "info", html: pagosDisponibles, showConfirmButton: true, confirmButtonText: "Ok"})
	    });

	}else if(datosCliente['tipo_cliente'] == 'mayorista' && (datosCliente['credito_interno']==0 ||datosCliente['credito_interno']==2)){ // RESPETO DE PRECIOS MAYORISTAS SIN CREDITO INTERNO (SOLO COMPRAS CON PAGO INSTANTANEO)

		descuento.attr('style','height: 40px;background-color:'+verde); // MODIFICACION ESTILO
		descuento.attr('disabled','disabled'); // BLOQUEO DCTO
	    $(productos).each(function (i){
			var idProd = $(descripcion[i]).attr("idProducto");
			var datosProd = infoProd(idProd);
			$('.divTotalMostrarVenta').removeClass('d-none');// MUESTRA TOTAL en crear venta
			$(cajaPrecio[i]).removeClass('d-none');//MUESTRA CAJAS
			$(cajaDcto[i]).removeClass('d-none');//MUESTRA CAJAS
			$(precio[i]).attr('style','height: 40px;background-color:'+verde); // MODIFICACION ESTILO


			/*------------------------------------------------------------------------------------------------*/
			// FILTRO PRECIO PROPIETARIO PARA QUE NO QUEDE SETEADO CUANDO SE CAMBIA DE CLIENTE
			if($(precio[i]).hasClass('precioProp')){	
				$(precio[i]).removeClass('precioProp');
				if($(precio[i]).attr('tipoPrecio') == 'unico' || $(precio[i]).attr('tipoPrecio') == 'oferta'){
					$(precio[i]).attr('pEditado',datosProd['precio_mayor']);
				}else{
					$(precio[i]).attr('pEditado',0);
				}
			}
			/*------------------------------------------------------------------------------------------------*/


			if(datosProd['maneja_stock']=='NO' || $(precio[i]).attr('tipoPrecio') == 'unico' || $(precio[i]).attr('tipoPrecio') == 'oferta'){
				$(precio[i]).val($(cant[i]).val()*$(precio[i]).attr('pEditado')); // MODIFICACION PRECIO
				calculoDcto = (Math.round((1-(Number($(precio[i]).attr('pEditado'))/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
			}else{
				$(precio[i]).val($(cant[i]).val()*datosProd['precio_mayor']); // MODIFICACION PRECIO
				calculoDcto = (Math.round((1-(Number(datosProd['precio_mayor'])/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
			}
			dcto = calculoDcto < 0 ? 0 : calculoDcto; // SI DCTO ES MENOR A CERO SE PONE CERO SI NO EL DCTO QUE PERTENECE
			$(descuento[i]).val(dcto); // DESCUENTO A CADA CAJA
			total = Number(total) + Number($(precio[i]).val());
			totalNormal = Number(totalNormal) + Number($(cant[i]).val())*Number(infoProd['precio_venta']);
			listarProductos();
	    });

		if(datosCliente['deuda_cliente'] > 0){// CON DEUDA
			let tipoBloqueo  = datosCliente['credito_interno']==0 ? 'Bloqueado' : 'Suspendido';
			Swal.fire({
			  	icon: 'error',
			  	html: '<b>CI '+tipoBloqueo+'</b><br>ADEUDA: <b>'+formatNumber.new(datosCliente['deuda_cliente'],'$')+'</b>',
			  	footer: '<a href="extensiones/tcpdf/pdf/historial-cliente-resumen.php?id='+datosCliente['id']+'" target="_blank">Ver Deuda</a>'
			})
		}else if(datosCliente['deuda_cliente'] < 0){ // SALDO A FAVOR
			saldoFavor = "<table><tbody><tr><td>       </td><td><h2><b>CLIENTE CON SALDO A FAVOR</b></h2></td></tr></tbody></table>"+
							"<table>"+					
								"<tbody>"+
									"<tr>"+
										"<td>                    </td>"+
										"<td style='text-align:center;color:blue'>Crédito Interno Disponible:</td>"+
										"<td>  </td>"+
										"<td style='color:blue'>"+formatNumber.new(-datosCliente['deuda_cliente'], "$ ")+"</td>"+
									"</tr>"+
								"</tbody"+
							"</table>";
			Swal.fire({
			  	icon: 'success',
			  	html: saldoFavor
			})
		}

	}else if(datosCliente['tipo_cliente'] == 'propietario'){ // CAMBIO DE PRECIOS SIN UTILIDAD SIEMPRE QUE EL CLIENTE SEA PROPIETARIO

		if(perfil == 'Administrador'){
			$('.divTotalMostrarVenta').removeClass('d-none');// MUESTRA TOTAL en editar venta								
			cajaPrecio.removeClass('d-none'); //OCULTA CAJAS PARA NO VER PRECIO PROPIETARIO
			cajaDcto.removeClass('d-none');	//OCULTA CAJAS PARA NO VER PRECIO PROPIETARIO							
		}else{
			$('.divTotalMostrarVenta').addClass('d-none');// MUESTRA TOTAL en editar venta
			cajaPrecio.addClass('d-none'); //OCULTA CAJAS PARA NO VER PRECIO PROPIETARIO
			cajaDcto.addClass('d-none');	//OCULTA CAJAS PARA NO VER PRECIO PROPIETARIO							
		}

	    $(productos).each(function (i){
			var datosProd = infoProd($(descripcion[i]).attr("idProducto"));
			$(precio[i]).attr('style','height: 40px;background-color:'+celeste); // MODIFICACION ESTILO
			$(precio[i]).val($(cant[i]).val()*datosProd['precio_compra']); // MODIFICACION ATRIBUTO
			$(descuento[i]).attr('style','height: 40px;background-color:'+celeste); // MODIFICACION ESTILO
			$(descuento[i]).attr('disabled','disabled'); // BLOQUEO DCTO
			dcto = (Math.round((1-(Number(datosProd['precio_compra'])/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
			$(descuento[i]).val(dcto);
			total = Number(total) + Number($(precio[i]).val());
			totalNormal = Number(totalNormal) + Number($(cant[i]).val())*Number(datosProd['precio_venta']);
			listarProductos();
	    });

	}else{ // MINORISTAS


		$(productos).each(function (i){
			var datosProd = infoProd($(descripcion[i]).attr("idProducto"));
			$('.divTotalMostrarVenta').removeClass('d-none');// MUESTRA TOTAL en crear venta
			$(cajaPrecio[i]).removeClass('d-none');//MUESTRA CAJAS
			$(cajaDcto[i]).removeClass('d-none');//MUESTRA CAJAS

			/*------------------------------------------------------------------------------------------------*/
			// FILTRO PRECIO PROPIETARIO PARA QUE NO QUEDE SETEADO CUANDO SE CAMBIA DE CLIENTE
			if($(precio[i]).hasClass('precioProp')){	
				$(precio[i]).removeClass('precioProp');
				if($(precio[i]).attr('tipoPrecio') == 'unico' || $(precio[i]).attr('tipoPrecio') == 'oferta'){
					$(precio[i]).attr('pEditado',datosProd['precio_mayor']);
				}else{
					$(precio[i]).attr('pEditado',0);
				}
			}
			/*------------------------------------------------------------------------------------------------*/
			
			if($(precio[i]).attr('tipoPrecio') == 'normal'){
				if(Number($(cant[i]).val()) >= Number(datosProd['mayor_sobre'])){ // si cant >= mayoreo
					precioCalculado = Math.round($(cant[i]).val()*datosProd['precio_mayor']);
					dcto = (Math.round((1-(Number(datosProd['precio_mayor'])/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
					$(precio[i]).attr('style','height: 40px;background-color:'+verde); // MODIFICACION ESTILO
					$(descuento[i]).attr('style','height: 40px;background-color:'+verde); // MODIFICACION ESTILO
				}else{
					precioCalculado = Math.round($(cant[i]).val()*datosProd['precio_venta']);
					dcto = 0; 
					$(precio[i]).attr('style','height: 40px;background-color:'+gris); // MODIFICACION ESTILO
					$(descuento[i]).attr('style','height: 40px;'); // MODIFICACION ESTILO
				}

			}else{
				precioCalculado = Math.round($(cant[i]).val()*$(precio[i]).attr('pEditado')); // MODIFICACION ATRIBUTO
				calculoDcto = (Math.round((1-(Number($(precio[i]).attr('pEditado'))/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
				dcto = calculoDcto < 0 ? 0 : calculoDcto; // SI DCTO ES MENOR A CERO SE PONE CERO SI NO EL DCTO QUE PERTENECE
				$(precio[i]).attr('style','height: 40px;background-color:'+celeste); // MODIFICACION ESTILO
				$(descuento[i]).attr('style','height: 40px;background-color:'+celeste); // MODIFICACION ESTILO
			}
			$(descuento[i]).val(dcto);
			$(precio[i]).val(precioCalculado);							
			total = Number(total) + Number($(precio[i]).val());
			
			if(datosProd['maneja_stock'] == 'SI'){
				totalNormal = Number(totalNormal) + Number($(cant[i]).val())*Number(datosProd['precio_venta']);
			}else{
				totalNormal = Number(totalNormal) + Number($(cant[i]).val())*Number($(precio[i]).attr('pEditado'));
			}

			listarProductos();

			
			if(datosCliente['deuda_cliente'] < 0 && datosCliente['credito_interno']!=1){ // SALDO A FAVOR
				pagosDisponibles =	"<table><tbody><tr><td>              </td><td><h3><b>CLIENTE CON SALDO A FAVOR</b></h3></td></tr></tbody></table>"+
									"<table>"+					
										"<tbody>"+
											"<tr><td> </td></tr>"+
											"<tr>"+
												"<td>                    </td>"+
												"<td style='text-align:center;color:blue'><h5>Crédito Interno Disponible:</h5></td>"+
												"<td>  </td>"+
												"<td style='color:blue'><h5><b>"+formatNumber.new(-datosCliente['deuda_cliente'], "$ ")+"</b></h5></td>"+
											"</tr>"+
										"</tbody"+
									"</table>";
				Swal.fire({icon: "info", html: pagosDisponibles, showConfirmButton: true, confirmButtonText: "Ok"})
			}else if(datosCliente['credito_interno']==1){ // SOLO SI EL CLIENTE TIENE ASIGNADO CREDITO INTERNO
				// TIPOS DE PAGOS DISPONIBLES PARA CLIENTE y CUPO
				var limiteNormal = Math.round((Number(datosCliente['limite'])-Number(datosCliente['deuda_cliente'])));
				if(Number(limiteNormal) <= 0){
					var limiteMostrar = 'SIN CUPO';
					var pagoCreditoInterno = '';
				}else{
					var limiteMostrar = formatNumber.new(limiteNormal, "$ ");	
					var pagoCreditoInterno= "<tr>"+
												"<td>                    </td>"+
														"<td style='text-align:left;color:green'>Crédito Interno:</td>"+
												"<td>  </td>"+
												"<td style='color:green'>"+formatNumber.new(totalNormal, "$ ")+"</td>"+
											"</tr>";
				}

				pagosDisponibles =	"<table><tbody><tr><td>                               </td><td><h2><b>Pagos Disponibles</b></h2></td></tr></tbody></table>"+
						"<table>"+					
							"<tbody>"+
								"<tr><td> </td></tr>"+
								"<tr><td> </td></tr>"+
								"<tr>"+
									"<td>                              </td>"+
									"<td style='text-align:left'><h5><b>Pagos Inmediatos</b></h5></td>"+
									"<td>  </td>"+
									"<td><h5><b>: "+formatNumber.new(total, "$ ")+"</b></h5></td>"+
								"</tr>"+
								pagoCreditoInterno+
								"<tr>"+
									"<td>                    </td>"+
								"</tr>"+
								"<tr>"+
									"<td>                    </td>"+
									"<td style='text-align:center;color:blue'><h4>Cupo Disponible</h4></td>"+
									"<td></td>"+
									"<td style='color:blue'><h4><b>: "+limiteMostrar+"</b></h4></td>"+
								"</tr>"+
							"</tbody"+
						"</table>";

				Swal.fire({icon: "info", html: pagosDisponibles, showConfirmButton: true, confirmButtonText: "Ok"})
			}
    	});		

	}
}


// CAMBIOS MÉTODO DE PAGO
$("#nuevoMetodoPago").change(function(){
	var metodo = $(this).val();
	var total = $("#totalVenta").val();
	var totalNormal = $("#totalVentaNormal").val();
	var perfil = $('#perfilVend').val();

	var idCliente = $("#seleccionarCliente option:selected").val();
	var datosCliente = infoCliente(idCliente);
	var tipoCliente = datosCliente['tipo_cliente'];

	var productos = JSON.parse($('#listaProductos').val());

	var descripcion = $(".nuevaDescripcionProducto");
	var cant = $(".nuevaCantidadProducto");
	var descuento = $(".descuentoProducto");
	var cajaPrecio = $(".ingresoPrecio");
	var cajaDcto = $(".ingresoDescuento");		
	var precio = $(".nuevoPrecioProducto");
	var verde = 'rgb(169,249,98)';
	var gris = 'rgb(238,238,238)';
	var celeste = 'rgb(98,249,210)';

	var factorSobrelimite = ((datosCliente['credito_interno'] == 0 || datosCliente['credito_interno'] == 2) && datosCliente['deuda_cliente']<0) ? 1 : 1.1; // 0 o 10% de sobrelimite si cliente tiene saldo a favor = 0, si tiene credito interno el limite+10%
	var limiteNormal = Math.round((Number(datosCliente['limite'])-Number(datosCliente['deuda_cliente'])));
	var limite = Math.round((Number(datosCliente['limite'])-Number(datosCliente['deuda_cliente']))*factorSobrelimite);
	
	if(metodo == "Fiado"){// PAGO FIADO CUALQUIER CLIENTE
				
		if(tipoCliente == 'propietario'){// FILTRO PARA OCULTAR PRECIO DE VENTA CUANDO ES VENDEDOR Y SE VENDE A PROPIETARIO
			$('.cajasMetodoPago').html(
	            '<div class="col-6">'+
	              	'<div class="mb-2"></div>'+
	          		'<div class="form-group">'+
	            		'<label>Crédito Interno</label>'+
						'<input type="text" class="form-control creditoInterno" id="creditoInterno" name="creditoInterno" value="' + total + '" required disabled>' +
	          		'</div>'+
	            '</div>')
			$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA

		}else{// VENTA CON CREDITO INTERNO A CLIENTE NO PROPIETARIO

			if(perfil == 'Vendedor'){
				if(datosCliente['respetar_p_mayor']==1){ // SE RESPETA PRECIO MAYOR
					$(productos).each(function(i){
						var datosProd = infoProd($(descripcion[i]).attr("idProducto"));
						$('.divTotalMostrarVenta').removeClass('d-none');// MUESTRA TOTAL en crear venta
						$(cajaPrecio[i]).removeClass('d-none');//MUESTRA CAJAS
						$(cajaDcto[i]).removeClass('d-none');//MUESTRA CAJAS


						if(datosProd['maneja_stock']=='NO'){
							if($(precio[i]).attr('pEditado')>=datosProd['precio_venta']){
								calculoDcto = 0;
							}else{
								calculoDcto = (Math.round((1-(Number($(precio[i]).attr('pEditado'))/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales											
							}
							precioCalculado = Math.round($(precio[i]).attr('pEditado'));
						}else{
							calculoDcto = (Math.round((1-(Number(datosProd['precio_mayor'])/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
							precioCalculado = Math.round($(cant[i]).val()*datosProd['precio_mayor']);
						}

						$(descuento[i]).attr('disabled','disabled');
						$(descuento[i]).attr('style','height: 40px;background-color:'+verde); // MODIFICACION ESTILO
						$(descuento[i]).val(calculoDcto);
						$(precio[i]).attr('readonly','readonly');
						$(precio[i]).attr('style','height: 40px;background-color:'+verde); // MODIFICACION ESTILO

						$(precio[i]).val(precioCalculado);	
						listarProductos();
					})

					// TOTAL CAJA CREDITO INTERNO
					$('.cajasMetodoPago').html(
	                    '<div class="col-6">'+
	                      	'<div class="mb-2"></div>'+
	                  		'<div class="form-group">'+
	                    		'<label>Crédito Interno</label>'+
								'<input type="text" class="form-control creditoInterno" id="creditoInterno" name="creditoInterno" value="' + total + '" required disabled>' +
	                  		'</div>'+
	                    '</div>')

					if(Number(total)>limite){// SI COMPRA SUPERA LIMITE
						$('#ingresarVenta').attr('disabled','disabled'); // DESACTIVA REGISTRAR VENTA
						Swal.fire({
							icon: "error",
							title: '<b>SUPERA LÍMITE DE CRÉDITO</b>',
							html: "Cupo permitido "+formatNumber.new(limiteNormal,'$')+"<br>Monto máximo por única vez es de <b>"+formatNumber.new(limite,'$')+"</b>",
							showConfirmButton: true,
							confirmButtonText: "Ok"
						})
					}else{
						$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA
					}
					actualizarTotales(total,totalNormal);

				}else{ // NO SE RESPETA PRECIO MAYOR

					var totalMostrar = 0;
					// PRECIOS DE PRODUCTOS A PRECIO NORMAL PARA CLIENTES QUE NO SE RESPETA PRECIO MAYOR EN CREDITO INTERNO
					$(productos).each(function(i){
						var datosProd = infoProd($(descripcion[i]).attr("idProducto"));
						$('.divTotalMostrarVenta').removeClass('d-none');// MUESTRA TOTAL en crear venta
						$(cajaPrecio[i]).removeClass('d-none');//MUESTRA CAJAS
						$(cajaDcto[i]).removeClass('d-none');//MUESTRA CAJAS


						if(datosProd['maneja_stock']=='NO'){
							if($(precio[i]).attr('pEditado')>=datosProd['precio_venta']){
								calculoDcto = 0;
							}else{
								calculoDcto = (Math.round((1-(Number($(precio[i]).attr('pEditado'))/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales											
							}
							precioCalculado = Math.round($(precio[i]).attr('pEditado'));
						}else{
							calculoDcto = (Math.round((1-(Number($(precio[i]).attr('precio_venta'))/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
							precioCalculado = Math.round($(cant[i]).val()*datosProd['precio_venta']);
						}

						$(descuento[i]).attr('disabled','disabled');
						$(descuento[i]).attr('style','height: 40px;background-color:'+gris); // MODIFICACION ESTILO
						$(descuento[i]).val(0);

						$(precio[i]).attr('readonly','readonly');
						$(precio[i]).attr('style','height: 40px;background-color:'+gris); // MODIFICACION ESTILO
						$(precio[i]).val(precioCalculado);
						totalMostrar = Number(totalMostrar) + Number(precioCalculado);
						listarProductos();
						actualizarTotalCreditoInterno(totalMostrar,perfil,limiteNormal,limite);
					})
				}
			}else if(perfil = 'Administrador'){

				var totalMostrar = 0;
				// PRECIOS DE PRODUCTOS A PRECIO NORMAL PARA CLIENTES QUE NO SE RESPETA PRECIO MAYOR EN CREDITO INTERNO
				$(productos).each(function(i){
					var datosProd = infoProd($(descripcion[i]).attr("idProducto"));
					$('.divTotalMostrarVenta').removeClass('d-none');// MUESTRA TOTAL en crear venta
					$(cajaPrecio[i]).removeClass('d-none');//MUESTRA CAJAS
					$(cajaDcto[i]).removeClass('d-none');//MUESTRA CAJAS


					if(datosProd['maneja_stock']=='NO'){
						if($(precio[i]).attr('pEditado')>=datosProd['precio_venta']){
							calculoDcto = 0;
						}else{
							calculoDcto = (Math.round((1-(Number($(precio[i]).attr('pEditado'))/Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
						}
						precioCalculado = Math.round($(precio[i]).attr('pEditado'));
					}else if(datosProd['maneja_stock']=='SI'){
						calculoDcto = (Math.round((1-( (Number($(precio[i]).val())/$(cant[i]).val()) / Number(datosProd['precio_venta'])))*10000))/100; //dcto con 2 decimales
						precioCalculado = Math.round(Number($(precio[i]).val()));
					}

					$(descuento[i]).val(calculoDcto);
					
					let colorInput = Number(calculoDcto) > 0 ? verde : gris;

					$(descuento[i]).attr('disabled','disabled');
					$(descuento[i]).attr('style','height: 40px;background-color:'+colorInput); // MODIFICACION ESTILO

					$(precio[i]).attr('readonly','readonly');
					$(precio[i]).attr('style','height: 40px;background-color:'+colorInput); // MODIFICACION ESTILO
					$(precio[i]).val(precioCalculado);
					totalMostrar = Number(totalMostrar) + Number(precioCalculado);
					listarProductos();
					actualizarTotalCreditoInterno(totalMostrar,perfil,limiteNormal,limite);
				})
			}
		}
	}else{ // TODOS LO METODOS DE PAGO EXCEPTO FIADO CUALQUIER CLIENTE
		listarProductos();
		if (metodo == "Efectivo") {
			$('.cajasMetodoPago').html(
                '<div class="col-6">'+
                  	'<div class="mb-2"></div>'+
              		'<div class="form-group">'+
                		'<label>Efectivo ($)</label>'+
						'<input type="text" class="form-control nuevoValorEfectivoVista" id="nuevoValorEfectivoVista" name="nuevoValorEfectivoVista" placeholder="0" required onkeyup="formatoMiles($(this));" onkeypress="return soloNumeros(event)" onchange="sinFormatoMiles('+"'nuevoValorEfectivo'"+',$(this).val());calcularVuelto();">'+
                        '<input type="hidden" id="nuevoValorEfectivo" name="nuevoValorEfectivo">'+
              		'</div>'+
            	'</div>'+
                '<div class="col-6" style="padding-right:0px">'+
                  '<div class="mb-2"></div>'+
                  '<div class="form-group">'+
                    '<label>Vuelto ($)</label>'+
					'<input type="text" class="form-control nuevoCambioEfectivoVista" id="nuevoCambioEfectivoVista" name="nuevoCambioEfectivoVista" placeholder="0" readonly required>'+
					'<input type="hidden" id="nuevoCambioEfectivo" name="nuevoCambioEfectivo">'+
                  '</div>'+
                '</div>')
			$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA

		} else if (metodo == "E_TD") {
			$('.cajasMetodoPago').html(
				'<div class="col-4">' +
                  	'<div class="mb-2"></div>'+
            		'<label>Efectivo ($)</label>'+
					'<div>' +
						'<input type="number" min="1" class="form-control efectivoCombTD" id="efectivoCombTD" name="efectivoCombTD" onchange="calcTD();" placeholder="0" onkeypress="return soloNumeros(event)" required>' +
					'</div>' +
				'</div>' +

				'<div class="col-4" id="cobrarTD" style="padding-left:0px">' +
                  	'<div class="mb-2"></div>'+
            		'<label>Diferencia Tarjeta ($)</label>'+
					'<div>' +
						'<input type="text" class="form-control" id="vueltoCombTD" name="vueltoCombTD" placeholder="0" value="0" readonly required>' +
					'</div>' +
				'</div>' +
				
				'<div class="col-4" id="cobrarTD" style="padding-left:0px">' +
                  	'<div class="mb-2"></div>'+
            		'<label>Código Transacción</label>'+
					'<div>' +
						'<input type="text" class="form-control" id="codTransCombTD" name="codTransCombTD" maxlength="4" placeholder="4 últimos dígitos" onkeypress="return soloNumeros(event)" required>' +
					'</div>' +
				'</div>')
				$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA

		} else if (metodo == "E_TC") {
			$('.cajasMetodoPago').html(
				'<div class="col-4">' +
                  	'<div class="mb-2"></div>'+
            		'<label>Efectivo ($)</label>'+
					'<div>' +
						'<input type="number" min="1" class="form-control efectivoCombTC" id="efectivoCombTC" name="efectivoCombTC" onchange="calcTC();" placeholder="0" onkeypress="return soloNumeros(event)" required>' +
					'</div>' +
				'</div>' +

				'<div class="col-4" id="cobrarTC" style="padding-left:0px">' +
                  	'<div class="mb-2"></div>'+
            		'<label>Diferencia Tarjeta ($)</label>'+
					'<div>' +
						'<input type="text" class="form-control" id="vueltoCombTC" name="vueltoCombTC" placeholder="0" value="0" readonly required>' +
					'</div>' +
				'</div>' +
				
				'<div class="col-4" id="cobrarTC" style="padding-left:0px">' +
                  	'<div class="mb-2"></div>'+
            		'<label>Código Transacción</label>'+
					'<div>' +
						'<input type="text" class="form-control" id="codTransCombTC" name="codTransCombTC" maxlength="4" placeholder="4 últimos dígitos" onkeypress="return soloNumeros(event)" required>' +
					'</div>' +
				'</div>')
				$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA

		}else if (metodo == "TD" || metodo == "TC") {
			$('.cajasMetodoPago').html(
                '<div class="col-6">'+
                  	'<div class="mb-2"></div>'+
              		'<div class="form-group">'+
                		'<label>Código Transacción</label>'+
						'<input type="text" class="form-control" id="nuevoCodigoTransaccion" name="nuevoCodigoTransaccion" maxlength="4" placeholder="4 últimos dígitos" onkeypress="return soloNumeros(event)" required>'+
              		'</div>'+
                '</div>')
				$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA

		}else if (metodo == "Transferencia"){
			$('.cajasMetodoPago').html(
                '<div class="col-6">'+
                  	'<div class="mb-2"></div>'+
              		'<div class="form-group">'+
                		'<label>Monto Transferencia ($)</label>'+
						'<input type="text" class="form-control" id="transferencia" name="transferencia" placeholder="Monto Transferido" value="' + total + '" onkeypress="return soloNumeros(event)" required disabled>' +
              		'</div>'+
                '</div>')
				$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA
		}else if (metodo == "Pend") {
			$('.cajasMetodoPago').html(
                '<div class="col-6">'+
                  	'<div class="mb-2"></div>'+
              		'<div class="form-group">'+
                		'<label>Pago Pendiente ($)</label>'+
						'<input type="text" class="form-control pendiente" id="pendiente" name="pendiente" value="' + total + '" required disabled>' +
              		'</div>'+
                '</div>')
				$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA
		}else if (metodo == "Multi") {
			$('.cajasMetodoPago').html(
                '<div class="col-6">'+
                  	'<div class="mb-2"></div>'+
              		'<div class="form-group">'+
                		'<label>Pago Pendiente ($)</label>'+
						'<input type="text" class="form-control multi" id="multi" name="multi" value="' + total + '" required disabled>' +
              		'</div>'+
                '</div>')
				$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA
		} else {
			$('.cajasMetodoPago').html('');

		}
	}
})























/*-----------------------------------------------------------------------------------------------------------------------
PROCESO DE SUGERENCIA DE PRECIOS (solo 1 vez sugiere precios para que no sea molestosa la sugerencia)
-----------------------------------------------------------------------------------------------------------------------*/
$("#nuevoMetodoPago").one("click", function() { // detecta primer click y setea recomendaciones
    localStorage.setItem("primerClickMetodoPagoConRecomendaciones", 0);
});

$("#nuevoMetodoPago").on("click", function() { // detecta primer click
	let arrayRelacionados = [];
	var productos = JSON.parse($('#listaProductos').val());
	var descripcion = $(".nuevaDescripcionProducto");
	
	$(productos).each(function(i){ // busca ids con prods relacionados
		let idProd = $(descripcion[i]).attr("idProducto");
		let relacion = infoProd(idProd)['prods_relacionados'];
		if(relacion != ''){
			prodsRelacionados = relacion.split(',');
			for (var i = 0; i < prodsRelacionados.length; i++) {
				arrayRelacionados.push(prodsRelacionados[i]);
			}
		}
	})

	$(descripcion).each(function(i){ // elimina prods relacionados que ya esten vendidos
		let idProd = $(descripcion[i]).attr("idProducto");
		let relacion = infoProd(idProd)['prods_relacionados'];
		prodsRelacionados = relacion.split(',');
		if(prodsRelacionados.includes(idProd)){
			let indice = arrayRelacionados.indexOf(idProd);
			arrayRelacionados.splice(indice, 1);
		}
	})

	let arrayRelaciondos_SinDuplicados = [...new Set(arrayRelacionados)];
	if(arrayRelaciondos_SinDuplicados.length > 0 && localStorage.getItem("primerClickMetodoPagoConRecomendaciones") == 0){
		localStorage.setItem("primerClickMetodoPagoConRecomendaciones", 1);

		let sucursal = $('#sucursalActiva').val()
        var htmlMostrar = '';
        $(arrayRelaciondos_SinDuplicados).each(function (i){
        	let idProd = arrayRelaciondos_SinDuplicados[i];
        	let datosProd = infoProd(idProd);
        	if(datosProd['stock_'+sucursal] > 0){
          		htmlMostrar +=	'<div>'+
		          					'<div class="descripcionProdRelacionado"><b>'+datosProd['descripcion']+'</b></div>'+
								  	'<div class="input-seguido divCantProdRelacionado">'+
										'<font size="-2">Cantidad</font>'+
										'<input type="number" class="form-control cantProdRelacionado" style="height: 32px"  idProd="'+datosProd['id']+'" id="cantProdRelacionado" min="1" max="'+datosProd['stock_'+sucursal]+'" value="1" stock="'+datosProd['stock_'+sucursal]+'" mayoreo="'+datosProd['mayor_sobre']+'" required>'+
								    '</div>'+
								    '<div class="input-seguido">'+
										'<font size="-2">Total ($)</font>'+
										'<div class="input-group">'+
											'<input type="number" style="height: 32px" class="form-control nuevoPrecioProducto" pEditado="0" id="precioProdRelacionado" value="'+datosProd["precio_venta"]+'" required readonly>'+
										'</div>'+
								    '</div>'+				    
								    '<div class="input-seguido">'+
										'<button class="btn btn-primary btn-sm agregarProdRelacionado" idProd="'+datosProd['id']+'">Agregar</button>'+
									'</div>'+
								'</div><br><br>';
        	}
        });
       	if(htmlMostrar != ''){ // QUE NO APAREZCAN RECOMENDACIONES SI NO HAY STOCK DE PRODS SUGERIDOS
			Swal.fire({
				title: 'Productos Recomendados',
				icon: 'info',
				html: htmlMostrar,
				confirmButtonText: 'Ok',
				showCloseButton: true,
	        })
       	}

	}
});















$(document).on("click", "#forzarCIVenta", function(){ //OK
	idVenta = $(this).attr('idVenta');
	totalVenta = $(this).attr('totalVenta');
	var datos = new FormData();
  	datos.append("forzarCreditoInterno", idVenta);
	$.ajax({
  		type: "POST",
  		cache: false,
  		contentType: false,
  		processData: false,
  		data: datos,
		url:"ajax/ventas.ajax.php",
      	success:function(r){
      		if(r == 'ok'){
				var montoPendiente = Number($('.btn-confirmar-ventas-pendientes').attr('deudaPendiente')) + Number(totalVenta);
				$('.btn-confirmar-ventas-pendientes').attr('deudaPendiente',montoPendiente);
				$('#ventasPendiente'+idVenta).html('<font class="text-success">Venta forzada a Crédito Interno</font>');
				if($('.ventaAForzar').length == 0){
					$('.btn-confirmar-ventas-pendientes').removeAttr('disabled');
				}
      		}
    	}
	})  	
})

$(document).on("click", ".ventaAForzarTabla", function(){ //OK
	idVenta = $(this).attr('idVenta');
	idCliente = $(this).attr('idCliente');
	totalVenta = $(this).attr('totalVenta');
	datos1 = new FormData();
  	datos1.append("forzarCreditoInterno", idVenta);
	$.ajax({
  		type: "POST",
  		cache: false,
  		contentType: false,
  		processData: false,
  		data: datos1,
		url:"ajax/ventas.ajax.php",
      	success:function(r){
      		if(r == 'ok'){
				var datos2 = new FormData();
				datos2.append("verificarDeuda", idCliente);
				$.ajax({
				    url: "ajax/clientes.ajax.php",
				    method: "POST",
				    data: datos2,
				    cache: false,
				    contentType: false,
				    processData: false,
				    dataType: "json",
				    success: function(deuda){
				    	audioSuccess('Venta Forzada a Crédito Interno');
				    	$('#forzarCIVentaTabla'+idVenta).addClass('d-none');
				    	$('#metPago'+idVenta).html('<b>Credito Interno</b><br>Monto: $ '+formatNumber.new(totalVenta));
					}
      			})
      		}
    	}
	})  	
})

$('#btnAsignarRut').click(function(){ //OK
	var perfil = $('#perfilVend').val();
	var rut = $('#rutFacturaAsignar').val();
	var idVenta = $('#rutFacturaAsignar').attr('idVenta');
	var datos = new FormData();
  	datos.append("modificarRutFactuar", idVenta);
  	datos.append("rutFacturar", rut);

	$.ajax({
  		type: "POST",
  		cache: false,
  		contentType: false,
  		processData: false,
  		data: datos,
		url:"ajax/ventas.ajax.php",
      	success:function(resp){
      		r = resp.split(',');
      		if(r[0] == 'ok'){
				var audio = new Audio('componentes/sonidos/success.mp3');
				audio.play();
				Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Rut Asignado Correctamente'});

				$("#rutFacturaAsignar").val(''); // reset select
				$('#modalRutFacturar').modal('hide');
      			if(rut == ''){
      				$('#facturas'+idVenta).html('')
      				$("#botonDatosSII"+idVenta).html('');
      			}else{
      				$('#facturas'+idVenta).html('<hr><font size="-1" style="color:red">Facturar:<br><b>'+rut+'</b></font>'+
      											'<br><button class="btn btn-primary btn-xs btnSubirFactura" idVenta="'+idVenta+'" rut="'+rut+'">Subir Factura(s)</button>')
      				$("#botonDatosSII"+idVenta).html("<button class='btn btn-sm btnVentaSii listaFactura info' data-original-title='Datos Factura SII' style='background-color:gray; color:white' codigoVenta='"+idVenta+"' data-original-title='PDF Sii'><span class='d-none spinner-border spinner-border-sm'></span><font id='textoSII'>SII</font></button>");
      			}
      		}
    	}
	})
})

$(".tablaVentas").on("click", ".quitarFactsVenta", function(){ //OK
	Swal.fire({
		icon:'question',
		title: "<h5>Eliminar Facturas de la venta?</h5>",
		showDenyButton: true,
		confirmButtonText: 'Si',
		denyButtonText: 'Cancelar',
		customClass: {
		actions: 'my-actions',
		cancelButton: 'order-1 right-gap boton-cancelar',
		confirmButton: 'order-2 btn boton-confirmar',
		denyButton: 'order-3 btn boton-denegar',
		}
	}).then((result) => {
		if (result.isConfirmed) {
			var idVenta = $(this).attr('idVenta');
			var datos = new FormData();
		  	datos.append("quitarFacturas", idVenta);
			$.ajax({
		  		type: "POST",
		  		cache: false,
		  		contentType: false,
		  		processData: false,
		  		data: datos,
				url:"ajax/ventas.ajax.php",
		      	success:function(resp){
		      		console.log(resp);
		      		let r = resp.split(',');
		      		let rut = r[1];
		      		if(r[0]='ok'){
		      			$('#facturas'+idVenta).html('<hr><font size="-1" style="color:red">Facturar:<br><b>'+rut+'</b></font>'+
		      											'<br><button class="btn btn-primary btn-xs btnSubirFactura" idVenta="'+idVenta+'" rut="'+rut+'">Subir Factura(s)</button>')
		      		}
		    	}
			})  	
		} else if (result.isDenied) {
			resolve();
		}
	})
})

$(".tablaVentas").on("click", "#botonAsignarRutFactura", function(){ //OK
	let idCliente = $(this).attr('idCliente');
	let idVenta = $(this).attr('idVenta');
	let datosCliente = infoCliente(idCliente);
	if(datosCliente['rut_facturar'] != ''){
		$('#rutFacturaAsignar').attr('idVenta',idVenta);
		$('#rutFacturaAsignar').val(datosCliente['rut_facturar']);
		$('#btnAsignarRut').removeAttr('disabled');
		$('#rutFacturaAsignar').addClass('is-valid');
	}else{
		$('#rutFacturaAsignar').attr('idVenta',idVenta);
		$('#rutFacturaAsignar').val(datosCliente['rut_facturar']);
		$('#btnAsignarRut').attr('disabled');
		$('#rutFacturaAsignar').removeClass('is-valid');
	}
})

$('#modalRutFacturar').on('shown.bs.modal', function (e) { //OK
	$('#rutFacturaAsignar').select();
})

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

$(".tablaVentas").on("click", ".btnSubirFactura", function(){ //OK
	var idVenta = $(this).attr('idVenta');
	var rut = $(this).attr('rut');
	Swal.fire({
		icon: 'info',
		title: 'Subir Factura(s)',
	    html: '<input multiple type="file" id="inputArchivos" accept="application/pdf">',
	  	showDenyButton: true,
	  	confirmButtonText: 'Subir',
	  	denyButtonText: 'Cancelar',
	}).then((result) => {
	  	if (result.isConfirmed && $('#inputArchivos').val() == ''){ 
	        var audio = new Audio('componentes/sonidos/error.wav');
	        audio.play();
	        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon:'error', title:'NO HAY ARCHIVOS'});
	  		Swal.close();
		}else if(result.isConfirmed && $('#inputArchivos').val() != ''){
	  		const $inputArchivos = document.querySelector("#inputArchivos");
	  		const archivosParaSubir = $inputArchivos.files;
		    const datos = new FormData();
		    datos.append('subirFacturas',idVenta)
		    for (const archivo of archivosParaSubir) { // Agregamos cada archivo a "archivos[]". Los corchetes son importantes
		        datos.append("archivos[]", archivo);
		    }
			$.ajax({
		  		type: "POST",
		  		cache: false,
		  		contentType: false,
		  		processData: false,
		  		data: datos,
				url:"ajax/ventas.ajax.php",
		      	success:function(r){
		      		var archivos = r.split(',');
		      		var nroFacturas = archivos.length;
		      		var extension = archivos[nroFacturas-2];
		      		var carpeta = archivos[nroFacturas-1];
		      		var plural = nroFacturas == 2 ? '' : 'S';
		      		var saltoLinea = nroFacturas == 2 ? '' : '<br>';
		      		var linkFacturas = '';
		      		$(archivos).each(function (i){
		      			if(i != (nroFacturas-1) && i != (nroFacturas-2)){
		      				if(i == 0){
		      					// linkFacturas += '<a href="sii/facturas/'+carpeta+'/'+archivos[i]+'.'+extension+'" target="_blank">'+archivos[i]+'</a>';
		      					linkFacturas += '<button class="btn btn-dark btn-sm" onclick="window.open(\'/pos/sii/facturas/'+carpeta+'/'+archivos[i]+'.'+extension+'\')">'+archivos[i]+'</button>';
			      			}else{
		      					linkFacturas += ' <button class="btn btn-dark btn-sm" onclick="window.open(\'/pos/sii/facturas/'+carpeta+'/'+archivos[i]+'.'+extension+'\')">'+archivos[i]+'</button>';
			      			}
			      		}
		      		});
		      		botonEliminarFacts = "<button type='button' class='btn btn-danger btn-circle btn-sm quitarFactsVenta float-right info' idVenta='"+idVenta+"'><i class='fa fa-times'></i></button>";
		      		var rutMostrar = rut.split('-');
		      		var facturasMostar = '<hr><font size="-1" class="text-primary">FACTURA'+plural+' ASOCIADA'+plural+':   '+botonEliminarFacts+saltoLinea+linkFacturas;
		      		$('#facturas'+idVenta).html(facturasMostar);

		      		$("#botonDatosSII"+idVenta).remove();
		      		
			        var audio = new Audio('componentes/sonidos/success.mp3').play();
			        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Factura'+plural.toLowerCase()+' subida'+plural.toLowerCase()+' con éxito'});
		    	}
	   		})
	  	} else if (result.isDenied) {
	  		Swal.close()
	  	}
	})
})

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
$(".tablaVentas").on("click", ".reimprimirTicketVenta", function(){ //OK
	idVenta = $(this).attr('idVenta');
	extraerDatosVentaTicket(idVenta,$(this));
	$(this).attr('disabled','disabled');
})


/*============================================= //OK
INGRESAR DETALLE VENTA AJAX
=============================================*/
$(".tablaVentas").on("click", ".editDetalleVentaAjax,.btnAgregarDetalleVentaAjax", function(){
	idVenta = $(this).attr('idVenta');
	detalle = $(this).text() == '+' ? '' : $(this).text();
	// SCRIPT PARA IDENTIFICAR LOS 2 ULTIMOS ID'S ABIERTOS
  	contador++;
  	if(contador==1){
	    localStorage.setItem("primerIdDetalleVenta", idVenta);
	    localStorage.setItem("primerDetalleVenta", detalle);
    	// INTERFAZ PARA EDITAR DETALLE VENTA
    	$('#detalleVenta'+idVenta).html(
			'<input class="form-control" name="editDetalleVentaAjaxEnviar" idVenta="'+idVenta+'" id="editDetalleVentaAjaxEnviar" value="'+detalle+'">'+
      		'<button style="width:110px" class="btn btn-info btn-xs btnEditDetalleVentaAjaxEnviar" idVenta="'+idVenta+'" detalleVenta="'+detalle+'" id="btnEditDetalleVentaAjaxEnviar'+idVenta+'">Actualizar Detalle</button>');
    	$('#editDetalleVentaAjaxEnviar').select();
  	}else if(contador==2){
    	localStorage.setItem("ultimoIdDetalleVenta", idVenta);
    	localStorage.setItem("ultimoDetalleVenta", detalle);
    	// A LA NORMALIDAD EL BOTON ANTERIOR
    	detalleVentaRestaurar = localStorage.getItem('primerDetalleVenta') == 'Agregar Detalle' ? "<button class='btn btn-success btn-sm btnAgregarDetalleVentaAjax' idVenta='"+localStorage.getItem('primerIdDetalleVenta')+"'>Agregar Detalle</button>" : "<b class='editDetalleVentaAjax' idVenta='"+localStorage.getItem('primerIdDetalleVenta')+"'>"+localStorage.getItem('primerDetalleVenta')+"</b>";
    	$('#detalleVenta'+localStorage.getItem('primerIdDetalleVenta')).html(detalleVentaRestaurar);
    	// INTERFAZ PARA EDITAR DETALLE VENTA
    	$('#detalleVenta'+idVenta).html(
			'<input class="form-control" name="editDetalleVentaAjaxEnviar" idVenta="'+idVenta+'" id="editDetalleVentaAjaxEnviar" value="'+detalle+'">'+
      		'<button style="width:110px" class="btn btn-info btn-xs btnEditDetalleVentaAjaxEnviar" idVenta="'+idVenta+'" detalleVenta="'+detalle+'" id="btnEditDetalleVentaAjaxEnviar'+idVenta+'">Actualizar Detalle</button>');
    	$('#editDetalleVentaAjaxEnviar').select();
  	}else{
    	localStorage.setItem("primerIdDetalleVenta", localStorage.getItem("ultimoIdDetalleVenta"));
    	localStorage.setItem("primerDetalleVenta", localStorage.getItem("ultimoDetalleVenta"));
    	localStorage.setItem("ultimoIdDetalleVenta", idVenta);
    	localStorage.setItem("ultimoDetalleVenta", detalle);
    	// A LA NORMALIDAD EL BOTON ANTERIOR
    	detalleVentaRestaurar = localStorage.getItem('primerDetalleVenta')  == 'Agregar Detalle' ? "<button class='btn btn-success btn-sm btnAgregarDetalleVentaAjax' idVenta='"+localStorage.getItem('primerIdDetalleVenta')+"'>Agregar Detalle</button>" : "<b class='editDetalleVentaAjax' idVenta='"+localStorage.getItem('primerIdDetalleVenta')+"'>"+localStorage.getItem('primerDetalleVenta')+"</b>";
    	$('#detalleVenta'+localStorage.getItem('primerIdDetalleVenta')).html(detalleVentaRestaurar);
    	// INTERFAZ PARA EDITAR DETALLE VENTA
    	$('#detalleVenta'+idVenta).html(
			'<input class="form-control" name="editDetalleVentaAjaxEnviar" idVenta="'+idVenta+'" id="editDetalleVentaAjaxEnviar" value="'+detalle+'">'+
      		'<button style="width:110px" class="btn btn-info btn-xs btnEditDetalleVentaAjaxEnviar" idVenta="'+idVenta+'" detalleVenta="'+detalle+'" id="btnEditDetalleVentaAjaxEnviar'+idVenta+'">Actualizar Detalle</button>');
    	$('#editDetalleVentaAjaxEnviar').select();
  	}
})

$(".tablaVentas").on("click", ".btnEditDetalleVentaAjaxEnviar", function(){ //OK
	idVenta = $(this).attr('idVenta');
	detalle = $(this).attr('detalleVenta');
	detalleEditado = $('#editDetalleVentaAjaxEnviar').val();
	var datos = new FormData();
  	datos.append("modifDetalleVenta", idVenta);
  	datos.append("detalleModif", elimCaracteresMalos(detalleEditado));
  	if(detalle == detalleEditado){
  		detalleVentaRestaurar = detalleEditado == '' ? "<button class='btn btn-success btn-sm btnAgregarDetalleVentaAjax info' data-original-title='Agregar Detalle' data-placement='bottom' idVenta='"+idVenta+"'>+</button>" : "<b class='editDetalleVentaAjax' idVenta='"+idVenta+"'>"+elimCaracteresMalos(detalleEditado)+"</b>";
		$('#detalleVenta'+idVenta).html(detalleVentaRestaurar);
    	Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'info',title: 'No se registraron cambios'})
  	}else if(detalle!=detalleEditado){
	   	$.ajax({
			url:"ajax/ventas.ajax.php",
	  		method: "POST",
	  		data: datos,
	  		cache: false,
	  		contentType: false,
	  		processData: false,
	  		beforeSend: function() {
	        	$('#btnEditDetalleVentaAjaxEnviar'+idVenta).removeAttr('style');
	        	$('#btnEditDetalleVentaAjaxEnviar'+idVenta).removeClass('btn-info');
	        	$('#btnEditDetalleVentaAjaxEnviar'+idVenta).addClass('btn-default');
	        	$('#btnEditDetalleVentaAjaxEnviar'+idVenta).attr('disabled','disabled');
	        	$('#btnEditDetalleVentaAjaxEnviar'+idVenta).html("<div style='text-align:center'>ACTUALIZANDO DETALLE VENTA...</div>");
	  		},      
	      	success:function(r){
        		var resp = r.split(',');
        		if(resp[0]=='ok'){
			    	detalleVentaRestaurar = detalleEditado == '' ? "<button class='btn btn-success btn-xs btnAgregarDetalleVentaAjax info' data-original-title='Agregar Detalle' data-placement='bottom' idVenta='"+idVenta+"'>+</button>" : "<b class='editDetalleVentaAjax' idVenta='"+idVenta+"'>"+elimCaracteresMalos(resp[1])+"</b>";
          			$('#detalleVenta'+idVenta).html(detalleVentaRestaurar);
			        var audio = new Audio('componentes/sonidos/success.mp3');
			        audio.play();
			        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Detalle modificado'});
          			
          			localStorage.clear();
          			contador=0;
        		}
	    	}
	   	})
  	}
})

/*============================================= //OK
COPIAR JSON PRODUCTOS VENDIDOS PARA FACTURAR
=============================================*/
$(".tablaVentas").on("click", ".listaFactura", function(){
	idVenta = $(this).attr('codigoVenta');
	var datos = new FormData();
  	datos.append("datosVenta", idVenta);
   	$.ajax({
		url:"ajax/ventas.ajax.php",
  		method: "POST",
  		data: datos,
  		cache: false,
  		contentType: false,
  		processData: false,
      	success:function(r){
      		infoVenta = JSON.parse(r);
      		var prodsVenta = JSON.parse(infoVenta['productos']);
      		var arrayProdsFactura = [];
			$(prodsVenta).each(function (i){
				var nomProdSii = infoProd(prodsVenta[i].id)['desc_sii'];
				if(Number(prodsVenta[i].pV) != 0){
					arrayProdsFactura.push({
						"prod":nomProdSii,
						"cant":prodsVenta[i].cant,
						"pV":prodsVenta[i].pV,
						"tot":prodsVenta[i].tot
					})
				}
    		});
    		copiarTexto(infoVenta['rut_factura'].replace(/-/g, "")+'///'+JSON.stringify(arrayProdsFactura)+'///'+infoVenta['tipo_pago']+'///'+infoVenta['id']); // sin https
		    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Copia Exitosa'});
    	}
   	})
})

/*=============================================
LISTAR TODOS LOS PRODUCTOS
=============================================*/
function listarProductos(){
  	var total = 0;
  	var totalNormal = 0;
  	var skuFlete = ajuste('sku_flete');
	var detectaFlete = 0;
	setTimeout(function(){
		var listaProductos = [];
		var listaProdsVentaRelacionados = []
		var descripcion = $(".nuevaDescripcionProducto");
		var cantidad = $(".nuevaCantidadProducto");
		var precio = $(".nuevoPrecioProducto");
		var descuento = $(".descuentoProducto");
		for (var i = 0; i < descripcion.length; i++){


			let datosProd = infoProd($(descripcion[i]).attr("idProducto"));
			precioVenta = $(precio[i]).val()/$(cantidad[i]).val();
			$(precio[i]).attr('data-original-title',' $ '+formatNumber.new(precioVenta)+' c/u');
			listaProductos.push({
				"id": $(descripcion[i]).attr("idProducto"),
				"sku": $(descripcion[i]).attr("codigoInterno"),
				"cant": $(cantidad[i]).val(),
				"pC": datosProd['precio_compra'],
				"pV": precioVenta,
				"tot": $(cantidad[i]).val()*precioVenta,
				"prod": $(descripcion[i]).val(),
				"dcto": $(descuento[i]).val()
			})
			total = Number(total) + Number($(precio[i]).val());
			totalNormal = Number(totalNormal) + Number(datosProd['precio_venta']) * Number($(cantidad[i]).val());
			if($(descripcion[i]).attr("codigoInterno") == skuFlete){
				detectaFlete += 1;
			}else{
				detectaFlete += 0
			}

			if($(cantidad[i]).hasClass('ventaProdRelacionado')){
				listaProdsVentaRelacionados.push({
					"id": $(descripcion[i]).attr("idProducto"),
					"cant": $(cantidad[i]).val(),
					"pC": datosProd['precio_compra'],
					"pV": precioVenta,
					"tot": ($(cantidad[i]).val()*precioVenta)
				})
			}
		}

		$("#listaProductos").val(JSON.stringify(listaProductos));
		$("#listaVentaProdsRelacionados").val(JSON.stringify(listaProdsVentaRelacionados));
		$('.incluyeFlete').val(detectaFlete);
		actualizarTotales(total,totalNormal);
	}, 300);
}

function actualizarTotales(total,totalNormal){
	// ACTUALIZA TOTALES	
	$("#nuevoTotalVenta").text('   '+formatNumber.new(total));
	$("#totalVenta").val(total);
	$("#totalVentaNormal").val(totalNormal);
	$("#nuevoMetodoPago").removeAttr("disabled");
	$("#transferencia").val(total);
	$("#pendiente").val(total);
	var prodsComunes = $(".descProdComun");
	if(total == 0 && prodsComunes.length == 0){
		$(".nuevoProducto").html('')
	}
}




$(document).on("change", "input.cantProdRelacionado", function() {
	let sucursal = $('#sucursalActiva').val();
	let cant = $(this).val();
	let max = $(this).attr('max');
	let datosProd = infoProd($(this).attr('idProd'));
	let plural = Number(datosProd['stock_'+sucursal]) > 1 ? 'n' : '';
	if(Number(cant) > Number(max)){
		$(this).val(max);
		$(this).parent().parent().children('.descripcionProdRelacionado').html('<b>'+datosProd['descripcion']+'<font style="color:red"><br><font size="-1">Solo queda'+plural+' '+datosProd['stock_'+sucursal]+'u</font></font></b>');
	}
})


$(document).on("click", "button.agregarProdRelacionado", function() {
	$(this).attr('disabled','disabled');
	$(this).parent().parent().children('.divCantProdRelacionado').children('.cantProdRelacionado').attr('disabled','disabled');
	let sucursal = $('#sucursalActiva').val();
	let cantProdRelacionado = $(this).parent().parent().children('.divCantProdRelacionado').children('.cantProdRelacionado').val();
	let idProd = $(this).attr('idProd');
	let datosProd = infoProd(idProd);
	let totalRelacionado = Number(cantProdRelacionado) >= Number(datosProd['mayor_sobre']) ? Number(cantProdRelacionado)*Number(datosProd['precio_mayor']) : Number(cantProdRelacionado)*Number(datosProd['precio_venta']);
	let estilo = Number(cantProdRelacionado) >= Number(datosProd['mayor_sobre']) ? 'height: 40px; background-color:rgb(169,249,98)' : 'height: 40px;';
	let descuento = Number(cantProdRelacionado) >= Number(datosProd['mayor_sobre']) ? Math.round((1 - (datosProd['precio_mayor']/(datosProd['precio_venta'])))*10000)/100 : 0;
	let sku = Number(datosProd['categoria']) >= 10 ? datosProd['sku'] : 0+datosProd['sku'];
	let descripcionMostrar = '<b>'+datosProd['zona_'+sucursal]+'-'+sku+'</b> '+datosProd['descripcion']+' <b>('+formatNumber.new(datosProd['precio_venta'], "$")+'c/u desde '+datosProd['mayor_sobre']+'u '+formatNumber.new(datosProd['precio_mayor'], "$")+'c/u)</b> [<i>'+datosProd['descuento']+'%</i>]';

 	$(".nuevoProducto").prepend(
      	'<div class="row col-12" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
        	'<div class="col-12 descripcion" style="padding-left:0px">'+
          		'<div>'+
            		'<div>'+
              			'<button type="button" class="btn btn-danger btn-xs quitarProducto" idproducto="'+datosProd['id']+'">'+
                			'<i class="fa fa-times"></i>'+
              			'</button>'+
              			'<font size="-1">   '+descripcionMostrar+'</font>'+
            		'</div>'+
            		'<input type="hidden" class="form-control nuevaDescripcionProducto" style="height: 40px" idproducto="'+datosProd['id']+'" codigointerno="'+datosProd['sku']+'" name="agregarProducto" value="'+datosProd['descripcion']+'" required="">'+
          		'</div>'+
        	'</div>'+
        	'<div style="height:25px"></div>'+
        	'<div class="col-3 cantidadProducto" style="padding-left:0px">'+
          		'<font size="-2">Cantidad</font>'+
          		'<input type="number" class="form-control ventaProdRelacionado nuevaCantidadProducto" style="height: 40px" name="nuevaCantidadProducto" id="nuevaCantidadProducto" min="1" value="'+cantProdRelacionado+'" stock="'+datosProd['stock_'+sucursal]+'" mayoreo="'+datosProd['mayor_sobre']+'" required>'+
        	'</div>'+
            '<div class="col-6 ingresoPrecio" style="padding-left:0px">'+
          		'<font size="-2">Total ($)</font>'+
          		'<div class="input-group">'+
	                '<input type="number" style="'+estilo+'" class="form-control nuevoPrecioProducto" pEditado="0" id="nuevoPrecioProducto" value="'+totalRelacionado+'" required readonly>'+
          		'</div>'+
        	'</div>'+
            '<div class="col-3 ingresoDescuento" style="padding-left:0px">'+
              	'<div>'+
              		'<font size="-2">Descuento</font>'+
                	'<input type="number" style="'+estilo+'" min="0" max="'+datosProd['descuento']+'" class="form-control descuentoProducto" step="1" value="'+descuento+'" required>'+
              	'</div>'+
            '</div>'+
        '</div>'+
        '<div id="esp'+datosProd['id']+'" style="height:3px"></div>')
	listarProductos()
	calcularVuelto()
	calcTD()
	calcTC()
})



function actualizarTotalCreditoInterno(totalMostrar,perfil,limiteNormal,limite){
	
	$('.cajasMetodoPago').html(
        '<div class="col-6">'+
          	'<div class="mb-2"></div>'+
      		'<div class="form-group">'+
        		'<label>Crédito Interno</label>'+
				'<input type="text" class="form-control creditoInterno" id="creditoInterno" total="'+totalMostrar+'" name="creditoInterno" value="' + totalMostrar + '" required disabled>' +
      		'</div>'+
        '</div>')


	if(perfil == 'Administrador'){ // PERMITE VENDER A ADMINISTRADOR (FORZAR CREDITO INTERNO)
		$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA
		if(Number(totalMostrar) > Number(limite)){// SI COMPRA SUPERA LIMITE	
			Swal.fire({
				icon: "error",
				title: '<b>SUPERA LÍMITE DE CRÉDITO</b>',
				html: "Cupo permitido <b>"+formatNumber.new(limiteNormal,'$')+"</b><br>Monto máximo por esta vez es de "+formatNumber.new(limite,'$'),
				showConfirmButton: true,
				confirmButtonText: "Ok"
			})
		}
	}else{ // FILTRA SI SE PUEDE CERRAR VENTA O NO A VENDEDORES
		if(Number(totalMostrar) > Number(limite)){// SI COMPRA SUPERA LIMITE	
			$('#ingresarVenta').attr('disabled','disabled'); // DESACTIVA REGISTRAR VENTA
				Swal.fire({
					icon: "error",
					title: '<b>SUPERA LÍMITE DE CRÉDITO</b>',
					html: "Cupo permitido <b>"+formatNumber.new(limiteNormal,'$')+"</b><br>Monto máximo por esta vez es de "+formatNumber.new(limite,'$'),
					showConfirmButton: true,
					confirmButtonText: "Ok"
				})
		}else{
			$('#ingresarVenta').removeAttr('disabled'); // HABILITA REGISTRAR VENTA
		}
	}
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

var sucursal = $(this).attr('sucursal');
var perfil = $("#perfilVend").val();
var ultCierre = $(".tablaVentas").attr('ultCierre');
// var skuInteres = ajuste('sku_interes');

$('#recuperaUltimaVenta').click(function(){
	codigoVenta = $(this).attr('ultima');
	window.open("extensiones/tcpdf/pdf/boleta-carta.php?codigo="+codigoVenta+"&motivo=ver", "_blank");
})


// var mostrarColvis = perfil == 'Administrador' ? false : true;
// var mostrarColvis = false;

if($('#perfilVend').val() == 'Administrador'){
	windows = obtenerGET(window.location)['ruta'];
	$('.tablaVentas').DataTable({
		// "ajax": "ajax/datatable-ventas.ajax.php?&ultCierre="+ultCierre+"&ventana="+ventana+"&skuInteres="+ajuste('sku_interes')+"&fechaInicial="+obtenerGET(window.location)['fechaInicial']+"&fechaFinal="+obtenerGET(window.location)['fechaFinal'],
		"ajax": "ajax/datatable-ventas.ajax.php?&ultCierre="+ultCierre+"&ventana="+windows+"&skuInteres="+ajuste('sku_interes')+"&fechaInicial="+obtenerGET(window.location)['fechaInicial']+"&fechaFinal="+obtenerGET(window.location)['fechaFinal'],
		// "order": [[ 7, "desc" ]], //orden descendente por defecto
		"deferRender": true,
		"retrieve": true,
		"mark": true, // marcar busqueda
		"processing": true,
		"language": {

			"sProcessing": "Procesando...",
			"sLengthMenu": "Mostrar _MENU_ registros",
			"sZeroRecords": "No se encontraron resultados",
			"sEmptyTable": "Ningún dato disponible en esta tabla",
			"sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
			"sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
			"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
			"sInfoPostFix": "",
			"sSearch": "Buscar (F3):",
			"sUrl": "",
			"sInfoThousands": ",",
			"sLoadingRecords": "Cargando...",
			"oPaginate": {
				"sFirst": "Primero",
				"sLast": "Último",
				"sNext": "Siguiente",
				"sPrevious": "Anterior"
			},
			"oAria": {
				"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
				"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			}
		},
	  	dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"fp>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
	    // mark: true,

	  	buttons:
	    [
		    { //Botón para Excel
		        extend: 'excel',
		        footer: true,
		        title: 'Archivo',
		        filename: 'Export_File',
		        text: '<button class="btn btn-sm btn-success info" data-original-title="Exportar a Excel" data-placement="bottom"><i class="fas fa-file-excel"></i></button>'
			},
			
			{ //Botón para PDF
		        extend: 'pdf',
		        footer: true,
		        title: 'Archivo PDF',
		        filename: 'Export_File_pdf',
		        text: '<button class="btn btn-sm bg-orange info" data-original-title="Exportar a PDF" data-placement="bottom"><i class="far fa-file-pdf texto-bco"></i></button>'
			},
			
			{ //Botón para Copiar Tabla
		        extend: 'copy',
		        text: '<button class="btn btn-sm bg-olive info" data-original-title="Copiar Tabla" data-placement="bottom"><i class="fa-solid fa-clipboard"></i></button>'
			},

			{ //Botón para Imprimir
		        extend: 'print',
		        text: '<button class="btn btn-sm bg-teal info" data-original-title="Imprimir" data-placement="bottom"><i class="fa-solid fa-print"></i></i></button>'
			}

			,{ //Vista de columas
		        extend: 'colvis',
		        footer: true,
		        text: '<button class="btn btn-sm bg-lightblue info" data-original-title="Vista Columnas" data-placement="bottom"><i class="fa-solid fa-eye"></i></button>'
			},
			{ // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
                text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
                action: function ( e, dt, node, config ) {
					dt.clear().draw();
					dt.ajax.reload();
                }
            }	      
			
	    ]
	    ,
	    columnDefs: [ // SETEO DE COLUMNAS QUE SE VEN POR DEFECTO
	        {
	            targets: 5,
	            visible: false
	        }
	    ]
	});


}else{

	$('.tablaVentas').DataTable({
		"ajax": "ajax/datatable-ventas.ajax.php?ultCierre="+ultCierre+"&ventana="+ventana+"&skuInteres="+ajuste('sku_interes'),
		// "order": [[ 7, "desc" ]], //orden descendente por defecto
		"deferRender": true,
		"retrieve": true,
		"processing": true,
		"language": {

			"sProcessing": "Procesando...",
			"sLengthMenu": "Mostrar _MENU_ registros",
			"sZeroRecords": "No se encontraron resultados",
			"sEmptyTable": "Ningún dato disponible en esta tabla",
			"sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
			"sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
			"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
			"sInfoPostFix": "",
			"sSearch": "Buscar (F3):",
			"sUrl": "",
			"sInfoThousands": ",",
			"sLoadingRecords": "Cargando...",
			"oPaginate": {
				"sFirst": "Primero",
				"sLast": "Último",
				"sNext": "Siguiente",
				"sPrevious": "Anterior"
			},
			"oAria": {
				"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
				"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			}
		}
		,
	  	
	  	dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
	    // mark: true,
	  	buttons:
		    [
			   // { // boton personalizado
	     //            text: ' <button class="btn btn-secondary btn-sm" data-toggle="modal" data-target="#modalRutFacturar">Asignar Rut Facturar</button>',
	     //        }	      
		    ]
		    

	});

}


$('.tablaVentasMovil').DataTable({
	"ajax": "ajax/datatable-ventas-movil.ajax.php?ultCierre="+ultCierre+"&ventana="+ventana,
	"order": [[ 0, "desc" ]], //orden descendente por defecto
	"deferRender": true,
	"retrieve": true,
	"processing": true,
	"language": {
	    "sProcessing":     "Procesando...",
	    "sLengthMenu":     "",
	    "sZeroRecords":    "No se encontraron resultados",
	    "sEmptyTable":     "Ningún dato disponible en esta tabla",
	    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
	    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
	    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
	    "sInfoPostFix":    "",
	    "sSearch": "<button class='btn btn-info btn-sm' onclick='actualizarTabla();'><i class='fas fa-undo'></i></button>    Buscar",
	    "sUrl": "",
	    "sInfoThousands": ",",
	    "sLoadingRecords": "Cargando...",
	    "oPaginate": {
	      "sFirst": "Primero",
	      "sLast": "Último",
	      "sNext": "&rarr;",
	      "sPrevious": "&larr;"
	    },
	    "oAria": {
	      "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
	      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
	    }

	},
	dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',
});


var tablaDataProductos = $('.tablaVentaProductos').DataTable({
	"ajax": "ajax/datatable-ventaProductos.ajax.php?perfil="+perfil+"&skuProdComun="+ajuste('sku_prod_comun')+"&skuInteres="+ajuste('sku_interes')+"&ventana="+obtenerPAGINA_y_GET(window.location).pagina,
	"deferRender": true,
	"retrieve": true,
	"processing": true,
	"language": {

		"sProcessing": "Procesando...",
		"sLengthMenu": "Mostrar _MENU_ registros",
		"sZeroRecords": "No se encontraron resultados",
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		"sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
		"sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		"sInfoPostFix": "",
		"sSearch": "Buscar (F3):",
		"sUrl": "",
		"sInfoThousands": ",",
		"sLoadingRecords": "Cargando...",
		"oPaginate": {
			"sFirst": "Primero",
			"sLast": "Último",
			"sNext": "Siguiente",
			"sPrevious": "Anterior"
		},
		"oAria": {
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		}

	},
  	
  	dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
  	buttons:

  		[
			{ // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
                text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
                action: function ( e, dt, node, config ) {
					dt.clear().draw();
					dt.ajax.reload();
                }
            }	      
	    ]

});






$("#modalVentaMovil").on("change", "input.precioVentaProdMovilVista", function() {
	idProd = $(this).attr('idProducto');
	pVUnico = $(this).val().replace('.',''); // sin puntos
	pVMin = $(this).attr('min');
	sku = infoProd(idProd)['sku'];
	skuInteres = ajuste('sku_interes');
		
	if(Number(sku) == Number(skuInteres) && Number(pVUnico) < Number(pVMin)){
		mixinInfo('Se ingresará como descuento');
	}else if(Number(sku) != Number(skuInteres) && Number(pVUnico) < Number(pVMin)){
		audioError('El valor mínimo es: '+formatNumber.new(pVMin));
		$('#precioVentaProdMovil'+idProd).val(pVMin);
		$('#precioVentaProdMovilVista'+idProd).val(formatNumber.new(pVMin));
		$("button.agregarUnico[idProducto='" + idProd + "']").attr('pMay',pVMin);	
	}else{
		$("button.agregarUnico[idProducto='" + idProd + "']").attr('pMay',pVUnico);	
	}
})

$('#modalVentaMovil').on('shown.bs.modal', function (e) {
	$('div.dataTables_filter input').val('');
	$('div.dataTables_filter input').select();
})



/*=============================================
LEYENDA SOBRE INPUT
=============================================*/
$(".formularioVenta").on("mouseover", "input#nuevoPrecioProducto", function() {
    // var cant = $(this).parent().parent().parent().children(".cantidadProducto").children(".nuevaCantidadProducto").val();
    // var pUnit = Number($(this).val())/Number(cant);
    // $(this).attr('data-original-title',formatNumber.new(pUnit,'$')+' c/u');
    // $(this).tooltip('bottom');
})

/*=============================================
HACER CLICK AL BUSCAR EN DATATABLE
=============================================*/
$('div.dataTables_filter').keyup(function(e) {
	// if($('div.dataTables_filter input')!=""){
	if (e.keyCode == 13) {





		// // valorInput = $('div.dataTables_filter input').val();
		// // if(valorInput.includes('*')){
		// // 	cant = $('div.dataTables_filter input').val().split('*')[0];
		// // 	sku = $('div.dataTables_filter input').val().split('*')[1];
		// // }else{
		// // 	cant = 1;
		// // 	sku = $('div.dataTables_filter input').val();
		// // }

		// // $('div.dataTables_filter input').val(sku);

		// // setTimeout(function(){
		// // },1000)

		// // HACE CLICK EN LA PRIMERA COINCIDENCIA DE LA BUSQUEDA DATATABLE
		// $('#agregarProducto0').click();
		// // MUESTRA TODA LA TABLA DEJANDO INVALIDO EL SEARCH, PERO NO BORRA EL INPUT
		// $('#tablaVentaProductos').dataTable().fnFilter('');












		// $('div.dataTables_filter input').select()
		// // HACE CLICK EN LA PRIMERA COINCIDENCIA DE LA BUSQUEDA DATATABLE
		// $('#agregarProducto0').click();
		// // MUESTRA TODA LA TABLA DEJANDO INVALIDO EL SEARCH, PERO NO BORRA EL INPUT
		// $('#tablaVentaProductos').dataTable().fnFilter('');
	}
	// }
});

/*==================================================
SURTIR PRODUCTO TRANSFORMABLE
==================================================*/
$(".tablaVentaProductos tbody").on("click", "button#surtirAlChicoxD", function(){
	$(this).attr('disabled','disabled');
	var idProd = $(this).attr('idProd');
    var datos = new FormData();
    datos.append("idProdTransf", idProd);
	$.ajax({
		url: "ajax/productos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		 beforeSend: function() {
		 	$('#surtirAlChicoxD').removeAttr('style');
		 	$('#surtirAlChicoxD').addClass('btn-default');
		 	$('#surtirAlChicoxD').attr('disabled','disabled');
		    $('#surtirAlChicoxD').removeAttr('data-original-title');
	        $('#surtirAlChicoxD').html("<div style='text-align:center'>TRANSFORMADO...</div>");
    	},
		success: function(r){
			$('.tablaVentaProductos').DataTable().ajax.reload();
			audioSuccess('SE HA SURTIDO EL PRODUCTO');
		}
	})
})




/*=============================================
CUANDO CARGUE LA TABLA CADA VEZ QUE NAVEGUE EN ELLA
=============================================*/
$(".tablaVentaProductos").on("draw.dt", function() {
	if (localStorage.getItem("quitarProducto") != null) {
		var listaIdProductos = JSON.parse(localStorage.getItem("quitarProducto"));
		for (var i = 0; i < listaIdProductos.length; i++) {
			$("button.recuperarBoton[idProducto='" + listaIdProductos[i]["idProducto"] + "']").removeClass('btn-default');
			$("button.recuperarBoton[idProducto='" + listaIdProductos[i]["idProducto"] + "']").addClass('btn-primary agregarProducto');
		}
	}
})

/*=============================================
QUITAR PRODUCTOS DE LA VENTA Y RECUPERAR BOTÓN
=============================================*/
var idQuitarProducto = [];
localStorage.removeItem("quitarProducto");
$(".formularioVenta").on("click", "button.quitarProducto", function() {


	var nroProdComun = $('.prodComunCod').val();
	

	if($(this).hasClass('quitarProductoComun')){ // RESTA 1 EN CONTROL DE PRODUCTOS COMUNES
		nroProdComun = Number(nroProdComun) - 1; 
		$('.prodComunCod').val(nroProdComun);
	}

	$(this).parent().parent().parent().parent().parent().children('#esp'+$(this).attr('idProducto')).remove();
	$(this).parent().parent().parent().parent().remove();
	var idProducto = $(this).attr("idProducto");
	$('.nuevoMetodoPago').val(''); // RESET METODO PAGO
	$('.cajasMetodoPago').html(''); // RESET METODO PAGO

	/*=============================================
	ALMACENAR EN EL LOCALSTORAGE EL ID DEL PRODUCTO A QUITAR
	=============================================*/
	if (localStorage.getItem("quitarProducto") == null) {
		idQuitarProducto = [];
	} else {
		idQuitarProducto.concat(localStorage.getItem("quitarProducto"))
	}

	idQuitarProducto.push({
		"idProducto": idProducto
	});

	localStorage.setItem("quitarProducto", JSON.stringify(idQuitarProducto));

	$("button.recuperarBoton[idProducto='" + idProducto + "']").removeClass('btn-default');

	botonRecuperado = screen.width >= 992 ? 'agregarProducto' : 'agregarUnico';
	$("button.recuperarBoton[idProducto='" + idProducto + "']").addClass('btn-primary '+botonRecuperado);
	
	$("button[idProd='" + idProducto + "']").removeAttr('disabled'); //RECUPERAR BOTONES DE EDICIÓN DE VENTA EN pVMayVivo	

	if ($(".nuevoProducto").children().length == 0) {

		$("#nuevoImpuestoVenta").val(0);
		$("#nuevoTotalVenta").val(0);
		$("#totalVenta").val(0);
		$("#totalUtilidad").val(0);
		$("#nuevoTotalVenta").attr("total", 0);

		// DESACTIVA BOTON INGRESAR VENTA SI NO HAY PRODUCTOS
		$('#nuevoMetodoPago').attr('disabled', 'disabled');
		
	} else {

		listarProductos()
		calcularVuelto();
		calcTD();
		calcTC();


	}

	var datos = new FormData();
	datos.append("idProducto", idProducto);
	$.ajax({
		url: "ajax/productos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(resp) {
			$(".varMayor[idProd='" + idProducto + "']").html("&uarr; "+resp["mayor_sobre"]+"u $ "+formatNumber.new(resp["precio_mayor"])+" c/u");
			$('#selectProdVentaMovil').prepend('<option class="red-option" value="'+resp['id']+'">['+resp['sku']+'] '+resp["descripcion"]+'</option>'); // DEVUELVE AL SELECT DE VENTA MOVIL
		}
	})

	listarProductos()


})



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*=============================================
SELECCIONAR PRODUCTO DESDE CELULAR
=============================================*/

$(".formularioVenta").on("change", "select.nuevaDescripcionProducto", function() {
	var nombreProducto = $(this).val();
	var nuevaDescripcionProducto = $(this).parent().parent().parent().children().children().children(".nuevaDescripcionProducto");
	var nuevoPrecioProducto = $(this).parent().parent().parent().children(".ingresoPrecio").children().children(".nuevoPrecioProducto");
	var nuevaCantidadProducto = $(this).parent().parent().parent().children(".ingresoCantidad").children(".nuevaCantidadProducto");
    var sucursal = $('#sucursalActiva').val();
	var datos = new FormData();
	datos.append("nombreProducto", nombreProducto);
	$.ajax({
		url: "ajax/productos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta) {
			$(nuevaDescripcionProducto).attr("idProducto", respuesta["id"]);
			$(nuevaCantidadProducto).attr("stock_"+sucursal, respuesta["stock_"+sucursal]);
			$(nuevoPrecioProducto).val(respuesta["precio_venta"]);
			listarProductos()
		}
	})
})

/*=============================================
APLICAR DESCUENTO
=============================================*/
$(".formularioVenta").on("change", "input.descuentoProducto", function() {

	var datosProd = infoProd($(this).parent().parent().parent().children(".descripcion").children().children().children(".quitarProducto").attr('idProducto'));
	var precio = $(this).parent().parent().parent().children(".ingresoPrecio").children().children(".nuevoPrecioProducto");
	var descripcion = $(this).parent().parent().parent().children(".descripcion").children().children(".nuevaDescripcionProducto").val();
	var cantidad = $(this).parent().parent().parent().children(".cantidadProducto").children(".nuevaCantidadProducto").val();
	var descuento = $(this).val();
	var factorDescuento = (1 - ($(this).val() / 100));
	var precioFinal = Math.ceil(cantidad * factorDescuento * datosProd['precio_venta']);
	var precioNormal = Math.ceil(cantidad * datosProd['precio_venta']);
	var maxDcto = $(this).attr("max");
	var factorDctoMax = 1 - (Number(maxDcto) / 100);
	var precioDctoMax = Math.ceil(cantidad * factorDctoMax * datosProd['precio_venta']);

	if (Number(descuento) <= Number(maxDcto) && Number(descuento) >= 0) { // si descuento es mayor que 0 y menor al dcto permitido
		precio.val(precioFinal);
	}else if (Number(descuento) > Number(maxDcto)) {
		audioError("Descuento máximo para " + descripcion + " es del " + maxDcto + "%");
		$(this).val(Number(maxDcto));
		precio.val(precioDctoMax);
	}else if (Number(descuento) < 0) {
		$(this).val(0);
		precio.val(precioNormal);
	}

	listarProductos();
	calcularVuelto();
	calcTD();
	calcTC();

})

/*=============================================
MODIFICAR CANTIDAD
=============================================*/

$(".formularioVenta").on("change", "input.nuevaDescripcionProducto", function() {
	listarProductos();
	$('.nuevoMetodoPago').val(''); // RESET METODO PAGO
	$('.cajasMetodoPago').html(''); // RESET METODO PAGO
})



/*==============================================
MODIFICAR PRECIO A PRODUCTOS SIN MANEJO DE STOCK
==============================================*/
$(".formularioVenta").on("change", "input.nuevoPrecioProducto", function(){
	$(this).attr('pEditado',$(this).val()); // si se cambia precio de flete, interes, etc. Se modifica atributo pEditado
	listarProductos();
	$('.nuevoMetodoPago').val(''); // RESET METODO PAGO
	$('.cajasMetodoPago').html(''); // RESET METODO PAGO
})

/*-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
$('.tablaVentas tbody').on('dblclick', '.detalleDespacho', function(){
	var idVenta = $(this).attr('idVenta');
	var datos = new FormData();
	datos.append("datosVenta", idVenta);
	$.ajax({
		url: "ajax/ventas.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(rVenta) {
			var datosFlete = rVenta['detalle_flete'];
			var nombreContacto = datosFlete.split(' // ')[0];
			var nroContacto = datosFlete.split(' // ')[1];
			var direccionContacto = datosFlete.split(' // ')[2];
            
            $('#detalleDespacho'+idVenta).html(
                'Nombre'+
                '<input type="text" style="width:150px" class="form-control input-xs nombreContacto" id="nombreContacto'+idVenta+'" placeholder="Nro Guía"'+
                ' value="'+nombreContacto+'"><div style="height:3px"></div>'+
                'Nro Contacto'+
                '<input type="text" style="width:150px" class="form-control input-xs nroContacto" placeholder="Nro Contacto" '+
                'onkeypress="return soloNumeros(event)" value="'+nroContacto+'"><div style="height:3px"></div>'+
                'Direccion Entrega'+
                '<input type="text" style="width:150px" class="form-control input-xs direccionContacto" placeholder="Nro Contacto" '+
                ' value="'+direccionContacto+'"><div style="height:3px"></div>'+
                '<button style="width:60%" class="btn btn-info btn-sm editarDespacho input-seguido" idVenta="'+idVenta+'"><font size="-1">Actualizar</font></button>'+
                '<button style="width:30%" class="btn btn-danger btn-sm cancelarDetalleDespacho" idVenta="'+idVenta+'"><i class="fa fa-times"></i></button>');
            $('#nombreContacto'+idVenta).select();
		}
	})
})

/*=============================================
CANCELAR CAMBIO MONTO COMRPOMISO
=============================================*/
$(".tablaVentas tbody").on("click", ".cancelarDetalleDespacho", function(){

	var idVenta = $(this).attr('idVenta');
	var datos = new FormData();
	datos.append("datosVenta", idVenta);
	$.ajax({
		url: "ajax/ventas.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(rVenta) {
			var datosFlete = rVenta['detalle_flete'];
            $('#detalleDespacho'+idVenta).html('<font size=\"-1\" idVenta=\"'+idVenta+'\" class=\"detalleDespacho\" id=\"detalleDespacho'+idVenta+'\">Despacho:<br><b>'+datosFlete+'</b></font>');
		}
	})
})
/*=============================================
ACTUALIAR CAMBIO MONTO COMRPOMISO
=============================================*/
$(".tablaVentas tbody").on("click", ".editarDespacho", function(){
    var idVenta = $(this).attr('idVenta');
    var nombreContacto = $(this).parent().children('.nombreContacto').val();
    var nroContacto = $(this).parent().children('.nroContacto').val();
    var direccionContacto = $(this).parent().children('.direccionContacto').val();
    var datosFlete = nombreContacto.toUpperCase()+' // '+nroContacto+' // '+direccionContacto.toUpperCase();
    var datos = new FormData();
    datos.append("editarDespacho", idVenta);
    datos.append("nombreContacto", nombreContacto);
    datos.append("nroContacto", nroContacto);
    datos.append("direccionContacto", direccionContacto);
    $.ajax({
        url: "ajax/ventas.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        success: function(r){
	        if(r == 'ok'){
	            audioSuccess('Datos Despacho Actualizados con éxito')
	            $('#detalleDespacho'+idVenta).html('<font size=\"-1\" idVenta=\"'+idVenta+'\" class=\"detalleDespacho\" id=\"detalleDespacho'+idVenta+'\">Despacho:<br><b>'+datosFlete+'</b></font>');
	        }
        }
    })
})


/*=============================================
CAMBIAR PAGO (MENU QUE PERMITE CAMBIAR)
=============================================*/
$('.tablaVentas tbody').on('click', 'button.btnCambiarPago', function(){
	$(this).tooltip('hide');
  	var idVenta = $(this).attr('codigoVenta');
  	var total = $(this).attr('total');
	var datos = new FormData();
	datos.append("datosVenta", idVenta);
	$.ajax({
		url: "ajax/ventas.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(rVenta) {
			if(rVenta['tipo_pago'] == 'Fiado'){ // VERIFICA QUE NO ESTÉ CON CREDITO INTERNO (NO SE PUEDE HACER DIRECTAMENTE EN TABLA VENTAS)
			    var audio = new Audio('componentes/sonidos/error.wav');
			    audio.play();
			    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'No se puede modificar el metodo de pago'});
			}else{
				$('#metPago'+idVenta).html(
			        '<div class="col-xs-12" style="padding-right:0px; padding-left:0px">'+
			            '<select class="form-control input-sm metodoPagoCambiarPago" total="'+total+'" idVenta="'+idVenta+'" id="metodoPagoCambiarPago" name="metodoPagoCambiarPago" required>'+
			                '<option value="">Método</option>'+
			            	'<option value="Efectivo">Efectivo</option>'+
			            	'<option value="Transferencia">Transferencia</option>'+
			            	'<option value="TC">Tarjeta Crédito</option>'+
			            	'<option value="TD">Tarjeta Débito</option>'+
			            	'<option value="E_TD">Efectivo + TD</option>'+
			            	'<option value="E_TC">Efectivo + TC</option>'+
			          	'</select>'+
			        '</div>'+
			        '<div class="cajasCambiarPago'+idVenta+'"></div>');
				$('#metodoPagoCambiarPago').focus();
			}
		}
	})
})

//SELECCIONAR MÉTODO CAMBIO DE PAGOS
$('.tablaVentas tbody').on('change','#metodoPagoCambiarPago',function(){
	var metodo = $(this).val();
	var idVenta = $(this).attr('idVenta');
	var total = $(this).attr('total');

	if (metodo == "Efectivo") {
		$('.cajasCambiarPago'+idVenta).html(
	        '<br>'+
	        '<font style="font-size:11px">Efectivo</font>'+
	        '<div class="col-xs-12" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm"><i class="fa fa-dollar-sign"></i></span>'+
					'<input type="text" min="1" total="'+total+'" class="form-control input-sm" id="efectivoCambioPagoVista" name="efectivoCambioPagoVista" placeholder="0" required onkeyup="formatoMiles($(this));" onkeypress="return soloNumeros(event)" onchange="sinFormatoMiles('+"'efectivoCambioPago'"+',$(this).val());calcularVuelto2('+total+');"><input type="hidden" id="efectivoCambioPago" name="efectivoCambioPago">' +
				'</div>'+
			'</div>'+
	        '<br>'+
	        '<font style="font-size:11px">Vuelto</font>'+
			'<div class="col-xs-12" id="capturarCambioEfectivo" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm"><i class="fa fa-dollar-sign"></i></span>'+
					'<input type="text" class="form-control input-sm" id="vueltoEfectivoCambioPagoVista" placeholder="0" disabled required><input type="hidden" id="vueltoEfectivoCambioPago" name="vueltoEfectivoCambioPago">'+
				'</div>'+
			'</div>'+
			'<br><br><br>'+
			'<button style="width:100%" class="btn btn-success btn-xs btnCambiarPagoVenta" total="'+total+'" tipoPago="'+metodo+'" idVenta="'+idVenta+'">Actualizar Pago</button>');
	}else if(metodo == 'E_TD'){
		$('.cajasCambiarPago'+idVenta).html(
	        '<br>'+
	        '<font style="font-size:11px">Efectivo</font>'+
	        '<div class="col-xs-12" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm"><i class="fa fa-dollar-sign"></i></span>'+
					'<input type="text" min="1" total="'+total+'" class="form-control input-sm" id="efectivoCombTDCambioPagoVista" placeholder="0" required onkeyup="formatoMiles($(this));" onkeypress="return soloNumeros(event)" onchange="sinFormatoMiles('+"'efectivoCombTDCambioPago'"+',$(this).val());calcTD2('+total+');"><input type="hidden" id="efectivoCombTDCambioPago" name="efectivoCombTDCambioPago">' +
				'</div>'+
			'</div>'+
	        '<br>'+
	        '<font style="font-size:11px">Diferencia Tarjeta</font>'+
			'<div class="col-xs-12" id="diferenciaTDCambioPago" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm"><i class="fa fa-dollar-sign"></i></span>'+
					'<input type="text" class="form-control input-sm" id="vueltoCombTDCambioPagoVista" placeholder="0" disabled required><input type="hidden" id="vueltoCombTDCambioPago" name="vueltoCombTDCambioPago">'+
				'</div>'+
			'</div>'+
	        '<br>'+
	        '<font style="font-size:11px">Código Transacción</font>'+
			'<div class="col-xs-12" id="codigoTDCambioPago" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm">#</span>'+
					'<input type="text" class="form-control input-sm" id="codTransCombTDCambioPago" maxlength="4" placeholder="0" required>'+
				'</div>'+
			'</div>'+
			'<br><br><br>'+
			'<button style="width:100%" class="btn btn-success btn-xs btnCambiarPagoVenta" total="'+total+'" tipoPago="'+metodo+'" idVenta="'+idVenta+'">Actualizar Pago</button>');
	}else if(metodo == 'E_TC'){
		$('.cajasCambiarPago'+idVenta).html(
	        '<br>'+
	        '<font style="font-size:11px">Efectivo</font>'+
	        '<div class="col-xs-12" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm"><i class="fa fa-dollar-sign"></i></span>'+
					'<input type="text" min="1" total="'+total+'" class="form-control input-sm" id="efectivoCombTCCambioPagoVista" placeholder="0" required onkeyup="formatoMiles($(this));" onkeypress="return soloNumeros(event)" onchange="sinFormatoMiles('+"'efectivoCombTCCambioPago'"+',$(this).val());calcTC2('+total+');"><input type="hidden" id="efectivoCombTCCambioPago" name="efectivoCombTCCambioPago">' +
				'</div>'+
			'</div>'+
	        '<br>'+
	        '<font style="font-size:11px">Diferencia Tarjeta</font>'+
			'<div class="col-xs-12" id="diferenciaTCCambioPago" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm"><i class="fa fa-dollar-sign"></i></span>'+
					'<input type="text" class="form-control input-sm" id="vueltoCombTCCambioPagoVista" placeholder="0" disabled required><input type="hidden" id="vueltoCombTCCambioPago" name="vueltoCombTCCambioPago">'+
				'</div>'+
			'</div>'+
	        '<br>'+
	        '<font style="font-size:11px">Código Transacción</font>'+
			'<div class="col-xs-12" id="codigoTCCambioPago" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm">#</span>'+
					'<input type="text" class="form-control input-sm" id="codTransCombTCCambioPago" maxlength="4" placeholder="0" required>'+
				'</div>'+
			'</div>'+
			'<br><br><br>'+
			'<button style="width:100%" class="btn btn-success btn-xs btnCambiarPagoVenta" total="'+total+'" tipoPago="'+metodo+'" idVenta="'+idVenta+'">Actualizar Pago</button>');
	}else if(metodo == 'Transferencia'){
		$('.cajasCambiarPago'+idVenta).html(
	        '<br>'+
	        '<font style="font-size:11px">Monto</font>'+
	        '<div class="col-xs-12" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm"><i class="fa fa-dollar-sign"></i></span>'+
					'<input type="number" min="1" total="'+total+'" class="form-control input-sm" value="'+total+'" id="transferenciaCambioPago" placeholder="0" disabled required>' +
				'</div>'+
			'</div>'+
			'<br><br><br>'+
			'<button style="width:100%" class="btn btn-success btn-xs btnCambiarPagoVenta" total="'+total+'" tipoPago="'+metodo+'" idVenta="'+idVenta+'">Actualizar Pago</button>');
	}else if(metodo == 'TD'){
		$('.cajasCambiarPago'+idVenta).html(
	        '<br>'+
	        '<font style="font-size:11px">Código Transacción</font>'+
	        '<div class="col-xs-12" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm">#</span>'+
					'<input type="text" min="1" total="'+total+'" class="form-control input-sm" maxlength="4" id="codTransTDCambioPago" placeholder="0" required>' +
				'</div>'+
			'</div>'+
			'<br><br><br>'+
			'<button style="width:100%" class="btn btn-success btn-xs btnCambiarPagoVenta" total="'+total+'" tipoPago="'+metodo+'" idVenta="'+idVenta+'">Actualizar Pago</button>');
	}else if(metodo == 'TC'){
		$('.cajasCambiarPago'+idVenta).html(
	        '<br>'+
	        '<font style="font-size:11px">Código Transacción</font>'+
	        '<div class="col-xs-12" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm">#</span>'+
					'<input type="text" min="1" total="'+total+'" class="form-control input-sm" maxlength="4" id="codTransTCCambioPago" placeholder="0" required>' +
				'</div>'+
			'</div>'+
			'<br><br><br>'+
			'<button style="width:100%" class="btn btn-success btn-xs btnCambiarPagoVenta" total="'+total+'" tipoPago="'+metodo+'" idVenta="'+idVenta+'">Actualizar Pago</button>');
	}else if(metodo == 'Fiado'){
		$('.cajasCambiarPago'+idVenta).html(
	        '<br>'+
	        '<font style="font-size:11px">Monto</font>'+
	        '<div class="col-xs-12" style="padding-right:0px; padding-left:0px">'+
				'<div class="input-group">'+
					'<span class="input-group-addon input-sm"><i class="fa fa-dollar-sign"></i></span>'+
					'<input type="number" min="1" total="'+total+'" class="form-control input-sm" value="'+total+'" id="montoCredIntCambioPago" placeholder="0" disabled required>' +
				'</div>'+
			'</div>'+
			'<br><br><br>'+
			'<button style="width:100%" class="btn btn-success btn-xs btnCambiarPagoVenta" total="'+total+'" tipoPago="'+metodo+'" idVenta="'+idVenta+'">Actualizar Pago</button>');
	}
	else{
		$('.cajasCambiarPago'+idVenta).html('');		
	}
})
/*-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

$('.tablaVentas tbody').on('click', 'button.btnCambiarPagoVenta', function(){
  	var datos = new FormData();	
	var metodo = $("#metodoPagoCambiarPago option:selected").val();	
  	var idVenta = $(this).attr('idVenta');
  	var total = $(this).attr('total');
  	datos.append('cambioPago', idVenta);
  	datos.append('tipoPago', $(this).attr('tipoPago'));
  	datos.append('total', total);

	if(metodo == 'Efectivo'){
		datos.append('cash', $('#efectivoCambioPago').val());
		datos.append('vuelto', $('#vueltoEfectivoCambioPago').val());
	}else if(metodo == 'TC'){
		datos.append('codTC', $('#codTransTCCambioPago').val());
	}else if(metodo == 'TD'){
		datos.append('codTD', $('#codTransTDCambioPago').val());
	}else if(metodo == 'E_TC'){
		datos.append('cash', $('#efectivoCombTCCambioPago').val());
		datos.append('montoTC', $('#vueltoCombTCCambioPago').val());
		datos.append('codTCComb', $('#codTransCombTCCambioPago').val());
	}else if(metodo == 'E_TD'){
		datos.append('cash', $('#efectivoCombTDCambioPago').val());
		datos.append('montoTD', $('#vueltoCombTDCambioPago').val());
		datos.append('codTDComb', $('#codTransCombTDCambioPago').val());
	}

	if(metodo == 'Efectivo' && ($('#efectivoCambioPago').val() == 0 || $('#efectivoCambioPago').val() == '' || $('#efectivoCambioPago').val() < Number(total))){
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'El efectivo debe ser mayor o igual a '+formatNumber.new(total)});
		$('#efectivoCambioPago').select();
	}else{
	  	$.ajax({
		 	url:'ajax/ventas.ajax.php',
		  	method: 'POST',
		  	data: datos,
		  	cache: false,
		  	contentType: false,
		  	processData: false,
	     	beforeSend: function(){
			 	$('#metPago'+idVenta).html("<div style='text-align:center'>CAMBIANDO PAGO... <img src='componentes/loading.gif' /></div>"); 
	    	},
		    success:function(r){
		    	resp = r.split(',');
		    	if(resp[1]=='Efectivo'){
		    		$('#metPago'+idVenta).html('<b>Efectivo</b><br>Cash: $ '+formatNumber.new(resp[2].slice(10,-1))+'<br>Total: $ '+formatNumber.new(total)+'<br>Vuelto: $ '+formatNumber.new(resp[4].slice(10,-3)));
		    	}else if(resp[1]=='Transferencia'){
		    		$('#metPago'+idVenta).html('<b>Transferencia</b><br>Monto: $ '+formatNumber.new(resp[2]));
		    	}else if(resp[1]=='TD'){
		    		$('#metPago'+idVenta).html('<b>Tarjeta Debito</b><br>'+resp[2]);
		    	}else if(resp[1]=='TC'){
		    		$('#metPago'+idVenta).html('<b>Tarjeta Credito</b><br>'+resp[2]);
		    	}else if(resp[1]=='E_TD'){
		    		$('#metPago'+idVenta).html('<b>Pago Combinado</b><br>Cash: $ '+formatNumber.new(resp[2].slice(10,-1))+'<br>TD-'+resp[4].slice(7,-3)+' ($ '+formatNumber.new(resp[3].slice(11,-1))+')');
		    	}else if(resp[1]=='E_TC'){
		    		$('#metPago'+idVenta).html('<b>Pago Combinado</b><br>Cash: $ '+formatNumber.new(resp[2].slice(10,-1))+'<br>TC-'+resp[4].slice(7,-3)+' ($ '+formatNumber.new(resp[3].slice(11,-1))+')');
		    	}else if(resp[1]=='Fiado'){
		    		$('#metPago'+idVenta).html('<b>Credito Interno</b><br>Monto: $ '+formatNumber.new(resp[2]));
		    	}
		        var audio = new Audio('componentes/sonidos/success.mp3');
		        audio.play();
		        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'El metodo de pago se modificó exitosamente'});
		    }
		})
	}
})


/*-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

/*=============================================
CALCULO DEL VUELTO EN EFECTIVO
=============================================*/
function calcularVuelto2(total){
	var efectivo = $('#efectivoCambioPago').val();
	var cambio = Number(efectivo) - Number(total);
	if (efectivo == '' || efectivo ==0){
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe ingresar uno monto superor a $ '+ formatNumber.new(total)});
		$('#efectivoCambioPago').select();

	} else if (total > 0 && cambio < 0) {
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Falta Dinero'});
		$('#efectivoCambioPago').val(0);
		$('#vueltoEfectivoCambioPagoVista').val(0);
		$('#efectivoCambioPago').select();
	} else {
		$('#vueltoEfectivoCambioPagoVista').val(formatNumber.new(cambio,"")); // en formato de miles
		$('#vueltoEfectivoCambioPago').val(cambio);
	}
	$('#transferenciaCambioPago').val(total);
	$('#creditoInternoCambioPago').val(total);
}

/*=============================================
CALCULO DEL VUELTO EN EFECTIVO
=============================================*/
function calcularVuelto(){
	var total = $('#totalVenta').val();
	var efectivo = $('#nuevoValorEfectivo').val();
	var cambio = Number(efectivo) - Number(total);
	if (total == 0 && $('#listarProductos').val() == '') {
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe contener productos la Venta'});
	} else if (total > 0 && cambio < 0) {
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Falta Dinero'});
		$('#nuevoCambioEfectivo').val(0);
		$('#nuevoCambioEfectivoVista').val(0);
		$('#nuevoValorEfectivo').val(0);
		$('#nuevoValorEfectivoVista').val(0);
		$('#nuevoCambioEfectivoVista').select();
	} else {
		$('#nuevoCambioEfectivoVista').val(formatNumber.new(cambio,''));
		$('#nuevoCambioEfectivo').val(cambio);
	}
	$('#transferencia').val(total);
	$('#creditoInterno').val(total);
}

/*=============================================
DIFERENCIA PAGO COMBINADO TD CAMBIO PAGO
=============================================*/
function calcTD2(total){
	var efectivo = $('#efectivoCombTDCambioPago').val();
	var cambio = Number(total) - Number(efectivo);
	if (total == 0) {
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe contener productos la Venta'});
	} else if (total > 0 && cambio <= 0) {
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta'});
		$('#efectivoCombTDCambioPagoVista').val(0);
		$('#efectivoCombTDCambioPago').val(0);
		$('#vueltoCombTDCambioPagoVista').val(0);
		$('#vueltoCombTDCambioPago').val(0);
		$('#efectivoCombTDCambioPagoVista').select();
	} else {
		$('#vueltoCombTDCambioPagoVista').val(formatNumber.new(cambio,''));
		$('#vueltoCombTDCambioPago').val(cambio);
	}
}

/*=============================================
DIFERENCIA PAGO COMBINADO TD CAMBIO PAGO
=============================================*/
function calcTC2(total){
	var efectivo = $('#efectivoCombTCCambioPago').val();
	var cambio = Number(total) - Number(efectivo);
	if (total == 0) {
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe contener productos la Venta'});
	} else if (total > 0 && cambio <= 0) {
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta'});
		$('#efectivoCombTCCambioPagoVista').val(0);
		$('#efectivoCombTCCambioPago').val(0);
		$('#vueltoCombTCCambioPagoVista').val(0);
		$('#vueltoCombTCCambioPago').val(0);
		$('#efectivoCombTCCambioPagoVista').select();
	} else {
		$('#vueltoCombTCCambioPagoVista').val(formatNumber.new(cambio,''));
		$('#vueltoCombTCCambioPago').val(cambio);
	}
}


/*=============================================
DIFERENCIA PAGO COMBINADO TD
=============================================*/
function calcTD(){
	var cash = $(".efectivoCombTD");
	var cambio = $("#totalVenta").val() - cash.val();
	var vueltoCombTD = $(".efectivoCombTD").parent().parent().parent().children('#cobrarTD').children().children('#vueltoCombTD');
	if (cambio < 0) {
		Swal.fire({
			title: "El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta",
			icon: "error",
			confirmButtonText: "¡Cerrar!"
		});
		cash.val(0);
	} else {
		vueltoCombTD.val(cambio);
	}
}

/*=============================================
DIFERENCIA PAGO COMBINADO TC
=============================================*/
function calcTC(){
	var cash = $(".efectivoCombTC");
	var cambio = $("#totalVenta").val() - cash.val();
	var vueltoCombTC = $(".efectivoCombTC").parent().parent().parent().children('#cobrarTC').children().children('#vueltoCombTC');
	if (cambio < 0) {
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta'});
		cash.val(0);
	} else {
		vueltoCombTC.val(cambio);
	}
}




/*=============================================
BOTON EDITAR VENTA
=============================================*/
$(".tablaVentas").on("click", ".botonGuardaVenta", function() {
	listarMetodos();
})

/*=============================================
BOTON EDITAR VENTA
=============================================*/
$(".tablaVentas").on("click", ".btnDevProds", function() {
    var id = $(this).attr('codigoVenta');
    var ruta="id="+id;
    window.open("index.php?ruta=dev-prods&"+ruta,"_blank");
})

/*=============================================
ANTES DE INGRESAR VENTA
=============================================*/
function verificarProdsComunes(){
	var descripcion = $(".descProdComun");
	var precio = $(".precioProdComun");
	var cantConflictos = 0;

	for (var i = 0; i < descripcion.length; i++){
		if($(descripcion[i]).val() == '' || $(precio[i]).val() == 0 || $(precio[i]).val() == ''){
			cantConflictos += 1;
		}
	}
	
	if(cantConflictos > 0){
		audioError('Debe completar descripción y precio de los productos comunes');
	}else{
		boletaOFactura($('#nuevoMetodoPago').val())
	}
}

function boletaOFactura(metPago){

	// if(metPago == 'Pend' || metPago == 'Fiado'){
	// 	enviar();
	// }else{

		Swal.fire({
			icon:'question',
		  	title: "<h1>¿Boleta o Factura?</h1>",
		  	showDenyButton: true,
		  	confirmButtonText: 'Boleta',
		  	denyButtonText: 'Factura',
		  	customClass: {
		    	actions: 'my-actions',
		    	cancelButton: 'order-1 right-gap boton-cancelar',
		    	confirmButton: 'order-2 btn boton-confirmar',
		    	denyButton: 'order-3 btn boton-denegar',
		    	title: 'titulo-modif',
		  	}

		}).then((result) => {
		  	if (result.isConfirmed) { // BOLETA

		    	enviar()

		  	} else if (result.isDenied) { // FACTURA

		  		rutFacturarCliente = $('.rutFacturarCliente').val();
				Swal.fire({
			        title: "Rut a Facturar",
			        input: "text",
			        inputValue: rutFacturarCliente,
					inputAttributes: {
					    maxlength: 10,
					    placeholder: 'Formato: 18817715-8',
					    onkeypress: "return soloRut(event)"
					},
			        confirmButtonText: "Ok",
					showCancelButton: true,
					cancelButtonText: 'Cancelar',
			        inputValidator: inputRut => {

						rutDigitado = inputRut.split('-');
						rut = rutDigitado[0].split("").reverse().join("");
						dv = rutDigitado[1];
						multiplicadores = [2,3,4,5,6,7];
						sumaTotal = 0;
					j = 0;
						for (var i = 0; i < rut.length; i++){
						    sumaTotal += Number(rut[i]) * Number(multiplicadores[j]);
						    j = Number(i) == 5 ? 0 : j=j+1;
						}
						dvCalculado = 11-Math.trunc(sumaTotal)%11

						if(Number(dvCalculado) == 11){
							dvComparar = 0;
						}else if(Number(dvCalculado) == 10){
							dvComparar = 'k';
						}else{
							dvComparar = dvCalculado;
						}

						if(dvComparar == dv){
							$('#rutFactura').val(inputRut);
			        		enviar();
						}else{
			        		return "Escriba el rut en el formato: 18817715-8";
						}

			        }
			    })
		  	}
		})
	// }

}

function enviar(){
	var listaProductos = $("#listaProductos").val()
	var metodo = $("#nuevoMetodoPago").val();
	var efectivo = $("#nuevoValorEfectivo").val();
	var efectivoTD = $("#efectivoCombTD").val();
	var efectivoTC = $("#efectivoCombTC").val();
	var codigoTD = $("#codTransCombTD").val();
	var codigoTC = $("#codTransCombTC").val();
	var codigoTarjeta = $("#nuevoCodigoTransaccion").val();
	var vueltoE_TD = $("#vueltoCombTD").val();
	var vueltoE_TC = $("#vueltoCombTC").val();
	var totalVenta = $("#totalVenta").val();
	var transferencia = $("#transferencia").val();
	// comprobar required en detalleVenta
	var requerido = $("#detalleVenta").attr('required');

	if (listaProductos == "[]") {
		Swal.fire({
			icon: "error",
			title: "La venta no se ha ejecuta si no hay productos",
			confirmButtonText: "Cerrar"
		});

	} else if (metodo == "") {
	    var audio = new Audio('componentes/sonidos/error.wav');
	    audio.play();
	    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe elegir algún metodo de pago'});
		$('#nuevoMetodoPago').focus();

	} else {

		if (metodo == "Efectivo" && (efectivo == "" || efectivo == 0)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
		    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese el dinero en efectivo'});
			$("#nuevoValorEfectivo").select();

		} else if ((metodo == "TD" || metodo == "TC") && (codigoTarjeta == "" || codigoTarjeta.length < 4)) {

		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "Falta ingresar los 4 últimos dígitos de la transacción",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "Fiado" && $('#seleccionarCliente').val() == 1) {

		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "Crédito Interno, necesario asignar venta a un Cliente",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "Pend" && ($('#seleccionarCliente').val() == 1 && $('#detalleVenta').val() == '')) {

		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
		    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Asigne algún dato para identificar quién adeuda'});
			$('#detalleVenta').select();


		} else if (metodo == "E_TD" && (efectivoTD == "" && codigoTD.length < 4)) {

		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "Debe ingresar el dinero en efectivo junto con los 4 últimos dígitos de la transacción",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "E_TD" && (efectivoTD == "" && codigoTD.length == 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "Debe ingresar el dinero en efectivo",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "E_TD" && (efectivoTD == 0 && codigoTD.length < 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "El dinero en efectivo tiene que ser mayor que 0 e inferior al valor total, además debe ingresar los 4 últimos dígitos de la transacción",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});
			$("#efectivoCombTD").val(0);
			$("#vueltoCombTD").val(0);

		} else if (metodo == "E_TD" && (efectivoTD == 0 && codigoTD.length == 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "El dinero en efectivo tiene que ser mayor que 0 e inferior al valor total",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "E_TD" && (vueltoE_TD < 0 && codigoTD.length == 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});
			$("#efectivoCombTD").val(0);
			$("#vueltoCombTD").val(0);

		} else if (metodo == "E_TD" && (vueltoE_TD < 0 && codigoTD.length < 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta, además debe ingresar los 4 últimos dígitos de la transacción",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});
			$("#efectivoCombTD").val(0);
			$("#vueltoCombTD").val(0);

		} else if (metodo == "E_TD" && (vueltoE_TD > 0 && codigoTD.length < 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "Debe ingresar los 4 últimos dígitos de la transacción",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "E_TC" && (efectivoTC == "" && codigoTC.length < 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "Debe ingresar el dinero en efectivo junto con los 4 últimos dígitos de la transacción",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "E_TC" && (efectivoTC == "" && codigoTC.length == 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "Debe ingresar el dinero en efectivo",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "E_TC" && (efectivoTC == 0 && codigoTC.length < 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "El dinero en efectivo tiene que ser mayor que 0 e inferior al valor total, además debe ingresar los 4 últimos dígitos de la transacción",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});
			$("#efectivoCombTC").val(0);
			$("#vueltoCombTC").val(0);

		} else if (metodo == "E_TC" && (efectivoTC == 0 && codigoTC.length == 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "El dinero en efectivo tiene que ser mayor que 0 e inferior al valor total",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "E_TC" && (vueltoE_TC < 0 && codigoTC.length == 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});
			$("#efectivoCombTC").val(0);
			$("#vueltoCombTC").val(0);

		} else if (metodo == "E_TC" && (vueltoE_TC < 0 && codigoTC.length < 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "El efectivo pagado debe ser menor al valor total. Recordar que la diferencia se va a pagar con tarjeta, además debe ingresar los 4 últimos dígitos de la transacción",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});
			$("#efectivoCombTC").val(0);
			$("#vueltoCombTC").val(0);

		} else if (metodo == "E_TC" && (vueltoE_TC > 0 && codigoTC.length < 4)) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "Debe ingresar los 4 últimos dígitos de la transacción",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "Transferencia" && transferencia == "") {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "ERROR",
				text: "Debe ingresar el Valor Transferido",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "Transferencia" && transferencia < totalVenta) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "ERROR",
				text: "El Valor Transferido no puede ser inferior al Total de la Venta",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else if (metodo == "Transferencia" && transferencia > totalVenta) {
		    var audio = new Audio('componentes/sonidos/error.wav');
		    audio.play();
			Swal.fire({
				title: "ERROR",
				text: "El Valor Transferido no puede ser superior al Total de la Venta. ESTE METODO NO ACEPTA DAR VUELTO",
				icon: "error",
				confirmButtonText: "¡Cerrar!"
			});

		} else {

			if($('.incluyeFlete').val() == 1){ // DETECTA FLETE PARA FLETE
				nombreDespacho = infoCliente($('#seleccionarCliente').val())['id']==1 ? '' : infoCliente($('#seleccionarCliente').val())['nombre'].toUpperCase()+' '+infoCliente($('#seleccionarCliente').val())['apellido'].toUpperCase();
				nroDespacho = infoCliente($('#seleccionarCliente').val())['id']==1 ? '' : infoCliente($('#seleccionarCliente').val())['telefono'];
				direccionDespacho = infoCliente($('#seleccionarCliente').val())['id']==1 ? '' : infoCliente($('#seleccionarCliente').val())['direccion'];

				(async () => {

					const { value: formValues } = await Swal.fire({
					  title: 'Datos Despacho',
					  html:
					    '<input id="swal-input1" class="swal2-input" placeholder="Nombre" maxlength="30" value="'+nombreDespacho+'">' +
					    '<input id="swal-input2" class="swal2-input" placeholder="Fono (Ej: 938714443)" maxlength="9" value="'+nroDespacho+'">' +
					    '<input id="swal-input3" class="swal2-input" placeholder="Dirección" maxlength="50" value="'+direccionDespacho+'">',
					  focusConfirm: false,
					  preConfirm: () => {
					    return [
					      $('#swal-input1').val(),
					      $('#swal-input2').val(),
					      $('#swal-input3').val()
					    ]
					  }
					})

					if (formValues) {
						$('.detalleFlete').val(formValues[0]+' // '+formValues[1]+' // '+formValues[2]);
						listarMetodos();
						cliente();
						document.forms[0].submit();
					}

				})()

			}else{ // SI NO DETECTA FLETE
				$('.detalleFlete').val('');
				listarMetodos();
				cliente();
				document.forms[0].submit();
			}

		}
	}
}

/*=============================================
LISTAR MÉTODO DE PAGO
=============================================*/
function listarMetodos(){

	var listaMetodos = "";
	var metodo = $("#nuevoMetodoPago").val();
	
	if (metodo == "Efectivo") {
		var totalSinRedondeo = $("#totalVenta").val();
		var resto = totalSinRedondeo % 10;
		if (resto < 6) {
			var totalRedondeado = totalSinRedondeo - resto;
			var vueltoRedondeado = $("#nuevoValorEfectivo").val() - totalRedondeado;
		} else {
			var totalRedondeado = Number(totalSinRedondeo) + 10 - Number(resto);
			var vueltoRedondeado = $("#nuevoValorEfectivo").val() - totalRedondeado;
		}
		$('#listaMetodoPago').val('[{"cash":"' + $('#nuevoValorEfectivo').val() + '","total":"' + totalRedondeado + '","vuelto":"' + vueltoRedondeado + '"}]');
	} else if (metodo == 'E_TD') {
		$('#listaMetodoPago').val('[{"cash":"' + $('#efectivoCombTD').val() + '","tarjeta":"' + $('#vueltoCombTD').val() + '","cod":"' + $('#codTransCombTD').val() + '"}]');
	} else if (metodo == 'E_TC') {
		$('#listaMetodoPago').val('[{"cash":"' + $('#efectivoCombTC').val() + '","tarjeta":"' + $('#vueltoCombTC').val() + '","cod":"' + $('#codTransCombTC').val() + '"}]');
	} else if (metodo == "TC") {
		$("#listaMetodoPago").val(metodo + "-" + $("#nuevoCodigoTransaccion").val());
	} else if (metodo == "TD") {
		$("#listaMetodoPago").val(metodo + "-" + $("#nuevoCodigoTransaccion").val());
	} else if (metodo == "Transferencia") {
		$("#listaMetodoPago").val($("#transferencia").val());
	} else if (metodo == "Fiado") {
		$("#listaMetodoPago").val($('#creditoInterno').val());
		// $('#fiadoVenta').val($('#creditoInterno').val());
	} else if (metodo == "Pend") {
		$("#listaMetodoPago").val($("#pendiente").val());
	} else {
		// $('#fiadoVenta').val('');
	}
}

/*=============================================
NOMBRE CLIENTE
=============================================*/
function cliente() {
	cliente = $("#seleccionarCliente option:selected").text().split(' [')[0]; // CORTA CUPO DISPONIBLE PARA CLIENTES CON CREDITO INTERNO
	$("#nomClient").val(cliente);
}

/*=============================================
BOTON EDITAR VENTA
=============================================*/
$(".tablaVentas,.tablaVentasMovil").on("click", ".btnEditarVenta", function() {
	var idVenta = $(this).attr("idVenta");
	window.open("index.php?ruta=editar-venta&idVenta=" + idVenta,"_blank");
})

/*=============================================
FUNCIÓN PARA DESACTIVAR LOS BOTONES AGREGAR CUANDO EL PRODUCTO YA HABÍA SIDO SELECCIONADO EN LA CARPETA
=============================================*/
function quitarAgregarProducto() {

	//Capturamos todos los id de productos que fueron elegidos en la venta
	var idProductos = $(".quitarProducto");

	//Capturamos todos los botones de agregar que aparecen en la tabla
	var botonesTabla = $(".tablaVentaProductos tbody button.agregarProducto");

	//Recorremos en un ciclo para obtener los diferentes idProductos que fueron agregados a la venta
	for (var i = 0; i < idProductos.length; i++) {

		//Capturamos los Id de los productos agregados a la venta
		var boton = $(idProductos[i]).attr("idProducto");

		//Hacemos un recorrido por la tabla que aparece para desactivar los botones de agregar
		for (var j = 0; j < botonesTabla.length; j++) {

			if ($(botonesTabla[j]).attr("idProducto") == boton) {

				$(botonesTabla[j]).removeClass("btn-primary agregarProducto");
				$(botonesTabla[j]).addClass("btn-default");

			}
		}

	}

}

/*========================================================================
CADA VEZ QUE CARGUE LA TABLA CUANDO NAVEGAMOS EN ELLA EJECUTAR LA FUNCIÓN:
========================================================================*/
$('.tablaVentaProductos').on('draw.dt', function() {

	quitarAgregarProducto();

})


/*=============================================
BORRAR VENTA
=============================================*/
$(".tablaVentas,.tablaVentasMovil").on("click", ".btnEliminarVenta", function() {

	var idVenta = $(this).attr("idVenta");
	Swal.fire({
		icon: 'question',
		title: '¿Está seguro de borrar la venta?',
		text: "¡Si no lo está puede cancelar la accíón!",
		type: 'warning',
		showCancelButton: true,
		confirmButtonColor: '#3085d6',
		cancelButtonColor: '#d33',
		cancelButtonText: 'Cancelar',
		confirmButtonText: 'Si, borrar venta!'
	}).then(function(result1) {
		if(result1.value){
			Swal.fire({
				icon: 'info',
				title: 'Motivo de la Eliminación?',
				input: 'text',
			  	inputPlaceholder: 'Describa el motivo',

				type: 'warning',
				showCancelButton: true,
				confirmButtonColor: '#3085d6',
				cancelButtonColor: '#d33',
				cancelButtonText: 'Cancelar',
				confirmButtonText: 'Si, borrar venta!'
			}).then(function(result2) {
				if(result2.value && result2.value != ''){
					var datos = new FormData();
					datos.append("infoEliminacionVenta", idVenta);
					datos.append("motivoEliminacion", result2.value);
					$.ajax({
						url: "ajax/ventas.ajax.php",
						method: "POST",
						data: datos,
						cache: false,
						contentType: false,
						processData: false,
						dataType: "json"
					})
					window.location = "index.php?ruta="+ventana+"&idVenta=" + idVenta;
				}else{
				    var audio = new Audio('componentes/sonidos/error.wav');
				    audio.play();
				    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe indicar el motivo de la Eliminación'});
				}
			})
		}
	})
})



/*=============================================
VER VENTA FORMATO CARTA
=============================================*/
$(".tablaVentas,.tablaVentasMovil").on("click", ".btnImprimirVentaCarta", function(){
	var codigoVenta = $(this).attr("codigoVenta");
	window.open("extensiones/tcpdf/pdf/boleta-carta.php?codigo=" + codigoVenta+"&motivo=ver", "_blank");
})

$(".tablaVentas,.tablaVentasMovil").on("click", ".btnVenta58mm", function(){
	var codigoVenta = $(this).attr("codigoVenta");
	window.open("extensiones/tcpdf/pdf/boleta-58mm.php?codigo=" + codigoVenta+"&motivo=ver", "_blank");
})

/*=============================================
DESCARGAR VENTA PDF
=============================================*/
$(".tablaVentas").on("click", ".btnDescargaVenta", function(){
	var codigoVenta = $(this).attr("codigoVenta");
	window.open("extensiones/tcpdf/pdf/boleta-carta.php?codigo="+codigoVenta+"&motivo=descarga", "_blank");
})

$(".tablaVentas").on("click", ".btnNoReimprimirTicket", function(){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Muchos items en la compra, debe imprimir por otro medio'});
})

/*=============================================
RANGO DE FECHAS
=============================================*/

$('#daterange-btn').daterangepicker({
		ranges: {
			'Hoy': [moment(), moment()],
			'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
			'Últimos 7 días': [moment().subtract(6, 'days'), moment()],
			'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
			'Este mes': [moment().startOf('month'), moment().endOf('month')],
			'Último mes': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
		},
		startDate: moment(),
		endDate: moment()
	},
	function(start, end) {
		$('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));

		var fechaInicial = start.format('YYYY-MM-DD');

		var fechaFinal = end.format('YYYY-MM-DD');

		var capturarRango = $("#daterange-btn span").html();

		localStorage.setItem("capturarRango", capturarRango);

		window.location = "index.php?ruta=ventas&fechaInicial=" + fechaInicial + "&fechaFinal=" + fechaFinal;

	}

)

/*=============================================
CANCELAR RANGO DE FECHAS
=============================================*/
$(".daterangepicker.opensleft .range_inputs .cancelBtn").on("click", function() {
	localStorage.removeItem("capturarRango");
	localStorage.clear();
	window.location = "ventas";
})

/*=============================================
CAPTURAR HOY
=============================================*/

$(".daterangepicker.opensleft .ranges li").on("click", function() {

	var textoHoy = $(this).attr("data-range-key");

	if (textoHoy == "Hoy") {

		var d = new Date();

		var dia = d.getDate();
		var mes = d.getMonth() + 1;
		var año = d.getFullYear();

		// if(mes < 10){

		// 	var fechaInicial = año+"-0"+mes+"-"+dia;
		// 	var fechaFinal = año+"-0"+mes+"-"+dia;

		// }else if(dia < 10){

		// 	var fechaInicial = año+"-"+mes+"-0"+dia;
		// 	var fechaFinal = año+"-"+mes+"-0"+dia;

		// }else if(mes < 10 && dia < 10){

		// 	var fechaInicial = año+"-0"+mes+"-0"+dia;
		// 	var fechaFinal = año+"-0"+mes+"-0"+dia;

		// }else{

		// 	var fechaInicial = año+"-"+mes+"-"+dia;
		//    	var fechaFinal = año+"-"+mes+"-"+dia;

		// }

		dia = ("0" + dia).slice(-2);
		mes = ("0" + mes).slice(-2);

		var fechaInicial = año + "-" + mes + "-" + dia;
		var fechaFinal = año + "-" + mes + "-" + dia;

		localStorage.setItem("capturarRango", "Hoy");

		window.location = "index.php?ruta=ventas&fechaInicial=" + fechaInicial + "&fechaFinal=" + fechaFinal;

	}

})

/*=============================================
ABRIR ARCHIVO XML EN NUEVA PESTAÑA
=============================================*/
$(".abrirXML").click(function() {
	var archivo = $(this).attr("archivo");
	window.open(archivo, "_blank");
})

