
const context = new window.AudioContext();

function playSuccess() {
    const successNoise = context.createOscillator();
    successNoise.frequency = "600";
    successNoise.type = "sine";
    successNoise.frequency.exponentialRampToValueAtTime(
        800,
        context.currentTime + 0.05
    );
    successNoise.frequency.exponentialRampToValueAtTime(
        1000,
        context.currentTime + 0.15
    );

    successGain = context.createGain();
    successGain.gain.exponentialRampToValueAtTime(
        0.01,
        context.currentTime + 0.3
    );

    successFilter = context.createBiquadFilter("bandpass");
    successFilter.Q = 0.01;

    successNoise
        .connect(successFilter)
        .connect(successGain)
        .connect(context.destination);
    successNoise.start();
    successNoise.stop(context.currentTime + 0.2);
}

function playError() {
    const errorNoise = context.createOscillator();
    errorNoise.frequency = "400";
    errorNoise.type = "sine";
    errorNoise.frequency.exponentialRampToValueAtTime(
        500,
        context.currentTime + 0.05
    );
    errorNoise.frequency.exponentialRampToValueAtTime(
        100,
        context.currentTime + 0.2
    );

    errorGain = context.createGain();
    errorGain.gain.exponentialRampToValueAtTime(
        0.01,
        context.currentTime + 0.3
    );

    errorNoise.connect(errorGain).connect(context.destination);
    errorNoise.start();
    errorNoise.stop(context.currentTime + 0.3);
}