function copiarTexto(texto) {
    let elemento = document.createElement("div");
    elemento.innerText = texto;
    elemento.setAttribute("contenteditable", "true");
    document.body.appendChild(elemento);

    let rango = document.createRange();
    rango.selectNodeContents(elemento);
    let seleccion = window.getSelection();
    seleccion.removeAllRanges();
    seleccion.addRange(rango);

    document.execCommand("copy");
    seleccion.removeAllRanges();
    document.body.removeChild(elemento);
}

function reemplazarEspacios(texto){
    texto = texto.replace(/\s+/g, ' '); // Reemplazar múltiples espacios por un solo espacio
    texto = texto.replace(/\u00A0/g, ' '); // Reemplazar el carácter de espacio no separable por un espacio regular
    return texto;
}

/*====================================================================================
IMAGEN PRODUCTO MODAL
====================================================================================*/
$(document).on("click", "img.imagenZoom", function() {
	let idProd = $(this).attr("idProducto");
	$("#imagenZoomModal").attr("src", infoProd(idProd)["imagen"]);
	$("#tituloModalZoom").text(infoProd(idProd)["descripcion"]);
})


/*====================================================================================
NUMEROS CON SEPARACION DE MILES CON PUNTO (UTILIZAR: formatNumber.new(NUMERO, "$ "))
====================================================================================*/
var formatNumber = {
	separador: ".", // separador para los miles
	sepDecimal: ',', // separador para los decimales
	formatear: function(num) {
		num += '';
		var splitStr = num.split('.');
		var splitLeft = splitStr[0];
		var splitRight = splitStr.length > 1 ? this.sepDecimal + splitStr[1] : '';
		var regx = /(\d+)(\d{3})/;
		while (regx.test(splitLeft)) {
			splitLeft = splitLeft.replace(regx, '$1' + this.separador + '$2');
		}
		return this.simbol + splitLeft + splitRight;
	},
	new: function(num, simbol) {
		this.simbol = simbol || '';
		return this.formatear(num);
	}
}


function validarEmail(inputEmail) {
    const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if(regex.test(inputEmail.val())){
		$(inputEmail).addClass('is-valid');
		$(inputEmail).removeClass('is-invalid');
	}else{
		$(inputEmail).addClass('is-invalid');
		$(inputEmail).removeClass('is-valid');
    }
    
    // return regex.test(email);
}

function esDispositivoMovil() {
  return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
}

/* *******************************************************************
CONTROL CONEXION IMPRESORA TERMICA
******************************************************************* */
const checkboxImpresora = document.querySelector('.checkboxImpresora')
checkboxImpresora.addEventListener('change', (e) => {
	var datos = new FormData();
  	if (e.target.checked) {
  		$('#conexionImpresoraTermica').val(1);
	  	datos.append("conexionImpresoraTermica", 1);
		$.ajax({
	  		type: "POST",
	  		cache: false,
	  		contentType: false,
	  		processData: false,
	  		data: datos,
			url:"ajax/usuarios.ajax.php",
	      	success:function(r){
				$('.imprimirUltimoTicketCabecera').addClass('d-lg-block'); // ocultar imprimir ultimo ticket
				$('.imprimirTicketVenta').removeClass('d-none'); // ocultar imprimir ultimo ticket
				$('.imprimirTicketCot').removeClass('d-none'); // ocultar imprimir ultimo ticket
				$('.imprimirTicket').removeClass('d-none'); // ocultar imprimir ultimo ticket

	      		const Toast = Swal.mixin({
					toast: true,
					position: 'top-start',
					showConfirmButton: false,
					timer: 1000,
					timerProgressBar: true,
					didOpen: (toast) => {
				    	toast.addEventListener('mouseenter', Swal.stopTimer)
				    	toast.addEventListener('mouseleave', Swal.resumeTimer)
				  	}
				})
				Toast.fire({
				  	icon: 'success',
				  	title: 'Conectado a Impresora'
				})
	      	}
	    })
  	} else {
  		$('#conexionImpresoraTermica').val(0);
	  	datos.append("conexionImpresoraTermica", 0);
		$.ajax({
	  		type: "POST",
	  		cache: false,
	  		contentType: false,
	  		processData: false,
	  		data: datos,
			url:"ajax/usuarios.ajax.php",
	      	success:function(r){
				$('.imprimirUltimoTicketCabecera').removeClass('d-lg-block'); // ocultar imprimir ultimo ticket
				$('.imprimirTicketVenta').addClass('d-none'); // ocultar imprimir ultimo ticket
				$('.imprimirTicketCot').addClass('d-none'); // ocultar imprimir ultimo ticket
				$('.imprimirTicket').addClass('d-none'); // ocultar imprimir ultimo ticket

	      		const Toast = Swal.mixin({
					toast: true,
					position: 'top-start',
					showConfirmButton: false,
					timer: 1000,
					timerProgressBar: true,
					didOpen: (toast) => {
				    	toast.addEventListener('mouseenter', Swal.stopTimer)
				    	toast.addEventListener('mouseleave', Swal.resumeTimer)
				  	}
				})
				Toast.fire({
				  	icon: 'info',
				  	title: 'Desconectado a Impresora'
				})
	      	}
	    })
  	}
})
/* **************************************************************** */

$(document).on('change',".eliminarCaracteresEspeciales",function(){
	let textoReemplazado = reemplazarTildes($(this).val());
	$(this).val(textoReemplazado);
})

function reemplazarTildes(texto) {
  	var letrasSinTilde = {
		'Ã':'A','À':'A','Á':'A','Ä':'A','Â':'A',
		'È':'E','É':'E','Ë':'E','Ê':'E',
		'Ì':'I','Í':'I','Ï':'I','Î':'I',
		'Ò':'O','Ó':'O','Ö':'O','Ô':'O',
		'Ù':'U','Ú':'U','Ü':'U','Û':'U',
		'ã':'a','à':'a','á':'a','ä':'a','â':'a',
		'è':'e','é':'e','ë':'e','ê':'e',
		'ì':'i','í':'i','ï':'i','î':'i',
		'ò':'o','ó':'o','ö':'o','ô':'o',
		'ù':'u','ú':'u','ü':'u','û':'u',
		'Ñ':'N','ñ':'n','Ç':'C','ç':'c',
		',':'.','"':' ','{':' ','}':' ',':':'.',';':'.'
  	};

  	return texto.replace(/[ÃÀÁÄÂÈÉËÊÌÍÏÎÒÓÖÔÙÚÜÛãàáäâèéëêìíïîòóöôùúüûÑñÇç,{}:;]/g, function(letra) {
    	return letrasSinTilde[letra];
  	});
}

function formatearMilesJSON(numero) {
  return numero.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
}

function infoProd(id) {
	var datos = new FormData();
	datos.append("idProducto", id);
	$.ajax({
	    async: false,
		url:"ajax/productos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(r1){
			respuesta = r1;
		}
	})
	return respuesta;
}



function infoProv(id) {
	var datos = new FormData();
	datos.append("idProveedor", id);
	$.ajax({
	    async: false,
		url:"ajax/proveedores.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(r1){
			respuesta = r1;
		}
	})
	return respuesta;
}

function infoCliente(id) {
	var datos = new FormData();
	datos.append("idCliente", id);
	$.ajax({
	    async: false,
		url:"ajax/clientes.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(r1){
			respuesta = r1;
		}
	})
	return respuesta;
}

// function audioTitTexError(titulo,texto){
// 	new Audio('componentes/sonidos/error.wav').play();
// 	Swal.fire({
// 	  	icon: 'error',
// 	  	html: '<b>CI Bloqueado</b><br>ADEUDA: <b>'+formatNumber.new(datosCliente['deuda_cliente'],'$')+'</b>',
// 	  	footer: '<a href="extensiones/tcpdf/pdf/historial-cliente-resumen.php?id='+datosCliente['id']+'" target="_blank">Ver Deuda</a>'
// 	})
// }



function audioSuccess(texto){
	new Audio('componentes/sonidos/success.mp3').play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: texto});
}

function audioInfo(texto){
	new Audio('componentes/sonidos/info1.mp3').play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: texto});
}

function audioError(texto){
	new Audio('componentes/sonidos/error.wav').play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: texto});
}

function mixinSuccess(texto){
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: texto});
}

function mixinInfo(texto){
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'info',title: texto});
}

function mixinWarning(texto){
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'warning',title: texto});
}

function mixinError(texto){
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: texto});
}


function audioMarioCoin(){
	new Audio('componentes/sonidos/mario-coin.mp3').play();
}

function obtenerGET(pagina){
	const url = new URL(pagina);
	const searchParams = url.searchParams;
	const keys = [...searchParams.keys()];
	const get = keys
	  .reduce((obj, key) =>({...obj, [key]: searchParams.get(key) }), {})
	return get;
}




function obtenerPAGINA_y_GET(pagina) {
    const url = new URL(pagina);
    const pathname = url.pathname.split('/').pop(); // Obtener la parte del pathname
    const searchParams = url.searchParams;
    const keys = [...searchParams.keys()];
    const get = keys.reduce((obj, key) => ({ ...obj, [key]: searchParams.get(key) }), {});
    return {
        pagina: pathname,
        gets: get
    };

    // ej.
    // obtener pagina: "obtenerPAGINA_y_GET(window.location).pagina"
    // obtener get: "obtenerPAGINA_y_GET(window.location).gets['get_especifico']"
}

// ENTER PARA ENVIAR WHATSAPP
$("#nroWhatsappCualquiera").keypress(function(e) {
	if(e.which == 13) {
		if($(this).val().length == 9 && $(this).val().charAt(0) == 9){
			$('#enviarWhatsappCualquiera').click()
		}else{
			var audio = new Audio('componentes/sonidos/error.wav');
    		audio.play();
    		Swal.mixin({toast: true,position: 'top-end',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Formato Erroneo<br>Formato: 938714443'});
		}
	}
});

// FOCUS EN BUSCADOR SELECT2
$(document).on('select2:open', () => { 
	document.querySelector('.select2-search__field').focus();
});


// MOSTRAR TOOLTIP
$('.info').mouseover(function(){
    $(this).tooltip('show');
})
  // $('[data-original-title]').tooltip();  // OTRA FORMA DE HACER APARECER EL TOOLTIP

$('.info').click(function(){
    $(this).tooltip('hide');	
})

// function mayor_que(seteado,ingresado,idInput){
// 	// ingresado2 = ingresado.replace('.','');
// 	// if(Number(ingresado2) < Number(seteado)){
// 	// 	audioError('El valor mínimo es: '+formatNumber.new(seteado));
// 	// 	$('#'+idInput).val(seteado);
// 	// 	$('#'+idInput+'Vista').val(formatNumber.new(seteado));
// 	// }
// }


// MOSTRAR (TOOLTIP)
$(".table").on("mouseover", ".info", function(){
    $(this).tooltip('show');
})

// OCULTAR (TOOLTIP) CUANDO SE ESCRIBE
$('.table').on('search.dt', function(e){
	$('.info').tooltip('hide');
});

// OCULTAR (TOOLTIP)
$(".table").on("click", ".info", function(){
    $(this).tooltip('hide');
})
// MOSTRAR BOTONES EN DATATABLE
if($('#perfilVend').val() == 'Administrador'){
  botonesDT = '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>';
}else{
  botonesDT = '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>';
}

var perfil = $('#perfilVend').val();


// validar RUT
function validarRut(a){
	rutDigitado = a.split('-');
	rut = rutDigitado[0].split("").reverse().join("");
	dv = rutDigitado[1];
	multiplicadores = [2,3,4,5,6,7];
	sumaTotal = 0;
	j = 0;
	for (var i = 0; i < rut.length; i++){
	    sumaTotal += Number(rut[i]) * Number(multiplicadores[j]);
	    j = Number(i) == 5 ? 0 : j=j+1;
	}
	dvCalculado = 11-Math.trunc(sumaTotal)%11

	if(Number(dvCalculado) == 11){
		dvComparar = 0;
	}else if(Number(dvCalculado) == 10){
		dvComparar = 'k';
	}else{
		dvComparar = dvCalculado;
	}


	if(dvComparar == 0 && dv == ''){
		return 'rutErroneo';
	}else if(dvComparar != dv){
		return 'rutErroneo';
	}else{
		return 'rutOk';
	}
}


function verificaRut(input){
	var resp = validarRut(input.val());
	// console.log(resp)
	if(input.val() == '' || resp == 'rutOk'){
		$('#btnAsignarRut').removeAttr('disabled');
		$(input).addClass('is-valid');
		$(input).removeClass('is-invalid');
	}else if(resp == 'rutErroneo'){
		$('#btnAsignarRut').attr('disabled','disabled');
		$(input).addClass('is-invalid');
		$(input).removeClass('is-valid');
	}
}


// EXTRAER AJUSTE
function ajuste(ajuste) {
	var datos = new FormData();
	datos.append("tipo_ajuste", ajuste);
	$.ajax({
	    async: false,
		url:"ajax/ajustes.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(r1){
			respuesta = r1['ajuste'];
		}
	})
	return respuesta;
}

// COPIAR DESDE BASE DE DATOS
// async function copiarAlPortapapeles(item) {
//   try {
//     await navigator.clipboard.writeText(item);
//     Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Copia Exitosa'});
//   } catch (err) {
//     Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Copia Fallida', html: 'Error:'+err});
//   }
// }

/*------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// reemplazar caracteres complicados
var elimCaracteresMalos = (function() {
  var from = "ÃÀÁÄÂÈÉËÊÌÍÏÎÒÓÖÔÙÚÜÛãàáäâèéëêìíïîòóöôùúüûÑñÇç,'", 
      to   = "AAAAAEEEEIIIIOOOOUUUUaaaaaeeeeiiiioooouuuunncc. ",
      mapping = {};
 
  for(var i = 0, j = from.length; i < j; i++ )
      mapping[ from.charAt( i ) ] = to.charAt( i );
 
  return function( str ) {
      var ret = [];
      for( var i = 0, j = str.length; i < j; i++ ) {
          var c = str.charAt( i );
          if( mapping.hasOwnProperty( str.charAt( i ) ) )
              ret.push( mapping[ c ] );
          else
              ret.push( c );
      }      
      return ret.join( '' ).replace('*','').replace('"','').replace('\n','.').replace(/(\r\n|\r|\n)/g, '. ').replace(/<|>|=|;|/g,'');;
  }
})();

/*------------------------------------------------------------------------------------------------------------------------------------------------------------*/

// //CERRAR TOASTR CUANDO SE HAGA CLICK AFUERA DE ÉL
// $(document).click(function(event){ 
//     if(!$(event.target).closest('.cerrarToastr2').length){
//         if($('.cerrarToastr2').is(":visible")){
//             $('.cerrarToastr2').click();
//         }
//     }
// });

// // OPCIONES TOASTR2
// toastr2.options = 	{
// 						'closeButton': true,
// 						'debug': false,
// 						'newestOnTop': true,
// 						'progressBar': false,
// 						'positionClass': 'toast-top-center',
// 						'preventDuplicates': false,
// 						'showDuration': null,
// 						'hideDuration': null,
// 						'timeOut': null,
// 						'extendedTimeOut': null,
// 						'showEasing': 'swing',
// 						'hideEasing': 'linear',
// 						'showMethod': 'fadeIn',
// 						'hideMethod': 'fadeOut',
// 					}
      
// // POSICION TOASTR
// toastr.options.positionClass = "toast-top-center"; // alertas toastr en parte superior central


/*------------------------------------------------------------------------------------------------------------------------------------------------------------*/


var ventana = window.location.pathname.split('/')[2];
if(ventana=='index.php'){
	var getVentana = window.location.search.split('&');
	var ventana = getVentana[0].substring(6);
}else{
	var ventana = window.location.pathname.split('/')[2];
}


function cambiarSucursal(){
	var ventana = $('#ventanaActual').val();
	var suc = $("#sucursalAdmin").val();
	var datos = new FormData();
	datos.append("cambioSucursal", suc);
	$.ajax({
		url: "ajax/sucursales.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		success: function(){
			speak(suc);         
			window.location = ventana;
		}
	})
}



function cambiarSucursalMovil(sucursalCambio){
	var ventana = $('#ventanaActual').val();
	var datos = new FormData();
	datos.append("cambioSucursal", sucursalCambio);
	$.ajax({
		url: "ajax/sucursales.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		success: function(){
			window.location = ventana;
		}
	})
}

function cambiarPerfil(){
	var ventana = $('#ventanaActual').val();
	var user = $("#perfilUser").val();
	var datos = new FormData();
	datos.append("cambioPerfil", user);
	$.ajax({
		url: "ajax/usuarios.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		success: function(r){
			window.location = ventana;
		}
	})
}


function formatoMiles(input){ // recibe el input completo --> $(this). CON ESTO SE PUEDE HACER DINAMICO A CUALQUIER INPUT TIPO TEXTO LLAMANDO A LA FUNCION EN EL INPUT --> onkeyup='formatoMiles($(this));'
	numero = input.val().replace(/\./g,'').toString().split('').reverse().join('').replace(/(?=\d*\.?)(\d{3})/g,'$1.').split('').reverse().join('').replace(/^[\.]/,'');
	input.val(numero);
}

function sinFormatoMiles(input, valor){ // TRAPASO A INPUT PARA ENVIARLO A BASE DE DATOS
	$('#'+input).val(valor.replace(/\./g,''));
}



// SEPARADOR DE MILES
$(".miles").on("keyup", function() {
	var num = $(this).val().replace(/\./g,'');
	if(!isNaN(num)){
	num = num.toString().split('').reverse().join('').replace(/(?=\d*\.?)(\d{3})/g,'$1.');
	num = num.split('').reverse().join('').replace(/^[\.]/,'');
	$(this).val(num);
	}
})


// $(document).on('mouseover', '.info', function(){
//     $(this).tooltip('show');
// });


/*=============================================
SideBar Menu
=============================================*/

// $('.brand-link').tree()

/*=====================================================
CLASE ACTIVE EN MENU LATERAL
=====================================================*/
$(document).ready(function(){
	sumarTotalesVentaCot();
	localStorage.clear();

	// // CLASS ACTIVE EN MENU LATERAL
	// if(ventanaActual == 'movimientos-dia' || ventanaActual == 'cerrar-dia'){
	// 	$('#pag-movimientos').addClass('active');
	// }else if(ventanaActual == 'registro-compra-config' || ventanaActual == 'pag-abast-bodega-local'){
	// 	$('#pag-compras').addClass('active');
	// }else if(ventanaActual == 'categorias-admin' || ventanaActual == 'subcategorias-admin'){
	// 	$('#pag-categorias').addClass('active');
	// }else if(ventanaActual == 'productos-faltantes'){
	// 	$('#pag-productos').addClass('active');		
	// }else if(ventanaActual == 'cotizaciones'){
	// 	$('#pag-cotizador').addClass('active');		
	// }else if(ventanaActual == 'crear-venta' || ventanaActual == 'reportes'){
	// 	$('#pag-ventas').addClass('active');		
	// }else{
	// 	$('#pag-'+ventanaActual).addClass('active');
	// }

});


/*=============================================
Data Table
=============================================*/
$(".tablas").DataTable({

	"language": {

		"sProcessing":     "Procesando...",
		"sLengthMenu":     "Mostrar _MENU_ registros",
		"sZeroRecords":    "No se encontraron resultados",
		"sEmptyTable":     "Ningún dato disponible en esta tabla",
		"sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
		"sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
		"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
		"sInfoPostFix":    "",
		"sSearch":         "Buscar (F3):",
		"sUrl":            "",
		"sInfoThousands":  ",",
		"sLoadingRecords": "Cargando...",
		"oPaginate": {
		"sFirst":    "Primero",
		"sLast":     "Último",
		"sNext":     "Siguiente",
		"sPrevious": "Anterior"
		},
		"oAria": {
			"sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		}

	}

});

$(".dataTable100").DataTable({
// "searching": false,
    "deferRender": true,
    "retrieve": true,
    "processing": true,
    "pageLength": 100,

	"language": {
		"sProcessing":     "Procesando...",
		"sLengthMenu":     "Mostrar _MENU_ registros",
		"sZeroRecords":    "No se encontraron resultados",
		"sEmptyTable":     "Ningún dato disponible en esta tabla",
		"sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
		"sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
		"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
		"sInfoPostFix":    "",
		"sSearch":         "Buscar (F3):",
		"sUrl":            "",
		"sInfoThousands":  ",",
		"sLoadingRecords": "Cargando...",
		"oPaginate": {
		"sFirst":    "Primero",
		"sLast":     "Último",
		"sNext":     "Siguiente",
		"sPrevious": "Anterior"
		},
		"oAria": {
			"sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		}

	}

});

$(".tablas25").DataTable({
	// "order": [[ 2, "asc" ]], //orden descendente por defecto
    "deferRender": true,
    "retrieve": true,
    "processing": true,
    "pageLength": 25,

	"language": {
		"sProcessing":     "Procesando...",
		"sLengthMenu":     "Mostrar _MENU_ registros",
		"sZeroRecords":    "No se encontraron resultados",
		"sEmptyTable":     "Ningún dato disponible en esta tabla",
		"sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
		"sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
		"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
		"sInfoPostFix":    "",
		"sSearch":         "Buscar (F3):",
		"sUrl":            "",
		"sInfoThousands":  ",",
		"sLoadingRecords": "Cargando...",
		"oPaginate": {
		"sFirst":    "Primero",
		"sLast":     "Último",
		"sNext":     "Siguiente",
		"sPrevious": "Anterior"
		},
		"oAria": {
			"sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		}

	}

});

/*=============================================
 //iCheck for checkbox and radio inputs
=============================================*/
$('input[type="checkbox"].minimal, input[type="radio"].minimal').iCheck({
  checkboxClass: 'icheckbox_minimal-blue',
  radioClass   : 'iradio_minimal-blue'
})

/*=============================================
 //input Mask
=============================================*/
//Datemask dd/mm/yyyy
$('#datemask').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' })
//Datemask2 mm/dd/yyyy
$('#datemask2').inputmask('mm/dd/yyyy', { 'placeholder': 'mm/dd/yyyy' })
//Money Euro
$('[data-mask]').inputmask()

/*=============================================
CORRECCIÓN BOTONERAS OCULTAS BACKEND	
=============================================*/
if(window.matchMedia("(max-width:767px)").matches){
	
	$("body").removeClass('sidebar-collapse');

}else{

	$("body").addClass('sidebar-collapse');
}

/*=============================================
TECLAS PERMITIDAS EN INPUTS	
=============================================*/
function soloFecha(event) {
	if ((event.charCode >= 47 && event.charCode <= 57) || event.charCode == 45) {
		return true;
	}
	return false;
}

/*=============================================
TECLAS RUT	
=============================================*/
function soloRut(event) {
	if ((event.charCode >= 48 && event.charCode <= 57) || event.charCode == 45 || event.charCode == 75 || event.charCode == 107) {
		return true;
	}
	return false;
}

/*=============================================
SOLO NUMEROS
=============================================*/
function soloNumeros(event) {
    if(event.charCode >= 48 && event.charCode <= 57 || (event.charCode == 44 || event.charCode == 46)){
        return true;
    }
    return false;        
}



/*=============================================
SOLO CELULAR
=============================================*/
function soloEnteros(event) {
    if(event.charCode >= 48 && event.charCode <= 57){
        return true;
    }
    return false;        
}



function actualizarTabla(){
	$('.table').DataTable().clear().draw();
	$('.table').DataTable().ajax.reload();
}