$("#monedaMov").on("change", function(){
  let moneda = $(this).val();
  if(moneda == 'td' || moneda == 'tc'){
    $('.divCodigoTarjeta').removeClass('d-none');
  }else{
    $('.divCodigoTarjeta').addClass('d-none');
  }
})

$("#btnModifMov").on("click", function(){
  var idMov = $(this).attr('idMov');
  var datos = new FormData();
  datos.append("modifMov", idMov);
  datos.append("fechaCont", $('#fechaContMov').val());
  datos.append("moneda", $('#monedaMov').val());
  datos.append("codTransaccion", $('#codTrans').val());

  $.ajax({
    type: "POST",
    cache: false,
    contentType: false,
    processData: false,
    data: datos,
    url:"ajax/movimientos.ajax.php",
    success:function(resp){
      audioSuccess('Movimiento modificado exitosamente');
      $('#editarMovimiento').modal('hide');
      actualizarTabla();
    }
  })
})

$(".tablaMovimientos,.tablaMovimientosMovil").on("click", ".btnEditarMovimiento", function(){
  var idMov = $(this).attr('idMov');
  var datos = new FormData();
  datos.append("datosMov", idMov);
  $.ajax({
    type: "POST",
    cache: false,
    contentType: false,
    processData: false,
    data: datos,
    url:"ajax/movimientos.ajax.php",
    dataType: "json",
    success:function(resp){
      $('#btnModifMov').attr('idMov',resp['id']);
      $('#fechaContMov').val(resp['fecha_cont']);
      $('#responsableMov').val(resp['nom_user']);
      $('#detalleMov').val(resp[25]['detalle_traducido']);
      $('#monedaMov').val(resp['moneda']);
      
      if(resp['moneda'] == 'td' || resp['moneda'] == 'tc'){
        $('.divCodigoTarjeta').removeClass('d-none');
        $('#codTrans').val(resp['detalle'].substring(3));
      }else{
        $('.divCodigoTarjeta').addClass('d-none');
        $('#codTrans').val('');
      }

      if(Number(resp['cargo']) == 0){ // abono
        $('#montoMov').val(formatNumber.new(resp['abono']));
      }else{
        $('#montoMov').val(formatNumber.new(resp['cargo']));
      }
    }
  })    
})

var ventana = window.location.pathname.split('/')[2];

$(".tablaMovimientos,.tablaMovimientosMovil").on("click", ".btnEliminarMovimiento", function(){
  var idMov  = $(this).attr('idMov');
  Swal.fire({
    icon:'question',
    title: "<h5>Seguro eliminarás el movimiento ID: "+idMov+"?</h5>",
    showDenyButton: true,
    confirmButtonText: 'Si',
    denyButtonText: 'Cancelar',
    customClass: {
    actions: 'my-actions',
    cancelButton: 'order-1 right-gap boton-cancelar',
    confirmButton: 'order-2 btn boton-confirmar',
    denyButton: 'order-3 btn boton-denegar',
    }
  }).then((result) => {
    if (result.isConfirmed) {
      var datos = new FormData();
      datos.append("eliminarMov", idMov);
      $.ajax({
        type: "POST",
        cache: false,
        contentType: false,
        processData: false,
        data: datos,
        url:"ajax/movimientos.ajax.php",
        success:function(resp){
          if(resp=='ok'){
            Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'info',title: 'Movimiento Eliminado'});
            $('.tablaMovimientos').DataTable().ajax.reload();
          }

        }
      })    
    } else if (result.isDenied) {
      resolve();
    }
    actualizarTabla();
  })
})


$('#ingresos').click(function(){
  $('#restoTipoIngreso2').html('')
  $('#restoTipoIngreso3').html('')
  $('#restoTipoIngreso4').html('')
  $('#restoTipoIngreso5').html('')
})

/*=============================================
CARGAR TABLAS DATATABLE
=============================================*/
$('.tablaMovimientosMovil').DataTable( {
    "ajax": "ajax/datatable-movimientos-movil.ajax.php?ventana="+ventana,
    "order": [[ 1, "desc" ],[ 0, "desc" ]], //orden por defecto
    "deferRender": true,
    "retrieve": true,
    "processing": true,
    "pageLength": 100,
    "responsive": true,

    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "&rarr;",
        "sPrevious": "&larr;"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }

    },


    dom: '<"row"<"col-12"><"col-8"f><"col-4"B>>t<"row"<"col-12 col-6"p>>',
    buttons:
    [
      { //Botón para PDF
        extend: 'pdf',
        footer: true,
        title: 'Archivo PDF',
        filename: 'Movimientos',
        text: '<button class="btn btn-sm bg-orange info" data-original-title="Exportar a PDF" data-placement="bottom"><i class="far fa-file-pdf texto-bco"></i></button>'
      }
    ]
});

$('.tablaMovimientos').DataTable({
  "ajax": "ajax/datatable-movimientos.ajax.php?ventana="+ventana,
  "order": [[ 1, "desc" ],[ 0, "desc" ]], //orden por defecto
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 100,
  "responsive": true,
  "language": {
    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  },
  dom: botonesDT,
  buttons:
    [
      { //Botón para Excel
        extend: 'excel',
        footer: true,
        title: 'Archivo',
        filename: ventana,
        text: '<button class="btn btn-sm btn-success info" data-original-title="Exportar a Excel" data-placement="bottom"><i class="fas fa-file-excel"></i></button>'
      },
      { //Botón para PDF
        extend: 'pdf',
        footer: true,
        title: 'Archivo PDF',
        filename: ventana,
        text: '<button class="btn btn-sm bg-orange info" data-original-title="Exportar a PDF" data-placement="bottom"><i class="far fa-file-pdf texto-bco"></i></button>'
      },
      { //Botón para Copiar Tabla
        extend: 'copy',
        text: '<button class="btn btn-sm bg-olive info" data-original-title="Copiar Tabla" data-placement="bottom"><i class="fa-solid fa-clipboard"></i></button>'
      },
      { //Botón para Imprimir
        extend: 'print',
        text: '<button class="btn btn-sm bg-teal info" data-original-title="Imprimir" data-placement="bottom"><i class="fa-solid fa-print"></i></i></button>'
      },


      { //Vista de columas
        extend: 'colvis',
        footer: true,
        text: '<button class="btn btn-sm bg-lightblue info" data-original-title="Vista Columnas" data-placement="bottom"><i class="fa-solid fa-eye"></i></button>'
      }
    ]
    ,
    columnDefs: [ // oculta la columna que quieras por defecto
        {
            targets: [10],
            // targets: 9,
            visible: false
        }
    ]
});


$('.tablaCuentaCorriente').DataTable({
  "ajax": "ajax/datatable-cuenta-corriente.ajax.php",
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 10,
  "responsive": true,
  "language": {

    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  },
  dom: botonesDT,
  buttons:
    [
      { //Botón para Excel
        extend: 'excel',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<button class="btn btn-sm btn-success info" data-original-title="Exportar a Excel" data-placement="bottom"><i class="fas fa-file-excel"></i></button>'
      },
      { //Botón para PDF
        extend: 'pdf',
        footer: true,
        title: 'Archivo PDF',
        filename: 'Export_File_pdf',
        text: '<button class="btn btn-sm bg-orange info" data-original-title="Exportar a PDF" data-placement="bottom"><i class="far fa-file-pdf texto-bco"></i></button>'
      },
      { //Botón para Copiar Tabla
        extend: 'copy',
        text: '<button class="btn btn-sm bg-olive info" data-original-title="Copiar Tabla" data-placement="bottom"><i class="fa-solid fa-clipboard"></i></button>'
      },
      { //Botón para Imprimir
        extend: 'print',
        text: '<button class="btn btn-sm bg-teal info" data-original-title="Imprimir" data-placement="bottom"><i class="fa-solid fa-print"></i></i></button>'
      },
      { //Vista de columas
        extend: 'colvis',
        footer: true,
        text: '<button class="btn btn-sm bg-lightblue info" data-original-title="Vista Columnas" data-placement="bottom"><i class="fa-solid fa-eye"></i></button>'
      }
    ]
});


/*====================================================
REQUERIR CAMPOS SI SE PAGA A TRABAJADOR EN CIERRE CAJA
====================================================*/
$('#pagTrabCierre').change(function(){
  if($('#pagTrabCierre').val()!=0){
    $('#detPagTrabCierre').attr('required','required');
    $('#montoPagTrabCierre').attr('required','required');
    $('#detPagTrabCierre').removeAttr('disabled');
    $('#montoPagTrabCierre').removeAttr('disabled');
  }else{
    $('#detPagTrabCierre').removeAttr('required');
    $('#montoPagTrabCierre').removeAttr('required');    
    $('#detPagTrabCierre').attr('disabled','disabled');
    $('#montoPagTrabCierre').attr('disabled','disabled');
    $('#detPagTrabCierre').val('');
    $('#montoPagTrabCierre').val('');

}
})



/*==================================================
RETIRO CF AJAX
==================================================*/
$("#registrarRetiroCF").click(function(){
  $(this).attr('disabled','disabled');
  var retCajaEf = $('#retCajaEf').val();
  if(retCajaEf == 0 || retCajaEf == '' || isNaN(retCajaEf) == true){  
    $('#registrarRetiroCF').removeAttr('disabled');
    var audioError = new Audio('componentes/sonidos/error.wav');
    audioError.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debes ingresar un monto correcto'})    
  }else{
    var datos = new FormData();
    datos.append('retCajaEf', retCajaEf);
    $.ajax({
      url: 'ajax/movimientos.ajax.php',
      method: 'POST',
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      beforeSend: function(){
        $('.spinerCarga').html('<div class="overlay"><i class="fas fa-2x fa-sync fa-spin"></i></div>');
      },
      success: function(r){
        if(r == 'ok'){
          $('#retCajaEf').val('');
          $('#retCajaEfVista').val('');
          $('.spinerCarga').html('');
          $('#registrarRetiroCF').removeAttr('disabled');
          $('#modalRetCaja').modal('hide');
          var audioSuccess = new Audio('componentes/sonidos/success.mp3');
          audioSuccess.play();
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 10000}).fire({icon: 'success',title: 'Retiro Caja Fuerte Exitoso por $'+formatNumber.new(retCajaEf)});
        }else{
          $('.spinerCarga').html('<div class="overlay"><i class="fas fa-2x fa-sync fa-spin"></i></div>');
        }
      }
    })
  } 
})


/*==================================================
RETIRO DEPOSITO BANCARIO AJAX
==================================================*/
$("#registrarDepositoBancario").click(function(){
  var depositoBanco = $('#depositoBancario').val();
  if(depositoBanco == 0 || depositoBanco == '' || isNaN(depositoBanco) == true){  
    audioError('Debes ingresar un monto correcto');    
  }else{
    var datos = new FormData();
    datos.append('depositoBanco', depositoBanco);
    $.ajax({
      url: 'ajax/movimientos.ajax.php',
      method: 'POST',
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      beforeSend: function(){
        $('.spinerCarga').html('<div class="overlay"><i class="fas fa-2x fa-sync fa-spin"></i></div>');
      },
      success: function(r){
        if(r == 'ok'){
          $('#depositoBancarioVista').val('');
          $('.spinerCarga').html('');
          $('#modalDepositoBanco').modal('hide');
          audioSuccess('Deposito registrado Exitosamente');
        }else{
          $('.spinerCarga').html('<div class="overlay"><i class="fas fa-2x fa-sync fa-spin"></i></div>');
        }
      }
    })
  } 
})

/*=============================================
REGISTRAR EGRESO DINERO
=============================================*/
$("#registrarEgreso").click(function(){
  var audioSuccess = new Audio('componentes/sonidos/success.mp3');
  var audioError = new Audio('componentes/sonidos/error.wav');

  var fechaEgresoCaja = $('#fechaEgresoCaja').val();
  var tipoEgreso  = $('#tipoEgreso').val();
  if(tipoEgreso != 0){
    var pagFlete = $('#pagFlete').val();
    var proveedor_select_pago = $('#proveedor_select_pago').val();
    var facturaNro = $('#facturaNro').val();
    var montoFactura = $('#montoFactura').val();
    var pagoTrabajador = $('#pagoTrabajador').val();
    var pagTrab = $('#pagTrab').val();
    var detPago = $('#detPago').val();
    var detJobs = $('#detJobs').val();
    var pagJobs = $('#pagJobs').val();
    var socio = $('#socio').val();
    var retSocio = $('#retSocio').val();
    var detRetiroSocio = $('#detRetiroSocio').val();
    var propina = $('#propina').val();
    var detOtroEgreso = $('#detOtroEgreso').val();
    var montoOtroEgreso = $('#montoOtroEgreso').val();
    var detActiv = $('#detActiv').val();
    var pagActiv = $('#pagActiv').val();
    var detMant = $('#detMant').val();
    var pagMant = $('#pagMant').val();
    var prestamo = $('#prestamo').val();
    var detPrestamo = $('#detPrestamo').val();
    var deudor = $('#deudor').val();
    var detDcto = $('#detDcto').val();
    var montoDcto = $('#montoDcto').val();
    var cliente_dcto = $('#cliente_dcto').val();
    var deudaDcto = $('#deudaDcto').val();
    var detDev = $('#detDev').val();
    var montoDev = $('#montoDev').val();
    var cliente_devolucion = $('#cliente_devolucion').val();
    var deudaDev = $('#deudaDev').val();

    var datos = new FormData();
    datos.append('fechaEgresoCaja', fechaEgresoCaja);
    datos.append('tipoEgreso', tipoEgreso);
    if(tipoEgreso == 1){ // pago proveedor
      datos.append('proveedor_select_pago', proveedor_select_pago);
      datos.append('facturaNro', facturaNro);
      datos.append('montoFactura', montoFactura);
    }else if(tipoEgreso == 2){
      datos.append('pagoTrabajador',pagoTrabajador);
      datos.append('pagTrab', pagTrab);
      datos.append('detPago', detPago);
    }else if(tipoEgreso == 3){ // retiro socio
      datos.append('socio', socio);
      datos.append('retSocio', retSocio);
      datos.append('detRetiroSocio',detRetiroSocio);
    }else if(tipoEgreso == 4){ // pago flete
      datos.append('pagFlete', pagFlete);
    }else if(tipoEgreso == 5){ // propina
      datos.append('propina', propina);
    }else if(tipoEgreso == 6){ // otro egreso
      datos.append('detOtroEgreso', detOtroEgreso);
      datos.append('montoOtroEgreso', montoOtroEgreso);
    }else if(tipoEgreso == 8){ // pago activo
      datos.append('detActiv', detActiv);
      datos.append('pagActiv', pagActiv);
    }else if(tipoEgreso == 9){ // pago mantencion activo
      datos.append('detMant', detMant);
      datos.append('pagMant', pagMant);
    }else if(tipoEgreso == 12){ // prestamo tercero
      datos.append('prestamo', prestamo);
      datos.append('detPrestamo', detPrestamo);
      datos.append('deudor', deudor);
    }else if(tipoEgreso == 13){ // pago trabajadores
      datos.append('detJobs', detJobs);
      datos.append('pagJobs', pagJobs);
    }else if(tipoEgreso == 14){ // pago reparaciones
      datos.append('detDcto', detDcto);
      datos.append('montoDcto', montoDcto);
      datos.append('cliente_dcto', cliente_dcto);
      datos.append('deudaDcto', deudaDcto);
    }else if(tipoEgreso == 15){ // pago reparaciones
      datos.append('detDev', detDev);
      datos.append('montoDev', montoDev);
      datos.append('cliente_devolucion', cliente_devolucion);
      datos.append('deudaDev', deudaDev);
    }

    $.ajax({
      url: 'ajax/movimientos.ajax.php',
      method: 'POST',
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      beforeSend: function(){
        $('.spinerCarga').html('<div class="overlay"><i class="fas fa-2x fa-sync fa-spin"></i></div>');
      },
      success: function(resp){
        r = resp.split(',');
        if(r[0] == 'ok'){
          $('#tipoEgreso').val(0);
          $('#restoTipoEgreso1').html('')
          $('#restoTipoEgreso2').html('')
          $('#restoTipoEgreso3').html('')
          $('.spinerCarga').html('');
          $('#modalEgresos').modal('hide');
          audioSuccess.play();
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 3000}).fire({icon: 'success',title: r[1]})
          if(ventana == 'movimientos' || ventana == 'movimientos-all' || ventana == 'movimientos-dia' || ventana == 'movimientos-all-movil' || ventana == 'movimientos-dia-movil' || ventana == 'movimientos-movil'){
            actualizarTabla();
          }
        }else{
          $('.spinerCarga').html('<div class="overlay"><i class="fas fa-2x fa-sync fa-spin"></i></div>');
        }
      }
    })
  }else{
    audioError.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debes completar el formulario'})    
  }    
})

/*=============================================
REGISTRAR INGRESO DINERO
=============================================*/
$("#registrarIngreso").click(function(){
  var audioSuccess = new Audio('componentes/sonidos/success.mp3');
  var audioError = new Audio('componentes/sonidos/error.wav');

  var fechaIngresoCaja = $('#fechaIngresoCaja').val();
  var tipoIngreso  = $('#tipoIngreso').val();

  if(tipoIngreso != 0){
    var metodoPagoAbonoIngresos = $('#metodoPagoAbonoIngresos').val();
    var abonoEfectivo = $('#abonoEfectivo').val();
    var abonoTransferencia = $('#abonoTransferencia').val();
    var abonoTD = $('#abonoTD').val();
    var codigoTD = $('#codigoTD').val();
    var abonoTC = $('#abonoTC').val();
    var codigoTC = $('#codigoTC').val();
    var cliente_select_deuda = $('#cliente_select_deuda').val();
    var deudaCliente = $('#deudaCliente').val();

    var anticipoEfectivo = $('#anticipoEfectivo').val();
    var anticipoTransferencia = $('#anticipoTransferencia').val();
    var anticipoTC = $('#anticipoTC').val();
    var codigoTC = $('#codigoTC').val();
    var anticipoTD = $('#anticipoTD').val();
    var codigoTD = $('#codigoTD').val();
    var deudaClienteAnticipo = $('#deudaClienteAnticipo').val();
    var metPagoAnticipo = $('#metPagoAnticipo').val();
    var cliente_anticipo = $('#cliente_anticipo').val();

    var aporteCaja = $('#aporteCaja').val();

    var detOtroIngreso = $('#detOtroIngreso').val();
    var montoOtroIngreso = $('#montoOtroIngreso').val();

    var detFlete = $('#detFlete').val();
    var montFlete = $('#montFlete').val();

    var detApCap = $('#detApCap').val();
    var montApCap = $('#montApCap').val();

    var deudorPrest = $('#deudorPrest').val();
    var abPrest = $('#abPrest').val();


    var datos = new FormData();
    datos.append('fechaIngresoCaja', fechaIngresoCaja);
    datos.append('tipoIngreso', tipoIngreso);

    if(tipoIngreso == 1){ // abono cliente
      datos.append('metodoPagoAbonoIngresos', metodoPagoAbonoIngresos);
      if(metodoPagoAbonoIngresos == 'ef'){
        datos.append('abonoEfectivo', abonoEfectivo);
      }else if(metodoPagoAbonoIngresos == 'transf'){
        datos.append('abonoTransferencia', abonoTransferencia);
      }else if(metodoPagoAbonoIngresos == 'td'){
        datos.append('abonoTD', abonoTD);
        datos.append('codigoTD', codigoTD);
      }else if(metodoPagoAbonoIngresos == 'tc'){
        datos.append('abonoTC', abonoTC);
        datos.append('codigoTC', codigoTC);
      }
      datos.append('cliente_select_deuda', cliente_select_deuda);
      datos.append('deudaCliente', deudaCliente);
    }else if(tipoIngreso == 10){ // anticipo cliente
      datos.append('metPagoAnticipo', metPagoAnticipo);
      if(metPagoAnticipo == 'ef'){
        datos.append('anticipoEfectivo', anticipoEfectivo);
      }else if(metPagoAnticipo == 'transf'){
        datos.append('anticipoTransferencia', anticipoTransferencia);
      }else if(metPagoAnticipo == 'td'){
        datos.append('anticipoTD', anticipoTD);
        datos.append('codigoTD', codigoTD);
      }else if(metPagoAnticipo == 'tc'){
        datos.append('anticipoTC', anticipoTC);
        datos.append('codigoTC', codigoTC);
      }
      datos.append('cliente_anticipo', cliente_anticipo);
      datos.append('deudaClienteAnticipo', deudaCliente);
    }else if(tipoIngreso == 2){ // aporte caja
      datos.append('aporteCaja', aporteCaja);
    }else if(tipoIngreso == 5){ // otro ingreso
      datos.append('detOtroIngreso', detOtroIngreso);
      datos.append('montoOtroIngreso', montoOtroIngreso);
    }else if(tipoIngreso == 6){ // ingreso por flete
      datos.append('detFlete', detFlete);
      datos.append('montFlete', montFlete);
    }else if(tipoIngreso == 8){ // ingreso por flete
      datos.append('detApCap', detApCap);
      datos.append('montApCap', montApCap);
    }else if(tipoIngreso == 9){ // ingreso por flete
      datos.append('deudorPrest', deudorPrest);
      datos.append('abPrest', abPrest);
    }

    $.ajax({
      url: 'ajax/movimientos.ajax.php',
      method: 'POST',
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      beforeSend: function(){
        $('.spinerCarga').html('<div class="overlay"><i class="fas fa-2x fa-sync fa-spin"></i></div>');
      },
      success: function(resp){
        r = resp.split(',');
        if(r[0] == 'ok' && $('#conexionImpresoraTermica').val() == 1 && esDispositivoMovil() == false && (tipoIngreso == 1 || tipoIngreso == 10)){
          Swal.fire({
            icon:"question",
            title: "<h1>¿Imprimir Ticket?</h1>",
            showDenyButton: true,
            confirmButtonText: "SI",
            denyButtonText: "NO",
            customClass: {
              actions: "my-actions",
              cancelButton: "order-1 right-gap boton-cancelar",
              confirmButton: "order-2 btn boton-confirmar",
              denyButton: "order-3 btn boton-denegar",
              title: "titulo-modif",
            }
          }).then((result) => {
            if (result.isConfirmed) {
              if(Number(tipoIngreso) == 1){
                infoAbono = ultimoAbono('abClient');
                imprimirTicketAbono(infoAbono['id'],infoAbono['fecha'],infoAbono['sucursal'],infoAbono['nom_user'],infoAbono['id_client'],infoAbono['nom_client'],infoAbono['abono'],infoAbono['detalle'],$('#deudaCliente').val(),infoAbono['tipo_mov'])
              }else if(Number(tipoIngreso) == 10){
                infoAbono = ultimoAbono('anticipoClient');
                imprimirTicketAbono(infoAbono['id'],infoAbono['fecha'],infoAbono['sucursal'],infoAbono['nom_user'],infoAbono['id_client'],infoAbono['nom_client'],infoAbono['abono'],infoAbono['detalle'],$('#deudaClienteAnticipo').val(),infoAbono['tipo_mov'])
              }
              $('#tipoIngreso').val(0);

              $('.abonoClienteIngresos1').addClass('d-none');      
              $('.anticipoClienteIngresos1').addClass('d-none');
              $('.aporteCajaIngresos1').addClass('d-none');
              $('.otroIngresos1').addClass('d-none');
              $('.fleteIngresos1').addClass('d-none');
              $('.aporteCapitalIngresos1').addClass('d-none');

              $('.cliente_select_deuda').val(0).trigger('change');
              $('.cliente_anticipo').val(0).trigger('change');
              $('#aporteCaja').val('');
              $('#aporteCajaVista').val('');
              $('#detApCap').val('');
              $('#detFlete').val('');
              $('#detOtroIngreso').val('');

              $('.spinerCarga').html('');
              $('#modalIngresos').modal('hide');
              audioSuccess.play();
              Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 3000}).fire({icon: 'success',title: r[1]})


            } else if (result.isDenied) {
              Swal.close();
              $('#tipoIngreso').val(0);

              $('.abonoClienteIngresos1').addClass('d-none');      
              $('.anticipoClienteIngresos1').addClass('d-none');
              $('.aporteCajaIngresos1').addClass('d-none');
              $('.otroIngresos1').addClass('d-none');
              $('.fleteIngresos1').addClass('d-none');
              $('.aporteCapitalIngresos1').addClass('d-none');

              $('.cliente_select_deuda').val(0).trigger('change');
              $('.cliente_anticipo').val(0).trigger('change');
              $('#aporteCaja').val('');
              $('#aporteCajaVista').val('');
              $('#detApCap').val('');
              $('#detFlete').val('');
              $('#detOtroIngreso').val('');

              $('.spinerCarga').html('');
              $('#modalIngresos').modal('hide');
              audioSuccess.play();
              Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 3000}).fire({icon: 'success',title: r[1]})

            }
          })

        }else{

          $('#tipoIngreso').val(0);

          $('.abonoClienteIngresos1').addClass('d-none');      
          $('.anticipoClienteIngresos1').addClass('d-none');
          $('.aporteCajaIngresos1').addClass('d-none');
          $('.otroIngresos1').addClass('d-none');
          $('.fleteIngresos1').addClass('d-none');
          $('.aporteCapitalIngresos1').addClass('d-none');

          $('.cliente_select_deuda').val(0).trigger('change');
          $('.cliente_anticipo').val(0).trigger('change');
          $('#aporteCaja').val('');
          $('#aporteCajaVista').val('');
          $('#detApCap').val('');
          $('#detFlete').val('');
          $('#detOtroIngreso').val('');

          $('.spinerCarga').html('');
          $('#modalIngresos').modal('hide');
          audioSuccess.play();
          Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 3000}).fire({icon: 'success',title: r[1]})
        }
        if(ventana == 'movimientos' || ventana == 'movimientos-all' || ventana == 'movimientos-dia' || ventana == 'movimientos-all-movil' || ventana == 'movimientos-dia-movil' || ventana == 'movimientos-movil'){
          actualizarTabla();
        }
      }
    })
  }else{
    audioError.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 1000}).fire({icon: 'error',title: 'Debes completar el formulario'})
  }
})

function ultimoAbono(tipoAbono) {
  var datos = new FormData();
  datos.append("ultimoAbono", tipoAbono);
  $.ajax({
    async: false,
    url:"ajax/movimientos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(r1){
      respuesta = r1;
    }
  })
  return respuesta;
}

/*==================================================
SELECTS DINAMICOS EN INGRESOS
==================================================*/
function cargarDeudaCliente(obj){
  $("#restoTipoIngreso2").html("")
  $("#restoTipoIngreso3").html("")
  $("#restoTipoIngreso4").html("")
  $("#restoTipoIngreso5").html("")
  var idCliente = obj.val();
  var datos1 = new FormData();
  datos1.append("verificarDeuda", idCliente);

  $.ajax({
    url: 'ajax/clientes.ajax.php',
    method: 'POST',
    data: datos1,
    cache: false,
    contentType: false,
    processData: false,
    dataType: 'json',
    success: function(deuda){

      var datos2 = new FormData();
      datos2.append("ventasPendientesCliente", idCliente);

      $.ajax({
        url: "ajax/ventas.ajax.php",
        method: "POST",
        data: datos2,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        beforeSend: function() {
          $("#restoTipoIngreso2").html("<div style='text-align:center;'>CARGANDO DEUDA...   <img width='100' height='100' src='componentes/img/sama/spinner-carga.gif' /></div>");
        },
        success: function(ventasPendientes){

          if(ventasPendientes.length > 0){ // PROCESO CON VENTAS PENDIENTES
            var plural = Number(ventasPendientes.length) == 1 ? '' : 'S';
            var htmlMostrar = '';
            $(ventasPendientes).each(function (i){
              htmlMostrar +=  '<div id="ventasPendiente'+ventasPendientes[i].id+'" class="mb-1">'+
                              'Venta <a href="extensiones/tcpdf/pdf/boleta-carta.php?cod_venta='+ventasPendientes[i].cod_venta+'&motivo=ver" target="_blank">'+ventasPendientes[i].cod_venta+
                              '</a> <i class="fa fa-arrow-right"></i> <button class="btn btn-warning btn-sm ventaAForzar" id="forzarCIVenta" totalVenta="'+ventasPendientes[i].total+'" idVenta="'+ventasPendientes[i].id+'">Forzar CRÉDITO INTERNO</button><br></div>';
            });
            Swal.fire({
              title: 'Cliente con <strong class="text-info">VENTA'+plural+' PENDIENTE'+plural+'</strong>',
              icon: 'info',
              html: htmlMostrar,
              confirmButtonText: 'Ok',
              showCloseButton: true,
              
              customClass: {
                confirmButton: 'btn-confirmar-ventas-pendientes',
              },
              didOpen: () => {
                $('.btn-confirmar-ventas-pendientes').attr('disabled','disabled');
                const confirmButton = Swal.getConfirmButton();
                confirmButton.setAttribute('deudaPendiente', '0');
              }

            }).then((result) => {
              if (result.isConfirmed){
                var deudaPend = Number($('.btn-confirmar-ventas-pendientes').attr('deudaPendiente'));
                var deudaReal = Number(deuda) + Number(deudaPend);




                $("#restoTipoIngreso2").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Deuda<div class='input-group'><input type='text' class='form-control input-lg' id='deudaClienteVista' value=" + formatNumber.new(deudaReal,'') + " readonly required><input type='hidden' id='deudaCliente' name='deudaCliente' value="+deudaReal+" required></div>");
                $("#restoTipoIngreso3").html("span class='input-group-addon'><i class='fa fa-money-check-alt'></i></span>   Método de Pago<div class='input-group'><select class='form-control input-lg metodoPagoAbonoIngresos' id='metodoPagoAbonoIngresos' name='metodoPagoAbonoIngresos' required><option value='>Método</option><option value=''>Seleccione Método</option><option value='ef'>Efectivo</option><option value='transf'>Transferencia</option><option value='tc'>Tarjeta Crédito</option><option value='td'>Tarjeta Débito</option></select></div>");
                
                // METODOS DE PAGO DINAMICOS
                $('#metodoPagoAbonoIngresos').change(function(){
                    var metodoPago = $(this).val();
                    if(metodoPago == 'ef'){
                      $("#restoTipoIngreso4").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Efectivo<div class='input-group'><input type='text' class='form-control input-lg' id='abonoEfectivoVista' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"abonoEfectivo", $(this).val()'+");' onkeypress='return soloNumeros(event)' placeholder='Ingrese Abono' required><input type='hidden' id='abonoEfectivo' name='abonoEfectivo'></div>");
                      $("#restoTipoIngreso5").html("");
                      if($('#deudaCliente').val()%10 <= 5){
                        $('#deudaCliente').val($('#deudaCliente').val()-$('#deudaCliente').val()%10);                 
                      }else{
                        $('#deudaCliente').val(Number($('#deudaCliente').val())+Number((10-$('#deudaCliente').val()%10)));
                      }
                    }else if(metodoPago == 'transf'){
                      $("#restoTipoIngreso4").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Transferencia<div class='input-group'><input type='text' class='form-control input-lg' id='abonoTransferenciaVista' placeholder='Monto Transferido' required onkeyup='formatoMiles($(this));' onkeypress='return soloNumeros(event)' onchange='sinFormatoMiles("+'"abonoTransferencia", $(this).val()'+");'><input type='hidden' id='abonoTransferencia' name='abonoTransferencia'></div>");
                      $("#restoTipoIngreso5").html("");
                      $('#deudaCliente').val(deudaReal);
                    }else if(metodoPago == 'td'){
                      $("#restoTipoIngreso4").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto a Cancelar con TD<div class='input-group'><input type='text' class='form-control input-lg' id='abonoTDVista' placeholder='Ingrese Monto' required onkeyup='formatoMiles($(this));' onkeypress='return soloNumeros(event)' onchange='sinFormatoMiles("+'"abonoTD", $(this).val()'+");'><input type='hidden' id='abonoTD' name='abonoTD'></div>");
                      $("#restoTipoIngreso5").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Código Transacción<div class='input-group'><input type='text' class='form-control input-lg' id='codigoTD' name='codigoTD' maxlength='4' placeholder='4 últimos dígitos' onkeypress='return soloNumeros(event)' required></div>");
                      $('#deudaCliente').val(deudaReal);
                    }else if(metodoPago == 'tc'){
                      $("#restoTipoIngreso4").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto a Cancelar con TC<div class='input-group'><input type='text' class='form-control input-lg' id='abonoTCVista' placeholder='Ingrese Monto' required onkeyup='formatoMiles($(this));' onkeypress='return soloNumeros(event)' onchange='sinFormatoMiles("+'"abonoTC", $(this).val()'+");'><input type='hidden' id='abonoTC' name='abonoTC'></div>");
                      $("#restoTipoIngreso5").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Código Transacción<div class='input-group'><input type='text' class='form-control input-lg' id='codigoTC' name='codigoTC' maxlength='4' placeholder='4 últimos dígitos' onkeypress='return soloNumeros(event)' required></div>");
                      $('#deudaCliente').val(deudaReal);
                    }else{
                      $("#restoTipoIngreso4").html("");
                      $("#restoTipoIngreso5").html("");
                      $('#deudaCliente').val(deudaReal);
                    }
                })
              }else{
                $('#modalIngresos').modal('hide');
                $('#tipoIngreso').val(0);
                $('#cliente_select_deuda').val(0).trigger('change');
                $('.abonoClienteIngresos1').addClass('d-none');
              }
            })    
            
          }else if(Number(deuda) <= 0){ // SIN VENTAS PENDIENTES Y SIN DEUDA
            var saldoFavor = Number(deuda) < 0 ? "<font>   Método de Pago<br>   <font color='blue'>Cliente con Saldo a Favor: <b>$ "+formatNumber.new(-deuda)+"</b></font>" : "";
            $("#restoTipoIngreso2").html("<span class='input-group-addon'><i class='fa fa-money'></i></span>"+saldoFavor+"</font><div class='input-group'><select class='form-control input-lg' id='metPagoAnticipo' name='metPagoAnticipo' required><option value='>Método</option><option value=''>Seleccione Método</option><option value='ef'>Efectivo</option><option value='transf'>Transferencia</option><option value='tc'>Tarjeta Crédito</option><option value='td'>Tarjeta Débito</option></select><input type='hidden' value='"+deuda+"' id='deudaClienteAnticipo' name='deudaClienteAnticipo'></div>");
            // METODOS DE PAGO DINAMICOS
            $('#metPagoAnticipo').change(function(){
                var metodoPago = $(this).val();
                if(metodoPago == 'ef'){
                  $("#restoTipoIngreso3").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Efectivo<div class='input-group'><input type='text' class='form-control input-lg' id='anticipoEfectivoVista' placeholder='Ingrese anticipo' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"anticipoEfectivo", $(this).val()'+");'><input type='hidden' id='anticipoEfectivo' name='anticipoEfectivo'></div>");
                  $("#restoTipoIngreso4").html("");
                  $("#restoTipoIngreso5").html("");
                }else if(metodoPago == 'transf'){
                  $("#restoTipoIngreso3").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Transferencia<div class='input-group'><input type='text' class='form-control input-lg' id='anticipoTransferenciaVista' placeholder='Monto Transferido' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"anticipoTransferencia", $(this).val()'+");'><input type='hidden' id='anticipoTransferencia' name='anticipoTransferencia'></div>");
                  $("#restoTipoIngreso4").html("");
                  $("#restoTipoIngreso5").html("");
                }else if(metodoPago == 'td'){
                  $("#restoTipoIngreso3").parent().parent().removeClass("col-xs-6");
                  $("#restoTipoIngreso3").parent().parent().removeClass("col-lg-6");
                  $("#restoTipoIngreso3").parent().parent().addClass("col-xs-12");
                  $("#restoTipoIngreso3").html("");
                  $("#restoTipoIngreso4").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto a Cancelar con TD<div class='input-group'><input type='text' class='form-control input-lg' id='anticipoTDVista' placeholder='Ingrese Monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"anticipoTD", $(this).val()'+");'><input type='hidden' id='anticipoTD' name='anticipoTD'></div>");
                  $("#restoTipoIngreso5").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Código Transacción<div class='input-group'><input type='text' class='form-control input-lg' id='codigoTD' name='codigoTD' maxlength='4' placeholder='4 últimos dígitos' onkeypress='return soloNumeros(event)' required></div>");
                }else if(metodoPago == 'tc'){
                  $("#restoTipoIngreso3").parent().parent().removeClass("col-xs-6");
                  $("#restoTipoIngreso3").parent().parent().removeClass("col-lg-6");
                  $("#restoTipoIngreso3").parent().parent().addClass("col-xs-12");
                  $("#restoTipoIngreso3").html("");
                  $("#restoTipoIngreso4").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto a Cancelar con TC<div class='input-group'><input type='text' class='form-control input-lg' id='anticipoTCVista' placeholder='Ingrese Monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"anticipoTC", $(this).val()'+");'><input type='hidden' id='anticipoTC' name='anticipoTC'></div>");
                  $("#restoTipoIngreso5").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Código Transacción<div class='input-group'><input type='text' class='form-control input-lg' id='codigoTC' name='codigoTC' maxlength='4' placeholder='4 últimos dígitos' onkeypress='return soloNumeros(event)' required></div>");                  
                }else{
                  $("#restoTipoIngreso3").html("");
                  $("#restoTipoIngreso4").html("");
                  $("#restoTipoIngreso5").html("");
                }
                    
            })


          }else{ // PROCESO SIN VENTAS PENDIENTES

            $("#restoTipoIngreso2").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Deuda<div class='input-group'><input type='text' class='form-control input-lg' id='deudaClienteVista' value=" + formatNumber.new(deuda,'') + " readonly required><input type='hidden' id='deudaCliente' name='deudaCliente' value="+deuda+" required></div>");
            $("#restoTipoIngreso3").html("<span class='input-group-addon'><i class='fa fa-money-check-alt'></i></span>   Método de Pago<div class='input-group'><select class='form-control input-lg metodoPagoAbonoIngresos' id='metodoPagoAbonoIngresos' name='metodoPagoAbonoIngresos' required><option value='>Método</option><option value=''>Seleccione Método</option><option value='ef'>Efectivo</option><option value='transf'>Transferencia</option><option value='tc'>Tarjeta Crédito</option><option value='td'>Tarjeta Débito</option></select></div>");
            
            // METODOS DE PAGO DINAMICOS
            $('#metodoPagoAbonoIngresos').change(function(){
                var metodoPago = $(this).val();
                if(metodoPago == 'ef'){
                  $("#restoTipoIngreso4").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Efectivo<div class='input-group'><input type='text' class='form-control input-lg' id='abonoEfectivoVista' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"abonoEfectivo", $(this).val()'+");' onkeypress='return soloNumeros(event)' placeholder='Ingrese Abono' required><input type='hidden' id='abonoEfectivo' name='abonoEfectivo'></div>");
                  $("#restoTipoIngreso5").html("");
                  if($('#deudaCliente').val()%10 <= 5){
                    $('#deudaCliente').val($('#deudaCliente').val()-$('#deudaCliente').val()%10);                 
                  }else{
                    $('#deudaCliente').val(Number($('#deudaCliente').val())+Number((10-$('#deudaCliente').val()%10)));
                  }
                }else if(metodoPago == 'transf'){
                  $("#restoTipoIngreso4").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Transferencia<div class='input-group'><input type='text' class='form-control input-lg' id='abonoTransferenciaVista' placeholder='Monto Transferido' required onkeyup='formatoMiles($(this));' onkeypress='return soloNumeros(event)' onchange='sinFormatoMiles("+'"abonoTransferencia", $(this).val()'+");'><input type='hidden' id='abonoTransferencia' name='abonoTransferencia'></div>");
                  $("#restoTipoIngreso5").html("");
                  $('#deudaCliente').val(deuda);
                }else if(metodoPago == 'td'){
                  $("#restoTipoIngreso4").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto a Cancelar con TD<div class='input-group'><input type='text' class='form-control input-lg' id='abonoTDVista' placeholder='Ingrese Monto' required onkeyup='formatoMiles($(this));' onkeypress='return soloNumeros(event)' onchange='sinFormatoMiles("+'"abonoTD", $(this).val()'+");'><input type='hidden' id='abonoTD' name='abonoTD'></div>");
                  $("#restoTipoIngreso5").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Código Transacción<div class='input-group'><input type='text' class='form-control input-lg' id='codigoTD' name='codigoTD' maxlength='4' placeholder='4 últimos dígitos' onkeypress='return soloNumeros(event)' required></div>");
                  $('#deudaCliente').val(deuda);
                }else if(metodoPago == 'tc'){
                  $("#restoTipoIngreso4").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto a Cancelar con TC<div class='input-group'><input type='text' class='form-control input-lg' id='abonoTCVista' placeholder='Ingrese Monto' required onkeyup='formatoMiles($(this));' onkeypress='return soloNumeros(event)' onchange='sinFormatoMiles("+'"abonoTC", $(this).val()'+");'><input type='hidden' id='abonoTC' name='abonoTC'></div>");
                  $("#restoTipoIngreso5").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Código Transacción<div class='input-group'><input type='text' class='form-control input-lg' id='codigoTC' name='codigoTC' maxlength='4' placeholder='4 últimos dígitos' onkeypress='return soloNumeros(event)' required></div>");
                  $('#deudaCliente').val(deuda);
                }else{
                  $("#restoTipoIngreso4").html("");
                  $("#restoTipoIngreso5").html("");
                  $('#deudaCliente').val(deuda);
                }
            })
          }

        }
      })            
    }

  });
}

$("#tipoIngreso").change(function() {
  var tipoIngreso = $(this).val();

  switch (tipoIngreso) {
    /*-------------------------------------------------------------------------------------
    // ABONO CLIENTE
    -------------------------------------------------------------------------------------    */
    case '1': // ABONO CLIENTE
      $('#restoTipoIngreso1').html(
        "<div class='abonoClienteIngresos1' style='width: 100%'>"+
          "<span class='input-group-addon'><i class='fa fa-user'></i></span>"+
          "Cliente"+
          "<div class='input-group'>"+
            "<select  style='font-size:16px; width:100%' class='form-control input-lg select2 cliente_select_deuda' id='cliente_select_deuda' name='cliente_select_deuda' onchange='cargarDeudaCliente($(this))' required>"+
              "<option value='0'>Seleccione cliente</option>"+
            "</select>"+
          "</div>"+
        "</div>")


      var idCliente = 'todos';
      var datos = new FormData();
      datos.append('idCliente', idCliente);
      $.ajax({
        url: 'ajax/clientes.ajax.php',
        method: 'POST',
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'json',
        success: function(r) {
          $(r).each(function(i) {
            if(r[i]['id'] != 1 && r[i]['deuda_cliente'] > 0 && r[i]['estado'] != 0){
              let finalNombre = r[i]["referencia"] == "" ? "" : " ("+r[i]["referencia"]+")";
              let nombreMostrar = reemplazarEspacios(r[i]["nombre"].charAt(0).toUpperCase() + r[i]["nombre"].slice(1)+" "+r[i]["apellido"].charAt(0).toUpperCase() + r[i]["apellido"].slice(1)+finalNombre.toUpperCase());
              $('#cliente_select_deuda').append('<option value="'+r[i]["id"]+'">'+nombreMostrar+'</option>');
            }
          });
        }
      })
      $('#cliente_select_deuda').select2()
    break;

    case '10': // ANTICIPO COMPRA
      $('#restoTipoIngreso1').html(
        "<div class='anticipoClienteIngresos1' style='width: 100%''>"+
          "<span class='input-group-addon'><i class='fa fa-user'></i></span>"+
          "   Cliente"+
          "<div class='input-group'>"+
            "<select  style='font-size:16px; width:100%'style='font-size:15px;' class='form-control input-lg select2 cliente_anticipo' id='cliente_anticipo' name='cliente_anticipo' onchange='cargarDeudaCliente($(this))' required>>"+
              "<option value='0'>Seleccione cliente</option>"+
            "</select>"+
          "</div>"+
        "</div>")
      var idCliente = 'todos';
      var datos = new FormData();
      datos.append('idCliente', idCliente);
      $.ajax({
        url: 'ajax/clientes.ajax.php',
        method: 'POST',
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'json',
        success: function(r) {
          $(r).each(function(i) {
            if(r[i]['id'] != 1 && r[i]['deuda_cliente'] <= 0 && r[i]['estado'] != 0){
              let finalNombre = r[i]["referencia"] == "" ? "" : " ("+r[i]["referencia"]+")";
              let nombreMostrar = reemplazarEspacios(r[i]["nombre"].charAt(0).toUpperCase() + r[i]["nombre"].slice(1)+" "+r[i]["apellido"].charAt(0).toUpperCase() + r[i]["apellido"].slice(1)+finalNombre.toUpperCase());
              $('#cliente_anticipo').append('<option value="'+r[i]["id"]+'">'+nombreMostrar+'</option>');
            }

          });
        }
      })
      $('#cliente_anticipo').select2();
    break;

    case '2': //APORTE CAJA
      $("#restoTipoIngreso2").html("")
      $("#restoTipoIngreso3").html("")
      $("#restoTipoIngreso4").html("")
      $("#restoTipoIngreso5").html("")
      $("#restoTipoIngreso1").html(
        "<div class='aporteCajaIngresos1' style='width: 100%'>"+
          "<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>"+
          "   Monto Aportado"+
          "<div class='input-group'>"+
            "<input type='text' class='form-control input-lg' id='aporteCajaVista' maxlength='7' onkeypress='return soloNumeros(event)' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles(\"aporteCaja\", $(this).val());'>"+
            "<input type='hidden' id='aporteCaja' name='aporteCaja'>"+
          "</div>"+
        "</div>")
    break;

    case '5':
      $("#restoTipoIngreso1").html(
        "<div class='otroIngresos1' style='width: 100%'>"+
          "<span class='input-group-addon'><i class='fa fa-info'></i></span>"+
          "   Detalle del Ingreso"+
          "<div class='input-group'>"+
            "<input type='text' class='form-control input-lg' id='detOtroIngreso' name='detOtroIngreso' placeholder='Detalle del movimiento' required>"+
          "</div>"+
        "</div>")
      $("#restoTipoIngreso2").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Ingreso<div class='input-group'><input type='text' class='form-control input-lg' id='montoOtroIngresoVista' maxlength='7' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"montoOtroIngreso", $(this).val()'+");'><input type='hidden' id='montoOtroIngreso' name='montoOtroIngreso'></div>");
      $("#restoTipoIngreso3").html("");
      $("#restoTipoIngreso4").html("");
      $("#restoTipoIngreso5").html("");
    break;

    case '6':
      $("#restoTipoIngreso1").html(
        "<div class='fleteIngresos1' style='width: 100%'>"+
          "<span class='input-group-addon'><i class='fa fa-info'></i></span>"+
          "   Detalle del Flete"+
          "<div class='input-group'>"+
            "<input type='text' class='form-control input-lg' id='detFlete' name='detFlete' placeholder='Detalle del flete' required>"+
          "</div>"+
        "</div>");
      $("#restoTipoIngreso2").html("");
      $("#restoTipoIngreso2").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Ingreso<div class='input-group'><input type='text' class='form-control input-lg' id='montFleteVista' maxlength='9' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"montFlete", $(this).val()'+");'><input type='hidden' id='montFlete' name='montFlete'></div>");
      $("#restoTipoIngreso3").html("");
      $("#restoTipoIngreso4").html("");
      $("#restoTipoIngreso5").html("");
    break;

    case '8':
      $("#restoTipoIngreso1").html(
        "<div class='aporteCapitalIngresos1' style='width: 100%'>"+
          "<span class='input-group-addon'><i class='fa fa-info'></i></span>"+
          "   Detalle aporte Capital"+
          "<div class='input-group'>"+
            "<input type='text' class='form-control input-lg' id='detApCap' name='detApCap' placeholder='Detalle ingreso' required>"+
          "</div>"+
        "</div>");
      $("#restoTipoIngreso2").html("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Ingreso<div class='input-group'><input type='text' class='form-control input-lg' id='montApCapVista' maxlength='9' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"montApCap", $(this).val()'+");'><input type='hidden' id='montApCap' name='montApCap'></div>");
      $("#restoTipoIngreso3").html("");
      $("#restoTipoIngreso4").html("");
      $("#restoTipoIngreso5").html("");
    break;

    default:
      $("#restoTipoIngreso1").html("");
      $("#restoTipoIngreso2").html("");
      $("#restoTipoIngreso3").html("");
      $("#restoTipoIngreso4").html("");
      $("#restoTipoIngreso5").html("");
    break;

  }

});

/*==================================================
SELECTS DINAMICOS EN EGRESOS
==================================================*/
$("#tipoEgreso").change(function() {

  var tipoEgreso = $(this).val();
  switch (tipoEgreso) {

    case '1': // proveedor
      $("#restoTipoEgreso1").html("<span class='input-group-addon'><i class='fa fa-industry'></i></span>   Proveedor<div class='input-group'><select style='font-size:15px' class='form-control input-lg proveedor_select_pago' id='proveedor_select_pago' name='proveedor_select_pago' required><option value='0'>Seleccione proveedor</option></select></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso3").html("");

      // LLENAR SELECT PROVEEDORES
      var idProveedor = 'todos';
      var datos = new FormData();
      datos.append('idProveedor', idProveedor);
      $.ajax({
      url:'ajax/proveedores.ajax.php',
      method: 'POST',
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',        
        success:function(respuesta){
          $(respuesta).each(function(i){
            $("#proveedor_select_pago").append("<option value='"+respuesta[i]['id']+"'>"+respuesta[i]['alias_empresa'].toUpperCase() +"</option>");                      
          });
        }
      })
      $('#proveedor_select_pago').select2();
      $('#proveedor_select_pago').change(function(){
        var prov_pago = $(this);
        if(prov_pago.val()==0){
          $("#restoTipoEgreso2").html("");
          $("#restoTipoEgreso3").html("");
        }else{
          $("#restoTipoEgreso2").html("");
          $("#restoTipoEgreso2").append("<span class='input-group-addon'><i>#</i></span>   Factura Nro.<div class='input-group'><input type='text' class='form-control input-lg' id='facturaNro' name='facturaNro' maxlength='10' onkeypress='return soloNumeros(event)' placeholder='Nro. Factura' required></div>");
          $("#restoTipoEgreso3").html("");
          $("#restoTipoEgreso3").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Factura<div class='input-group'><input type='text' class='form-control input-lg' id='montoFacturaVista' maxlength='7' placeholder='Monto Factura' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"montoFactura", $(this).val()'+");'><input type='hidden' id='montoFactura' name='montoFactura'></div>");
        }
      })

    break;

    case '14': // dcto cliente
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append( "<span class='input-group-addon'><i class='fa fa-user'></i></span>   Cliente"+
                                      "<div class='input-group'>"+
                                        "<select style='font-size:15px' class='form-control input-lg' id='cliente_dcto' name='cliente_dcto' required>"+
                                          "<option value='0'>Seleccione cliente</option>"+
                                        "</select>"+
                                      "</div>");
      // LLENAR SELECT CLIENTES
      var idCliente = 'todos';
      var datos = new FormData();
      datos.append('idCliente', idCliente);
      $.ajax({
        url: 'ajax/clientes.ajax.php',
        method: 'POST',
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'json',
        success: function(respuesta) {
          $(respuesta).each(function(i) {
            if (respuesta[i]['id'] != 1) { // todos los clientes
              let finalNombre = respuesta[i]["referencia"] == "" ? "" : " ("+respuesta[i]["referencia"]+")";
              let nombreMostrar = reemplazarEspacios(respuesta[i]["nombre"].charAt(0).toUpperCase() + respuesta[i]["nombre"].slice(1)+" "+respuesta[i]["apellido"].charAt(0).toUpperCase() + respuesta[i]["apellido"].slice(1)+finalNombre.toUpperCase());
              $("#cliente_dcto").append("<option value='" + respuesta[i]['id'] + "'>" +nombreMostrar+ "</option>");
            }
          });
        }
      })
      $('#cliente_dcto').select2();
      // MOSTRAR DEUDA CLIENTE
      $('#cliente_dcto').change(function() {
        var idCliente = $(this).val();
        var datos = new FormData();
        datos.append("verificarDeuda", idCliente);
        $.ajax({
          url: 'ajax/clientes.ajax.php',
          method: 'POST',
          data: datos,
          cache: false,
          contentType: false,
          processData: false,
          dataType: 'json',
          success: function(deuda) {
            $("#restoTipoEgreso2").html("");
            $("#restoTipoEgreso2").append("<span class='input-group-addon'><i>#</i></span>   Descripción del descuento<div class='input-group'><input type='text' class='form-control input-lg' id='detDcto' name='detDcto' placeholder='Ej: 10 Fibrocemento compra 210101005' required><input type='hidden' class='form-control input-lg' id='deudaDcto' name='deudaDcto' value='"+deuda+"'></div>");
            $("#restoTipoEgreso3").html("");
            $("#restoTipoEgreso3").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Descontado<div class='input-group'><input type='text' class='form-control input-lg' id='montoDctoVista' maxlength='7' onkeypress='return soloNumeros(event)' placeholder='Monto pagado' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"montoDcto", $(this).val()'+");'><input type='hidden' id='montoDcto' name='montoDcto'></div>");
          }
        })
      })

    break;

    case '15': // devolucion dinero cliente
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append( "<span class='input-group-addon'><i class='fa fa-user'></i></span>   Cliente"+
                                      "<div class='input-group'>"+
                                        "<select style='font-size:15px' class='form-control input-lg' id='cliente_devolucion' name='cliente_devolucion' required>"+
                                          "<option value='0'>Seleccione cliente</option>"+
                                        "</select>"+
                                      "</div>");

      // LLENAR SELECT CLIENTES
      var idCliente = 'todos';
      var datos = new FormData();
      datos.append('idCliente', idCliente);
      $.ajax({
        url: 'ajax/clientes.ajax.php',
        method: 'POST',
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'json',
        success: function(respuesta) {
          $(respuesta).each(function(i) {
            if (respuesta[i]['id'] != 1 && respuesta[i]['deuda_cliente'] < 0) {
              let finalNombre = respuesta[i]["referencia"] == "" ? "" : " ("+respuesta[i]["referencia"]+")";
              let nombreMostrar = reemplazarEspacios(respuesta[i]["nombre"].charAt(0).toUpperCase() + respuesta[i]["nombre"].slice(1)+" "+respuesta[i]["apellido"].charAt(0).toUpperCase() + respuesta[i]["apellido"].slice(1)+finalNombre.toUpperCase());
              $("#cliente_devolucion").append("<option value='" + respuesta[i]['id'] + "'>"+nombreMostrar+"</option>");
            }
          });
        }
      })

      $('#cliente_devolucion').select2();
      // MOSTRAR DEUDA CLIENTE
      $('#cliente_devolucion').change(function() {
        var idCliente = $(this).val();
        var datos = new FormData();
        datos.append('verificarDeuda', idCliente);
        $.ajax({
          url: 'ajax/clientes.ajax.php',
          method: 'POST',
          data: datos,
          cache: false,
          contentType: false,
          processData: false,
          dataType: 'json',
          success: function(deuda) {
            $("#restoTipoEgreso2").html("");
            $("#restoTipoEgreso2").append("<span class='input-group-addon'><i>#</i></span>   Descripción del descuento<div class='input-group'><input type='text' class='form-control input-lg' id='detDev' name='detDev' placeholder='Ej: 10 codos sin stock a $1.500 c/u' required><input type='hidden' class='form-control input-lg' id='deudaDev' name='deudaDev' value='"+deuda+"'></div>");
            $("#restoTipoEgreso3").html("");
            $("#restoTipoEgreso3").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Descontado<div class='input-group'><input type='text' class='form-control input-lg' id='montoDevVista' maxlength='7' onkeypress='return soloNumeros(event)' placeholder='Monto pagado' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"montoDev", $(this).val()'+");'><input type='hidden' id='montoDev' name='montoDev'></div>");
          }
        })
      })

    break;

    case '2': // pago trabajador

      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-user'></i></span>   Trabajador<div class='input-group'><select style='font-size:15px' class='form-control input-lg pagTrab' id='pagTrab' name='pagTrab' required><option value='0'>Seleccione trabajador</option></select></div>");

      var socio = 'socio';
      var datos = new FormData();
      datos.append("socio", socio);

      $.ajax({
        url:"ajax/usuarios.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(respuesta){
            
          $(respuesta).each(function(i){
            if(respuesta[i]['socio']!=1){
              $("#pagTrab").append("<option value='"+respuesta[i]['id']+"'>"+respuesta[i]['nombre']+"</option>");                      
            }
          });
        }
      });
      $('#pagTrab').select2();

      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso2").append("<span class='input-group-addon'><i class='fa fa-info'></i></span>   Detalle del Pago<div class='input-group'><input type='text' class='form-control input-lg' id='detPago' name='detPago' placeholder='Ej: 14 horas' required></div>");
      $("#restoTipoEgreso3").html("");
      $("#restoTipoEgreso3").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Pagado<div class='input-group'><input type='text' class='form-control input-lg' id='pagoTrabajadorVista' maxlength='9' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"pagoTrabajador", $(this).val()'+");'><input type='hidden' id='pagoTrabajador' name='pagoTrabajador'></div>");

    break;    

    case '3': // retiro socio

      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-user'></i></span>   Socio<div class='input-group'><select style='font-size:15px' class='form-control input-lg socio' id='socio' name='socio' required><option value='0'>Seleccione socio</option></select></div>");

      var socio = 'socio';
      var datos = new FormData();
      datos.append("socio", socio);

      $.ajax({
        url:"ajax/usuarios.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(respuesta){
            
          $(respuesta).each(function(i){
            if(respuesta[i]['socio']==1){
              $("#socio").append("<option value='"+respuesta[i]['id']+"'>"+respuesta[i]['nombre']+"</option>");                      
            }
          });
        }
      });
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso2").append("<span class='input-group-addon'><i class='fa fa-info'></i></span>   Detalle Retiro Socio<div class='input-group'><input type='text' class='form-control input-lg' id='detRetiroSocio' name='detRetiroSocio' placeholder='Detalle del movimiento' required></div>");
      $("#restoTipoEgreso3").html("");
      $("#restoTipoEgreso3").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Retirado<div class='input-group'><input type='text' class='form-control input-lg' id='retSocioVista' maxlength='9' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"retSocio", $(this).val()'+");'><input type='hidden' id='retSocio' name='retSocio'></div>");
    break;

    case '4':
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Valor Flete<div class='input-group'><input type='text' class='form-control input-lg' id='pagFleteVista' maxlength='9' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"pagFlete", $(this).val()'+");'><input type='hidden' id='pagFlete' name='pagFlete'></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso3").html("");
    break;

    case '5':
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Propina<div class='input-group'><input type='text' class='form-control input-lg' id='propinaVista' maxlength='6' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"propina", $(this).val()'+");'><input type='hidden' id='propina' name='propina'></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso3").html("");
    break;

    case '6':
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-info'></i></span>   Detalle del Egreso<div class='input-group'><input type='text' class='form-control input-lg' id='detOtroEgreso' name='detOtroEgreso' placeholder='Detalle del movimiento' required></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso2").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Egreso<div class='input-group'><input type='text' class='form-control input-lg' id='montoOtroEgresoVista' maxlength='7' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"montoOtroEgreso", $(this).val()'+");'><input type='hidden' id='montoOtroEgreso' name='montoOtroEgreso'></div>");
      $("#restoTipoEgreso3").html("");
    break;

    case '7':
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-industry'></i></span>   Distribuidor<div class='input-group'><select style='font-size:15px' class='form-control input-lg distrib' id='distrib' name='distrib' required><option value='0'>Seleccione distribuidor</option><option value='36'>Elias Figueroa</option></select></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso2").append("<span class='input-group-addon'><i class='fa fa-info'></i></span>   Detalle del Egreso<div class='input-group'><input type='text' class='form-control input-lg' id='detDistrib' name='detDistrib' placeholder='Detalle del pago' required></div>");
      $("#restoTipoEgreso3").html("");
      $("#restoTipoEgreso3").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Pagado<div class='input-group'><input type='text' class='form-control input-lg' id='pagDistribVista' maxlength='7' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"pagDistrib", $(this).val()'+");'><input type='hidden' id='pagDistrib' name='pagDistrib'></div>");
    break;

    case '8':
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-info'></i></span>   Detalle compra<div class='input-group'><input type='text' class='form-control input-lg' id='detActiv' name='detActiv' placeholder='Activo comprado' required></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso2").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Pagado<div class='input-group'><input type='text' class='form-control input-lg' id='pagActivVista' maxlength='10' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"pagActiv", $(this).val()'+");'><input type='hidden' id='pagActiv' name='pagActiv'></div>");
      $("#restoTipoEgreso3").html("");
    break;

    case '9':
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-info'></i></span>   Detalle mantención<div class='input-group'><input type='text' class='form-control input-lg' id='detMant' name='detMant' placeholder='Ej: Cambio Aceite Camión' required></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso2").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Pagado<div class='input-group'><input type='text' class='form-control input-lg' id='pagMantVista' maxlength='7' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"pagMant", $(this).val()'+");'><input type='hidden' id='pagMant' name='pagMant'></div>");
      $("#restoTipoEgreso3").html("");
    break;

    case '10':
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Peaje<div class='input-group'><input type='text' class='form-control input-lg' id='peajeVista' maxlength='6' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"peaje", $(this).val()'+");'><input type='hidden' id='peaje' name='peaje'></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso3").html("");
    break;

    case '11':
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Petroleo<div class='input-group'><input type='text' class='form-control input-lg' id='petroCamVista' maxlength='6' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"petroCam", $(this).val()'+");'><input type='hidden' id='petroCam' name='petroCam'></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso3").html("");
    break;

    case '12':
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-user'></i></span>   Titular<div class='input-group'><select style='font-size:15px' class='form-control input-lg' id='deudor' name='deudor' required><option value='0'>Seleccione deudor</option></select></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso3").html("");

      // LLENAR SELECT PROVEEDORES
      var idCliente = 'todos';
      var datos = new FormData();
      datos.append('idCliente', idCliente);
      $.ajax({
      url:'ajax/clientes.ajax.php',
      method: 'POST',
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',        
        success:function(r){
          $(r).each(function(i){
            if(r[i]['prestamos']==1){
              $("#deudor").append("<option maximo='"+(Number(r[i]['limite'])-Number(r[i]['deuda_cliente']))+"' limite='"+r[i]['limite']+"' value='"+r[i]['id']+"'>"+r[i]['nombre'].toUpperCase()+' '+r[i]['apellido'].toUpperCase()+' ('+r[i]['referencia']+")</option>");                      
            }
          });
        }
      })

      $('#deudor').change(function(){
        var deudor = $(this);
        if(deudor.val()==0){
          $("#restoTipoEgreso2").html("");
        }else{
          max = $('#deudor option:selected').attr('maximo');
          limite = $('#deudor option:selected').attr('limite');
          $("#restoTipoEgreso2").html("");
          $("#restoTipoEgreso2").append("<span class='input-group-addon'><i class='fa fa-info'></i></span>   Detalle Préstamo<div class='input-group'><input type='text' class='form-control input-lg' id='detPrestamo' name='detPrestamo' placeholder='Ej: Para reparacion vehículo' required></div>");
          $("#restoTipoEgreso3").html("");
          $("#restoTipoEgreso3").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Máximo a prestar: "+formatNumber.new(max,"$ ")+" <div class='input-group'><input type='text' max='"+max+"' class='form-control input-lg' id='prestamoVista' maxlength='7' placeholder='Monto prestado' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='excedeMax("+max+","+limite+");sinFormatoMiles("+'"prestamo", $(this).val()'+");'><input type='hidden' id='prestamo' name='prestamo'></div>");
        }
      })

    break;

    case '13':
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso1").append("<span class='input-group-addon'><i class='fa fa-info'></i></span>   Trabajo realizado<div class='input-group'><input type='text' class='form-control input-lg' id='detJobs' name='detJobs' placeholder='Detalle Trabajos Realizados' required></div>");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso2").append("<span class='input-group-addon'><i class='fa fa-dollar-sign'></i></span>   Monto Pagado<div class='input-group'><input type='text' class='form-control input-lg' id='pagJobsVista' maxlength='8' placeholder='Ingrese monto' required onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles("+'"pagJobs", $(this).val()'+");'><input type='hidden' id='pagJobs' name='pagJobs'></div>");
      $("#restoTipoEgreso3").html("");
    break;

    default:
      $("#restoTipoEgreso1").html("");
      $("#restoTipoEgreso2").html("");
      $("#restoTipoEgreso3").html("");
    break;
  }
});

/*=============================================
=     ALERTA SI SUPERA EL MAXIMO PRESTAMO     =
=============================================*/
function excedeMax(max,limite){
  if($('#prestamo').val()>max){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Excede el máximo<br>Monto a prestar: '+formatNumber.new(max, '$ ')+'<br>Crédito Total: '+formatNumber.new(limite, '$ ')+'<br>Utilizado: '+formatNumber.new((limite-max), '$ ')});

    $('#prestamo').val(0);  
    $('#prestamo').select();      
  }
}





/*=============================================
=      VALIDACION FORMULARIO DE INGRESO       =
=============================================*/
$("#formIngresos").submit(function() {

  if($('#tipoIngreso').val()==1){
    if($('#cliente_select_deuda').val()!= 0 && $('#metodoPagoAbonoIngresos').val()=='ef' && $('#abonoEfectivo').val()>0){
      return true;
    }else if($('#cliente_select_deuda').val()!= 0 && $('#metodoPagoAbonoIngresos').val()=='transf' && $('#abonoTransferencia').val()>0){
      return true;      
    }else if($('#cliente_select_deuda').val()!= 0 && $('#metodoPagoAbonoIngresos').val()=='tc' && $('#abonoTC').val()>0 && $('#codigoTC').val()!=''){
      return true;      
    }else if($('#cliente_select_deuda').val()!= 0 && $('#metodoPagoAbonoIngresos').val()=='td' && $('#abonoTD').val()>0 && $('#codigoTD').val()!=''){      
      return true;      
    }else{
      var audio = new Audio('componentes/sonidos/error.wav');
      audio.play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Faltan datos'});
      return false;      
    }
  }else if($('#tipoIngreso').val()==2){
    if($('#aporteCaja').val()==''){
      var audio = new Audio('componentes/sonidos/error.wav');
      audio.play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese aporte de caja'});
      return false;
    }else{
      return true;
    }
  }else if($('#tipoIngreso').val()==3){  
    return true;
  }else{
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese aporte de caja'});
  }
})


/*============================
=      CALCULAR VUELTO       =
============================*/
$('#abonoEfectivo input').on('change', function(){
// $(".tablaMovimientos tbody").on("change", "#abonoEfectivo", function(){
  // $('#vueltoEfectivo').val($(this).val()-1);
})

