function textoParaWhatsappInforme(){


    var get = obtenerGET(window.location);
    var abastecimiento = get['abastecimiento'];
    var item1 = get['item1'];
    var item2 = get['item2'];
    var sucursal = $('#sucursalActiva').val(); 



    if(Number(abastecimiento) == 2){

        var datos = new FormData();
        datos.append("textoWhatsappInforme", abastecimiento);
        datos.append("item1", item1);
        datos.append("item2", item2);
        datos.append("idProv", item1);
        datos.append("sucursal", sucursal);
        $.ajax({
            url: "ajax/informes.ajax.php",
            method: "POST",
            data: datos,
            cache: false,
            contentType: false,
            processData: false,
            success: function(r){
                let textoWsp = r.split('////')[0];
                let totalNeto = r.split('////')[1];
                // copiar texto formato whatsapp
                copiarTexto(textoWsp.replace(/\\n/g, '\n'));
                Swal.mixin({toast: true,position: 'top',showConfirmButton: false,showCloseButton: true,timer: 3000}).fire({icon: 'success',title: 'Copia Exitosa \n\n Total Estimado \n $'+formatNumber.new(Math.round(totalNeto))+' / $'+formatNumber.new(Math.round(totalNeto*1.19))});
            }
        })

    }else{    
        var idProveedor = null;
        var datos = new FormData();
        datos.append("idProveedor", idProveedor);

        $.ajax({
            url:"ajax/informes.ajax.php",
            method: "POST",
            data: datos,
            cache: false,
            contentType: false,
            processData: false,
            dataType:"json",
            success:function(respuesta){
                const optionsFinal = {};
                optionsFinal[0] = 'Proveedor Nuevo';
                respuesta.forEach((elemento) => {
                    optionsFinal[elemento.id] = elemento.alias_empresa.charAt(0).toUpperCase() + elemento.alias_empresa.slice(1);
                });


                (async () => {
                    const { idProv: seleccionado } = await Swal.fire({
                        title: "A quién enviará solicitud de precios?",
                        input: "select",
                        inputOptions: optionsFinal,
                        inputPlaceholder: "Seleccione Proveedor",
                        showCancelButton: true,
                        didOpen: () => {

                            const select = document.querySelector('select.swal2-select');
                            const opcionesArray = Array.from(select.options); // opciones actuales
                            opcionesArray.sort((a, b) => a.text.localeCompare(b.text)); // se ordenan en array por texto
                            select.innerHTML = ""; // se vacia el select
                            
                            opcionesArray.forEach(opcion => { // primero seleccione proveedor
                                if(opcion.innerText == 'Seleccione Proveedor'){
                                    select.appendChild(opcion);
                                }
                            });

                            opcionesArray.forEach(opcion => { // segundo nuevo proveedor
                                if(opcion.innerText == 'Proveedor Nuevo'){
                                    select.appendChild(opcion);
                                }
                            });


                            opcionesArray.forEach(opcion => { // se agregan ordenadas alfabeticamente el resto de proveedores
                                if(opcion.value != 0){
                                    select.appendChild(opcion);
                                }
                            });
                        },
                        inputValidator: (idProv) => {
                            return new Promise((resolve) => {
                                if (idProv == ''){
                                    resolve("Seleccione algún proveedor");
                                } else {
                                    resolve();
                                    var datos = new FormData();
                                    datos.append("textoWhatsappInforme", abastecimiento);
                                    datos.append("item1", item1);
                                    datos.append("item2", item2);
                                    datos.append("idProv", idProv);
                                    datos.append("sucursal", sucursal);
                                    $.ajax({
                                        url: "ajax/informes.ajax.php",
                                        method: "POST",
                                        data: datos,
                                        cache: false,
                                        contentType: false,
                                        processData: false,
                                        success: function(r){
                                            let textoWsp = r.split('////')[0];
                                            let totalNeto = r.split('////')[1];
                                            copiarTexto(textoWsp.replace(/\\n/g, '\n'));
                                            Swal.mixin({toast: true,position: 'top',showConfirmButton: false,showCloseButton: true,timer: 5000}).fire({icon: 'success',title: 'Copia Exitosa \n\n Total Estimado \n $'+formatNumber.new(Math.round(totalNeto))+' / $'+formatNumber.new(Math.round(totalNeto*1.19))});
                                        }
                                    })
                                }
                            });
                        }
                    });
                })()
            }
        })
    }
}

var tablaTerminarPedido = $('.tablaTerminarPedido').DataTable( {
    "ajax": "ajax/datatable-terminar-pedido.ajax.php?abastecimiento="+obtenerGET(window.location)['abastecimiento']+"&item1="+obtenerGET(window.location)['item1']+"&item2="+obtenerGET(window.location)['item2'],
    "order": [ 0, "desc" ], //orden descendente por defecto
    "deferRender": true,
    "retrieve": true,
    "processing": true,
    "language": {
        "sProcessing":     "Procesando...",
        "sLengthMenu":     "",
        "sZeroRecords":    "No se encontraron resultados",
        "sEmptyTable":     "Ningún dato disponible en esta tabla",
        "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
        "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
        "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
        "sInfoPostFix":    "",
        "sSearch": "<button class='btn btn-info btn-sm' onclick='actualizarTabla();'><i class='fas fa-undo'></i></button>    Buscar",
        "sUrl": "",
        "sInfoThousands": ",",
        "sLoadingRecords": "Cargando...",
        "oPaginate": {
          "sFirst": "Primero",
          "sLast": "Último",
          "sNext": "&rarr;",
          "sPrevious": "&larr;"
        },
        "oAria": {
          "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
          "sSortDescending": ": Activar para ordenar la columna de manera descendente"
        }

    },
    dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',
});

function resetPedido(){
    var get = obtenerGET(window.location);
    var abastecimiento = get['abastecimiento']; // tipo informe abastecimiento (1: subcat; 2: proveedor; 3: todos)
    var item1 = get['item1']; // item1
    var item2 = get['item2']; // item2
    var datos = new FormData();
    datos.append("resetAbastecimiento", abastecimiento);
    datos.append("item1", item1);
    datos.append("item2", item2);
    $.ajax({
        url: "ajax/informes.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        success: function(r){
            if(r == 'ok'){
                audioSuccess('Informe Reseteado')
                $('.cant_pedido').text('0');
                $('.total_pedido_item').text('0');
                $('#totalEstimadoPedido').html(
                    '<button class="btn btn-warning float-right text-white disabledBotonesInforme" onclick="resetPedido()" disabled><i class="fas fa-undo"></i> RESET</button>'+
                     '<div class="float-right">TOTAL $ 0   </div>');
                $('.disabledBotonesInforme').attr('disabled','disabled');

            }
        }
    })
}

/*==================================================
INGRESAR PEDIDO A BASE DE DATOS POR AJAX
==================================================*/
$(document).on('blur', "#cant_pedido", function(){
    
    var id = $(this).attr('idproducto');
    var cant_pedido = $(this).text();
    var fila = $(this).parents('tr');
    var cant_pedido_sumar = $(this).text();
    var valorUnitarioCIVA = infoProd(id)['precio_compra'];

    if(cant_pedido == ''){
        $(this).text(0);
        cant_pedido = 0;
    }

    if(isNaN(cant_pedido)){
        mixinError('Solo cantidades > 0');
    }else{
        $.ajax({
            url: 'ajax/informes.ajax.php',
            method: 'POST',
            data: {id: id, cant_pedido: cant_pedido},
            success: function(r) {
            resp = r.split(',')[0];
            cant = r.split(',')[1];
                if (resp == 'ok') {
                    if (Number(cant) == 1){
                        mixinSuccess('Has agregado '+cant+' producto al pedido')
                    }else if (Number(cant) == 0){
                        mixinWarning('No se han agregado productos al pedido')
                    }else if(Number(cant) > 1){
                        mixinSuccess('Has agregado '+cant+' productos al pedido')
                    }
                
                    var get = obtenerGET(window.location);
                    var abast = get['abastecimiento']; // tipo informe abastecimiento (1: subcat; 2: proveedor; 3: todos)
                    var item1 = get['item1']; // item1
                    var item2 = get['item2']; // item2
                    var datos = new FormData();
                    datos.append("totalPedido", abast);
                    datos.append("item1", item1);
                    datos.append("item2", item2);
                    $.ajax({
                        url: "ajax/informes.ajax.php",
                        method: "POST",
                        data: datos,
                        cache: false,
                        contentType: false,
                        processData: false,
                        success: function(resp){
                            r = resp.split(',');
                            console.log(resp);
                            if(r[0] = 'ok'){
                                if(Number(r[1]) == 0){
                                    $('#totalEstimadoPedido').html(
                                        '<button class="btn btn-warning float-right text-white disabledBotonesInforme" onclick="resetPedido()" disabled><i class="fas fa-undo"></i> RESET</button>'+
                                        '<div class="float-right">TOTAL $ 0   </div>');
                                    $('.disabledBotonesInforme').attr('disabled','disabled');
                                }else{
                                    $('#totalEstimadoPedido').html(
                                        '<button class="btn btn-warning float-right text-white disabledBotonesInforme" onclick="resetPedido()"><i class="fas fa-undo"></i> RESET</button>'+
                                        '<div class="float-right">TOTAL $ '+formatNumber.new(r[1])+' &harr; '+formatNumber.new(r[2])+'   </div>');
                                    $('.disabledBotonesInforme').removeAttr('disabled');
                                }
                                $('#totalTraspasar').val(r[1]);
                                
                                let totalFila = Math.round(cant_pedido_sumar*valorUnitarioCIVA);
                                let netoFila = Math.round(cant_pedido_sumar*valorUnitarioCIVA/1.19);

                                if(Number(cant) > 0){
                                    fila.find('td:last').html('$ '+formatNumber.new(netoFila)+'  &harr; '+formatNumber.new(totalFila)); // resultado por fila
                                }else{
                                    fila.find('td:last').text(0); // resultado por fila                                    
                                }
                            }
                        }
                    })

                }else{
                    audioError('No se pudo concretar');
                }
            }
        })
    }

});

// AL HACER FOCO EN EL ELEMENTO RESETEARLO A VACÍO
$(document).on('focus', "#cant_pedido", function(){
    $(this).text('');
});

/*==================================================
SELECTS DINAMICOS CON AJAX EN INFORME ABASTECIMIENTO
==================================================*/
// CAMBIOS EN SELECT ABASTECIMIENTO
$("#abastecimiento").change(function() {
    
    var orden = $(this).val();
    switch(orden){
        
        case '1':
        $("#select1").html(""); // RESET SELECT 1
        $("#select1").append("<option value='0'>Seleccione categoría</option>");
        $("#select2").html("Seleccione subcategoría"); // RESET SELECT 2
        categorias();
        $(".divSelect1").removeClass('d-none'); // RESET SELECT 2
        $(".divSelect2").addClass('d-none'); // RESET SELECT 2
        break;

        case '2':
        $("#select1").html(""); // RESET SELECT 1
        $("#select1").append("<option value='0'>Seleccione proveedor</option>");
        $("#select2").text("");
        $(".divSelect1").removeClass('d-none'); // RESET SELECT 2
        $(".divSelect2").addClass('d-none'); // RESET SELECT 2
        proveedores();
        break;

        default:
        $("#select1").text("");
        $("#select2").text("");
        $(".divSelect1").addClass('d-none');
        $(".divSelect2").addClass('d-none');

        break;
    }

});

// CAMBIOS EN SELECT1
$("#select1").change(function() {

    var idSubcategoria = $(this).val();
    var datos = new FormData();
    var select0 = $("#abastecimiento").val();

    // evita que se active el select2 si no está en subcategoría el select0
    if(select0==1){
        $(".divSelect2").removeClass('d-none'); // RESET SELECT 2
    }

    datos.append("idSubcategoria", idSubcategoria);
    $.ajax({
        url:"ajax/informes.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType:"json",
        success:function(respuesta){
            var itemsSelect = respuesta;
            llenar_select2(itemsSelect);
        }
    })

});

// FUNCIONES
function proveedores(){

    var idProveedor = null;
    var datos = new FormData();
    datos.append("idProveedor", idProveedor);

    $.ajax({
      url:"ajax/informes.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
      success:function(respuesta){

        var itemsSelect = respuesta;
        llenar_select_proveedores(itemsSelect);

      }
    })

}

function categorias(){

    var idCategoria = null;
    var datos = new FormData();
    datos.append("idCategoria", idCategoria);

    $.ajax({
        url:"ajax/informes.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType:"json",
        success:function(respuesta){

            var itemsSelect = respuesta;
            llenar_select1(itemsSelect);

        }
    })

}

function llenar_select_proveedores(arregloAjax){
    $(arregloAjax).each(function (i) { //populate child options
        $("#select1").append("<option value=\""+arregloAjax[i].id+"\">"+arregloAjax[i].alias_empresa+"</option>");
    });
}

function llenar_select1(arregloAjax){
    // $("#select1").html(""); //reset child options
    $(arregloAjax).each(function (i) { //populate child options
        $("#select1").append("<option value=\""+arregloAjax[i].id+"\">"+arregloAjax[i].categoria+"</option>");
    });

}

function llenar_select2(arregloAjax){
    // console.log(arregloAjax);
    $("#select2").html(""); //reset child options
    $("#select2").append("<option value='0'>Seleccione subcategoría</option>");
    $(arregloAjax).each(function (i) { //populate child options
        $("#select2").append("<option value=\""+arregloAjax[i].id_subcategoria+"\">"+arregloAjax[i].subcategoria+"</option>");
    });

}


/*=============================================
BOTON GENERAR INFORME ABASTECIMIENTO
=============================================*/
function informeAbastecimiento(){
    
    var abastecimiento = $("#abastecimiento");
    var select1 = $("#select1");
    var select2 = $("#select2");
    var ruta="abastecimiento="+abastecimiento.val()+"&item1="+select1.val()+"&item2="+select2.val();
    if(abastecimiento.val()==0){
        Swal.fire({
            type: "error",
            title: "Faltan Datos",
            text: "A lo menos debe seleccionar un item",
            confirmButtonText: "Cerrar"
        });
    }else if(abastecimiento.val()==1 && select1.val()==0){
        Swal.fire({
            type: "error",
            title: "Faltan Datos",
            text: "Debe seleccionar una categoría",
            confirmButtonText: "Cerrar"
        });
    }else if(abastecimiento.val()==1 && select1.val()!=0 && select2.val()==0){
        Swal.fire({
            type: "error",
            title: "Faltan Datos",
            text: "Debe seleccionar la subcategoría",
            confirmButtonText: "Cerrar"
        });
    }else if(abastecimiento.val()==2 && select1.val()==0){
        Swal.fire({
            type: "error",
            title: "Faltan Datos",
            text: "Debe seleccionar el proveedor",
            confirmButtonText: "Cerrar"
        });
    }else{
        window.open("index.php?ruta=terminar-informe-abastecimiento&"+ruta,"_blank");
        // GENERAR PDF
        abastecimiento.val(0);
        // $("#select1").attr("disabled", "disabled");
        $("#select1").text("");
        // $("#select2").attr("disabled", "disabled");
        $("#select2").text("");
        $('#modalAbastecimiento').modal('hide');
        $(".divSelect1").addClass('d-none');
        $(".divSelect2").addClass('d-none');
        
    }
}


/*=============================================
BOTON GENERAR INFORME PRODUCTOS
=============================================*/
function informeProductos(){
    
    var motivo = $("#motivoInformeProductos");
    var ruta="motivo="+motivo.val();
    if(motivo.val()==0){
        Swal.fire({
            type: "error",
            title: "Faltan Datos",
            text: "Seleccione el motivo del informe",
            confirmButtonText: "Cerrar"
        });
    }else{
        window.open("extensiones/tcpdf/pdf/productos-pdf.php?"+ruta, "_blank");
        motivo.val(0);
        $('#modalInformeProductos').modal('hide');
    }
}

/*=============================================
BOTON GENERAR INFORME CLIENTES
=============================================*/
function informeClientes(){
    
    var motivo = $("#motivoInformeClientes");
    var ruta="motivo="+motivo.val();
    if(motivo.val()==0){
        Swal.fire({
            type: "error",
            title: "Faltan Datos",
            text: "Seleccione el motivo del informe",
            confirmButtonText: "Cerrar"
        });
    }else if(motivo.val() == 'infoClientes'){
        window.open("extensiones/tcpdf/pdf/clientes.php", "_blank");
        motivo.val(0);
        $('#modalClientesInformacion').modal('hide');
    }else if(motivo.val() == 'morosos'){
        window.open("extensiones/tcpdf/pdf/morosos.php", "_blank");
        motivo.val(0);
        $('#modalClientesInformacion').modal('hide');
    }
}

$('#btnGenerarInforme').click(function(){

    var tipoAbast = obtenerGET(window.location)['abastecimiento'];
    if(Number(tipoAbast) == 2){
    
        let ruta="abastecimiento="+tipoAbast+"&item1="+obtenerGET(window.location)['item1']+"&item2="+obtenerGET(window.location)['item2'];
        window.open("extensiones/tcpdf/pdf/abastecimiento.php?"+ruta, "_blank");
    
    }else{
        var idProveedor = null;
        var datos = new FormData();
        datos.append("idProveedor", idProveedor);

        $.ajax({
            url:"ajax/informes.ajax.php",
            method: "POST",
            data: datos,
            cache: false,
            contentType: false,
            processData: false,
            dataType:"json",
            success:function(respuesta){
                const optionsFinal = {};
                optionsFinal[0] = 'Proveedor Nuevo';                
                respuesta.forEach((elemento) => {
                    optionsFinal[elemento.id] = elemento.alias_empresa.charAt(0).toUpperCase() + elemento.alias_empresa.slice(1);
                });

                (async () => {
                    const { idProv: seleccionado } = await Swal.fire({
                        title: "A quién enviará solicitud de precios?",
                        input: "select",
                        inputOptions: optionsFinal,
                        inputPlaceholder: "Seleccione Proveedor",
                        showCancelButton: true,
                        didOpen: () => {

                            const select = document.querySelector('select.swal2-select');
                            const opcionesArray = Array.from(select.options); // opciones actuales
                            opcionesArray.sort((a, b) => a.text.localeCompare(b.text)); // se ordenan en array por texto
                            select.innerHTML = ""; // se vacia el select
                            
                            opcionesArray.forEach(opcion => { // primero seleccione proveedor
                                if(opcion.innerText == 'Seleccione Proveedor'){
                                    select.appendChild(opcion);
                                }
                            });

                            opcionesArray.forEach(opcion => { // segundo nuevo proveedor
                                if(opcion.innerText == 'Proveedor Nuevo'){
                                    select.appendChild(opcion);
                                }
                            });


                            opcionesArray.forEach(opcion => { // se agregan ordenadas alfabeticamente el resto de proveedores
                                if(opcion.value != 0){
                                    select.appendChild(opcion);
                                }
                            });
                        },
                        inputValidator: (idProv) => {
                            return new Promise((resolve) => {
                                if (idProv && optionsFinal[idProv]) {        
                                    resolve();

                                    let ruta="abastecimiento="+tipoAbast+"&item1="+obtenerGET(window.location)['item1']+"&item2="+obtenerGET(window.location)['item2']+"&prov="+idProv;
                                    window.open("extensiones/tcpdf/pdf/abastecimiento.php?"+ruta, "_blank");

                                } else {
                                    resolve("Seleccione algún proveedor");
                                }
                            });
                        }
                    });
                })()
            }
        })
    }
});

