/*=============================================
RANGO DE FECHAS
=============================================*/
if(localStorage.getItem("capturarRangoCot") != null){
    $("#daterange-cot span").html(localStorage.getItem("capturarRangoCot"));
}else{
    $("#daterange-cot span").html('<i class="fa fa-calendar"></i> Rango de fecha')
}
$('#daterange-cot').daterangepicker(
    {
        ranges: {
            'Cotizaciones'       : [moment().subtract(1, 'month'), moment()],
            'Este mes'  : [moment().startOf('month'), moment().endOf('month')],
            'Mes Anterior'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Este año'  : [moment().startOf('year'), moment().endOf('year')],
            'Año Anterior'  : [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        },
        startDate: moment(),
        endDate  : moment()
    },
    function (start, end){
        var fechaInicial = start.format('YYYY-MM-DD');
        var fechaFinal = end.format('YYYY-MM-DD');
        var hoy = moment(new Date()).format('YYYY-MM-DD');
        var fecha1 = fechaInicial;
        var fecha2 = fechaFinal;
        $('#daterange-cot span').html(moment(fecha1).format('DD-MM-YY') + ' - ' + moment(fecha2).format('DD-MM-YY'));
        var capturarRango = $("#daterange-cot span").html();
        localStorage.setItem("capturarRangoCot", capturarRango);
        window.location = "index.php?ruta=cotizaciones&fechaInicial="+fecha1+"&fechaFinal="+fecha2;
    }
)

$('#actualizarTblCotProds').click(function(){
	$('.tablaCotizadorProductos').DataTable().ajax.reload();	
})
var perfil = $("#perfilVendedorCot").val();
var tablaCotizacionesMovil = $('.tablaCotizacionesMovil').DataTable( {
    "ajax": "ajax/datatable-cotizaciones-movil.ajax.php",
    "order": [ 0, "desc" ], //orden descendente por defecto
    "deferRender": true,
	"retrieve": true,
	"processing": true,
    "createdRow": function(row, data, dataIndex) {
 	   $(row).addClass('filaSeleccionable');
	},
	"language": {
	    "sProcessing":     "Procesando...",
	    "sLengthMenu":     "",
	    "sZeroRecords":    "No se encontraron resultados",
	    "sEmptyTable":     "Ningún dato disponible en esta tabla",
	    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
	    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
	    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
	    "sInfoPostFix":    "",
	    "sSearch": "<button class='btn btn-info btn-sm' onclick='actualizarTabla();'><i class='fas fa-undo'></i></button>    Buscar",
	    "sUrl": "",
	    "sInfoThousands": ",",
	    "sLoadingRecords": "Cargando...",
	    "oPaginate": {
	      "sFirst": "Primero",
	      "sLast": "Último",
	      "sNext": "&rarr;",
	      "sPrevious": "&larr;"
	    },
	    "oAria": {
	      "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
	      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
	    }

	},
	// dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',
});


$(".tablaCotizaciones").on("click", ".reimprimirTicketCot", function(){
	idCot = $(this).attr('idCot');
	Swal.fire({
		icon:"question",
			title: "<h1>¿Imprimir Ticket?</h1>",
			showDenyButton: true,
		confirmButtonText: "SI",
		denyButtonText: "NO",
		customClass: {
			actions: "my-actions",
			cancelButton: "order-1 right-gap boton-cancelar",
			confirmButton: "order-2 btn boton-confirmar",
			denyButton: "order-3 btn boton-denegar",
			title: "titulo-modif",
			}
	}).then((result) => {
		if (result.isConfirmed) {
			extraerDatosCotTicket(idCot);
	  	} else if (result.isDenied) {
	  		Swal.close();
		}
	})
})


var tablaCotizaciones = $('.tablaCotizaciones').DataTable( {
    "ajax": "ajax/datatable-cotizaciones.ajax.php?fechaInicial="+obtenerGET(window.location)['fechaInicial']+"&fechaFinal="+obtenerGET(window.location)['fechaFinal'],
    "deferRender": true,
	"retrieve": true,
	"mark": true,
	"processing": true,
    "createdRow": function(row, data, dataIndex) {
 	   $(row).addClass('filaSeleccionable');
	},
	"language": {
		"sProcessing":     "Procesando...",
		"sLengthMenu":     "Mostrar _MENU_ registros",
		"sZeroRecords":    "No se encontraron resultados",
		"sEmptyTable":     "Ningún dato disponible en esta tabla",
		"sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
		"sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
		"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
		"sInfoPostFix":    "",
		"sSearch":         "Buscar (F3):",
		"sUrl":            "",
		"sInfoThousands":  ",",
		"sLoadingRecords": "Cargando...",
		"oPaginate": {
		"sFirst":    "Primero",
		"sLast":     "Último",
		"sNext":     "Siguiente",
		"sPrevious": "Anterior"
		},
		"oAria": {
			"sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		}
	},
  	dom: botonesDT,
  	buttons:
  		[
			{ // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
                text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
                action: function ( e, dt, node, config ) {
					dt.clear().draw();
					dt.ajax.reload();
                }
            },
            { //Vista de columas
		        extend: 'colvis',
		        footer: true,
		        text: '<button class="btn btn-sm bg-lightblue info" data-original-title="Vista Columnas" data-placement="bottom"><i class="fa-solid fa-eye"></i></button>'
			}
	    ]	
		,
	    columnDefs: [ // SETEO DE COLUMNAS QUE SE VEN POR DEFECTO
	        {
	            targets: 4,
	            visible: false
	        },

	        // {
	        //     targets: 0,
	        //     visible: false
	        // }	        
	    ],
});


$('.tablaCotizaciones tbody').on('click', 'tr.filaSeleccionable', function() {
    // if (event.ctrlKey) {
		$(this).toggleClass('filaSeleccionada'); // Alternar la clase 'seleccionada'
		let nroFilasSeleccionadas = $('.filaSeleccionada').length;
		if( Number(nroFilasSeleccionadas) > 0){
			$('.consolidarVenta').removeAttr('disabled');
		}else{
			$('.consolidarVenta').attr('disabled','disabled');
		}
	// }
});

$('.tablaCotizacionesMovil tbody').on('click', 'tr.filaSeleccionable', function() {
	// alert()
    // if (event.ctrlKey) {
		$(this).toggleClass('filaSeleccionada'); // Alternar la clase 'seleccionada'
		let nroFilasSeleccionadas = $('.filaSeleccionada').length;
		if( Number(nroFilasSeleccionadas) > 0){
			$('.consolidarVentaMovil').removeAttr('disabled');
		}else{
			$('.consolidarVentaMovil').attr('disabled','disabled');
		}
	// }
});

$('.consolidarVenta').click(function(){
	idsCotizaciones = [];
    var filasSeleccionadas = $('.tablaCotizaciones').DataTable().rows('.filaSeleccionada').nodes();
    // var filasSeleccionadas = $('.tablaCotizaciones').DataTable().rows('.filaSeleccionada').nodes();
    $(filasSeleccionadas).each(function (){ // Recorre las filas seleccionadas
		var fila = $(this);
		var idCot = fila.find('td:eq(5)').text();
		idsCotizaciones.push(idCot);
    });
	var datos = new FormData();
	datos.append('consolidarVenta', idsCotizaciones);
	$.ajax({
	    url:'ajax/cotizaciones.ajax.php',
	    method: 'POST',
	    data: datos,
	    cache: false,
	    contentType: false,
	    processData: false,
		beforeSend: function(){
			$('.spinerCarga').html('<div class="overlay"><i class="fas fa-2x fa-sync fa-spin"></i></div>');
  		},	    
	    success:function(resp){
			r = JSON.parse(resp);
			$('.spinerCarga').html('');
		    $("#contenidoConsolidarVenta").html("");
		    var totalProdsConsolidar = 0;
			$(r).each(function (i){
				
				let idProd = r[i].id;
				let cantComprar = r[i].cantComprar;
				let cantEnLocales = r[i].cantEnLocales;
				let cantDespuesVenta = r[i].cantDespuesVenta;
				let estadoDespuesVenta = r[i].estadoDespuesVenta;


				let cotizacionesInvolucradas = JSON.parse(r[i].cotizaciones);
				let cotizacionesMostrar = cotizacionesInvolucradas.length == 1 ? 'COT INVOLUCRADA: ' : 'COTS INVOLUCRADAS: ';
				$(cotizacionesInvolucradas).each(function (i){
					if(i == 0){
						cotizacionesMostrar += cotizacionesInvolucradas[i];
					}else{
						cotizacionesMostrar += ' - ' + cotizacionesInvolucradas[i];
					}
				})

				let sku = infoProd(idProd)['sku'];
				let descripcion = infoProd(idProd)['descripcion'];
				let sucursal = $('#sucursalActiva').val();
				let stockIdealSucursal = infoProd(idProd)['stock_ideal_'+sucursal];


				totalProdsConsolidar = Number(totalProdsConsolidar) + Number(cantComprar);

				// let fondoDIV = Number(cantComprar) == 0 ? 'lightgreen' : '';
				if(Number(cantComprar) == 0 && Number(estadoDespuesVenta) <= 0.33){ // no se necesita comprar pero el estado del stock despues de vender sería critico
					var recomendacion = '<font size="+1">Se recomienda comprar, después de vender quedarían solo <b>'+cantDespuesVenta+'u</b>, quedando en estado <b>CRÍTICO</b> de stock <b>('+cantDespuesVenta+'/'+stockIdealSucursal+')</b></font>';
					var fondoDIV = 'lightpink';
				}else if(Number(cantComprar) == 0 && Number(estadoDespuesVenta) > 0.33 && Number(estadoDespuesVenta) <= 0.66){
					var recomendacion = '<font size="+1">Quedaría en estado <b>ACEPTABLE</b> de stock <b>('+cantDespuesVenta+'/'+stockIdealSucursal+')</b></font>';
					var fondoDIV = 'rgb(255,255,128)';
				}else if(Number(cantComprar) == 0 && Number(estadoDespuesVenta) > 0.66){
					var recomendacion = 'Quedaría en estado <b>IDEAL</b> de stock <b>('+cantDespuesVenta+'/'+stockIdealSucursal+')</b>. NO SE ACONCEJA COMPRAR MÁS PRODUCTOS</font>';
					var fondoDIV = 'lightcyan';
				}else{
					var recomendacion = '';
					var fondoDIV = '';
				}

		      	$("#contenidoConsolidarVenta").prepend(
		        	'<div class="row mb-1 col-12" id="borde" style="background-color:'+fondoDIV+'; padding:20px 20px; border-style: dashed; border-width: 1px;">'+
		          		'<div class="col-12">'+recomendacion+'</div>'+
		          		'<div class="col-2 ingCantAbast">'+
		            		'<font size="-1">Cantidad</font>'+
		            		'<div class="input-group">'+
		              		'<input type="number" class="form-control cantProdsConsolidar" onchange="listarProductosConsolidar()" idProd="'+idProd+'" min="0" value="'+cantComprar+'" required>'+
		            	'</div>'+
		          	'</div>'+
		          	'<div class="col-9" style="padding-left:0px;padding-right:0px">'+
		            	'<i><b>'+cotizacionesMostrar+'</b></i>'+
		            	'<br><font size="+1">SKU: <b>'+sku+'</b><br>'+descripcion+'</font>'+
					'</div>'+
					'<div class="col-1" style="padding-left:0px;padding-right:0px">'+
		            	'<button type="button" class="btn btn-danger float-right btn-xs quitarProdConsolidar" idProducto="'+idProd+'"><i class="fa fa-times"></i></button> '+
		        	'</div>'+
		        	'<div id="esp'+idProd+'" style="height:3px"></div>')
  			});
  			listarProductosConsolidar();
  			if(Number(totalProdsConsolidar) <= 0){
  				$('.botonesConsolidarVenta').attr('disabled','disabled');
  			}
	    }
	})
})

$('.consolidarVentaMovil').click(function(){
	idsCotizaciones = [];
    var filasSeleccionadas = $('.tablaCotizacionesMovil').DataTable().rows('.filaSeleccionada').nodes();

    // var filasSeleccionadas = $('.tablaCotizaciones').DataTable().rows('.filaSeleccionada').nodes();
    $(filasSeleccionadas).each(function (){ // Recorre las filas seleccionadas
		var fila = $(this);
		var textoCot = fila.find('td:eq(0)').text();
		const idCot = textoCot.match(/Cotización Nro\. (\d+)/)[1];
		idsCotizaciones.push(idCot);
    });
	var datos = new FormData();
	datos.append('consolidarVenta', idsCotizaciones);
	$.ajax({
	    url:'ajax/cotizaciones.ajax.php',
	    method: 'POST',
	    data: datos,
	    cache: false,
	    contentType: false,
	    processData: false,
		beforeSend: function(){
			$('.spinerCarga').html('<div class="overlay"><i class="fas fa-2x fa-sync fa-spin"></i></div>');
  		},	    
	    success:function(resp){
			r = JSON.parse(resp);
			$('.spinerCarga').html('');
		    $("#contenidoConsolidarVenta").html("");
		    var totalProdsConsolidar = 0;
			$(r).each(function (i){
				
				let idProd = r[i].id;
				let cantComprar = r[i].cantComprar;
				let cantEnLocales = r[i].cantEnLocales;
				let cantDespuesVenta = r[i].cantDespuesVenta;
				let estadoDespuesVenta = r[i].estadoDespuesVenta;

				let sku = infoProd(idProd)['sku'];
				let descripcion = infoProd(idProd)['descripcion'];
				let sucursal = $('#sucursalActiva').val();
				let stockIdealSucursal = infoProd(idProd)['stock_ideal_'+sucursal];


				totalProdsConsolidar = Number(totalProdsConsolidar) + Number(cantComprar);

				// let fondoDIV = Number(cantComprar) == 0 ? 'lightgreen' : '';
				if(Number(cantComprar) == 0 && Number(estadoDespuesVenta) <= 0.33){ // no se necesita comprar pero el estado del stock despues de vender sería critico
					var recomendacion = '<font size="+1">Se recomienda comprar, después de vender quedarían solo <b>'+cantDespuesVenta+'u</b>, quedando en estado <b>CRÍTICO</b> de stock <b>('+cantDespuesVenta+'/'+stockIdealSucursal+')</b></font>';
					var fondoDIV = 'lightpink';
				}else if(Number(cantComprar) == 0 && Number(estadoDespuesVenta) > 0.33 && Number(estadoDespuesVenta) <= 0.66){
					var recomendacion = '<font size="+1">Quedaría en estado <b>ACEPTABLE</b> de stock <b>('+cantDespuesVenta+'/'+stockIdealSucursal+')</b></font>';
					var fondoDIV = 'rgb(255,255,128)';
				}else if(Number(cantComprar) == 0 && Number(estadoDespuesVenta) > 0.66){
					var recomendacion = 'Quedaría en estado <b>IDEAL</b> de stock <b>('+cantDespuesVenta+'/'+stockIdealSucursal+')</b>. NO SE ACONCEJA COMPRAR MÁS PRODUCTOS</font>';
					var fondoDIV = 'lightcyan';
				}else{
					var recomendacion = '';
					var fondoDIV = '';
				}

		      	$("#contenidoConsolidarVenta").prepend(
		        	'<div class="row mb-1 col-12" id="borde" style="background-color:'+fondoDIV+'; padding:20px 20px; border-style: dashed; border-width: 1px;">'+
		          		'<div class="col-12">'+recomendacion+'</div>'+
		          		'<div class="col-2 ingCantAbast">'+
		            		'<font size="-1">Cantidad</font>'+
		            		'<div class="input-group">'+
		              		'<input type="number" class="form-control cantProdsConsolidar" onchange="listarProductosConsolidar()" idProd="'+idProd+'" min="0" value="'+cantComprar+'" required>'+
		            	'</div>'+
		          	'</div>'+
		          	'<div class="col-9" style="padding-left:0px;padding-right:0px">'+
		            	'<br><font size="+1">SKU: <b>'+sku+'</b><br>'+descripcion+'</font>'+
					'</div>'+
					'<div class="col-1" style="padding-left:0px;padding-right:0px">'+
		            	'<button type="button" class="btn btn-danger float-right btn-xs quitarProdConsolidar" idProducto="'+idProd+'"><i class="fa fa-times"></i></button> '+
		        	'</div>'+
		        	'<div id="esp'+idProd+'" style="height:3px"></div>')
  			});
  			listarProductosConsolidar();
  			if(Number(totalProdsConsolidar) <= 0){
  				$('.botonesConsolidarVenta').attr('disabled','disabled');
  			}
	    }
	})
})

$('#modalConsolidarVenta').on("change", "input.cantProdsConsolidar", function() {
	let cant = $(this).val();
	if(Number(cant) < 0){
		$(this).val(0);
	}
    var inputsCant = $('.cantProdsConsolidar');
    var suma = 0;
    for (var i = 0; i < inputsCant.length; i++) {
		suma += parseFloat(inputsCant[i].value) || 0;
    }
    if(Number(suma) > 0){
		$('.botonesConsolidarVenta').removeAttr('disabled');
    }else{
    	$('.botonesConsolidarVenta').attr('disabled','disabled');
    }
})

$("#modalConsolidarVenta").on("click", "button.quitarProdConsolidar", function(){
  	$(this).parent().parent().parent().children('#esp'+$(this).attr('idProducto')).remove();
  	$(this).parent().parent().remove();
	var idProducto = $(this).attr("idProducto");
  	$("button[idProducto='"+idProducto+"']").removeAttr('disabled');
  	$("button.recuperarBoton[idProducto='"+idProducto+"']").addClass('agregarCodBarras');
  	$("button[idProducto='"+idProducto+"']").removeClass('recuperarBoton');
  	listarProductosConsolidar();
    var inputsCant = $('.cantProdsConsolidar');
    if(inputsCant.length == 0){
		$('#modalConsolidarVenta').modal('hide');
    }else{
		$('.botonesConsolidarVenta').removeAttr('disabled');    	
    }
})

function textoParaWhatsappConsolidarVenta(){	
    var idProveedor = null;
    var datos = new FormData();
    datos.append("idProveedor", idProveedor);
    $.ajax({
        url:"ajax/informes.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType:"json",
        success:function(respuesta){

            const optionsFinal = {};
            optionsFinal[0] = 'Proveedor Nuevo';
            respuesta.forEach((elemento) => {
                optionsFinal[elemento.id] = elemento.alias_empresa.charAt(0).toUpperCase() + elemento.alias_empresa.slice(1);
            });

            (async () => {
                const { idProv: seleccionado } = await Swal.fire({
                    title: "A quién enviará solicitud de precios?",
                    input: "select",
                    inputOptions: optionsFinal,
                    inputPlaceholder: "Seleccione Proveedor",
                    showCancelButton: true,
      				didOpen: () => {

						const select = document.querySelector('select.swal2-select');
						const opcionesArray = Array.from(select.options); // opciones actuales
						opcionesArray.sort((a, b) => a.text.localeCompare(b.text)); // se ordenan en array por texto
						select.innerHTML = ""; // se vacia el select
						
						opcionesArray.forEach(opcion => { // primero seleccione proveedor
							if(opcion.innerText == 'Seleccione Proveedor'){
						  		select.appendChild(opcion);
							}
						});

						opcionesArray.forEach(opcion => { // segundo nuevo proveedor
							if(opcion.innerText == 'Proveedor Nuevo'){
						  		select.appendChild(opcion);
							}
						});


						opcionesArray.forEach(opcion => { // se agregan ordenadas alfabeticamente el resto de proveedores
							if(opcion.value != 0){
						  		select.appendChild(opcion);
							}
						});
					},
                    inputValidator: (idProv) => {
                        return new Promise((resolve) => {

                            if (idProv == ''){
                                resolve("Seleccione algún proveedor");
                            }else{
                                resolve();
                                var datos = new FormData();
                                var listaProductosConsolidarVenta = $('#listaProductosConsolidar').val();
                                datos.append("textoWspConsolidarVenta", listaProductosConsolidarVenta);
                                datos.append("idProv", idProv);
                                $.ajax({
                                    url: "ajax/cotizaciones.ajax.php",
                                    method: "POST",
                                    data: datos,
                                    cache: false,
                                    contentType: false,
                                    processData: false,
                                    success: function(r){
                                        let textoWsp = r.split('////')[0];
                                        let totalNeto = r.split('////')[1];
                                        textoWsp += '\nTotal Neto : $ '+formatNumber.new(Math.round(totalNeto))+'\n*Total c/IVA: $ '+formatNumber.new(Math.round(totalNeto*1.19))+'*';
										copiarTexto(textoWsp.replace(/\\n/g, '\n'));
                                        Swal.mixin({toast: true,position: 'top',showConfirmButton: false,showCloseButton: true,timer: 5000}).fire({icon: 'success',title: 'Copia Exitosa \n\n Total Estimado \n $'+formatNumber.new(Math.round(totalNeto))+' / $'+formatNumber.new(Math.round(totalNeto*1.19))});
										$('#modalConsolidarVenta').modal('hide');
                                    }
                                })
                            }
                        });
                    }
                });
            })()
        }
    })
}

function generarPDFPedidoConsolidar(){
    var idProveedor = null;
    var datos = new FormData();
    datos.append("idProveedor", idProveedor);
    $.ajax({
        url:"ajax/informes.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType:"json",
        success:function(respuesta){
            const optionsFinal = {};
            optionsFinal[0] = 'Proveedor Nuevo';
            respuesta.forEach((elemento) => {
                optionsFinal[elemento.id] = elemento.alias_empresa.charAt(0).toUpperCase() + elemento.alias_empresa.slice(1);
            });
            (async () => {
                const { idProv: seleccionado } = await Swal.fire({
                    title: "A quién enviará solicitud de precios?",
                    input: "select",
                    inputOptions: optionsFinal,
                    inputPlaceholder: "Seleccione Proveedor",
                    showCancelButton: true,
      				didOpen: () => {

						const select = document.querySelector('select.swal2-select');
						const opcionesArray = Array.from(select.options); // opciones actuales
						opcionesArray.sort((a, b) => a.text.localeCompare(b.text)); // se ordenan en array por texto
						select.innerHTML = ""; // se vacia el select
						
						opcionesArray.forEach(opcion => { // primero seleccione proveedor
							if(opcion.innerText == 'Seleccione Proveedor'){
						  		select.appendChild(opcion);
							}
						});

						opcionesArray.forEach(opcion => { // segundo nuevo proveedor
							if(opcion.innerText == 'Proveedor Nuevo'){
						  		select.appendChild(opcion);
							}
						});


						opcionesArray.forEach(opcion => { // se agregan ordenadas alfabeticamente el resto de proveedores
							if(opcion.value != 0){
						  		select.appendChild(opcion);
							}
						});
					},                    
                    inputValidator: (idProv) => {
                        return new Promise((resolve) => {
                            if (idProv == ''){
                                resolve("Seleccione algún proveedor");
                            }else{
                                resolve();
								var listaProductos = [];
								var cant = $(".cantProdsConsolidar");
								for (var i = 0; i < cant.length; i++){
									listaProductos.push({
										"id": $(cant[i]).attr("idProd"),
										"cant": $(cant[i]).val()
									})
								}
								window.open("extensiones/tcpdf/pdf/pedido-consolidar.php?prov="+idProv+"&prods=" + JSON.stringify(listaProductos), "_blank");
                            }
                        });
                    }
                });
            })()
        }
    })
}

function listarProductosConsolidar(){
  	var total = 0;
	var listaProductos = [];
	var cant = $(".cantProdsConsolidar");
	for (var i = 0; i < cant.length; i++){
		listaProductos.push({
			"id": $(cant[i]).attr("idProd"),
			"cantComprar": $(cant[i]).val()
		})
		total = Number(total) + Number($(cant[i]).val()*$(cant[i]).attr("p_con_iva"));
	}
	$("#listaProductosConsolidar").val(JSON.stringify(listaProductos));
}


var tablaCotizador = $('.tablaCotizadorProductos').DataTable( {
    "ajax": "ajax/datatable-cotizadorProductos.ajax.php",
    "deferRender": true,
	"retrieve": true,
	"processing": true,
	 "language": {

			"sProcessing":     "Procesando...",
			"sLengthMenu": "Mostrar _MENU_ registros",
			"sZeroRecords":    "No se encontraron resultados",
			"sEmptyTable":     "Ningún dato disponible en esta tabla",
			"sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
			"sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
			"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
			"sInfoPostFix":    "",
			"sSearch":         "Buscar (F3):",
			"sUrl":            "",
			"sInfoThousands":  ",",
			"sLoadingRecords": "Cargando...",
			"oPaginate": {
			"sFirst":    "Primero",
			"sLast":     "Último",
			"sNext":     "Siguiente",
			"sPrevious": "Anterior"
			},
			"oAria": {
				"sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
				"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			}

	},
  	dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
  	buttons:

  		[
			{ // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
                text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
                action: function ( e, dt, node, config ) {
					dt.clear().draw();
					dt.ajax.reload();
                }
            }	      
	    ]	
} );

var tablaCotizadorMovil = $('.tablaCotizadorProductosMovil').DataTable({
	"ajax": "ajax/datatable-cotizadorProductosMovil.ajax.php?perfil="+perfil+"&skuProdComun="+ajuste('sku_prod_comun')+"&utMin="+ajuste('ut_min_admin_cot'),
	"deferRender": true,
	"retrieve": true,
	"processing": true,
	"language": {

		"sProcessing": "Procesando...",
		"sLengthMenu": "Mostrar _MENU_ registros",
		"sZeroRecords": "No se encontraron resultados",
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		"sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
		"sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		"sInfoPostFix": "",
		"sSearch": "<button class='btn btn-info btn-sm' onclick='actualizarTabla();'><i class='fas fa-undo'></i></button>    Buscar",
		"sUrl": "",
		"sInfoThousands": ",",
		"sLoadingRecords": "Cargando...",
		"oPaginate": {
			"sFirst": "Primero",
			"sLast": "Último",
			"sNext": "Siguiente",
			"sPrevious": "Anterior"
		},
		"oAria": {
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		}

	},
	dom: '<"row"<"col-sm-12 col-md-4"f>>t<"row">'
});


/*=============================================
FUNCIÓN PARA DESACTIVAR LOS BOTONES AGREGAR CUANDO EL PRODUCTO YA HABÍA SIDO SELECCIONADO EN LA CARPETA
=============================================*/
$('.tablaCotizadorProductos,.tablaCotizadorProductosMovil').on('draw.dt', function() {

	dispositivo = screen.width >= 992 ? '' : 'Movil';

	//Capturamos todos los id de productos que fueron elegidos en la venta
	var idProductos = $(".quitarProductoCot");

	//Capturamos todos los botones de agregar que aparecen en la tabla
	var botonesTabla = $(".tablaCotizadorProductos"+dispositivo+" tbody button.agregarProductoCot");

	//Recorremos en un ciclo para obtener los diferentes idProductos que fueron agregados a la venta
	for (var i = 0; i < idProductos.length; i++) {

		//Capturamos los Id de los productos agregados a la venta
		var boton = $(idProductos[i]).attr("idProducto");

		//Hacemos un recorrido por la tabla que aparece para desactivar los botones de agregar
		for (var j = 0; j < botonesTabla.length; j++) {

			if ($(botonesTabla[j]).attr("idProducto") == boton) {

				$(botonesTabla[j]).removeClass("btn-primary agregarProductoCot");
				$(botonesTabla[j]).addClass("btn-default");

			}
		}

	}
})


/*=============================================
SUMAR ITEMS
=============================================*/
function sumTotales(){

	var total = 0;
	var totalProdsSinSumaUtilidad = 0;
	var utilidad = 0;

	$(".totItemCot, .utItemCot").each(function(){
	    let idProd = $(this).attr('idProd');
	    let val = parseInt($(this).val()) || 0;

	    if ($(this).hasClass('totItemCot')) {
	        total += val;
	        if ($(this).hasClass('servicio')) {
	            totalProdsSinSumaUtilidad += val;
	        }
	    }

	    if ($(this).hasClass('utItemCot')) {
            utilidad += val;
	    }
	});	
	$('#totCot').val(total);
	$('#totCotMostrar').text('   '+formatNumber.new(total));
	porcentajeUtilidad = (Math.round((Number(utilidad)/(total-utilidad-totalProdsSinSumaUtilidad))*10000))/100; //dcto con 2 decimales
		
	$('#utTotCot').val(utilidad);
	$('#utTotCotMostrar').text('   '+formatNumber.new(utilidad)+' ('+porcentajeUtilidad+'%)');
}

$('#newCot').on('click', function(){
	window.location = 'cotizador';
})

/*=============================================
HACER CLICK AL BUSCAR EN DATATABLE
=============================================*/
$('div.dataTables_filter').keyup(function(e){
	if(e.keyCode == 13){
	  	$('#agregarProductoCot0').click(); // HACE CLICK EN LA PRIMERA COINCIDENCIA DE LA BUSQUEDA DATATABLE
	   	$('#tablaCotizadorProductos').dataTable().fnFilter('');// MUESTRA TODA LA TABLA DEJANDO INVALIDO EL SEARCH, PERO NO BORRA EL INPUT
    }
});

/*=============================================
AGREGAR PRODS A COT DESDE LA TABLA
=============================================*/
$(".tablaCotizadorProductos,.tablaCotizadorProductosMovil tbody").on("click", "button.agregarProductoCot", function(){
	var idProducto = $(this).attr("idProducto");
    var sucursal = $('#sucursalActiva').val();
	var perfilVend = perfil == 'Administrador' ? 'admin' : 'vend';
	var servicio = $(this).hasClass("servicio");

	$(this).removeClass("btn-primary agregarProductoCot");
	$(this).addClass("btn-default");

	var datos = new FormData();
    datos.append("idProducto", idProducto);
    $.ajax({
     	url:"ajax/productos.ajax.php",
      	method: "POST",
      	data: datos,
      	cache: false,
      	contentType: false,
      	processData: false,
      	dataType:"json",
      	success:function(respuesta){


			var descripcion = respuesta["descripcion"];
			var codigoInterno = respuesta["sku"];
			var maneja_stock = respuesta["maneja_stock"];
			var stock = respuesta["stock_"+sucursal];
			var precio = respuesta["precio_venta"];
			var descuento = respuesta["descuento"];
			var mayoreo = respuesta["mayor_sobre"];
			var precioMayor = respuesta["precio_mayor"];
			var pComp = respuesta["precio_compra"];
			var ubic = respuesta["zona_"+sucursal];
			
			var ut_min_cot = ajuste('ut_min_'+perfilVend+'_cot');


			var classServicio = servicio == true ? 'servicio' : '';

			var utilidadInicial = classServicio != 'servicio' ? precio-pComp : 0;
			if(perfil == 'Administrador'){ // ADMINISTRADOR
				var pMinProd = Number(pComp)*(1+Number(ut_min_cot)/100) > Number(precio) ? Number(precio) : Math.round(Number(pComp)*(1+Number(ut_min_cot)/100));

				var pMinProdFinal = Number(pMinProd) > Number(precioMayor) ? Math.round(Number(precioMayor)) : Math.round(Number(pMinProd));
				var max_dcto = Math.round((100-(pMinProdFinal/precio*100))*100)/100;
				var maxDctoMostrar = max_dcto > descuento ? max_dcto : descuento;
				var descripMostrar = '<font size="-1"><i>Precio Compra <b>'+formatNumber.new((Math.round(pComp/1.19*100)/100), "$")+'/'+formatNumber.new(pComp, "$")+'</b></i>    DCTO MAX: <b>'+maxDctoMostrar+'%</b></font>';
				
				if(Math.round(Number(pComp)*(1+Number(ut_min_cot)/100))>precio){
					sugerencia = '['+formatNumber.new(Math.round(Number(precio)), "$")+' - '+formatNumber.new(Math.round(Number(precio*1.2)), "$")+']<br><i style="color:red">Se recomienda subir Precio Venta</i>';
					disabled = '';
				}else{
					sugerencia = '10% ['+formatNumber.new(Math.round(Number(pMinProdFinal)), "$")+' - '+formatNumber.new(precio, "$")+']<br>'+
								 '<b>20% ['+formatNumber.new(Math.round(Number(pComp)*1.2), "$")+' - '+formatNumber.new(precio, "$")+']</b>';
					disabled = '';
				}

				show = $('#btnMostrarUtilidad').hasClass('collapsed') ? '' : 'show'; // FILTRO PARA DETECTAR SI SE MUESTRA O NO UTILIDAD



	          	$(".nuevoProductoCot").prepend(
		          	'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
		            	'<div class="col-9 tipoProd" tipoProd="'+classServicio+'" style="padding-left:0px">'+
		              		'<div>'+
		                		'<div>'+
		                  			'<button type="button" class="btn btn-danger btn-xs quitarProductoCot" idproducto="'+idProducto+'">'+
		                    			'<i class="fa fa-times"></i>'+
		                  			'</button>'+
		                  			'<font size="-1"> '+descripMostrar+'</font>'+
								  	'<input type="text" class="form-control descProdCot" style="height:25px; width:100%" idProducto="' + idProducto + '" codigoInterno="' + codigoInterno + '" name="agregarProducto" value="' + descripcion + '" required>'+
		                		'</div>'+
		              		'</div>'+
		            	'</div>'+
		            	'<div class="col-3 float-right" style="padding-left:0px">'+
							'<font size="-2">Sugerencia</font><br>'+
							'<font size="-1">'+sugerencia+
		            	'</div>'+
		            	'<div style="height:25px"></div>'+
		              	// CANTIDAD
		              	'<div class="col-3 col-lg-2 cantCot" style="padding-left:0px">'+
		                	'<font size="-2">Cantidad</font>'+
		                	'<font class="d-lg-none" size="-2">Cant</font>'+
		                	'<div class="input-group">'+
			                	'<input type="number" class="form-control cantItemCot" style="height: 30px; font-size: 10pt" id="cantItemCot" min="1" value="1" stock="' + stock + '" mayoreo="' + mayoreo + '" nuevoStock="' + Number(stock - 1) + '" required>'+
		                	'</div>'+
		              	'</div>'+
		              	// PRECIO UNITARIO
		              	'<div class="col-6 col-lg-3 pCot" style="padding-left:0px">'+
		                	'<font size="-2">Precio Unit ('+formatNumber.new(precio, "$")+')</font>'+
		                	'<div class="input-group">'+
		                  		'<input type="number" style="height: 30px; font-size: 10pt" min="'+pMinProdFinal+'" class="form-control pItemCot" id="pItemCot" pComp="' + pComp + '" pReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="' + precio + '" required '+disabled+'>'+
		                	'</div>'+
		              	'</div>'+
		              	// DCTO
		              	'<div class="col-3 col-lg-2 dctoCot" style="padding-left:0px">'+
		                	'<font size="-2" id="dcto">Dcto (%)</font>'+
		                	'<div class="input-group">'+
			                  	'<input type="number" style="height: 30px; font-size: 10pt" min="0" max="'+max_dcto+'" class="form-control dctoItemCot" id="dctoItemCot" precioReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="0" required '+disabled+'>'+
		                	'</div>'+
		              	'</div>'+
		              	// TOTAL
		              	'<div class="col-6 col-lg-3 totCot" style="padding-left:0px">'+
		                	'<font size="-2">Total ($)</font>'+
		                	'<div class="input-group">'+
			                  	'<input type="text" style="height: 30px; font-size: 10pt; background-color:rgb(98,249,210)" class="form-control totItemCot '+classServicio+'" idProd="'+idProducto+'" id="totItemCot" precioReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="' + precio + '" required disabled>'+
		                	'</div>'+
		              	'</div>'+
		              	// UTILIDAD
		              	'<div class="col-6 col-lg-2 utCot collapse '+show+'" id="collapseContent" style="padding-left:0px">'+
		                	'<font size="-2">Utilidad</font>'+
		                	'<div class="input-group">'+
			                  	'<input type="text" style="height: 30px; font-size: 10pt; background-color:rgb(169,249,98)" class="form-control utItemCot" id="utItemCot" idProd="'+idProducto+'" precioReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="' + utilidadInicial + '" required disabled>'+
		                	'</div>'+
		              	'</div>'+
			        '</div>'+
			        '<div id="esp'+idProducto+'" style="height:3px"></div>')

			}else{ // VENDEDOR O SIMILAR
				

				var pMinProd = Math.round(Number(pComp)*(1+Number(ut_min_cot)/100));

				// APLICAR ESCALA DE DESCUENTOS RESPECTO A PRODUCTO CON ALTA UTILIDAD
				if(Number(mayoreo) == 1 || Number(pMinProd)>Number(precioMayor)){ // prod en oferta ó <15%
					pMinCot = precioMayor;
				}else if(Number(precio/pComp)>=2){ // MAYOR A 100% UTILIDAD
					pMinCot = pComp*1.75;
				}else if(Number(precio/pComp)<2 && Number(precio/pComp)>=1.7){ // [70%-100%[
					pMinCot = pComp*1.6;
				}else if(Number(precio/pComp)<1.7 && Number(precio/pComp)>=1.5){ // [50%-70%[
					pMinCot = pComp*1.4;
				}else if(Number(precio/pComp)<1.5 && Number(precio/pComp)>=1.3){ // [30%-50%[
					pMinCot = pComp*1.25;
				}else{ // [15%-30%[
					pMinCot = pMinProd;
				}

				var max_dcto = Math.round((100-(pMinCot/precio*100))*100)/100;
				var maxDctoMostrar = max_dcto > descuento ? max_dcto : descuento;	
				var descripMostrar = '<font size="-2">Descripción    DCTO MAX: <b>'+maxDctoMostrar+'%</b></font>';
				sugerencia = '['+formatNumber.new(Math.round(Number(pMinCot)), "$")+' - '+formatNumber.new(precio, "$")+']';
				disabled = '';

	          	$(".nuevoProductoCot").prepend(

		          	'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
		            	'<div class="col-9 tipoProd" tipoProd="'+classServicio+'"" style="padding-left:0px">'+
		              		'<div>'+
		                		'<div>'+
		                  			'<button type="button" class="btn btn-danger btn-xs quitarProductoCot" idproducto="'+idProducto+'">'+
		                    			'<i class="fa fa-times"></i>'+
		                  			'</button>'+
		                  			'<font size="-1"> '+descripMostrar+'</font>'+
								  	'<input type="text" class="form-control descProdCot" style="height:25px; width:100%" idProducto="' + idProducto + '" codigoInterno="' + codigoInterno + '" name="agregarProducto" value="' + descripcion + '" required>'+
		                		'</div>'+
		              		'</div>'+
		            	'</div>'+

		              	// CANTIDAD
						'<div class="col-3 float-right" style="padding-left:0px">'+
							'<font size="-2">Sugerencia</font>'+
							'<br><font size="-1"><b>'+sugerencia+'</b>'+
		            	'</div>'+
		            	'<div style="height:25px"></div>'+
		              	'<div class="col-3 cantCot" style="padding-left:0px">'+
		                	'<font size="-2">Cantidad</font>'+
		                	'<font class="d-lg-none" size="-2">Cant</font>'+
		                	'<div class="input-group">'+
			                	'<input type="number" class="form-control cantItemCot" style="height: 30px; font-size: 10pt" id="cantItemCot" min="1" value="1" stock="' + stock + '" mayoreo="' + mayoreo + '" nuevoStock="' + Number(stock - 1) + '" required>'+
		              		'</div>'+
		              	'</div>'+

		              	// PRECIO UNITARIO
		              	'<div class="col-3 pCot" style="padding-left:0px">'+
		                	'<font size="-2">Precio Unit ('+formatNumber.new(precio, "$")+')</font>'+
		                	'<div class="input-group estepalo">'+
		                  		'<input type="number" style="height: 30px; font-size: 10pt" min="'+Math.round(pMinCot)+'" class="form-control pItemCot" id="pItemCot" pComp="' + pComp + '" pReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="' + precio + '" required '+disabled+'>'+
		                	'</div>'+
		              	'</div>'+

		              	// DCTO
						'<div class="col-3 dctoCot" style="padding-left:0px">'+
		                	'<font size="-2" id="dcto">Dcto (%)</font>'+
		                	'<div class="input-group">'+
			                  	'<input type="number" style="height: 30px; font-size: 10pt" min="0" max="'+max_dcto+'" class="form-control dctoItemCot" id="dctoItemCot" precioReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="0" required '+disabled+'>'+
		                	'</div>'+
		              	'</div>'+

		              	// TOTAL
		              	'<div class="col-3 totCot" style="padding-left:0px">'+
		                	'<font size="-2">Total ($)</font>'+
		                	'<div class="input-group">'+
			                  	'<input type="text" style="height: 30px; font-size: 10pt; background-color:rgb(98,249,210)" class="form-control totItemCot '+classServicio+'" idProd="'+idProducto+'" id="totItemCot" precioReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="' + precio + '" required disabled>'+
		                	'</div>'+
		              	'</div>'+

		              	// UTILIDAD
		              	'<div class="utCot d-none" id="collapseContent">'+
		                	'<font size="-2">Utilidad</font>'+
		                	'<div class="input-group">'+
			                  	'<input type="text" style="height: 30px; font-size: 10pt; background-color:rgb(169,249,98)" class="form-control utItemCot" idProd="'+idProducto+'" id="utItemCot" precioReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="' + utilidadInicial + '" required disabled>'+
		                	'</div>'+
		              	'</div>'+

			        '</div>'+
			        '<div id="esp'+idProducto+'" style="height:3px"></div>')				          	
			}
	        sumTotales()
	        listarProdsCot()
			localStorage.removeItem("quitarProductoCot");
	    }
	})

	$('#modalCotMovil').modal('hide');
});


/*=============================================
NOMBRE CLIENTE NUEVO COT
=============================================*/
$(".formularioCotizacion").on("change", "input.newClientCot", function(){
	$(".nomClientCot").val($(".newClientCot").val()+' ('+$("#contactClientCot").val()+')');	
})
$(".formularioCotizacion").on("change", "input#contactClientCot", function(){
	$(".nomClientCot").val($(".newClientCot").val()+' ('+$("#contactClientCot").val()+')');	
})

/*=============================================
MODIFICAR DESCRIPCION COT
=============================================*/
$(".formularioCotizacion").on("change", "input.descProdCot", function(){
	var descrip = $(this);
    listarProdsCot()
})

/*=============================================
MODIFICAR CANTIDAD
=============================================*/
$(".formularioCotizacion").on("change", "input.cantItemCot", function(){
	var pUnit = $(this).parent().parent().parent().parent().children(".pCot").children().children().children(".pItemCot");
	var dcto = $(this).parent().parent().parent().parent().children(".dctoCot").children().children().children(".dctoItemCot");
	var ut = $(this).parent().parent().parent().parent().children(".utCot").children().children().children(".utItemCot");
	var tot = $(this).parent().parent().parent().parent().children(".totCot").children().children().children(".totItemCot");

	var tipoProd = $(this).parent().parent().parent().parent().children(".tipoProd").attr('tipoProd');

	var cant = $(this);
	var pComp = pUnit.attr('pComp');
	// ACTUALIZAR TOTAL Y UTILIDAD ITEM
	tot.val(cant.val()*pUnit.val());

	if(tipoProd != 'servicio'){ // suma utilidad si es producto, no servicio
		ut.val((pUnit.val()-pComp)*cant.val())
	}

	sumTotales()
    listarProdsCot()
})		

/*=============================================
MODIFICAR PRECIO UNITARIO
=============================================*/
$(".formularioCotizacion").on("change", "input.pItemCot", function(){

	var cant = $(this).parent().parent().parent().parent().children('.cantCot').children().children().children('.cantItemCot');
	var dcto = $(this).parent().parent().parent().parent().children(".dctoCot").children().children().children(".dctoItemCot");
	var ut = $(this).parent().parent().parent().parent().children(".utCot").children().children().children(".utItemCot");
	var tot = $(this).parent().parent().parent().parent().children(".totCot").children().children().children(".totItemCot");

	var tipoProd = $(this).parent().parent().parent().parent().children(".tipoProd").attr('tipoProd');

	var pUnit = $(this);
	var pComp = pUnit.attr('pComp');
	// AUMENTO
	if(Number(pUnit.val())>pUnit.attr('pReal')){
		dcto.parent().parent().children('#dcto').text('Aumento (%)');
		dcto.val((Math.round(Number(pUnit.val())/Number(pUnit.attr('pReal'))*10000))/100);		
		dcto.attr('style','height: 30px; font-size: 10pt; background-color:rgb(247,122,85); color:white');
		pUnit.attr('style','height: 30px; font-size: 10pt; background-color:rgb(247,122,85); color:white');
	}else if(Number(pUnit.val()) == pUnit.attr('pReal')){
		dcto.attr('style','height: 30px; font-size: 10pt');
		pUnit.attr('style','height: 30px; font-size: 10pt');
		dcto.val(0);
	}else if(Number(pUnit.val()) == ""){
		dcto.attr('style','height: 30px; font-size: 10pt');
		pUnit.attr('style','height: 30px; font-size: 10pt');
		dcto.val(0);
		pUnit.val(pUnit.attr('pReal'));
	}else if(Number(pUnit.val()) < pUnit.attr('min')){
		dcto.attr('style','height: 30px; font-size: 10pt; background-color:rgb(169,249,98); color:black');
		dcto.val(Math.round((100-(pUnit.attr('min')/pUnit.attr('pReal')*100))*100)/100);		
		pUnit.attr('style','height: 30px; font-size: 10pt; background-color:rgb(169,249,98); color:black');
		pUnit.val(pUnit.attr('min'));
		new Audio('componentes/sonidos/error.wav').play();
		setTimeout(function(){
	    	Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'El precio no puede ser menor a '+formatNumber.new(pUnit.attr('min'), '$ ')});
		}, 200);

	}else{
		dcto.parent().parent().children('#dcto').text('Dcto (%)');
		dcto.val(Math.round((100-(pUnit.val()/pUnit.attr('pReal')*100))*100)/100);		
		dcto.attr('style','height: 30px; font-size: 10pt; background-color:rgb(169,249,98); color:black');
		pUnit.attr('style','height: 30px; font-size: 10pt; background-color:rgb(169,249,98); color:black');
	}
	tot.val(Math.round(cant.val()*pUnit.val()));

	if(tipoProd != 'servicio'){ // suma utilidad si es producto, no servicio
		ut.val((pUnit.val()-pComp)*cant.val());
	}

	sumTotales()
    listarProdsCot()
})

/*=============================================
MODIFICAR DESCUENTO
=============================================*/
$(".formularioCotizacion").on("change", "input.dctoItemCot", function(){
	var cant = $(this).parent().parent().parent().parent().children(".cantCot").children().children().children(".cantItemCot");
	var pUnit = $(this).parent().parent().parent().parent().children(".pCot").children().children().children(".pItemCot");
	var ut = $(this).parent().parent().parent().parent().children(".utCot").children().children().children(".utItemCot");
	var tot = $(this).parent().parent().parent().parent().children(".totCot").children().children().children(".totItemCot");

	var tipoProd = $(this).parent().parent().parent().parent().children(".tipoProd").attr('tipoProd');

	var dcto = $(this);
	var pComp = pUnit.attr('pComp');
	if(dcto.val()=="" || dcto.val()==0){
		dcto.parent().parent().children('#dcto').text('Dcto (%)');
		dcto.val(0);
		dcto.attr('style','height: 30px; font-size: 10pt');
		pUnit.val(pUnit.attr('pReal'));		
		pUnit.attr('style','height: 30px; font-size: 10pt');
	}else if(Number(dcto.val())>Number(dcto.attr('max'))){	
		dcto.attr('style','height: 30px; font-size: 10pt; background-color:rgb(169,249,98); color:black');		
		pUnit.val(Math.round(Number(pUnit.attr('pReal'))*(1-(dcto.attr('max')/100))));		
		pUnit.attr('style','height: 30px; font-size: 10pt; background-color:rgb(169,249,98); color:black');
		dcto.val(dcto.attr('max'));
		tot.val(cant.val()*pUnit.val());

		if(tipoProd != 'servicio'){ // suma utilidad si es producto, no servicio
			ut.val((pUnit.val()-pComp)*cant.val());
		}

	}else if(Number(dcto.val())<0){	
		dcto.attr('style','height: 30px; font-size: 10pt');
		pUnit.val(Math.round(Number(pUnit.attr('pReal'))));		
		pUnit.attr('style','height: 30px; font-size: 10pt');
		dcto.val(0);
		tot.val(cant.val()*pUnit.val());

		if(tipoProd != 'servicio'){ // suma utilidad si es producto, no servicio
			ut.val((pUnit.val()-pComp)*cant.val());
		}

	}else{	
		dcto.attr('style','height: 30px; font-size: 10pt; background-color:rgb(169,249,98); color:black');		
		pUnit.val(Math.round(Number(pUnit.attr('pReal'))*(1-(dcto.val()/100))));		
		pUnit.attr('style','height: 30px; font-size: 10pt; background-color:rgb(169,249,98); color:black');
		tot.val(cant.val()*pUnit.val());

		if(tipoProd != 'servicio'){ // suma utilidad si es producto, no servicio
			ut.val((pUnit.val()-pComp)*cant.val());
		}

	}
	sumTotales()
    listarProdsCot()
})


/*=============================================
CUANDO CARGUE LA TABLA CADA VEZ QUE NAVEGUE EN ELLA
=============================================*/
$(".tablaCotizadorProductos").on("draw.dt", function(){
	if(localStorage.getItem("quitarProductoCot") != null){
		var listaIdProductos = JSON.parse(localStorage.getItem("quitarProductoCot"));
		for(var i = 0; i < listaIdProductos.length; i++){
			$("button.recuperarBoton[idProducto='"+listaIdProductos[i]["idProducto"]+"']").removeClass('btn-default');
			$("button.recuperarBoton[idProducto='"+listaIdProductos[i]["idProducto"]+"']").addClass('btn-primary agregarProductoCot');
		}
	}
})


/*=============================================
QUITAR PRODUCTOS DE LA VENTA Y RECUPERAR BOTÓN
=============================================*/
var idQuitarProductoCot = [];
localStorage.removeItem("quitarProductoCot");
$(".formularioCotizacion").on("click", "button.quitarProductoCot", function(){
	var idProducto = $(this).attr("idProducto");
	$(this).parent().parent().parent().parent().remove();
	$('#esp'+idProducto).remove();
	/*=============================================
	ALMACENAR EN EL LOCALSTORAGE EL ID DEL PRODUCTO A QUITAR
	=============================================*/
	if(localStorage.getItem("quitarProductoCot") == null){
		idQuitarProductoCot = [];
	}else{
		idQuitarProductoCot.concat(localStorage.getItem("quitarProductoCot"))
	}
	idQuitarProductoCot.push({"idProducto":idProducto});
	localStorage.setItem("quitarProductoCot", JSON.stringify(idQuitarProductoCot));
	$("button.recuperarBoton[idProducto='"+idProducto+"']").removeClass('btn-default');
	$("button.recuperarBoton[idProducto='"+idProducto+"']").addClass('btn-primary agregarProductoCot');

	if($(".nuevoProductoCot").children().length == 0){
		$("#totCot").val(0);
		$("#nuevoTotalCot").attr("total",0);
		$('#utTotCotMostrar').text('   0 (0%)');
		// DESACTIVA BOTON INGRESAR VENTA SI NO HAY PRODUCTOS
		$('#nuevoMetodoPago').attr('disabled', 'disabled');
	}else{
    	sumTotales()  
        
        listarProdsCot()
	}

	var datos = new FormData();
	datos.append("idProducto", idProducto);
	$.ajax({
		url: "ajax/productos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(resp) {
			$(".varMayor[idProd='" + idProducto + "']").html("&uarr; "+resp["mayor_sobre"]+"u $ "+formatNumber.new(resp["precio_mayor"])+" c/u");
			$('#selectProdCotMovil').prepend('<option class="red-option" value="'+resp['id']+'">['+resp['sku']+'] '+resp["descripcion"]+'</option>'); // DEVUELVE AL SELECT DE VENTA MOVIL
		}
	})


    listarProdsCot()
})



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// /*=============================================
// AGREGANDO PRODUCTOS DESDE EL BOTÓN PARA DISPOSITIVOS ---> SOLO ADMINISTRADOR
// =============================================*/
$('#selectProdCotMovil').change(function(){
	var idProducto = $(this).val();
	if(idProducto == 0){
		$("#infoProdCotMovil").html('');
		$('#agregarProdCotMovil').attr('disabled','disabled');
	}else{
		$('#agregarProdCotMovil').removeAttr('disabled');		
	    var sucursal = $('#sucursalActiva').val();
		var tipo_cliente = $('#tipo_cliente').val();
		var datos = new FormData();
		datos.append("idProducto", idProducto);
		$.ajax({
			url: "ajax/productos.ajax.php",
			method: "POST",
			data: datos,
			cache: false,
			contentType: false,
			processData: false,
			dataType: "json",
			success: function(respuesta) {
				var descuento = respuesta["descuento"];
				var mayoreo = respuesta["mayor_sobre"];
				var precioMayor = respuesta["precio_mayor"];
				var precioCompra = respuesta["precio_compra"];
				var ubic = respuesta["zona_"+sucursal];

				var stockSucursal =  "stock_"+sucursal;
				var descripcion = respuesta["descripcion"];
				var codigoInterno = respuesta["sku"];
				var maneja_stock = respuesta["maneja_stock"];
				var stock = respuesta["stock_"+sucursal];
				var precio = respuesta['precio_venta'];
				

				var tipo_ajuste = 'ut_min_admin_cot';
				var datos = new FormData();
				datos.append("tipo_ajuste", tipo_ajuste);
				$.ajax({
					url:"ajax/ajustes.ajax.php",
					method: "POST",
					data: datos,
					cache: false,
					contentType: false,
					processData: false,
					dataType: "json",
					success: function(r1){

						var ut_min_cot = r1['ajuste'];
						var pMinProd = Number(precioCompra)*(1+Number(ut_min_cot)/100) > Number(precio) ? Number(precio) : Math.round(Number(precioCompra)*(1+Number(ut_min_cot)/100));
						if(Math.round(Number(precioCompra)*(1+Number(ut_min_cot)/100))>precio){
							sugerencia = '['+formatNumber.new(Math.round(Number(precio)), "$")+' - '+formatNumber.new(Math.round(Number(precio*1.2)), "$")+']<br><i style="color:red">Se recomienda subir Precio Venta</i>';
							disabled = '';
						}else{
							sugerencia = '['+formatNumber.new(Math.round(Number(pMinProd)), "$")+' - '+formatNumber.new(precio, "$")+']';
							disabled = '';
						}

						var	descripcionMostrar = 	'<b>Precio Venta: </b>('+formatNumber.new(precio, "$")+'c/u <b style="color:indigo"><i class="fa fa-arrow-up"></i> '+mayoreo+'u '+formatNumber.new(precioMayor, "$")+'c/u)</b><br>'+
													'<b>Sugerencia: </b>'+sugerencia;

						$('#agregarProdCotMovil').attr('idProd', idProducto);

						var imagen = '<br><img id="imagenZoom" src="'+respuesta['imagen']+'" alt="'+descripcion+'" class="imagenZoom" width="150px" idProducto="'+idProducto+'" data-toggle="modal" data-target="#modalZoomProducto">';
						$("#imagenZoomModal").attr("src", respuesta["imagen"]);
						$("#tituloModalZoom").text(descripcion);
						$('#agregarProdCotMovil').attr('idProd', idProducto);

						$("#infoProdCotMovil").html(
				          	'<div class="row">'+
				            	'<div class="col-8 descripcion">'+
		                  			'<font size="-1">'+descripcionMostrar+'</font>'+
				            	'</div>'+
				            	'<div class="col-4">'+
		                  			'<font size="-1">'+imagen+'</font>'+
				            	'</div>'+
					        '</div>'+
					        '<div id="esp'+idProducto+'" style="height:3px"></div>')
					}
				})

			}
		})	
	}
})

$('#agregarProdCotMovil').click(function(){
// aqui
	$('#modalCotMovil').modal('hide');
	var perfilVend = perfil == 'Administrador' ? 'admin' : 'vend';
	var idProducto = $(this).attr("idProd");
	$("#selectProdCotMovil").val(0).trigger('change'); // reset select
    var sucursal = $('#sucursalActiva').val();
	var datos = new FormData();
	datos.append("idProducto", idProducto);

	$.ajax({

		url: "ajax/productos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta) {
			descripcion = respuesta["descripcion"];
			codigoInterno = respuesta["sku"];
			maneja_stock = respuesta["maneja_stock"];
			stock = respuesta["stock_"+sucursal];
			mayoreo = respuesta["mayor_sobre"];
			precio = respuesta["precio_venta"];
			descuento = respuesta["descuento"];
			precioMayor = respuesta["precio_mayor"];
			precioCompra = respuesta["precio_compra"];
			ubic = respuesta["zona_"+sucursal];

			tipo_ajuste = 'ut_min_'+perfilVend+'_cot';

			var datos = new FormData();
			datos.append("tipo_ajuste", tipo_ajuste);
			$.ajax({
				url:"ajax/ajustes.ajax.php",
				method: "POST",
				data: datos,
				cache: false,
				contentType: false,
				processData: false,
				dataType: "json",
				success: function(r1){
					var ut_min_cot = r1['ajuste'];
					if(perfil == 'Administrador'){
						var pMinProd = Number(precioCompra)*(1+Number(ut_min_cot)/100) > Number(precio) ? Number(precio) : Math.round(Number(precioCompra)*(1+Number(ut_min_cot)/100));
						var max_dcto = Math.round((100-(pMinProd/precio*100))*100)/100;
						var maxDctoMostrar = max_dcto > descuento ? max_dcto : descuento;
						var descripMostrar = '<font size="-1"><i>Precio Compra <b>'+formatNumber.new((Math.round(precioCompra/1.19*100)/100), "$")+'/'+formatNumber.new(precioCompra, "$")+'</b></i>   Precio Mayor: <b>'+formatNumber.new(precioMayor,'$')+'</b>   Precio Normal: <b>'+formatNumber.new(precio,'$')+'</b>   Dcto Max: <b>'+maxDctoMostrar+'%</b></font>';
						if(Math.round(Number(precioCompra)*(1+Number(ut_min_cot)/100))>precio){
							sugerencia = '['+formatNumber.new(Math.round(Number(precio)), "$")+' - '+formatNumber.new(Math.round(Number(precio*1.2)), "$")+']<br><i style="color:red">Se recomienda subir Precio Venta</i>';
							disabled = '';
						}else{
							sugerencia = '['+formatNumber.new(Math.round(Number(pMinProd)), "$")+' - '+formatNumber.new(precio, "$")+']';
							disabled = '';
						}

						show = $('#btnMostrarUtilidad').hasClass('collapsed') ? '' : 'show'; // FILTRO PARA DETECTAR SI SE MUESTRA O NO UTILIDAD

			          	$(".nuevoProductoCot").prepend(

				          	'<div class="row" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-right: 1px;border-bottom: 1px;border-left:1px">'+
				            	'<div class="col-9" style="padding-left:0px">'+
				              		'<div>'+
				                		'<div>'+
				                  			'<button type="button" class="btn btn-danger btn-xs quitarProductoCot" idproducto="'+idProducto+'">'+
				                    			'<i class="fa fa-times"></i>'+
				                  			'</button>'+
				                  			'<font size="-1"> '+descripMostrar+'</font>'+
										  	'<input type="text" class="form-control descProdCot" style="height:25px; width:100%" idProducto="' + idProducto + '" codigoInterno="' + codigoInterno + '" name="agregarProducto" value="' + descripcion + '" required>'+
				                		'</div>'+
				              		'</div>'+
				            	'</div>'+
				            	'<div class="col-3 float-right" style="padding-left:0px">'+
									'<font size="-2">Sugerencia</font>'+
									'<font size="-1"><b>'+sugerencia+'</b>'+
				            	'</div>'+
				            	'<div style="height:25px"></div>'+
				              	// CANTIDAD


				              	'<div class="col-3 col-lg-2 cantCot" style="padding-left:0px">'+
				                	'<font size="-2">Cantidad</font>'+
				                	'<font class="d-lg-none" size="-2">Cant</font>'+
				                	'<div class="input-group">'+
					                	'<input type="number" class="form-control cantItemCot" style="height: 30px; font-size: 10pt" id="cantItemCot" min="1" value="1" stock="' + stock + '" mayoreo="' + mayoreo + '" nuevoStock="' + Number(stock - 1) + '" required>'+
				                	'</div>'+
				              	'</div>'+
				              	// PRECIO UNITARIO
				              	'<div class="col-6 col-lg-3 pCot" style="padding-left:0px">'+
				                	'<font size="-2">Precio Unit ('+formatNumber.new(precio, "$")+')</font>'+
				                	'<div class="input-group">'+
				                  		'<input type="number" style="height: 30px; font-size: 10pt" min="'+pMinProd+'" class="form-control pItemCot" id="pItemCot" pComp="' + precioCompra + '" pReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="' + precio + '" required '+disabled+'>'+
				                	'</div>'+
				              	'</div>'+
				              	// DCTO
				              	'<div class="col-3 col-lg-2 dctoCot" style="padding-left:0px">'+
				                	'<font size="-2" id="dcto">Dcto (%)</font>'+
				                	'<div class="input-group">'+
					                  	'<input type="number" style="height: 30px; font-size: 10pt" min="0" max="'+max_dcto+'" class="form-control dctoItemCot" id="dctoItemCot" precioReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="0" required '+disabled+'>'+
				                	'</div>'+
				              	'</div>'+
				              	// TOTAL
				              	'<div class="col-6 col-lg-3 totCot" style="padding-left:0px">'+
				                	'<font size="-2">Total ($)</font>'+
				                	'<div class="input-group">'+
					                  	'<input type="text" style="height: 30px; font-size: 10pt; background-color:rgb(98,249,210)" class="form-control totItemCot" id="totItemCot" precioReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="' + precio + '" required disabled>'+
				                	'</div>'+
				              	'</div>'+
				              	// UTILIDAD
				              	'<div class="col-6 col-lg-2 utCot collapse '+show+'" id="collapseContent" style="padding-left:0px">'+
				                	'<font size="-2">Utilidad</font>'+
				                	'<div class="input-group">'+
					                  	'<input type="text" style="height: 30px; font-size: 10pt; background-color:rgb(169,249,98)" class="form-control utItemCot" id="utItemCot" precioReal="' + precio + '" precioFinal="' + precio + '" precioMayor="' + precioMayor + '" value="' + (precio-precioCompra) + '" required disabled>'+
				                	'</div>'+
				              	'</div>'+
					        '</div>'+
					        '<div id="esp'+idProducto+'" style="height:3px"></div>')
					}
				}
			})
		}

	})
	localStorage.removeItem("quitarProductoCot");
	setTimeout(function(){
    	listarProdsCot();
	    sumTotales();
    	$('#cantItemCot').select();
	}, 300);
	
})



$('#modalCotMovil').on('shown.bs.modal', function (e) {
	var prodsIngresados = [];
	$('.descProdCot').each(function (i){
		idIngresados = $(this).attr('idProducto');
		prodsIngresados.push(idIngresados);
    });
	// ELIMINA LA OPCIÓN QUE YA SE INGRESÓ A LA VENTA
    for (var i = 0; i <	prodsIngresados.length; i++) {
	    $('#selectProdCotMovil option[value="'+prodsIngresados[i]+'"]').remove();
	}

})



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*=============================================
SELECCIONAR PRODUCTO DESDE CELULAR
=============================================*/
$(".formularioCotizacion").on("change", "select.nuevaDescripcionProductoCot", function(){
    var sucursal = $('#sucursalActiva').val();
	var nombreProducto = $(this).val();
	var nuevaDescripcionProductoCot = $(this).parent().parent().parent().children().children().children(".nuevaDescripcionProductoCot");
	var nuevoPrecioProductoCot = $(this).parent().parent().parent().children(".ingresoPrecioCot").children().children(".nuevoPrecioProductoCot");
	var nuevaCantidadProductoCot = $(this).parent().parent().parent().children(".ingresoCantidadCot").children(".nuevaCantidadProductoCot");
	var datos = new FormData();
   	datos.append("nombreProducto", nombreProducto);
    $.ajax({
     	url:"ajax/productos.ajax.php",
      	method: "POST",
      	data: datos,
      	cache: false,
      	contentType: false,
      	processData: false,
      	dataType:"json",
      	success:function(respuesta){  	    
      	    $(nuevaDescripcionProductoCot).attr("idProducto", respuesta["id"]);
      	    $(nuevaCantidadProductoCot).attr("stock_"+sucursal, respuesta["stock_"+sucursal]);
      	    $(nuevaCantidadProductoCot).attr("nuevoStock", Number(respuesta["stock_"+sucursal])-1);
      	    $(nuevoPrecioProductoCot).val(respuesta["precio_venta"]);
      	    $(nuevoPrecioProductoCot).attr("precioReal", respuesta["precio_venta"]);
	        listarProdsCot()
      	}
    })
})

/*=============================================
LISTAR TODOS LOS PRODUCTOS
=============================================*/
function listarProdsCot(){
	var listaProductosCot = [];
	var arrayTotalesCot = [];
	var descripcion = $(".descProdCot");
	var cantidad = $(".cantItemCot");
	var precio = $(".pItemCot");
	var descuento = $(".dctoItemCot");
	
	for(var i = 0; i < descripcion.length; i++){
		if($(descuento[i]).val()>100){
			$dcto = 0;
		}else{
			$dcto = $(descuento[i]).val();
		}
		listaProductosCot.push({"id" : $(descripcion[i]).attr("idProducto"), 
							  	"sku" : $(descripcion[i]).attr("codigointerno"),
							  	"prod" : $(descripcion[i]).val(),
							  	"cant" : $(cantidad[i]).val(),
							  	"pC": $(precio[i]).attr("pComp"),
							 	"pV" : Number($(precio[i]).val()),
							  	"tot" : $(precio[i]).val()*$(cantidad[i]).val(),
							  	"dcto" : $dcto});
		// ARRAY TOTAL COTIZACION Y UTILIDAD
		arrayTotalesCot.push({ "total" :$(precio[i]).val(), "preciocompra": $(precio[i]).attr("precioCompra")});
	}

	$("#listaProductosCot").val(JSON.stringify(listaProductosCot)); // LISTAR PRODUCTOS
	
	// CALCULO TOTAL Y UTILIDAD
	sumaCosto=0;
	$.each(arrayTotalesCot, function(i,item){
	    sumaCosto = Number(sumaCosto) + Number(item.preciocompra);
	});
	sumaTotal=0;
	$.each(arrayTotalesCot, function(i,item){
	    sumaTotal = Number(sumaTotal) + Number(item.total);
	});
	$('#utilidadCotizacion').val(sumaTotal-sumaCosto);

}

/*=============================================
ANTES DE ENVIAR FORMULARIO
=============================================*/
function enviarCot() {
	var listaProductosCot = $("#listaProductosCot").val();
	var clienteCot = $(".seleccionarClienteCot").val();

	if (listaProductosCot == "[]") {
		Swal.fire({
			icon: "error",
			title: "La Cotización no se ejecuta si no hay productos",
			confirmButtonText: "Cerrar"
		});
		return;
	}

	if (clienteCot == "") {
		Swal.fire({
			icon: "error",
			title: "Seleccione Cliente",
			confirmButtonText: "Cerrar"
		});
		return;
	}

	if (clienteCot == 0 && ($('.newClientCot').val() == '' || $('#contactClientCot').val() == '')) {
		Swal.fire({
			icon: "error",
			title: "Debe ingresar datos del Cliente",
			confirmButtonText: "Cerrar"
		});
		return;
	}

	// Validación de cantidades numéricas
	let valido = true;

	$('.cantItemCot').each(function () {
		const valor = $(this).val();
		if (valor === '' || isNaN(valor)) {
			valido = false;
			$(this).addClass('input-error');
		} else {
			$(this).removeClass('input-error');
		}
	});

	if (!valido) {
		audioError('Por favor, ingresa solo valores numéricos en todos los campos de cantidad.');
		return;
	}

	// Si todo está correcto
	listarMetodos();
	document.forms[0].submit();
}

// function enviarCot(){
// 	var listaProductosCot = $("#listaProductosCot").val();
// 	var clienteCot = $(".seleccionarClienteCot").val();
// 	if (listaProductosCot=="[]"){
// 		Swal.fire({
// 				icon: "error",
// 				title: "La Cotización no se ha ejecuta si no hay productos",
// 				confirmButtonText: "Cerrar"
// 		    });
// 	}else if(clienteCot==""){
// 		Swal.fire({
// 				icon: "error",
// 				title: "Seleccione Cliente",
// 				confirmButtonText: "Cerrar"
// 		    });
// 	}else if($(".seleccionarClienteCot").val()==0 && ($('.newClientCot').val() == '' || $('#contactClientCot').val() == '')){
// 		Swal.fire({
// 				icon: "error",
// 				title: "Debe ingresar datos del Cliente",
// 				confirmButtonText: "Cerrar"
// 		    });				
// 	}else{


// 	    let valido = true;

// 	    $('.cantItemCot').each(function() {
// 	        const valor = $(this).val();
// 	        if (valor === '' || isNaN(valor)) {
// 	            valido = false;
// 	            $(this).addClass('input-error'); // opcional: para marcar el error visualmente
// 	        } else {
// 	            $(this).removeClass('input-error');
// 	        }
// 	    });

// 	    if (!valido) {
// 	        e.preventDefault();
// 	        alert('Por favor, ingresa solo valores numéricos en todos los campos de cantidad.');
// 	    }


// 		listarMetodos();
// 		document.forms[0].submit();
// 	}
// }

/*=============================================
IMPRIMIR COTIZACION
=============================================*/
$(".tablaCotizaciones,.tablaCotizacionesMovil").on("click", ".btnImprimirCotizacion", function(){
	var codigoCotizacion = $(this).attr("codigoCotizacion");
	window.open("extensiones/tcpdf/pdf/cotizacion.php?codigo="+codigoCotizacion+"&motivo=ver", "_blank");
})

$(".tablaCotizaciones").on("click", ".btnDownloadCot", function(){
	var codigoCotizacion = $(this).attr("codigoCotizacion");
	window.open("extensiones/tcpdf/pdf/cotizacion.php?codigo="+codigoCotizacion+"&motivo=descarga", "_blank");
})

$(".tablaCotizaciones").on("click", ".btnCotEmpresa", function(){
	var codigoCotizacion = $(this).attr("codigoCotizacion");
	window.open("extensiones/tcpdf/pdf/cot-empresa.php?codigo="+codigoCotizacion, "_blank");
})

$(".tablaCotizaciones").on("click", ".btnImprCotAll", function(){
	var codigoCotizacion = $(this).attr("codigoCotizacion");
	window.open("extensiones/tcpdf/pdf/cotizacion-all.php?codigo="+codigoCotizacion, "_blank");
})

/*=============================================
COTIZACION A VENTA
=============================================*/
$(".tablaCotizaciones,.tablaCotizacionesMovil").on("click", ".btnVentaCot", function(){
	var codigoCotizacion = $(this).attr("codigoCotizacion");
	window.open("index.php?ruta=venta-cot&idCot=" + codigoCotizacion, "_blank");
})

/*=============================================
ACTUALIZAR COT
=============================================*/
$(".tablaCotizaciones,.tablaCotizacionesMovil").on("click", ".btnActualizarCot", function(){
	var codigoCotizacion = $(this).attr("codigoCotizacion");
	window.open("index.php?ruta=actualizar-cot&idCot=" + codigoCotizacion, "_blank");
})

/*=============================================
ACTUALIZAR EXPIRACION COTIZACION
=============================================*/
$(".tablaCotizaciones,.tablaCotizacionesMovil").on("click", ".btnActualizarExpiracion", function(){
	var idCot = $(this).attr("codigoCotizacion");
	$(this).remove();
	$('#expirado'+idCot).remove();
	$("button.btnVentaCot[codigoCotizacion='" + idCot + "']").removeAttr('disabled');
	var datos = new FormData();
	datos.append("actualizarFechaExpiracionCot", idCot);
	$.ajax({
	  	url:"ajax/cotizaciones.ajax.php",
	  	method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		success:function(r){
            var audio = new Audio('componentes/sonidos/success.mp3');
            audio.play();
            Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'success',title: 'Vigencia Cotización hasta mañana'});
	  	}
  	})

})

/*=============================================
CLIENTE NUEVO COTIZACION
=============================================*/
$(".seleccionarClienteCot").on("change", function(){
		// $("#nomClientCot").val($(".seleccionarClienteCot option:selected").text());        
	if($(".seleccionarClienteCot option:selected").val()==0){
        $(".clientNewCot").html(
			'<div class="col-6">'+
                '<label>Nombre y Apellido</label>'+
                '<div class="input-group">'+
                  	'<div class="input-group-prepend">'+
                    	'<span class="input-group-text" style="background-color:white"><i class="fas fa-user"></i></span>'+
                  	'</div>'+
                  	'<input type="text" class="form-control input-lg newClientCot" maxlength="20" id="newClientCot" name="newClientCot" placeholder="Ingrese nombre" required>'+
                '</div>'+
            '</div>'+
            '<div class="col-6">'+
                '<label>Nro. de Contacto</label>'+
                '<div class="input-group">'+
                  	'<div class="input-group-prepend">'+
                    	'<span class="input-group-text" style="background-color:white"><i class="fas fa-mobile-alt"></i></span>'+
                  	'</div>'+
                  	'<input type="text" class="form-control input-lg" id="contactClientCot" name="contactClientCot" maxlength="9" onkeypress="return soloNumeros(event)" placeholder="912345678" required>'+
                '</div>'+
            '</div>');
		$(".nomClientCot").val('');	
	}else{
		$(".clientNewCot").html('');		
		$(".nomClientCot").val($(".seleccionarClienteCot option:selected").text());        
	}
})
