$('.tablaCompras').on('click', '.ingresarAbastGuardado', function(){
  var idCompra = $(this).attr('idCompra');

  Swal.fire({
  icon:'question',
  title: "<h5>Registrar Compra Guardada?</h5>",
  showDenyButton: true,
  confirmButtonText: 'Si',
  denyButtonText: 'Cancelar',
  customClass: {
    actions: 'my-actions',
    cancelButton: 'order-1 right-gap boton-cancelar',
    confirmButton: 'order-2 btn boton-confirmar',
    denyButton: 'order-3 btn boton-denegar',
  }
  })
  .then((result) => {
    if (result.isConfirmed) {
      var datos = new FormData();
      datos.append("ingresarAbastGuardado", idCompra);

      Swal.fire({
        title: 'Registrando Compra...',
        text: 'Espere un momento',
        allowOutsideClick: false,
        allowEscapeKey: false,
        allowEnterKey: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });


      $.ajax({
          url: "ajax/compras.ajax.php",
          method: "POST",
          data: datos,
          cache: false,
          contentType: false,
          processData: false,
          success: function (respuesta) {
            if(respuesta == 'ok'){
              $('.tablaCompras').DataTable().ajax.reload();
              Swal.close();
              audioSuccess("Compra Registrada correctamente");
            }
          },
          error: function () {
            Swal.fire({
                icon: 'error',
                title: 'Error al cargar sucursales',
                confirmButtonText: 'Cerrar'
            });
          }
      });
    }
  })
})

/*=============================================
RANGO DE FECHAS
=============================================*/
if(localStorage.getItem("capturarRango5") != null){
    $("#daterange-btn5 span").html(localStorage.getItem("capturarRango5"));
}else{
    $("#daterange-btn5 span").html('<i class="fa fa-calendar"></i> Rango de fecha')
}

$('#daterange-btn5').daterangepicker(
    {
        ranges: {
            'Home'       : [moment().subtract(1, 'month'), moment()],
            'Este mes'  : [moment().startOf('month'), moment().endOf('month')],
            'Mes Anterior'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Este año'  : [moment().startOf('year'), moment().endOf('year')],
            'Año Anterior'  : [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        },
        startDate: moment(),
        endDate  : moment()
    },
    function (start, end){
        var fechaInicial = start.format('YYYY-MM-DD');
        var fechaFinal = end.format('YYYY-MM-DD');
        var hoy = moment(new Date()).format('YYYY-MM-DD');
        var fecha1 = fechaInicial;
        var fecha2 = fechaFinal;
        $('#daterange-btn5 span').html(moment(fecha1).format('DD-MM-YY') + ' - ' + moment(fecha2).format('DD-MM-YY'));
        var capturarRango = $("#daterange-btn5 span").html();
        localStorage.setItem("capturarRango5", capturarRango);
        window.location = "index.php?ruta=compras&fechaInicial="+fecha1+"&fechaFinal="+fecha2;
    }
)

/*=============================================
CARGAR TABLA COMPRAS
=============================================*/
var tblCompras = $('.tablaCompras').DataTable({
  "ajax": "ajax/datatable-compras.ajax.php?fechaInicial="+obtenerGET(window.location)['fechaInicial']+"&fechaFinal="+obtenerGET(window.location)['fechaFinal'],
  "order": [[ 0, "desc" ]], //orden descendente por defecto
  "deferRender": true,
  "retrieve": true,
  "mark": true,
  "processing": true,
  "pageLength": 10,
  "language": {

    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  }
});

/*=============================================
CARGAR TABLA COMPRAS MOVIL
=============================================*/
$('.tablaComprasMovil').DataTable({
  "ajax": "ajax/datatable-compras-movil.ajax.php",
  "order": [[ 0, "desc" ]], //orden descendente por defecto
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "mark": true,
  "pageLength": 10,
  "language": {
    "sProcessing": "Procesando...",
    "sLengthMenu": "Mostrar _MENU_ registros",
    "sZeroRecords": "No se encontraron resultados",
    "sEmptyTable": "Ningún dato disponible en esta tabla",
    "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix": "",
    "sSearch": "Buscar",
    "sUrl": "",
    "sInfoThousands": ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
      "sFirst": "Primero",
      "sLast": "Último",
      "sNext": "&rarr;",
      "sPrevious": "&larr;"
    },
    "oAria": {
      "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  },
  dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',
});

/*=============================================
CARGAR TABLA PRODUCTOS COMPRAR
=============================================*/
$('.tablaAbastecimiento').DataTable({
  "ajax": "ajax/datatable-abastecimiento.ajax.php?suc="+obtenerGET(window.location)['suc']+"&prov="+obtenerGET(window.location)['prov'],
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 25,
  "language":{
    "sProcessing":     "Procesando...",
    "sLengthMenu":     "Mostrar _MENU_ registros",
    "sZeroRecords":    "No se encontraron resultados",
    "sEmptyTable":     "Ningún dato disponible en esta tabla",
    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix":    "",
    "sSearch":         "Buscar (F3):",
    "sUrl":            "",
    "sInfoThousands":  ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
    "sFirst":    "Primero",
    "sLast":     "Último",
    "sNext":     "Siguiente",
    "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  },
  dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"<"dt-buttons float-right btn-group flex-wrap"B>><"col-sm-12 col-md-4"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
  buttons:
  [
    { // boton personalizado // RECARGA NUEVAMENTE EL DATATABLE
      text: '                                                      <button class="btn btn-info btn-sm"><i class="fas fa-undo"></i></button>',
      action: function ( e, dt, node, config ) {
        dt.clear().draw();
        dt.ajax.reload();
      }
    }       
  ]
});


/*=============================================
MOVER COMPRA A OTRA SUCURSAL
=============================================*/
$('.tablaCompras').on('click', '.moverDeSucursal', function(){
  var idCompra = $(this).attr('idCompra');
  var sucursalAbastActual = $(this).attr('sucursalAbast');
  var datos = new FormData();
  datos.append("llamarSucursales", "todas");
  $.ajax({
      url: "ajax/sucursales.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function (sucursales) {
          let opciones = {};
          $(sucursales).each(function (i) {
              if (sucursales[i].nombre_sucursal !== sucursalAbastActual) {
                  opciones[sucursales[i].nombre_sucursal] = sucursales[i].alias_sucursal.toUpperCase();
              }
          });

          Swal.fire({
              title: 'Selecciona la nueva sucursal',
              input: 'select',
              inputOptions: opciones,
              inputPlaceholder: 'Elige una sucursal',
              showCancelButton: true,
              confirmButtonText: 'Mover',
              cancelButtonText: 'Cancelar',
              inputValidator: (value) => {
                  if (!value) {
                      return 'Debes seleccionar una sucursal';
                  }
              }
          }).then((result) => {
              if (result.isConfirmed) {
                  const nuevaSucursal = result.value;
                  window.open("index.php?ruta=abastecimiento-interno&bodega="+sucursalAbastActual+"&suc="+nuevaSucursal+"&idCompra="+idCompra, "_blank");
              }
          });
      },
      error: function () {
          Swal.fire({
              icon: 'error',
              title: 'Error al cargar sucursales',
              confirmButtonText: 'Cerrar'
          });
      }
  });
 
})

/*=============================================
IMPRIMIR CODIGOS BARRA
=============================================*/
$('.tablaCompras').on('click', '.imprimirCodigosBarra', function(){
  var idCompra = $(this).attr('idCompra');
  var datos = new FormData();
  datos.append('datosCompra', idCompra);

  $.ajax({
    url:'ajax/compras.ajax.php',
    method: 'POST',
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success:function(respuesta){
      r = JSON.parse(respuesta);
      productosComprados = JSON.parse(r.abastecimiento);
      $('#contenidoImprimirCodigos').html('');
      $(productosComprados).each(function (i){
        textoCant = i == 0 ? 'Cant Etiquetas' : '';
        textoProd = i == 0 ? 'Producto' : '';

        $('#contenidoImprimirCodigos').append(
              '<div class="col-3 ingCantAbast" style="padding-left:0px">'+
                '<font size="-1"><b>'+textoCant+'</b></font>'+
                '<div class="input-group">'+
                  '<input type="number" class="form-control form-control-sm cantCodsBarra" id="cantCodsBarra" idProd="'+productosComprados[i].id+'" value="'+productosComprados[i].cant+'">'+
                '</div>'+
              '</div>'+
              '<div class="col-9 ingPCompAbastNeto" style="padding-left:0px">'+
                '<font size="-1"><b>'+textoProd+'</b></font>'+
                '<div class="input-group">'+productosComprados[i].cant+' '+productosComprados[i].nom+
                '</div>'+
              '</div>'
          )
      });
    }
  })  
})


$('#modalImprimirCodigos').on('shown.bs.modal', function (e) {
  setTimeout(function(){
    $('#cantCodsBarra').select();
  }, 200);
})

/*=============================================
ABASTERCIMIENTO EXTERNO PARA DISPOSITIVOS ---> SOLO ADMINISTRADOR
=============================================*/
$('#selectProdAbastExternoMovil').change(function(){ //OK
  var get = obtenerGET(window.location);
  // var prov = get['prov']; // proveedor
  var local = get['suc']; // local abastecido

  var idProducto = $(this).val();
  if(idProducto == 0){
    $("#infoProdAbastExternoMovil").html('');
    $('#agregarProdAbastExternoMovil').attr('disabled','disabled');
  }else{

    $('#agregarProdAbastExternoMovil').removeAttr('disabled');   
    var datos = new FormData();
    datos.append("idProducto", idProducto);
    $.ajax({
      url: "ajax/productos.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        $('#agregarProdAbastExternoMovil').attr('idProd', idProducto);
        var imagen = '<br><img style="float:left" id="imagenZoom" src="'+respuesta['imagen']+'" alt="'+respuesta["descripcion"]+'" class="imagenZoom" width="150px" idProducto="'+idProducto+'" data-toggle="modal" data-target="#modalZoomProducto">';
        $("#imagenZoomModal").attr("src", respuesta["imagen"]);
        $("#tituloModalZoom").text(respuesta["descripcion"]);
        $("#infoProdAbastExternoMovil").html(
            '<div class="row">'+
              '<div class="col-12">'+
                '<font>'+respuesta["descripcion"]+'</font>'+
                  imagen+
              '</div>'+
            '</div>'+
            '<div id="esp'+idProducto+'" style="height:3px"></div>')
      }
    })  
  }
})


$('#agregarProdAbastExternoMovil').click(function(){
  $('#modalAbastecimientoExternoMovil').modal('hide'); // ocultar modal
  $("#selectProdAbastExternoMovil").val(0).trigger('change'); // reset select
  var get = obtenerGET(window.location);
  var sucursal = get['suc']; // local abastecido
  var idProducto = $(this).attr("idProd");
  $(this).removeClass("abastecerProd");
  $("button[idProd='" + idProducto + "']").attr("disabled",'disabled');
  $("button[idProd='" + idProducto + "']").addClass('recuperarBoton');
  var datos = new FormData();
  datos.append("idProducto", idProducto);
  $.ajax({
    url: "ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(r1) {
      var descripcion = r1["descripcion"];
      var dcto = r1["descuento"];
      var sku = r1["sku"];
      var codigoInterno = r1["sku"];
      var codProv = r1["cod_proveedor"];
      var prov = r1["proveedor"];
      var stock = r1["stock_"+sucursal];
      var pCTotal = r1['precio_compra'];
      var pCNeto = r1["pc_neto"];
      var pV = r1["precio_venta"];
      var pVM = r1["precio_mayor"];
      var mayor = r1["mayor_sobre"];
      var ubic = r1["zona_"+sucursal];
      var cantSurtir = r1["cant_transf"];
      var transformable = r1["transformable"];
      var idSurtible = r1["id_transf"];

      var datos2 = new FormData();
      datos2.append("idProducto", idSurtible);
      $.ajax({
        url: "ajax/productos.ajax.php",
        method: "POST",
        data: datos2,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(r2) {

          if(transformable == 1){
            var precioVentaUnitarioSurtible = r2['precio_venta'];
            var precioVentaMayorSurtible = r2['precio_mayor'];
            var pCNetoSurtible = Math.round(Number(pCNeto)/Number(cantSurtir)*100)/100;
            var pCIvaSurtible = Math.round(Number(pCTotal)/Number(cantSurtir));
            var vistaInput = '';
          }else{
            var precioVentaUnitarioSurtible = 0;
            var precioVentaMayorSurtible = 0;
            var pCNetoSurtible = 0;
            var pCIvaSurtible = 0;
            var vistaInput = 'd-none';
          }

          productoSurtible = 
            '<font class="'+vistaInput+'" size="-1" style="color:blue">PRODUCTO SURTIBLE: <b>VALORES UNITARIOS</b></font>'+
            '<div class="row '+vistaInput+'" id="borde" style="padding:5px 20px; border: 2px solid blue">'+

              '<div class="col-6 ingPCompraNetoSurtible" style="padding-left:0px">'+
                '<font size="-2">P. Compra Neto Unit</font>'+
                '<div class="input-group">'+
                  '<input type="number" class="form-control form-control-sm pCompraNetoSurtible" id="pCompraNetoSurtible" value="'+pCNetoSurtible+'" disabled>'+
                '</div>'+
              '</div>'+
              '<div class="col-6 ingPCompraTotalSurtible" style="padding-left:0px">'+
                '<font size="-2">P. Compra Total Unit</font>'+
                '<div class="input-group">'+
                  '<input type="number" class="form-control form-control-sm pCompraCIvaSurtible" id="pCompraCIvaSurtible" value="'+pCIvaSurtible+'" disabled>'+
                '</div>'+
              '</div>'+
              '<div class="col-6" style="padding-left:0px">'+
                '<font size="-2">P. Venta Total Unit</font>'+
                '<div class="input-group">'+
                  '<input type="number" class="form-control form-control-sm pVentaUnitSurtible" value="'+precioVentaUnitarioSurtible+'" required>'+
                '</div>'+
              '</div>'+
              '<div class="col-6" style="padding-left:0px">'+
                '<font size="-2">P. Venta Mayor</font>'+
                '<div class="input-group">'+
                  '<input type="text" class="form-control form-control-sm pVentaMayorSurtible" value="'+precioVentaMayorSurtible+'">'+
                '</div>'+
              '</div>'+
            '</div>';     

          $(".prodAbast").append(
            '<div class="row" id="borde" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-color:red;">'+
              '<div class="col-12 descripcion" style="padding-left:0px">'+
                '<div>'+
                  '<div>'+
                    '<button type="button" class="btn btn-danger btn-xs quitarProdAbast" idProducto="' + idProducto + '">'+
                    '<i class="fa fa-times"></i>'+
                    '</button> <font size="-1"><b>'+ubic+'-'+codigoInterno+'</b> '+descripcion+' <b>(Neto: '+formatNumber.new(pCNeto, "$")+' - $ Total: '+formatNumber.new(pCTotal, "$")+')</b></font>'+
                  '</div>'+
                '</div>'+
              '</div>'+
              '<div style="height:25px"></div>'+
              '<div class="col-3 ingCantAbast" style="padding-left:0px">'+
                '<input type="hidden" class="nomProdAbast" value="'+descripcion+'">'+
                '<font size="-2">Cant</font>'+
                '<div class="input-group">'+
                  '<input type="number" class="form-control form-control-sm cantAbast" sku="'+sku+'" idProd="'+idProducto+'" stk="'+stock+ '" value="0" id="cantAbast" required>'+
                '</div>'+
              '</div>'+
              '<div class="col-5 ingPCompAbastNeto" style="padding-left:0px">'+
                '<font size="-2">P. Compra Neto</font>'+
                '<div class="input-group">'+
                  '<input type="number" class="form-control form-control-sm pCompAbastNeto" cant_transf="'+cantSurtir+'" transformable="'+transformable+'" step="0.01" prov="'+prov+'" pV="'+pV+'" pVM="'+pVM+'" mayor="'+mayor+'" pCNeto="' +pCNeto+ '" id="pCompAbastNeto" value="'+pCNeto+'" required>'+
                '</div>'+
              '</div>'+
              '<div class="col-4 ingPCompAbastTotal" style="padding-left:0px">'+
                '<font size="-2">P. Compra Total</font>'+
                '<div class="input-group">'+
                  '<input type="number" class="form-control form-control-sm pCompAbastTotal" cant_transf="'+cantSurtir+'" transformable="'+transformable+'" prov="'+prov+'" pV="'+pV+'" pVM="'+pVM+'" mayor="'+mayor+'" pCTotal="' + pCTotal + '" id="pCompAbastTotal" value="'+pCTotal+'" required>'+
                '</div>'+
              '</div>'+
              '<div class="col-4 codProvDiv" style="padding-left:0px">'+
                '<font size="-2">Cod. Prov,</font>'+
                '<div class="input-group">'+
                  '<input type="text" class="form-control form-control-sm codProv" prov="'+prov+'" id="codProv" value="'+codProv+'" disabled required>'+
                '</div>'+
              '</div>'+
              '<div class="col-4 pVUnitAbast" style="padding-left:0px">'+
                '<font size="-2">P. Venta Unit</font>'+
                '<div class="input-group">'+
                  '<input type="number" class="form-control form-control-sm pVAbast" dcto="'+dcto+'" min="'+pV+'" pV="'+pV+'" id="pVAbast" value="'+pV+'" disabled required>'+
                '</div>'+
              '</div>'+
              '<div class="col-4 mb-1 pVMayorAbast" style="padding-left:0px">'+
                '<font size="-2">P. Venta Mayor</font>'+
                '<div class="input-group">'+
                  '<input type="number" class="form-control form-control-sm pVMAbast" pVM="' + pVM + '" id="pVMAbast" value="'+pVM+'" disabled required>'+
                '</div>'+
              '</div>'+
              productoSurtible+
            '</div>'+
            '<div id="esp'+idProducto+'" style="height:3px"></div>')
          listarAbastecimiento();
        }
      })
    }
  })
})

$('#modalAbastecimientoExternoMovil').on('shown.bs.modal', function (e) {
  var prodsIngresados = [];
  $('.cantAbast').each(function (i){
    idIngresados = $(this).attr('idProd');
    prodsIngresados.push(idIngresados);
  });
  // ELIMINA LA OPCIÓN QUE YA SE INGRESÓ A LA VENTA
  for (var i = 0; i < prodsIngresados.length; i++) {
    $('#selectProdAbastExternoMovil option[value="'+prodsIngresados[i]+'"]').remove();
  }
  $("#infoProdAbastExternoMovil").html('');
})

/*=============================================
VER COMPRA PDF
=============================================*/
$(".tablaCompras,.tablaComprasMovil").on("click", ".btnVerPDFCompra", function(){
  var id = $(this).attr("idCompra");
  window.open("extensiones/tcpdf/pdf/compra.php?codigo=" + id+"&motivo=ver", "_blank");
})

/*=============================================
DESCARGAR COMPRA PDF
=============================================*/
$(".tablaCompras").on("click", ".btnDescargarCompra", function(){
  var id = $(this).attr("idCompra");
  window.open("extensiones/tcpdf/pdf/compra.php?codigo=" + id+"&motivo=descarga", "_blank");
})


/*=============================================
CONFIGURACION COMPRA
=============================================*/
// COMPUTADOR
$('#documentoAbast').on('change',function(){
  seleccion = $("#documentoAbast option:selected").val();
  if(seleccion == 'factura'){
    $('#documentoAbastInputs').html(
      '<div class="user-block mb-3">'+
        '<img class="img-circle img-bordered-xs info" data-original-title="Nro Factura" src="componentes/img/sama/codigo.png" alt="codigo">'+
        '<span class="username">'+                        
          '<input type="text" class="form-control" id="nroFactura" name="nroFactura" maxlength="9" placeholder="Nro Factura">'+
        '</span>'+
      '</div>')
    $('#documentoAbastInputs2').html('')
  }else if(seleccion == 'guia'){
    $('#documentoAbastInputs').html(
      '<div class="user-block mb-3">'+
        '<img class="img-circle img-bordered-xs info" data-original-title="Nro Guía" src="componentes/img/sama/codigo.png" alt="codigo">'+
        '<span class="username">'+                        
          '<input type="text" class="form-control" id="nroGuia" name="nroGuia" maxlength="9" placeholder="Nro Guía">'+
        '</span>'+
      '</div>')
    $('#documentoAbastInputs2').html(
      '<div class="user-block mb-3">'+
        '<img class="img-circle img-bordered-xs info" data-original-title="Nro Factura Guía" src="componentes/img/sama/codigo.png" alt="codigo">'+
        '<span class="username">'+                        
          '<input type="text" class="form-control" id="nroFacturaGuia" name="nroFacturaGuia" maxlength="9" placeholder="Nro Factura">'+
        '</span>'+
      '</div>')
  }else if(seleccion == 'otro'){
    $('#documentoAbastInputs').html(
      '<div class="user-block mb-3">'+
        '<img class="img-circle img-bordered-xs info" data-original-title="Nro Documento" src="componentes/img/sama/codigo.png" alt="codigo">'+
        '<span class="username">'+                        
          '<input type="text" class="form-control" id="nroOtro" name="nroOtro" maxlength="9" placeholder="Nro Documento">'+
        '</span>'+
      '</div>')
    $('#documentoAbastInputs2').html('')
  }else{
    $('#documentoAbastInputs').html(
      '<div class="user-block mb-3">'+
        '<img class="img-circle img-bordered-xs info" data-original-title="Nro Factura" src="componentes/img/sama/codigo.png" alt="codigo">'+
        '<span class="username">'+                        
          '<input type="text" class="form-control" id="nroFactura" name="nroFactura" maxlength="9" placeholder="Nro Factura" disabled>'+
        '</span>'+
      '</div>')
    $('#documentoAbastInputs2').html('')    
  }
})

// DISPOSITIVOS MOVILES
$('#documentoAbastMovil').on('change',function(){
  seleccion = $("#documentoAbastMovil option:selected").val();
  if(seleccion == 'factura'){
    $('#docCompra1').html('<input type="text" class="form-control form-control-sm" id="nroFacturaMovil" name="nroFacturaMovil" maxlength="9" placeholder="Nro Factura">')
    $('#docCompra2').html('')
  }else if(seleccion == 'guia'){
    $('#docCompra1').html('<input type="text" class="form-control form-control-sm" id="nroGuiaMovil" name="nroGuiaMovil" maxlength="9" placeholder="Nro Guía">')
    $('#docCompra2').html('<input type="text" class="form-control form-control-sm" id="nroFacturaGuiaMovil" name="nroFacturaGuiaMovil" maxlength="9" placeholder="Nro Factura">')
  }else if(seleccion == 'otro'){
    $('#docCompra1').html('<input type="text" class="form-control form-control-sm" id="nroOtroMovil" name="nroOtroMovil" maxlength="9" placeholder="Nro Doc.">')
    $('#docCompra2').html('')
  }else{
    $('#docCompra1').html('')
    $('#docCompra2').html('')
  }
})


/*=============================================
AGREGANDO PRODUCTOS PARA ABASTECER
=============================================*/
$(".tablaAbastecimiento tbody").on("click", ".abastecerProd", function(){
  var getVentana = window.location.search.split('&');
  var sucursal = getVentana[1].substring(4);
  var proveedor = obtenerGET(window.location)['prov'];

  // if($('#provAbast').val()==0){
  //   var audio = new Audio('componentes/sonidos/error.wav');
  //   audio.play();
  //   Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe seleccionar un Proveedor Primero'});
  //   $('#provAbast').focus();
  //   return;
  // }

  var idProducto = $(this).attr("idProd");
  $(this).removeClass("abastecerProd");
  $("button[idProd='" + idProducto + "']").attr("disabled",'disabled');
  $("button[idProd='" + idProducto + "']").addClass('recuperarBoton');
  var datos = new FormData();
  datos.append("idProducto", idProducto);
  $.ajax({
    url: "ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(r1) {
      var descripcion = r1["descripcion"];
      var dcto = r1["descuento"];
      var sku = r1["sku"];
      var codigoInterno = r1["sku"];
      var prov = r1["proveedor"];
      var listaProveedores = r1["lista_provs_json"] == '' ? '' : JSON.parse(r1["lista_provs_json"]);
      
      var codProv = ''; // cod prov inicial
      $(listaProveedores).each(function (i){
        if(listaProveedores[i].prov == proveedor){
          codProv = listaProveedores[i].cod_prov; // si existe codigo lo asigna
        }
      })

      var stock = r1["stock_"+sucursal];
      var pCTotal = r1['precio_compra'];
      var pCNeto = r1["pc_neto"];
      var pV = r1["precio_venta"];
      var pVM = r1["precio_mayor"];
      var mayor = r1["mayor_sobre"];
      var ubic = r1["zona_"+sucursal];
      var cantSurtir = r1["cant_transf"];
      var transformable = r1["transformable"];
      var idSurtible = r1["id_transf"];

      var datos2 = new FormData();
      datos2.append("idProducto", idSurtible);
      $.ajax({
        url: "ajax/productos.ajax.php",
        method: "POST",
        data: datos2,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(r2) {

          if(transformable == 1){
            var precioVentaUnitarioSurtible = r2['precio_venta'];
            var precioVentaMayorSurtible = r2['precio_mayor'];
            var pCNetoSurtible = Math.round(Number(pCNeto)/Number(cantSurtir)*100)/100;
            var pCIvaSurtible = Math.round(Number(pCTotal)/Number(cantSurtir));
            var vistaInput = '';
          }else{
            var precioVentaUnitarioSurtible = 0;
            var precioVentaMayorSurtible = 0;
            var pCNetoSurtible = 0;
            var pCIvaSurtible = 0;
            var vistaInput = 'd-none';
          }

          productoSurtible = 
            '<font class="'+vistaInput+'" size="-1" style="color:blue">PRODUCTO SURTIBLE: <b>VALORES UNITARIOS</b></font>'+
            '<div class="row '+vistaInput+'" id="borde" style="padding:5px 20px; border: 2px solid blue">'+
              '<div class="col-3 ingPCompraNetoSurtible" style="padding-left:0px">'+
                '<span class="input-group-addon"  style="height: 40px"><i class="fa fa-dollar-sign"></i></span> <font size="-2">P. Compra Neto Unitario</font>'+
                '<div class="input-group">'+
                  '<input type="number" style="height: 40px" class="form-control pCompraNetoSurtible" id="pCompraNetoSurtible" value="'+pCNetoSurtible+'" disabled>'+
                '</div>'+
              '</div>'+
              '<div class="col-3 ingPCompraTotalSurtible" style="padding-left:0px">'+
                '<span class="input-group-addon" style="height: 40px"><i class="fa fa-dollar-sign"></i></span> <font size="-2">P. Compra Total Unitario</font>'+
                '<div class="input-group">'+
                  '<input type="number" style="height: 40px" class="form-control pCompraCIvaSurtible" id="pCompraCIvaSurtible" value="'+pCIvaSurtible+'" disabled>'+
                '</div>'+
              '</div>'+
              '<div class="col-3" style="padding-left:0px">'+
                '<span class="input-group-addon" style="height: 40px"><i class="fa fa-dollar-sign"></i></span> <font size="-2">P. Venta Total Unitario</font>'+
                '<div class="input-group">'+
                  '<input type="number" style="height: 40px" class="form-control pVentaUnitSurtible" value="'+precioVentaUnitarioSurtible+'" required>'+
                '</div>'+
              '</div>'+
              '<div class="col-3" style="padding-left:0px">'+
                '<span class="input-group-addon" style="height: 40px"><i class="fa fa-dollar-sign"></i></span> <font size="-2">P. Venta Mayor</font>'+
                '<div class="input-group">'+
                  '<input type="text" style="height: 40px" class="form-control pVentaMayorSurtible" value="'+precioVentaMayorSurtible+'">'+
                '</div>'+
              '</div>'+
            '</div>';     


          $(".prodAbast").append(
            '<div class="row" id="borde" style="padding:5px 20px; border-style: dashed; border-width: 1px; border-color:red;">'+
              '<div class="col-12 descripcion" style="padding-left:0px">'+
                '<div>'+
                  '<div>'+
                    '<button type="button" class="btn btn-danger btn-xs quitarProdAbast" idProducto="' + idProducto + '">'+
                    '<i class="fa fa-times"></i>'+
                    '</button> <font size="-1"><b>'+ubic+'-'+codigoInterno+'</b> '+descripcion+' <b>(Neto: '+formatNumber.new(pCNeto, "$")+' - $ Total: '+formatNumber.new(pCTotal, "$")+')</b></font>'+
                  '</div>'+
                '</div>'+
              '</div>'+
              '<div style="height:25px"></div>'+
              '<div class="col-3 ingCantAbast" style="padding-left:0px">'+
                '<input type="hidden" class="nomProdAbast" value="'+descripcion+'">'+
                '<span class="input-group-addon" style="height: 40px"><i class="fa fa-cubes"></i></span> <font size="-2">Cantidad Comprada</font>'+
                '<div class="input-group">'+
                  '<input type="number" style="height: 40px" class="form-control cantAbast" sku="'+sku+'" idProd="'+idProducto+'" stk="'+stock+ '" value="0" id="cantAbast" required>'+
                '</div>'+
              '</div>'+
              '<div class="col-4 ingPCompAbastNeto" style="padding-left:0px">'+
                '<span class="input-group-addon" style="height: 40px"><i class="fa fa-dollar-sign"></i></span> <font size="-2">Precio Compra Neto</font>'+
                '<div class="input-group">'+
                  '<input type="number" style="height: 40px" class="form-control pCompAbastNeto" cant_transf="'+cantSurtir+'" transformable="'+transformable+'" step="0.01" prov="'+prov+'" pV="'+pV+'" pVM="'+pVM+'" mayor="'+mayor+'" pCNeto="' +pCNeto+ '" id="pCompAbastNeto" value="'+pCNeto+'" required>'+
                '</div>'+
              '</div>'+
              '<div class="col-5 ingPCompAbastTotal" style="padding-left:0px">'+
                '<span class="input-group-addon" style="height: 40px"><i class="fa fa-dollar-sign"></i></span> <font size="-2">Precio Compra Total</font>'+
                '<div class="input-group">'+
                  '<input type="number" style="height: 40px" class="form-control pCompAbastTotal" cant_transf="'+cantSurtir+'" transformable="'+transformable+'" prov="'+prov+'" pV="'+pV+'" pVM="'+pVM+'" mayor="'+mayor+'" pCTotal="' + pCTotal + '" id="pCompAbastTotal" value="'+pCTotal+'" required>'+
                '</div>'+
              '</div>'+
              '<div class="col-3 codProvDiv" style="padding-left:0px">'+
                '<span class="input-group-addon" style="height: 40px"><i class="fa fa-barcode"></i></span> <font size="-2">Código Proveedor</font>'+
                '<div class="input-group">'+
                  '<input type="text" style="height: 40px" class="form-control codProv" prov="'+prov+'" id="codProv" value="'+codProv+'" required>'+
                '</div>'+
              '</div>'+
              '<div class="col-4 pVUnitAbast" style="padding-left:0px">'+
                '<span class="input-group-addon" style="height: 40px"><i class="fa fa-dollar-sign"></i></span> <font size="-2">Precio Venta Unitario</font>'+
                '<div class="input-group">'+
                  '<input type="number" style="height: 40px" class="form-control pVAbast" dcto="'+dcto+'" min="'+pV+'" pV="'+pV+'" id="pVAbast" value="'+pV+'" required>'+
                '</div>'+
              '</div>'+
              '<div class="col-5 mb-1 pVMayorAbast" style="padding-left:0px">'+
                '<span class="input-group-addon" style="height: 40px"><i class="fa fa-dollar-sign"></i></span> <font size="-2">Precio Venta Mayor (sobre '+mayor+') <b>('+dcto+'% DCTO)</b></font>'+
                '<div class="input-group">'+
                  '<input type="number" style="height: 40px" class="form-control pVMAbast" pVM="' + pVM + '" id="pVMAbast" value="'+pVM+'" required>'+
                '</div>'+
              '</div>'+
              productoSurtible+
            '</div>'+
            '<div id="esp'+idProducto+'" style="height:3px"></div>')
          listarAbastecimiento();
        }
      })
    }
  })
});

/*=============================================
LISTAR ABASTECIMIENTO
=============================================*/
function listarAbastecimiento() {
  var listaProds = [];
  var cant = $(".cantAbast");
  var pCNeto = $(".pCompAbastNeto");
  var pCTotal = $(".pCompAbastTotal");
  var pVUnit = $(".pVAbast");
  var pVMayor = $(".pVMAbast");
  var nomProd = $(".nomProdAbast");
  var prov = $(".codProv");

  var pCNetoSurtible = $('.pCompraNetoSurtible');
  var pCTotalSurtible = $('.pCompraCIvaSurtible');
  var pVUnitSurtible = $('.pVentaUnitSurtible');
  var pVMayorSurtible = $('.pVentaMayorSurtible');

  for (var i = 0; i < cant.length; i++) {

    var cantAbast = Number($(cant[i]).val());

    var datosProd = infoProd($(cant[i]).attr("idProd"));
    var sku = Number(datosProd['categoria']) <= 9 ? '0'+datosProd['sku'] : datosProd['sku'];

    listaProds.push({
      "id": $(cant[i]).attr("idProd"),
      "sku": sku,
      "cant": cantAbast,
      "pCNetoActual": $(pCNeto[i]).val(),
      "pCTotalActual": $(pCTotal[i]).val(),
      "pV": $(pVUnit[i]).val(),
      "pM": $(pVMayor[i]).val(),
      "pCNetoSurtible": $(pCNetoSurtible[i]).val(),
      "pCTotalSurtible": $(pCTotalSurtible[i]).val(),
      "pVUnitSurtible": $(pVUnitSurtible[i]).val(),
      "pVMayorSurtible": $(pVMayorSurtible[i]).val(),
      "nom": $(nomProd[i]).val(),
      "prov": $(prov[i]).attr('prov'),
      "codProv": $(prov[i]).val()      
    })
  }
  $(".abastecimiento").val(JSON.stringify(listaProds));
}

/*=============================================
LISTA EL CODIGO DE PROVEEDOR
=============================================*/
$(".formularioAbastecimiento").on("change", "input#codProv", function(){
  listarAbastecimiento();
});

/*=================================================
ACTIVA PRECIO VENTA NUEVO CUANDO SUBE PRECIO COMPRA
=================================================*/
$(".formularioAbastecimiento").on("change", "input.pCompAbastNeto", function(){
  // PRECIO NETO EN INPUT PRECIO COMPRA TOTAL
  $(this).parent().parent().parent().children('.ingPCompAbastTotal').children().children('#pCompAbastTotal').val(Number(Math.round($(this).val()*1.19)));
  listarAbastecimiento()
  actualizarTotalCompra()

  if($(this).attr('transformable') == 1){ // CAMBIO DE PRECIOS SURTIBLES AUTOMATICO
    pCNetoInput = $(this).val();
    cantSurtir = $(this).attr('cant_transf');
    pCNetoSurtibleCalcular = Number(pCNetoInput)/Number(cantSurtir);
    pCTotalSurtibleCalcular = Math.round(Number(pCNetoSurtibleCalcular)*1.19);
    $(this).parent().parent().parent().children().children('.ingPCompraNetoSurtible').children().children('.pCompraNetoSurtible').val(pCNetoSurtibleCalcular);
    $(this).parent().parent().parent().children().children('.ingPCompraTotalSurtible').children().children('.pCompraCIvaSurtible').val(pCTotalSurtibleCalcular);
  }
});

$(".formularioAbastecimiento").on("change", "input.pCompAbastTotal", function() {
  // PRECIO NETO EN INPUT PRECIO COMPRA NETO
  $(this).parent().parent().parent().children('.ingPCompAbastNeto').children().children('#pCompAbastNeto').val(Number(Math.round($(this).val()/1.19*100)/100));
  listarAbastecimiento()
  actualizarTotalCompra()

  if($(this).attr('transformable') == 1){ // CAMBIO DE PRECIOS SURTIBLES AUTOMATICO
    pCTotalInput = $(this).val();
    cantSurtir = $(this).attr('cant_transf');
    pCTotalSurtibleCalcular = Number(pCTotalInput)/Number(cantSurtir);
    pCNetoSurtibleCalcular = Math.round(Number(pCTotalSurtibleCalcular)/1.19*100)/100;
    $(this).parent().parent().parent().children().children('.ingPCompraNetoSurtible').children().children('.pCompraNetoSurtible').val(pCNetoSurtibleCalcular);
    $(this).parent().parent().parent().children().children('.ingPCompraTotalSurtible').children().children('.pCompraCIvaSurtible').val(pCTotalSurtibleCalcular);
  }  
});

$(".formularioAbastecimiento").on("change", "input.pVentaUnitSurtible,input.pVentaMayorSurtible", function() {
  listarAbastecimiento()
})

/*=============================================
CANTIDAD COMPRA
=============================================*/
$(".formularioAbastecimiento").on("change", "input.cantAbast", function(){
  if($(this).val()<=0){ // NO PERMITE COMPRAR CERO O MENOS UNIDADES 
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'No puedes comprar 0 unidades'});

    $(this).val(1);
    $(this).parent().parent().parent().removeAttr('style');
    $(this).parent().parent().parent().attr('style','padding:5px 20px; border-style: dashed; border-width: 1px;');    
  }else{ // ELIMINA BORDE ROJO SI TODO ESTA BIEN CON STOCK_COMPRA
    $(this).parent().parent().parent().removeAttr('style');
    $(this).parent().parent().parent().attr('style','padding:5px 20px; border-style: dashed; border-width: 1px;');    
  }
  listarAbastecimiento()
  actualizarTotalCompra()
});

/*=============================================
EVITA QUE SE SUPERE EL MINIMO ESTABLECIDO EN PRECIOS VENTA
=============================================*/
$(".formularioAbastecimiento").on("change", "input.pVAbast", function() {
  // SETEAR PRECIO COMPRA MAYOR COMO MAXIMO EN EL PRECIO UNITARIO CON DESCUENTO APLICADO
  var precioMayorMaximo = Math.floor(Number($(this).val())-(Number($(this).attr('dcto'))/100)*Number($(this).val()));
  $(this).parent().parent().parent().children('.pVMayorAbast').children().children('#pVMAbast').val(precioMayorMaximo);
  listarAbastecimiento()
});

/*=============================================
EVITA QUE SE SUPERE EL MINIMO ESTABLECIDO EN PRECIOS VENTA
=============================================*/
$(".formularioAbastecimiento").on("change", "input.pVMAbast", function() {
  listarAbastecimiento()
});

/*=============================================
QUITAR PRODUCTOS DE LA COMPRA
=============================================*/
var idQuitarProdAbast = [];
localStorage.removeItem("quitarProdAbast");
$(".formularioAbastecimiento").on("click", "button.quitarProdAbast", function() {
  $(this).parent().parent().parent().parent().parent().children('#esp'+$(this).attr('idProducto')).remove();
  $(this).parent().parent().parent().parent().remove();
  var idProducto = $(this).attr("idProducto");
  /*=============================================
  ALMACENAR EN EL LOCALSTORAGE EL ID DEL PRODUCTO A QUITAR
  =============================================*/
  if (localStorage.getItem("quitarProdAbast") == null) {
    idQuitarProdAbast = [];
  } else {
    idQuitarProdAbast.concat(localStorage.getItem("quitarProdAbast"))
  }

  idQuitarProdAbast.push({
    "idProducto": idProducto
  });

  localStorage.setItem("quitarProdAbast", JSON.stringify(idQuitarProdAbast));

  $("button[idProd='" + idProducto + "']").removeAttr('disabled');
  $("button.recuperarBoton[idProd='" + idProducto + "']").addClass('abastecerProd');
  $("button[idProd='" + idProducto + "']").removeClass('recuperarBoton');
  listarAbastecimiento()
  actualizarTotalCompra()
})

/*=============================================
NOMBRE PROVEEDOR ABASTECIMIENTO
=============================================*/
$(".formularioAbastecimiento").on("change", "select.provAbast", function(){
  $('#nomProvAbast').val($('#provAbast option:selected').text())
})

/*=============================================
ACTUALIZAR TABLA ABASTECIMIENTO  
=============================================*/
$('#actualizarTblProdsAbast').click(function(){
  $('.tablaAbastecimiento').DataTable().ajax.reload();  
})

/*=============================================
CAMBIOS EN TIPO DE PAGO
=============================================*/
$('.tipoPagoAbastExternoMovil,.tipoPagoAbastExterno').change(function(){
  $('.btnEnviarAbastecimiento').attr('tipoPago',$(this).val());
})

/*=============================================
ENVIAR FORMULARIO ABASTECIMIENTO
=============================================*/
$('.btnEnviarAbastecimiento,.btnGuardarAbastecimiento').click(function(){
  // var motivo = 'abastecer';
  var tipoPago = $(this).attr('tipoPago');
  Swal.fire({
    title: "Corregir Total",
    input: "number",
    inputValue: $('#totalCompra').val(),
    inputAttributes: {
      maxlength: 10,
      onkeypress: "return soloNumeros(event)"
    },
    confirmButtonText: "Ok",
    inputValidator: valor => {
      if (!valor) {
        return 'Rectifique o Ratifique el valor de la factura'
      }else{
        $('#totalCompra').val(valor);
        enviarAbastecimiento($(this).val());
      }
    }
  })
})

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*=============================================
FUNCIONES PERSONALIZADAS
=============================================*/
function actualizarTotalCompra(){
  var totalNeto = 0;
  $(".cantAbast").each(function(){
    pCompraNeto = $(this).parent().parent().parent().children('.ingPCompAbastNeto').children().children('#pCompAbastNeto').val();
    if (isNaN(parseInt($(this).val()))){
        totalNeto = 0;
    }else{
        totalNeto = Number(totalNeto) + Number($(this).val())*Number(pCompraNeto);
    }
  });

  var totalCIva = Math.round(Number(totalNeto)*1.19);
  $("#totalCompra").val(totalCIva);
  $(".totalCompraMostrar").html('   '+formatNumber.new(Math.round(totalNeto))+' / <b>'+formatNumber.new(totalCIva))+'</b>';
}

function configCompra(){
  var sucursal = $('#sucurCompra').val();
  var proveedor = $('#provCompra').val();
  if(sucursal!=0 && proveedor!=0 && esDispositivoMovil() == false){
    window.open("index.php?ruta=registro-compra&suc="+sucursal+"&prov="+proveedor, "_blank");
    $('#sucurCompra').val(0);
    $('#provCompra').val(0);
    $('#modalRegistroCompra').modal('hide');
  }else if(sucursal!=0 && proveedor!=0 && esDispositivoMovil() == true){
    window.open("index.php?ruta=registro-compra-movil&suc="+sucursal+"&prov="+proveedor, "_blank");
    $('#sucurCompra').val(0);
    $('#provCompra').val(0);
    $('#modalRegistroCompra').modal('hide');
  }else{
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'DEBE SELECCIONAR SUCURSAL Y PROVEEDOR'});
  }
}


function enviarAbastecimiento(motivo){

  var abastecimiento = $("#abastecimiento").val();
  var buscar_ceros = 0;
  $(".cantAbast").each(function(){
    if($(this).val()==0){
      buscar_ceros += 1;
    }
  });

  if(abastecimiento == "[]" || abastecimiento == "") {
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Debe agregar productos'});

  }else if(buscar_ceros==1){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Falta ingresar stock comprado de 1 producto, fijarse en borde rojo'});

  }else if(buscar_ceros>1){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Falta ingresar stock comprado de '+buscar_ceros+' productos, fijarse en borde rojo'});

  }else if($('#fechaAbast').val() == ''){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese fecha correcta'});
    $('#fechaAbast').select();

  }else if($('#provAbast option:selected').val()==0){
    var audio = new Audio('componentes/sonidos/error.wav');
    audio.play();
    Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Falta seleccionar al proveedor'});
    $('#provAbast').focus();


// reparar este script
  }else if(screen.width >= 992 && $('#documentoAbast option:selected').val()==''){ // detecta computador
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Falta seleccionar tipo de documento'});
      $('#documentoAbast').focus();
  }else if(screen.width >= 992 && $('#documentoAbast option:selected').val()=='factura' && $('#nroFactura').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese nro de Factura de compra'});
      $('#nroFactura').select();
  }else if(screen.width >= 992 && $('#documentoAbast option:selected').val()=='guia' && $('#nroGuia').val()=='' && $('#nroFacturaGuia').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese nro de Guía y Factura asociada a la compra'});
      $('#nroGuia').select();
  }else if(screen.width >= 992 && $('#documentoAbast option:selected').val()=='guia' && $('#nroGuia').val()!='' && $('#nroFacturaGuia').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese nro de Factura asociada a la compra'});
      $('#nroGuia').select();
  }else if(screen.width >= 992 && $('#documentoAbast option:selected').val()=='guia' && $('#nroGuia').val()=='' && $('#nroFacturaGuia').val()!=''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese nro de Guía asociada a la compra'});
      $('#nroGuia').select();
  }else if(screen.width >= 992 && $('#documentoAbast option:selected').val()=='otro' && $('#nroOtro').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese nro de referencia de la compra'});
      $('#nroOtro').select();
  }else if(screen.width >= 992 && $('#tipoPagoAbastExterno option:selected').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese tipo de pago'});
      $('#tipoPagoAbastExterno').focus();
  
  }else if(screen.width < 992 && $('#documentoAbastMovil option:selected').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Falta seleccionar tipo de documento'});
      $('#documentoAbastMovil').focus();
  }else if(screen.width < 992 && $('#documentoAbastMovil option:selected').val()=='factura' && $('#nroFacturaMovil').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese nro de Factura de compra'});
      $('#nroFacturaMovil').select();
  }else if(screen.width < 992 && $('#documentoAbastMovil option:selected').val()=='guia' && $('#nroGuiaMovil').val()=='' && $('#nroFacturaGuiaMovil').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese nro de Guía y Factura asociada a la compra'});
      $('#nroGuiaMovil').select();
  }else if(screen.width < 992 && $('#documentoAbastMovil option:selected').val()=='guia' && $('#nroGuiaMovil').val()!='' && $('#nroFacturaGuiaMovil').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese nro de Factura asociada a la compra'});
      $('#nroGuiaMovil').select();
  }else if(screen.width < 992 && $('#documentoAbastMovil option:selected').val()=='guia' && $('#nroGuiaMovil').val()=='' && $('#nroFacturaGuiaMovil').val()!=''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese nro de Guía asociada a la compra'});
      $('#nroGuiaMovil').select();
  }else if(screen.width < 992 && $('#documentoAbastMovil option:selected').val()=='otro' && $('#nroOtroMovil').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese nro de referencia de la compra'});
      $('#nroOtroMovil').select();
  }else if(screen.width < 992 && $('#tipoPagoAbastExternoMovil option:selected').val()==''){
      new Audio('componentes/sonidos/error.wav').play();
      Swal.mixin({toast: true,position: 'top',showConfirmButton: false,timer: 2000}).fire({icon: 'error',title: 'Ingrese tipo de pago'});
      $('#tipoPagoAbastExternoMovil').focus();
  }else{    

    var datos = new FormData();
    datos.append("abastecimiento", $('#abastecimiento').val());
    datos.append("tipoAbastecimiento", motivo);    
    datos.append("totalCompra", $('#totalCompra').val());
    datos.append("sucursalCompraNombre", $('#sucursalCompraNombre').val());
    datos.append("provAbast", $('#provAbast').val());
    datos.append("nomProvAbast", $('#nomProvAbast').val());
    datos.append("fechaAbast", $('#fechaAbast').val());
    
    if( $('#documentoAbast').val() == 'factura'){
      
      datos.append("nroFactura", $('#nroFactura').val());
    
    }else if( $('#documentoAbast').val() == 'guia'){

      datos.append("nroGuia", $('#nroGuia').val());
      datos.append("nroFacturaGuia", $('#nroFacturaGuia').val());
    
    }else if( $('#documentoAbast').val() == 'otro'){

      datos.append("nroOtro", $('#nroOtro').val());

    }else if( $('#documentoAbast').val() == 'otro'){
    
      datos.append("nroFacturaGuiaMovil", $('#nroFacturaGuiaMovil').val());
      datos.append("nroGuiaMovil", $('#nroGuiaMovil').val());
    
    }else if( $('#documentoAbast').val() == 'otro'){
    
      datos.append("nroOtroMovil", $('#nroOtroMovil').val());

    }
    datos.append("tipoPagoAbastExterno", $('#tipoPagoAbastExterno').val());

    Swal.fire({
      title: 'Registrando Compra...',
      text: 'Espere un momento',
      allowOutsideClick: false,
      allowEscapeKey: false,
      allowEnterKey: false,
      didOpen: () => {
        Swal.showLoading();
      }
    });
    
    $.ajax({
      url: "ajax/compras.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      // dataType: "json",
      success: function(respuesta) {
        if(respuesta == 'ok'){
          $('#formularioAbastecimiento')[0].reset();
          $('#documentoAbastInputs').html(
            '<div class="user-block mb-3">'+
              '<img class="img-circle img-bordered-xs info" data-original-title="Nro Factura" src="componentes/img/sama/codigo.png" alt="codigo">'+
              '<span class="username">'+                        
                '<input type="text" class="form-control" id="nroFactura" name="nroFactura" maxlength="9" placeholder="Nro Factura" disabled>'+
              '</span>'+
            '</div>');
          $('#documentoAbastInputs2').html('')
          $('.prodAbast').html('');
          $('#totalCompra').val(0);
          $(".totalCompraMostrar").html('   0');
          $('.tablaAbastecimiento').DataTable().ajax.reload();
          Swal.close();
          if(motivo == 'Abastecer'){
            audioSuccess("Compra Registrada correctamente");
          }else{
            audioInfo("Compra Guardada correctamente");
          }
        }
      }
    })
  }
}