$('.tblCats').DataTable( {
    "deferRender": true,
    "retrieve": true,
    "processing": true,
    "pageLength": 25,
    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "&rarr;",
        "sPrevious": "&larr;"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }

    },
    dom: '<"row"<"col-12"><"col-12"f>>t<"row"<"col-12 col-6"p>>',
});

/*=============================================
EDITAR CATEGORIA
=============================================*/
$(".tblCats").on("click", ".btnEditarCategoria", function(){

	var idCategoria = $(this).attr("idCategoria");
	var datos = new FormData();
	datos.append("idCategoria", idCategoria);

	$.ajax({
		url: "ajax/categorias.ajax.php",
		method: "POST",
      	data: datos,
      	cache: false,
     	contentType: false,
     	processData: false,
     	dataType:"json",
     	success: function(respuesta){

     		$("#editarCategoria").val(respuesta["categoria"]);
     		$("#idCategoria").val(respuesta["id"]);
     		$("#subCategoria").val(respuesta["subcategorias"]);
     	}

	})


})

/*=============================================
EDITAR SUBCATEGORIA
=============================================*/
$(".tblCats").on("click", ".btnEditarSubcategoria", function(){

	var idSubcategoria = $(this).attr("idSubcategoria");

	var datos = new FormData();
	datos.append("idSubcategoria", idSubcategoria);

	$.ajax({
		url: "ajax/categorias.ajax.php",
		method: "POST",
      	data: datos,
      	cache: false,
     	contentType: false,
     	processData: false,
     	dataType:"json",
     	success: function(respuesta){

     		$("#editarSubcategoria").val(respuesta["subcategoria"]);
     		$("#idSubcategoria").val(respuesta["id"]);
     		// $("#subCategoria").val(respuesta["subcategorias"]);
     	}

	})


})



/*=============================================
ELIMINAR CATEGORIA
=============================================*/
$(".tblCats").on("click", ".btnEliminarCategoria", function(){

	 var idCategoria = $(this).attr("idCategoria");

	 Swal.fire({
	 	title: '¿Está seguro de borrar la categoría?',
	 	text: "¡Si no lo está puede cancelar la acción!",
	 	type: 'warning',
	 	showCancelButton: true,
	 	confirmButtonColor: '#3085d6',
	 	cancelButtonColor: '#d33',
	 	cancelButtonText: 'Cancelar',
	 	confirmButtonText: 'Si, borrar categoría!'
	 }).then(function(result){

	 	if(result.value){

	 		window.location = "index.php?ruta=categorias-admin&idCategoria="+idCategoria;

	 	}

	 })

})


/*=============================================
ELIMINAR SUBCATEGORIA
=============================================*/
$(".tblCats").on("click", ".btnEliminarSubcategoria", function(){

	 var idSubcategoria = $(this).attr("idSubcategoria");

	 Swal.fire({
	 	title: '¿Está seguro de borrar la subcategoría?',
	 	text: "¡Si no lo está puede cancelar la acción!",
	 	type: 'warning',
	 	showCancelButton: true,
	 	confirmButtonColor: '#3085d6',
	 	cancelButtonColor: '#d33',
	 	cancelButtonText: 'Cancelar',
	 	confirmButtonText: 'Si, borrar categoría!'
	 }).then(function(result){

	 	if(result.value){

	 		window.location = "index.php?ruta=subcategorias-admin&idSubcategoria="+idSubcategoria;

	 	}

	 })

})