/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// INFO EMPRESA
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
$('#btnGuardarAjustesInfoEmpresa').click(function(){
	let nombreEmpresa = $('#nombreReal').val()
	let nombreFantasia = $('#nombreComercial').val()
	let rutEmpresa = $('#rutComercial').val()
	let giroComercial = $('#giroComercial').val()
	let direccionEmpresa = $('#direccionComercial').val()
  	let datos = new FormData();
  	datos.append("nombreEmpresa", nombreEmpresa);
  	datos.append("nombreFantasia", nombreFantasia);
  	datos.append("rutEmpresa", rutEmpresa);
  	datos.append("giroComercial", giroComercial);
  	datos.append("direccionEmpresa", direccionEmpresa);
	$.ajax({
    	url:"ajax/ajustes.ajax.php",
    	method: "POST",
    	data: datos,
    	cache: false,
    	contentType: false,
    	processData: false,
    	success:function(r){
    		if(r == 'ok'){
				$('.ajustesInfoEmpresa').attr('disabled','');
				$('#btnEditarAjustesInfoEmpresa').text('Editar Configuración');
				$('#btnEditarAjustesInfoEmpresa').removeClass('btn-default');
				$('#btnEditarAjustesInfoEmpresa').addClass('btn-warning');
    			audioSuccess('Información modificada exitosamente');
    		}else{
    			audioError('Ocurrio algún error');
    		}
    	}
    })
})

$("#btnEditarAjustesInfoEmpresa").on("click", function(){
	if($(this).hasClass('btn-warning')){ // boton editar
		$('.ajustesInfoEmpresa').removeAttr('disabled');
		$(this).text('Cancelar');
		$(this).removeClass('btn-warning');
		$(this).addClass('btn-default');
		$('#nombreEmpresa').select();
	}else{ // boton cancelar
		$('.ajustesInfoEmpresa').attr('disabled','');
		$(this).text('Editar Configuración');
		$(this).removeClass('btn-default');
		$(this).addClass('btn-warning');
		let ids = ['nombreReal','nombreComercial','rutComercial','giroComercial','direccionComercial'];
		for (var i = ids.length - 1; i >= 0; i--) {
			let ajusteActual = ids[i].replace(/([a-z])([A-Z])/g, '$1_$2').toLowerCase();
			$('#'+ids[i]).val(ajuste(ajusteActual));
		}
	}
})

/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// INFO BANCO
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
$('#btnGuardarAjustesBanco').click(function(){
	let nombreBanco = $('#nombreBanco').val()
	let tipoCuentaBanco = $('#tipoCuentaBanco').val()
	let nroCuentaBanco = $('#nroCuentaBanco').val()
	let rutTitularBanco = $('#rutTitularBanco').val()
	let nombreTitularBanco = $('#nombreTitularBanco').val()
	let correoPagosBanco = $('#correoPagosBanco').val()
  	let datos = new FormData();
  	datos.append("nombreBanco", nombreBanco);
  	datos.append("tipoCuentaBanco", tipoCuentaBanco);
  	datos.append("nroCuentaBanco", nroCuentaBanco);
  	datos.append("rutTitularBanco", rutTitularBanco);
  	datos.append("nombreTitularBanco", nombreTitularBanco);
  	datos.append("correoPagosBanco", correoPagosBanco);
	$.ajax({
    	url:"ajax/ajustes.ajax.php",
    	method: "POST",
    	data: datos,
    	cache: false,
    	contentType: false,
    	processData: false,
    	success:function(r){
    		if(r == 'ok'){
				$('.ajustesInfoBanco').attr('disabled','');
				$('#btnEditarAjustesInfoBanco').text('Editar Datos Bancarios');
				$('#btnEditarAjustesInfoBanco').removeClass('btn-default');
				$('#btnEditarAjustesInfoBanco').addClass('btn-warning');
    			audioSuccess('Información Bancaria editada exitosamente');
    		}else{
    			audioError('Ocurrio algún error');
    		}
    	}
    })
})

$("#btnEditarAjustesBanco").on("click", function(){
	if($(this).hasClass('btn-warning')){ // boton editar
		$('.ajustesInfoBanco').removeAttr('disabled');
		$(this).text('Cancelar');
		$(this).removeClass('btn-warning');
		$(this).addClass('btn-default');
		$('#nombreBanco').focus();
	}else{ // boton cancelar
		$('.ajustesInfoBanco').attr('disabled','');
		$(this).text('Editar Configuración');
		$(this).removeClass('btn-default');
		$(this).addClass('btn-warning');
		let ids = ['nombreBanco','tipoCuentaBanco','nroCuentaBanco','rutTitularBanco','nombreTitularBanco','correoPagosBanco'];
		for (var i = ids.length - 1; i >= 0; i--) {
			let ajusteActual = ids[i].replace(/([a-z])([A-Z])/g, '$1_$2').toLowerCase();
			$('#'+ids[i]).val(ajuste(ajusteActual));
		}
	}
})

/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
// AJUSTES FILA
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
$(".btnEditAjuste").on("click", function(){
	if($(this).hasClass('cot')){
		var tipoAjuste = 'Cot';
	}else if($(this).hasClass('venta')){
		var tipoAjuste = 'Ventas';
	}else if($(this).hasClass('compras')){
		var tipoAjuste = 'Compras';
	}else if($(this).hasClass('prod')){
		var tipoAjuste = 'Prod';
	}else if($(this).hasClass('print')){
		var tipoAjuste = 'Print';
	}
	$(this).html('<i class="fas fa-check"></i>');
	$(this).addClass('btn-success btnActualizarAjuste').removeClass('btn-warning btnEditAjuste');
	$(this).parent().children('.btnCancelarEdicionAjuste').removeClass('d-none');
	$(this).parent().parent().parent().children('.divAjuste').children('.ajuste'+tipoAjuste).removeAttr('disabled').select();
	$(this).parent().parent().parent().children('.divAjusteSlider').children('.ajuste'+tipoAjuste).removeAttr('disabled').select();
	$(this).attr('onclick','modificarAjuste($(this))');
})

$(".ajusteCot, .ajusteVentas, .ajusteCompras, .ajusteProd, .ajustePrint").on("change", function(){
	if($(this).hasClass('ajusteCot')){	
		var tipoAjuste = 'Cot';
	}else if($(this).hasClass('ajusteVentas')){
		var tipoAjuste = 'Ventas';
	}else if($(this).hasClass('compras')){
		var tipoAjuste = 'Compras';
	}else if($(this).hasClass('prod')){
		var tipoAjuste = 'Prod';
	}else if($(this).hasClass('print')){
		var tipoAjuste = 'Print';
	}
	let valor = $(this).val();
	$(this).parent().parent().children('.divAjuste').children().val(valor);
	$(this).parent().parent().children('.divAjusteSlider').children().val(valor);
	let calculoPrecio = Math.round(1000*(1+Number(valor)/100));
	let calculoUtilidad = Math.round(1000*Number(valor)/100);

	if($(this).hasClass('vend')){
		$('#ejemploUtMinVend'+tipoAjuste).html(
			'<b>('+valor+'%)</b>. '+
			'Si el producto lo compro en $1.000, <b>MÍNIMO</b> se cotizará en <i>$'+formatNumber.new(calculoPrecio)+'</i> '+
			'asegurando a lo menos una utilidad de <b>$'+formatNumber.new(calculoUtilidad)+'</b>.')		
	}else if($(this).hasClass('admin')){
		$('#ejemploUtMinAdmin'+tipoAjuste).html(
			'<b>('+valor+'%)</b>. '+
			'Si el producto lo compro en $1.000, <b>MÍNIMO</b> se cotizará en <i>$'+formatNumber.new(calculoPrecio)+'</i> '+
			'asegurando a lo menos una utilidad de <b>$'+formatNumber.new(calculoUtilidad)+'</b>.')		
	}
})

$(".btnCancelarEdicionAjuste").on("click", function(){
	$(this).addClass('d-none');
	$(this).parent().children('.btnActualizarAjuste').removeClass('btn-success').addClass('btn-warning btnEditAjuste');
	$(this).parent().children('.btnActualizarAjuste').html("<i class='fa fa-pen'></i>");
	$(this).parent().children('.btnActualizarAjuste').removeAttr("onclick");
	$(this).parent().children('.btnActualizarAjuste').removeClass('btnActualizarAjuste');
	$(this).parent().parent().parent().children('.divAjuste').children().attr('disabled','');
	$(this).parent().parent().parent().children('.divAjusteSlider').children().attr('disabled','');
	let ajusteActual = $(this).parent().parent().parent().children('.divAjuste').children().attr('id').replace(/([a-z])([A-Z])/g, '$1_$2').toLowerCase();
	$(this).parent().parent().parent().children('.divAjuste').children().val(ajuste(ajusteActual));
	$(this).parent().parent().parent().children('.divAjusteSlider').children().val(ajuste(ajusteActual));
})

function modificarAjuste(obj){
	if(obj.parent().parent().parent().children('.divAjuste').children().hasClass('miles')){
		var valor = parseInt(obj.parent().parent().parent().children('.divAjuste').children().val().replace(/\./g, ''));
	}else{
		var valor = obj.parent().parent().parent().children('.divAjuste').children().val();
	}
	let itemAjuste = obj.parent().parent().parent().children('.divAjuste').children().attr('id').replace(/([a-z])([A-Z])/g, '$1_$2').toLowerCase();
  	let datos = new FormData();
  	datos.append("ajustarConfig", valor);
  	datos.append("itemAjuste", itemAjuste);
	$.ajax({
    	url:"ajax/ajustes.ajax.php",
    	method: "POST",
    	data: datos,
    	cache: false,
    	contentType: false,
    	processData: false,
    	success:function(r){
    		if(r == 'ok'){
				obj.parent().children('.btnCancelarEdicionAjuste').addClass('d-none');
				obj.removeClass('btn-success btnActualizarAjuste').addClass('btn-warning btnEditAjuste').removeAttr("onclick").html("<i class='fa fa-pen'></i>");
				obj.parent().parent().parent().children('.divAjuste').children().attr('disabled','');
				if(obj.parent().parent().parent().children('.divAjuste').children().hasClass('miles')){
					obj.parent().parent().parent().children('.divAjuste').children().val(formatNumber.new(valor));
				}
				obj.parent().parent().parent().children('.divAjusteSlider').children().attr('disabled','');
				mixinSuccess('Ajuste modificado exitosamente');
    		}
    	}
    })
}

/* *******************************************************************
CONTROL USO IMPRESORA TERMICA
******************************************************************* */

if(obtenerPAGINA_y_GET(window.location).pagina == 'ajustes'){ // carga solo cuando se está en ajustes
	const checkboxUsoImpresora = document.querySelector('.checkboxUsoImpresora')
	checkboxUsoImpresora.addEventListener('change', (e) => {
		var datos = new FormData();
	  	if (e.target.checked) {
		  	datos.append("ajustarConfig", 1);
			datos.append("itemAjuste", 'usoImpresoraTermica'.replace(/([a-z])([A-Z])/g, '$1_$2').toLowerCase());
			$.ajax({
		    	url:"ajax/ajustes.ajax.php",
		    	method: "POST",
		    	data: datos,
		    	cache: false,
		    	contentType: false,
		    	processData: false,
		    	success:function(r){
		    		mixinInfo('Uso Impresora Activado');
		    	}
		    })
	  	} else {
		  	datos.append("ajustarConfig", 0);
			datos.append("itemAjuste", 'usoImpresoraTermica'.replace(/([a-z])([A-Z])/g, '$1_$2').toLowerCase());
			$.ajax({
		    	url:"ajax/ajustes.ajax.php",
		    	method: "POST",
		    	data: datos,
		    	cache: false,
		    	contentType: false,
		    	processData: false,
		    	success:function(r){
		    		mixinInfo('Uso Impresora Desactivado');
		    	}
		    })  	
		}
	})
}