<?php
ini_set('memory_limit', '512M');
require_once "conexion.php";
class ModeloVentas{

	/*=============================================
	EXTRAER DIAS TRABAJADOS
	=============================================*/
	static public function mdlDiasTrabajados($fecha){
		$stmt = Conexion::conectar()->prepare("SELECT DISTINCT(fecha_cont) from ventas WHERE fecha_cont like '%$fecha%' and estado != 0");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	SELECCIONAR VENTAS MES ANTERIOR
	=============================================*/
	static public function mdlSeleccionarVentasAnteriores($mesesAtras){

		date_default_timezone_set("America/Santiago");
	    if($mesesAtras == 'atras_1_mes'){
	    	$fechaCorte =  date('Y-m', strtotime('-1 month')); 
			$stmt = Conexion::conectar()->prepare("SELECT * FROM ventas WHERE estado != 0 AND fecha_cont LIKE '%$fechaCorte%'"); // IMPAGAS Y ATRASADAS 
	    }else if($mesesAtras == 'atras_6_meses'){
	    	$fechaInicio =  date('Y-m', strtotime('-6 month')).'-01';
		    $fechaFin = date('Y-m').'-01';
			$stmt = Conexion::conectar()->prepare("SELECT * FROM ventas WHERE estado != 0 AND fecha_cont >= '$fechaInicio' AND fecha_cont < '$fechaFin'"); // IMPAGAS Y ATRASADAS 
	    }else if($mesesAtras == 'atras_12_meses'){
	    	$fechaInicio = date('Y-m', strtotime('-12 month')).'-01';
		    $fechaFin = date('Y-m').'-01';
			$stmt = Conexion::conectar()->prepare("SELECT * FROM ventas WHERE estado != 0 AND fecha_cont >= '$fechaInicio' AND fecha_cont < '$fechaFin'"); // IMPAGAS Y ATRASADAS 
	    }else if($mesesAtras == 'hace_1_anio'){
	    	$fechaCorte =  date('Y-m', strtotime('-1 year')); 
			$stmt = Conexion::conectar()->prepare("SELECT * FROM ventas WHERE estado != 0 AND fecha_cont LIKE '%$fechaCorte%'"); // IMPAGAS Y ATRASADAS 	    	
	    }
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlTotalVentasAnteriores($mesesAtras){

		date_default_timezone_set("America/Santiago");
	    if($mesesAtras == 'atras_1_mes'){
	    	$fechaCorte =  date('Y-m', strtotime('-1 month')); 
			$stmt = Conexion::conectar()->prepare("SELECT sum(total) FROM ventas WHERE estado != 0 AND fecha_cont LIKE '%$fechaCorte%'"); // IMPAGAS Y ATRASADAS 
	    }else if($mesesAtras == 'atras_6_meses'){
	    	$fechaInicio =  date('Y-m', strtotime('-6 month')).'-01';
		    $fechaFin = date('Y-m').'-01';
			$stmt = Conexion::conectar()->prepare("SELECT sum(total) FROM ventas WHERE estado != 0 AND fecha_cont >= '$fechaInicio' AND fecha_cont < '$fechaFin'"); // IMPAGAS Y ATRASADAS 
	    }else if($mesesAtras == 'atras_12_meses'){
	    	$fechaInicio = date('Y-m', strtotime('-12 month')).'-01';
		    $fechaFin = date('Y-m').'-01';
			$stmt = Conexion::conectar()->prepare("SELECT sum(total) FROM ventas WHERE estado != 0 AND fecha_cont >= '$fechaInicio' AND fecha_cont < '$fechaFin'"); // IMPAGAS Y ATRASADAS 
	    }else if($mesesAtras == 'hace_1_anio'){
	    	$fechaCorte =  date('Y-m', strtotime('-1 year')); 
			$stmt = Conexion::conectar()->prepare("SELECT sum(total) FROM ventas WHERE estado != 0 AND fecha_cont LIKE '%$fechaCorte%'"); // IMPAGAS Y ATRASADAS 	    	
	    }
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}



	/*=============================================
	SELECCIONAR VENTAS POR FACTURAR
	=============================================*/
	static public function mdlSeleccionarVentasFacturar($id, $desde){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM `ventas` WHERE cod_venta >= $desde AND id_cliente = $id");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	SELECCIONAR ULTIMO_ID_REGISTRO
	=============================================*/
	static public function mdlSeleccionarUltimoIdVenta($perfil){
		// if($perfil=='Administrador'){
			$stmt = Conexion::conectar()->prepare("SELECT MAX(id) AS id FROM ventas where estado != 0");
		// }else{
		// 	$stmt = Conexion::conectar()->prepare("SELECT MAX(id) AS id FROM ventas where estado != 0 AND vista_vendedor = 1");
		// }
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}


	/*=============================================
	PROCESOS OPTIMIZADOS
	=============================================*/
	static public function mdlSumaYCantColVentasMes($anio_mes, $col){
	    $stmt = Conexion::conectar()->prepare("SELECT SUM($col) AS suma, COUNT($col) AS cant FROM ventas WHERE fecha_cont LIKE :anio_mes AND estado != 0");
    	$anio_mes_param = "%$anio_mes%";
    	$stmt->bindParam(':anio_mes', $anio_mes_param);
    	$stmt->execute();
    	$resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    	$stmt = null;
    
	    return [
	        'suma' => $resultado['suma'],
	        'cant' => $resultado['cant']
	    ];
	}

	static public function mdlMostrarVentasFecha($fechaCont){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM ventas WHERE fecha_cont = :fechaCont AND estado != 0 ORDER BY cod_venta DESC");
	    $stmt->bindParam(":fechaCont", $fechaCont, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}


	/*=============================================
	MOSTRAR VENTAS
	=============================================*/
	static public function mdlMostrarVentas($tabla, $item, $valor, $compItem, $compEstado, $estado, $filOrden, $ord){
		if($item == 'fecha_cont'){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item $compItem :$item AND estado $compEstado $estado ORDER BY $filOrden $ord");
			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
			$stmt -> execute();
			return $stmt -> fetchAll();
		}else if($item != null){
			// $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item $compItem :$item AND estado $compEstado $estado ORDER BY $filOrden $ord");
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item $compItem :$item AND estado $compEstado $estado ORDER BY $filOrden $ord");
			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
			$stmt -> execute();
			return $stmt -> fetch();
		}else{
			// $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado $compEstado $estado ORDER BY $filOrden $ord");
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado $compEstado $estado ORDER BY $filOrden $ord");
			$stmt -> execute();
			return $stmt -> fetchAll();
		}
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR VENTAS
	=============================================*/
	static public function mdlMostrarVentasPendientes($idCliente){
		if($idCliente != null){	// ventas del cliente
			$stmt = Conexion::conectar()->prepare("SELECT * FROM ventas WHERE estado != 0 AND id_cliente = '$idCliente' AND tipo_pago = 'Pend' ORDER BY id ASC");
			$stmt -> execute();
			return $stmt -> fetchAll();
			$stmt -> close();
			$stmt = null;
		}else{ // todas las ventas pendientes
			$stmt = Conexion::conectar()->prepare("SELECT id_cliente FROM ventas WHERE estado != 0 AND tipo_pago = 'Pend' AND id_cliente != 1 ORDER BY id ASC");
			$stmt -> execute();
			return $stmt -> fetchAll();
			$stmt -> close();
			$stmt = null;
		}
	}

	/*=============================================
	MOSTRAR VENTAS
	=============================================*/
	static public function mdlMostrarVentasEditadas($fecha){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM ventas WHERE fecha_cont = '$fecha' AND estado = 2 ORDER BY id ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR VENTAS MONTO EXTRAIBLE
	=============================================*/
	static public function mdlMostrarVentasMontoExtraible($fecha){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM ventas WHERE fecha_cont = '$fecha' AND monto_extraible = 1 ORDER BY id ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}


	/*=============================================
	MOSTRAR VENTAS SIN UTILIDAD
	=============================================*/
	static public function mdlMostrarVentasSinUtilidad($fechaCont){

		$stmt = Conexion::conectar()->prepare("SELECT * FROM ventas WHERE fecha_cont = '$fechaCont' AND estado != 0 AND utilidad_total = 0");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}


	/*=============================================
	MOSTRAR 30 ULTIMOS DIAS DE VENTAS
	=============================================*/
	static public function mdlMostrarVentasIntervalo($tabla, $item, $fechaInicial, $fechaFinal){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado != 0 AND $item >= '$fechaInicial' AND $item <= '$fechaFinal' ORDER BY cod_venta DESC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	VENTAS POR HORA
	=============================================*/
	static public function mdlVentasPorHora($tabla, $columna, $hora1, $hora2, $fecha, $compEstado, $estado){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE (HOUR($columna)>=$hora1 AND HOUR($columna)<$hora2) AND $columna like '%$fecha%' AND estado $compEstado $estado");
		$stmt -> execute();
		return $stmt -> fetchAll();		
		$stmt -> close();
		$stmt = null;
	}


	/*=============================================
	MOSTRAR VENTAS MES
	=============================================*/
	static public function mdlMostrarVentasMes($tabla, $idUsuario){
		date_default_timezone_set("America/Santiago");		
		$fechaFinal = date("Y-m");	
		if($_SESSION['perfil'] == 'Vendedor'){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE fecha_cont like '%$fechaFinal%' AND id_vendedor = $idUsuario AND estado != 0");			
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE fecha_cont like '%$fechaFinal%' AND estado != 0");
		}
			$stmt -> execute();
			return $stmt -> fetchAll();
			$stmt -> close();
			$stmt = null;					
	}

	/*=============================================
	REGISTRO DE VENTA
	=============================================*/
	static public function mdlIngresarVenta($tabla, $datos){

		$sucursal = $_SESSION['sucursal'];
		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(estado, vista_vendedor, id_cliente, nom_client, rut_factura, id_vendedor, nom_vend, productos, impuesto, neto, total, monto_extraible, descuentos, detalle_venta, detalle_flete, prods_sugeridos_vendidos, total_prods_sugeridos, utilidad_neta, utilidad_total, fecha_venta, fecha_cont, tipo_pago, metodo_pago, cod_venta, sucursal_venta, fecha) VALUES (:estado, :vista_vendedor, :id_cliente, :nom_client, :rut_factura, :id_vendedor, :nom_vend, :productos, :impuesto, :neto, :total, :monto_extraible, :descuentos,  :detalle_venta, :detalle_flete, :prods_sugeridos_vendidos, :total_prods_sugeridos, :utilidad_neta, :utilidad_total, :fecha_venta, :fecha_cont, :tipo_pago, :metodo_pago, :cod_venta, '$sucursal', :fecha)");
		
		$stmt->bindParam(":id_cliente", $datos["id_cliente"], PDO::PARAM_INT);
		$stmt->bindParam(":estado", $datos["estado"], PDO::PARAM_INT);
		$stmt->bindParam(":vista_vendedor", $datos["vista_vendedor"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_client", $datos["nom_client"], PDO::PARAM_STR);
		$stmt->bindParam(":rut_factura", $datos["rut_factura"], PDO::PARAM_STR);
		$stmt->bindParam(":id_vendedor", $datos["id_vendedor"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_vend", $datos["nom_vend"], PDO::PARAM_STR);
		$stmt->bindParam(":productos", $datos["productos"], PDO::PARAM_STR);
		$stmt->bindParam(":impuesto", $datos["impuesto"], PDO::PARAM_STR);
		$stmt->bindParam(":neto", $datos["neto"], PDO::PARAM_STR);
		$stmt->bindParam(":total", $datos["total"], PDO::PARAM_STR);
		$stmt->bindParam(":monto_extraible", $datos["monto_extraible"], PDO::PARAM_INT);
		$stmt->bindParam(":descuentos", $datos["descuentos"], PDO::PARAM_STR);
		$stmt->bindParam(":detalle_venta", $datos["detalle_venta"], PDO::PARAM_STR);
		$stmt->bindParam(":detalle_flete", $datos["detalle_flete"], PDO::PARAM_STR);
		$stmt->bindParam(":prods_sugeridos_vendidos", $datos["prods_sugeridos_vendidos"], PDO::PARAM_STR);
		$stmt->bindParam(":total_prods_sugeridos", $datos["total_prods_sugeridos"], PDO::PARAM_INT);
		$stmt->bindParam(":utilidad_neta", $datos["utilidad_neta"], PDO::PARAM_STR);
		$stmt->bindParam(":utilidad_total", $datos["utilidad_total"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_venta", $datos["fecha_venta"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha", $datos["fecha"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_cont", $datos["fecha_cont"], PDO::PARAM_STR);
		$stmt->bindParam(":tipo_pago", $datos["tipo_pago"], PDO::PARAM_STR);
		$stmt->bindParam(":metodo_pago", $datos["metodo_pago"], PDO::PARAM_STR);	
		$stmt->bindParam(":cod_venta", $datos["cod_venta"], PDO::PARAM_STR);
		// $stmt->bindParam(":propietario", $datos["propietario"], PDO::PARAM_STR);

		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}
		$stmt->close();
		$stmt = null;
	}


	/*=============================================
	EDITAR VENTA
	=============================================*/
	static public function mdlEditarVenta($tabla, $datos){
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET id_cliente = :id_cliente, info_edicion = :info_edicion, prods_edit_orig = :prods_edit_orig,  estado = :estado, vista_vendedor = :vista_vendedor, nom_client = :nom_client, productos = :productos, impuesto = :impuesto, neto = :neto, total= :total, descuentos= :descuentos, detalle_venta= :detalle_venta, detalle_flete= :detalle_flete, utilidad_neta= :utilidad_neta, utilidad_total= :utilidad_total, tipo_pago = :tipo_pago, metodo_pago = :metodo_pago, fecha = :fecha, monto_extraible = :monto_extraible WHERE id = :id");
		
		$stmt->bindParam(":id", $datos["id"], PDO::PARAM_INT);
		$stmt->bindParam(":estado", $datos["estado"], PDO::PARAM_INT);
		$stmt->bindParam(":vista_vendedor", $datos["vista_vendedor"], PDO::PARAM_INT);		
		$stmt->bindParam(":id_cliente", $datos["id_cliente"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_client", $datos["nom_client"], PDO::PARAM_STR);
		$stmt->bindParam(":prods_edit_orig", $datos["prods_edit_orig"], PDO::PARAM_STR);
		$stmt->bindParam(":info_edicion", $datos["info_edicion"], PDO::PARAM_STR);
		$stmt->bindParam(":productos", $datos["productos"], PDO::PARAM_STR);
		$stmt->bindParam(":impuesto", $datos["impuesto"], PDO::PARAM_STR);
		$stmt->bindParam(":neto", $datos["neto"], PDO::PARAM_STR);
		$stmt->bindParam(":total", $datos["total"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha", $datos["fecha"], PDO::PARAM_STR);
		$stmt->bindParam(":monto_extraible", $datos["monto_extraible"], PDO::PARAM_INT);
		$stmt->bindParam(":descuentos", $datos["descuentos"], PDO::PARAM_STR);
		$stmt->bindParam(":detalle_venta", $datos["detalle_venta"], PDO::PARAM_STR);		
		$stmt->bindParam(":detalle_flete", $datos["detalle_flete"], PDO::PARAM_STR);		
		$stmt->bindParam(":utilidad_neta", $datos["utilidad_neta"], PDO::PARAM_STR);		
		$stmt->bindParam(":utilidad_total", $datos["utilidad_total"], PDO::PARAM_STR);		
		$stmt->bindParam(":tipo_pago", $datos["tipo_pago"], PDO::PARAM_STR);
		$stmt->bindParam(":metodo_pago", $datos["metodo_pago"], PDO::PARAM_STR);


		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}
		$stmt->close();
		$stmt = null;
	}

	/*=============================================
	ELIMINAR VENTA
	=============================================*/
	static public function mdlEliminarVenta($tabla, $datos){
		
		$fechaHora = ControladorAjustes::ctrFechaHora();
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET estado = 0, fecha = '$fechaHora' WHERE id = :id");
		$stmt -> bindParam(":id", $datos, PDO::PARAM_INT);
		if($stmt -> execute()){
			return "ok";
		}else{
			return "error";	
		}
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	RANGO FECHAS
	=============================================*/	
	static public function mdlRangoFechasVentas($tabla, $fechaInicial, $fechaFinal, $rol, $idUsuario){
		if($rol == 'Administrador'){
			if($fechaInicial == null){
				$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY id ASC");
				$stmt -> execute();
				return $stmt -> fetchAll();	
			}else if($fechaInicial == $fechaFinal){
				$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado != 0 AND fecha_cont BETWEEN '$fechaInicial' AND '$fechaFinal'");
				$stmt -> execute();
				return $stmt -> fetchAll();
			}else{
				$fechaActual = new DateTime();
				$fechaActual ->add(new DateInterval("P1D"));
				$fechaActualMasUno = $fechaActual->format("Y-m-d");
				$fechaFinal2 = new DateTime($fechaFinal);
				$fechaFinal2 ->add(new DateInterval("P1D"));
				$fechaFinalMasUno = $fechaFinal2->format("Y-m-d");
				if($fechaFinalMasUno == $fechaActualMasUno){
					$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado != 0 AND fecha_cont BETWEEN '$fechaInicial' AND '$fechaFinalMasUno'");
				}else{
					$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado != 0 AND fecha_cont BETWEEN '$fechaInicial' AND '$fechaFinal'");
				}
				$stmt -> execute();
				return $stmt -> fetchAll();
			}
		}else if($rol == 'Vendedor'){
			if($fechaInicial == null){
				$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado != 0 AND id_vendedor = $idUsuario ORDER BY id ASC");
				$stmt -> execute();
				return $stmt -> fetchAll();	
			}else if($fechaInicial == $fechaFinal){
				$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado != 0 AND fecha_venta like '%$fechaFinal%' AND id_vendedor = $idUsuario");
				$stmt -> bindParam(":fecha_venta", $fechaFinal, PDO::PARAM_STR);
				$stmt -> execute();
				return $stmt -> fetchAll();
			}else{
				$fechaActual = new DateTime();
				$fechaActual ->add(new DateInterval("P1D"));
				$fechaActualMasUno = $fechaActual->format("Y-m-d");
				$fechaFinal2 = new DateTime($fechaFinal);
				$fechaFinal2 ->add(new DateInterval("P1D"));
				$fechaFinalMasUno = $fechaFinal2->format("Y-m-d");
				if($fechaFinalMasUno == $fechaActualMasUno){
					$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado != 0 AND fecha_venta BETWEEN '$fechaInicial' AND '$fechaFinalMasUno' AND id_vendedor = $idUsuario");
				}else{
					$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado != 0 AND fecha_venta BETWEEN '$fechaInicial' AND '$fechaFinal' AND id_vendedor = $idUsuario");
				}
				$stmt -> execute();
				return $stmt -> fetchAll();
			}

		}
	}

	/*=============================================
	SUMAR EL TOTAL DE VENTAS
	=============================================*/
	static public function mdlSumaTotalVentas($tabla){	
		$stmt = Conexion::conectar()->prepare("SELECT SUM(total) as total FROM $tabla WHERE estado != 0");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	SUMAR EL TOTAL DE VENTAS DIA
	=============================================*/
	static public function mdlSumaTotalVentasDia1($tabla, $item, $valor){
		date_default_timezone_set("America/Santiago");
		$stmt = Conexion::conectar()->prepare("SELECT SUM(total) as total FROM $tabla WHERE estado != 0 AND $item = :$item");
		$stmt->bindParam(":$item", $valor, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}


	static public function mdlSumaTotalVentasDia2($tabla, $item1, $valor1, $item2, $valor2){
		date_default_timezone_set("America/Santiago");
		$stmt = Conexion::conectar()->prepare("SELECT SUM(total) as total FROM $tabla WHERE estado != 0 AND $item1 = :$item1 and $item2 like '%$valor2%'");
		$stmt->bindParam(":$item1", $valor1, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlVentasE_TD2($tabla, $item1, $valor1, $item2, $valor2){
		date_default_timezone_set("America/Santiago");
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado != 0 AND $item1 = :$item1 and $item2 like '%$valor2%'");
		$stmt->bindParam(":$item1", $valor1, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	SUMAR EL TOTAL DE VENTAS MES
	=============================================*/
	static public function mdlSumaTotalVentasMes($tabla, $rol, $idUsuario){
		date_default_timezone_set("America/Santiago");
		$fechaFinal = date("Y-m");	
		if($rol == 'Vendedor'){
			$stmt = Conexion::conectar()->prepare("SELECT SUM(total) as total FROM $tabla WHERE estado != 0 AND fecha_cont like '%$fechaFinal%' AND id_vendedor = $idUsuario");
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT SUM(total) as total FROM $tabla WHERE estado != 0 AND fecha_cont like '%$fechaFinal%'");
		}
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;			

	}

	/*=============================================
	SUMAR EL TOTAL DE VENTAS MES ANTERIOR
	=============================================*/
	static public function mdlSumaTotalVentasMesAnt($tabla, $rol, $idUsuario){
		date_default_timezone_set("America/Santiago");
		$fechaFinal = date("Y-m", strtotime("-1 month"));	
		if($rol == 'Administrador'){
			$stmt = Conexion::conectar()->prepare("SELECT SUM(total) as total FROM $tabla WHERE estado != 0 AND fecha_cont like '%$fechaFinal%'");
		}else if($rol == 'Vendedor'){
			$stmt = Conexion::conectar()->prepare("SELECT SUM(total) as total FROM $tabla WHERE estado != 0 AND fecha_cont like '%$fechaFinal%' AND id_vendedor = $idUsuario");
		}
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;			

	}	

	/*=============================================
	SUMAR EL TOTAL UTILIDAD
	=============================================*/
	static public function mdlSumaTotalUtilidades($tabla){	
		$stmt = Conexion::conectar()->prepare("SELECT SUM(utilidad_total) as total FROM $tabla WHERE estado != 0");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	SUMAR EL TOTAL UTILIDAD
	=============================================*/
	static public function mdlSumaTotalUtilidadesMes($tabla){
		$fechaFinal = date("Y-m");	
		$stmt = Conexion::conectar()->prepare("SELECT SUM(utilidad_total) as total FROM $tabla WHERE estado != 0 AND fecha_cont like '%$fechaFinal%'");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}

    static public function mdlActualizarItem1($tabla, $item1, $valor1, $valor){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE id = :id");
        $stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
        $stmt -> bindParam(":id", $valor, PDO::PARAM_STR);
        if($stmt -> execute()){
            return "ok";
        }else{
            return "error"; 
        }
        $stmt -> close();
        $stmt = null;
    }	

    static public function mdlActualizar1($tabla, $item1, $valor1, $valor){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = '$valor1' WHERE id = $valor");
        if($stmt -> execute()){
            return "ok";
        }else{
            return "error"; 
        }
        $stmt -> close();
        $stmt = null;
    }

    static public function mdlActualizarItem2($tabla, $item1, $valor1, $item2, $valor2, $valor){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = '$valor1', $item2 = '$valor2' WHERE id = $valor");
        // $stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
        // $stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
        // $stmt -> bindParam(":id", $valor, PDO::PARAM_STR);
        if($stmt -> execute()){
            return "ok";
        }else{
            return "error"; 
        }
        $stmt -> close();
        $stmt = null;
    }	    

	/*=============================================
	ACTUALIZAR 2
	=============================================*/
	static public function mdlActualizar2($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1, $item2 = :$item2 WHERE $item3 = :$item3");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item3, $valor3, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok,".$valor1.",".$valor2.",".$valor3;
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}
	/*==============================================
	SELECCIONAR ULTIMO CORRELATIVO DE VENTAS DEL DIA
	==============================================*/
	static public function mdlUltimaVentaDia($fechaCont){
		$stmt = Conexion::conectar()->prepare("SELECT MAX(RIGHT(cod_venta,3)) as ultimo FROM ventas WHERE fecha_cont = '$fechaCont'");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}



// 
}