<?php

require_once "conexion.php";

class ModeloMovimientosBancarios{

	/*=============================================
	REGISTRAR MOVIMIENTO BANCARIO
	=============================================*/
	static public function mdlRegistrarMovBancario($tabla, $datos){

		$sucursal = $_SESSION['sucursal'];
		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(fecha, tipo_mov, user, sucursal, cargo, abono, saldo) VALUES (:fecha, :tipo_mov, :user, :sucursal, :cargo, :abono, :saldo)");
		
		$stmt->bindParam(":fecha", $datos["fecha"], PDO::PARAM_STR);
		$stmt->bindParam(":tipo_mov", $datos["tipo_mov"], PDO::PARAM_STR);
		$stmt->bindParam(":user", $datos["user"], PDO::PARAM_INT);
		$stmt->bindParam(":sucursal", $datos["sucursal"], PDO::PARAM_STR);
		$stmt->bindParam(":cargo", $datos["cargo"], PDO::PARAM_INT);
		$stmt->bindParam(":abono", $datos["abono"], PDO::PARAM_INT);
		$stmt->bindParam(":saldo", $datos["saldo"], PDO::PARAM_INT);
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}
		$stmt->close();
		$stmt = null;
	}

	/*=============================================
	REGISTRAR VALOR UF
	=============================================*/
	static public function mdlRegistrarUF($valor){
		date_default_timezone_set("America/Santiago");
	    $fecha =  date('Y-m-d', strtotime('+1 day'));
		$stmt = Conexion::conectar()->prepare("INSERT INTO uf_observada(fecha, valor) VALUES ('$fecha', $valor)");
		if($stmt->execute()){
			return "ok";	
		}else{
			return "error";
		}
		$stmt->close();
		$stmt = null;
	}

	static public function mdlRegistrarUFAnterior($fecha, $valor){
		date_default_timezone_set("America/Santiago");
		$stmt = Conexion::conectar()->prepare("INSERT INTO uf_observada(fecha, valor) VALUES ('$fecha', $valor)");
		if($stmt->execute()){
			return "ok";	
		}else{
			return "error";
		}
		$stmt->close();
		$stmt = null;
	}


	/*=============================================
	EXTRAER VALOR UF
	=============================================*/
	static public function mdlValorUF($fecha){
		$stmt = Conexion::conectar()->prepare("SELECT valor as valor FROM uf_observada WHERE fecha = '$fecha'");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt->close();
		$stmt = null;
	}

	/*=========================
	MOSTRAR COMPROMISOS DE PAGO
	=========================*/
	static public function mdlMostrarCompromisosPago($tabla, $item, $valor){
		date_default_timezone_set("America/Santiago");
	    $fecha =  date('Y-m-d', strtotime('-1 month'));
	    $fechaPosterior =  date('Y-m-d', strtotime('+2 month')); 

		if($item == null){ // TODOS
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY fecha_vencimiento ASC"); // TODOS 
			$stmt -> execute();
			return $stmt -> fetchAll();
		}else if($item == 'fecha_vencimiento'){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE (estado = 0 AND fecha_vencimiento < '$fechaPosterior') || (fecha_vencimiento > '$fecha' AND estado = 1) ORDER BY fecha_vencimiento ASC"); // FECHA_VENCIMIENTO > (1 MES ATRAS) QUE ESTEN SALDADAS Y TODAS LAS QUE NO ESTAN PAGADAS HASTA 2 MESES ADELANTE
			$stmt -> execute();
			return $stmt -> fetchAll();
		}else{ // UNICO
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");
			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
			$stmt -> execute();
			return $stmt -> fetch();
		}
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlMostrarCompromisosPagoRango($tabla, $fecha1, $fecha2){
		// $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE fecha_vencimiento >= '$fecha1' AND fecha_vencimiento <= '$fecha2' OR (estado = 0 AND fecha_vencimiento < '$fecha2') OR (fecha_vencimiento > '$fecha1' AND estado = 1) ORDER BY fecha_vencimiento ASC");
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE fecha_vencimiento >= '$fecha1' AND fecha_vencimiento <= '$fecha2' ORDER BY fecha_vencimiento ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlSumarCompromisosPagoRango($tabla, $fecha1, $fecha2){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE fecha_vencimiento >= '$fecha1' AND fecha_vencimiento <= '$fecha2' UNION SELECT * FROM $tabla WHERE (estado = 0 AND fecha_vencimiento < '$fecha2') || (fecha_vencimiento > '$fecha1' AND estado = 1) ORDER BY fecha_vencimiento ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}


	/*===================================
	MOSTRAR COMPROMISOS DE PAGO ATRASADOS
	===================================*/
	static public function mdlMostrarCompromisosPagoAtrasadosDashboard($tabla, $item){
		date_default_timezone_set("America/Santiago");
	    $fecha =  date('Y-m', strtotime('+1 month'));
	    $fechaCorte = $fecha.'-01';
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = 0 AND fecha_vencimiento < '$fechaCorte' ORDER BY $item ASC"); // IMPAGAS Y ATRASADAS 
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}


	/*===================================
	MOSTRAR COMPROMISOS PAGADOS MES
	===================================*/
	static public function mdlMostrarCompromisosPagadosMes($tabla){
		date_default_timezone_set("America/Santiago");
	    $fechaCorte =  date('Y-m');
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = 1 AND fecha_pago LIKE '%$fechaCorte%'"); // IMPAGAS Y ATRASADAS 
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}


	/*==========================================
	MOSTRAR COMPROMISOS DE PAGO EN INFORME EMAIL
	==========================================*/
	static public function mdlMostrarCompromisosPagoEmail(){
		date_default_timezone_set("America/Santiago");
	    $fecha =  date('Y-m-d', strtotime('+1 week')); 
		$stmt = Conexion::conectar()->prepare("SELECT * FROM compromisos_pago WHERE fecha_vencimiento <= '$fecha' AND estado = 0 ORDER BY fecha_vencimiento ASC"); // FECHA_VENCIMIENTO <= (1 SEMANA) QUE NO ESTEN SALDADAS Y TODAS LAS QUE NO SE HAN PAGADO ANTES 
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	REGISTRO DE COMPROMISO DE PAGO
	=============================================*/
	static public function mdlRegistrarCompromisoPago($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(deudor, fecha_vencimiento, tipo_compromiso, se_paga_desde, descripcion, acreedor, monto, nro_cuota) VALUES (:deudor, :fecha_vencimiento, :tipo_compromiso, :se_paga_desde, :descripcion, :acreedor, :monto, :nro_cuota)");
		$stmt->bindParam(":deudor", $datos["deudor"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_vencimiento", $datos["fecha_vencimiento"], PDO::PARAM_STR);
		$stmt->bindParam(":tipo_compromiso", $datos["tipo_compromiso"], PDO::PARAM_STR);
		$stmt->bindParam(":se_paga_desde", $datos["se_paga_desde"], PDO::PARAM_STR);
		$stmt->bindParam(":descripcion", $datos["descripcion"], PDO::PARAM_STR);
		$stmt->bindParam(":acreedor", $datos["acreedor"], PDO::PARAM_STR);
		$stmt->bindParam(":monto", $datos["monto"], PDO::PARAM_INT);
		$stmt->bindParam(":nro_cuota", $datos["nro_cuota"], PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok";	
		}else{
			return "error";
		}
		$stmt->close();
		$stmt = null;
	}

	static public function mdlRegistrarCredito($tabla, $datos){
		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(deudor, fecha_vencimiento, tipo_compromiso, nro_credito, banco, se_paga_desde, descripcion, acreedor, monto, nro_cuota) VALUES (:deudor, :fecha_vencimiento, :tipo_compromiso, :nro_credito, :banco, :se_paga_desde, :descripcion, :acreedor, :monto, :nro_cuota)");
		$stmt->bindParam(":deudor", $datos["deudor"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_vencimiento", $datos["fecha_vencimiento"], PDO::PARAM_STR);
		$stmt->bindParam(":tipo_compromiso", $datos["tipo_compromiso"], PDO::PARAM_STR);
		$stmt->bindParam(":nro_credito", $datos["nro_credito"], PDO::PARAM_STR);
		$stmt->bindParam(":banco", $datos["banco"], PDO::PARAM_STR);
		$stmt->bindParam(":se_paga_desde", $datos["se_paga_desde"], PDO::PARAM_STR);
		$stmt->bindParam(":descripcion", $datos["descripcion"], PDO::PARAM_STR);
		$stmt->bindParam(":acreedor", $datos["acreedor"], PDO::PARAM_STR);
		$stmt->bindParam(":monto", $datos["monto"], PDO::PARAM_INT);
		$stmt->bindParam(":nro_cuota", $datos["nro_cuota"], PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok";	
		}else{
			return "error";
		}
		$stmt->close();
		$stmt = null;
	}


	/*=============================================
	ELIMINAR COMPROMISO DE PAGO
	=============================================*/
	static public function mdlEliminarCompromisosPago($tabla, $datos){
		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE id = :id");
		$stmt -> bindParam(":id", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){
			return "ok";
		}else{
			return "error";	
		}
		$stmt -> close();
		$stmt = null;
	}


	/*=============================================
	REGISTRAR PAGO COMPROMISO
	=============================================*/
	static public function mdlRegistrarPago($tabla, $datos){
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET estado = :estado, fecha_pago = :fecha_pago, monto_pagado = :monto_pagado, interes_pagado = :interes_pagado , moneda_pago = :moneda_pago, abonos = :abonos   WHERE id = :id");
		$stmt -> bindParam(":estado", $datos["estado"], PDO::PARAM_INT);
		$stmt -> bindParam(":fecha_pago", $datos["fecha_pago"], PDO::PARAM_STR);
		$stmt -> bindParam(":abonos", $datos["abonos"], PDO::PARAM_STR);
		$stmt -> bindParam(":monto_pagado", $datos["monto_pagado"], PDO::PARAM_INT);
		$stmt -> bindParam(":interes_pagado", $datos["interes_pagado"], PDO::PARAM_INT);
		$stmt -> bindParam(":moneda_pago", $datos["moneda_pago"], PDO::PARAM_STR);
		$stmt -> bindParam(":id", $datos["id"], PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}


	/*=============================================
	APLICAR NOTA CREDITO
	=============================================*/
	static public function mdlModificar1($tabla, $item, $valor, $id){
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item = '$valor' WHERE id = $id");
		if($stmt -> execute()){
			return "ok";
		}else{
			return "error";	
		}
		$stmt -> close();
		$stmt = null;
	}


	/*=============================================
	REVOCAR PAGO
	=============================================*/

	static public function mdlRevocarPago($id) {
	    try {
	        $conexion = Conexion::conectar();
	        $stmt = $conexion->prepare("UPDATE compromisos_pago 
	            SET estado = 0, 
	                fecha_pago = '1900-01-01', 
	                monto_pagado = 0, 
	                interes_pagado = 0, 
	                moneda_pago = '',
	                abonos = '' 
	            WHERE id = :id");

	        // Bind de parámetros para evitar inyección SQL
	        $stmt->bindParam(":id", $id, PDO::PARAM_INT);

	        if ($stmt->execute()) {
	            return "ok";
	        } else {
	            return "error";
	        }
	    } catch (PDOException $e) {
	        return "Error: " . $e->getMessage(); // Devuelve el error para depuración
	    } finally {
	        $stmt = null; // Libera la memoria
	        $conexion = null; // Cierra la conexión
	    }
	}


	/*=============================================
	ULTIMO ITEM
	=============================================*/
	static public function mdlUltimoMov(){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM movimientos_bancarios ORDER by id DESC LIMIT 1");
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}
	
}