<?php

require_once "conexion.php";

class ModeloCotizaciones{

	/*=============================================
	MOSTRAR COTIZACIONES
	=============================================*/
	static public function mdlMostrarCotizacionesIntervalo($tabla, $item, $fechaInicial, $fechaFinal){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item >= '$fechaInicial' AND $item <= '$fechaFinal' ORDER BY id DESC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}


	static public function mdlMostrarCotizaciones($tabla, $item, $valor){
		if($item != null){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY id DESC");
			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
			$stmt -> execute();
			return $stmt -> fetch();
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY id DESC");
			$stmt -> execute();
			return $stmt -> fetchAll();
		}
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlMostrarCotizacionesOrdenado($tabla, $item, $valor){
		if($item != null){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY id ASC");
			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
			$stmt -> execute();
			return $stmt -> fetch();
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY id ASC");
			$stmt -> execute();
			return $stmt -> fetchAll();
		}
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlMostrarCotizacionesMes($tabla){
		date_default_timezone_set("America/Santiago");
		$fecha = date('Y-m');
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE fecha_ingreso LIKE '%$fecha%'");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}		

	static public function mdlMostrarCotizacionesMesVendedor(){
		date_default_timezone_set("America/Santiago");
		$fecha = date('Y-m');
		$idVendedor = $_SESSION['id'];
		$stmt = Conexion::conectar()->prepare("SELECT * FROM cotizaciones WHERE id_vendedor = $idVendedor AND fecha_ingreso LIKE '%$fecha%'");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}		

	/*=============================================
	INGRESO DE COTIZACIONES
	=============================================*/

	static public function mdlIngresarCotizacion($tabla, $datos){

		$fechaHora = ControladorAjustes::ctrFechaHora();
		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(id_client, nom_client, id_vendedor, nom_vend, productos, neto, iva, total, utilidad, fecha_ingreso, fecha_expiracion, fecha) VALUES (:id_client, :nom_client, :id_vendedor, :nom_vend, :productos, :neto, :iva, :total, :utilidad, :fecha_ingreso, :fecha_expiracion, '$fechaHora')");
		$stmt->bindParam(":id_client", $datos["id_client"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_client", $datos["nom_client"], PDO::PARAM_STR);
		$stmt->bindParam(":id_vendedor", $datos["id_vendedor"], PDO::PARAM_INT);
		$stmt->bindParam(":nom_vend", $datos["nom_vend"], PDO::PARAM_STR);
		$stmt->bindParam(":productos", $datos["productos"], PDO::PARAM_STR);
		$stmt->bindParam(":iva", $datos["iva"], PDO::PARAM_INT);
		$stmt->bindParam(":neto", $datos["neto"], PDO::PARAM_INT);
		$stmt->bindParam(":total", $datos["total"], PDO::PARAM_INT);
		$stmt->bindParam(":utilidad", $datos["utilidad"], PDO::PARAM_INT);
		$stmt->bindParam(":fecha_ingreso", $datos["fecha_ingreso"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_expiracion", $datos["fecha_expiracion"], PDO::PARAM_STR);		
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}
		$stmt->close();
		$stmt = null;
	}

	/*=============================================
	ACTUALIZAR COTIZACION
	=============================================*/

	static public function mdlActualizarCot($tabla, $item1, $valor1, $id){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1, fecha = '$valor1' WHERE id = :id");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":id", $id, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}
	
}