<?php

require_once "conexion.php";

class ModeloCategorias{


	/*=============================================
	MOSTRAR CATEGORIAS
	=============================================*/
	static public function mdlMostrarCategorias1($tabla, $item, $valor){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");
		$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();		
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	MOSTRAR CATEGORIAS
	=============================================*/
	static public function mdlMostrarCategorias($tabla, $item, $valor){
		if($item != null){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");
			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
			$stmt -> execute();
			if ($item=="id"){
				return $stmt -> fetch();
			}else{
				return $stmt -> fetchAll();
			}
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla  ORDER BY categoria ASC");
			$stmt -> execute();
			return $stmt -> fetchAll();
		}
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR CATEGORIAS
	=============================================*/
	static public function mdlMostrarCategoriasOrdenado($tabla, $item, $valor){
		
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla  ORDER BY id_categoria ASC");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;

	}	


	

	/*=============================================
	MOSTRAR CATEGORIAS
	=============================================*/
	static public function mdlMostrarSubcategorias1($tabla, $item, $valor){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");
		$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
		$stmt -> execute();
		if ($item=="id"){
			return $stmt -> fetch();
		}else{
			return $stmt -> fetchAll();
		}
		$stmt -> close();
		$stmt = null;
	}


	/*=============================================
	MOSTRAR SUBCATEGORIAS
	=============================================*/	
	static public function mdlMostrarSubcategorias($tabla, $item, $valor){

		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY categoria_padre ASC, subcategoria ASC");

		$stmt -> execute();

		return $stmt -> fetchAll();		

		$stmt -> close();

		$stmt = null;

	}


	/*=============================================
	MOSTRAR SUBCATEGORIAS
	=============================================*/	
	static public function mdlSubcatsCoincidir($tabla, $itemCoincidencia, $valor){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $itemCoincidencia = $valor");
		$stmt -> execute();
		return $stmt -> fetchAll();				
		$stmt -> close();		
		$stmt = null;	
	}


	/*=============================================
	SELECCIONAR ULTIMO_ID
	=============================================*/
	static public function mdlSeleccionarUltimoId($tabla, $item1, $item, $catPadre){

		if($tabla=="subcategorias"){

			$stmt = Conexion::conectar()->prepare("SELECT MAX($item) as numero FROM $tabla WHERE $item1 = $catPadre");

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT MAX($item) as numero FROM $tabla");
			
		}

		$stmt -> execute();

		return $stmt -> fetch();

		$stmt -> close();

		$stmt = null;
	}

	

	// /*=============================================
	// SELECCIONAR CATEGORIA
	// =============================================*/
	static public function mdlSeleccionarItem($tabla, $item1, $item_coincidencia, $datos){ 

		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item_coincidencia = $datos" );

		$stmt -> execute();

		return $stmt -> fetch();

		$stmt -> close();

		$stmt = null;
	}


	// /*=============================================
	// SELECCIONAR SUBCATEGORIA DE TABLA SUBCATEGORIAS
	// =============================================*/
	static public function mdlSeleccionarSubcategoria($tablaSubCat, $item_busqueda, $item_1, $valor_1, $item_2, $valor_2){ 

		$stmt = Conexion::conectar()->prepare("SELECT $item_busqueda as item FROM $tablaSubCat WHERE $item_1 = $valor_1 AND $item_2 = $valor_2");

		$stmt -> execute();

		return $stmt -> fetch();

		$stmt -> close();

		$stmt = null;
	}

	static public function mdlSeleccionarSubcategoria1($tablaSubCat, $item_1, $valor_1, $item_2, $valor_2){ 

		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tablaSubCat WHERE $item_1 = $valor_1 AND $item_2 = $valor_2");

		$stmt -> execute();

		return $stmt -> fetch();

		$stmt -> close();

		$stmt = null;
	}



	/*=============================================
	TRASPASAR DATO ultimo_id SUBCATEGORIA A todos los categoria_id de la tabla y así guardar ése nro como el último registro para su posterior uso correlativo de la numeración de categorias 
	=============================================*/

	static public function mdlUltimoId($tabla, $datos, $nro_correlativo, $catPadre){


		if($tabla=="categorias"){

			$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET ultimo_id = :ultimo_id");
			$stmt -> bindParam(":ultimo_id", $nro_correlativo, PDO::PARAM_STR);

		}else{

			$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET ultimo_id = :ultimo_id WHERE categoria_padre = $catPadre");
			$stmt -> bindParam(":ultimo_id", $nro_correlativo, PDO::PARAM_STR);

		}

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt->close();
		$stmt = null;

	}


	/*=============================================
	CREAR CATEGORIA
	=============================================*/

	static public function mdlIngresarCategoria($tabla, $datos, $nro_correlativo){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(categoria, id_categoria, ultimo_id) VALUES (:categoria, :id_categoria, :ultimo_id)");

		$stmt->bindParam(":categoria", $datos, PDO::PARAM_STR);
		// $stmt->bindParam(":categoria_id", $categoria_id, PDO::PARAM_STR);
		$stmt->bindParam(":id_categoria", $nro_correlativo, PDO::PARAM_STR);
		$stmt->bindParam(":ultimo_id", $nro_correlativo, PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt->close();
		$stmt = null;

	}


	/*=============================================
	CREAR SUBCATEGORIA
	=============================================*/

	static public function mdlIngresarSubcategoria($tabla, $datos, $catPadre, $nro_correlativo){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(subcategoria, categoria_padre, id_subcategoria, ultimo_id) VALUES (:subcategoria, :categoria_padre, :id_subcategoria, :ultimo_id)");

		$stmt->bindParam(":subcategoria", $datos, PDO::PARAM_STR);
		$stmt->bindParam(":categoria_padre", $catPadre, PDO::PARAM_STR);
		$stmt->bindParam(":id_subcategoria", $nro_correlativo, PDO::PARAM_STR);
		$stmt->bindParam(":ultimo_id", $nro_correlativo, PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt->close();
		$stmt = null;

	}

	/*=============================================
	EDITAR CATEGORIA
	=============================================*/

	static public function mdlEditarCategoria($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET categoria = :categoria WHERE id = :id");

		$stmt -> bindParam(":categoria", $datos["categoria"], PDO::PARAM_STR);
		$stmt -> bindParam(":id", $datos["id"], PDO::PARAM_INT);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt->close();
		$stmt = null;

	}

	/*=============================================
	EDITAR SUBCATEGORIA
	=============================================*/

	static public function mdlEditarSubcategoria($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET subcategoria = :subcategoria WHERE id = :id");

		$stmt -> bindParam(":subcategoria", $datos["subcategoria"], PDO::PARAM_STR);
		$stmt -> bindParam(":id", $datos["id"], PDO::PARAM_INT);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt->close();
		$stmt = null;

	}

	/*=============================================
	BORRAR CATEGORIA
	=============================================*/

	static public function mdlBorrarCategoria($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE id = :id");

		$stmt -> bindParam(":id", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	BORRAR CATEGORIA
	=============================================*/

	static public function mdlBorrarSubcategoria($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE id = :id");

		$stmt -> bindParam(":id", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}


}

