<?php
session_start();
require_once "../../../modelos/productos.modelo.php";
require_once "../../../modelos/compras.modelo.php";
require_once "../../../controladores/ajustes.controlador.php";
require_once "../../../modelos/ajustes.modelo.php";
$sucursal = $_SESSION['sucursal'];
$nombreComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_comercial')['ajuste']);
$nombreReal = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_real')['ajuste']);
$rutComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_comercial')['ajuste']);
$direccionComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'direccion_comercial')['ajuste']);
$wsp = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_ventas')['ajuste'];
$fono = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'];
$correo = strtolower(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_compras')['ajuste']);
$giro = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'giro_comercial')['ajuste']);

$abastecimiento =  json_decode($_GET["prods"],true);


require_once('tcpdf_include.php');
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf-> setPrintHeader(false);
$pdf->startPageGroup();
$pdf->AddPage();
/*--------------------------------------------------------------------------------------------*/
$titulo = 'SOLICITUD COTIZACIÓN';

$html0 = 

	'<table>	
		<tr>
			<td style="width:540px; text-align:center; font-size:13px;">
				<h4>'.$titulo.'</h4>
			</td>
		</tr>
		<tr>
			<td style="width:540px; text-align:left; font-size:0px; padding:0px 2px;">
			</td>
		</tr>
	</table>';
$pdf->writeHTML($html0, false, false, false, false, '');

// CABECERAS
$html2 = '
	<br><br>
	<table style="font-size:10px; padding:1px 2px;border-bottom: 1px solid #333; height:25px;">
		<tr>
			<td style="background-color:white; width:30px; text-align:center; line-height:25px"><b>#</b></td>		
			<td style="background-color:white; width:60px; text-align:center; line-height:25px"><b>CODIGO</b></td>
			<td style="background-color:white; width:40px; text-align:center; line-height:25px"><b>CANT</b></td>
			<td style="background-color:white; width:230px; text-align:left; line-height:25px"><b>PRODUCTO</b></td>
			<td style="background-color:white; width:60px; text-align:center"><b>PRECIO NETO</b></td>
			<td style="background-color:white; width:60px; text-align:center"><b>PRECIO c/IVA</b></td>
			<td style="background-color:white; width:60px; text-align:center"><b>TOTAL c/IVA</b></td>
		</tr>
	</table>';
$pdf->writeHTML($html2, false, false, false, false, '');



$html3 = '<table style="font-size:8px; padding:1px 2px;">';

// $totalFinal = 0;
$totalFinalNeto = 0;
$prov = $_GET['prov'];

// $textoWsp = '';
foreach ($abastecimiento as $key => $value) {
	if($value['cant'] > 0){	
		$idProd = $value['id']; 
		$infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);

		// BUSCA SKU PROVEEDOR
		$arrayProvs = json_decode($infoProd['lista_provs_json'], true);
		$codProv = $prov == 0 ? '' : 'SINCOD';
		$precioNetoProveedor = 0;
		for ($i=0; $i < count($arrayProvs); $i++) { 
			if($arrayProvs[$i]['prov'] == $prov){
				$codProv = $arrayProvs[$i]['cod_prov']; // si es que se ha comprado al proveedor extrae sku_prov
				$precioNetoProveedor = $arrayProvs[$i]['pc_neto'];
			}
		}

		// busca ultimo precio de compra
	    $ultimaCompraProd = ModeloCompras::mdlUltimaCompraProd('compras', 'abastecimiento', '%"id":"'.$idProd.'"%');
		if(isset($ultimaCompraProd['abastecimiento'])){ // REVISA SI SE HA COMPRADO ANTES
	      	$datosCompra = json_decode($ultimaCompraProd['abastecimiento'], true);
	      	foreach ($datosCompra as $elemento) {
	        	if(isset($elemento['id']) && $elemento['id'] === "$idProd") {
	          		$precioCompraNetoUnit = $elemento['pCNetoActual']; // ultimo precio comprado indistinto del proveedor
	          		break; // Terminar el bucle una vez que se encuentra el elemento
	        	}
	      	}
	    }else{
			$precioCompraNetoUnit = $infoProd['pc_neto']; // precio neto seteado
	    }
	    $netoFinalUnit = $precioNetoProveedor <= $precioCompraNetoUnit && $precioNetoProveedor > 0 ? $precioNetoProveedor : $precioCompraNetoUnit; // elige el menor precio para enviar a proveedor
		$totalItem = $netoFinalUnit*$value['cant'];
	    $totalFinalNeto += $totalItem;

		$html3 .= '
			<tr>
				<td style="background-color:white; width:30px; text-align:center">'.($key+1).'</td>
				<td style="background-color:white; width:60px; text-align:center">'.$codProv.'</td>
				<td style="background-color:white; width:40px; text-align:center">'.$value['cant'].'</td>
				<td style="background-color:white; width:230px; text-align:left">'.strtoupper($infoProd['descripcion']).'</td>
				<td style="background-color:white; width:60px; text-align:center">'.number_format($netoFinalUnit,0,',','.').'</td>
				<td style="background-color:white; width:60px; text-align:center">'.number_format($netoFinalUnit*1.19,0,',','.').'</td>
				<td style="background-color:white; width:60px; text-align:center">'.number_format($totalItem*1.19,0,',','.').'</td>
			</tr>';
	}
}

$html3 .= 
	'<tr>
		<td style="background-color:white; width:30px; text-align:center"></td>
		<td style="background-color:white; width:60px; text-align:center"></td>
		<td style="background-color:white; width:40px; text-align:center"></td>
		<td style="background-color:white; width:230px; text-align:left"></td>
		<td style="background-color:white; width:60px; text-align:center"></td>
		<td style="background-color:white; width:60px; text-align:center"></td>
		<td style="background-color:white; width:60px; text-align:center; border-top: 1px solid #333;">'.number_format($totalFinalNeto*1.19,0,',','.').'</td>
	</tr>';
$html3 .= '</table>';
$pdf->writeHTML($html3, false, false, false, false, '');

$datosCotizar = 
	'<br><br><br>
	<table>
		<tr>
			<td style="width:340px; text-align:left; font-size:10px; padding:0px 2px;"></td>
			<td style="width:200px; text-align:left; font-size:10px; padding:0px 2px; color:blue">
				<b>COTIZAR A NOMBRE DE:</b>
			</td>
		</tr>
		<tr>
			<td style="width:340px; text-align:left; font-size:10px; padding:0px 2px;"></td>
			<td style="width:55px; text-align:left; font-size:8px; padding:0px 2px;">
				RUT <br>
				NOMBRE <br>
				DIRECCIÓN <br>
				GIRO <br>
				CONTACTO<br>
				CORREO
			</td>
			<td style="width:5px; text-align:left; font-size:8px; padding:0px 2px;">
				:<br>
				:<br>
				:<br>
				:<br>
				:<br>
				:<br>
			</td>
			<td style="width:140px; text-align:left; font-size:8px; padding:0px 2px;">
				<b>'.$rutComercio.'</b><br>
				<b>'.$nombreReal.'</b><br>
				<b>'.$direccionComercio.'</b> <br>
				<b>'.$giro.'</b><br>
				<b>'.$wsp.'</b><br>
				<b>'.$correo.'</b>
			</td>
		</tr>
	</table>';
$pdf->writeHTML($datosCotizar, false, false, false, false, '');


date_default_timezone_set("America/Santiago");
$pdf->Output($titulo.'.pdf');

?>