<?php
require_once "../../../controladores/clientes.controlador.php";
require_once "../../../modelos/clientes.modelo.php";

// $item = 'deuda_cliente';
$item = null;
$valor = 'deuda';
$clientes = ControladorClientes::ctrMostrarClientes($item, $valor);
$deudaTotal = number_format(ModeloClientes::mdlCuentasPorCobrar()['total'],0,',','.');
$deudores = count(ModeloClientes::mdlDeudores());
require_once('tcpdf_include.php');
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
// $pdf->SetFont('courier', '', 12);
$pdf-> setPrintHeader(false);
$pdf->setFooterData(array(0,64,0), array(0,64,128));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
$pdf->startPageGroup();
$pdf->AddPage();

/*=============================================
                 TITULO
=============================================*/
$bloque0 = <<<EOF
	<table>
		<tr>
			<td style="background-color:white; width:540px">	
				<div style="font-size:15px; text-align:center; line-height:15px;">
					CLIENTES MOROSOS ($$deudaTotal - $deudores DEUDORES) 
				</div>
			</td>
		</tr>
	</table>
	<br><br>
EOF;

$pdf->writeHTML($bloque0, false, false, false, false, '');

/*=============================================
                 CABECERA           
=============================================*/
$bloque1 = '
	
	<br>

	<table style="font-size:8px; padding:5px 2px;">

		<tr>

		<td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center"><b>#</b></td>		
		<td style="border: 0.5px solid #000000; background-color:white; width:215px; text-align:center"><b>NOMBRE</b></td>		
		<td style="border: 0.5px solid #000000; background-color:white; width:70px; text-align:center"><b>DEUDA</b></td>		
		<td style="border: 0.5px solid #000000; background-color:white; width:70px; text-align:center"><b>LIMITE</b></td>
		<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center"><b>FONO</b></td>
		<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center"><b>RESUMEN</b></td>

		</tr>

	</table>';

$pdf->writeHTML($bloque1, false, false, false, false, '');

//----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

$color = 'black';
foreach ($clientes as $i => $val){

	if($val['id']!=1 && ($val['deuda_cliente']>0)){
    	
    	// $nombre = '<b>'.mb_strtoupper($val['nombre'].' '.$val['apellido']).'</b> ('.mb_strtoupper($val['referencia']).')';
    	$nombre = '<b>'.mb_strtoupper($val['nombre'].' '.$val['apellido'].'</b> ('.$val['referencia']).') <b><i>ID:'.$val['id'].'</i></b>';
        $deuda = '<b>$ '.number_format($val['deuda_cliente'],0,',','.').'</b>';
        $limite = '$ '.number_format($val['limite'],0,',','.');
        $contactos = $val['telefono'].'<br> '.$val['email'];
        $i += 1;
        $deudores = $i;

        $resumenVentas = '<a href="137.184.183.8/pos/extensiones/tcpdf/pdf/resumen-moroso.php?id='.$val['id'].'">VER RESUMEN</a>';

	$bloque2 = '
		<br>

		<table style="font-size:8px; padding:5px 2px;">

			<tr>

			<td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center; $color">'.$i.'</td>	
			<td style="border: 0.5px solid #000000; background-color:white; width:215px; text-align:left; $color">'.$nombre.'</td>
			<td style="border: 0.5px solid #000000; background-color:white; width:70px; text-align:center; $color">'.$deuda.'</td>
			<td style="border: 0.5px solid #000000; background-color:white; width:70px; text-align:center; $color">'.$limite.'</td>
			<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; $color">'.$val["telefono"].'</td>
			<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; $color">'.$resumenVentas.'</td>

			</tr>

		</table>';

	$pdf->writeHTML($bloque2, false, false, false, false, '');

	}
}

$pdf->Output('LISTA DE CLIENTES SAMA.pdf');

?>