<?php

require_once "../../../modelos/compras.modelo.php";
require_once "../../../controladores/productos.controlador.php";
require_once "../../../modelos/productos.modelo.php";
require_once "../../../controladores/ajustes.controlador.php";
require_once "../../../modelos/ajustes.modelo.php";

class imprimirVenta{
	public function traerImpresionVenta(){

		$item = 'id';
		$valor = $_GET['codigo'];
		$orden = "fecha";
		$respuestaIntercambio = ModeloCompras::mdlMostrarCompra('intercambios', 'id', $valor);	

		//REQUERIMOS LA CLASE TCPDF
		require_once('tcpdf_include.php');
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf-> setPrintHeader(false);
		$pdf->startPageGroup();
		$pdf->AddPage();
		$logo = 'src="'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"';
		date_default_timezone_set("America/Santiago");
		$fecha = date("d-m-Y H:i:s");
		$sucursalProveedora = $respuestaIntercambio['nom_prov'];
		$sucursalAbastecida = $respuestaIntercambio['sucursal_abastecida'];
		// $titulo = 'INTERCAMBIO STOCK desde <b>'.strtoupper($respuestaIntercambio['nom_prov']).'</b> hacia <b>'.strtoupper($respuestaIntercambio['sucursal_abastecida']).'</b>     <span style="font-size:7px">'.$fecha.'</span>';
		$titulo = 'INTERCAMBIO STOCK desde <b>'.strtoupper($sucursalProveedora).'</b> hacia <b>'.strtoupper($sucursalAbastecida).'</b>';


		$bloque1 = '
			<table>
				<tr>
					<td style="width:50px"><img $logo></td>
					<td style="width:490px; text-align:center">
						'.$titulo.'
					</td>
				</tr>
			</table>';

		$pdf->writeHTML($bloque1, false, false, false, false, '');

		// ---------------------------------------------------------
		$sucProveedora = strtoupper($sucursalProveedora); 
		$sucReceptora = strtoupper($sucursalAbastecida);
		$bloque2 = '
			<table style="font-size:8px; padding:5px 10px;">
				<tr>
					<td style="border: 1px solid #333; background-color:white; width:30px; text-align:center;"><b>#</b></td>
					<td style="border: 1px solid #333; background-color:white; width:90px; text-align:left;"><b>SKU</b></td>
					<td style="border: 1px solid #333; background-color:white; width:195px; text-align:left;"><b>PRODUCTOS</b></td>
					<td style="border: 1px solid #333; background-color:white; width:75px; text-align:center;"><b>STK ACTUAL<br>'.$sucProveedora.'</b></td>
					<td style="border: 1px solid #333; background-color:white; width:75px; text-align:center;"><b>ABASTECIDO<br>'.$sucReceptora.'</b></td>
					<td style="border: 1px solid #333; background-color:white; width:75px; text-align:center;"><b>STK ACTUAL<br>'.$sucReceptora.'</b></td>
				</tr>
			</table>';

		$pdf->writeHTML($bloque2, false, false, false, false, '');

		// ---------------------------------------------------------

		$productos = json_decode($respuestaIntercambio['abastecimiento'], true);
		foreach(array_reverse($productos) as $key => $item) {
			$nro = $key+1;
			$idProducto = $item['id'];
			$respuestaProducto = ControladorProductos::ctrMostrarProductos('id', $idProducto, 'fecha');
			$sucursal = $respuestaIntercambio['sucursal_abastecida'];
			$abastecido =  number_format($item['cant'],0,',','.');
			$stockOrigen = number_format($respuestaProducto['stock_'.$sucursalProveedora],0,',','.');
			$stock = number_format($respuestaProducto['stock_'.$sucursal],0,',','.');
			$zona = $respuestaProducto['zona_'.$sucursalAbastecida] == '' ? 's/ZONA' : $respuestaProducto['zona_'.$sucursalAbastecida];
			$sku = $respuestaProducto["categoria"] <= 9 ? '0'.$respuestaProducto["sku"] : $respuestaProducto["sku"];

			$bloque3 = '

				<table style="font-size:8px; padding:5px 10px;">

					<tr>
						<td style="border: 1px solid #333; color:#333; background-color:white; width:30px; text-align:center;">'.$nro.'</td>
						<td style="border: 1px solid #333; color:#333; background-color:white; width:90px; text-align:left;"><b>'.$zona.'</b>-'.$sku.'</td>
						<td style="border: 1px solid #333; color:#333; background-color:white; width:195px; text-align:left;">'.$respuestaProducto['descripcion'].'</td>
						<td style="border: 1px solid #333; color:#333; background-color:white; width:75px; text-align:left;">'.$stockOrigen.'</td>
						<td style="border: 1px solid #333; color:#333; background-color:white; width:75px; text-align:left;">'.$abastecido.'</td>
						<td style="border: 1px solid #333; color:#333; background-color:white; width:75px; text-align:left;">'.$stock.'</td>
					</tr>

				</table>';

			$pdf->writeHTML($bloque3, false, false, false, false, '');
		}


		$pdf->Output('Intercambio Nro.'.$respuestaIntercambio["id"].'.pdf');

	}

}

$boletaCarta = new imprimirVenta();
// $boletaCarta -> codigo = $_GET["codigo"];
$boletaCarta -> traerImpresionVenta();

?>