<?php
session_start();
require_once "../../../controladores/movimientos.controlador.php";
require_once "../../../modelos/movimientos.modelo.php";
require_once "../../../modelos/actividad-inventario.modelo.php";
require_once "../../../controladores/productos.controlador.php";
require_once "../../../controladores/ajustes.controlador.php";
require_once "../../../modelos/productos.modelo.php";
require_once "../../../modelos/ajustes.modelo.php";

class historialCliente{

public $idCliente;

public function mostrarHistorial(){

//TRAEMOS LA INFORMACIÓN DE LA VENTA
// $item = 'id';
// $valor = $this->id;
// $cliente = ControladorClientes::ctrMostrarClientes($item, $valor);
// $apellidos = explode(" ", $cliente["apellido"]);
// $nombres = explode(" ", $cliente["nombre"]);
// $nombre = strtoupper($nombres[0].' '.$apellidos[0]);
// $orden = 'ASC';
// $movimientosCredito = ModeloMovimientos::mdlHistorialCredIntCliente($valor, $orden);
// date_default_timezone_set("America/Santiago");
require_once('tcpdf_include.php');
// $titulo = 'RESUMEN VENTAS CON CRÉDITO INTERNO ('.$nombre.')';


$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
// set default header data
// $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 045', PDF_HEADER_STRING);
// $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, $titulo, date('d/m/Y H:i:s', strtotime(date('Y-m-d H:i:s'))));

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// $pdf->setPrintHeader(true);
$pdf->setFooterData(array(0,64,0), array(0,64,128));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
// $pdf->SetFooterMargin(PDF_MARGIN_FOOTER); // HOJAS
$pdf->startPageGroup();
$pdf->AddPage();


// COMPROMISOS DE PAGO CERCANOS, SE ENVÍA SOLO LOS MIÉRCOLES
$diaSemana = getdate()['weekday'];
// $compromisosProxSemana = ModeloMovimientosBancarios::mdlMostrarCompromisosPagoEmail();
$tablaCompromisosProxSemana = ''; 
$sucursal = $_SESSION['sucursal'];


	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//----------------------------------------------------------------------------------------------------------------------------------------
	// INFORME DE PERDIDAS OPTIMIZADAS, CON TOTAL DE PERDIDA Y AVANCE EN CONTROL DE INVENTARIO
	//----------------------------------------------------------------------------------------------------------------------------------------
$prodsPerdidos = ModeloActividadInventario::mdlMostrarPerdidasStock(date('Y-m-d'));
$idsProdsPerdidos = [];

foreach ($prodsPerdidos as $key => $value) {
  	array_push($idsProdsPerdidos, $value['id_prod']); // agregamos todos los ids
}
$idsUnicosPerdidas = array_values(array_unique($idsProdsPerdidos)); // solo ids unicos

$cantidadPerdidas = [];
$idTrabajador = [];
$conteoPerdidas = 0;

foreach($idsUnicosPerdidas as $clave) { 
  	foreach ($prodsPerdidos as $key_1 => $value_1) {
      	if($value_1['id_prod'] == $clave){ // revisa si IDS son iguales
        	$conteoPerdidas += $value_1['actividad']; // suma para calcular pérdida
        	$precioCompraPRoducto = $value_1['id_trab'];
      	}
  	}
  	array_push($idTrabajador, $precioCompraPRoducto); // precio de compra de cada producto
  	array_push($cantidadPerdidas, $conteoPerdidas); // ingresa la suma de pérdida
  	$conteoPerdidas = 0; // vuelve a cero conteo para seguir con el siguiente prod
}
//----------------------------------------------------------------------------------------------------------------------------------------
// EJEMPLO RESPUESTA
// ARRAY_IDS      = [ 113,351,443,1187,2091]
// ARRAY_PERDIDAS     = [   3,-15, 10,  -4, 109]
// ARRAY_ID_TRABAJADOR  = [   2,  1,  2,   2,   2]
//----------------------------------------------------------------------------------------------------------------------------------------

$totalPerdidaProd = 0;
$totalPerdidaDia = 0;
	if(count($idsUnicosPerdidas)==0){
	$tablaProdsPerdidos = '';
	}else{
		$tablaProdsPerdidos = '<table><tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:70%"><b>DESCRIPCIÓN</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center"><b>CANT</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center"><b>$ UNIT</b></td><td style="border-bottom: 1px solid #666; background-color:white; width:10%; text-align:center"><b>TOTAL ($)</b></td>';

		for ($i=0; $i < count($idsUnicosPerdidas); $i++) { 

    	$datosProd = ControladorProductos::ctrMostrarProducto('id', $idsUnicosPerdidas[$i], 'id');
    	$color = $cantidadPerdidas[$i] < 0 ? 'red' :'blue';
    	$totalPerdidaProd = $datosProd['precio_compra']*$cantidadPerdidas[$i];
    	$totalPerdidaDia += $totalPerdidaProd;
    	$idTrab = $idTrabajador[$i];
    	$trabajador = ControladorUsuarios::ctrMostrarUsuarios('id', $idTrab);

  		$tablaProdsPerdidos .= '<tr style="color:'.$color.'"><td style="border-right: 1px solid #666; background-color:white; width:70%"> <i>'.strtoupper(substr(explode(' ',$trabajador['nombre'])[0],0,1)).'. '.ucfirst(explode(' ',$trabajador['nombre'])[1]).'</i> - '.strtoupper($datosProd['descripcion']).'</td><td style="border-right: 1px solid #666; background-color:white; width:10%; text-align:center">'.number_format($cantidadPerdidas[$i], 0, ',', '.').'</td><td style="border-right: 1px solid #666; background-color:white; width:10%; text-align:center">'.number_format($datosProd['precio_compra'], 0, ',', '.').'</td><td style="background-color:white; width:10%; text-align:center"><b>'.number_format($totalPerdidaProd, 0, ',', '.').'</b></td></tr>';
	}
	$tablaProdsPerdidos .= '</table>';
	}

if($totalPerdidaDia == 0){
	$perdidaDia = '';	    	
}else if($totalPerdidaDia < 0){
	$perdidaDia = '<div style="height:3px"><font style="color:red">EL CONTEO REGISTRA PÉRDIDAS POR:<b> $'.number_format($totalPerdidaDia, 0, ',', '.').'.-</b> EN PRODUCTOS</font>';
}else{
 	$perdidaDia = '<div style="height:3px"><font style="color:blue">CONTEO PRODUCTIVO, SE SUMA A STOCK:<b> $'.number_format($totalPerdidaDia, 0, ',', '.').'.-</b> EN PRODUCTOS</font>';
}

$avanceConteo = ModeloProductos::mdlAvanceConteo('estado_'.$sucursal, 'check_stock_'.$sucursal, 'descripcion');
$cantidadProductosContar = ControladorProductos::ctrMostrarProductos('estado_'.$sucursal, 1, 'descripcion');
$totalMonetarioPerdidaMes = ModeloActividadInventario::mdlSumarPerdidasMes(date('Y-m'),$sucursal);
$porcentajeAvanceConteo = number_format(count($avanceConteo)/count($cantidadProductosContar)*100, 2, ',', '.');

$perdidaConteo = $totalMonetarioPerdidaMes['total'] < 0 ? '<font style="color:red">SE HA CONTADO EL <b>'.$porcentajeAvanceConteo.' %</b> DE LOS PRODUCTOS, REGISTRANDO UNA PÉRDIDA GLOBAL DE <b>$'.number_format($totalMonetarioPerdidaMes['total'], 0, ',', '.').'</b> EN PRODUCTOS</font>' : '<br><font style="color:blue">SE HA CONTADO EL <b>'.$porcentajeAvanceConteo.' %</b> DE LOS PRODUCTOS, REGISTRANDO UNA SUMA MONETARIA DE <b>$'.number_format($totalMonetarioPerdidaMes['total'], 0, ',', '.').'</b> EN PRODUCTOS</font>';

// '<h2>CONTEO DE PRODUCTOS</h2>'.
// $tablaProdsPerdidos.
// $perdidaDia.$perdidaConteo.'<br>'.

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//----------------------------------------------------------------------------------------------------------------------------------------
	// INFORME DE PRODUCTOS QUE NO HAN SIDO SURTIDOS (STOCK_PROD_BASE > 0 && STOCK_PROD_SURTIR < 1/3(STOCK_IDEAL))
	//----------------------------------------------------------------------------------------------------------------------------------------
	$productosSurtirConBajoStock = ModeloProductos::mdlSeleccionarTransformablesBajoStock();
	if(count($productosSurtirConBajoStock) == 0){
		$informeProductosSurtir = '';	
		$linkWhatsapp = '';
	}else{
		$informeProductosSurtir = '<br><h4>FALTA SURTIR LOS SIGUIENTES PRODUCTOS</h4>';
  	foreach ($productosSurtirConBajoStock as $key => $value) {
    	$prodBase = ModeloProductos::mdlMostrarProducto('productos', 'id', $value['id_transf']);
    	if($prodBase['stock_'.$sucursal] >= 1){
        	$informeProductosSurtir .= $value['descripcion'].' <i><b>('.$value['sku'].')</b></i><br>';
    	}
  	}
	$msjeWhatsapp = str_replace('</h4>','*%0A',str_replace('<h4>','*',str_replace('</i>','_',str_replace('<i>','_',str_replace('</b>','*',str_replace('<b>','*',str_replace('<br>', '%0A ', $informeProductosSurtir)))))));
		$nroWsp = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_'.$sucursal)['ajuste'];
	$linkWhatsapp = '<br><a href="https://api.whatsapp.com/send?phone='.$nroWsp.'&text='.$msjeWhatsapp.'" target="_blanck">Enviar Whatsapp a '.strtoupper($sucursal).'</a>';
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//----------------------------------------------------------------------------------------------------------------------------------------
	// INFORME DE PRODUCTOS A ABASTECER DESDE BODEGA A LOCAL
	//----------------------------------------------------------------------------------------------------------------------------------------
	$bodega = 'bodega1';
$productosAbastecer = ModeloProductos::mdlAbastecimientoDesdeBodega();
if(count($productosAbastecer) == 0){
	$informeAbastecimientoDesdeBodega = '';
	$tablaAbastecimientoDesdeBodega = '';		
}else{    	
  	$informeAbastecimientoDesdeBodega = '<h4>Abastecimiento desde <b>'.strtoupper($bodega).'</b> a <b>'.strtoupper($sucursal).'</b><h4>';
  	$tablaAbastecimientoDesdeBodega = '<table><tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center"><b>CANT</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:20%; text-align:center"><b>SKU</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:50%; text-align:center"><b>DESCRIPCIÓN</b></td><td style="border-bottom: 1px solid #666; background-color:white; width:20%; text-align:center"><b>UBICACIÓN</b></td></tr>';

    foreach ($productosAbastecer as $key => $value) {
      	$stockAbastecer = $value['stock_ideal_'.$sucursal]-$value['stock_'.$sucursal];
      	$stockSugerido = $value['stock_'.$bodega] >= $stockAbastecer ? $stockAbastecer : $value['stock_'.$bodega];

      	$tablaAbastecimientoDesdeBodega .= '<tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center">'.number_format($stockSugerido,0,',','.').'</td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:20%; text-align:center">'.$value['sku'].'</td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:50%; text-align:left"> '.$value['descripcion'].'</td><td style="border-bottom: 1px solid #666; background-color:white; width:20%; text-align:center">'.$value['zona_'.$bodega].'</td></tr>';
    }
    $tablaAbastecimientoDesdeBodega .= '</table>';
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//----------------------------------------------------------------------------------------------------------------------------------------
	// INFORME DE COMPRAS URGENTES
	//----------------------------------------------------------------------------------------------------------------------------------------
$productosCompraUrgente = ModeloProductos::mdlComprasUrgentes();
if(count($productosCompraUrgente) == 0){
	$informeComprasUrgentes = '';	
}else{    	
    $informeComprasUrgentes = '<font style="color:red"><h4>COMPRAS URGENTES</h4>';
    foreach ($productosCompraUrgente as $key => $value) {
		$stockAbastecer = $value['stock_ideal_'.$bodega]-$value['stock_'.$bodega];
  		$saltoLinea = $key == 0 ? '' : '<br>';
  		$informeComprasUrgentes .= $saltoLinea.'<b>'.$stockAbastecer.'</b> '.$value['descripcion'];
    }
    $informeComprasUrgentes .= '</font>';
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//----------------------------------------------------------------------------------------------------------------------------------------
	// INFORME DE COMPRAS NO URGENTES
	//----------------------------------------------------------------------------------------------------------------------------------------
$productosCompraNoUrgente = ModeloProductos::mdlComprasNoUrgentes();
if(count($productosCompraUrgente) == 0){
	$informeComprasNoUrgentes = '';	
}else{
		$informeComprasNoUrgentes = '<h4>COMPRAS NO URGENTES</h4>';
	foreach ($productosCompraNoUrgente as $key => $value){
		$stockAbastecer = $value['stock_ideal_'.$bodega]-$value['stock_'.$bodega];
  		$saltoLinea = $key == 0 ? '' : '<br>';
		$informeComprasNoUrgentes .= $saltoLinea.'<b>'.$stockAbastecer.'</b> '.$value['descripcion'];
	}
}
$pdfMostrar = '<h4>CONTEO DE PRODUCTOS</h4>'.$tablaProdsPerdidos.$perdidaDia.$perdidaConteo.'<br>'.$informeProductosSurtir.$linkWhatsapp.$informeAbastecimientoDesdeBodega.$tablaAbastecimientoDesdeBodega.$informeComprasUrgentes.$informeComprasNoUrgentes;
/*=============================================
                 TITULO
=============================================*/
$bloque0 = <<<EOF
	$pdfMostrar
EOF;

$pdf->writeHTML($bloque0, false, false, false, false, '');


$pdf->Output('MOVIMIENTOS CUENTA.pdf');

}

}

$historial = new historialCliente();

// $historial -> id = $_GET["id"];
$historial -> mostrarHistorial();


?>